<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** ユーザー管理 */
class UserModel extends Model{

	/**
	 * ﾕｰｻﾞｰcode(登録者)
	 * @var int
	 */
	var $authuser_code;

	/**
	 * 一覧
	 */
	function index(){
		$page_name = "";
		$this->login($page_name);
		if($this->authuser_authority == "system"){
			$this->list_edit();
		}else{
			$this->list_view();
		}
	}

	/**
	 * 一覧
	 */
	function list_view(){
		$this->tpl->assignHtml('title', _TITLE_USER);
		$page_name = "eturan,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "sosiki_sortkey";
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "sosiki_fullname";
				        break;
				    case "002":
					$s_col = "user_id";
				        break;
				    case "003":
					$s_col = "user_name";
				        break;
				    case "004":
					$s_col = "auth_name";
				        break;
				    case "005":
					$s_col = "email_ad";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes(@$_REQUEST[$val])."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}
		$where .= ")";
		
		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT * FROM user_detail".$where.$order, "list");
		
		if( count($list) > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi(count($list), $count, $url, $param);
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, count($list), $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  array_slice($list, $this->nv->list_start, $count));
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		$this->tpl->assignHtml('authuser_code', $this->authuser_code);
		/** set template */
		$this->tpl->assignHtml('user_col', select_code("00016"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('auth_col', select_code("00023"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/list_view.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}


	/**
	 * 編集
	 * 入力
	 */
	function self_edit(){
		$this->tpl->assignHtml('title', _TITLE_USER_INPUT);
		$page_name = "eturan,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['code'] != ""){
			$_SESSION['input']['user_pkey']    = @$_REQUEST['code'];
		}
		if(@$_SESSION['input']['user_pkey'] != $this->authuser_code){
			$this->tpl->assignHtml('error_detail', Error::ErrorView("0009"));
		}else{
			if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re"){
				/** ｴﾗｰ */
				$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
				$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
				/** 入力値 */
				$user_pkey    = @$_SESSION['input']['user_pkey'];
				$sosiki_pkey  = @$_SESSION['input']['sosiki_pkey'];
				$user_id      = @$_SESSION['input']['user_id'];
				$old_user_id  = @$_SESSION['input']['old_user_id'];
				$user_name    = @$_SESSION['input']['user_name'];
				$auth         = @$_SESSION['input']['auth'];
				$email_ad     = @$_SESSION['input']['email_ad'];
				$pass         = @$_SESSION['input']['pass'];
				$kessai       = @$_SESSION['input']['kessai'];
				$user_referer = @$_SESSION['input']['user_referer'];
				/** ｴﾗｰｾｯｼｮﾝ削除 */
				$_SESSION['input']['error_flag'] = false;
				$_SESSION['input']['error_msg']  = "";
			}else{
				$user_pkey = addslashes(@$_REQUEST['code']);
				/** 詳細ﾃﾞｰﾀ */
				$detail = $this->db->dbSelect("select * from \"user\" where user_pkey='".$user_pkey."'", "detail");
				if(count($detail) > 0){
					$sosiki_pkey  = $detail['sosiki_pkey'];
					$user_id      = $detail['user_id'];
					$old_user_id  = $detail['user_id'];
					$user_name    = $detail['user_name'];
					$auth         = $detail['auth'];
					$email_ad     = $detail['email_ad'];
					$pass         = $detail['pass'];
					$kessai       = $detail['kessai'];
				}else{
					$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
				}
				$user_referer = _USER_REFERER;
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('user_pkey',   @$user_pkey);
		$this->tpl->assignHtml('sosiki_pkey', @$sosiki_pkey);
		$this->tpl->assignHtml('user_id',     @$user_id);
		$this->tpl->assignHtml('old_user_id', @$old_user_id);
		$this->tpl->assignHtml('user_name',   @$user_name);
		$this->tpl->assignHtml('auth',        @$auth);
		$this->tpl->assignHtml('email_ad',    @$email_ad);
		$this->tpl->assignHtml('pass',        @$pass);
		$this->tpl->assignHtml('kessai',      @$kessai);
		$this->tpl->assignHtml('user_col',    select_code("00016"));
		$this->tpl->assignHtml('parent',      select_sosiki());
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','self_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/self_input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認
	 */
	function self_edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_USER_INPUT);
		$page_name = "eturan,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['user_pkey']    = @$_REQUEST['user_pkey'];
		$_SESSION['input']['sosiki_pkey']  = @$_REQUEST['sosiki_pkey'];
		$_SESSION['input']['user_id']      = @$_REQUEST['user_id'];
		$_SESSION['input']['old_user_id']  = @$_REQUEST['old_user_id'];
		$_SESSION['input']['user_name']    = @$_REQUEST['user_name'];
		$_SESSION['input']['auth']         = @$_REQUEST['auth'];
		$_SESSION['input']['email_ad']     = @$_REQUEST['email_ad'];
		$_SESSION['input']['pass']         = @$_REQUEST['pass'];
		$_SESSION['input']['kessai']       = @$_REQUEST['kessai'];
		$_SESSION['input']['user_referer'] = @$_REQUEST['user_referer'];

		if(@$_SESSION['input']['user_pkey'] != $this->authuser_code){
			$this->tpl->assignHtml('error_detail', Error::ErrorView("0009"));
		}else{
			/** 入力ﾁｪｯｸ */
			$_SESSION['input']['method'] = "self_edit";
			$this->check();
		}
		/** 出力 */
		$this->tpl->assignHtml('sosiki_pkey', $_SESSION['input']['sosiki_pkey']);
		$this->tpl->assignHtml('user_id',     $_SESSION['input']['user_id']);
		$this->tpl->assignHtml('user_name',   $_SESSION['input']['user_name']);
		$this->tpl->assignHtml('auth',        $_SESSION['input']['auth']);
		$this->tpl->assignHtml('email_ad',    $_SESSION['input']['email_ad']);
		$this->tpl->assignHtml('pass',        $_SESSION['input']['pass']);
		$this->tpl->assignHtml('kessai',      $_SESSION['input']['kessai']);
		$this->tpl->assignHtml('user_col',    select_code("00016"));
		$this->tpl->assignHtml('parent',      select_sosiki());
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','self_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/self_confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function self_edit_done(){
		$page_name = "eturan,sinsei,syonin,alert";
		$this->login($page_name);

		if(@$_SESSION['input']['user_pkey'] != $this->authuser_code){
			$this->tpl->assignHtml('error_detail', Error::ErrorView("0009"));
		}else{
			/** 入力ﾁｪｯｸ */
			$_SESSION['input']['method'] = "self_edit";
			$this->check();
			/** CODE ｴｽｹｰﾌﾟ */
			$user_pkey = addslashes($_SESSION['input']['user_pkey']);
			$where = "user_pkey = ".$user_pkey;

			/** 登録 */
			$fields_values = array(
					"user_name"   => $_SESSION['input']['user_name'],     
					"email_ad"    => $_SESSION['input']['email_ad'],
					"pass"        => $_SESSION['input']['pass'], 
					"kessai"      => $_SESSION['input']['kessai']
					      );
			$this->db->dbUpdate("\"user\"", $fields_values, $where);
		/** 出力 */
			$this->tpl->assignHtml('db_error',  $this->db->error);
		}
		$this->tpl->assignHtml('name',$_SESSION['input']['user_name']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action',"self_edit");
		$this->tpl->assignHtml('code',$user_pkey);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 一覧
	 */
	function list_edit(){
		$this->tpl->assignHtml('title', _TITLE_USER);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "sosiki_sortkey";
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "sosiki_fullname";
				        break;
				    case "002":
					$s_col = "user_id";
				        break;
				    case "003":
					$s_col = "user_name";
				        break;
				    case "004":
					$s_col = "auth_name";
				        break;
				    case "005":
					$s_col = "email_ad";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes(@$_REQUEST[$val])."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}
		$where .= ")";
		
		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT * FROM user_detail".$where.$order, "list");
		
		if( count($list) > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi(count($list), $count, $url, $param);
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, count($list), $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  array_slice($list, $this->nv->list_start, $count));
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('user_col', select_code("00016"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('auth_col', select_code("00023"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/list.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * 新規追加
	 * 入力
	 */
	function reg(){
		$this->tpl->assignHtml('title', _TITLE_USER_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** 入力ﾌｫｰﾑ */
		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re"){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			/** 入力値 */
			$sosiki_pkey  = @$_SESSION['input']['sosiki_pkey'];
			$user_id      = @$_SESSION['input']['user_id'];
			$old_user_id  = @$_SESSION['input']['old_user_id'];
			$user_name    = @$_SESSION['input']['user_name'];
			$auth         = @$_SESSION['input']['auth'];
			$email_ad     = @$_SESSION['input']['email_ad'];
			$pass         = @$_SESSION['input']['pass'];
			$kessai       = @$_SESSION['input']['kessai'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
		}else{
			/** ﾃﾞﾌｫﾙﾄ値 */
			$sosiki_pkey  = "";
			$user_id      = "";
			$old_user_id  = "";
			$user_name    = "";
			$auth         = "";
			$email_ad     = "";
			$pass         = "";
			$kessai       = "";
			$user_referer = _USER_REFERER;
		}
		
		/** 出力 */
		$this->tpl->assignHtml('authority', $this->authuser_authority);

		$this->tpl->assignHtml('sosiki_pkey', $sosiki_pkey);
		$this->tpl->assignHtml('user_id',     $user_id);
		$this->tpl->assignHtml('old_user_id', $old_user_id);
		$this->tpl->assignHtml('user_name',   $user_name);
		$this->tpl->assignHtml('auth',        $auth);
		$this->tpl->assignHtml('email_ad',    $email_ad);
		$this->tpl->assignHtml('pass',        $pass);
		$this->tpl->assignHtml('kessai',      $kessai);
		$this->tpl->assignHtml('user_col',    select_code("00016"));
		$this->tpl->assignHtml('parent',      select_sosiki());
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name', _ACTION_ADD);
		$this->tpl->assignHtml('action_param','reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 確認
	 */
	function reg_conf(){
		$this->tpl->assignHtml('title', _TITLE_USER_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['sosiki_pkey']  = @$_REQUEST['sosiki_pkey'];
		$_SESSION['input']['user_id']      = @$_REQUEST['user_id'];
		$_SESSION['input']['old_user_id']  = @$_REQUEST['old_user_id'];
		$_SESSION['input']['user_name']    = @$_REQUEST['user_name'];
		$_SESSION['input']['auth']         = @$_REQUEST['auth'];
		$_SESSION['input']['email_ad']     = @$_REQUEST['email_ad'];
		$_SESSION['input']['pass']         = @$_REQUEST['pass'];
		$_SESSION['input']['kessai']       = @$_REQUEST['kessai'];
		$_SESSION['input']['user_referer'] = @$_REQUEST['user_referer'];
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "reg";
		$this->check();
		/** 出力 */
		$this->tpl->assignHtml('authority', $this->authuser_authority);

		$this->tpl->assignHtml('sosiki_pkey', $_SESSION['input']['sosiki_pkey']);
		$this->tpl->assignHtml('user_id',     $_SESSION['input']['user_id']);
		$this->tpl->assignHtml('user_name',   $_SESSION['input']['user_name']);
		$this->tpl->assignHtml('auth',        $_SESSION['input']['auth']);
		$this->tpl->assignHtml('email_ad',    $_SESSION['input']['email_ad']);
		$this->tpl->assignHtml('pass',        $_SESSION['input']['pass']);
		$this->tpl->assignHtml('kessai',      $_SESSION['input']['kessai']);
		$this->tpl->assignHtml('user_col',    select_code("00016"));
		$this->tpl->assignHtml('parent',      select_sosiki());
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_ADD);
		$this->tpl->assignHtml('action_param','reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 登録
	 */
	function reg_done(){
		$page_name = "system";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "reg";
		$this->check();
		if(!ereg("　$",$_SESSION['input']['kessai'])){
			$_SESSION['input']['kessai'] .= "　";
		}
		$fields_values = array(
				"sosiki_pkey" => $_SESSION['input']['sosiki_pkey'],     
				"user_id"     => $_SESSION['input']['user_id'],     
				"user_name"   => $_SESSION['input']['user_name'],     
				"auth"        => $_SESSION['input']['auth'],
				"email_ad"    => $_SESSION['input']['email_ad'],
				"pass"        => $_SESSION['input']['pass'], 
				"kessai"      => $_SESSION['input']['kessai']
				      );
		$code = $this->db->dbInsert("\"user\"", $fields_values);

		$mail_tpl = new Template;
		$email = new Sendmail;
		$item = $_SESSION['input'];
		$email_ad = explode("\n",$item['email_ad']);
		for($i=0; $i<count($email_ad); $i++){
			$item['email_ad'] = $email_ad[$i];
			
			$mail_tpl->assignHtml('item',$item);
			$mail_tpl->assignHtml('user_col',    select_code("00016"));
			$mail_tpl->assignHtml('auth_col',    select_code("00023"));

			$body = $mail_tpl->fetchHtml('mail/user_reg.html');
			$subject = "【情報資産管理システム】ユーザー登録完了のご案内";

			$email->email($email_ad[$i], _ADMIN_EMAIL, $subject, $body);
		}

		/** 出力 */
		$this->tpl->assignHtml('authority', $this->authuser_authority);

		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('name',$_SESSION['input']['user_name']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action',"edit");
		$this->tpl->assignHtml('code',$code);
		$this->tpl->assignHtml('action_name',_ACTION_ADD);

		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 編集
	 * 入力
	 */
	function edit(){
		$this->tpl->assignHtml('title', _TITLE_USER_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re"){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			/** 入力値 */
			$user_pkey    = @$_SESSION['input']['user_pkey'];
			$sosiki_pkey  = @$_SESSION['input']['sosiki_pkey'];
			$user_id      = @$_SESSION['input']['user_id'];
			$old_user_id  = @$_SESSION['input']['old_user_id'];
			$user_name    = @$_SESSION['input']['user_name'];
			$auth         = @$_SESSION['input']['auth'];
			$email_ad     = @$_SESSION['input']['email_ad'];
			$pass         = @$_SESSION['input']['pass'];
			$kessai       = @$_SESSION['input']['kessai'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
		}else{
			$user_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from \"user\" where user_pkey='".$user_pkey."'", "detail");
			if(count($detail) > 0){
				$sosiki_pkey  = $detail['sosiki_pkey'];
				$user_id      = $detail['user_id'];
				$old_user_id  = $detail['user_id'];
				$user_name    = $detail['user_name'];
				$auth         = $detail['auth'];
				$email_ad     = $detail['email_ad'];
				$pass         = $detail['pass'];
				$kessai       = $detail['kessai'];
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;
		}
		/** 出力 */
		$this->tpl->assignHtml('authority', $this->authuser_authority);

		$this->tpl->assignHtml('user_pkey',   $user_pkey);
		$this->tpl->assignHtml('sosiki_pkey', $sosiki_pkey);
		$this->tpl->assignHtml('user_id',     $user_id);
		$this->tpl->assignHtml('old_user_id', $old_user_id);
		$this->tpl->assignHtml('user_name',   $user_name);
		$this->tpl->assignHtml('auth',        $auth);
		$this->tpl->assignHtml('email_ad',    $email_ad);
		$this->tpl->assignHtml('pass',        $pass);
		$this->tpl->assignHtml('kessai',      $kessai);
		$this->tpl->assignHtml('user_col',    select_code("00016"));
		$this->tpl->assignHtml('parent',      select_sosiki());
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認
	 */
	function edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_USER);
		$this->tpl->assignHtml('title', _TITLE_USER_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['user_pkey']    = @$_REQUEST['user_pkey'];
		$_SESSION['input']['sosiki_pkey']  = @$_REQUEST['sosiki_pkey'];
		$_SESSION['input']['user_id']      = @$_REQUEST['user_id'];
		$_SESSION['input']['old_user_id']  = @$_REQUEST['old_user_id'];
		$_SESSION['input']['user_name']    = @$_REQUEST['user_name'];
		$_SESSION['input']['auth']         = @$_REQUEST['auth'];
		$_SESSION['input']['email_ad']     = @$_REQUEST['email_ad'];
		$_SESSION['input']['pass']         = @$_REQUEST['pass'];
		$_SESSION['input']['kessai']       = @$_REQUEST['kessai'];
		$_SESSION['input']['user_referer'] = @$_REQUEST['user_referer'];
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** 出力 */
		$this->tpl->assignHtml('authority', $this->authuser_authority);

		$this->tpl->assignHtml('sosiki_pkey', $_SESSION['input']['sosiki_pkey']);
		$this->tpl->assignHtml('user_id',     $_SESSION['input']['user_id']);
		$this->tpl->assignHtml('user_name',   $_SESSION['input']['user_name']);
		$this->tpl->assignHtml('auth',        $_SESSION['input']['auth']);
		$this->tpl->assignHtml('email_ad',    $_SESSION['input']['email_ad']);
		$this->tpl->assignHtml('pass',        $_SESSION['input']['pass']);
		$this->tpl->assignHtml('kessai',      $_SESSION['input']['kessai']);
		$this->tpl->assignHtml('user_col',    select_code("00016"));
		$this->tpl->assignHtml('parent',      select_sosiki());
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function edit_done(){
		$page_name = "system";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */
		$user_pkey = addslashes($_SESSION['input']['user_pkey']);
		$where = "user_pkey = ".$user_pkey;

		if(!ereg("　$",$_SESSION['input']['kessai'])){
			$_SESSION['input']['kessai'] .= "　";
		}
		/** 登録 */
		$fields_values = array(
				"sosiki_pkey" => $_SESSION['input']['sosiki_pkey'],     
				"user_id"     => $_SESSION['input']['user_id'],     
				"user_name"   => $_SESSION['input']['user_name'],     
				"auth"        => $_SESSION['input']['auth'],
				"email_ad"    => $_SESSION['input']['email_ad'],
				"pass"        => $_SESSION['input']['pass'], 
				"kessai"      => $_SESSION['input']['kessai']
				      );
		$this->db->dbUpdate("\"user\"", $fields_values, $where);
		/** 出力 */
		$this->tpl->assignHtml('authority', $this->authuser_authority);

		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('name',$_SESSION['input']['user_name']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action',"edit");
		$this->tpl->assignHtml('code',$user_pkey);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 削除
	 * 確認
	 */
	function del(){
		$this->tpl->assignHtml('title', _TITLE_USER_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$user_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['user_pkey']    = $user_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		if($user_pkey == $this->authuser_code){
			/** LOGIN ユーザーは削除させない */
			$this->tpl->assignHtml('error_detail', _ERR_LOGIN_DEL);
		}else{
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from \"user\" where user_pkey='".$user_pkey."'", "detail");
			if(count($detail) > 0){
				$sosiki_pkey  = $detail['sosiki_pkey'];
				$user_id      = $detail['user_id'];
				$old_user_id  = $detail['user_id'];
				$user_name    = $detail['user_name'];
				$auth         = $detail['auth'];
				$email_ad     = $detail['email_ad'];
				$pass         = $detail['pass'];
				$kessai       = $detail['kessai'];
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('authority', $this->authuser_authority);

		$this->tpl->assignHtml('user_pkey',   @$user_pkey);
		$this->tpl->assignHtml('sosiki_pkey', @$sosiki_pkey);
		$this->tpl->assignHtml('user_id',     @$user_id);
		$this->tpl->assignHtml('old_user_id', @$old_user_id);
		$this->tpl->assignHtml('user_name',   @$user_name);
		$this->tpl->assignHtml('auth',        @$auth);
		$this->tpl->assignHtml('email_ad',    @$email_ad);
		$this->tpl->assignHtml('pass',        @$pass);
		$this->tpl->assignHtml('kessai',      @$kessai);
		$this->tpl->assignHtml('user_col',    select_code("00016"));
		$this->tpl->assignHtml('parent',      select_sosiki());
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('user/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		/** CODE ｴｽｹｰﾌﾟ */
		$user_pkey = addslashes($_SESSION['input']['user_pkey']);
		$where = "user_pkey = ".$user_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select user_name from \"user\" where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['user_name']);
			/** 削除 */
			$this->db->dbDelete("\"user\"", $where);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('authority', $this->authuser_authority);

		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check(){
		
		#入力チェック
		$cci = new CheckItem;
		#必須項目
		$error_name_array = select_code("00016");

		$col_name = array(
				"user_id"=>$error_name_array['002'],
				"user_name"=>$error_name_array['003'],
				"email_ad"=>_USER_EMAIL,
				"pass"=>_USER_PASS,
				"kessai"=>_COL_KESSAI
				);
		$cci->checkItemNon($col_name);
		$cci->checkAlphaNumericPlus(array("user_id"=>$error_name_array['002']));
		$cci->checkItemEmailArray(array("email_ad"=>_USER_EMAIL));
		$sql = "select * from \"user\" where user_id = '".$_SESSION['input']['user_id']."'";
		if($_SESSION['input']['method'] == "reg"){
			$cci->checkItemRepeatedAdd($sql, $error_name_array['002']);
		}else{
			$cci->checkItemRepeatedEdit($sql, $error_name_array['002'], $_SESSION['input']['old_user_id'], "user_id");
		}
		
		$email_ad_array = explode("\r",@$_SESSION['input']['email_ad']);
		for($i=0; $i<count($email_ad_array); $i++){
			$email_ad = explode("@",@$email_ad_array[$i]);
			if(count($email_ad)>=2){
				if(!in_array($email_ad[1],select_code("00027")) and _ERROR_0254){
					$cci->checkErrorCode("0254");
				}
			}
		}

		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
		}
	}
	
	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "system";
		$this->login($page_name);
		
		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			array_pop($full);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sosiki_pkey in (".implode(",",$sosiki_array).")";

		}

		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=user.csv");

		$list = $this->db->dbSelect("SELECT * FROM \"user_detail\"".$_SESSION['csv'], "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('parent', select_sosiki());
		print mb_convert_encoding($this->tpl->fetchHtml('user/csv.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * プリント出力
	 */
	function prt(){
		$page_name = "system";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_USER);
		
		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			array_pop($full);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sosiki_pkey in (".implode(",",$sosiki_array).")";

		}

		$list = $this->db->dbSelect("SELECT * FROM \"user\"".$_SESSION['csv'], "list");

		$this->tpl->assignHtml('user_col',    select_code("00016"));
		$this->tpl->assignHtml('parent',      select_sosiki());
		$this->tpl->assignHtml('auth_col',    select_code("00023"));
		$this->tpl->assignHtml('list_view',$list);
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('user/print.html'));
		$this->tpl->outputHtml('print_list.html');

	}
}

?>