<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** 組織管理 */
class SosikiModel extends Model{

	/**
	 * 一覧
	 */
	function index(){
		$page_name = "";
		$this->login($page_name);
		if($this->authuser_authority == "system"){
			$this->list_edit();
		}else{
			$this->list_view();
		}
	}

	/**
	 * 一覧編集
	 */
	function list_edit(){
		$this->tpl->assignHtml('title', _TITLE_SOSIKI);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "sosiki_sortkey";
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		$search_max = 2;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "s_syozoku_fullname";
				        break;
				    case "002":
					$s_col = "syozoku_name";
				        break;
				    case "003":
					$s_col = "yukou_name";
				        break;
				    case "004":
					$s_col = "sosiki_sortkey";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes(@$_REQUEST[$val])."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}
		
		$where .= ")";
		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";
		
		/** 一覧 */
		$list = $this->db->dbSelect("SELECT * FROM sosiki_detail".$where.$order, "list");
		
		if( count($list) > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi(count($list), $count, $url, $param);
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, count($list), $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  array_slice($list, $this->nv->list_start, $count));
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('where', $where);
		$this->tpl->assignHtml('order', $order);
		$this->tpl->assignHtml('sosiki_col', select_code("00017"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('sosiki/list_edit.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * 一覧表示
	 */
	function list_view(){
		$this->tpl->assignHtml('title', _TITLE_SOSIKI);
		$page_name = "eturan,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "sosiki_sortkey";
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		$search_max = 2;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "s_syozoku_name";
				        break;
				    case "002":
					$s_col = "syozoku_name";
				        break;
				    case "003":
					$s_col = "yukou_name";
				        break;
				    case "004":
					$s_col = "sosiki_sortkey";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes(@$_REQUEST[$val])."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}
		
		$where .= ")";
		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT * FROM sosiki_detail".$where.$order, "list");
		
		if( count($list) > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi(count($list), $count, $url, $param);
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, count($list), $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  array_slice($list, $this->nv->list_start, $count));
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** set template */
		$this->tpl->assignHtml('sosiki_col', select_code("00017"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('sosiki/list_view.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	function sosiki_edit(){
		$page_name = "system";
		$this->login($page_name);
		
		$_SESSION['input'] = $_REQUEST;
		$full_key = full_sosiki_key($_SESSION['input']['pare']);
		#入力チェック
		$cci = new CheckItem;
		#必須項目
		$error_name_array = select_code("00017");
		
		$cci->CheckMoveCate(array('name'=>$error_name_array['001']),@$_SESSION['input']['key'],$full_key);
		if(@$_SESSION['input']['name'] == ""){
			$cci->CheckCateDel(array('key'=>$error_name_array['002']));
		}
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
		if($cci->error_flag == true){
			$this->tpl->assignHtml('error_msg',  $cci->error_msg);
			$error = '{"error":"'.addslashes(ereg_replace("\n","",$this->tpl->fetchHtml('sosiki/sosiki_error.html'))).'"}';
			print "$error";
		}else{
			if(@$_REQUEST['name'] == ""){
				$this->del($_REQUEST['key']);
				$this->sosiki_path($_REQUEST['key']);
			}elseif(@$_REQUEST['name'] != ""){
				$sort = ereg_replace("[^0-9]","",@$_REQUEST['sort']);
				if($sort == ""){
					$sort = 32767;
				}
				$this->edit($_REQUEST['key'],$_REQUEST['pare'],$_REQUEST['name'],$_REQUEST['yukou'],$sort);
				$this->sosiki_path($_REQUEST['key']);
			}
			$where = @$_REQUEST['where'];
			$order = @$_REQUEST['order'];
			$param = @$_REQUEST['param'];
			$param_search = @$_REQUEST['param_search'];
			$this->table_view($where,$order,$param,$param_search);
		}
	}

	function sosiki_del(){
		$page_name = "system";
		$this->login($page_name);
		
		$_SESSION['input'] = $_REQUEST;
		$full_key = full_sosiki_key($_SESSION['input']['pare']);
		#入力チェック
		$cci = new CheckItem;
		#必須項目
		$error_name_array = select_code("00017");
		
		$cci->CheckCateDel(array('key'=>$error_name_array['002']));
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
		if($cci->error_flag == true){
			$this->tpl->assignHtml('error_msg',  $cci->error_msg);
			$error = '{"error":"'.addslashes(ereg_replace("\n","",$this->tpl->fetchHtml('sosiki/sosiki_error.html'))).'"}';
			print "$error";
		}else{
			$this->del($_REQUEST['key']);
			$this->sosiki_path($_REQUEST['key']);

			$where = @$_REQUEST['where'];
			$order = @$_REQUEST['order'];
			$param = @$_REQUEST['param'];
			$param_search = @$_REQUEST['param_search'];
			$this->table_view($where,$order,$param,$param_search);
		}
	}

	function sosiki_reg(){
		$page_name = "system";
		$this->login($page_name);

		$_SESSION['input'] = $_REQUEST;
		#入力チェック
		$cci = new CheckItem;
		#必須項目
		$error_name_array = select_code("00017");
		
		$cci->checkItemNon(array('name'=>$error_name_array['002']));
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
		if($cci->error_flag == true){
			$this->tpl->assignHtml('error_msg',  $cci->error_msg);
			$error = '{"error":"'.addslashes(ereg_replace("\n","",$this->tpl->fetchHtml('sosiki/sosiki_error.html'))).'"}';
			print "$error";
		}else{
			$sort = ereg_replace("[^0-9]","",@$_REQUEST['sort']);
			if($sort == ""){
				$sort = 32767;
			}
			$code = $this->reg($_REQUEST['pare'],$_REQUEST['name'],$_REQUEST['yukou'],$sort);
			$this->sosiki_path($code);
			$where = @$_REQUEST['where'];
			$order = @$_REQUEST['order'];
			$param = @$_REQUEST['param'];
			$param_search = @$_REQUEST['param_search'];
			$this->table_view($where,$order,$param,$param_search);
		}
	}

	/**
	 * 新規追加
	 * 入力
	 */
	function reg($pare,$name,$yukou,$sort){
		$fields_values = array(
				"sosiki_onpkey" => $pare,
				"syozoku_name"  => $name,
				"yukou"         => $yukou,
				"sosiki_sortkey"=> $sort
				      );
		$code = $this->db->dbInsert("sosiki", $fields_values);
		return $code;
	}

	/**
	 * 編集
	 */
	function edit($key,$pare,$name,$yukou,$sort){
		$where = "sosiki_pkey = ".$key;
		$fields_values = array(
				"sosiki_onpkey" => $pare,
				"syozoku_name"  => $name,
				"yukou"         => $yukou,
				"sosiki_sortkey"=> $sort
				      );
		$this->db->dbUpdate("sosiki", $fields_values, $where);
	}

	/**
	 * 削除
	 */
	function del($key){
		$where = "sosiki_pkey = ".$key;
		$this->db->dbDelete("sosiki", $where);
	}
	
	/**
	 * 表示
	 */
	function table_view($where,$order,$param,$param_search){
		$table = '{"data":"ok","error":"non"}';
		print "$table";

	}
	
	/**
	 * ソート
	function sort(){
		$list = $this->db->dbSelect("SELECT * FROM \"sosiki\" order by sosiki_sortkey", "list");

		for($i=0; $i<count($list); $i++){
			$sort_key = ($i+1)*10;
			$where = "sosiki_pkey = ".$list[$i]['sosiki_pkey'];
			$fields_values = array(
					"sosiki_sortkey"     => $sort_key
					      );
			$this->db->dbUpdate("sosiki", $fields_values, $where);
		}
	}
	 */
	
	/**
	 * 所属名（フルパス）、上位組織、配下組織
	 */
	function sosiki_path($sosiki_pkey){
		#配下所属取得
		$child_sosiki_array = child_sosiki_array($sosiki_pkey);
		#配下所属＋自所属
		array_unshift($child_sosiki_array,$sosiki_pkey);
		#配下所属＋自所属の「syozoku_fullname」書き換え
		for($i=0; $i<count($child_sosiki_array); $i++){
			$fullname = implode("/",full_sosiki_name($child_sosiki_array[$i]));
			
			$where = "sosiki_pkey = ".$child_sosiki_array[$i];
			$fields_values = array(
					"syozoku_fullname"   => $fullname
					      );
			$this->db->dbUpdate("sosiki", $fields_values, $where);
		}
		
		#「child_sosiki」生成
		$list = $this->db->dbSelect("SELECT * FROM \"sosiki\" order by sosiki_sortkey", "list");
		$child_sosiki = array();
		for($i=0; $i<count($list); $i++){
			$parent_sosiki_array = parent_sosiki_array($list[$i]['sosiki_pkey']);
			$parent_sosiki = implode(",",$parent_sosiki_array);
			$child_sosiki_array = child_sosiki_array($list[$i]['sosiki_pkey']);
			$child_sosiki = implode(",",$child_sosiki_array);
			$sosiki_path_detail = $this->db->dbSelect("SELECT * FROM sosiki_path where sosiki_pkey = ".$list[$i]['sosiki_pkey'], "detail");
			if(count($sosiki_path_detail) > 0){
				$where_sosiki = "sosiki_pkey = ".$list[$i]['sosiki_pkey'];
				$fields_values = array(
						"parent_sosiki"  => $parent_sosiki,
						"child_sosiki"   => $child_sosiki
						      );
				$this->db->dbUpdate("sosiki_path", $fields_values, $where_sosiki);
			}else{
				$insert_values = array(
						"sosiki_pkey"  => $list[$i]['sosiki_pkey'],
						"parent_sosiki"  => $parent_sosiki,
						"child_sosiki"   => $child_sosiki
						      );
				$this->db->dbInsert("sosiki_path", $insert_values);
			}
		}
		
	}
	
	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "system";
		$this->login($page_name);
		
		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == "system"){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sosiki_pkey in (".implode(",",$sosiki_array).")";
		}

		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=sosiki.csv");

		$list = $this->db->dbSelect("SELECT * FROM \"sosiki_detail\"".$_SESSION['csv'], "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		print mb_convert_encoding($this->tpl->fetchHtml('sosiki/csv.html'),"SJIS-win","UTF-8");
	}
}
?>