<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

class SogoCheckModel extends Model{

	function sogo_start(){
		$where_date = "invbunrui = 6";
		$fields_values = array(
				"invstart"   => date("Y/m/d H:i:s"),
				"invend"     => null
		);
		$this->db->dbUpdate("inventorydate", $fields_values, $where_date);
		//バッチログセット
		$this->set_bat_log(7);
	}

	function sogo_end(){
		$where_date = "invbunrui = 6";
		$fields_values = array(
				"invend"     => date("Y/m/d H:i:s")
		);
		$this->db->dbUpdate("inventorydate", $fields_values, $where_date);
		//バッチログセット
		$this->set_bat_log(123);
		//夜間バッチ異常終了メール送信
		$this->error_mail_send();

	}
	
	function table_copy(){
		$table_name = array(
				"hard_detail",
				"soft_detail",
				"licence_detail",
				"licencelist_detail",
				"inventory_detail",
				"sosiki_detail",
				"hard",
				"soft",
				"licence",
				"licencelist",
				"licencelistprogram",
				"licencelistprogram_down",
				"inventory",
				"inventorysoft"
				);
		for($i=0; $i< count($table_name); $i++){
// 			$sql_drop = "drop table tmp_".$table_name[$i];
// 			$this->db->dbQuery($sql_drop);
// 			$sql_create = "create table tmp_".$table_name[$i]." as select * from ".$table_name[$i];
// 			$this->db->dbQuery($sql_create);
// table copy doing commnet
print "executing_truncate_table_".$table_name[$i]."_".$i."\n";
			// tmp_～のTrucate Table 実行
			$sql_truncate = "";
			$sql_truncate = "truncate table tmp_".$table_name[$i];
			$this->db->dbQuery($sql_truncate);
print "executing_insert_table_".$table_name[$i]."_".$i."\n";
			// tmp_～のInsert Table 実行
			$sql_insert_into = "";
			$sql_insert_into = "insert into tmp_".$table_name[$i]." select * from ".$table_name[$i];
			$this->db->dbQuery($sql_insert_into);

		}
		//バッチログセット
		$this->set_bat_log(8);
	}

	function sogo_tmp_del(){
		$sql_truncate = "";
		$sql_truncate = "truncate table sogocheck_tmp";
		$this->db->dbQuery($sql_truncate);
		$sql_truncate = "truncate table inventorysoft_ext";
		$this->db->dbQuery($sql_truncate);
//		$where_sogo = "sogochk_type = 1 or sogochk_type = 2";
//		$this->db->dbDelete("sogocheck_tmp", $where_sogo);
//		$this->db->dbDelete("inventorysoft_ext","1=1");
		//バッチログセット
		$this->set_bat_log(9);
	}

	function sogo_replace($param){
		#発生開始時間コピー
		$col_array = array(
			"err_pkey",
			"inv_list",
			"inv_detail",
			"hard_hardno",
			"soft_hardno",
			"soft_licenceno",
			"soft_program",
			"licence_licenceno",
			"licence_program",
			"licencelist_program",
			"sosiki1",
			"sosiki2",
			"spt_val1",
			"spt_val2",
			"spt_val3",
			"spt_val4",
			"spt_val5",
			"mail_val1",
			"mail_val2",
			"mail_val3",
			"mail_val4",
			"mail_val5",
			"mail_val6",
			"mail_val7"
		);
		$limit = " limit ".$param[1]." offset ".$param[0];
		$list = $this->db->dbSelect("select * from sogocheck_tmp order by sogochk_pkey".$limit, "list");
		if(count($list) > 0){
			for($i=0; $i<count($list); $i++){
print "start_time_".$list[$i]['sogochk_pkey']."\n";
				$where_array = array();
				foreach($col_array as $value){
					if(is_null($list[$i][$value])){
						$where_array[] = $value." is null";
					}elseif($value == "sosiki1" or  $value == "sosiki2"){
						$where_array[] = $value."=".$list[$i][$value];
					}elseif($value != "sosiki1" and  $value != "sosiki2"){
						$where_array[] = $value."='".addslashes($list[$i][$value])."'";
					}
				}
				$where_comp = " where ".implode(" and ",$where_array);
				$list_comp = $this->db->dbSelect("select * from sogocheck".$where_comp, "list");
				if(count($list_comp) > 0){
					$where_start_date = "sogochk_pkey = ".$list[$i]['sogochk_pkey'];
					$fields_values = array(
							"start_date"   => $list_comp[0]['start_date']
					);
					$this->db->dbUpdate("sogocheck_tmp", $fields_values, $where_start_date);
				}
			}
		}
		$pkey = $param[0] / 10000 + 83;
		//バッチログセット
		$this->set_bat_log($pkey);
	}
		
	function sogo_view($param){
		
		if($param[0] == 0){
			#一時保管データ転送
			$sql_truncate = "";
			$sql_truncate = "truncate table sogocheck";
			$this->db->dbQuery($sql_truncate);
	//		$where_sogo = "sogochk_type = 1 or sogochk_type = 2";
	//		$this->db->dbDelete("sogocheck", $where_sogo);
			$sql_replace = "insert into sogocheck select * from sogocheck_tmp";
			$this->db->dbQuery($sql_replace);
		
			$sql_truncate = "";
			$sql_truncate = "truncate table sogo_view";
			$this->db->dbQuery($sql_truncate);
	//		$where_view = "1=1";
	//		$this->db->dbDelete("sogo_view", $where_view);
		}
		#齟齬表示用テーブル作成
		$limit = " limit ".$param[1]." offset ".$param[0];
		$list = $this->db->dbSelect("select * from sogocheck order by sogochk_pkey".$limit, "list");
		#メッセージテンプレート読み出し
		$sogo_tpl_array = $this->db->dbSelect("select * from sogo_msg", "list");
		if(count($sogo_tpl_array) > 0){
			foreach($sogo_tpl_array as $value){
				$sogo_tpl[$value['sogo_pkey']] = $value;
			}
		}
		if(count($list) > 0){
			$this->fields_values = array();
			for($i=0; $i<count($list); $i++){
print "cr_sogo_view_".$list[$i]['sogochk_pkey']."\n";
				if(!is_null($list[$i]['sosiki1'])){
					$sosiki_datail1 = $this->db->dbSelect("select * from sosiki where sosiki_pkey = ".$list[$i]['sosiki1'], "detail");
				}else{
					$sosiki_datail1 = array();
				}
				if(!is_null($list[$i]['sosiki2'])){
					$sosiki_datail2 = $this->db->dbSelect("select * from sosiki where sosiki_pkey = ".$list[$i]['sosiki2'], "detail");
				}else{
					$sosiki_datail2 = array();
				}
				#sosiki_sortkey
				if(!is_null(@$sosiki_datail1['sosiki_sortkey'])){
					$sosiki_sortkey = $sosiki_datail1['sosiki_sortkey'];
				}elseif(is_null(@$sosiki_datail1['sosiki_sortkey']) and !is_null(@$sosiki_datail2['sosiki_sortkey'])){
					$sosiki_sortkey = $sosiki_datail2['sosiki_sortkey'];
				}else{
					$sosiki_sortkey = null;
				}
				#sosiki_fullname
				if(!is_null(@$sosiki_datail1['syozoku_fullname']) and !is_null(@$sosiki_datail2['syozoku_fullname'])){
					$sosiki_fullname = $sosiki_datail1['syozoku_fullname']."\n".$sosiki_datail2['syozoku_fullname'];
				}elseif(!is_null(@$sosiki_datail1['syozoku_fullname']) and is_null(@$sosiki_datail2['syozoku_fullname'])){
					$sosiki_fullname = $sosiki_datail1['syozoku_fullname'];
				}elseif(is_null(@$sosiki_datail1['syozoku_fullname']) and !is_null(@$sosiki_datail2['syozoku_fullname'])){
					$sosiki_fullname = $sosiki_datail2['syozoku_fullname'];
				}else{
					$sosiki_fullname = null;
				}
				#message
				for($j=1; $j<=7; $j++){
					$col_name = "msg_val".$j;
					$str[$j-1] = $list[$i][$col_name];
				}
				$message = vsprintf(@$sogo_tpl[$list[$i]['err_pkey']]['sogo_msg'],$str);
				#support
				for($j=1; $j<=5; $j++){
					$col_name = "spt_val".$j;
					$str[$j-1] = $list[$i][$col_name];
				}
				$support = vsprintf(@$sogo_tpl[$list[$i]['err_pkey']]['sogo_spt'],$str);
				#inventory
				$inventory_array = array();
				if(!is_null(@$list[$i]['inv_list'])){
					$inventory_array[] = '<a href="inventory.php?search_col1=007&search_value1='.$list[$i]['inv_list'].'&search_comp1=002&search_cd1=001&search_sosiki=on&search_haiki=on">一覧</a>';
				}
				if(!is_null(@$list[$i]['inv_detail'])){
					$inventory_array[] = '<a href="inventory.php?action=detail&code='.$list[$i]['inv_detail'].'">詳細</a>';
				}
				if(count($inventory_array) > 0){
					$inventory = implode("\n",$inventory_array);
				}else{
					$inventory = "";
				}
				#hardware
				$hardware = "";
				if(!is_null(@$list[$i]['hard_hardno'])){
					$hardware = '<a href="hardware.php?search_col1=002&search_value1='.$list[$i]['hard_hardno'].'&search_comp1=002&search_cd1=001&search_haiki=on">'.$list[$i]['hard_hardno'].'</a>';
				}
				#software
				$software_array = array();
				if(!is_null(@$list[$i]['soft_hardno'])){
					$software_array[] = 'ハードウェア管理番号：
					<a href="software.php?search_col1=002&search_value1='.$list[$i]['soft_hardno'].'&search_comp1=002&search_cd1=001&search_sosiki=on&search_haiki=on&search_hard_haiki=on">'.$list[$i]['soft_hardno'].'</a>';
				}
				if(!is_null(@$list[$i]['soft_licenceno'])){
					$software_array[] = 'ライセンス管理番号：
					<a href="software.php?search_col1=004&search_value1='.$list[$i]['soft_licenceno'].'&search_comp1=002&search_cd1=001&search_sosiki=on&search_haiki=on&search_hard_haiki=on">'.$list[$i]['soft_licenceno'].'</a>';
				}
				if(count($software_array) > 0){
					$software = implode("\n\n",$software_array);
				}else{
					$software = "";
				}
				#licence
				$licence_array = array();
				if(!is_null(@$list[$i]['licence_licenceno'])){
					$licence_array[] = '<a href="license.php?search_col1=002&search_value1='.$list[$i]['licence_licenceno'].'&search_comp1=002&search_cd1=001&search_haiki=on">'.$list[$i]['licence_licenceno'].'</a>';
				}
				if(!is_null(@$list[$i]['licence_program'])){
					$licence_array[] = 'プログラムの追加と削除での表示：
					<a href="license.php?search_col1=019&search_value1='.$list[$i]['licence_program'].'&search_comp1=002&search_cd1=001&search_haiki=on">'.$list[$i]['licence_program'].'</a>';
				}
				if(count($licence_array) > 0){
					$licence = implode("\n\n",$licence_array);
				}else{
					$licence = "";
				}
				#licence_list
				$licence_list = "";
				if(!is_null(@$list[$i]['licencelist_program'])){
					$licence_list = '<a href="license_list.php?search_col1=003&search_value1='.$list[$i]['licencelist_program'].'&search_comp1=002&search_cd1=001">'.$list[$i]['licencelist_program'].'</a>';
				}
				
				$this->fields_values[] = array(
								$list[$i]['sogochk_pkey'],
								$sosiki_sortkey,
								$sosiki_fullname,
								$list[$i]['check_date'],
								$list[$i]['err_pkey'],
								$inventory,
								$hardware,
								$software,
								$licence,
								$licence_list,
								$message,
								$support,
								$list[$i]['sosiki1'], 
								$list[$i]['sosiki2']
							);
			}
			if(count(@$this->fields_values) > 1){
				$this->db->dbPrepare("INSERT INTO sogo_view (sogochk_pkey,sosiki_sortkey,sosiki_fullname,check_date,err_pkey,inventory,hardware,software,licence,licence_list,message,support,sosiki_pkey1,sosiki_pkey2) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
				unset($this->fields_values);
			}
		}
		$pkey = $param[0] / 10000 + 103;
		//バッチログセット
		$this->set_bat_log($pkey);
	}

	function inv_check_ready(){
		//チェックデータ抽出
		$allcheck_date = $this->db->dbSelect("select * from inventorydate where invbunrui = 1", "detail");
		$list = $this->db->dbSelect("select * from inventory_detail where collectsource = 'LanScopeツール' and invtraprecvdate > '".$allcheck_date['invend']."'", "list");
		for($i=0; $i<count($list); $i++){
			if($list[$i]['hardwareno'] != ""){
				$kanrino_in_array[] = $list[$i]['hardwareno'];
			}
		}
		if(count(@$kanrino_in_array) > 0){
			$kanrino_in = " in('".implode("','",$kanrino_in_array)."')";
			$where_sogo = "sogochk_type = 2 and settei3".$kanrino_in;
			$this->db->dbDelete("sogocheck", $where_sogo);
		}
		$this->inv_check($list);
		if(count(@$this->fields_values) > 1){
			$this->db->dbPrepare("INSERT INTO sogocheck_tmp (sogochk_type,err_pkey,inv_list,inv_detail,hard_hardno,soft_hardno,soft_licenceno,soft_program,licence_licenceno,licence_program,licencelist_program,sosiki1,sosiki2,sysyem_user,start_date,check_date,msg_val1,msg_val2,msg_val3,msg_val4,msg_val5,msg_val6,msg_val7,spt_val1,spt_val2,spt_val3,spt_val4,spt_val5,mail_val1,mail_val2,mail_val3,mail_val4,mail_val5,mail_val6,mail_val7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
			unset($this->fields_values);
		}
	}

	function sogo_invall(){
		$list = $this->db->dbSelect("select * from tmp_inventory_detail", "list");
		$this->invall_check($list);
		unset($list);
		if(count(@$this->fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO sogocheck_tmp (sogochk_type,err_pkey,inv_list,inv_detail,hard_hardno,soft_hardno,soft_licenceno,soft_program,licence_licenceno,licence_program,licencelist_program,sosiki1,sosiki2,sysyem_user,start_date,check_date,msg_val1,msg_val2,msg_val3,msg_val4,msg_val5,msg_val6,msg_val7,spt_val1,spt_val2,spt_val3,spt_val4,spt_val5,mail_val1,mail_val2,mail_val3,mail_val4,mail_val5,mail_val6,mail_val7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
			unset($this->fields_values);
		}
		//バッチログセット
		$this->set_bat_log(10);
	}

	function sogo_inv($param){
		$limit = " limit ".$param[1]." offset ".$param[0];
		$list = $this->db->dbSelect("select * from tmp_inventory_detail order by inventory_pkey".$limit, "list");
		unset($this->inv_fields_values);
		$this->inv_check($list);
		unset($list);
		if(count(@$this->fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO sogocheck_tmp (sogochk_type,err_pkey,inv_list,inv_detail,hard_hardno,soft_hardno,soft_licenceno,soft_program,licence_licenceno,licence_program,licencelist_program,sosiki1,sosiki2,sysyem_user,start_date,check_date,msg_val1,msg_val2,msg_val3,msg_val4,msg_val5,msg_val6,msg_val7,spt_val1,spt_val2,spt_val3,spt_val4,spt_val5,mail_val1,mail_val2,mail_val3,mail_val4,mail_val5,mail_val6,mail_val7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
			unset($this->fields_values);
		}
print "sogo_end ".$param[0]."\n";
		if(count(@$this->inv_fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO inventorysoft_ext (insapno,inv_soft_reg,inv_soft_exempt) VALUES (?,?,?)", $this->inv_fields_values);
			unset($this->inv_fields_values);
		}
print "ext_end ".$param[0]."\n";
		$pkey = $param[0] / 2000 + 11;
		//バッチログセット
		$this->set_bat_log($pkey);
	}

	function sogo_licencelist(){
		$licence_list = $this->db->dbSelect("select * from tmp_licencelist_detail where newkbn = 0", "list");
		$this->lcslall_check($licence_list);
		unset($licence_list);
		if(count(@$this->fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO sogocheck_tmp (sogochk_type,err_pkey,inv_list,inv_detail,hard_hardno,soft_hardno,soft_licenceno,soft_program,licence_licenceno,licence_program,licencelist_program,sosiki1,sosiki2,sysyem_user,start_date,check_date,msg_val1,msg_val2,msg_val3,msg_val4,msg_val5,msg_val6,msg_val7,spt_val1,spt_val2,spt_val3,spt_val4,spt_val5,mail_val1,mail_val2,mail_val3,mail_val4,mail_val5,mail_val6,mail_val7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
			unset($this->fields_values);
		}
		//バッチログセット
		$this->set_bat_log(61);
	}

	function sogo_licence($param){
		$limit = " limit ".$param[1]." offset ".$param[0];
		$licence = $this->db->dbSelect("select * from tmp_licence_detail where newkbn = 0 order by licence_pkey".$limit, "list");
		$this->lcsall_check($licence);
		unset($licence);
		if(count(@$this->fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO sogocheck_tmp (sogochk_type,err_pkey,inv_list,inv_detail,hard_hardno,soft_hardno,soft_licenceno,soft_program,licence_licenceno,licence_program,licencelist_program,sosiki1,sosiki2,sysyem_user,start_date,check_date,msg_val1,msg_val2,msg_val3,msg_val4,msg_val5,msg_val6,msg_val7,spt_val1,spt_val2,spt_val3,spt_val4,spt_val5,mail_val1,mail_val2,mail_val3,mail_val4,mail_val5,mail_val6,mail_val7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
			unset($this->fields_values);
		}
		$pkey = $param[0] / 10000 + 62;
		//バッチログセット
		$this->set_bat_log($pkey);
	}

	function sogo_soft($param){
		$limit = " limit ".$param[1]." offset ".$param[0];
		$soft = $this->db->dbSelect("select * from tmp_soft_detail where newkbn = 0 order by soft_pkey".$limit, "list");
		$this->softall_check($soft);
		unset($soft);
		if(count(@$this->fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO sogocheck_tmp (sogochk_type,err_pkey,inv_list,inv_detail,hard_hardno,soft_hardno,soft_licenceno,soft_program,licence_licenceno,licence_program,licencelist_program,sosiki1,sosiki2,sysyem_user,start_date,check_date,msg_val1,msg_val2,msg_val3,msg_val4,msg_val5,msg_val6,msg_val7,spt_val1,spt_val2,spt_val3,spt_val4,spt_val5,mail_val1,mail_val2,mail_val3,mail_val4,mail_val5,mail_val6,mail_val7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
			unset($this->fields_values);
		}
		$pkey = $param[0] / 30000 + 72;
		//バッチログセット
		$this->set_bat_log($pkey);
	}
	
	function sogo_hard(){
		$hard = $this->db->dbSelect("select * from tmp_hard_detail where newkbn = 0", "list");
		$this->hardall_check($hard);
		unset($hard);
		if(count(@$this->fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO sogocheck_tmp (sogochk_type,err_pkey,inv_list,inv_detail,hard_hardno,soft_hardno,soft_licenceno,soft_program,licence_licenceno,licence_program,licencelist_program,sosiki1,sosiki2,sysyem_user,start_date,check_date,msg_val1,msg_val2,msg_val3,msg_val4,msg_val5,msg_val6,msg_val7,spt_val1,spt_val2,spt_val3,spt_val4,spt_val5,mail_val1,mail_val2,mail_val3,mail_val4,mail_val5,mail_val6,mail_val7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
			unset($this->fields_values);
		}
		//バッチログセット
		$this->set_bat_log(82);
	}
	
	function sogo_mail(){
		if(_SOGO_MAIL_SEND == '1'){
			$mail_tpl = new Template;
			$email = new Sendmail;
			$sosiki_name = select_sosiki();
		
			$system_sogo = $this->db->dbSelect("select * from sogocheck where sysyem_user or ( sosiki1 is null and sosiki2 is null and sysyem_user = false)", "list");

			if(count($system_sogo) > 0){
				for($i=0; $i<count($system_sogo); $i++){
					for($j=1; $j<=7; $j++){
						$col_name = "mail_val".$j;
						$str[$j-1] = $system_sogo[$i][$col_name];
					}
					$system_sogo[$i]['sogo'] = vsprintf(Error::SogoView($system_sogo[$i]['err_pkey']),$str);
				}
				$mail_tpl->assignHtml('list_view',$system_sogo);
				$mail_tpl->assignHtml('total_qty', count($system_sogo));

				$body = $mail_tpl->fetchHtml('mail/system_sogo.html');
				$body = ereg_replace("ttttt.+ttttt","",$body);
				$subject = "【情報資産管理システム】齟齬情報のご案内（所属なし 全".count($system_sogo)."件）";
	
				$system_user = $this->db->dbSelect("select email_ad from \"user\" where auth = 'd004'", "list");
				for($i=0; $i<count($system_user); $i++){
					$email_array = explode("\n",$system_user[$i]['email_ad']);
					for($j=0; $j<count($email_array); $j++){
						if($email_array[$j] != ""){
							$email->email($email_array[$j], _ADMIN_EMAIL, $subject, $body);
						}
					}
				}
				unset($system_sogo);
				unset($body);
				unset($subject);
			}

		
			$sogo_user = $this->db->dbSelect("select * from \"user\" where auth = 'd005'", "list");
			for($i=0; $i<count($sogo_user); $i++){
				$exec = _HTTPDOCS_PATH."/hcms/bin/mail_send_alert.sh ".$sogo_user[$i]['sosiki_pkey']." ".ereg_replace("\n",",",$sogo_user[$i]['email_ad']);
				exec($exec);
			}
			$sogo_user = $this->db->dbSelect("select * from \"user\" where auth = 'd003'", "list");
			for($i=0; $i<count($sogo_user); $i++){
				$exec = _HTTPDOCS_PATH."/hcms/bin/mail_send.sh ".$sogo_user[$i]['sosiki_pkey']." ".ereg_replace("\n",",",$sogo_user[$i]['email_ad']);
				exec($exec);
			}
		}
	}

	function mail_send($param){
		if(_SOGO_MAIL_SEND == '1'){
			$mail_tpl = new Template;
			$email = new Sendmail;
			$sosiki_name = select_sosiki();

			$sosiki_key = $param[0];
			//所属
			$child_array = child_sosiki_key($sosiki_key);
			array_unshift($child_array,$sosiki_key);
			$sosiki_array = $child_array;
			$where = ' where (sosiki1 in ('.implode(",",$sosiki_array).') or sosiki2 in ('.implode(",",$sosiki_array).'))';

			$email_ad = $param[1];
			$user_sogo = $this->db->dbSelect("select * from sogocheck".$where, "list");
			if(count($user_sogo) > 0){
				for($i=0; $i<count($user_sogo); $i++){
					for($j=1; $j<=7; $j++){
						$col_name = "mail_val".$j;
						$str[$j-1] = $user_sogo[$i][$col_name];
					}
					$user_sogo[$i]['sogo'] = vsprintf(Error::SogoView($user_sogo[$i]['err_pkey']),$str);
				}
				$mail_tpl->assignHtml('list_view',$user_sogo);
				$mail_tpl->assignHtml('total_qty', count($user_sogo));
				$mail_tpl->assignHtml('sosiki_name', $sosiki_name[$sosiki_key]);

				$body = $mail_tpl->fetchHtml('mail/user_sogo.html');
				$body = ereg_replace("ttttt.+ttttt","",$body);
				$subject = "【情報資産管理システム】齟齬情報のご案内（".$sosiki_name[$sosiki_key]." 全".count($user_sogo)."件）";
		
				$email_array = explode(",",$email_ad);
				for($j=0; $j<count($email_array); $j++){
					if($email_array[$j] != ""){
						$email->email($email_array[$j], _ADMIN_EMAIL, $subject, $body);
					}
				}
			}
			unset($user_sogo);
			unset($body);
			unset($subject);
		}
	}
	
	function mail_send_alert($param){
		if(_SOGO_MAIL_SEND == '1'){
			$mail_tpl = new Template;
			$email = new Sendmail;
			$sosiki_name = select_sosiki();

			$sosiki_key = $param[0];
			//所属
			$child_array = child_sosiki_key($sosiki_key);
			array_unshift($child_array,$sosiki_key);
			$sosiki_array = $child_array;
			$where = ' where (sosiki1 in ('.implode(",",$sosiki_array).') or sosiki2 in ('.implode(",",$sosiki_array).')) and to_date(check_date, \'yyyy/MM/dd\')-to_date(start_date, \'yyyy/MM/dd\') >= ';
			$where .= _ALERT_DISCREPANT_DAY-1;
			$email_ad = $param[1];
			$user_sogo = $this->db->dbSelect("select * from sogocheck".$where, "list");
			if(count($user_sogo) > 0){
				for($i=0; $i<count($user_sogo); $i++){
					for($j=1; $j<=7; $j++){
						$col_name = "mail_val".$j;
						$str[$j-1] = $user_sogo[$i][$col_name];
					}
					$user_sogo[$i]['sogo'] = vsprintf(Error::SogoView($user_sogo[$i]['err_pkey']),$str);
				}
				$mail_tpl->assignHtml('list_view',$user_sogo);
				$mail_tpl->assignHtml('total_qty', count($user_sogo));
				$mail_tpl->assignHtml('sosiki_name', $sosiki_name[$sosiki_key]);

				$body = $mail_tpl->fetchHtml('mail/user_sogo.html');
				$body = ereg_replace("ttttt.+ttttt","",$body);
				$subject = "【情報資産管理システム】齟齬情報のご案内（".$sosiki_name[$sosiki_key]." 全".count($user_sogo)."件）";
		
				$email_array = explode(",",$email_ad);
				for($j=0; $j<count($email_array); $j++){
					if($email_array[$j] != ""){
						$email->email($email_array[$j], _ADMIN_EMAIL, $subject, $body);
					}
				}
			}
			unset($user_sogo);
			unset($body);
			unset($subject);
		}
	}
	
	function invall_check($list){
		$sosiki_name_list = select_sosiki();
		$today = date("Ymd");
		for($i=0; $i<count($list); $i++){
print $i."_invall\n";
			$sogo_user = array_search($list[$i]['group1'],$sosiki_name_list);
			if(@$sogo_user === FALSE){
				$system_sogo = true;
				$user1_sogo = "";
				$user2_sogo = "";
			}else{
				$system_sogo = false;
				$user1_sogo = $sogo_user;
				$user2_sogo = "";
			}

			if($list[$i]['hikaku'] == 'd001' and $list[$i]['group1'] == "" and _SOGO_0318){
				$this->fields_values[] = array(
								1,     
								"0318",    
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['computername'], 
								$list[$i]['ipaddress'], 
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if($list[$i]['hikaku'] == 'd001' and $list[$i]['jyotai'] == "" and _SOGO_0319){
				$this->fields_values[] = array(
								1,     
								"0319",    
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								@$user1_sogo,
								@$user2_sogo,
								@$system_sogo,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['computername'], 
								$list[$i]['ipaddress'], 
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if($list[$i]['hikaku'] == 'd001' and $list[$i]['hsyubetu'] == "" and _SOGO_0320){
				$this->fields_values[] = array(
								1,     
								"0320",    
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								@$user1_sogo,
								@$user2_sogo,
								@$system_sogo,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['computername'], 
								$list[$i]['ipaddress'], 
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			$hard_detail = $this->db->dbSelect("select * from tmp_hard_detail where hard_kanrino = '".$list[$i]['hardwareno']."'", "detail");
			if(!is_array($hard_detail)){
				$hard_detail = array();
			}
			if($list[$i]['hikaku'] == 'd001' and $list[$i]['jyotai'] == 'd001' and $list[$i]['hsyubetu'] == 'd001' and count($hard_detail)<=0 and _SOGO_0321){
				$this->fields_values[] = array(
								1,     
								"0321",    
								"",
								$list[$i]['inventory_pkey'],
								$list[$i]['hardwareno'],
								"",
								"",
								"",
								"",
								"",
								"",
								@$user1_sogo,
								@$user2_sogo,
								@$system_sogo,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['computername'], 
								$list[$i]['ipaddress'], 
								"",
								"",
								"",
								"",
								""
						      );
			}else{
				if(@$hard_detail['haiki_date'] != null){
					$haiki = explode("-",$hard_detail['haiki_date']);
					$haikidate = date("Ymd",mktime(0,0,0,$haiki[1],$haiki[2],$haiki[0]));
				}else{
					$haikidate = $today;
				}
				if($list[$i]['hikaku'] == 'd001' and $list[$i]['jyotai'] != "d004" and $haikidate < date("Ymd") and @$hard_detail['haiki_date'] != null and _SOGO_0322){
					$this->fields_values[] = array(
									1,     
									"0322",    
									"",
									$list[$i]['inventory_pkey'],
									$list[$i]['hardwareno'],
									"",
									"",
									"",
									"",
									"",
									"",
									@$user1_sogo,
									@$user2_sogo,
									@$system_sogo,
									date("Y-m-d H:i:s"),
									date("Y-m-d H:i:s"),
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									$list[$i]['inventory_pkey'],
									$hard_detail['hard_pkey'],
									"",
									"",
									"",
									$list[$i]['computername'], 
									$list[$i]['ipaddress'], 
									$list[$i]['hardwareno'],
									"",
									"",
									"",
									""
							      );
				}

				if($list[$i]['invtraprecvdate'] != null){
					$lun_check = explode("-",$list[$i]['invtraprecvdate']);
					$lun_check_date = date("Ymd",mktime(0,0,0,$lun_check[1],$lun_check[2]+_LAN_TOOL_DAY,$lun_check[0]));
				}else{
					$lun_check_date = $today;
				}
				if($list[$i]['hikaku'] == 'd001' and $list[$i]['jyotai'] == "d001" and $lun_check_date < date("Ymd") and $list[$i]['collectsource'] == "LanScopeツール" and @$hard_detail['soft_installdel'] == "d001" and _SOGO_0328){
					$this->fields_values[] = array(
									1,     
									"0328",    
									"",
									$list[$i]['inventory_pkey'],
									$list[$i]['hardwareno'],
									"",
									"",
									"",
									"",
									"",
									"",
									@$user1_sogo,
									@$user2_sogo,
									@$system_sogo,
									date("Y-m-d H:i:s"),
									date("Y-m-d H:i:s"),
									_LAN_TOOL_DAY,
									"",
									"",
									"",
									"",
									"",
									"",
									$list[$i]['inventory_pkey'],
									$hard_detail['hard_pkey'],
									"",
									"",
									"",
									$list[$i]['computername'], 
									$list[$i]['ipaddress'], 
									_LAN_TOOL_DAY,
									"",
									"",
									"",
									""
							      );
				}

				if($list[$i]['invtraprecvdate'] != null){
					$usb_check = explode("-",$list[$i]['invtraprecvdate']);
					$usb_check_date = date("Ymd",mktime(0,0,0,$usb_check[1],$usb_check[2]+_USB_TOOL_DAY,$usb_check[0]));
				}else{
					$usb_check_date = $today;
				}
				if($list[$i]['hikaku'] == 'd001' and $list[$i]['jyotai'] == "d001" and $usb_check_date < date("Ymd") and $list[$i]['collectsource'] == "USBツール" and $hard_detail['soft_installdel'] == "d001" and _SOGO_0329){
					$this->fields_values[] = array(
									1,     
									"0329",    
									"",
									$list[$i]['inventory_pkey'],
									$list[$i]['hardwareno'],
									"",
									"",
									"",
									"",
									"",
									"",
									@$user1_sogo,
									@$user2_sogo,
									@$system_sogo,
									date("Y-m-d H:i:s"),
									date("Y-m-d H:i:s"),
									_USB_TOOL_DAY,
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									$list[$i]['computername'], 
									$list[$i]['ipaddress'], 
									_USB_TOOL_DAY,
									"",
									"",
									"",
									""
							      );
				}

				if($list[$i]['invtraprecvdate'] != null){
					$kbn_check = explode("-",$list[$i]['invtraprecvdate']);
					$kbn_check_date = date("Ymd",mktime(0,0,0,$kbn_check[1],$kbn_check[2]+_KOBAN_SEARCH_DAY,$kbn_check[0]));
				}else{
					$kbn_check_date = $today;
				}
				if($list[$i]['hikaku'] == 'd001' and $list[$i]['jyotai'] == "d001" and $kbn_check_date < date("Ymd") and $list[$i]['collectsource'] == "Koban検知" and $hard_detail['soft_installdel'] == "d001" and _SOGO_0330){
					$this->fields_values[] = array(
									1,     
									"0330",    
									"",
									$list[$i]['inventory_pkey'],
									$list[$i]['hardwareno'],
									"",
									"",
									"",
									"",
									"",
									"",
									@$user1_sogo,
									@$user2_sogo,
									@$system_sogo,
									date("Y-m-d H:i:s"),
									date("Y-m-d H:i:s"),
									_KOBAN_SEARCH_DAY,
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									$list[$i]['ipaddress'], 
									_KOBAN_SEARCH_DAY,
									"",
									"",
									"",
									"",
									""
							      );
				}

				if($list[$i]['invtraprecvdate'] != null){
					$lsc_check = explode("-",$list[$i]['invtraprecvdate']);
					$lsc_check_date = date("Ymd",mktime(0,0,0,$lsc_check[1],$lsc_check[2]+_LAN_SEARCH_DAY,$lsc_check[0]));
				}else{
					$lsc_check_date = $today;
				}
				if($list[$i]['hikaku'] == 'd001' and $list[$i]['jyotai'] == "d001" and $lsc_check_date < date("Ymd") and $list[$i]['collectsource'] == "LanScope検知" and $hard_detail['soft_installdel'] == "d001" and _SOGO_0331){
					$this->fields_values[] = array(
									1,     
									"0331",    
									"",
									$list[$i]['inventory_pkey'],
									$list[$i]['hardwareno'],
									"",
									"",
									"",
									"",
									"",
									"",
									@$user1_sogo,
									@$user2_sogo,
									@$system_sogo,
									date("Y-m-d H:i:s"),
									date("Y-m-d H:i:s"),
									_LAN_SEARCH_DAY,
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									$list[$i]['computername'], 
									$list[$i]['ipaddress'], 
									_LAN_SEARCH_DAY,
									"",
									"",
									"",
									""
							      );
				}
			}
			if($list[$i]['hikaku'] == 'd001' and ($list[$i]['collectsource'] == "LanScopeツール" or $list[$i]['collectsource'] == "USBツール") and $list[$i]['hsyubetu'] == "d002" and _SOGO_0324){
				$this->fields_values[] = array(
								1,     
								"0324",    
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								@$user1_sogo,
								@$user2_sogo,
								@$system_sogo,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['computername'], 
								$list[$i]['ipaddress'], 
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if($list[$i]['hikaku'] == 'd001' and $list[$i]['jyotai'] != "d004" and ($list[$i]['collectsource'] == "Koban検知" or $list[$i]['collectsource'] == "LanScope検知") and $list[$i]['hsyubetu'] != "d002" and _SOGO_0325){
				if($list[$i]['collectsource'] == "Koban検知"){
					$computername = "<不明>";
				}else{
					$computername = $list[$i]['computername'];
				}
				$this->fields_values[] = array(
								1,     
								"0325",    
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								@$user1_sogo,
								@$user2_sogo,
								@$system_sogo,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								$computername,
								$list[$i]['ipaddress'], 
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if($list[$i]['hikaku'] == 'd001' and $list[$i]['collectsource'] == "LanScopeツール" and $list[$i]['hardwareno'] == "" and _SOGO_0326){
				$this->fields_values[] = array(
								1,     
								"0326",    
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								@$user1_sogo,
								@$user2_sogo,
								@$system_sogo,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['computername'],
								$list[$i]['ipaddress'], 
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if($list[$i]['hikaku'] == 'd001' and $list[$i]['collectsource'] == "USBツール" and $list[$i]['hardwareno'] == "" and _SOGO_0327){
				$this->fields_values[] = array(
								1,     
								"0327",    
								"",
								$list[$i]['inventory_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								@$user1_sogo,
								@$user2_sogo,
								@$system_sogo,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['computername'],
								$list[$i]['ipaddress'], 
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			$inv = $this->db->dbSelect("select count(*) from tmp_inventory where hardwareno = '".$list[$i]['hardwareno']."'", "detail");
			if($inv['count'] >= 2 and _SOGO_0334){
				$this->fields_values[] = array(
								1,     
								"0334",    
								$list[$i]['hardwareno'],
								"",
								$list[$i]['hardwareno'],
								"",
								"",
								"",
								"",
								"",
								"",
								@$user1_sogo,
								@$user2_sogo,
								@$system_sogo,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['hardwareno'],
								"",
								"",
								"",
								"",
								$list[$i]['hardwareno'],
								$list[$i]['hardwareno'],
								"",
								"",
								"",
								"",
								""
						      );
			}
		}
		unset($list);
	}
	
	function inv_check($list){
		#齟齬チェック対象外ライセンス種類
		$type_array = $this->db->dbSelect("select * from code where code_bunrui = '00029' order by code_sort", "list");
		$type_in =array();
		$target_type = "";
		if(count($type_array) > 0){
			for($k=0; $k<count($type_array); $k++){
				$type_in[] = "'".$type_array[$k]['code_name']."'";
			}
			$target_type = " where tmp_licencelist.licence_keitai in (".implode(",",$type_in).")";
			$target_name_in = " and code in (".implode(",",$type_in).")";

			#齟齬チェック対象外ライセンス種類の名前
			$type_name_data = $this->db->dbSelect("select * from code where code_bunrui = '00005'".$target_name_in." order by code_sort", "list");
			$type_name_array =array();
			$target_type_name = "";
			if(count($type_name_data) > 0){
				for($j=0; $j<count($type_name_data); $j++){
					$type_name_array[] = $type_name_data[$j]['code_name'];
				}
				$target_type_name = implode("・",$type_name_array);

			}
		}

		$target_soft_array = $this->db->dbSelect("select tmp_licencelistprogram.program_add_del from (tmp_licencelistprogram LEFT JOIN tmp_licencelist ON tmp_licencelistprogram.licencelist_pkey = tmp_licencelist.licencelist_pkey)".$target_type." and tmp_licencelist.newkbn <> 1 and tmp_licencelist.yukou = 'd001' UNION select tmp_licencelistprogram_down.program_add_del from (tmp_licencelistprogram_down LEFT JOIN tmp_licencelist ON tmp_licencelistprogram_down.licencelist_pkey = tmp_licencelist.licencelist_pkey)".$target_type." and tmp_licencelist.newkbn <> 1 and tmp_licencelist.yukou = 'd001'","list");
		$target_soft = array();
		for($k=0; $k<count($target_soft_array); $k++){
			$target_soft[] = $target_soft_array[$k]['program_add_del'];
		}

		$disabled_soft_array = $this->db->dbSelect("select tmp_licencelistprogram.program_add_del from (tmp_licencelistprogram LEFT JOIN tmp_licencelist ON tmp_licencelistprogram.licencelist_pkey = tmp_licencelist.licencelist_pkey and tmp_licencelist.yukou = 'd001') where tmp_licencelist.disabled = 'd001' UNION select tmp_licencelistprogram_down.program_add_del from (tmp_licencelistprogram_down LEFT JOIN tmp_licencelist ON tmp_licencelistprogram_down.licencelist_pkey = tmp_licencelist.licencelist_pkey and tmp_licencelist.yukou = 'd001') where tmp_licencelist.disabled = 'd001'","list");
		$disabled_soft = array();
		for($k=0; $k<count($disabled_soft_array); $k++){
			$disabled_soft[] = $disabled_soft_array[$k]['program_add_del'];
		}
			
		for($i=0; $i<count($list); $i++){
print $i."-".$list[$i]['hardwareno']."_inv\n";
			$sosiki_detail = $this->db->dbSelect("select sosiki_pkey from tmp_hard where hard_kanrino = '".$list[$i]['hardwareno']."'", "detail");
			$sosiki = $sosiki_detail['sosiki_pkey'];

			if(@$sosiki !== FALSE){
				if(!@$sosiki_in[$sosiki]){
					$sosiki_in[$sosiki] = " in(".implode(",",full_sosiki_key($sosiki)).")";
				}
if(!is_array(@$sosiki_list[$sosiki])){
					$sosiki_list[$sosiki] = array();
					$program_array = $this->db->dbSelect("select tmp_licencelistprogram.program_add_del from (tmp_licencelistprogram LEFT JOIN tmp_licencelist ON tmp_licencelistprogram.licencelist_pkey = tmp_licencelist.licencelist_pkey and tmp_licencelist.yukou = 'd001') LEFT JOIN tmp_licence ON tmp_licencelist.licencelist_pkey = tmp_licence.licencelist_pkey and (tmp_licence.haiki_date > '".date("Y/m/d")."' or tmp_licence.haiki_date is null) and tmp_licence.newkbn <> 1 where tmp_licencelist.newkbn <> 1 and tmp_licence.sosiki_pkey".$sosiki_in[$sosiki]." group by tmp_licencelistprogram.program_add_del UNION select tmp_licencelistprogram_down.program_add_del from (tmp_licencelistprogram_down LEFT JOIN tmp_licencelist ON tmp_licencelistprogram_down.licencelist_pkey = tmp_licencelist.licencelist_pkey and tmp_licencelist.yukou = 'd001') LEFT JOIN tmp_licence ON tmp_licencelist.licencelist_pkey = tmp_licence.licencelist_pkey and (tmp_licence.haiki_date > '".date("Y/m/d")."' or tmp_licence.haiki_date is null) and tmp_licence.newkbn <> 1 where tmp_licencelist.newkbn <> 1 and tmp_licence.sosiki_pkey".$sosiki_in[$sosiki]." group by tmp_licencelistprogram_down.program_add_del 
", "list");
					for($k=0; $k<count($program_array); $k++){
						array_push($sosiki_list[$sosiki],$program_array[$k]['program_add_del']);
					}
				}
				if(!is_array(@$pg_list[$list[$i]['hardwareno']])){
					$pg_list[$list[$i]['hardwareno']] = array();
					$program_array = $this->db->dbSelect("select tmp_licencelistprogram.program_add_del from (((tmp_licencelistprogram LEFT JOIN tmp_licencelist ON tmp_licencelistprogram.licencelist_pkey = tmp_licencelist.licencelist_pkey and tmp_licencelist.yukou = 'd001') LEFT JOIN tmp_licence ON tmp_licencelist.licencelist_pkey = tmp_licence.licencelist_pkey and (tmp_licence.haiki_date > '".date("Y/m/d")."' or tmp_licence.haiki_date is null) and tmp_licence.newkbn <> 1 )  LEFT JOIN tmp_soft ON tmp_licence.licence_pkey = tmp_soft.licence_pkey and (tmp_soft.uninstall_date > '".date("Y/m/d")."' or tmp_soft.uninstall_date is null) and tmp_soft.newkbn <> 1 and tmp_soft.downgrade != 'd001' ) LEFT JOIN tmp_hard ON tmp_soft.hard_pkey =  tmp_hard.hard_pkey and (tmp_hard.haiki_date > '".date("Y/m/d")."' or tmp_hard.haiki_date is null) and tmp_hard.newkbn <> 1 where tmp_licencelist.newkbn <> 1 and tmp_hard.hard_kanrino = '".$list[$i]['hardwareno']."' group by tmp_licencelistprogram.program_add_del UNION select tmp_licencelistprogram_down.program_add_del from (((tmp_licencelistprogram_down LEFT JOIN tmp_licencelist ON tmp_licencelistprogram_down.licencelist_pkey = tmp_licencelist.licencelist_pkey and tmp_licencelist.yukou = 'd001') LEFT JOIN tmp_licence ON tmp_licencelist.licencelist_pkey = tmp_licence.licencelist_pkey and (tmp_licence.haiki_date > '".date("Y/m/d")."' or tmp_licence.haiki_date is null) and tmp_licence.newkbn <> 1 )  LEFT JOIN tmp_soft ON tmp_licence.licence_pkey = tmp_soft.licence_pkey and (tmp_soft.uninstall_date > '".date("Y/m/d")."' or tmp_soft.uninstall_date is null) and tmp_soft.newkbn <> 1 and tmp_soft.downgrade = 'd001' ) LEFT JOIN tmp_hard ON tmp_soft.hard_pkey =  tmp_hard.hard_pkey and (tmp_hard.haiki_date > '".date("Y/m/d")."' or tmp_hard.haiki_date is null) and tmp_hard.newkbn <> 1 where tmp_licencelist.newkbn <> 1 and tmp_hard.hard_kanrino = '".$list[$i]['hardwareno']."' group by tmp_licencelistprogram_down.program_add_del", "list");
					for($k=0; $k<count($program_array); $k++){
						array_push($pg_list[$list[$i]['hardwareno']],$program_array[$k]['program_add_del']);
					}
				}
				
				$soft_list = $this->db->dbSelect("select insapname,insapno from tmp_inventorysoft where hardwareno = '".$list[$i]['hardwareno']."'", "list");
				
				for($j=0; $j<count($soft_list); $j++){
					
					if($list[$i]['jyotai'] == 'd001' and $list[$i]['hikaku'] == 'd001' and $list[$i]['hsyubetu'] != "d004" and !in_array($soft_list[$j]['insapname'],$sosiki_list[$sosiki]) and !in_array($soft_list[$j]['insapname'],$target_soft) and _SOGO_0332){
						$this->fields_values[] = array(
										2,     
										"0332",    
										"",
										$list[$i]['inventory_pkey'],
										$list[$i]['hardwareno'],
										$list[$i]['hardwareno'],
										"",
										$soft_list[$j]['insapname'],
										"",
										$soft_list[$j]['insapname'],
										$soft_list[$j]['insapname'],
										@$sosiki,
										"",
										false,
										date("Y-m-d H:i:s"),
										date("Y-m-d H:i:s"),
										$soft_list[$j]['insapname'],
										$target_type_name,
										"",
										"",
										"",
										"",
										"",
										$list[$i]['hardwareno'],
										"",
										"",
										"",
										"",
										$list[$i]['computername'], 
										$list[$i]['ipaddress'], 
										$list[$i]['hardwareno'],
										$soft_list[$j]['insapname'],
										$target_type_name,
										"",
										""
								      );
					}
					if($list[$i]['jyotai'] == 'd001' and $list[$i]['hikaku'] == 'd001' and $list[$i]['hsyubetu'] != "d004" and in_array($soft_list[$j]['insapname'],$sosiki_list[$sosiki]) and !in_array($soft_list[$j]['insapname'],$pg_list[$list[$i]['hardwareno']]) and !in_array($soft_list[$j]['insapname'],$target_soft) and _SOGO_0333){
						$this->fields_values[] = array(
										2,     
										"0333",    
										"",
										$list[$i]['inventory_pkey'],
										$list[$i]['hardwareno'],
										$list[$i]['hardwareno'],
										"",
										$soft_list[$j]['insapname'],
										"",
										$soft_list[$j]['insapname'],
										$soft_list[$j]['insapname'],
										@$sosiki,
										"",
										false,
										date("Y-m-d H:i:s"),
										date("Y-m-d H:i:s"),
										$soft_list[$j]['insapname'],
										$target_type_name,
										"",
										"",
										"",
										"",
										"",
										$list[$i]['hardwareno'],
										$list[$i]['hardwareno'],
										"",
										"",
										"",
										$list[$i]['computername'], 
										$list[$i]['ipaddress'], 
										$list[$i]['hardwareno'],
										$soft_list[$j]['insapname'],
										$target_type_name,
										"",
										""
								      );
					}
					if($list[$i]['jyotai'] == 'd001' and $list[$i]['hikaku'] == 'd001' and in_array($soft_list[$j]['insapname'],$disabled_soft) and _SOGO_0337){
						$this->fields_values[] = array(
										2,     
										"0337",    
										"",
										$list[$i]['inventory_pkey'],
										$list[$i]['hardwareno'],
										$list[$i]['hardwareno'],
										"",
										$soft_list[$j]['insapname'],
										"",
										$soft_list[$j]['insapname'],
										$soft_list[$j]['insapname'],
										@$sosiki,
										"",
										false,
										date("Y-m-d H:i:s"),
										date("Y-m-d H:i:s"),
										$soft_list[$j]['insapname'],
										"",
										"",
										"",
										"",
										"",
										"",
										"",
										"",
										"",
										"",
										"",
										$list[$i]['computername'], 
										$list[$i]['ipaddress'], 
										$list[$i]['hardwareno'],
										$soft_list[$j]['insapname'],
										"",
										"",
										""
								      );
					}
					
					$inv_soft_reg = in_array($soft_list[$j]['insapname'],$pg_list[$list[$i]['hardwareno']]);
					$inv_soft_exempt = in_array($soft_list[$j]['insapname'],$target_soft);
					$this->inv_fields_values[] = array(
									$soft_list[$j]['insapno'],
									$inv_soft_reg,
									$inv_soft_exempt
							);
				}
				unset($soft_list);
			}
			
		}
		unset($list);
	}
	
	function lcslall_check($list){
		for($i=0; $i<count($list); $i++){
print $i."_lcslall\n";
			$where = " where soft_name = '".addslashes($list[$i]['soft_name'])."' and edition = '".$list[$i]['edition']."' and licence_keitai = '".$list[$i]['licence_keitai']."' and hard_kotei = '".$list[$i]['hard_kotei']."' and upgrade = '".$list[$i]['upgrade']."' and newkbn = 0";
			$ll = $this->db->dbSelect("select count(*) from tmp_licencelist_detail".$where, "detail");
			if($ll['count'] > 1 and _SOGO_0335){
				$this->fields_values[] = array(
								1,     
								"0335",    
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								true,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								$list[$i]['soft_name'],
								$list[$i]['edition'],
								$list[$i]['licence_keitai_name'],
								$list[$i]['hard_kotei_name'],
								$list[$i]['upgrade_name'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['soft_name'],
								$list[$i]['edition'],
								$list[$i]['licence_keitai_name'],
								$list[$i]['hard_kotei_name'], 
								$list[$i]['upgrade_name'], 
								"",
								""
						      );
			}
		}
		unset($list);
	}
	
	function lcsall_check($list){
		for($i=0; $i<count($list); $i++){
print $i."_lcsall\n";
			if($list[$i]['hard_pkey'] == ""){
				$hard_pkey_tmp = 0;
			}else{
				$hard_pkey_tmp = $list[$i]['hard_pkey'];
			}
			$hard_list = $this->db->dbSelect("select * from tmp_hard_detail where hard_pkey = ".$hard_pkey_tmp, "list");
			if(count($hard_list) > 0){
				$hard_detail = $hard_list[0];
			}else{
				$hard_detail = array();
			}
			
			if($list[$i]['licence_pkey2'] != ""){
				$licence_kanrino2_array = explode(",",$list[$i]['licence_pkey2']);
				if(count($licence_kanrino2_array) > 0){
					$license_detail_array = array();
					for($k=0; $k<count($licence_kanrino2_array); $k++){
						$li_list_array[$k] = $this->db->dbSelect("select * from tmp_licence_detail where licence_pkey = ".$licence_kanrino2_array[$k], "list");
						if(count($li_list_array[$k]) > 0){
							$license_detail_array[] = $li_list_array[$k][0];
						}else{
							$license_detail_array[] = array();
						}
					}
				}
			}
			
			$sosiki_list = $this->db->dbSelect("select * from tmp_sosiki_detail where sosiki_pkey = ".$list[$i]['sosiki_pkey'], "list");
			$licenselist_list = $this->db->dbSelect("select * from tmp_licencelist_detail where licencelist_pkey = ".$list[$i]['licencelist_pkey']." and yukou = 'd001'", "list");
			
			if($list[$i]['hard_kotei'] == 'd001' and count($hard_list) <= 0 and _SOGO_0301){
				$this->fields_values[] = array(
								1,     
								"0301",    
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								true,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if(@$hard_detail['haiki_date'] != null){
				$hard_haiki = explode("-",$hard_detail['haiki_date']);
				$hard_haiki_date = date("Ymd",mktime(0,0,0,$hard_haiki[1],$hard_haiki[2],$hard_haiki[0]));
			}else{
				$hard_haiki_date = date("Ymd");
			}
			if($list[$i]['hard_kotei'] == 'd001' and $list[$i]['haiki_date'] == '' and $hard_haiki_date < date("Ymd") and _SOGO_0302){
				$this->fields_values[] = array(
								1,     
								"0302",    
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['sosiki_pkey'],
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if(count(@$li_list_array) > 0){
				for($k=0; $k<count($li_list_array); $k++){
					if($list[$i]['upgrade'] == 'd001' and count($li_list_array[$k]) <= 0 and $list[$i]['install_qty'] > 0 and _SOGO_0303){
						$this->fields_values[] = array(
										1,     
										"0303",    
										"",
										"",
										"",
										"",
										"",
										"",
										$list[$i]['licence_kanrino'],
										"",
										"",
										@$list[$i]['sosiki_pkey'],
										"",
										true,
										date("Y-m-d H:i:s"),
										date("Y-m-d H:i:s"),
										"",
										"",
										"",
										"",
										"",
										"",
										"",
										$list[$i]['licence_pkey'],
										"",
										"",
										"",
										"",
										$list[$i]['licence_kanrino'],
										"",
										"",
										"",
										"",
										"",
										""
								      );
					}
				}
			}
			
			if(count(@$license_detail_array) > 0){
				for($k=0; $k<count($license_detail_array); $k++){
					if(@$license_detail_array[$k]['haiki_date'] != null){
						$license_haiki = explode("-",$license_detail_array[$k]['haiki_date']);
						$license_haiki_date = date("Ymd",mktime(0,0,0,$license_haiki[1],$license_haiki[2],$license_haiki[0]));
					}else{
						$license_haiki_date = date("Ymd");
					}
					if($list[$i]['upgrade'] == 'd001' and $list[$i]['haiki_date'] == '' and $license_haiki_date < date("Ymd") and _SOGO_0304){
						$this->fields_values[] = array(
										1,     
										"0304",    
										"",
										"",
										"",
										"",
										"",
										"",
										$list[$i]['licence_kanrino'],
										"",
										"",
										@$list[$i]['sosiki_pkey'],
										"",
										false,
										date("Y-m-d H:i:s"),
										date("Y-m-d H:i:s"),
										"",
										"",
										"",
										"",
										"",
										"",
										"",
										$list[$i]['licence_pkey'],
										"",
										"",
										"",
										"",
										$list[$i]['licence_kanrino'],
										"",
										"",
										"",
										"",
										"",
										""
								      );
					}
				}
			}
			
			if($list[$i]['upgrade'] == 'd001' and @$license_detail['upgrade'] == 'd001' and _SOGO_0305){
				$this->fields_values[] = array(
								1,     
								"0305",    
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['sosiki_pkey'],
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}

			if($list[$i]['haiki_date'] == '' and $list[$i]['install_su'] <> 99999999 and $list[$i]['install_qty'] > $list[$i]['install_su'] and _SOGO_0306){
				$this->fields_values[] = array(
								1,     
								"0306",    
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['sosiki_pkey'],
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								$list[$i]['install_su'],
								"",
								"",
								"",
								"",
								""
						      );
			}

			if($list[$i]['licence_pkey2'] != '' and @$list[$i]['install_su'] != @$license_detail['install_su'] and _SOGO_0307){
				$this->fields_values[] = array(
								1,     
								"0307",    
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['sosiki_pkey'],
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_pkey2'],
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if(count($sosiki_list) <= 0 and _SOGO_0308){
				$this->fields_values[] = array(
								1,     
								"0308",    
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								true,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if(count($licenselist_list) <= 0 and _SOGO_0309){
				$this->fields_values[] = array(
								1,     
								"0309",    
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								true,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}

			$l_list = $this->db->dbSelect("select * from tmp_licence where licence_kanrino = '".$list[$i]['licence_kanrino']."' and newkbn = 0", "list");
			if(count($l_list) > 1 and _SOGO_0310){
				$this->fields_values[] = array(
								1,     
								"0310",    
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['sosiki_pkey'],
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if(@$list[$i]['haiki_date'] != null or @$list[$i]['haiki_date'] != ""){
				$haiki = explode("-",$list[$i]['haiki_date']);
				$haiki_date = date("Ymd",mktime(0,0,0,$haiki[1],$haiki[2],$haiki[0]));
			}else{
				$haiki_date = "";
			}
			if(@$list[$i]['disabled'] == 'd001' and (@$list[$i]['haiki_date'] == null or @$list[$i]['haiki_date'] == "" or $haiki_date > date("Ymd")) and _SOGO_0336){
				$this->fields_values[] = array(
								1,     
								"0336",    
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['sosiki_pkey'],
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								""
						      );
			}
			
			if(@$list[$i]['haiki_date'] != null and @$list[$i]['haiki_date'] != ""){
				$haiki = explode("-",$list[$i]['haiki_date']);
				$haiki_date = date("Ymd",mktime(0,0,0,$haiki[1],$haiki[2],$haiki[0]));
			}else{
				$haiki_date = "";
			}
			if(@$list[$i]['use_limit_date'] != null and @$list[$i]['use_limit_date'] != ""){
				$use_limit = explode("-",$list[$i]['use_limit_date']);
				$use_limit_date = date("Ymd",mktime(0,0,0,$use_limit[1],$use_limit[2],$use_limit[0]));
			}else{
				$use_limit_date = "";
			}
			if(@$list[$i]['use_limit_date'] != null and @$list[$i]['use_limit_date'] != "" and $use_limit_date <= date("Ymd") and (@$list[$i]['haiki_date'] == null or @$list[$i]['haiki_date'] == "" or $haiki_date > date("Ymd")) and _SOGO_0338){
				$this->fields_values[] = array(
								1,     
								"0338",    
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['sosiki_pkey'],
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								$list[$i]['use_limit_date'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}
		}
		unset($list);
	}
	
	function softall_check($list){
		for($i=0; $i<count($list); $i++){
print $i."_softall\n";
			if(!@$sosiki_full[@$list[$i]['licence_sosiki_pkey']]){
				$sosiki_full[@$list[$i]['licence_sosiki_pkey']] = child_sosiki_key(@$list[$i]['licence_sosiki_pkey']);
				array_unshift($sosiki_full[@$list[$i]['licence_sosiki_pkey']],@$list[$i]['licence_sosiki_pkey']);
			}
			$hard_list = $this->db->dbSelect("select * from tmp_hard_detail where hard_pkey = ".$list[$i]['hard_pkey'], "list");
			if(count($hard_list) > 0){
				$hard_detail = $hard_list[0];
			}else{
				$hard_detail = array();
			}

			if(count($hard_list) <= 0 and _SOGO_0311){
				$this->fields_values[] = array(
								1,     
								"0311",    
								"",
								"",
								"",
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								"",
								"",
								"",
								"",
								true,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['soft_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}

			if($list[$i]['licence_pkey'] == ""){
				$licence_pkey_tmp = 0;
			}else{
				$licence_pkey_tmp = $list[$i]['licence_pkey'];
			}
			$license_list = $this->db->dbSelect("select * from tmp_licence_detail where licence_pkey = ".$licence_pkey_tmp, "list");
			if(count($license_list) > 0){
				$license_detail = $license_list[0];
			}else{
				$license_detail = array();
			}

			if(count($license_detail) <= 0 and _SOGO_0312){
				$this->fields_values[] = array(
								1,     
								"0312",    
								"",
								"",
								"",
								$list[$i]['hard_kanrino'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								true,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['soft_pkey'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}

			if(!in_array(@$list[$i]['sosiki_pkey'],$sosiki_full[@$list[$i]['licence_sosiki_pkey']]) and $hard_detail['newkbn'] <> 1 and $license_detail['newkbn'] <> 1 and ($hard_detail['haiki_date'] > date("Y/m/d") or $hard_detail['haiki_date'] == null) and ($license_detail['haiki_date'] > date("Y/m/d") or $license_detail['haiki_date'] == null) and (@$list[$i]['haiki_date'] > date("Y/m/d") or @$list[$i]['haiki_date'] == null) and _SOGO_0313){
				$this->fields_values[] = array(
								1,     
								"0313",    
								"",
								"",
								$list[$i]['hard_kanrino'],
								$list[$i]['hard_kanrino'],
								$list[$i]['licence_kanrino'],
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['licence_sosiki_pkey'],
								@$list[$i]['sosiki_pkey'],
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['hard_pkey'],
								$list[$i]['licence_pkey'],
								$list[$i]['soft_pkey'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}
			if(@$license_detail['hard_kotei'] == 'd001' and $list[$i]['hard_kanrino'] != @$license_detail['hard_kanrino'] and ($hard_detail['haiki_date'] > date("Y/m/d") or $hard_detail['haiki_date'] == null) and ($license_detail['haiki_date'] > date("Y/m/d") or $license_detail['haiki_date'] == null) and (@$list[$i]['haiki_date'] > date("Y/m/d") or @$list[$i]['haiki_date'] == null) and _SOGO_0339){
				$this->fields_values[] = array(
								1,     
								"0339",    
								"",
								"",
								"",
								$list[$i]['hard_kanrino'],
								$list[$i]['licence_kanrino'],
								"",
								$list[$i]['licence_kanrino'],
								"",
								"",
								@$list[$i]['licence_sosiki_pkey'],
								@$list[$i]['sosiki_pkey'],
								true,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								$list[$i]['hard_kanrino'],
								@$license_detail['hard_kanrino'],
								"",
								"",
								"",
								"",
								"",
								$list[$i]['soft_pkey'],
								$list[$i]['licence_pkey'],
								"",
								"",
								"",
								$list[$i]['hard_kanrino'],
								@$license_detail['hard_kanrino'],
								$list[$i]['soft_pkey'],
								$list[$i]['licence_pkey'],
								"",
								"",
								""
						      );
			}
		}
		unset($list);
	}
	
	function hardall_check($list){
		for($i=0; $i<count($list); $i++){
print $i."_hardall\n";
			if(@$list[$i]['haiki_date'] != null){
				$hard_haiki = explode("-",$list[$i]['haiki_date']);
				$hard_haiki_date = date("Ymd",mktime(0,0,0,$hard_haiki[1],$hard_haiki[2],$hard_haiki[0]));
			}else{
				$hard_haiki_date = date("Ymd");
			}
			$soft_list = $this->db->dbSelect("select * from tmp_soft_detail where hard_pkey = ".$list[$i]['hard_pkey']." and newkbn <> 1", "list");
			for($j=0; $j<count($soft_list); $j++){
				if(@$soft_list[$j]['haiki_date'] != null){
					$soft_haiki = explode("-",$soft_list[$j]['haiki_date']);
					$soft_haiki_date = date("Ymd",mktime(0,0,0,$soft_haiki[1],$soft_haiki[2],$soft_haiki[0]));
				}else{
					$soft_haiki_date = date("Ymd");
				}
				if($hard_haiki_date < date("Ymd") and @$soft_list[$j]['haiki_date'] == '' and _SOGO_0314){
					$this->fields_values[] = array(
									1,     
									"0314",    
									"",
									"",
									"",
									$list[$i]['hard_kanrino'],
									"",
									"",
									"",
									"",
									"",
									@$list[$i]['sosiki_pkey'],
									"",
									false,
									date("Y-m-d H:i:s"),
									date("Y-m-d H:i:s"),
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									$soft_list[$j]['soft_pkey'],
									"",
									"",
									"",
									"",
									$list[$i]['hard_kanrino'],
									"",
									"",
									"",
									"",
									"",
									""
							      );
				}

				if($list[$i]['haiki_date'] != '' and @$soft_list[$j]['haiki_date'] != '' and $hard_haiki_date < $soft_haiki_date and _SOGO_0315){
					$this->fields_values[] = array(
									1,     
									"0315",    
									"",
									"",
									$list[$i]['hard_kanrino'],
									$list[$i]['hard_kanrino'],
									"",
									"",
									"",
									"",
									"",
									@$list[$i]['sosiki_pkey'],
									"",
									false,
									date("Y-m-d H:i:s"),
									date("Y-m-d H:i:s"),
									"",
									"",
									"",
									"",
									"",
									"",
									"",
									$list[$i]['hard_pkey'],
									$soft_list[$j]['soft_pkey'],
									"",
									"",
									"",
									$list[$i]['hard_kanrino'],
									"",
									"",
									"",
									"",
									"",
									""
							      );
				}
			}
			unset($soft_list);

			$sosiki_qty = $this->db->dbSelect("select count(*) from tmp_sosiki_detail where sosiki_pkey = ".$list[$i]['sosiki_pkey'], "detail");
			if($sosiki_qty['count'] <= 0 and _SOGO_0316){
				$this->fields_values[] = array(
								1,     
								"0316",    
								"",
								"",
								$list[$i]['hard_kanrino'],
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								true,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['hard_pkey'],
								"",
								"",
								"",
								"",
								$list[$i]['hard_kanrino'],
								"",
								"",
								"",
								"",
								"",
								""
						      );
			}
			$hard_qty = $this->db->dbSelect("select count(*) from tmp_hard where hard_kanrino = '".$list[$i]['hard_kanrino']."' and newkbn = 0", "detail");
			if($hard_qty['count'] > 1 and _SOGO_0317){
				$this->fields_values[] = array(
								1,     
								"0317",    
								"",
								"",
								$list[$i]['hard_kanrino'],
								"",
								"",
								"",
								"",
								"",
								"",
								@$list[$i]['sosiki_pkey'],
								"",
								false,
								date("Y-m-d H:i:s"),
								date("Y-m-d H:i:s"),
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								$list[$i]['hard_kanrino'],
								$list[$i]['hard_kanrino'],
								"",
								"",
								"",
								$list[$i]['hard_kanrino'],
								$list[$i]['hard_kanrino'],
								"",
								"",
								"",
								"",
								""
						      );
			}
		}
		unset($list);
	}
	
	function error_mail_send(){
		$mail_tpl = new Template;
		$email = new Sendmail;
		$list = $this->db->dbSelect("select * from bat_log where end_date is null", "list");
		if(count($list) > 0){
			$message = "";
			for($i=0; $i<count($list); $i++){
				$message .= "異常終了: ".$list[$i]['title']."\n";
			}
			$mail_tpl->assignHtml('error_message',$message);
			$body = $mail_tpl->fetchHtml('mail/bat_error.html');
			$subject = "【情報資産管理システム】夜間バッチ異常終了";
			$email->email(_ERROR_EMAIL, _ADMIN_EMAIL, $subject, $body);
		}
	}

	//バッチログセット
	function set_bat_log($pkey){
		$where_date = "bat_pkey = ".$pkey;
		$fields_values = array(
				"end_date"     => date("Y/m/d H:i:s")
		);
		$this->db->dbUpdate("bat_log", $fields_values, $where_date);
	}
	
	function sogo_test($param){
		$where = " where hardwareno = '".$param[0]."'";
		$list = $this->db->dbSelect("select * from tmp_inventory_detail".$where, "list");
		unset($this->inv_fields_values);
		$this->inv_check($list);
		unset($list);
		if(count(@$this->fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO sogocheck_tmp (sogochk_type,err_pkey,inv_list,inv_detail,hard_hardno,soft_hardno,soft_licenceno,soft_program,licence_licenceno,licence_program,licencelist_program,sosiki1,sosiki2,sysyem_user,start_date,check_date,msg_val1,msg_val2,msg_val3,msg_val4,msg_val5,msg_val6,msg_val7,spt_val1,spt_val2,spt_val3,spt_val4,spt_val5,mail_val1,mail_val2,mail_val3,mail_val4,mail_val5,mail_val6,mail_val7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $this->fields_values);
			unset($this->fields_values);
		}
print "sogo_end ".$param[0]."\n";
		if(count(@$this->inv_fields_values) >= 1){
			$this->db->dbPrepare("INSERT INTO inventorysoft_ext (insapno,inv_soft_reg,inv_soft_exempt) VALUES (?,?,?)", $this->inv_fields_values);
			unset($this->inv_fields_values);
		}
print "ext_end ".$param[0]."\n";
	}

}

?>