<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** ソフトウェア台帳管理 */
class SoftwareModel extends Model{

	/**
	 * ﾕｰｻﾞｰcode(登録者)
	 * @var int
	 */
	var $authuser_code;

	/**
	 * 一覧
	 */
	function index(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
			$_REQUEST['search_haiki'] = "on";
			$_REQUEST['search_hard_haiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);
		$this->tpl->assignHtml('search_haiki',@$_REQUEST['search_haiki']);
		$this->tpl->assignHtml('search_hard_haiki',@$_REQUEST['search_hard_haiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "sosiki_sortkey";
			$sort_default = true;
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);
		
		if(@$sort_default){
			$order = " order by sosiki_sortkey,hard_kanrino,soft_name";
		}else{
			$order = " order by ".$this->sort." ".$this->asc;
		}

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "002";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "sosiki_fullname";
				        break;
				    case "002":
					$s_col = "hard_kanrino";
				        break;
				    case "003":
					$s_col = "use_name";
				        break;
				    case "004":
					$s_col = "licence_kanrino";
				        break;
				    case "005":
					$s_col = "soft_name";
				        break;
				    case "006":
					$s_col = "licence_keitai_name";
				        break;
				    case "007":
					$s_col = "licencelist_pkey";
				        break;
				    case "008":
					$s_col = "bikou";
				        break;
				    case "009":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "010":
					$s_col = "haiki_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "011":
					$s_col = "hard_kotei_name";
				        break;
				    case "012":
					$s_col = "edition";
				        break;
				    case "013":
					$s_col = "upgrade_name";
				        break;
				    case "014":
					$s_col = "memo";
				        break;
				    case "015":
					$s_col = "downgrade_name";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= ") and newkbn <> 1";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";

		if(@$_REQUEST['search_haiki'] == "on"){
			$where .= " and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";
		}
		if(@$_REQUEST['search_hard_haiki'] == "on"){
			$where .= " and (hard_haiki_date > '".date("Y/m/d")."' or hard_haiki_date is null )";
		}

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM soft_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi($list['count'], $count, $url, $param);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM soft_detail".$where.$order.$limit, "list");

			/** プログラムの追加と削除での表示 */
			for($i=0; $i<count($list_limit); $i++){
				if($list_limit[$i]['downgrade'] == "d001"){
					$program_add_del_table = "licencelistprogram_down";
				}else{
					$program_add_del_table = "licencelistprogram";
				}
				$program_where = " where licence.licence_pkey = ".$list_limit[$i]['licence_pkey'];
				$licence_program = $this->db->dbSelect("SELECT lp.program_add_del from licence left join ".$program_add_del_table." lp on licence.licencelist_pkey = lp.licencelist_pkey".$program_where, "list");
				$licence_program_list = array();
				for($j=0; $j<count($licence_program); $j++){
					$licence_program_list[$j] = $licence_program[$j]['program_add_del'];
				}
				
				$inv_where = " where hardwareno = '".$list_limit[$i]['hard_kanrino']."'";
				$inv_order = " order by insapname";
				$inv_soft = $this->db->dbSelect("SELECT insapname from inventorysoft".$inv_where.$inv_order, "list");
				$program_name_array = array();
				for($k=0; $k<count($inv_soft); $k++){
					if(in_array($inv_soft[$k]['insapname'],$licence_program_list)){
						$program_name_array[] = $inv_soft[$k]['insapname'];
					}
				}
				$list_limit[$i]['program_add_del'] = $program_name_array;

				if(in_array($list_limit[$i]['sosiki_pkey'],$child_array)){
					$list_limit[$i]['app_edit_ok'] = true;
				}else{
					$list_limit[$i]['app_edit_ok'] = false;
				}
				
			}

			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/list.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * 新規追加
	 * 入力
	 */
	function app_reg(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			
			for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
				$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
				$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
				$version_name         = "version".$_SESSION['input']['licence_no'][$i];
				$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
				$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
				$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
				$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
				$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
			
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}

			if(count(@$licence_pkey) > 0){
				$in_key = implode(",",$licence_pkey);
				$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$licence = array();
			}
			if(count($licence) > 0){
				for($i=0; $i<count($licence); $i++){
					$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
					$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
					$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
					$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
					$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
					$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
					$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
					$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
						$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$list = $licence;
			
			for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
				$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
				$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
				$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
				$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
				$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
				$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
				$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
				$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
			
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}
			if(count(@$d_licence_pkey) > 0){
				$in_key = implode(",",$d_licence_pkey);
				$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$d_licence = array();
			}
			if(count($d_licence) > 0){
				for($i=0; $i<count($d_licence); $i++){
					$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
					$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
					$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
					$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
					$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
					$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
					$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
					$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
						$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$d_licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$del_list = $d_licence;

			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			if(@$_REQUEST['hard_kanrino']){
				$hard_detail = $this->db->dbSelect("SELECT * FROM hard_detail where hard_kanrino = '".$_REQUEST['hard_kanrino']."'", "detail");
				$item['hard_pkey'] = $hard_detail['hard_pkey'];
				$item['hard_kanrino'] = $hard_detail['hard_kanrino'];
				$item['use_name'] = $hard_detail['use_name'];
			}
			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");

			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;

			$item['sinsei_date'] = date("Y/m/d H:i");
			$item['sinseisyozoku'] = $detail['sosiki_pkey'];
			$licence = array();
		
			$user_referer = _USER_REFERER;
		}
		/** 出力 */
		$this->tpl->assignHtml('list_view',   $licence);
		$this->tpl->assignHtml('del_list_view', @$del_list);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 確認
	 */
	function app_reg_conf(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		
		for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
			$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
			$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
			$version_name         = "version".$_SESSION['input']['licence_no'][$i];
			$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
			$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
			$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
			$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
			$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
		
			$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
			
			$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
		}

		if(count(@$licence_pkey) > 0){
			$in_key = implode(",",$licence_pkey);
			$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$licence = array();
		}
		if(count($licence) > 0){
			for($i=0; $i<count($licence); $i++){
				$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
				$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
				$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
				$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
				$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
				$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
				$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
				$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
					$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$licence[$i]['downgrade']       = "d002";
				}
			}
		}
		$list = $licence;
		
		for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
			$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
			$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
			$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
			$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
			$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
			$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
			$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
			$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
		
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
			
			$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
		}
		if(count(@$d_licence_pkey) > 0){
			$in_key = implode(",",$d_licence_pkey);
			$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$d_licence = array();
		}
		if(count($d_licence) > 0){
			for($i=0; $i<count($d_licence); $i++){
				$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
				$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
				$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
				$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
				$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
				$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
				$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
				$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
				if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
					$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$d_licence[$i]['downgrade']       = "d002";
				}
			}
		}
		$del_list = $d_licence;

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_reg";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
		}
		/** 出力 */
		$this->tpl->assignHtml('list_view',   @$list);
		$this->tpl->assignHtml('del_list_view', @$del_list);
		$this->tpl->assignHtml('list',   $detail_hard);
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 登録
	 */
	function app_reg_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_reg";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			/** 登録 */
			$soft_pkey_array = array();
			$shinsei_no = "";
			$licence_no = array();
			if(count(@$_SESSION['input']['licence_no']) > 0){
				for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
					$licence_no[] = array(
								"licence_pkey_name"	=>"licence_pkey".$_SESSION['input']['licence_no'][$i],
								"soft_pkey_name"	=>"soft_pkey".$_SESSION['input']['licence_no'][$i],
								"version_name"		=>"version".$_SESSION['input']['licence_no'][$i],
								"memo_name"		=>"memo".$_SESSION['input']['licence_no'][$i],
								"bikou_name"		=>"bikou".$_SESSION['input']['licence_no'][$i],
								"downgrade_name"	=>"downgrade".$_SESSION['input']['licence_no'][$i],
								"tyoutatu_date_name"	=>"tyoutatu_date".$_SESSION['input']['licence_no'][$i],
								"haiki_date_name"	=>"haiki_date".$_SESSION['input']['licence_no'][$i],
								);
				}
			}
			if(count(@$_SESSION['input']['d_licence_no']) > 0){
				for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
					$licence_no[] = array(
								"licence_pkey_name"	=>"d_licence_pkey".$_SESSION['input']['d_licence_no'][$i],
								"soft_pkey_name"	=>"d_soft_pkey".$_SESSION['input']['d_licence_no'][$i],
								"version_name"		=>"d_version".$_SESSION['input']['d_licence_no'][$i],
								"memo_name"		=>"d_memo".$_SESSION['input']['d_licence_no'][$i],
								"bikou_name"		=>"d_bikou".$_SESSION['input']['d_licence_no'][$i],
								"downgrade_name"	=>"d_downgrade".$_SESSION['input']['d_licence_no'][$i],
								"tyoutatu_date_name"	=>"d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i],
								"haiki_date_name"	=>"d_haiki_date".$_SESSION['input']['d_licence_no'][$i],
								);
				}
			}

			if(count(@$licence_no) > 0){
				for($i=0; $i<count($licence_no); $i++){
					$licence_pkey		= $licence_no[$i]['licence_pkey_name'];
					$soft_pkey		= $licence_no[$i]['soft_pkey_name'];
					$version		= $licence_no[$i]['version_name'];
					$memo			= $licence_no[$i]['memo_name'];
					$bikou			= $licence_no[$i]['bikou_name'];
					$downgrade		= $licence_no[$i]['downgrade_name'];
					$tyoutatu_date		= $licence_no[$i]['tyoutatu_date_name'];
					$haiki_date		= $licence_no[$i]['haiki_date_name'];

					if($_SESSION['input'][$version] == ""){
						$_SESSION['input'][$version] = 1;
					}
					if($_SESSION['input'][$soft_pkey] == ""){
						$fields_values = array(
								"hard_pkey"            => $_SESSION['input']['hard_pkey'], 
								"licence_pkey"         => $_SESSION['input'][$licence_pkey],     
								"bikou"                => $_SESSION['input'][$bikou], 
								"downgrade"            => $_SESSION['input'][$downgrade], 
								"install_date"         => $_SESSION['input'][$tyoutatu_date],
								"uninstall_date"       => $_SESSION['input'][$haiki_date],
								"memo"                 => @$_SESSION['input'][$memo],
								"version"              => 1, 
								"newkbn"               => 1 
								      );
						$pkey = $this->db->dbInsert("\"soft\"", $fields_values);
					}else{
						$soft_pkey_array[] = $_SESSION['input'][$soft_pkey];
						$pkey = $_SESSION['input'][$soft_pkey];
						if($this->authuser_authority != 'system'){
							$detail = $this->db->dbSelect("select * from soft_detail where soft_pkey=".$_SESSION['input'][$soft_pkey], "detail");
							$_SESSION['input'][$memo] = $detail['memo'];
						}
					}

					$fields_values = array(
							"soft_pkey"            => $pkey, 
							"hard_pkey"            => $_SESSION['input']['hard_pkey'], 
							"licence_pkey"         => $_SESSION['input'][$licence_pkey],     
							"bikou"                => $_SESSION['input'][$bikou], 
							"downgrade"            => $_SESSION['input'][$downgrade], 
							"install_date"         => $_SESSION['input'][$tyoutatu_date],
							"uninstall_date"       => $_SESSION['input'][$haiki_date],
							"memo"                 => @$_SESSION['input'][$memo],
							"version"              => $_SESSION['input'][$version]
							      );

					$code = $this->db->dbInsert("\"softrireki\"", $fields_values);

					if($shinsei_no == ""){
						$shinsei_no = $code;
					}
					$fields_values = array(
							"history_pkey"         => $code,     
							"history_type"         => "d002",     
							"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
							"sinseisya"            => $_SESSION['input']['sinseisya'], 
							"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'], 
							"email_ad"             => $_SESSION['input']['email_ad'],
							"shinsei_no"           => $shinsei_no
							      );
					$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);
				}
			}

			$mail_tpl = new Template;
			$email = new Sendmail;
		
			$mail_tpl->assignHtml('sinseisya',$_SESSION['input']['sinseisya']);
			$mail_tpl->assignHtml('sinsei_date',$_SESSION['input']['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ソフトウェア台帳");
			$mail_tpl->assignHtml('action',_ACTION_APPADD);

			$body = $mail_tpl->fetchHtml('mail/sinsei.html');
			$subject = "【情報資産管理システム】ソフトウェア台帳　"._ACTION_APPADD;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$sosiki_pkey = $detail['sosiki_pkey'];
			
			$list = $this->db->dbSelect("SELECT * FROM user_detail where (auth = 'd003' or auth = 'd004') and sosiki_pkey = ".$sosiki_pkey, "list");
			for($i=0; $i<count(@$list); $i++){
				$email_ad = explode("\n",$list[$i]['email_ad']);
				for($j=0; $j<count($email_ad); $j++){
//					$email->email($email_ad[$j], _ADMIN_EMAIL, $subject, $body);
				}
			}
		}
		
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['hard_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 編集
	 * 入力
	 */
	function app_edit(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			
			for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
				$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
				$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
				$version_name         = "version".$_SESSION['input']['licence_no'][$i];
				$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
				$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
				$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
				$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
				$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
			
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}

			if(count(@$licence_pkey) > 0){
				$in_key = implode(",",$licence_pkey);
				$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$licence = array();
			}
			if(count($licence) > 0){
				for($i=0; $i<count($licence); $i++){
					$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
					$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
					$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
					$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
					$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
					$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
					$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
					$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
						$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$list = $licence;
			
			for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
				$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
				$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
				$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
				$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
				$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
				$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
				$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
				$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
			
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}
			if(count(@$d_licence_pkey) > 0){
				$in_key = implode(",",$d_licence_pkey);
				$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$d_licence = array();
			}
			if(count($d_licence) > 0){
				for($i=0; $i<count($d_licence); $i++){
					$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
					$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
					$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
					$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
					$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
					$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
					$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
					$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
						$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$d_licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$del_list = $d_licence;

			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$soft_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$soft_detail = $this->db->dbSelect("select * from soft_detail where soft_pkey='".$soft_pkey."'", "detail");
			
			//組織認証
			$this->sosiki_auth(array($soft_detail['sosiki_pkey']));
			
			if(count($soft_detail) > 0){
				$hard_detail = $this->db->dbSelect("select * from hard_detail where hard_pkey='".$soft_detail['hard_pkey']."'", "detail");
				if(count($hard_detail) > 0){
					$item    = $hard_detail;
					$list = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$hard_detail['hard_pkey']."' and (haiki_date > '".date("Y/m/d")."' or haiki_date is null) and newkbn <> 1 order by licence_kanrino", "list");
					if(count($list) > 0){
						for($i=0; $i<count($list); $i++){
							if($list[$i]['downgrade'] == "" or is_null($list[$i]['downgrade'])){
								$list[$i]['downgrade'] = "d002";
							}
						}
					}
					$del_list = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$hard_detail['hard_pkey']."' and haiki_date <= '".date("Y/m/d")."' and newkbn <> 1 order by licence_kanrino", "list");
					if(count($del_list) > 0){
						for($i=0; $i<count($del_list); $i++){
							if($del_list[$i]['downgrade'] == "" or is_null($del_list[$i]['downgrade'])){
								$del_list[$i]['downgrade'] = "d002";
							}
						}
					}
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i");
			$item['sinseisyozoku'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('list_view', @$list);
		$this->tpl->assignHtml('del_list_view', @$del_list);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認app_print
	 */
	function app_edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		
		for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
			$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
			$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
			$version_name         = "version".$_SESSION['input']['licence_no'][$i];
			$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
			$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
			$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
			$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
			$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
		
			$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
			
			$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
		}

		if(count(@$licence_pkey) > 0){
			$in_key = implode(",",$licence_pkey);
			$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$licence = array();
		}
		if(count($licence) > 0){
			for($i=0; $i<count($licence); $i++){
				$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
				$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
				$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
				$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
				$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
				$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
				$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
				$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
					$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$licence[$i]['downgrade']       = "d002";
				}
			}
		}
		$list = $licence;
		
		for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
			$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
			$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
			$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
			$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
			$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
			$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
			$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
			$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
		
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
			
			$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
		}
		if(count(@$d_licence_pkey) > 0){
			$in_key = implode(",",$d_licence_pkey);
			$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$d_licence = array();
		}
		if(count($d_licence) > 0){
			for($i=0; $i<count($d_licence); $i++){
				$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
				$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
				$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
				$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
				$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
				$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
				$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
				$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
				if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
					$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$d_licence[$i]['downgrade']       = "d002";
				}
			}
		}
		$del_list = $d_licence;

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
		}
		/** 出力 */
		$this->tpl->assignHtml('list_view',   $list);
		$this->tpl->assignHtml('del_list_view',   $del_list);
		$this->tpl->assignHtml('list',   $detail_hard);
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function app_edit_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			/** 登録 */
			$soft_pkey_array = array();
			$shinsei_no = "";
			$licence_no = array();
			if(count(@$_SESSION['input']['licence_no']) > 0){
				for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
					$licence_no[] = array(
								"licence_pkey_name"	=>"licence_pkey".$_SESSION['input']['licence_no'][$i],
								"soft_pkey_name"	=>"soft_pkey".$_SESSION['input']['licence_no'][$i],
								"version_name"		=>"version".$_SESSION['input']['licence_no'][$i],
								"memo_name"		=>"memo".$_SESSION['input']['licence_no'][$i],
								"bikou_name"		=>"bikou".$_SESSION['input']['licence_no'][$i],
								"downgrade_name"	=>"downgrade".$_SESSION['input']['licence_no'][$i],
								"tyoutatu_date_name"	=>"tyoutatu_date".$_SESSION['input']['licence_no'][$i],
								"haiki_date_name"	=>"haiki_date".$_SESSION['input']['licence_no'][$i],
								);
				}
			}
			if(count(@$_SESSION['input']['d_licence_no']) > 0){
				for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
					$licence_no[] = array(
								"licence_pkey_name"	=>"d_licence_pkey".$_SESSION['input']['d_licence_no'][$i],
								"soft_pkey_name"	=>"d_soft_pkey".$_SESSION['input']['d_licence_no'][$i],
								"version_name"		=>"d_version".$_SESSION['input']['d_licence_no'][$i],
								"memo_name"		=>"d_memo".$_SESSION['input']['d_licence_no'][$i],
								"bikou_name"		=>"d_bikou".$_SESSION['input']['d_licence_no'][$i],
								"downgrade_name"	=>"d_downgrade".$_SESSION['input']['d_licence_no'][$i],
								"tyoutatu_date_name"	=>"d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i],
								"haiki_date_name"	=>"d_haiki_date".$_SESSION['input']['d_licence_no'][$i],
								);
				}
			}

			if(count(@$licence_no) > 0){
				for($i=0; $i<count($licence_no); $i++){
					$licence_pkey		= $licence_no[$i]['licence_pkey_name'];
					$soft_pkey		= $licence_no[$i]['soft_pkey_name'];
					$version		= $licence_no[$i]['version_name'];
					$memo			= $licence_no[$i]['memo_name'];
					$bikou			= $licence_no[$i]['bikou_name'];
					$downgrade		= $licence_no[$i]['downgrade_name'];
					$tyoutatu_date		= $licence_no[$i]['tyoutatu_date_name'];
					$haiki_date		= $licence_no[$i]['haiki_date_name'];

					if($_SESSION['input'][$version] == ""){
						$_SESSION['input'][$version] = 1;
					}
					if($_SESSION['input'][$soft_pkey] == ""){
						$fields_values = array(
								"hard_pkey"            => $_SESSION['input']['hard_pkey'], 
								"licence_pkey"         => $_SESSION['input'][$licence_pkey],     
								"bikou"                => $_SESSION['input'][$bikou], 
								"downgrade"            => $_SESSION['input'][$downgrade], 
								"install_date"         => $_SESSION['input'][$tyoutatu_date],
								"uninstall_date"       => $_SESSION['input'][$haiki_date],
								"memo"                 => @$_SESSION['input'][$memo],
								"version"              => 1, 
								"newkbn"               => 1 
								      );
						$pkey = $this->db->dbInsert("\"soft\"", $fields_values);
					}else{
						$soft_pkey_array[] = $_SESSION['input'][$soft_pkey];
						$pkey = $_SESSION['input'][$soft_pkey];
						if($this->authuser_authority != 'system'){
							$detail = $this->db->dbSelect("select * from soft_detail where soft_pkey=".$_SESSION['input'][$soft_pkey], "detail");
							$_SESSION['input'][$memo] = $detail['memo'];
						}
					}

					$fields_values = array(
							"soft_pkey"            => $pkey, 
							"hard_pkey"            => $_SESSION['input']['hard_pkey'], 
							"licence_pkey"         => $_SESSION['input'][$licence_pkey],     
							"bikou"                => $_SESSION['input'][$bikou], 
							"downgrade"            => $_SESSION['input'][$downgrade], 
							"install_date"         => $_SESSION['input'][$tyoutatu_date],
							"uninstall_date"       => $_SESSION['input'][$haiki_date],
							"memo"                 => @$_SESSION['input'][$memo],
							"version"              => $_SESSION['input'][$version]
							      );

					$code = $this->db->dbInsert("\"softrireki\"", $fields_values);

					if($shinsei_no == ""){
						$shinsei_no = $code;
					}
					$fields_values = array(
							"history_pkey"         => $code,     
							"history_type"         => "d002",     
							"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
							"sinseisya"            => $_SESSION['input']['sinseisya'], 
							"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'], 
							"email_ad"             => $_SESSION['input']['email_ad'],
							"shinsei_no"           => $shinsei_no
							      );
					$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);
				}
			}

			$mail_tpl = new Template;
			$email = new Sendmail;
		
			$mail_tpl->assignHtml('sinseisya',$_SESSION['input']['sinseisya']);
			$mail_tpl->assignHtml('sinsei_date',$_SESSION['input']['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ソフトウェア台帳");
			$mail_tpl->assignHtml('action',_ACTION_APPEDIT);

			$body = $mail_tpl->fetchHtml('mail/sinsei.html');
			$subject = "【情報資産管理システム】ソフトウェア台帳　"._ACTION_APPEDIT;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$sosiki_pkey = $detail['sosiki_pkey'];
			
			$list = $this->db->dbSelect("SELECT * FROM user_detail where (auth = 'd003' or auth = 'd004') and sosiki_pkey = ".$sosiki_pkey, "list");
			for($i=0; $i<count(@$list); $i++){
				$email_ad = explode("\n",$list[$i]['email_ad']);
				for($j=0; $j<count($email_ad); $j++){
//					$email->email($email_ad[$j], _ADMIN_EMAIL, $subject, $body);
				}
			}
		}
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$detail_hard['hard_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 編集
	 * 入力
	 */
	function app_copy(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
				$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
				$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
				$version_name         = "version".$_SESSION['input']['licence_no'][$i];
				$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
				$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
				$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
				$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
				$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
			
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}

			if(count(@$licence_pkey) > 0){
				$in_key = implode(",",$licence_pkey);
				$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$licence = array();
			}
			if(count($licence) > 0){
				for($i=0; $i<count($licence); $i++){
					$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
					$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
					$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
					$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
					$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
					$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
					$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
					$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
						$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$list = $licence;
			
			for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
				$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
				$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
				$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
				$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
				$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
				$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
				$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
				$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
			
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}
			if(count(@$d_licence_pkey) > 0){
				$in_key = implode(",",$d_licence_pkey);
				$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$d_licence = array();
			}
			if(count($d_licence) > 0){
				for($i=0; $i<count($d_licence); $i++){
					$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
					$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
					$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
					$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
					$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
					$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
					$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
					$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
						$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$d_licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$del_list = $d_licence;
			
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$soft_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$soft_detail = $this->db->dbSelect("select * from soft_detail where soft_pkey='".$soft_pkey."'", "detail");
			
			//組織認証
			$this->sosiki_auth(array($soft_detail['sosiki_pkey']));
			
			if(count($soft_detail) > 0){
				$hard_detail = $this->db->dbSelect("select * from hard_detail where hard_pkey='".$soft_detail['hard_pkey']."'", "detail");
				if(count($hard_detail) > 0){
					$item    = $hard_detail;
					$list = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$hard_detail['hard_pkey']."' and (haiki_date > '".date("Y/m/d")."' or haiki_date is null) and newkbn <> 1 order by licence_kanrino", "list");
					if(count($list) > 0){
						for($i=0; $i<count($list); $i++){
							if($list[$i]['downgrade'] == "" or is_null($list[$i]['downgrade'])){
								$list[$i]['downgrade'] = "d002";
							}
						}
					}
					$del_list = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$hard_detail['hard_pkey']."' and haiki_date <= '".date("Y/m/d")."' and newkbn <> 1 order by licence_kanrino", "list");
					if(count($del_list) > 0){
						for($i=0; $i<count($del_list); $i++){
							if($del_list[$i]['downgrade'] == "" or is_null($del_list[$i]['downgrade'])){
								$del_list[$i]['downgrade'] = "d002";
							}
						}
					}
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i");
			$item['sinseisyozoku'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('list_view', @$list);
		$this->tpl->assignHtml('del_list_view', @$del_list);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 修正申請
	 * 入力
	 */
	function app_modify(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			if($item['soft_pkey'] != ""){
				$action_param = 'app_edit';
			}else{
				$action_param = 'app_reg';
			}
			for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
				$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
				$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
				$version_name         = "version".$_SESSION['input']['licence_no'][$i];
				$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
				$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
				$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
				$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
				$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
			
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}

			if(count(@$licence_pkey) > 0){
				$in_key = implode(",",$licence_pkey);
				$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$licence = array();
			}
			if(count($licence) > 0){
				for($i=0; $i<count($licence); $i++){
					$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
					$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
					$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
					$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
					$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
					$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
					$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
					$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
						$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$list = $licence;
			
			for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
				$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
				$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
				$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
				$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
				$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
				$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
				$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
				$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
			
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}
			if(count(@$d_licence_pkey) > 0){
				$in_key = implode(",",$d_licence_pkey);
				$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$d_licence = array();
			}
			if(count($d_licence) > 0){
				for($i=0; $i<count($d_licence); $i++){
					$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
					$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
					$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
					$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
					$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
					$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
					$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
					$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
						$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$d_licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$del_list = $d_licence;
			
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$detail_history = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".addslashes(@$_REQUEST['code']), "detail");
			$softhistory_pkey = $detail_history['shinsei_no'];
			/** 詳細ﾃﾞｰﾀ */
			$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");
			
			//組織認証
			$this->sosiki_auth(array($soft_detail['sinseisyozoku']));
			
			if(count($soft_detail) > 0){
				$hard_detail = $this->db->dbSelect("select * from hard_detail where hard_pkey='".$soft_detail['hard_pkey']."'", "detail");
				if(count($hard_detail) > 0){
					$item			= $hard_detail;

					$soft_list = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where shinsei_no = '".$softhistory_pkey."' and hard_pkey is not null order by licence_kanrino", "list");
					if(count($soft_list) > 0){
						for($i=0; $i<count($soft_list); $i++){
							if($soft_list[$i]['downgrade'] == "" or is_null($soft_list[$i]['downgrade'])){
								$soft_list[$i]['downgrade'] = "d002";
							}
							$old_soft = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".$soft_list[$i]['soft_pkey']." and newkbn <> 1", "detail");
							if(@$old_soft['soft_pkey']){
								$soft_list[$i]['version'] = @$old_soft['version'];
							}else{
								$soft_list[$i]['soft_pkey'] = "";
								$soft_list[$i]['version']   = "";
							}
							if(strtotime(@$old_soft['haiki_date']) > strtotime(date('Y/m/d')) or @$old_soft['haiki_date'] == null){
								$list[] = $soft_list[$i];
							}else{
								$del_list[] = $soft_list[$i];
							}
						}
					}
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i");
			$item['sinseisyozoku'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('list_view', @$list);
		$this->tpl->assignHtml('del_list_view', @$del_list);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 入力
	 */
	function edit(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			
			for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
				$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
				$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
				$version_name         = "version".$_SESSION['input']['licence_no'][$i];
				$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
				$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
				$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
				$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
				$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
			
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}

			if(count(@$licence_pkey) > 0){
				$in_key = implode(",",$licence_pkey);
				$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$licence = array();
			}
			if(count($licence) > 0){
				for($i=0; $i<count($licence); $i++){
					$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
					$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
					$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
					$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
					$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
					$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
					$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
					$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
						$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$list = $licence;
			
			for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
				$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
				$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
				$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
				$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
				$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
				$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
				$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
				$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
			
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
				$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
				
				$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
			}
			if(count(@$d_licence_pkey) > 0){
				$in_key = implode(",",$d_licence_pkey);
				$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
			}else{
				$d_licence = array();
			}
			if(count($d_licence) > 0){
				for($i=0; $i<count($d_licence); $i++){
					$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
					$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
					$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
					$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
					$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
					$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
					$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
					$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
						$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
					}else{
						$d_licence[$i]['downgrade']       = "d002";
					}
				}
			}
			$del_list = $d_licence;

			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$soft_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$soft_detail = $this->db->dbSelect("select * from soft_detail where soft_pkey='".$soft_pkey."'", "detail");
			
			//組織認証
			$this->sosiki_auth(array($soft_detail['sosiki_pkey']));
			
			if(count($soft_detail) > 0){
				$hard_detail = $this->db->dbSelect("select * from hard_detail where hard_pkey='".$soft_detail['hard_pkey']."'", "detail");
				if(count($hard_detail) > 0){
					$item    = $hard_detail;
					$list = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$hard_detail['hard_pkey']."' and (haiki_date > '".date("Y/m/d")."' or haiki_date is null) and newkbn <> 1 order by licence_kanrino", "list");
					if(count($list) > 0){
						for($i=0; $i<count($list); $i++){
							if($list[$i]['downgrade'] == "" or is_null($list[$i]['downgrade'])){
								$list[$i]['downgrade'] = "d002";
							}
						}
					}
					$del_list = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$hard_detail['hard_pkey']."' and haiki_date <= '".date("Y/m/d")."' and newkbn <> 1 order by licence_kanrino", "list");
					if(count($del_list) > 0){
						for($i=0; $i<count($del_list); $i++){
							if($del_list[$i]['downgrade'] == "" or is_null($del_list[$i]['downgrade'])){
								$del_list[$i]['downgrade'] = "d002";
							}
						}
					}
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('list_view', @$list);
		$this->tpl->assignHtml('del_list_view', @$del_list);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認
	 */
	function edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
			$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
			$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
			$version_name         = "version".$_SESSION['input']['licence_no'][$i];
			$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
			$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
			$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
			$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
			$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
		
			$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
			
			$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
		}

		if(count(@$licence_pkey) > 0){
			$in_key = implode(",",$licence_pkey);
			$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$licence = array();
		}
		if(count($licence) > 0){
			for($i=0; $i<count($licence); $i++){
				$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
				$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
				$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
				$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
				$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
				$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
				$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
				$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
					$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$licence[$i]['downgrade']       = "d002";
				}
			}
		}
		$list = $licence;
		
		for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
			$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
			$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
			$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
			$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
			$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
			$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
			$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
			$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
		
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
			
			$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
		}
		if(count(@$d_licence_pkey) > 0){
			$in_key = implode(",",$d_licence_pkey);
			$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$d_licence = array();
		}
		if(count($d_licence) > 0){
			for($i=0; $i<count($d_licence); $i++){
				$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
				$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
				$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
				$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
				$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
				$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
				$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
				$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
				if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
					$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$d_licence[$i]['downgrade']       = "d002";
				}
			}
		}
		$del_list = $d_licence;

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
		}
		/** 出力 */
		$this->tpl->assignHtml('list_view',   $list);
		$this->tpl->assignHtml('del_list_view',   $del_list);
		$this->tpl->assignHtml('list',   $detail_hard);
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function edit_done(){
		$page_name = "system";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			/** 登録 */
			$soft_pkey_array = array();
			$shinsei_no = "";
			$licence_no = array();
			if(count(@$_SESSION['input']['licence_no']) > 0){
				for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
					$licence_no[] = array(
								"licence_pkey_name"	=>"licence_pkey".$_SESSION['input']['licence_no'][$i],
								"soft_pkey_name"	=>"soft_pkey".$_SESSION['input']['licence_no'][$i],
								"version_name"		=>"version".$_SESSION['input']['licence_no'][$i],
								"memo_name"		=>"memo".$_SESSION['input']['licence_no'][$i],
								"bikou_name"		=>"bikou".$_SESSION['input']['licence_no'][$i],
								"downgrade_name"	=>"downgrade".$_SESSION['input']['licence_no'][$i],
								"tyoutatu_date_name"	=>"tyoutatu_date".$_SESSION['input']['licence_no'][$i],
								"haiki_date_name"	=>"haiki_date".$_SESSION['input']['licence_no'][$i],
								);
				}
			}
			if(count(@$_SESSION['input']['d_licence_no']) > 0){
				for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
					$licence_no[] = array(
								"licence_pkey_name"	=>"d_licence_pkey".$_SESSION['input']['d_licence_no'][$i],
								"soft_pkey_name"	=>"d_soft_pkey".$_SESSION['input']['d_licence_no'][$i],
								"version_name"		=>"d_version".$_SESSION['input']['d_licence_no'][$i],
								"memo_name"		=>"d_memo".$_SESSION['input']['d_licence_no'][$i],
								"bikou_name"		=>"d_bikou".$_SESSION['input']['d_licence_no'][$i],
								"downgrade_name"	=>"d_downgrade".$_SESSION['input']['d_licence_no'][$i],
								"tyoutatu_date_name"	=>"d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i],
								"haiki_date_name"	=>"d_haiki_date".$_SESSION['input']['d_licence_no'][$i],
								);
				}
			}

			if(count(@$licence_no) > 0){
				for($i=0; $i<count($licence_no); $i++){
					$licence_pkey		= $licence_no[$i]['licence_pkey_name'];
					$soft_pkey		= $licence_no[$i]['soft_pkey_name'];
					$version		= $licence_no[$i]['version_name'];
					$memo			= $licence_no[$i]['memo_name'];
					$bikou			= $licence_no[$i]['bikou_name'];
					$downgrade		= $licence_no[$i]['downgrade_name'];
					$tyoutatu_date		= $licence_no[$i]['tyoutatu_date_name'];
					$haiki_date		= $licence_no[$i]['haiki_date_name'];

					if($_SESSION['input'][$version] == ""){
						$_SESSION['input'][$version] = 1;
					}
					if($_SESSION['input'][$soft_pkey] == ""){
						$fields_values = array(
								"hard_pkey"            => $_SESSION['input']['hard_pkey'], 
								"licence_pkey"         => $_SESSION['input'][$licence_pkey],     
								"bikou"                => $_SESSION['input'][$bikou], 
								"downgrade"            => $_SESSION['input'][$downgrade], 
								"install_date"         => $_SESSION['input'][$tyoutatu_date],
								"uninstall_date"       => $_SESSION['input'][$haiki_date],
								"memo"                 => @$_SESSION['input'][$memo],
								"version"              => 1, 
								"newkbn"               => 0 
								      );
						$pkey = $this->db->dbInsert("\"soft\"", $fields_values);
					}else{
						$soft_pkey = addslashes($_SESSION['input'][$soft_pkey]);
						$where = "soft_pkey = ".$soft_pkey;

						$fields_values = array(
								"hard_pkey"            => $_SESSION['input']['hard_pkey'], 
								"licence_pkey"         => $_SESSION['input'][$licence_pkey],     
								"bikou"                => $_SESSION['input'][$bikou], 
								"downgrade"            => $_SESSION['input'][$downgrade], 
								"install_date"         => $_SESSION['input'][$tyoutatu_date],
								"uninstall_date"       => $_SESSION['input'][$haiki_date],
								"memo"                 => $_SESSION['input'][$memo],
								"version"              => $_SESSION['input'][$version]
								      );
						$this->db->dbUpdate("\"soft\"", $fields_values, $where);
					}
				}
			}
		}
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('massage',  "保守が完了しました。");
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$detail_hard['hard_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}


	/**
	 * 申請
	 * 取下
	 */
	function app_del(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SAGE);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$softhistory_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		/** 詳細ﾃﾞｰﾀ */
		$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");
		
		//組織認証
		$this->sosiki_auth(array($soft_detail['sinseisyozoku']));
		
		if(count($soft_detail) > 0){
			$item    = $soft_detail;
			$_SESSION['input']['shinsei_no'] = $soft_detail['shinsei_no'];
			$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$soft_detail['shinsei_no']." order by licence_kanrino", "list");
			if(count($soft_list) > 0){
				for($i=0; $i<count($soft_list); $i++){
					if($soft_list[$i]['downgrade'] == "" or is_null($soft_list[$i]['downgrade'])){
						$soft_list[$i]['downgrade'] = "d002";
					}
					$version = $soft_list[$i]['version']-1;
					$old_soft = $this->db->dbSelect("select * from soft_rireki_detail where soft_pkey = ".$soft_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
					if(strtotime(@$old_soft['haiki_date']) > strtotime(date('Y/m/d')) or @$old_soft['haiki_date'] == null){
						$list[] = $soft_list[$i];
					}else{
						$del_list[] = $soft_list[$i];
					}
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;

		/** 出力 */
		$this->tpl->assignHtml('list_view', @$list);
		$this->tpl->assignHtml('del_list_view', @$del_list);
		$this->tpl->assignHtml('list',   @$item);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPDEL);
		$this->tpl->assignHtml('action_param','app_del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 申請
	 * 取下
	 */
	function app_del_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$shinsei_no = addslashes(@$_SESSION['input']['shinsei_no']);
		$where = "shinsei_no = ".$shinsei_no;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from soft_rireki_detail where ".$where, "list");
		if(count($detail) > 0){
			for($i=0; $i<count($detail); $i++){
				$where = "history_pkey = ".$detail[$i]['softhistory_pkey']." and history_type = 'd002'";
				/** 取下 */
				$fields_values = array(
						"syonin_kbn"          => 'd003'
						      );
				$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

				$where_list = "soft_pkey = ".$detail[$i]['soft_pkey']." and newkbn = 1";
				$this->db->dbDelete("\"soft\"", $where_list);
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** 出力 */
		$this->tpl->assignHtml('massage',  "取下が完了しました。");
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_APPDEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認
	 * 
	 */
	function app(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SHOUNIN);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$softhistory_pkey = addslashes(@$_SESSION['input']['softhistory_pkey']);
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";

			/** 詳細ﾃﾞｰﾀ */
			$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");
			//組織認証
			$this->sosiki_auth(array($soft_detail['sinseisyozoku']));
	
			if(count($soft_detail) > 0){
				$history = $soft_detail;
				$_SESSION['input']['shinsei_no'] = $soft_detail['shinsei_no'];
				$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$soft_detail['shinsei_no']." order by licence_kanrino", "list");
				if(count($soft_list) > 0){
					for($i=0; $i<count($soft_list); $i++){
						if($soft_list[$i]['downgrade'] == "" or is_null($soft_list[$i]['downgrade'])){
							$soft_list[$i]['downgrade'] = "d002";
						}
						if($soft_list[$i]['tyoutatu_date'] != ""){
							$tyoutatu_date = explode("-",$soft_list[$i]['tyoutatu_date']);
							$soft_list[$i]['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
						}
						if($soft_list[$i]['haiki_date'] != ""){
							$haiki_date = explode("-",$soft_list[$i]['haiki_date']);
							$soft_list[$i]['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
						}
						$version = $soft_list[$i]['version']-1;
						$old_soft = $this->db->dbSelect("select * from soft_rireki_detail where soft_pkey = ".$soft_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
						if(strtotime(@$old_soft['haiki_date']) > strtotime(date('Y/m/d')) or @$old_soft['haiki_date'] == null){
							$list[] = $soft_list[$i];
						}else{
							$del_list[] = $soft_list[$i];
						}
					}
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
		}else{
			$softhistory_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");
	
			//組織認証
			$this->sosiki_auth(array($soft_detail['sinseisyozoku']));
	
			if(count($soft_detail) > 0){
				$history = $soft_detail;
				$_SESSION['input']['shinsei_no'] = $soft_detail['shinsei_no'];
				$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$soft_detail['shinsei_no']." order by licence_kanrino", "list");
				if(count($soft_list) > 0){
					for($i=0; $i<count($soft_list); $i++){
						if($soft_list[$i]['downgrade'] == "" or is_null($soft_list[$i]['downgrade'])){
							$soft_list[$i]['downgrade'] = "d002";
						}
						if($soft_list[$i]['tyoutatu_date'] != ""){
							$tyoutatu_date = explode("-",$soft_list[$i]['tyoutatu_date']);
							$soft_list[$i]['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
						}
						if($soft_list[$i]['haiki_date'] != ""){
							$haiki_date = explode("-",$soft_list[$i]['haiki_date']);
							$soft_list[$i]['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
						}
						$version = $soft_list[$i]['version']-1;
						$old_soft = $this->db->dbSelect("select * from soft_rireki_detail where soft_pkey = ".$soft_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
						if(strtotime(@$old_soft['haiki_date']) > strtotime(date('Y/m/d')) or @$old_soft['haiki_date'] == null){
							$list[] = $soft_list[$i];
						}else{
							$del_list[] = $soft_list[$i];
						}
					}
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$item = $soft_detail;
			$item['syoninsya'] = _DEFAULT_SYONINSYA;
			$item['syonin_date'] = date("Y/m/d H:i");
			$user_referer = _USER_REFERER;
		}

		#導入ライセンス比較
		for($i=0; $i<count(@$list); $i++){
			$version = $list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $list[$i][$val];
					}
				}
				$old = array();
			}
			$licence_cmp[$i]['new'] = @$new;
			$licence_cmp[$i]['old'] = @$old;
		}

		#削除済みライセンス比較
		for($i=0; $i<count(@$del_list); $i++){
			$version = $del_list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$del_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $del_list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$del_list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $del_list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($del_list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $del_list[$i][$val];
					}
				}
				$old = array();
			}
			$d_licence_cmp[$i]['new'] = @$new;
			$d_licence_cmp[$i]['old'] = @$old;
		}


		$version = $history['version']-1;
		$detail = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey=".$history['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
		if($detail['hard_pkey'] != ""){
			#ハードウェア比較
			$check_array = 	array(
						"hard_kanrino",
						"use_name"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if(@$history[$val] == ""){
						$new[$val] = "　";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $history;
		}

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('licence_cmp', @$licence_cmp);
		$this->tpl->assignHtml('d_licence_cmp', @$d_licence_cmp);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APP);
		$this->tpl->assignHtml('action_param','app');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/input_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}
	
	/**
	 * 内容確認
	 * 
	 */
	function app_conf(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_SHOUNIN);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 承認時デフォルト値書換 */
		change_default_syonin(@$_SESSION['input']['syoninsya']);
		$item = $_SESSION['input'];
		$softhistory_pkey = addslashes(@$_SESSION['input']['softhistory_pkey']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app";
		$this->check_app();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}

		/** 詳細ﾃﾞｰﾀ */
		$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");

		//組織認証
		$this->sosiki_auth(array($soft_detail['sinseisyozoku']));

		if(count($soft_detail) > 0){
			$history = $soft_detail;
			$_SESSION['input']['shinsei_no'] = $soft_detail['shinsei_no'];
			$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$soft_detail['shinsei_no']." order by licence_kanrino", "list");
			if(count($soft_list) > 0){
				for($i=0; $i<count($soft_list); $i++){
					if($soft_list[$i]['downgrade'] == "" or is_null($soft_list[$i]['downgrade'])){
						$soft_list[$i]['downgrade'] = "d002";
					}
					if($soft_list[$i]['tyoutatu_date'] != ""){
						$tyoutatu_date = explode("-",$soft_list[$i]['tyoutatu_date']);
						$soft_list[$i]['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
					}
					if($soft_list[$i]['haiki_date'] != ""){
						$haiki_date = explode("-",$soft_list[$i]['haiki_date']);
						$soft_list[$i]['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
					}
					$version = $soft_list[$i]['version']-1;
					$old_soft = $this->db->dbSelect("select * from soft_rireki_detail where soft_pkey = ".$soft_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
					if(strtotime(@$old_soft['haiki_date']) > strtotime(date('Y/m/d')) or @$old_soft['haiki_date'] == null){
						$list[] = $soft_list[$i];
					}else{
						$del_list[] = $soft_list[$i];
					}
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;

		#導入ライセンス比較
		for($i=0; $i<count(@$list); $i++){
			$version = $list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $list[$i][$val];
					}
				}
				$old = array();
			}
			$licence_cmp[$i]['new'] = @$new;
			$licence_cmp[$i]['old'] = @$old;
		}

		#削除済みライセンス比較
		for($i=0; $i<count(@$del_list); $i++){
			$version = $del_list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$del_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $del_list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$del_list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $del_list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($del_list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $del_list[$i][$val];
					}
				}
				$old = array();
			}
			$d_licence_cmp[$i]['new'] = @$new;
			$d_licence_cmp[$i]['old'] = @$old;
		}


		$version = $history['version']-1;
		$detail = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey=".$history['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
		if($detail['hard_pkey'] != ""){
			#ハードウェア比較
			$check_array = 	array(
						"hard_kanrino",
						"use_name"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if(@$history[$val] == ""){
						$new[$val] = "　";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $history;
		}

		$app_col = select_code("00008");
		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('licence_cmp', @$licence_cmp);
		$this->tpl->assignHtml('d_licence_cmp', @$d_licence_cmp);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',$app_col[@$_SESSION['input']['syonin_kbn']]);
		$this->tpl->assignHtml('action_param','app');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 内容確認
	 * 承認・却下
	 */
	function app_done(){
		$page_name = "system,syonin";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$softhistory_pkey = addslashes(@$_SESSION['input']['softhistory_pkey']);
		$syonin_kbn       = addslashes(@$_SESSION['input']['syonin_kbn']);
		$syoninsya        = addslashes(@$_SESSION['input']['syoninsya']);
		$syonin_date      = addslashes(@$_SESSION['input']['syonin_date']);

		/** 詳細ﾃﾞｰﾀ */
		$where = "shinsei_no = ".$_SESSION['input']['shinsei_no'];
		$detail = $this->db->dbSelect("select * from soft_rireki_detail where ".$where, "list");
		$this->tpl->assignHtml('name',$detail[0]['hard_kanrino']);
		if(count($detail) > 0){
			for($i=0; $i<count($detail); $i++){
				if($syonin_kbn == "d001"){
					$where_soft = "soft_pkey = ".$detail[$i]['soft_pkey'];
					$fields_values = array(
							"hard_pkey"         => $detail[$i]['hard_pkey'],
							"licence_pkey"      => $detail[$i]['licence_pkey'],
							"downgrade"         => $detail[$i]['downgrade'],
							"bikou"             => $detail[$i]['bikou'],
							"install_date"      => $detail[$i]['tyoutatu_date'],
							"uninstall_date"    => $detail[$i]['haiki_date'],
							"memo"              => $detail[$i]['memo'],
							"version"           => $detail[$i]['version'] + 1, 
							"newkbn"            => 0
							      );
					$this->db->dbUpdate("\"soft\"", $fields_values, $where_soft);
				}else{
					$where_list = "soft_pkey = ".$detail[$i]['soft_pkey']." and newkbn = 1";
					$this->db->dbDelete("\"soft\"", $where_list);
				}
			}

			$where = "shinsei_no = ".$_SESSION['input']['shinsei_no']." and history_type = 'd002'";
			$fields_values = array(
					"syonin_kbn"          => $syonin_kbn,
					"syoninsya"           => $syoninsya,
					"syonin_date"         => $syonin_date
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

			if($syonin_kbn == "d001"){
				$action = "承認";
				$this->tpl->assignHtml('massage',  "承認完了いたしました。");
			}else{
				$action = "却下";
				$this->tpl->assignHtml('massage',  "却下完了いたしました。");
			}
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$syoninsya);
			$mail_tpl->assignHtml('syonin_date',$syonin_date);
			$mail_tpl->assignHtml('sinsei_date',$detail[0]['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ソフトウェア台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ソフトウェア台帳　".$action;

			$email->email($detail[0]['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		$app_col = select_code("00008");
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', $app_col[@$_SESSION['input']['syonin_kbn']]);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認ff
	 * 表示
	 */
	function app_view(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$softhistory_pkey = addslashes(@$_REQUEST['code']);
		/** 詳細ﾃﾞｰﾀ */
		$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");

		//組織認証
		$this->sosiki_auth(array($soft_detail['sinseisyozoku']));

		if(count($soft_detail) > 0){
			$history = $soft_detail;
			$_SESSION['input']['shinsei_no'] = $soft_detail['shinsei_no'];
			$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$soft_detail['shinsei_no']." order by licence_kanrino", "list");
			if(count($soft_list) > 0){
				for($i=0; $i<count($soft_list); $i++){
					if($soft_list[$i]['downgrade'] == "" or is_null($soft_list[$i]['downgrade'])){
						$soft_list[$i]['downgrade'] = "d002";
					}
					if($soft_list[$i]['tyoutatu_date'] != ""){
						$tyoutatu_date = explode("-",$soft_list[$i]['tyoutatu_date']);
						$soft_list[$i]['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
					}
					if($soft_list[$i]['haiki_date'] != ""){
						$haiki_date = explode("-",$soft_list[$i]['haiki_date']);
						$soft_list[$i]['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
					}
					$version = $soft_list[$i]['version']-1;
					$old_soft = $this->db->dbSelect("select * from soft_rireki_detail where soft_pkey = ".$soft_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
					if(strtotime(@$old_soft['haiki_date']) > strtotime(date('Y/m/d')) or @$old_soft['haiki_date'] == null){
						$list[] = $soft_list[$i];
					}else{
						$del_list[] = $soft_list[$i];
					}
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$item = $soft_detail;
		$user_referer = _USER_REFERER;

		#導入ライセンス比較
		for($i=0; $i<count(@$list); $i++){
			$version = $list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $list[$i][$val];
					}
				}
				$old = array();
			}
			$licence_cmp[$i]['new'] = @$new;
			$licence_cmp[$i]['old'] = @$old;
		}

		#削除済みライセンス比較
		for($i=0; $i<count(@$del_list); $i++){
			$version = $del_list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$del_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $del_list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$del_list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $del_list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($del_list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $del_list[$i][$val];
					}
				}
				$old = array();
			}
			$d_licence_cmp[$i]['new'] = @$new;
			$d_licence_cmp[$i]['old'] = @$old;
		}


		$version = $history['version']-1;
		$detail = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey=".$history['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
		if($detail['hard_pkey'] != ""){
			#ハードウェア比較
			$check_array = 	array(
						"hard_kanrino",
						"use_name"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if(@$history[$val] == ""){
						$new[$val] = "　";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $history;
		}

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('licence_cmp', @$licence_cmp);
		$this->tpl->assignHtml('d_licence_cmp', @$d_licence_cmp);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPVIEW);
		$this->tpl->assignHtml('action_param','app_view');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 内容確認
	 * 表示
	 */
	function rireki_del(){
		$this->tpl->assignHtml('title', _TITLE_APP_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$softhistory_pkey = addslashes(@$_REQUEST['code']);
		/** 詳細ﾃﾞｰﾀ */
		$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");
		
		//組織認証
		$this->sosiki_auth(array($soft_detail['sinseisyozoku']));
		
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		
		if(count($soft_detail) > 0){
			$history = $soft_detail;
			$_SESSION['input']['shinsei_no'] = $soft_detail['shinsei_no'];
			$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$soft_detail['shinsei_no']." order by licence_kanrino", "list");
			if(count($soft_list) > 0){
				for($i=0; $i<count($soft_list); $i++){
					if($soft_list[$i]['downgrade'] == "" or is_null($soft_list[$i]['downgrade'])){
						$soft_list[$i]['downgrade'] = "d002";
					}
					if($soft_list[$i]['tyoutatu_date'] != ""){
						$tyoutatu_date = explode("-",$soft_list[$i]['tyoutatu_date']);
						$soft_list[$i]['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
					}
					if($soft_list[$i]['haiki_date'] != ""){
						$haiki_date = explode("-",$soft_list[$i]['haiki_date']);
						$soft_list[$i]['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
					}
					$version = $soft_list[$i]['version']-1;
					$old_soft = $this->db->dbSelect("select * from soft_rireki_detail where soft_pkey = ".$soft_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
					if(strtotime(@$old_soft['haiki_date']) > strtotime(date('Y/m/d')) or @$old_soft['haiki_date'] == null){
						$list[] = $soft_list[$i];
					}else{
						$del_list[] = $soft_list[$i];
					}
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;
		
		#導入ライセンス比較
		for($i=0; $i<count(@$list); $i++){
			$version = $list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $list[$i][$val];
					}
				}
				$old = array();
			}
			$licence_cmp[$i]['new'] = @$new;
			$licence_cmp[$i]['old'] = @$old;
		}

		#削除済みライセンス比較
		for($i=0; $i<count(@$del_list); $i++){
			$version = $del_list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$del_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $del_list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$del_list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $del_list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($del_list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $del_list[$i][$val];
					}
				}
				$old = array();
			}
			$d_licence_cmp[$i]['new'] = @$new;
			$d_licence_cmp[$i]['old'] = @$old;
		}


		$version = $history['version']-1;
		$detail = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey=".$history['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
		if($detail['hard_pkey'] != ""){
			#ハードウェア比較
			$check_array = 	array(
						"hard_kanrino",
						"use_name"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if(@$history[$val] == ""){
						$new[$val] = "　";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $history;
		}

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$history);
		$this->tpl->assignHtml('licence_cmp', @$licence_cmp);
		$this->tpl->assignHtml('d_licence_cmp', @$d_licence_cmp);
		$this->tpl->assignHtml('syonin', @$history);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','rireki_del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function rireki_del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$shinsei_no = addslashes(@$_SESSION['input']['shinsei_no']);
		$where = "shinsei_no = ".$shinsei_no;
		$this->db->dbDelete("\"rireki\"", $where);
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		$this->tpl->assignHtml('massage',  "削除が完了しました。");
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 削除
	 * 確認
	 */
	function del(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$soft_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['soft_pkey']    = $soft_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from soft_detail where soft_pkey=".$soft_pkey, "detail");
		
		if(count($detail) > 0){
			$item    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('software/confirm_del.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$soft_pkey = addslashes(@$_SESSION['input']['soft_pkey']);
		$where = "soft_pkey = ".$soft_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select soft_pkey from \"soft\" where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_pkey']);
			/** 削除 */
			$this->db->dbDelete("\"soft\"", $where);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('massage',  "削除が完了しました。");
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}


	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check(){
		#入力チェック(警告)
		$cci_att = new CheckItem;

		$licence_no = array();
		if(count(@$_SESSION['input']['licence_no']) > 0){
			for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
				$licence_no[] = array(
							"licence_pkey_name"	=>"licence_pkey".$_SESSION['input']['licence_no'][$i],
							"tyoutatu_date_name"	=>"tyoutatu_date".$_SESSION['input']['licence_no'][$i],
							"haiki_date_name"	=>"haiki_date".$_SESSION['input']['licence_no'][$i],
							);
			}
		}
		if(count(@$_SESSION['input']['d_licence_no']) > 0){
			for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
				$licence_no[] = array(
							"licence_pkey_name"	=>"d_licence_pkey".$_SESSION['input']['d_licence_no'][$i],
							"tyoutatu_date_name"	=>"d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i],
							"haiki_date_name"	=>"d_haiki_date".$_SESSION['input']['d_licence_no'][$i],
							);
			}
		}
		for($i=0; $i<count(@$licence_no); $i++){
			$licence_pkey_name	= $licence_no[$i]['licence_pkey_name'];
			$tyoutatu_date_name	= $licence_no[$i]['tyoutatu_date_name'];
			$haiki_date_name	= $licence_no[$i]['haiki_date_name'];

			$error_check = true;
			if (ereg ("^([12][0-9]{3})/([0-9]{2})/([0-9]{2})$", @$_SESSION['input'][$haiki_date_name])) {
				$haiki = explode("/",@$_SESSION['input'][$haiki_date_name]);
				if(strtotime(date('Y/m/d',mktime(0,0,0,$haiki[1],$haiki[2],$haiki[0]))) <= strtotime(date('Y/m/d'))){
					$error_check = false;
				}
			}
			if($error_check){
				$pkey = $_SESSION['input'][$licence_pkey_name];
				$where = " where licence_pkey = ".$pkey;
				$detail = $this->db->dbSelect("select * from licence_detail".$where, "detail");

				if($detail['upgrade'] == "d001"){
					if($detail['licence_pkey2'] == "" and _ERROR_0234){
						$cci_att->checkErrorCode("0234",array($detail['licence_kanrino']));
					}else{
						$licence_pkey2_array = explode(",",$detail['licence_pkey2']);
						if(count(@$licence_pkey2_array) <= 0){
							$licence_pkey2_array = array($detail['licence_pkey2']);
						}
						$error_236 = false;
						for($j=0; $j<count($licence_pkey2_array); $j++){
							$where_licence = " where licence_pkey = ".$licence_pkey2_array[$j];
							$licence_detail = $this->db->dbSelect("select * from licence_detail".$where_licence, "detail");
							if(@$detail['upgrade'] == "d001" and @$licence_detail['haiki_date'] != ""){
								$error_236 = true;
							}
						}
						if($error_236 and _ERROR_0236){
							$cci_att->checkErrorCode("0236",array($detail['licence_kanrino']));
						}
					}
				}
				if(@$_SESSION['input'][$tyoutatu_date_name] == "" and _ERROR_0279){
					$cci_att->checkErrorCode("0279",array("ライセンス管理番号「".$detail['licence_kanrino']."」の"));
				}
			}
		}

		if($cci_att->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['att_flag']  = true;
			$_SESSION['input']['att_msg']   = $cci_att->error_msg;
		}
		
		#入力チェック
		$cci = new CheckItem;

		$licence_no = array();
		if(count(@$_SESSION['input']['licence_no']) > 0){
			for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
				$licence_no[] = array(
							"licence_pkey_name"	=>"licence_pkey".$_SESSION['input']['licence_no'][$i],
							"soft_pkey_name"	=>"soft_pkey".$_SESSION['input']['licence_no'][$i],
							"version_name"		=>"version".$_SESSION['input']['licence_no'][$i],
							"tyoutatu_date_name"	=>"tyoutatu_date".$_SESSION['input']['licence_no'][$i],
							"haiki_date_name"	=>"haiki_date".$_SESSION['input']['licence_no'][$i],
							);
			}
		}
		if(count(@$_SESSION['input']['d_licence_no']) > 0){
			for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
				$licence_no[] = array(
							"licence_pkey_name"	=>"d_licence_pkey".$_SESSION['input']['d_licence_no'][$i],
							"soft_pkey_name"	=>"d_soft_pkey".$_SESSION['input']['d_licence_no'][$i],
							"version_name"		=>"d_version".$_SESSION['input']['d_licence_no'][$i],
							"tyoutatu_date_name"	=>"d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i],
							"haiki_date_name"	=>"d_haiki_date".$_SESSION['input']['d_licence_no'][$i],
							);
			}
		}

		#バージョンチェック
		if(count(@$licence_no) > 0){
			for($i=0; $i<count($licence_no); $i++){
				$version_name		= $licence_no[$i]['version_name'];
				$soft_pkey_name		= $licence_no[$i]['soft_pkey_name'];
				$version = @$_SESSION['input'][$version_name];
				$soft_pkey = @$_SESSION['input'][$soft_pkey_name];
				if($soft_pkey != ""){
					$where = " where soft_pkey = ".$soft_pkey;
					$detail = $this->db->dbSelect("select * from soft_detail".$where, "detail");
					if($version != $detail['version'] and _ERROR_0051){
						$cci->checkErrorCode("0051");
					}
				}
			}
		}

		if($_SESSION['input']['method'] != "edit"){
			$cci->checkItemNon(array("email_ad"=>"申請者メールアドレス"));
			$cci->checkItemEmailArray(array("email_ad"=>"申請者メールアドレス"));
		
			$email_ad = explode("@",@$_SESSION['input']['email_ad']);
			if(count($email_ad)>=2){
				if(!in_array($email_ad[1],select_code("00027")) and _ERROR_0254){
					$cci->checkErrorCode("0254");
				}
			}
		}

		$error_name_array = select_code("00011");

		if(@$_SESSION['input']['hard_pkey'] == "" and _ERROR_0231){
			$cci->checkErrorCode("0231");
		}

		$where = " where hard_pkey = '".@$_SESSION['input']['hard_pkey']."'";
		$hard_detail = $this->db->dbSelect("select * from hard_detail".$where, "detail");
		
		if(count(@$_SESSION['input']['licence_no']) <= 0 and _ERROR_0255){
			$cci->checkErrorCode("0255");
		}else{
			$licence_kanrino_array = array();
			$error_276 = false;
			$error_232 = false;
			for($i=0; $i<count($licence_no); $i++){
				$licence_pkey_name	= $licence_no[$i]['licence_pkey_name'];
				$soft_pkey_name		= $licence_no[$i]['soft_pkey_name'];
				$tyoutatu_date_name	= $licence_no[$i]['tyoutatu_date_name'];
				$haiki_date_name	= $licence_no[$i]['haiki_date_name'];
				
				$pkey = @$_SESSION['input'][$licence_pkey_name];
				$where = " where licence_pkey = ".$pkey;
				$detail = $this->db->dbSelect("select * from licence_detail".$where, "detail");

				$cci->checkItemDate01(array($tyoutatu_date_name=>"ライセンス管理番号「".$detail['licence_kanrino']."」の".$error_name_array['009'],$haiki_date_name=>"ライセンス管理番号「".$detail['licence_kanrino']."」の".$error_name_array['010']));

				if(@$_SESSION['input'][$soft_pkey_name] == ''){
					$error_232 = true;
				}

				$error_check = true;
				if (ereg ("^([12][0-9]{3})/([0-9]{2})/([0-9]{2})$", @$_SESSION['input'][$haiki_date_name])) {
					$haiki = explode("/",@$_SESSION['input'][$haiki_date_name]);
					if(strtotime(date('Y/m/d',mktime(0,0,0,$haiki[1],$haiki[2],$haiki[0]))) <= strtotime(date('Y/m/d'))){
						$error_check = false;
					}
				}
				if($error_check){
					if(strtotime($detail['haiki_date']) <= strtotime(date("Y/m/d")) and $detail['haiki_date'] != null and _ERROR_0233){
						$cci->checkErrorCode("0233",array($detail['licence_kanrino']));
					}
					if($detail['upgrade'] == "d001"){
						$licence_pkey2_array = explode(",",$detail['licence_pkey2']);
						if(count(@$licence_pkey2_array) <= 0){
							$licence_pkey2_array = array($detail['licence_pkey2']);
						}
						$error_235 = false;
						for($j=0; $j<count($licence_pkey2_array); $j++){
							$where_licence = " where licence_pkey = ".$licence_pkey2_array[$j];
							$licence_detail = $this->db->dbSelect("select * from licence_detail".$where_licence, "detail");
							if(count($licence_detail) <= 0){
								$error_235 = true;
							}
						}
						if($error_235 and _ERROR_0235){
							$cci->checkErrorCode("0235",array($detail['licence_kanrino']));
						}
					}
					if($detail['hard_kotei'] == "d001" and $detail['hard_pkey'] != @$_SESSION['input']['hard_pkey'] and _ERROR_0237){
						$cci->checkErrorCode("0237",array($detail['licence_kanrino']));
					}
					#インストール数チェック
					if(@$_SESSION['input'][$soft_pkey_name] == "" and $detail['install_su'] < 99999999){
						$qty = $detail['install_su'] - $detail['install_qty'];
						if($qty <= 0 and _ERROR_0238){
							$cci->checkErrorCode("0238",array($detail['licence_kanrino']));
						}
					}

					if(in_array($detail['licence_kanrino'],$licence_kanrino_array)){
						$error_276 = true;
					}
					array_push($licence_kanrino_array,$detail['licence_kanrino']);
				}
			}
			if($error_276 and _ERROR_0276){
				$cci->checkErrorCode("0276");
			}
			if(strtotime($hard_detail['haiki_date']) <= strtotime(date('Y/m/d')) and $hard_detail['haiki_date'] != "" and $error_232 and _ERROR_0232){
				$cci->checkErrorCode("0232");
			}
		}

		if($_SESSION['input']['method'] != "del" and $_SESSION['input']['method'] != "edit"){
			if(@$_SESSION['input']['sinseisya'] == "" and _ERROR_0201){
				$cci->checkErrorCode("0201");
			}
			if(@$_SESSION['input']['sinsei_date'] == "" and _ERROR_0202){
				$cci->checkErrorCode("0202");
			}
			$cci->checkItemDateTime(array("sinsei_date"=>"申請日"));
		}
		$cci->checkItemDate01(array("tyoutatu_date"=>$error_name_array['009'],"haiki_date"=>$error_name_array['010']));
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check_app(){
		#入力チェック
		$cci = new CheckItem;

		$detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$_SESSION['input']['softhistory_pkey'], "detail");
		if($_SESSION['input']['syonin_kbn'] == 'd001'){
			#バージョンチェック
			$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$detail['shinsei_no'], "list");
			if(count($soft_list) > 0){
				$error_0103 = false;
				for($i=0; $i<count($soft_list); $i++){
					$detail_old = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".$soft_list[$i]['soft_pkey'], "detail");
					if($soft_list[$i]['version'] != $detail_old['version']){
						$error_0103 = true;
					}
				}
				if($error_0103 and _ERROR_0103){
					$cci->checkErrorCode("0103");
				}
				
				for($i=0; $i<count($soft_list); $i++){
					$error_check = true;
					if (ereg ("^([12][0-9]{3})-([0-9]{2})-([0-9]{2})$", @$soft_list[$i]['haiki_date'])) {
						$haiki = explode("-",@$soft_list[$i]['haiki_date']);
						if(strtotime(date('Y/m/d',mktime(0,0,0,$haiki[1],$haiki[2],$haiki[0]))) <= strtotime(date('Y/m/d'))){
							$error_check = false;
						}
					}
					if($error_check){
						$pkey = @$soft_list[$i]['licence_pkey'];
						$where = " where licence_pkey = ".$pkey;
						$licence_detail = $this->db->dbSelect("select * from licence_detail".$where, "detail");

						if(strtotime($licence_detail['haiki_date']) <= strtotime(date("Y-m-d")) and $licence_detail['haiki_date'] != null and _ERROR_0233){
							$cci->checkErrorCode("0233",array($licence_detail['licence_kanrino']));
						}
						$detail_old = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".$soft_list[$i]['soft_pkey'], "detail");
						if(@$detail_old['newkbn'] == 1){
							$where_install_licence = " where licence_pkey = ".$pkey." and soft_pkey != ".$soft_list[$i]['soft_pkey']." and newkbn <> 1 and (haiki_date > '".date("Y/m/d")."' or haiki_date is null)";
							$install_licence =  $this->db->dbSelect("select * from soft_detail".$where_install_licence, "list");
							$install_qty = count($install_licence);
							$qty = $licence_detail['install_su'] - $install_qty;
							if($qty <= 0 and _ERROR_0238){
								$cci->checkErrorCode("0238",array($licence_detail['licence_kanrino']));
							}
						}
					}
				}
			}
		}

		
		if (strtotime(@$_SESSION['input']['syonin_date']) < strtotime($detail['sinsei_date']) and _ERROR_0104) {
			$cci->checkErrorCode("0104");
		}

		if(@$_SESSION['input']['syoninsya'] == "" and _ERROR_0101){
			$cci->checkErrorCode("0101");
		}
		if(@$_SESSION['input']['syonin_date'] == "" and _ERROR_0102){
			$cci->checkErrorCode("0102");
		}

		$error_name_array = select_code("00015");
		$cci->checkItemDateTime(array("syonin_date"=>$error_name_array['007']));
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "";
		$this->login($page_name);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sosiki_pkey in (".implode(",",$sosiki_array).") and (haiki_date > '".date("Y/m/d")."' or haiki_date is null ) and (hard_haiki_date > '".date("Y/m/d")."' or hard_haiki_date is null ) and newkbn <> 1";
		}
		
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=software.csv");

		$list = $this->db->dbSelect("SELECT * FROM soft_detail".$_SESSION['csv'], "list");
		/** プログラムの追加と削除での表示 */
		for($i=0; $i<count($list); $i++){
			if($list[$i]['downgrade'] == "d001"){
				$program_add_del_table = "licencelistprogram_down";
			}else{
				$program_add_del_table = "licencelistprogram";
			}
			$program_where = " where licence.licence_pkey = ".$list[$i]['licence_pkey'];
			$licence_program = $this->db->dbSelect("SELECT lp.program_add_del from licence left join ".$program_add_del_table." lp on licence.licencelist_pkey = lp.licencelist_pkey".$program_where, "list");
			$licence_program_list = array();
			for($j=0; $j<count($licence_program); $j++){
				$licence_program_list[$j] = $licence_program[$j]['program_add_del'];
			}
			
			$inv_where = " where hardwareno = '".$list[$i]['hard_kanrino']."'";
			$inv_soft = $this->db->dbSelect("SELECT insapname from inventorysoft".$inv_where, "list");
			$program_name_array = array();
			for($k=0; $k<count($inv_soft); $k++){
				if(in_array($inv_soft[$k]['insapname'],$licence_program_list)){
					$program_name_array[] = $inv_soft[$k]['insapname'];
				}
			}
			if(count($program_name_array) > 0){
				$program_name = implode("\n",$program_name_array);
			}else{
				$program_name = "";
			}
			$list[$i]['program_add_del'] = $program_name;
		}
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		print mb_convert_encoding($this->tpl->fetchHtml('software/csv.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * プリント出力
	 */
	function prt(){
		$page_name = "";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sosiki_pkey in (".implode(",",$sosiki_array).") and (haiki_date > '".date("Y/m/d")."' or haiki_date is null ) and (hard_haiki_date > '".date("Y/m/d")."' or hard_haiki_date is null ) and newkbn <> 1";
		}
		
		$list = $this->db->dbSelect("SELECT * FROM soft_detail".$_SESSION['csv'], "list");

		/** プログラムの追加と削除での表示 */
		for($i=0; $i<count($list); $i++){
			if($list[$i]['downgrade'] == "d001"){
				$program_add_del_table = "licencelistprogram_down";
			}else{
				$program_add_del_table = "licencelistprogram";
			}
			$program_where = " where licence.licence_pkey = ".$list[$i]['licence_pkey'];
			$licence_program = $this->db->dbSelect("SELECT lp.program_add_del from licence left join ".$program_add_del_table." lp on licence.licencelist_pkey = lp.licencelist_pkey".$program_where, "list");
			$licence_program_list = array();
			for($j=0; $j<count($licence_program); $j++){
				$licence_program_list[$j] = $licence_program[$j]['program_add_del'];
			}
			
			$inv_where = " where hardwareno = '".$list[$i]['hard_kanrino']."'";
			$inv_soft = $this->db->dbSelect("SELECT insapname from inventorysoft".$inv_where, "list");
			$program_name_array = array();
			for($k=0; $k<count($inv_soft); $k++){
				if(in_array($inv_soft[$k]['insapname'],$licence_program_list)){
					$program_name_array[] = $inv_soft[$k]['insapname'];
				}
			}
			$list[$i]['program_add_del'] = $program_name_array;
		}


		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('list_view',$list);
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('software/print.html'));
		$this->tpl->outputHtml('print_list.html');

	}
	
	/**
	 * 申請書印刷
	 */
	function app_print(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_APP);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		#申請情報
		#ダウングレード名取得
		$downgrade_array = select_code("00004");
		
		for($i=0; $i<count(@$_SESSION['input']['licence_no']); $i++){
			$licence_pkey_name    = "licence_pkey".$_SESSION['input']['licence_no'][$i];
			$soft_pkey_name       = "soft_pkey".$_SESSION['input']['licence_no'][$i];
			$version_name         = "version".$_SESSION['input']['licence_no'][$i];
			$bikou_name           = "bikou".$_SESSION['input']['licence_no'][$i];
			$downgrade_name       = "downgrade".$_SESSION['input']['licence_no'][$i];
			$tyoutatu_date_name   = "tyoutatu_date".$_SESSION['input']['licence_no'][$i];
			$haiki_date_name      = "haiki_date".$_SESSION['input']['licence_no'][$i];
			$memo_name            = "memo".$_SESSION['input']['licence_no'][$i];
		
			$licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
			$licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
			
			$licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
		}

		if(count(@$licence_pkey) > 0){
			$in_key = implode(",",$licence_pkey);
			$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$licence = array();
		}
		if(count($licence) > 0){
			for($i=0; $i<count($licence); $i++){
				$licence[$i]['licence_pkey']		= @$licence[$i]['licence_pkey'];
				$licence[$i]['soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
				$licence[$i]['version']			= @$licence_input[$licence[$i]['licence_pkey']]['version'];
				$licence[$i]['bikou']			= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
				$licence[$i]['tyoutatu_date']		= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
				$licence[$i]['haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
				$licence[$i]['memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
				$licence[$i]['downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
					$licence[$i]['downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$licence[$i]['downgrade']       = "d002";
				}
				$licence[$i]['downgrade_name']          = $downgrade_array[@$licence[$i]['downgrade']];
			}
		}
		$list = $licence;
		
		for($i=0; $i<count(@$_SESSION['input']['d_licence_no']); $i++){
			$licence_pkey_name    = "d_licence_pkey".$_SESSION['input']['d_licence_no'][$i];
			$soft_pkey_name       = "d_soft_pkey".$_SESSION['input']['d_licence_no'][$i];
			$version_name         = "d_version".$_SESSION['input']['d_licence_no'][$i];
			$bikou_name           = "d_bikou".$_SESSION['input']['d_licence_no'][$i];
			$downgrade_name       = "d_downgrade".$_SESSION['input']['d_licence_no'][$i];
			$tyoutatu_date_name   = "d_tyoutatu_date".$_SESSION['input']['d_licence_no'][$i];
			$haiki_date_name      = "d_haiki_date".$_SESSION['input']['d_licence_no'][$i];
			$memo_name            = "d_memo".$_SESSION['input']['d_licence_no'][$i];
		
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["soft_pkey"]       = @$_SESSION['input'][$soft_pkey_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]["version"]         = @$_SESSION['input'][$version_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['bikou']           = @$_SESSION['input'][$bikou_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['tyoutatu_date']   = @$_SESSION['input'][$tyoutatu_date_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['haiki_date']      = @$_SESSION['input'][$haiki_date_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['memo']            = @$_SESSION['input'][$memo_name];
			$d_licence_input[$_SESSION['input'][$licence_pkey_name]]['downgrade']       = @$_SESSION['input'][$downgrade_name];
			
			$d_licence_pkey[] = $_SESSION['input'][$licence_pkey_name];
		}
		if(count(@$d_licence_pkey) > 0){
			$in_key = implode(",",$d_licence_pkey);
			$d_licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$d_licence = array();
		}
		if(count($d_licence) > 0){
			for($i=0; $i<count($d_licence); $i++){
				$d_licence[$i]['licence_pkey']		= @$d_licence[$i]['licence_pkey'];
				$d_licence[$i]['soft_pkey']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['soft_pkey'];
				$d_licence[$i]['version']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['version'];
				$d_licence[$i]['bikou']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['bikou'];
				$d_licence[$i]['tyoutatu_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['tyoutatu_date'];
				$d_licence[$i]['haiki_date']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['haiki_date'];
				$d_licence[$i]['memo']			= @$d_licence_input[$d_licence[$i]['licence_pkey']]['memo'];
				$d_licence[$i]['downgrade']		= @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
				if(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'])){
					$d_licence[$i]['downgrade']       = @$d_licence_input[$d_licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$d_licence[$i]['downgrade']       = "d002";
				}
				$d_licence[$i]['downgrade_name']          = $downgrade_array[@$d_licence[$i]['downgrade']];
			}
		}
		$del_list = $d_licence;

		#ハードウェア管理番号取得
		$hard_detail = $this->db->dbSelect("select * from hard_detail where hard_pkey='".$_SESSION['input']['hard_pkey']."'", "detail");

		$_SESSION['input']['hard_kanrino'] = $hard_detail['hard_kanrino'];
		$_SESSION['input']['use_name'] = $hard_detail['use_name'];

		$history = $_SESSION['input'];
		#導入ライセンス比較
		for($i=0; $i<count(@$list); $i++){
			if($list[$i]['soft_pkey'] != ""){
				$soft = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".$list[$i]['soft_pkey']." and newkbn <> 1", "detail");
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $list[$i][$val];
					}
				}
				$old = array();
			}
			$licence_cmp[$i]['new'] = @$new;
			$licence_cmp[$i]['old'] = @$old;
		}

		#削除済みライセンス比較
		for($i=0; $i<count(@$del_list); $i++){
			if($del_list[$i]['soft_pkey'] != ""){
				$soft = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".$del_list[$i]['soft_pkey']." and newkbn <> 1", "detail");
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $del_list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$del_list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $del_list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($del_list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $del_list[$i][$val];
					}
				}
				$old = array();
			}
			$d_licence_cmp[$i]['new'] = @$new;
			$d_licence_cmp[$i]['old'] = @$old;
		}

		$detail = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$history['hard_pkey']."' and newkbn <> 1", "detail");
		if($detail['hard_pkey'] != ""){
			#ハードウェア比較
			$check_array = 	array(
						"hard_kanrino",
						"use_name"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $_SESSION['input'][$val]){
					$old[$val] = @$detail[$val];
					if(@$_SESSION['input'][$val] == ""){
						$new[$val] = "　";
					}else{
						$new[$val] = $_SESSION['input'][$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $_SESSION['input'];
		}
		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',$_SESSION['input']);
		$this->tpl->assignHtml('licence_cmp',@$licence_cmp);
		$this->tpl->assignHtml('d_licence_cmp',@$d_licence_cmp);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		/** set template */
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('software/print_sinsei.html'));
		$this->tpl->outputHtml('print_sinsei.html');
	}
	
	/**
	 * 申請書印刷
	 */
	function app_print_r(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_APP);
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		$softhistory_pkey = addslashes(@$_REQUEST['code']);
		/** 詳細ﾃﾞｰﾀ */
		$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");
		
		//組織認証
		$this->sosiki_auth(array($soft_detail['sinseisyozoku']));
		
		if(count($soft_detail) > 0){
			$item    = $soft_detail;
			$_SESSION['input']['shinsei_no'] = $soft_detail['shinsei_no'];
			$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$soft_detail['shinsei_no']." order by licence_kanrino", "list");
			if(count($soft_list) > 0){
				for($i=0; $i<count($soft_list); $i++){
					if($soft_list[$i]['downgrade'] == "" or is_null($soft_list[$i]['downgrade'])){
						$soft_list[$i]['downgrade'] = "d002";
					}
					if($soft_list[$i]['tyoutatu_date'] != ""){
						$tyoutatu_date = explode("-",$soft_list[$i]['tyoutatu_date']);
						$soft_list[$i]['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
					}
					if($soft_list[$i]['haiki_date'] != ""){
						$haiki_date = explode("-",$soft_list[$i]['haiki_date']);
						$soft_list[$i]['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
					}
					$version = $soft_list[$i]['version']-1;
					$old_soft = $this->db->dbSelect("select * from soft_rireki_detail where soft_pkey = ".$soft_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
					if(strtotime(@$old_soft['haiki_date']) > strtotime(date('Y/m/d')) or @$old_soft['haiki_date'] == null){
						$list[] = $soft_list[$i];
					}else{
						$del_list[] = $soft_list[$i];
					}
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		$history = $soft_detail;

		#導入ライセンス比較
		for($i=0; $i<count(@$list); $i++){
			$version = $list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $list[$i][$val];
					}
				}
				$old = array();
			}
			$licence_cmp[$i]['new'] = @$new;
			$licence_cmp[$i]['old'] = @$old;
		}

		#削除済みライセンス比較
		for($i=0; $i<count(@$del_list); $i++){
			$version = $del_list[$i]['version']-1;
			$soft = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey = ".$del_list[$i]['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $del_list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$del_list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $del_list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($del_list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $del_list[$i][$val];
					}
				}
				$old = array();
			}
			$d_licence_cmp[$i]['new'] = @$new;
			$d_licence_cmp[$i]['old'] = @$old;
		}


		$version = $history['version']-1;
		$detail = $this->db->dbSelect("SELECT * FROM soft_rireki_detail where soft_pkey=".$history['soft_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
		if($detail['hard_pkey'] != ""){
			#ハードウェア比較
			$check_array = 	array(
						"hard_kanrino",
						"use_name"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if(@$history[$val] == ""){
						$new[$val] = "　";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $history;
		}
		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',$history);
		$this->tpl->assignHtml('licence_cmp',@$licence_cmp);
		$this->tpl->assignHtml('d_licence_cmp',@$d_licence_cmp);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		/** set template */
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('software/print_sinsei.html'));
		$this->tpl->outputHtml('print_sinsei.html');
	}
	
	/**
	 * ライセンス台帳一覧
	 */
	function license_search(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "licence_pkey";
		}
		if(@$_REQUEST['sort_asc'] == "ASC"){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "sosiki_fullname";
				        break;
				    case "002":
					$s_col = "licence_kanrino";
				        break;
				    case "003":
					$s_col = "soft_name";
				        break;
				    case "004":
					$s_col = "licence_keitai";
				        break;
				    case "005":
					$s_col = "brand";
				        break;
				    case "006":
					$s_col = "install_su";
				        break;
				    case "007":
					$s_col = "install_qty";
				        break;
				    case "008":
					$s_col = "hard_kotei";
				        break;
				    case "009":
					$s_col = "hard_kanrino";
				        break;
				    case "010":
					$s_col = "upgrade";
				        break;
				    case "011":
					$s_col = "up_licence_kanrino";
				        break;
				    case "012":
					$s_col = "licence_no";
				        break;
				    case "013":
					$s_col = "tyoutatu";
				        break;
				    case "014":
					$s_col = "tokusitu_useproposal";
				        break;
				    case "015":
					$s_col = "useproposal_youken";
				        break;
				    case "016":
					$s_col = "hokan_baitai";
				        break;
				    case "017":
					$s_col = "hokan_basyo";
				        break;
				    case "018":
					$s_col = "program_add_del";
				        break;
				    case "019":
					$s_col = "bikou";
				        break;
				    case "020":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "021":
					$s_col = "haiki_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= ")";

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licence_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licence_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->outputHtml('license/sub_list.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * ハードウェア台帳一覧
	 */
	function license_search_reload(){
		parse_str($_POST['params'],$request);
		$_REQUEST['page'] = @$request['page'];

		$this->tpl->assignHtml('title', _TITLE_LICENSE);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** パラメータ */
		$param_key = ereg_key($request,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($request,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$request['sort_name'] == ""){
			$request['sort_name'] = "licence_pkey";
		}
		if(@$request['sort_asc'] == "ASC"){
			$request['sort_asc'] = "ASC";
		}else{
			$request['sort_asc'] = "DESC";
		}
		$this->sort = $request['sort_name'];
		$this->asc = $request['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$request[$val] = trim(@$request[$val]);
			if(@$request[$val] != "" and @$request[$col] != ""){
				$search_val_base = @$request[$val];
				switch (@$request[$col]){
				    case "001":
					$s_col = "sosiki_fullname";
				        break;
				    case "002":
					$s_col = "licence_kanrino";
				        break;
				    case "003":
					$s_col = "soft_name";
				        break;
				    case "004":
					$s_col = "licence_keitai";
				        break;
				    case "005":
					$s_col = "brand";
				        break;
				    case "006":
					$s_col = "install_su";
				        break;
				    case "007":
					$s_col = "install_qty";
				        break;
				    case "008":
					$s_col = "hard_kotei";
				        break;
				    case "009":
					$s_col = "hard_kanrino";
				        break;
				    case "010":
					$s_col = "upgrade";
				        break;
				    case "011":
					$s_col = "up_licence_kanrino";
				        break;
				    case "012":
					$s_col = "licence_no";
				        break;
				    case "013":
					$s_col = "tyoutatu";
				        break;
				    case "014":
					$s_col = "tokusitu_useproposal";
				        break;
				    case "015":
					$s_col = "useproposal_youken";
				        break;
				    case "016":
					$s_col = "hokan_baitai";
				        break;
				    case "017":
					$s_col = "hokan_basyo";
				        break;
				    case "018":
					$s_col = "program_add_del";
				        break;
				    case "019":
					$s_col = "bikou";
				        break;
				    case "020":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$request[$val]);
				        break;
				    case "021":
					$s_col = "haiki_date";
					$search_val_base = ereg_replace("\/","-",@$request[$val]);
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$request[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$request[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$request[$col]);
			$this->tpl->assignHtml($val,@$request[$val]);
			$this->tpl->assignHtml($comp,@$request[$comp]);
			$this->tpl->assignHtml($cd,@$request[$cd]);
		}

		$where .= ")";

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licence_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licence_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$html = $this->tpl->fetchHtml('license/sub_list_reload.html');
		print $html;
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * ハードウェア台帳一覧
	 */
	function license_search_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		
		$where = " where licence_pkey = ".$_REQUEST['no'];
		$detail = $this->db->dbSelect("SELECT * FROM licence_detail".$where, "detail");

		$json = new Services_JSON();
		$licence_detail = $json->encode($detail);
		
		print $licence_detail;
	}

}

?>