<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** ライセンス一覧管理 */
class License_listModel extends Model{

	/**
	 * ﾕｰｻﾞｰcode(登録者)
	 * @var int
	 */
	var $authuser_code;

	/**
	 * 一覧
	 */
	function index(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "soft_name";
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "003";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "soft_name";
				        break;
				    case "002":
					$s_col = "licence_keitai_name";
				        break;
				    case "003":
					$s_col = "program_add_del";
				        break;
				    case "004":
					$s_col = "hard_kotei_name";
				        break;
				    case "005":
					$s_col = "upgrade_name";
				        break;
				    case "006":
					$s_col = "brand";
				        break;
				    case "007":
					$s_col = "useproposal_kakunin_name";
				        break;
				    case "008":
					$s_col = "tokusitu_useproposal";
				        break;
				    case "009":
					$s_col = "bikou";
				        break;
				    case "010":
					$s_col = "sosiki_fullname";
				        break;
				    case "011":
					$s_col = "upd_name";
				        break;
				    case "012":
					$s_col = "upd_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "013":
					$s_col = "yukou_name";
				        break;
				    case "014":
					$s_col = "useproposal_youken";
				        break;
				    case "015":
					$s_col = "licencelist_pkey";
				        break;
				    case "016":
					$s_col = "edition";
				        break;
				    case "017":
					$s_col = "program_add_del_down";
				        break;
				    case "018":
					$s_col = "disabled_name";
				        break;
				    case "019":
					$s_col = "licence_qty";
				        break;
				    case "020":
					$s_col = "soft_qty";
				        break;
				    case "021":
					$s_col = "memo";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= ") and newkbn <> 1";
		if($this->authuser_authority != "system"){
			$where .= " and yukou = 'd001'";
		}
//		if($this->authuser_authority != "system"){
//			$child_where = " where user_pkey = ".$this->authuser_code;
//			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
//
//			$child_array = child_sosiki_key($detail['sosiki_pkey']);
//			array_unshift($child_array,$detail['sosiki_pkey']);
//			$where .= " and upd_syozoku in (".implode(",",$child_array).")";
//		}
		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licencelist_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi($list['count'], $count, $url, $param);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licencelist_detail".$where.$order.$limit, "list");
			if(count($list_limit) > 0){
				for($i=0; $i<count($list_limit); $i++){
					/** プログラムの追加と削除での表示 */
					$program_add_del_array = explode("\n",$list_limit[$i]['program_add_del']);
					$list_limit[$i]['program_add_del'] = $program_add_del_array;
					/** ダウングレード使用時のプログラムの追加と削除での表示 */
					$program_add_del_down_array = explode("\n",$list_limit[$i]['program_add_del_down']);
					$list_limit[$i]['program_add_del_down'] = $program_add_del_down_array;
				}
			}
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/list.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * 新規追加
	 * 入力
	 */
	function app_reg(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");

			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;

			$item['sinsei_date'] = date("Y/m/d H:i");
			$item['sinseisyozoku'] = $detail['sosiki_pkey'];
			$item['hard_kotei'] = "d002";
			$item['upgrade'] = "d002";
			$item['disabled'] = "d002";
			$item['useproposal_kakunin'] = "d001";
			$item['yukou'] = "d001";
		
			$user_referer = _USER_REFERER;
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 確認
	 */
	function app_reg_conf(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_reg";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 登録
	 */
	function app_reg_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_reg";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			/** 登録 */
			$fields_values = array(
					"soft_name"            => $_SESSION['input']['soft_name'],     
					"licence_keitai"       => $_SESSION['input']['licence_keitai'],     
					"brand"                => $_SESSION['input']['brand'],     
					"hard_kotei"           => $_SESSION['input']['hard_kotei'],
					"upgrade"              => $_SESSION['input']['upgrade'],
					"useproposal_kakunin"  => $_SESSION['input']['useproposal_kakunin'], 
					"tokusitu_useproposal" => $_SESSION['input']['tokusitu_useproposal'], 
					"useproposal_youken"   => $_SESSION['input']['useproposal_youken'], 
					"bikou"                => $_SESSION['input']['bikou'], 
					"yukou"                => $_SESSION['input']['yukou'], 
					"edition"              => $_SESSION['input']['edition'], 
					"disabled"             => $_SESSION['input']['disabled'], 
					"memo"                 => @$_SESSION['input']['memo'], 
					"version"              => 1, 
					"newkbn"               => 1 
					      );
			$pkey = $this->db->dbInsert("\"licencelist\"", $fields_values);

			$fields_values = array(
					"licencelist_pkey"     => $pkey,     
					"soft_name"            => $_SESSION['input']['soft_name'],     
					"licence_keitai"       => $_SESSION['input']['licence_keitai'],     
					"brand"                => $_SESSION['input']['brand'],     
					"hard_kotei"           => $_SESSION['input']['hard_kotei'],
					"upgrade"              => $_SESSION['input']['upgrade'],
					"useproposal_kakunin"  => $_SESSION['input']['useproposal_kakunin'], 
					"tokusitu_useproposal" => $_SESSION['input']['tokusitu_useproposal'], 
					"useproposal_youken"   => $_SESSION['input']['useproposal_youken'], 
					"bikou"                => $_SESSION['input']['bikou'], 
					"yukou"                => $_SESSION['input']['yukou'], 
					"edition"              => $_SESSION['input']['edition'], 
					"disabled"             => $_SESSION['input']['disabled'], 
					"memo"                 => @$_SESSION['input']['memo'], 
					"version"              => 1
					      );
			$code = $this->db->dbInsert("\"licencelistrireki\"", $fields_values);

			$fields_values = array(
					"history_pkey"         => $code,     
					"history_type"         => "d004",     
					"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
					"sinseisya"            => $_SESSION['input']['sinseisya'], 
					"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'], 
					"email_ad"             => $_SESSION['input']['email_ad'],
					"shinsei_no"           => $code,     
					      );
			$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);

			$where = "licencehistory_pkey = ".$code;

			#プログラムの追加と削除を履歴と台帳に登録
			$this->db->dbDelete("\"licencelistprogram\"", "licencelist_pkey = ".$pkey);
			$this->db->dbDelete("\"licencelistprogramrireki\"", $where);
			for($i=0; $i<count(@$_SESSION['input']['program_add_del']); $i++){
				$fields        = array(
						"licencelist_pkey"     => $pkey,
						"program_add_del"      => ereg_replace("\(RETURN\)","\r",$_SESSION['input']['program_add_del'][$i])
						      );
				$this->db->dbInsert("\"licencelistprogram\"", $fields);
				$fields_values = array(
						"licencehistory_pkey"  => $code,
						"program_add_del"      => ereg_replace("\(RETURN\)","\r",$_SESSION['input']['program_add_del'][$i])
						      );
				$this->db->dbInsert("\"licencelistprogramrireki\"", $fields_values);
			}
			#ダウングレード使用時のプログラムの追加と削除を履歴と台帳に登録
			$this->db->dbDelete("\"licencelistprogram_down\"", "licencelist_pkey = ".$pkey);
			$this->db->dbDelete("\"licencelistprogram_down_rireki\"", $where);
			for($i=0; $i<count(@$_SESSION['input']['program_add_del_down']); $i++){
				$fields        = array(
						"licencelist_pkey"     => $pkey,
						"program_add_del"      => ereg_replace("\(RETURN\)","\r",$_SESSION['input']['program_add_del_down'][$i])
						      );
				$this->db->dbInsert("\"licencelistprogram_down\"", $fields);
				$fields_values = array(
						"licencehistory_pkey"  => $code,
						"program_add_del"      => ereg_replace("\(RETURN\)","\r",$_SESSION['input']['program_add_del_down'][$i])
						      );
				$this->db->dbInsert("\"licencelistprogram_down_rireki\"", $fields_values);
			}
			if(_AUTO_APPROVAL == 1){
				$this->auto_app($code);
			}

			$mail_tpl = new Template;
			$email = new Sendmail;
		
			$mail_tpl->assignHtml('sinseisya',$_SESSION['input']['sinseisya']);
			$mail_tpl->assignHtml('sinsei_date',$_SESSION['input']['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス一覧表");
			$mail_tpl->assignHtml('action',_ACTION_APPADD);

			$body = $mail_tpl->fetchHtml('mail/sinsei.html');
			$subject = "【情報資産管理システム】ライセンス一覧表　"._ACTION_APPADD;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$sosiki_pkey = $detail['sosiki_pkey'];
			
			$list = $this->db->dbSelect("SELECT * FROM user_detail where (auth = 'd003' or auth = 'd004') and sosiki_pkey = ".$sosiki_pkey, "list");
			for($i=0; $i<count(@$list); $i++){
				$email_ad = explode("\n",$list[$i]['email_ad']);
				for($j=0; $j<count($email_ad); $j++){
//					$email->email($email_ad[$j], _ADMIN_EMAIL, $subject, $body);
				}
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['soft_name']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 編集
	 * 入力
	 */
	function app_edit(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$licencelist_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".$licencelist_pkey."'", "detail");
			if(count($detail) > 0){
				$item    = $detail;
				#プログラムの追加と削除表示用
				if($item['program_add_del']){
					$item['program_add_del'] =explode("\n",ereg_replace("\r","",$item['program_add_del']));
				}else{
					$item['program_add_del'] = array();
				}
				#ダウングレード使用時のプログラムの追加と削除表示用
				if($item['program_add_del_down']){
					$item['program_add_del_down'] =explode("\n",ereg_replace("\r","",$item['program_add_del_down']));
				}else{
					$item['program_add_del_down'] = array();
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;

			$item['sinsei_date'] = date("Y/m/d H:i");
			$item['sinseisyozoku'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認app_print
	 */
	function app_edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function app_edit_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */
		$licencelist_pkey = addslashes($_SESSION['input']['licencelist_pkey']);
		$where = "licencelist_pkey = ".$licencelist_pkey;

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			if($this->authuser_authority != 'system'){
				$detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey=".$_SESSION['input']['licencelist_pkey'], "detail");
				$_SESSION['input']['memo'] = $detail['memo'];
			}
			/** 登録 */
			$fields_values = array(
					"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
					"soft_name"            => $_SESSION['input']['soft_name'],     
					"licence_keitai"       => $_SESSION['input']['licence_keitai'],     
					"brand"                => $_SESSION['input']['brand'],     
					"hard_kotei"           => $_SESSION['input']['hard_kotei'],
					"upgrade"              => $_SESSION['input']['upgrade'],
					"useproposal_kakunin"  => $_SESSION['input']['useproposal_kakunin'], 
					"tokusitu_useproposal" => $_SESSION['input']['tokusitu_useproposal'], 
					"useproposal_youken"   => $_SESSION['input']['useproposal_youken'], 
					"bikou"                => $_SESSION['input']['bikou'], 
					"yukou"                => $_SESSION['input']['yukou'], 
					"edition"              => $_SESSION['input']['edition'], 
					"disabled"             => $_SESSION['input']['disabled'], 
					"memo"                 => $_SESSION['input']['memo'], 
					"version"              => $_SESSION['input']['version'], 
					"upd_date"             => $_SESSION['input']['upd_date'], 
					"upd_name"             => $_SESSION['input']['upd_name'], 
					"upd_syozoku"          => $_SESSION['input']['upd_syozoku']
					      );
			$code = $this->db->dbInsert("\"licencelistrireki\"", $fields_values);

			$fields_values = array(
					"history_pkey"         => $code,     
					"history_type"         => "d004",     
					"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
					"sinseisya"            => $_SESSION['input']['sinseisya'], 
					"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'], 
					"email_ad"             => $_SESSION['input']['email_ad'],
					"shinsei_no"           => $code,     
					      );
			$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);

			$where = "licencehistory_pkey = ".$code;

			#プログラムの追加と削除を履歴に登録
			$this->db->dbDelete("\"licencelistprogramrireki\"", $where);
			for($i=0; $i<count(@$_SESSION['input']['program_add_del']); $i++){
				$fields_values = array(
						"licencehistory_pkey"  => $code,
						"program_add_del"      => ereg_replace("\(RETURN\)","\r",$_SESSION['input']['program_add_del'][$i])
						      );
				$this->db->dbInsert("\"licencelistprogramrireki\"", $fields_values);
			}
			#ダウングレード使用時のプログラムの追加と削除を履歴に登録
			$this->db->dbDelete("\"licencelistprogram_down_rireki\"", $where);
			for($i=0; $i<count(@$_SESSION['input']['program_add_del_down']); $i++){
				$fields_values = array(
						"licencehistory_pkey"  => $code,
						"program_add_del"      => ereg_replace("\(RETURN\)","\r",$_SESSION['input']['program_add_del_down'][$i])
						      );
				$this->db->dbInsert("\"licencelistprogram_down_rireki\"", $fields_values);
			}
			if(_AUTO_APPROVAL == 1){
				$this->auto_app($code);
			}

			$mail_tpl = new Template;
			$email = new Sendmail;
		
			$mail_tpl->assignHtml('sinseisya',$_SESSION['input']['sinseisya']);
			$mail_tpl->assignHtml('sinsei_date',$_SESSION['input']['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス一覧表");
			$mail_tpl->assignHtml('action',_ACTION_APPEDIT);

			$body = $mail_tpl->fetchHtml('mail/sinsei.html');
			$subject = "【情報資産管理システム】ライセンス一覧表　"._ACTION_APPEDIT;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$sosiki_pkey = $detail['sosiki_pkey'];
			
			$list = $this->db->dbSelect("SELECT * FROM user_detail where (auth = 'd003' or auth = 'd004') and sosiki_pkey = ".$sosiki_pkey, "list");
			for($i=0; $i<count(@$list); $i++){
				$email_ad = explode("\n",$list[$i]['email_ad']);
				for($j=0; $j<count($email_ad); $j++){
//					$email->email($email_ad[$j], _ADMIN_EMAIL, $subject, $body);
				}
			}

		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['soft_name']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * コピー
	 * 入力
	 */
	function app_copy(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$licencelist_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".$licencelist_pkey."'", "detail");
			if(count($detail) > 0){
				$item				= $detail;
				$item['licencelist_pkey']	= "";
				$item['upd_date']		= "";
				$item['upd_syozoku']		= "";
				$item['upd_name']		= "";
				$item['version']		= "";
				#プログラムの追加と削除表示用
				if($item['program_add_del']){
					$item['program_add_del'] =explode("\n",ereg_replace("\r","",$item['program_add_del']));
				}else{
					$item['program_add_del'] = array();
				}
				#ダウングレード使用時のプログラムの追加と削除表示用
				if($item['program_add_del_down']){
					$item['program_add_del_down'] =explode("\n",ereg_replace("\r","",$item['program_add_del_down']));
				}else{
					$item['program_add_del_down'] = array();
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;

			$item['sinsei_date'] = date("Y/m/d H:i");
			$item['sinseisyozoku'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 修正申請
	 * 入力
	 */
	function app_modify(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			if($item['licencelist_pkey'] != ""){
				$action_param = 'app_edit';
			}else{
				$action_param = 'app_reg';
			}
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$history_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$history_pkey, "detail");
			if(count($detail) > 0){
				$base_detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey=".$detail['licencelist_pkey'], "detail");
				if($base_detail['newkbn'] == 0){
					$item				= $detail;
					$item['upd_date']		= $base_detail['upd_date'];
					$item['upd_syozoku']		= $base_detail['upd_syozoku'];
					$item['upd_name']		= $base_detail['upd_name'];
					$item['version']		= $base_detail['version'];
					$action_param = 'app_edit';
				}else{
					$item				= $detail;
					$item['licencelist_pkey']	= "";
					$item['upd_date']		= "";
					$item['upd_syozoku']		= "";
					$item['upd_name']		= "";
					$item['version']		= "";
					$action_param = 'app_reg';
				}
				#プログラムの追加と削除表示用
				if($item['program_add_del']){
					$item['program_add_del'] =explode("\n",ereg_replace("\r","",$item['program_add_del']));
				}else{
					$item['program_add_del'] = array();
				}
				#ダウングレード使用時のプログラムの追加と削除表示用
				if($item['program_add_del_down']){
					$item['program_add_del_down'] =explode("\n",ereg_replace("\r","",$item['program_add_del_down']));
				}else{
					$item['program_add_del_down'] = array();
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;

			$item['sinsei_date'] = date("Y/m/d H:i");
			$item['sinseisyozoku'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param',$action_param);
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 入力
	 */
	function edit(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$licencelist_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".$licencelist_pkey."'", "detail");
			if(count($detail) > 0){
				$item    = $detail;
				#プログラムの追加と削除表示用
				if($item['program_add_del']){
					$item['program_add_del'] =explode("\n",ereg_replace("\r","",$item['program_add_del']));
				}else{
					$item['program_add_del'] = array();
				}
				#ダウングレード使用時のプログラムの追加と削除表示用
				if($item['program_add_del_down']){
					$item['program_add_del_down'] =explode("\n",ereg_replace("\r","",$item['program_add_del_down']));
				}else{
					$item['program_add_del_down'] = array();
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認
	 */
	function edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function edit_done(){
		$page_name = "system";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */
		$licencelist_pkey = addslashes($_SESSION['input']['licencelist_pkey']);
		$where = "licencelist_pkey = ".$licencelist_pkey;

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			/** 登録 */
			if($this->authuser_authority != 'system'){
				$detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey=".$_SESSION['input']['licencelist_pkey'], "detail");
				$_SESSION['input']['memo'] = $detail['memo'];
			}
			$fields_values = array(
					"soft_name"            => $_SESSION['input']['soft_name'],     
					"licence_keitai"       => $_SESSION['input']['licence_keitai'],     
					"brand"                => $_SESSION['input']['brand'],     
					"hard_kotei"           => $_SESSION['input']['hard_kotei'],
					"upgrade"              => $_SESSION['input']['upgrade'],
					"useproposal_kakunin"  => $_SESSION['input']['useproposal_kakunin'], 
					"tokusitu_useproposal" => $_SESSION['input']['tokusitu_useproposal'], 
					"useproposal_youken"   => $_SESSION['input']['useproposal_youken'], 
					"bikou"                => $_SESSION['input']['bikou'], 
					"upd_date"             => $_SESSION['input']['upd_date'], 
					"upd_name"             => $_SESSION['input']['upd_name'], 
					"yukou"                => $_SESSION['input']['yukou'], 
					"edition"              => $_SESSION['input']['edition'], 
					"disabled"             => $_SESSION['input']['disabled'], 
					"memo"                 => $_SESSION['input']['memo'], 
					"version"              => $_SESSION['input']['version'] + 1, 
					"upd_syozoku"          => $_SESSION['input']['upd_syozoku']
					      );
			$this->db->dbUpdate("\"licencelist\"", $fields_values, $where);
			#プログラムの追加と削除を書き換え
			$this->db->dbDelete("\"licencelistprogram\"", $where);
			for($i=0; $i<count(@$_SESSION['input']['program_add_del']); $i++){
				$fields_values = array(
						"licencelist_pkey"     => $licencelist_pkey,
						"program_add_del"      => ereg_replace("\(RETURN\)","\r",$_SESSION['input']['program_add_del'][$i])
						      );
				$this->db->dbInsert("\"licencelistprogram\"", $fields_values);
			}
			#ダウングレード使用時のプログラムの追加と削除を書き換え
			$this->db->dbDelete("\"licencelistprogram_down\"", $where);
			for($i=0; $i<count(@$_SESSION['input']['program_add_del_down']); $i++){
				$fields_values = array(
						"licencelist_pkey"     => $licencelist_pkey,
						"program_add_del"      => ereg_replace("\(RETURN\)","\r",$_SESSION['input']['program_add_del_down'][$i])
						      );
				$this->db->dbInsert("\"licencelistprogram_down\"", $fields_values);
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['soft_name']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action',"edit");
		$this->tpl->assignHtml('code',$licencelist_pkey);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 申請
	 * 取下
	 */
	function app_del(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SAGE);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$licencehistory_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['licencehistory_pkey']    = $licencehistory_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$item    = $detail;
			#プログラムの追加と削除表示用
			if($item['program_add_del']){
				$item['program_add_del'] = explode("\n",$item['program_add_del']);
			}else{
				$item['program_add_del'] = array();
			}
			#ダウングレード使用時のプログラムの追加と削除表示用
			if($item['program_add_del_down']){
				$item['program_add_del_down'] =explode("\n",$item['program_add_del_down']);
			}else{
				$item['program_add_del_down'] = array();
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;

		/** 出力 */
		$this->tpl->assignHtml('item',   $item);
		$this->tpl->assignHtml('list',   $item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPDEL);
		$this->tpl->assignHtml('action_param','app_del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 申請
	 * 取下
	 */
	function app_del_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$licencehistory_pkey = addslashes(@$_SESSION['input']['licencehistory_pkey']);
		$where = "licencehistory_pkey = ".$licencehistory_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_name']);
			$where = "history_pkey = ".$licencehistory_pkey." and history_type = 'd004'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => 'd003'
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);
			
			$where_list = "licencelist_pkey = ".$detail['licencelist_pkey']." and newkbn = 1";
			$list = $this->db->dbSelect("select * from licencelist_detail where ".$where_list, "list");
			if(count($list) > 0){
				$this->db->dbDelete("\"licencelist\"", $where_list);
				$this->db->dbDelete("\"licencelistprogram\"", "licencelist_pkey = ".$detail['licencelist_pkey']);
				$this->db->dbDelete("\"licencelistprogram_down\"", "licencelist_pkey = ".$detail['licencelist_pkey']);
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_APPDEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認
	 * 
	 */
	function app(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SHOUNIN);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$licencehistory_pkey = addslashes(@$_SESSION['input']['licencehistory_pkey']);
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";

			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
			if(count($detail) > 0){
				$history    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
		}else{
			$licencehistory_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
			if(count($detail) > 0){
				$history    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$item['syoninsya'] = _DEFAULT_SYONINSYA;
			
			$item['syonin_date'] = date("Y/m/d H:i");
			$item['sinsei_date'] = $detail['sinsei_date'];
			$item['sinseisya'] = $detail['sinseisya'];
			$item['email_ad'] = $detail['email_ad'];
			$item['licencehistory_pkey'] = $detail['licencehistory_pkey'];
			$item['version'] = $detail['version'];
			$user_referer = _USER_REFERER;
		}
		#プログラムの追加と削除比較用データ
		if($history['program_add_del']){
			$history['program_add_del'] = ereg_replace("\r","",$history['program_add_del']);
			$history['program_add_del'] = explode("\n",$history['program_add_del']);
		}else{
			$history['program_add_del'] = array();
		}
		#ダウングレード使用時のプログラムの追加と削除比較用データ
		if($history['program_add_del_down']){
			$history['program_add_del_down'] = ereg_replace("\r","",$history['program_add_del_down']);
			$history['program_add_del_down'] = explode("\n",$history['program_add_del_down']);
		}else{
			$history['program_add_del_down'] = array();
		}


		if($history['licencelist_pkey'] != ""){
			$version = $history['version']-1;
			$detail = $this->db->dbSelect("SELECT * FROM licencelist_rireki_detail where licencelist_pkey = ".$history['licencelist_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			#プログラムの追加と削除比較用データ
			if(@$detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}		
			#ダウングレード使用時のプログラムの追加と削除比較用データ
			if(@$detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}		

			/** プログラムの追加と削除比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$history['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $history['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$history['program_add_del'];
				if(count(@$history['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $history['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$history['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $history['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$history['program_add_del_down'];
				if(count(@$history['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $history['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}
		
			/** 比較 */
			$check_array = 	array(
						"soft_name",
						"licence_keitai",
						"brand",
						"hard_kotei",
						"upgrade",
						"useproposal_kakunin",
						"tokusitu_useproposal",
						"useproposal_youken",
						"bikou",
						"yukou",
						"edition", 
						"disabled", 
						"memo"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APP);
		$this->tpl->assignHtml('action_param','app');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/input_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}
	
	/**
	 * 内容確認
	 * 
	 */
	function app_conf(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_SHOUNIN);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 承認時デフォルト値書換 */
		change_default_syonin(@$_SESSION['input']['syoninsya']);
		$item = $_SESSION['input'];
		$licencehistory_pkey = addslashes(@$_SESSION['input']['licencehistory_pkey']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app";
		$this->check_app();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}

		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$history    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;

		#プログラムの追加と削除比較用データ
		if($history['program_add_del']){
			$history['program_add_del'] = ereg_replace("\r","",$history['program_add_del']);
			$history['program_add_del'] = explode("\n",$history['program_add_del']);
		}else{
			$history['program_add_del'] = array();
		}
		#ダウングレード使用時のプログラムの追加と削除比較用データ
		if($history['program_add_del_down']){
			$history['program_add_del_down'] = ereg_replace("\r","",$history['program_add_del_down']);
			$history['program_add_del_down'] = explode("\n",$history['program_add_del_down']);
		}else{
			$history['program_add_del_down'] = array();
		}

		if($history['licencelist_pkey'] != ""){
			$version = $history['version']-1;
			$detail = $this->db->dbSelect("SELECT * FROM licencelist_rireki_detail where licencelist_pkey = ".$history['licencelist_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			#プログラムの追加と削除比較用データ
			if(@$detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}		
			#ダウングレード使用時のプログラムの追加と削除比較用データ
			if(@$detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}		

			/** プログラムの追加と削除比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$history['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $history['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$history['program_add_del'];
				if(count(@$history['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $history['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$history['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $history['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$history['program_add_del_down'];
				if(count(@$history['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $history['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}
		
			/** 比較 */
			$check_array = 	array(
						"soft_name",
						"licence_keitai",
						"brand",
						"hard_kotei",
						"upgrade",
						"useproposal_kakunin",
						"tokusitu_useproposal",
						"useproposal_youken",
						"bikou",
						"yukou",
						"edition", 
						"disabled", 
						"memo"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}
		$app_col = select_code("00008");
		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',$app_col[@$_SESSION['input']['syonin_kbn']]);
		$this->tpl->assignHtml('action_param','app');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 内容確認
	 * 承認・却下
	 */
	function app_done(){
		$page_name = "system,syonin";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$licencehistory_pkey = addslashes(@$_SESSION['input']['licencehistory_pkey']);
		$syonin_kbn       = addslashes(@$_SESSION['input']['syonin_kbn']);
		$syoninsya        = addslashes(@$_SESSION['input']['syoninsya']);
		$syonin_date      = addslashes(@$_SESSION['input']['syonin_date']);

		$where = "licencehistory_pkey = ".$licencehistory_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_name']);
			#プログラムの追加と削除登録用データ
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = ereg_replace("\(RETURN\)","\r",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}
			#ダウングレード使用時のプログラムの追加と削除登録用データ
			if($detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = ereg_replace("\(RETURN\)","\r",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}
			$where = "history_pkey = ".$licencehistory_pkey." and history_type = 'd004'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => $syonin_kbn,
					"syoninsya"           => $syoninsya,
					"syonin_date"         => $syonin_date
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

			if($syonin_kbn == "d001"){
				$where = "licencelist_pkey = ".$detail['licencelist_pkey'];
				$fields_values = array(
						"soft_name"            => $detail['soft_name'],     
						"licence_keitai"       => $detail['licence_keitai'],     
						"brand"                => $detail['brand'],     
						"hard_kotei"           => $detail['hard_kotei'],
						"upgrade"              => $detail['upgrade'],
						"useproposal_kakunin"  => $detail['useproposal_kakunin'], 
						"tokusitu_useproposal" => $detail['tokusitu_useproposal'], 
						"useproposal_youken"   => $detail['useproposal_youken'], 
						"bikou"                => $detail['bikou'], 
						"yukou"                => $detail['yukou'], 
						"edition"              => $detail['edition'], 
						"disabled"             => $detail['disabled'], 
						"memo"                 => $detail['memo'], 
						"version"              => $detail['version'] + 1, 
						"upd_date"             => $detail['sinsei_date'], 
						"upd_name"             => $detail['sinseisya'], 
						"upd_syozoku"          => $detail['sinseisyozoku'], 
						"newkbn"               => 0
						      );
				$this->db->dbUpdate("\"licencelist\"", $fields_values, $where);
				$code = $detail['licencelist_pkey'];
				
				$where = "licencelist_pkey = ".$code;
				#プログラムの追加と削除登録
				$this->db->dbDelete("\"licencelistprogram\"", $where);
				for($i=0; $i<count($detail['program_add_del']); $i++){
					$fields_values = array(
							"licencelist_pkey"     => $code,
							"program_add_del"      => $detail['program_add_del'][$i]
							      );
					$this->db->dbInsert("\"licencelistprogram\"", $fields_values);
				}
				#ダウングレード使用時のプログラムの追加と削除登録
				$this->db->dbDelete("\"licencelistprogram_down\"", $where);
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					$fields_values = array(
							"licencelist_pkey"     => $code,
							"program_add_del"      => $detail['program_add_del_down'][$i]
							      );
					$this->db->dbInsert("\"licencelistprogram_down\"", $fields_values);
				}
			}else{
				$where_list = "licencelist_pkey = ".$detail['licencelist_pkey']." and newkbn = 1";
				$list = $this->db->dbSelect("select * from licencelist_detail where ".$where_list, "list");
				if(count($list) > 0){
					$this->db->dbDelete("\"licencelist\"", $where_list);
					$this->db->dbDelete("\"licencelistprogram\"", "licencelist_pkey = ".$detail['licencelist_pkey']);
					$this->db->dbDelete("\"licencelistprogram_down\"", "licencelist_pkey = ".$detail['licencelist_pkey']);
				}
			}

			if($syonin_kbn == "d001"){
				$action = "承認";
			}else{
				$action = "却下";
			}
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$syoninsya);
			$mail_tpl->assignHtml('syonin_date',$syonin_date);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス一覧表");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ライセンス一覧表　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		$app_col = select_code("00008");
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', $app_col[@$_SESSION['input']['syonin_kbn']]);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認
	 * 表示
	 */
	function app_view(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$licencehistory_pkey = addslashes(@$_REQUEST['code']);
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$history    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;

		#プログラムの追加と削除比較用データ
		if($history['program_add_del']){
			$history['program_add_del'] = ereg_replace("\r","",$history['program_add_del']);
			$history['program_add_del'] = explode("\n",$history['program_add_del']);
		}else{
			$history['program_add_del'] = array();
		}
		#ダウングレード使用時のプログラムの追加と削除比較用データ
		if($history['program_add_del_down']){
			$history['program_add_del_down'] = ereg_replace("\r","",$history['program_add_del_down']);
			$history['program_add_del_down'] = explode("\n",$history['program_add_del_down']);
		}else{
			$history['program_add_del_down'] = array();
		}

		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date']       = $detail['sinsei_date'];
		$item['sinseisya']         = $detail['sinseisya'];
		$item['licencehistory_pkey']  = $detail['licencehistory_pkey'];
		$item['version']           = $detail['version'];
		$item['email_ad']          = $detail['email_ad'];
		$user_referer              = _USER_REFERER;

		if($history['licencelist_pkey'] != ""){
			$version = $history['version']-1;
			$detail = $this->db->dbSelect("SELECT * FROM licencelist_rireki_detail where licencelist_pkey = ".$history['licencelist_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			#プログラムの追加と削除比較用データ
			if(@$detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}		
			#ダウングレード使用時のプログラムの追加と削除比較用データ
			if(@$detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}		

			/** プログラムの追加と削除比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$history['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $history['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$history['program_add_del'];
				if(count(@$history['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $history['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$history['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $history['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$history['program_add_del_down'];
				if(count(@$history['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $history['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}
		
			/** 比較 */
			$check_array = 	array(
						"soft_name",
						"licence_keitai",
						"brand",
						"hard_kotei",
						"upgrade",
						"useproposal_kakunin",
						"tokusitu_useproposal",
						"useproposal_youken",
						"bikou",
						"yukou",
						"edition", 
						"disabled", 
						"memo" 
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPVIEW);
		$this->tpl->assignHtml('action_param','app_view');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 内容確認
	 * 表示
	 */
	function rireki_del(){
		$this->tpl->assignHtml('title', _TITLE_APP_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$licencehistory_pkey = addslashes(@$_REQUEST['code']);
		$_SESSION['input']['licencehistory_pkey']    = $licencehistory_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		/** プログラムの追加と削除 */
		if($detail['program_add_del']){
			$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
			$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
		}else{
			$detail['program_add_del'] = array();
		}
		/** ダウングレード使用時のプログラムの追加と削除 */
		if($detail['program_add_del_down']){
			$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
			$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
		}else{
			$detail['program_add_del_down'] = array();
		}


		if(count($detail) > 0){
			$old    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date']       = $detail['sinsei_date'];
		$item['sinseisya']         = $detail['sinseisya'];
		$item['email_ad']          = $detail['email_ad'];
		$item['licencehistory_pkey']  = $detail['licencehistory_pkey'];
		$item['version']           = $detail['version'];
		$user_referer              = _USER_REFERER;

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','rireki_del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function rireki_del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$licencehistory_pkey = addslashes(@$_SESSION['input']['licencehistory_pkey']);
		$where = "licencehistory_pkey = ".$licencehistory_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from \"licencelist_rireki_detail\" where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_name']);
			/** 削除 */
			$this->db->dbDelete("\"licencelistrireki\"", $where);
			$this->db->dbDelete("\"licencelistprogramrireki\"", $where);
			$this->db->dbDelete("\"licencelistprogram_down_rireki\"", $where);
			$where_rireki = "history_pkey = ".$licencehistory_pkey." and history_type = 'd004'";
			$this->db->dbDelete("\"rireki\"", $where_rireki);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 削除
	 * 確認
	 */
	function del(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$licencelist_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['licencelist_pkey']    = $licencelist_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;

		/** エラーﾁｪｯｸ */
		$_SESSION['input']['method'] = "del";
		$this->check_del();
		if(@$_SESSION['input']['error_flag'] == true || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
		}

		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".$licencelist_pkey."'", "detail");
		if(count($detail) > 0){
			$item    = $detail;
			/** プログラムの追加と削除 */
			if($item['program_add_del']){
				$item['program_add_del'] = explode("\n",$item['program_add_del']);
			}else{
				$item['program_add_del'] = array();
			}
			/** ダウングレード使用時のプログラムの追加と削除 */
			if($item['program_add_del_down']){
				$item['program_add_del_down'] = explode("\n",$item['program_add_del_down']);
			}else{
				$item['program_add_del_down'] = array();
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('licenselist/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$licencelist_pkey = addslashes(@$_SESSION['input']['licencelist_pkey']);
		$where = "licencelist_pkey = ".$licencelist_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select soft_name from \"licencelist\" where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_name']);
			/** 削除 */
			$this->db->dbDelete("\"licencelist\"", $where);
			/** program削除 */
			$this->db->dbDelete("\"licencelistprogram\"", $where);
			/** program_down削除 */
			$this->db->dbDelete("\"licencelistprogram_down\"", $where);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check(){
		
		#入力チェック(警告)
		$cci_att = new CheckItem;
		if(@$_SESSION['input']['brand'] == "" and _ERROR_0250){
			$cci_att->checkErrorCode("0250");
		}
		#プログラムの追加と削除の選択有無
		if(@$_SESSION['input']['program_add_del'] == "" and _ERROR_0246){
			$cci_att->checkErrorCode("0246",array("プログラムの追加と削除","プログラムの追加と削除"));
		}
		#ダウングレード使用時のプログラムの追加と削除の選択有無
		if(@$_SESSION['input']['program_add_del_down'] == "" and _ERROR_0246){
			$cci_att->checkErrorCode("0246",array("ダウングレード使用時のプログラムの追加と削除","ダウングレード使用時のプログラムの追加と削除"));
		}
		
		if($_SESSION['input']['method'] != "app_reg"){
			$where = " where licencelist_pkey = '".addslashes($_SESSION['input']['licencelist_pkey'])."'";
			$detail = $this->db->dbSelect("select * from licencelist".$where, "detail");
			$in_soft_name = preg_quote(@$_SESSION['input']['soft_name']);
			$de_soft_name = preg_quote(@$detail['soft_name']);
			if(!ereg($in_soft_name,@$detail['soft_name']) and !ereg($de_soft_name,@$_SESSION['input']['soft_name']) and _ERROR_0260){
				$cci_att->checkErrorCode("260");
			}
		}
		if($_SESSION['input']['method'] != "edit"){
			if(@$_SESSION['input']['licence_keitai'] == 'd001' and _ERROR_0265){
				$cci_att->checkErrorCode("265");
			}
		}
		if($cci_att->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['att_flag']  = true;
			$_SESSION['input']['att_msg']   = $cci_att->error_msg;
		}
		
		
		#入力チェック
		$cci = new CheckItem;

		#バージョンチェック
		if($_SESSION['input']['method'] != "app_reg"){
			$where = " where licencelist_pkey = ".$_SESSION['input']['licencelist_pkey'];
			$detail = $this->db->dbSelect("select * from licencelist_detail".$where, "detail");
			if(@$_SESSION['input']['version'] != $detail['version'] and _ERROR_0051){
				$cci->checkErrorCode("0051");
			}
		}

		if($_SESSION['input']['method'] != "edit"){
			$cci->checkItemNon(array("email_ad"=>"申請者メールアドレス"));
			$cci->checkItemEmailArray(array("email_ad"=>"申請者メールアドレス"));
		
			$email_ad = explode("@",@$_SESSION['input']['email_ad']);
			if(count($email_ad)>=2){
				if(!in_array($email_ad[1],select_code("00027")) and _ERROR_0254){
					$cci->checkErrorCode("0254");
				}
			}
		}
		if($_SESSION['input']['method'] == "app_edit"){
			$where = " where licencelist_pkey = ".$_SESSION['input']['licencelist_pkey'];
			$detail = $this->db->dbSelect("select * from licencelist_detail".$where, "detail");
			if(@$_SESSION['input']['licence_keitai'] != @$detail['licence_keitai'] and @$detail['licence_keitai'] != 'd001' and $this->authuser_authority != "system" and _ERROR_0261){
				$cci->checkErrorCode("0261");
			}
			if(@$_SESSION['input']['hard_kotei'] != @$detail['hard_kotei'] and _ERROR_0262){
				$cci->checkErrorCode("0262");
			}
			if(@$_SESSION['input']['upgrade'] != @$detail['upgrade'] and _ERROR_0263){
				$cci->checkErrorCode("0263");
			}



			$where = " where licencelist_pkey = ".$_SESSION['input']['licencelist_pkey'];
			#プログラムの追加と削除の削除禁止
			$list = $this->db->dbSelect("select program_add_del from licencelistprogram".$where, "list");
			if(count($list) > 0){
				for($i=0; $i<count($list); $i++){
					$list[$i]['program_add_del'] = ereg_replace("\r","(RETURN)",$list[$i]['program_add_del']);
				}
			}
			$array_check = true;
			for($i=0; $i<count($list); $i++){
				if(count(@$_SESSION['input']['program_add_del']) > 0){
					if(!in_array($list[$i]['program_add_del'],@$_SESSION['input']['program_add_del'])) {
						$array_check = false;
					} 
				}else{
					$array_check = false;
				}
			}
			if(!$array_check and _ERROR_0264){
				$cci->checkErrorCode("0264",array("プログラムの追加と削除での表示","プログラムの追加と削除での表示"));
			}
			#ダウングレード使用時のプログラムの追加と削除の削除禁止
			$list = $this->db->dbSelect("select program_add_del from licencelistprogram_down".$where, "list");
			if(count($list) > 0){
				for($i=0; $i<count($list); $i++){
					$list[$i]['program_add_del'] = ereg_replace("\r","(RETURN)",$list[$i]['program_add_del']);
				}
			}
			$array_check = true;
			for($i=0; $i<count($list); $i++){
				if(count(@$_SESSION['input']['program_add_del_down']) > 0){
					if(!in_array($list[$i]['program_add_del'],@$_SESSION['input']['program_add_del_down'])) {
						$array_check = false;
					} 
				}else{
					$array_check = false;
				}
			}
			if(!$array_check and _ERROR_0264){
				$cci->checkErrorCode("0264",array("ダウングレード使用時のプログラムの追加と削除での表示","ダウングレード使用時のプログラムの追加と削除での表示"));
			}
		}

		$error_name_array = select_code("00013");

		if(@$_SESSION['input']['soft_name'] == "" and _ERROR_0239){
			$cci->checkErrorCode("0239");
		}
		if(@$_SESSION['input']['licence_keitai'] == "" and _ERROR_0240){
			$cci->checkErrorCode("0240");
		}
		if(@$_SESSION['input']['hard_kotei'] == "" and _ERROR_0241){
			$cci->checkErrorCode("0241");
		}
		if(@$_SESSION['input']['upgrade'] == "" and _ERROR_0242){
			$cci->checkErrorCode("0242");
		}
		if(@$_SESSION['input']['tokusitu_useproposal'] == "" and _ERROR_0243){
			$cci->checkErrorCode("0243");
		}
		if(@$_SESSION['input']['useproposal_youken'] == "" and _ERROR_0244){
			$cci->checkErrorCode("0244");
		}
		
		if($_SESSION['input']['method'] == "app_reg"){
			$where = " where soft_name = '".addslashes($_SESSION['input']['soft_name'])."' and licence_keitai = '".$_SESSION['input']['licence_keitai']."' and hard_kotei = '".$_SESSION['input']['hard_kotei']."' and upgrade = '".$_SESSION['input']['upgrade']."'";
		}else{
			$where = " where licencelist_pkey != ".$_SESSION['input']['licencelist_pkey']." and soft_name = '".addslashes($_SESSION['input']['soft_name'])."' and licence_keitai = '".$_SESSION['input']['licence_keitai']."' and hard_kotei = '".$_SESSION['input']['hard_kotei']."' and upgrade = '".$_SESSION['input']['upgrade']."'";
		}
		if($_SESSION['input']['edition'] != ""){
			$where .= " and edition = '".$_SESSION['input']['edition']."'";
		}else{
			$where .= " and edition is null";
		}
		/** 詳細ﾃﾞｰﾀ */
		$list = $this->db->dbSelect("select * from licencelist_detail".$where, "list");
		if(count($list) > 0 and _ERROR_0245){
			$cci->checkErrorCode("0245");
		}
		if(@$_SESSION['input']['licence_keitai'] == "d005" and @$_SESSION['input']['hard_kotei'] == "d002" and _ERROR_0247){
			$cci->checkErrorCode("0247");
		}
		if(@$_SESSION['input']['licence_keitai'] != "d005" and @$_SESSION['input']['hard_kotei'] == "d001" and _ERROR_0248){
			$cci->checkErrorCode("0248");
		}
		if(@$_SESSION['input']['useproposal_kakunin'] == "" and _ERROR_0251){
			$cci->checkErrorCode("0251");
		}
		if(@$_SESSION['input']['yukou'] == "" and _ERROR_0252){
			$cci->checkErrorCode("0252");
		}
		if(@$_SESSION['input']['upd_syozoku'] == "0" and _ERROR_0253){
			$cci->checkErrorCode("0253");
		}
		if($_SESSION['input']['method'] == "edit" or $_SESSION['input']['method'] == "del"){
			$cci->checkItemNon(array("upd_date"=>$error_name_array['012'],"upd_name"=>$error_name_array['011']));
		}else{
			if(@$_SESSION['input']['sinseisya'] == "" and _ERROR_0201){
				$cci->checkErrorCode("0201");
			}
			if(@$_SESSION['input']['sinsei_date'] == "" and _ERROR_0202){
				$cci->checkErrorCode("0202");
			}
		}
		$cci->checkItemDate01(array("upd_date"=>$error_name_array['012']));
		$cci->checkItemDateTime(array("sinsei_date"=>"申請日"));
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check_app(){
		#入力チェック
		$cci = new CheckItem;

		#バージョンチェック
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$_SESSION['input']['licencehistory_pkey'], "detail");
		if($detail['licencelist_pkey'] != ""){
			$detail_old = $this->db->dbSelect("SELECT * FROM licencelist_detail where licencelist_pkey = ".$detail['licencelist_pkey'], "detail");
			if($detail['version'] != $detail_old['version'] and _ERROR_0103){
				$cci->checkErrorCode("0103");
			}
		}
		if (strtotime(@$_SESSION['input']['syonin_date']) < strtotime($detail['sinsei_date']) and _ERROR_0104) {
			$cci->checkErrorCode("0104");
		}
		if(@$_SESSION['input']['syoninsya'] == "" and _ERROR_0101){
			$cci->checkErrorCode("0101");
		}
		if(@$_SESSION['input']['syonin_date'] == "" and _ERROR_0102){
			$cci->checkErrorCode("0102");
		}

		$error_name_array = select_code("00015");
		$cci->checkItemDateTime(array("syonin_date"=>$error_name_array['007']));
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check_del(){
		#入力チェック
		$cci = new CheckItem;

		#バージョンチェック
		$where = " where licencelist_pkey = '".addslashes($_SESSION['input']['licencelist_pkey'])."'";
		$list = $this->db->dbSelect("select * from licence".$where, "list");
		if(count($list) > 0 and _ERROR_0023){
			$cci->checkErrorCode("0023",array("ライセンス一覧表から選択","ライセンス"));
		}
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "";
		$this->login($page_name);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			if($this->authuser_authority != "system"){
				$_SESSION['csv'] = " where yukou = 'd001' and newkbn <> 1";
			}else{
				$_SESSION['csv'] = " where newkbn <> 1";
			}
		}
		
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=license_list.csv");

		$list = $this->db->dbSelect("SELECT * FROM licencelist_detail".$_SESSION['csv'], "list");
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		print mb_convert_encoding($this->tpl->fetchHtml('licenselist/csv.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * プログラムの追加と削除CSV出力
	 */
	function csv_program(){
		$page_name = "";
		$this->login($page_name);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			if($this->authuser_authority != "system"){
				$_SESSION['csv'] = " where yukou = 'd001' and newkbn <> 1";
			}else{
				$_SESSION['csv'] = " where newkbn <> 1";
			}
		}
		
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=licencelist_program.csv");

		$list = $this->db->dbSelect("SELECT licencelist_pkey,program_name FROM licencelist_program_detail".$_SESSION['csv'], "list");
		$this->tpl->assignHtml('list_view',  $list);
		print mb_convert_encoding($this->tpl->fetchHtml('licenselist/csv_program.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * ダウングレード使用時のプログラムの追加と削除CSV出力
	 */
	function csv_program_down(){
		$page_name = "";
		$this->login($page_name);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			if($this->authuser_authority != "system"){
				$_SESSION['csv'] = " where yukou = 'd001' and newkbn <> 1";
			}else{
				$_SESSION['csv'] = " where newkbn <> 1";
			}
		}
		
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=licencelist_program_down.csv");

		$list = $this->db->dbSelect("SELECT licencelist_pkey,program_name FROM licencelist_program_down_detail".$_SESSION['csv'], "list");
		$this->tpl->assignHtml('list_view',  $list);
		print mb_convert_encoding($this->tpl->fetchHtml('licenselist/csv_program.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * プリント出力
	 */
	function prt(){
		$page_name = "";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			if($this->authuser_authority != "system"){
				$_SESSION['csv'] = " where yukou = 'd001' and newkbn <> 1";
			}else{
				$_SESSION['csv'] = " where newkbn <> 1";
			}
		}
		
		$list = $this->db->dbSelect("SELECT * FROM licencelist_detail".$_SESSION['csv'], "list");
		if(count($list) > 0){
			for($i=0; $i<count($list); $i++){
				/** プログラムの追加と削除での表示 */
				$program_add_del_array = explode("\n",$list[$i]['program_add_del']);
				$list[$i]['program_add_del'] = $program_add_del_array;
				/**  ダウングレード使用時のプログラムの追加と削除での表示 */
				$program_add_del_down_array = explode("\n",$list[$i]['program_add_del_down']);
				$list[$i]['program_add_del_down'] = $program_add_del_down_array;
			}
		}

		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('list_view',$list);
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('licenselist/print.html'));
		$this->tpl->outputHtml('print_list.html');

	}
	
	/**
	 * 申請書印刷
	 */
	function app_print(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_APP);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		if(@$_SESSION['input']['licencelist_pkey'] != ""){
			$detail = $this->db->dbSelect("SELECT * FROM licencelist_detail where licencelist_pkey = ".$_SESSION['input']['licencelist_pkey'], "detail");
			#プログラムの追加と削除比較用データ
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}
			#ダウングレード使用時のプログラムの追加と削除比較用データ
			if($detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}
		
			/** プログラムの追加と削除比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$_SESSION['input']['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $_SESSION['input']['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$_SESSION['input']['program_add_del'];
				if(count(@$_SESSION['input']['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $_SESSION['input']['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$_SESSION['input']['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $_SESSION['input']['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$_SESSION['input']['program_add_del_down'];
				if(count(@$_SESSION['input']['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $_SESSION['input']['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}
			
			

			$check_array = 	array(
						"soft_name",
						"licence_keitai",
						"brand",
						"hard_kotei",
						"upgrade",
						"useproposal_kakunin",
						"tokusitu_useproposal",
						"useproposal_youken",
						"bikou",
						"yukou",
						"edition", 
						"disabled", 
						"memo"
					);
			foreach($check_array as $val){
				if($detail[$val] != @$_SESSION['input'][$val]){
					$old[$val] = $detail[$val];
					if(@$_SESSION['input'][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $_SESSION['input'][$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
			
		}else{
			$new = $_SESSION['input'];
		}
		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',$_SESSION['input']);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		/** set template */
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('licenselist/print_sinsei.html'));
		$this->tpl->outputHtml('print_sinsei.html');
	}
	
	/**
	 * 申請書印刷
	 */
	function app_print_r(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST_APP);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		$licencehistory_pkey = addslashes(@$_REQUEST['code']);
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$history    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;

		#プログラムの追加と削除比較用データ
		if($history['program_add_del']){
			$history['program_add_del'] = ereg_replace("\r","",$history['program_add_del']);
			$history['program_add_del'] = explode("\n",$history['program_add_del']);
		}else{
			$history['program_add_del'] = array();
		}
		#ダウングレード使用時のプログラムの追加と削除比較用データ
		if($history['program_add_del_down']){
			$history['program_add_del_down'] = ereg_replace("\r","",$history['program_add_del_down']);
			$history['program_add_del_down'] = explode("\n",$history['program_add_del_down']);
		}else{
			$history['program_add_del_down'] = array();
		}
		#特筆すべき使用許諾条件比較用データ
		$history['tokusitu_useproposal'] = ereg_replace("\r\n","\n",$history['tokusitu_useproposal']);
		$history['tokusitu_useproposal'] = ereg_replace("\r","",$history['tokusitu_useproposal']);

		#ライセンス保有証明部材比較用データ
		$history['useproposal_youken'] = ereg_replace("\r\n","\n",$history['useproposal_youken']);
		$history['useproposal_youken'] = ereg_replace("\r","",$history['useproposal_youken']);

		#ライセンス一覧表備考比較用データ
		$history['bikou'] = ereg_replace("\r\n","\n",$history['bikou']);
		$history['bikou'] = ereg_replace("\r","",$history['bikou']);

		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date']       = $detail['sinsei_date'];
		$item['sinseisya']         = $detail['sinseisya'];
		$item['licencehistory_pkey']  = $detail['licencehistory_pkey'];
		$item['version']           = $detail['version'];
		$item['email_ad']          = $detail['email_ad'];
		$user_referer              = _USER_REFERER;

		if($history['licencelist_pkey'] != ""){
			$version = $history['version']-1;
			$detail = $this->db->dbSelect("SELECT * FROM licencelist_rireki_detail where licencelist_pkey = ".$history['licencelist_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			#プログラムの追加と削除比較用データ
			if(@$detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}		
			#ダウングレード使用時のプログラムの追加と削除比較用データ
			if(@$detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}		
			#特筆すべき使用許諾条件比較用データ
			$detail['tokusitu_useproposal'] = ereg_replace("\r\n","\n",@$detail['tokusitu_useproposal']);
			$detail['tokusitu_useproposal'] = ereg_replace("\r","",@$detail['tokusitu_useproposal']);

			#ライセンス保有証明部材比較用データ
			$detail['useproposal_youken'] = ereg_replace("\r\n","\n",@$detail['useproposal_youken']);
			$detail['useproposal_youken'] = ereg_replace("\r","",@$detail['useproposal_youken']);

			#ライセンス一覧表備考比較用データ
			$detail['bikou'] = ereg_replace("\r\n","\n",@$detail['bikou']);
			$detail['bikou'] = ereg_replace("\r","",@$detail['bikou']);

			/** プログラムの追加と削除比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$history['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $history['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$history['program_add_del'];
				if(count(@$history['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $history['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$history['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $history['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$history['program_add_del_down'];
				if(count(@$history['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $history['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}
		
			/** 比較 */
			$check_array = 	array(
						"soft_name",
						"licence_keitai",
						"brand",
						"hard_kotei",
						"upgrade",
						"useproposal_kakunin",
						"tokusitu_useproposal",
						"useproposal_youken",
						"bikou",
						"yukou",
						"edition", 
						"disabled", 
						"memo"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}

		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',@$item);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		/** set template */
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('licenselist/print_sinsei.html'));
		$this->tpl->outputHtml('print_sinsei.html');
	}
	
	/**
	 * プログラムの追加と削除一覧
	 */
	function program_search(){
		parse_str($_POST['params'],$request);
		$_REQUEST['add_name'] = @$request['program_add_del'];
		$this->tpl->assignHtml('title', _TITLE_PROGRAM_SELECT);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "program_add_del";
		}
		if(@$_REQUEST['sort_asc'] == "DESC"){
			$_REQUEST['sort_asc'] = "DESC";
		}else{
			$_REQUEST['sort_asc'] = "ASC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by lower(".$this->sort.") ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		@$_REQUEST['search_name'] = trim(@$_REQUEST['search_name']);
		if(@$_REQUEST['search_name'] != ""){
			$where = " where LOWER(program_add_del) like LOWER('%".addslashes($_REQUEST['search_name'])."%')";
		}else{
			$where = "";
		}
		$this->tpl->assignHtml('search_name',  @$_REQUEST['search_name']);

		if(count(@$_REQUEST['add_name']) > 0){
			$add_name = @$_REQUEST['add_name'];
		}else{
			$add_name = array();
		}
		$this->tpl->assignHtml('add_name',$add_name);

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM program".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM program".$where.$order.$limit, "list");
			if(count($list_limit) > 0){
				for($i=0; $i<count($list_limit); $i++){
					$list_limit[$i]['program_add_del'] = ereg_replace("\n","(RETURN)",ereg_replace("\r","(RETURN)",$list_limit[$i]['program_add_del']));
				}
			}
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->outputHtml('licenselist/program_search.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}
	
	/**
	 * ダウングレード使用時のプログラムの追加と削除一覧
	 */
	function program_search_down(){
		parse_str($_POST['params'],$request);
		$_REQUEST['add_name'] = @$request['program_add_del_down'];
		$this->tpl->assignHtml('title', _TITLE_PROGRAM_SELECT);
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "program_add_del";
		}
		if(@$_REQUEST['sort_asc'] == "DESC"){
			$_REQUEST['sort_asc'] = "DESC";
		}else{
			$_REQUEST['sort_asc'] = "ASC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by lower(".$this->sort.") ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		@$_REQUEST['search_name'] = trim(@$_REQUEST['search_name']);
		if(@$_REQUEST['search_name'] != ""){
			$where = " where LOWER(program_add_del) like LOWER('%".addslashes($_REQUEST['search_name'])."%')";
		}else{
			$where = "";
		}
		$this->tpl->assignHtml('search_name',  @$_REQUEST['search_name']);

		if(count(@$_REQUEST['add_name']) > 0){
			$add_name = @$_REQUEST['add_name'];
		}else{
			$add_name = array();
		}
		$this->tpl->assignHtml('add_name',$add_name);

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM program".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM program".$where.$order.$limit, "list");
			if(count($list_limit) > 0){
				for($i=0; $i<count($list_limit); $i++){
					$list_limit[$i]['program_add_del'] = ereg_replace("\n","(RETURN)",ereg_replace("\r","(RETURN)",$list_limit[$i]['program_add_del']));
				}
			}
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->outputHtml('licenselist/program_search.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * プログラムの追加と削除一覧
	 */
	function program_search_reload(){
		parse_str($_POST['params'],$request);
		$_REQUEST['page'] = @$request['page'];
		
		$this->tpl->assignHtml('title', _TITLE_PROGRAM_SELECT);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** パラメータ */
		$param_key = ereg_key($request,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($request,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$request['sort_name'] == ""){
			$request['sort_name'] = "program_add_del";
		}
		if(@$request['sort_asc'] == "DESC"){
			$request['sort_asc'] = "DESC";
		}else{
			$request['sort_asc'] = "ASC";
		}
		$this->sort = $request['sort_name'];
		$this->asc = $request['sort_asc'];
		$order = " order by lower(".$this->sort.") ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		@$request['search_name'] = trim(@$request['search_name']);
		if(@$request['search_name'] != ""){
			$where = " where LOWER(program_add_del) like LOWER('%".addslashes($request['search_name'])."%')";
		}else{
			$where = "";
		}
		$this->tpl->assignHtml('search_name',  @$request['search_name']);

		if(count(@$request['add_name']) > 0){
			$add_name = @$request['add_name'];
		}else{
			$add_name = array();
		}
		$this->tpl->assignHtml('add_name',$add_name);

		if(count(@$request['fix_name']) > 0){
			$fix_name = @$request['fix_name'];
		}else{
			$fix_name = array();
		}
		$this->tpl->assignHtml('fix_name',$fix_name);
		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM program".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM program".$where.$order.$limit, "list");
			if(count($list_limit) > 0){
				for($i=0; $i<count($list_limit); $i++){
					$list_limit[$i]['program_add_del'] = ereg_replace("\n","(RETURN)",ereg_replace("\r","(RETURN)",$list_limit[$i]['program_add_del']));
				}
			}
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->outputHtml('licenselist/program_search_reroad.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * プログラムの追加と削除一覧
	 */
	function program_search_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		parse_str($_POST['params'],$request);

		$program_add_del = @$request['fix_name'];
		if(count(@$program_add_del) > 0 and count(@$request['add_name']) > 0){
			$program_add_del = array_merge($program_add_del,$request['add_name']);
		}elseif(count(@$program_add_del) <= 0 and count(@$request['add_name']) > 0){
			$program_add_del = $request['add_name'];
		}elseif(count(@$program_add_del) > 0 and count(@$request['add_name']) <= 0){
		}else{
			$program_add_del = array();
		}
		
		if(@$request['direct_name'] != ""){
			$direct_list = explode("\r\n",$request['direct_name']);
			for($i=0;$i<count($direct_list);$i++){
				if($direct_list[$i] != ""){
					array_push($program_add_del,$direct_list[$i]);
				}
			}
		}
		
		
		if(count(@$program_add_del) > 0){
			$first_pg = ereg_replace("\n","",addslashes($program_add_del[0]));
			$first_pg = ereg_replace("\(RETURN\)","",$first_pg);
		}else{
			$first_pg = "";
		}

		$this->tpl->assignHtml('program_add_del',$program_add_del);
		$html = $this->tpl->fetchHtml('licenselist/program_list.html');
		$program_list = '{"list":"'.ereg_replace("\n","",addslashes($html)).'","first":"'.$first_pg.'"}';
		print $program_list;
	}

	/**
	 * プログラムの追加と削除一覧
	 */
	function program_search_down_done(){
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		parse_str($_POST['params'],$request);

		$program_add_del = @$request['fix_name'];
		if(count(@$program_add_del) > 0 and count(@$request['add_name']) > 0){
			$program_add_del = array_merge($program_add_del,$request['add_name']);
		}elseif(count(@$program_add_del) <= 0 and count(@$request['add_name']) > 0){
			$program_add_del = $request['add_name'];
		}elseif(count(@$program_add_del) > 0 and count(@$request['add_name']) <= 0){
		}else{
			$program_add_del = array();
		}
		
		if(@$request['direct_name'] != ""){
			$direct_list = explode("\r\n",$request['direct_name']);
			for($i=0;$i<count($direct_list);$i++){
				if($direct_list[$i] != ""){
					array_push($program_add_del,$direct_list[$i]);
				}
			}
		}
		
		
		if(count(@$program_add_del) > 0){
			$first_pg = ereg_replace("\n","",addslashes($program_add_del[0]));
			$first_pg = ereg_replace("\(RETURN\)","",$first_pg);
		}else{
			$first_pg = "";
		}

		$this->tpl->assignHtml('program_add_del_down',$program_add_del);
		$html = $this->tpl->fetchHtml('licenselist/program_list_down.html');
		$program_list = '{"list":"'.ereg_replace("\n","",addslashes($html)).'","first":"'.$first_pg.'"}';
		print $program_list;
	}

	/**
	 * プログラムの追加と削除一覧
	 */
	function licenselist_search(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "soft_name";
		}
		if(@$_REQUEST['sort_asc'] == "DESC"){
			$_REQUEST['sort_asc'] = "DESC";
		}else{
			$_REQUEST['sort_asc'] = "ASC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "001";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "soft_name";
				        break;
				    case "002":
					$s_col = "licence_keitai_name";
				        break;
				    case "003":
					$s_col = "brand";
				        break;
				    case "004":
					$s_col = "hard_kotei_name";
				        break;
				    case "005":
					$s_col = "upgrade_name";
				        break;
				    case "006":
					$s_col = "licencelist_pkey";
				        break;
				    case "007":
					$s_col = "edition";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes(@$_REQUEST[$val])."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes(@$_REQUEST[$val])."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes(@$_REQUEST[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= " and yukou = 'd001')";
		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licencelist_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licencelist_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** set template */
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('license_col', select_code("00021"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->outputHtml('licenselist/sub_list.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * プログラムの追加と削除一覧
	 */
	function licenselist_search_reload(){
		parse_str($_POST['params'],$request);
		$_REQUEST['page'] = @$request['page'];

		$this->tpl->assignHtml('title', _TITLE_LICENSE_LIST);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** パラメータ */
		$param_key = ereg_key($request,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($request,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$request['sort_name'] == ""){
			$request['sort_name'] = "program_add_del";
		}
		if(@$request['sort_asc'] == "DESC"){
			$request['sort_asc'] = "DESC";
		}else{
			$request['sort_asc'] = "ASC";
		}
		$this->sort = $request['sort_name'];
		$this->asc = $request['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** デフォルト値設定 */
		if(@$request['search_col1'] == ""){
			$request['search_col1'] = "001";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$request[$val] = trim(@$request[$val]);
			if(@$request[$val] != "" and @$request[$col] != ""){
				switch (@$request[$col]){
				    case "001":
					$s_col = "soft_name";
				        break;
				    case "002":
					$s_col = "licence_keitai_name";
				        break;
				    case "003":
					$s_col = "brand";
				        break;
				    case "004":
					$s_col = "hard_kotei_name";
				        break;
				    case "005":
					$s_col = "upgrade_name";
				        break;
				    case "006":
					$s_col = "licencelist_pkey";
				        break;
				    case "007":
					$s_col = "edition";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$request[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes(@$request[$val])."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes(@$request[$val])."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes(@$request[$val])."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes(@$request[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes(@$request[$val])."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$request[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$request[$col]);
			$this->tpl->assignHtml($val,@$request[$val]);
			$this->tpl->assignHtml($comp,@$request[$comp]);
			$this->tpl->assignHtml($cd,@$request[$cd]);
		}

		$where .= " and yukou = 'd001')";

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licencelist_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licencelist_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** set template */
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('license_col', select_code("00021"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$html = $this->tpl->fetchHtml('licenselist/sub_list_reload.html');
		print $html;
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * プログラムの追加と削除一覧
	 */
	function licenselist_search_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		$gaitou_col = select_code("00004");
		$type_col   = select_code("00005");
		
		if(@$_REQUEST['no'] != "undefined" and @$_REQUEST['no'] != ""){
			$where = " where licencelist_pkey = ".$_REQUEST['no'];
			$detail = $this->db->dbSelect("SELECT * FROM licencelist_detail".$where, "detail");

			$detail['tokusitu_useproposal']    = ereg_replace("\n","<br />",$detail['tokusitu_useproposal']);
			#プログラムの追加と削除表示用データ
			$program_add_del_array = explode("\n",$detail['program_add_del']);
			$detail['program_add_del'] = "";
			if(count($program_add_del_array) > 0){
				for($i=0; $i<count($program_add_del_array); $i++){
					$detail['program_add_del'] .= "<span><pre>".ereg_replace("\(RETURN\)","\n",htmlspecialchars($program_add_del_array[$i]))."</pre></span>";
				}
			}
			#ダウングレード使用時のプログラムの追加と削除表示用データ
			$program_add_del_down_array = explode("\n",$detail['program_add_del_down']);
			$detail['program_add_del_down'] = "";
			if(count($program_add_del_down_array) > 0){
				for($i=0; $i<count($program_add_del_down_array); $i++){
					$detail['program_add_del_down'] .= "<span><pre>".ereg_replace("\(RETURN\)","\n",htmlspecialchars($program_add_del_down_array[$i]))."</pre></span>";
				}
			}
			$detail['licence_keitai_name']     = $type_col[$detail['licence_keitai']];
			$detail['hard_kotei_name']         = $gaitou_col[$detail['hard_kotei']];
			$detail['upgrade_name']            = $gaitou_col[$detail['upgrade']];
			foreach($detail as $key => $value){
				if($detail[$key] == ""){
					$detail[$key] = "&nbsp;";
				}
			}

		}else{
			$detail['hard_kotei']               = "&nbsp;";
			$detail['upgrade']                  = "&nbsp;";
			$detail['licencelist_pkey']         = "";
			$detail['brand']                    = "&nbsp;";
			$detail['edition']                  = "&nbsp;";
			$detail['soft_name']                = "&nbsp;";
			$detail['licence_keitai_name']      = "&nbsp;";
			$detail['hard_kotei_name']          = "&nbsp;";
			$detail['upgrade_name']             = "&nbsp;";
			$detail['tokusitu_useproposal']     = "&nbsp;";
			$detail['useproposal_youken']       = "&nbsp;";
			$detail['program_add_del']          = "&nbsp;";
			$detail['program_add_del_down']          = "&nbsp;";
		}
		$json = new Services_JSON();
		$license_list_detail = $json->encode($detail);
		
		print $license_list_detail;
	}
	
	function auto_app($pkey){

		$where = "licencehistory_pkey = ".$pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where ".$where, "detail");
		#プログラムの追加と削除登録用データ
		if($detail['program_add_del']){
			$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
			$detail['program_add_del'] = ereg_replace("\(RETURN\)","\r",$detail['program_add_del']);
			$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
		}else{
			$detail['program_add_del'] = array();
		}
		#ダウングレード使用時のプログラムの追加と削除登録用データ
		if($detail['program_add_del_down']){
			$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
			$detail['program_add_del_down'] = ereg_replace("\(RETURN\)","\r",$detail['program_add_del_down']);
			$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
		}else{
			$detail['program_add_del_down'] = array();
		}
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_name']);
			$where = "history_pkey = ".$pkey." and history_type = 'd004'";
			/** 自動承認 */
			$fields_values = array(
					"syonin_kbn"          => "d001",
					"syoninsya"           => "自動承認",
					"syonin_date"         => date("Y/m/d H:i")
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);
			
			$where = "licencelist_pkey = ".$detail['licencelist_pkey'];
			$fields_values = array(
					"soft_name"            => $detail['soft_name'],     
					"licence_keitai"       => $detail['licence_keitai'],     
					"brand"                => $detail['brand'],     
					"hard_kotei"           => $detail['hard_kotei'],
					"upgrade"              => $detail['upgrade'],
					"useproposal_kakunin"  => $detail['useproposal_kakunin'], 
					"tokusitu_useproposal" => $detail['tokusitu_useproposal'], 
					"useproposal_youken"   => $detail['useproposal_youken'], 
					"bikou"                => $detail['bikou'], 
					"yukou"                => $detail['yukou'], 
					"edition"              => $detail['edition'], 
					"disabled"             => $detail['disabled'], 
					"memo"                 => $detail['memo'], 
					"version"              => $detail['version'] + 1, 
					"upd_date"             => $detail['sinsei_date'], 
					"upd_name"             => $detail['sinseisya'], 
					"upd_syozoku"          => $detail['sinseisyozoku'], 
					"newkbn"               => 0
					      );
			$this->db->dbUpdate("\"licencelist\"", $fields_values, $where);
			$code = $detail['licencelist_pkey'];
			
			$where = "licencelist_pkey = ".$code;
			#プログラムの追加と削除登録
			$this->db->dbDelete("\"licencelistprogram\"", $where);
			for($i=0; $i<count($detail['program_add_del']); $i++){
				$fields_values = array(
						"licencelist_pkey"     => $code,
						"program_add_del"      => $detail['program_add_del'][$i]
						      );
				$this->db->dbInsert("\"licencelistprogram\"", $fields_values);
			}
			#ダウングレード使用時のプログラムの追加と削除登録
			$this->db->dbDelete("\"licencelistprogram_down\"", $where);
			for($i=0; $i<count($detail['program_add_del_down']); $i++){
				$fields_values = array(
						"licencelist_pkey"     => $code,
						"program_add_del"      => $detail['program_add_del_down'][$i]
						      );
				$this->db->dbInsert("\"licencelistprogram_down\"", $fields_values);
			}

			$action = "承認";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',"自動承認");
			$mail_tpl->assignHtml('syonin_date',date("Y/m/d H:i"));
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス一覧表");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ライセンス一覧表　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}
	}

}

?>