<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** ライセンス台帳管理 */
class LicenseModel extends Model{

	/**
	 * ﾕｰｻﾞｰcode(登録者)
	 * @var int
	 */
	var $authuser_code;
	
	/**
	 * 使用権限のみ
	 */
	var $use_only = false;
	
	/**
	 * 一覧
	 */
	function index(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
			$_REQUEST['search_haiki'] = "on";
			$_REQUEST['search_zero'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);
		$this->tpl->assignHtml('search_haiki',@$_REQUEST['search_haiki']);
		$this->tpl->assignHtml('search_zero',@$_REQUEST['search_zero']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "licence_pkey";
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "002";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "sosiki_fullname";
				        break;
				    case "025":
					$s_col = "kanri_sosiki_fullname";
				        break;
				    case "002":
					$s_col = "licence_kanrino";
				        break;
				    case "003":
					$s_col = "soft_name";
				        break;
				    case "004":
					$s_col = "licence_keitai_name";
				        break;
				    case "005":
					$s_col = "brand";
				        break;
				    case "006":
					$s_col = "install_su";
				        break;
				    case "007":
					$s_col = "install_qty";
				        break;
				    case "008":
					$s_col = "hard_kotei_name";
				        break;
				    case "009":
					$s_col = "hard_kanrino";
				        break;
				    case "010":
					$s_col = "upgrade_name";
				        break;
				    case "011":
					$s_col = "up_licence_kanrino";
				        break;
				    case "012":
					$s_col = "licence_no";
				        break;
				    case "013":
					$s_col = "tyoutatu";
				        break;
				    case "014":
					$s_col = "useproposal_kakunin";
				        break;
				    case "015":
					$s_col = "tokusitu_useproposal";
				        break;
				    case "016":
					$s_col = "useproposal_youken";
				        break;
				    case "017":
					$s_col = "hokan_baitai";
				        break;
				    case "018":
					$s_col = "hokan_basyo";
				        break;
				    case "019":
					$s_col = "program_add_del";
				        break;
				    case "020":
					$s_col = "bikou";
				        break;
				    case "021":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "022":
					$s_col = "haiki_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "023":
					$s_col = "licencelist_pkey";
				        break;
				    case "024":
					$s_col = "program_add_del_down";
				        break;
				    case "026":
					$s_col = "edition";
				        break;
				    case "027":
					$s_col = "price";
				        break;
				    case "028":
					$s_col = "use_limit_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "029":
					$s_col = "memo";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= ") and newkbn <> 1";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and (sosiki_pkey in (".implode(",",$sosiki_array).") or kanri_sosiki_pkey in (".implode(",",$sosiki_array)."))";

		if(@$_REQUEST['search_haiki'] == "on"){
			$where .= " and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";
		}

		if(@$_REQUEST['search_zero'] == "on"){
			$where .= " and (install_su > 0)";
		}

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licence_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi($list['count'], $count, $url, $param);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licence_detail".$where.$order.$limit, "list");
			if(count($list_limit) > 0){
				for($i=0; $i<count($list_limit); $i++){
					if(in_array($list_limit[$i]['sosiki_pkey'],$child_array) or in_array($list_limit[$i]['kanri_sosiki_pkey'],$child_array)){
						$list_limit[$i]['app_edit_ok'] = true;
					}else{
						$list_limit[$i]['app_edit_ok'] = false;
					}
				
					/** プログラムの追加と削除での表示 */
					$program_add_del_array = explode("\n",$list_limit[$i]['program_add_del']);
					$list_limit[$i]['program_add_del'] = $program_add_del_array;
					/** ダウングレード使用時のプログラムの追加と削除での表示 */
					$program_add_del_down_array = explode("\n",$list_limit[$i]['program_add_del_down']);
					$list_limit[$i]['program_add_del_down'] = $program_add_del_down_array;
					/** アップグレード元ライセンス管理番号 */
					$up_licence_kanrino_array = explode(",",$list_limit[$i]['up_licence_kanrino']);
					$list_limit[$i]['up_licence_kanrino'] = $up_licence_kanrino_array;
				}
			}
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/list.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * 新規追加
	 * 入力
	 */
	function app_reg(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			if(@$item['install_su_type'] == "mugen"){
				$item['hold_qty'] = 99999999;
				$item['install_su_name'] = "無制限";
			}else{
				$item['install_su_name'] = $item['hold_qty'];
			}

			$item['use_sosiki_self'] = array("licence_pkey"=>@$item['licence_pkey_self'],"sosiki_pkey"=>@$item['sosiki_pkey_self'],"install_su"=>@$item['install_su_self'],"version"=>@$item['version_self']);

			if(@$item['use_sosiki_qty'] > 0){
				for($i=0; $i<@$item['use_sosiki_qty']; $i++){
					$licence_pkey =	"licence_pkey_".$i;
					$sosiki_pkey =	"sosiki_pkey_".$i;
					$install_su =	"install_su_".$i;
					$version =	"version_".$i;
					if((@$item[$install_su] != "" and @$item[$sosiki_pkey] != "" and @$item[$sosiki_pkey] != 0) or @$item[$licence_pkey] != ""){
						if(@$item[$install_su] == ""){
							$item[$install_su] = 0;
						}elseif(@$item[$install_su] == 99999999){
							$item[$install_su] = "無制限";
						}
						if(@$item[$version] == ""){
							$item[$version] = 0;
						}
						$item['use_sosiki'][$i] = array(
										"licence_pkey"	=> @$item[$licence_pkey],
										"sosiki_pkey"	=> @$item[$sosiki_pkey],
										"install_su"	=> @$item[$install_su],
										"version"	=> @$item[$version]
										);
					}
				}
			}
			$item['use_sosiki'] = @array_values(@$item['use_sosiki']);
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");

			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i");

			$item['kanri_sosiki_pkey'] = $detail['sosiki_pkey'];
			//管理所属=使用所属
			$item['use_sosiki_self'] = array("licence_pkey"=>"","sosiki_pkey"=>$item['kanri_sosiki_pkey'],"install_su"=>"0","version"=>"1");
		
			$user_referer = _USER_REFERER;

			//ライセンス管理番号自動採番
			if(_NUMBERING_SET){
				//ID取得
				$fields_values = array("create_date" => date("Y/m/d H:i:s"));
				$id = $this->db->dbInsert("licence_kanrino_numbering", $fields_values);
				//最大値設定
				if(strlen($id) > _ZORO_PADDING and _ZORO_PADDING){
					$maxno = 1;
					for($i=1; $i<=_ZORO_PADDING; $i++){
						$maxno = $maxno * 10;
					}
					$id = $maxno - 1;
				}
				//ゼロパディング設定
				$kanrino = (string)$id;
				if(_ZORO_PADDING){
					$format = "%0"._ZORO_PADDING."d";
					$kanrino = sprintf($format, $kanrino);
				}
				//管理番号
				$item['licence_kanrino'] = _LICENCE_PREFIX.$kanrino;
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 確認
	 */
	function app_reg_conf(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_reg";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		if(@$_SESSION['input']['install_su_type'] == "mugen"){
			$_SESSION['input']['hold_qty'] = 99999999;
			$_SESSION['input']['install_su_name'] = "無制限";
		}else{
			$_SESSION['input']['install_su_name'] = $_SESSION['input']['hold_qty'];
		}
		$detail_licenselist = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".@$_SESSION['input']['licencelist_pkey']."'", "detail");
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
			$detail_licenselist['hard_kanrino'] = $detail_hard['hard_kanrino'];
		}
		if(@$_SESSION['input']['licence_pkey2']){
			$detail_license = $this->db->dbSelect("select * from licence_detail where licence_pkey='".@$_SESSION['input']['licence_pkey2']."'", "detail");
			$detail_licenselist['up_licence_kanrino'] = $detail_license['licence_kanrino'];
		}
		#プログラムの追加と削除の表示用データ
		$program_add_del_array = explode("\n",$detail_licenselist['program_add_del']);
		$detail_licenselist['program_add_del'] = $program_add_del_array;
		#ダウングレード使用時のプログラムの追加と削除の表示用データ
		$program_add_del_down_array = explode("\n",$detail_licenselist['program_add_del_down']);
		$detail_licenselist['program_add_del_down'] = $program_add_del_down_array;


		if($detail_licenselist['upd_date'] != ""){
			$day = explode("-",$detail_licenselist['upd_date']);
		}else{
			$day = explode("/",$_SESSION['input']['sinsei_date']);
		}
		$check_date = date("Ymd",mktime(0,0,0,$day[1],$day[2] + _USE_COND_CHECK_DAY,$day[0]));

		$sinseidatetime = explode(" ",$_SESSION['input']['sinsei_date']);
		$sinsei = explode("/",$sinseidatetime[0]);
		$sinsei_date = date("Ymd",mktime(0,0,0,$sinsei[1],$sinsei[2],$sinsei[0]));

		if($detail_licenselist['useproposal_kakunin'] == "d001" and $check_date <= $sinsei_date){
			$this->tpl->assignHtml('kakunin',true);
		}
		#使用所属
		if(@$_SESSION['input']['use_sosiki_qty'] > 0){
			for($i=0; $i<@$_SESSION['input']['use_sosiki_qty']; $i++){
				$licence_pkey =	"licence_pkey_".$i;
				$sosiki_pkey =	"sosiki_pkey_".$i;
				$install_su =	"install_su_".$i;
				$version =	"version_".$i;
				if((@$_SESSION['input'][$install_su] != "" and @$_SESSION['input'][$sosiki_pkey] != "" and @$_SESSION['input'][$sosiki_pkey] != 0) or @$_SESSION['input'][$licence_pkey] != ""){
					if(@$_SESSION['input'][$install_su] == ""){
						$_SESSION['input'][$install_su] = 0;
					}elseif($_SESSION['input'][$install_su] == 99999999){
						$_SESSION['input'][$install_su] = "無制限";
					}
					if(@$_SESSION['input'][$version] == ""){
						$_SESSION['input'][$version] = 0;
					}
					$_SESSION['input']['use_sosiki'][$i] = array(
										"licence_pkey"	=> @$_SESSION['input'][$licence_pkey],
										"sosiki_pkey"	=> @$_SESSION['input'][$sosiki_pkey],
										"install_su"	=> @$_SESSION['input'][$install_su],
										"version"	=> @$_SESSION['input'][$version]
										);
				}
			}
		}
		$session_input = $_SESSION['input'];
		$session_input['use_sosiki'] = @array_values(@$_SESSION['input']['use_sosiki']);

		/** 出力 */
		$this->tpl->assignHtml('list',   $detail_licenselist);
		$this->tpl->assignHtml('item',   $session_input);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 登録
	 */
	function app_reg_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		$licencelist_detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey=".$_SESSION['input']['licencelist_pkey'], "detail");
		if($licencelist_detail['hard_kotei'] == 'd002'){
			$_SESSION['input']['hard_pkey'] = "";
		}
		if($licencelist_detail['upgrade'] == 'd002'){
			$_SESSION['input']['licence_pkey2'] = "";
		}
		if(count(@$_SESSION['input']['licence_pkey2']) > 0 and is_array(@$_SESSION['input']['licence_pkey2'])){
			$_SESSION['input']['licence_pkey2'] = implode(",",$_SESSION['input']['licence_pkey2']);
		}
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_reg";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			$shinsei_no = "";
			$_SESSION['input']['use_sosiki'][] = array("sosiki_pkey"=>@$_SESSION['input']['sosiki_pkey_self'],"licence_pkey"=>@$_SESSION['input']['licence_pkey_self'],"install_su"=>@$_SESSION['input']['install_su_self'],"version"=>@$_SESSION['input']['version_self']);
			$_SESSION['input']['use_sosiki'] = @array_values(@$_SESSION['input']['use_sosiki']);
			if(count(@$_SESSION['input']['use_sosiki']) > 0){
				for($i=0; $i<count($_SESSION['input']['use_sosiki']); $i++){
					if(@$_SESSION['input']['use_sosiki'][$i]['install_su'] == "無制限"){
						$_SESSION['input']['use_sosiki'][$i]['install_su'] = 99999999;
					}
					/** 登録 */
					$fields_values = array(
							"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
							"sosiki_pkey"          => $_SESSION['input']['use_sosiki'][$i]['sosiki_pkey'], 
							"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
							"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],     
							"install_su"           => $_SESSION['input']['use_sosiki'][$i]['install_su'],     
							"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
							"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'], 
							"licence_no"           => $_SESSION['input']['licence_no'], 
							"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
							"hokan_baitai"         => $_SESSION['input']['hokan_baitai'], 
							"hokan_basyo"          => $_SESSION['input']['hokan_basyo'], 
							"bikou"                => $_SESSION['input']['bikou'], 
							"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
							"haiki_date"           => $_SESSION['input']['haiki_date'],
							"price"                => $_SESSION['input']['price'],
							"use_limit_date"       => $_SESSION['input']['use_limit_date'],
							"memo"                 => @$_SESSION['input']['memo'],
							"version"              => 1, 
							"newkbn"               => 1 
							      );
					$pkey = $this->db->dbInsert("\"licence\"", $fields_values);

					$fields_values = array(
							"licence_pkey"         => $pkey, 
							"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
							"sosiki_pkey"          => $_SESSION['input']['use_sosiki'][$i]['sosiki_pkey'], 
							"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
							"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],     
							"install_su"           => $_SESSION['input']['use_sosiki'][$i]['install_su'],     
							"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
							"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'], 
							"licence_no"           => $_SESSION['input']['licence_no'], 
							"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
							"hokan_baitai"         => $_SESSION['input']['hokan_baitai'], 
							"hokan_basyo"          => $_SESSION['input']['hokan_basyo'], 
							"bikou"                => $_SESSION['input']['bikou'], 
							"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
							"haiki_date"           => $_SESSION['input']['haiki_date'],
							"price"                => $_SESSION['input']['price'],
							"use_limit_date"       => $_SESSION['input']['use_limit_date'],
							"memo"                 => @$_SESSION['input']['memo'],
							"version"              => 1
							      );
					$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);

					if($shinsei_no == ""){
						$shinsei_no = $code;
					}
					$fields_values = array(
							"history_pkey"         => $code,     
							"history_type"         => "d003",     
							"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
							"sinseisya"            => $_SESSION['input']['sinseisya'], 
							"sinseisyozoku"        => $this->authuser_sosiki, 
							"email_ad"             => $_SESSION['input']['email_ad'],
							"shinsei_no"           => $shinsei_no
							      );
					$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);

					$fields_values = array(
							"licencehistory_pkey"  => $code,     
							"hold_qty"             => $_SESSION['input']['hold_qty']
							      );
					$this->db->dbInsert("\"hold_licence_qry_rireki\"", $fields_values);

				}
			}else{
				/** 登録 */
				$fields_values = array(
						"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
						"sosiki_pkey"          => "", 
						"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
						"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],     
						"install_su"           => "0",     
						"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
						"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'], 
						"licence_no"           => $_SESSION['input']['licence_no'], 
						"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
						"hokan_baitai"         => $_SESSION['input']['hokan_baitai'], 
						"hokan_basyo"          => $_SESSION['input']['hokan_basyo'], 
						"bikou"                => $_SESSION['input']['bikou'], 
						"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
						"haiki_date"           => $_SESSION['input']['haiki_date'],
						"price"                => $_SESSION['input']['price'],
						"use_limit_date"       => $_SESSION['input']['use_limit_date'],
						"memo"                 => @$_SESSION['input']['memo'],
						"version"              => 1, 
						"newkbn"               => 1 
						      );
				$pkey = $this->db->dbInsert("\"licence\"", $fields_values);

				$fields_values = array(
						"licence_pkey"         => $pkey, 
						"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
						"sosiki_pkey"          => "",
						"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
						"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],     
						"install_su"           => "0",
						"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
						"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'], 
						"licence_no"           => $_SESSION['input']['licence_no'], 
						"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
						"hokan_baitai"         => $_SESSION['input']['hokan_baitai'], 
						"hokan_basyo"          => $_SESSION['input']['hokan_basyo'], 
						"bikou"                => $_SESSION['input']['bikou'], 
						"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
						"haiki_date"           => $_SESSION['input']['haiki_date'],
						"price"                => $_SESSION['input']['price'],
						"use_limit_date"       => $_SESSION['input']['use_limit_date'],
						"memo"                 => @$_SESSION['input']['memo'],
						"version"              => 1
						      );
				$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);

				if($shinsei_no == ""){
					$shinsei_no = $code;
				}
				$fields_values = array(
						"history_pkey"         => $code,     
						"history_type"         => "d003",     
						"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
						"sinseisya"            => $_SESSION['input']['sinseisya'], 
						"sinseisyozoku"        => $this->authuser_sosiki, 
						"email_ad"             => $_SESSION['input']['email_ad'],
						"shinsei_no"           => $shinsei_no
						      );
				$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);

				$fields_values = array(
						"licencehistory_pkey"  => $code,     
						"hold_qty"             => $_SESSION['input']['hold_qty']
						      );
				$this->db->dbInsert("\"hold_licence_qry_rireki\"", $fields_values);
			}

			$mail_tpl = new Template;
			$email = new Sendmail;
		
			$mail_tpl->assignHtml('sinseisya',$_SESSION['input']['sinseisya']);
			$mail_tpl->assignHtml('sinsei_date',$_SESSION['input']['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス台帳");
			$mail_tpl->assignHtml('action',_ACTION_APPADD);

			$body = $mail_tpl->fetchHtml('mail/sinsei.html');
			$subject = "【情報資産管理システム】ライセンス台帳　"._ACTION_APPADD;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$sosiki_pkey = $detail['sosiki_pkey'];
			
			$list = $this->db->dbSelect("SELECT * FROM user_detail where (auth = 'd003' or auth = 'd004') and sosiki_pkey = ".$sosiki_pkey, "list");
			for($i=0; $i<count(@$list); $i++){
				$email_ad = explode("\n",$list[$i]['email_ad']);
				for($j=0; $j<count($email_ad); $j++){
//					$email->email($email_ad[$j], _ADMIN_EMAIL, $subject, $body);
				}
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['licence_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 編集
	 * 入力
	 */
	function app_edit(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			if(@$item['install_su_type'] == "mugen"){
				$item['hold_qty'] = 99999999;
				$item['install_su_name'] = "無制限";
			}else{
				$item['install_su_name'] = $item['hold_qty'];
			}
			
			$item['use_sosiki_self'] = array("licence_pkey"=>@$item['licence_pkey_self'],"sosiki_pkey"=>@$item['sosiki_pkey_self'],"install_su"=>@$item['install_su_self'],"version"=>@$item['version_self']);

			if(@$item['use_sosiki_qty'] > 0){
				for($i=0; $i<@$item['use_sosiki_qty']; $i++){
					$licence_pkey =	"licence_pkey_".$i;
					$sosiki_pkey =	"sosiki_pkey_".$i;
					$install_su =	"install_su_".$i;
					$version =	"version_".$i;
					if((@$item[$install_su] != "" and @$item[$sosiki_pkey] != "" and @$item[$sosiki_pkey] != 0) or @$item[$licence_pkey] != ""){
						if(@$item[$install_su] == ""){
							$item[$install_su] = 0;
						}
						if(@$item[$version] == ""){
							$item[$version] = 1;
						}
						$item['use_sosiki'][$i] = array(
										"licence_pkey"	=> @$item[$licence_pkey],
										"sosiki_pkey"	=> @$item[$sosiki_pkey],
										"install_su"	=> @$item[$install_su],
										"version"	=> @$item[$version]
										);
					}
				}
				$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey='".$item['licence_pkey']."'", "detail");
				$this->use_only_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey']);
				$item['use_sosiki'] = @array_values(@$item['use_sosiki']);
				$item['use_sosiki'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$item['use_sosiki']);
			}
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$licence_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey='".$licence_pkey."'", "detail");
			$this->use_only_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey']);
			
			//組織認証
			$this->sosiki_auth(array($detail['sosiki_pkey'],$detail['kanri_sosiki_pkey']));
			
			if(count($detail) > 0){
				$item    = $detail;
				//管理所属=使用所属
				$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and sosiki_pkey = ".$detail['kanri_sosiki_pkey']." and newkbn <> 1";
				$item['use_sosiki_self'] = $this->db->dbSelect("select licence_pkey, sosiki_pkey, install_su, version from licence_detail".$where_list, "detail");
				if(!is_array($item['use_sosiki_self'])){
					$item['use_sosiki_self'] = array("licence_pkey"=>"","sosiki_pkey"=>$detail['kanri_sosiki_pkey'],"install_su"=>"0","version"=>"1");
				}
				if($item['use_sosiki_self']['install_su'] == 99999999){
					$item['use_sosiki_self']['install_su'] = "無制限";
				}
				$item['use_sosiki_self'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],array($item['use_sosiki_self']));
				$item['use_sosiki_self'] = @$item['use_sosiki_self'][0];
				//管理所属!=使用所属
				$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and sosiki_pkey != ".$detail['kanri_sosiki_pkey']." and newkbn <> 1 order by \"sosiki_sortkey\"";
				$item['use_sosiki'] = $this->db->dbSelect("select licence_pkey, sosiki_pkey, install_su, version from licence_detail".$where_list, "list");
				if(count($item['use_sosiki']) > 0){
					for($i=0; $i < count($item['use_sosiki']); $i++){
						if($item['use_sosiki'][$i]['install_su'] == 99999999){
							$item['use_sosiki'][$i]['install_su'] = "無制限";
						}
					}
				}
				$item['use_sosiki'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$item['use_sosiki']);
				$item['use_sosiki'] = @array_values(@$item['use_sosiki']);
				/** アップグレード元ライセンス管理番号 */
				if($item['up_licence_kanrino']){
					$item['up_licence_kanrino'] =explode(",",$item['up_licence_kanrino']);
				}else{
					$item['up_licence_kanrino'] = array();
				}
				/** アップグレード元ライセンスキー */
				if($item['licence_pkey2']){
					$item['licence_pkey2'] =explode(",",$item['licence_pkey2']);
				}else{
					$item['licence_pkey2'] = array();
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i");
//			$item['sosiki_pkey'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('use_only', $this->use_only);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認app_print
	 */
	function app_edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		if(@$_SESSION['input']['install_su_type'] == "mugen"){
			$_SESSION['input']['hold_qty'] = 99999999;
			$_SESSION['input']['install_su_name'] = "無制限";
		}else{
			$_SESSION['input']['install_su_name'] = $_SESSION['input']['hold_qty'];
		}
		$detail_licenselist = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".@$_SESSION['input']['licencelist_pkey']."'", "detail");
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
			$detail_licenselist['hard_kanrino'] = $detail_hard['hard_kanrino'];
		}
		#プログラムの追加と削除の表示用データ
		$program_add_del_array = explode("\n",$detail_licenselist['program_add_del']);
		$detail_licenselist['program_add_del'] = $program_add_del_array;
		#ダウングレード使用時のプログラムの追加と削除の表示用データ
		$program_add_del_down_array = explode("\n",$detail_licenselist['program_add_del_down']);
		$detail_licenselist['program_add_del_down'] = $program_add_del_down_array;

		if($detail_licenselist['upd_date'] != ""){
			$day = explode("-",$detail_licenselist['upd_date']);
		}else{
			$day = explode("/",$_SESSION['input']['sinsei_date']);
		}
		$check_date = date("Ymd",mktime(0,0,0,$day[1],$day[2] + _USE_COND_CHECK_DAY,$day[0]));

		$sinseidatetime = explode(" ",$_SESSION['input']['sinsei_date']);
		$sinsei = explode("/",$sinseidatetime[0]);
		$sinsei_date = date("Ymd",mktime(0,0,0,$sinsei[1],$sinsei[2],$sinsei[0]));

		if($detail_licenselist['useproposal_kakunin'] == "d001" and $check_date <= $sinsei_date){
			$this->tpl->assignHtml('kakunin',true);
		}
		#使用所属
		if(@$_SESSION['input']['use_sosiki_qty'] > 0){
			for($i=0; $i<@$_SESSION['input']['use_sosiki_qty']; $i++){
				$licence_pkey =	"licence_pkey_".$i;
				$sosiki_pkey =	"sosiki_pkey_".$i;
				$install_su =	"install_su_".$i;
				$version =	"version_".$i;
				if((@$_SESSION['input'][$install_su] != "" and @$_SESSION['input'][$sosiki_pkey] != "" and @$_SESSION['input'][$sosiki_pkey] != 0) or @$_SESSION['input'][$licence_pkey] != ""){
					if(@$_SESSION['input'][$install_su] == ""){
						$_SESSION['input'][$install_su] = 0;
					}
					if(@$_SESSION['input'][$version] == ""){
						$_SESSION['input'][$version] = 0;
					}
					$_SESSION['input']['use_sosiki'][$i] = array(
										"licence_pkey"	=> @$_SESSION['input'][$licence_pkey],
										"sosiki_pkey"	=> @$_SESSION['input'][$sosiki_pkey],
										"install_su"	=> @$_SESSION['input'][$install_su],
										"version"	=> @$_SESSION['input'][$version]
										);
				}
			}
		}
		$session_input = $_SESSION['input'];
		$session_input['use_sosiki'] = @array_values(@$_SESSION['input']['use_sosiki']);
		/** 出力 */
		$this->tpl->assignHtml('list',   $detail_licenselist);
		$this->tpl->assignHtml('item',   $session_input);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function app_edit_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */
		$licencelist_detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey=".$_SESSION['input']['licencelist_pkey'], "detail");
		if($licencelist_detail['hard_kotei'] == 'd002'){
			$_SESSION['input']['hard_pkey'] = "";
		}
		if($licencelist_detail['upgrade'] == 'd002'){
			$_SESSION['input']['licence_pkey2'] = "";
		}
		if(count(@$_SESSION['input']['licence_pkey2']) > 0 and is_array(@$_SESSION['input']['licence_pkey2'])){
			$_SESSION['input']['licence_pkey2'] = implode(",",$_SESSION['input']['licence_pkey2']);
		}
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			$shinsei_no = "";
			if($this->authuser_authority != 'system'){
				$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey=".$_SESSION['input']['licence_pkey'], "detail");
				$_SESSION['input']['memo'] = $detail['memo'];
			}
			if(@$_SESSION['input']['sosiki_pkey_self'] != ''){
				$_SESSION['input']['use_sosiki'][] = array("sosiki_pkey"=>@$_SESSION['input']['sosiki_pkey_self'],"licence_pkey"=>@$_SESSION['input']['licence_pkey_self'],"install_su"=>@$_SESSION['input']['install_su_self'],"version"=>@$_SESSION['input']['version_self']);
			}
			$_SESSION['input']['use_sosiki'] = @array_values(@$_SESSION['input']['use_sosiki']);
			if(count(@$_SESSION['input']['use_sosiki']) > 0){
				for($i=0; $i<count($_SESSION['input']['use_sosiki']); $i++){
					if(@$_SESSION['input']['use_sosiki'][$i]['install_su'] == "無制限"){
						$_SESSION['input']['use_sosiki'][$i]['install_su'] = 99999999;
					}
					if($_SESSION['input']['use_sosiki'][$i]['licence_pkey'] == ""){
						/** 新規使用所属 */
						$fields_values = array(
								"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
								"sosiki_pkey"          => $_SESSION['input']['use_sosiki'][$i]['sosiki_pkey'],
								"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
								"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],     
								"install_su"           => $_SESSION['input']['use_sosiki'][$i]['install_su'],
								"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
								"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'], 
								"licence_no"           => $_SESSION['input']['licence_no'], 
								"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
								"hokan_baitai"         => $_SESSION['input']['hokan_baitai'], 
								"hokan_basyo"          => $_SESSION['input']['hokan_basyo'], 
								"bikou"                => $_SESSION['input']['bikou'], 
								"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
								"haiki_date"           => $_SESSION['input']['haiki_date'],
								"price"                => $_SESSION['input']['price'],
								"use_limit_date"       => $_SESSION['input']['use_limit_date'],
								"memo"                 => $_SESSION['input']['memo'],
								"version"              => 1,
								"newkbn"               => 1 
								      );
						$pkey = $this->db->dbInsert("\"licence\"", $fields_values);
						/** 登録 */
						$fields_values = array(
								"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
								"sosiki_pkey"          => $_SESSION['input']['use_sosiki'][$i]['sosiki_pkey'],
								"licence_pkey"         => $pkey, 
								"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],
								"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],
								"install_su"           => $_SESSION['input']['use_sosiki'][$i]['install_su'],
								"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
								"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'],
								"licence_no"           => $_SESSION['input']['licence_no'],
								"tyoutatu"             => $_SESSION['input']['tyoutatu'],
								"hokan_baitai"         => $_SESSION['input']['hokan_baitai'],
								"hokan_basyo"          => $_SESSION['input']['hokan_basyo'],
								"bikou"                => $_SESSION['input']['bikou'],
								"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
								"haiki_date"           => $_SESSION['input']['haiki_date'],
								"price"                => $_SESSION['input']['price'],
								"use_limit_date"       => $_SESSION['input']['use_limit_date'],
								"memo"                 => $_SESSION['input']['memo'],
								"version"              => 1
								      );
						$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);
					}else{
						if($_SESSION['input']['licence_pkey'] == $_SESSION['input']['use_sosiki'][$i]['licence_pkey']){
							$hokan_baitai	= $_SESSION['input']['hokan_baitai'];
							$hokan_basyo	= $_SESSION['input']['hokan_basyo'];
							$bikou		= $_SESSION['input']['bikou'];
							$memo		= $_SESSION['input']['memo'];
						}else{
							$old_licence_detail = $this->db->dbSelect("select * from licence where licence_pkey=".$_SESSION['input']['use_sosiki'][$i]['licence_pkey'], "detail");
							$hokan_baitai	= @$old_licence_detail['hokan_baitai'];
							$hokan_basyo	= @$old_licence_detail['hokan_basyo'];
							$bikou		= @$old_licence_detail['bikou'];
							$memo		= @$old_licence_detail['memo'];
						}
						/** 登録 */
						$fields_values = array(
								"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
								"sosiki_pkey"          => $_SESSION['input']['use_sosiki'][$i]['sosiki_pkey'],
								"licence_pkey"         => $_SESSION['input']['use_sosiki'][$i]['licence_pkey'], 
								"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],
								"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],
								"install_su"           => $_SESSION['input']['use_sosiki'][$i]['install_su'],
								"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
								"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'],
								"licence_no"           => $_SESSION['input']['licence_no'],
								"tyoutatu"             => $_SESSION['input']['tyoutatu'],
								"hokan_baitai"         => $hokan_baitai,
								"hokan_basyo"          => $hokan_basyo,
								"bikou"                => $bikou,
								"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
								"haiki_date"           => $_SESSION['input']['haiki_date'],
								"price"                => $_SESSION['input']['price'],
								"use_limit_date"       => $_SESSION['input']['use_limit_date'],
								"memo"                 => $memo,
								"version"              => $_SESSION['input']['use_sosiki'][$i]['version']
								      );
						$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);
					}

					if($shinsei_no == ""){
						$shinsei_no = $code;
					}
					$fields_values = array(
							"history_pkey"         => $code,     
							"history_type"         => "d003",     
							"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
							"sinseisya"            => $_SESSION['input']['sinseisya'], 
							"sinseisyozoku"        => $this->authuser_sosiki, 
							"email_ad"             => $_SESSION['input']['email_ad'],
							"shinsei_no"           => $shinsei_no
							      );
					$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);

					$fields_values = array(
							"licencehistory_pkey"  => $code,     
							"hold_qty"             => $_SESSION['input']['hold_qty']
							      );
					$this->db->dbInsert("\"hold_licence_qry_rireki\"", $fields_values);
				}
			}else{
				/** 登録 */
				$fields_values = array(
						"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
						"sosiki_pkey"          => "", 
						"licence_pkey"         => $_SESSION['input']['licence_pkey'], 
						"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
						"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],     
						"install_su"           => "",     
						"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
						"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'], 
						"licence_no"           => $_SESSION['input']['licence_no'], 
						"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
						"hokan_baitai"         => $_SESSION['input']['hokan_baitai'], 
						"hokan_basyo"          => $_SESSION['input']['hokan_basyo'], 
						"bikou"                => $_SESSION['input']['bikou'], 
						"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
						"haiki_date"           => $_SESSION['input']['haiki_date'],
						"price"                => $_SESSION['input']['price'],
						"use_limit_date"       => $_SESSION['input']['use_limit_date'],
						"memo"                 => $_SESSION['input']['memo'],
						"version"              => $_SESSION['input']['version']
						      );
				$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);

				if($shinsei_no == ""){
					$shinsei_no = $code;
				}
				$fields_values = array(
						"history_pkey"         => $code,     
						"history_type"         => "d003",     
						"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
						"sinseisya"            => $_SESSION['input']['sinseisya'], 
						"sinseisyozoku"        => $this->authuser_sosiki, 
						"email_ad"             => $_SESSION['input']['email_ad'],
						"shinsei_no"           => $shinsei_no
						      );
				$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);

				$fields_values = array(
						"licencehistory_pkey"  => $code,     
						"hold_qty"             => $_SESSION['input']['hold_qty']
						      );
				$this->db->dbInsert("\"hold_licence_qry_rireki\"", $fields_values);
			}

			$mail_tpl = new Template;
			$email = new Sendmail;
		
			$mail_tpl->assignHtml('sinseisya',$_SESSION['input']['sinseisya']);
			$mail_tpl->assignHtml('sinsei_date',$_SESSION['input']['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス台帳");
			$mail_tpl->assignHtml('action',_ACTION_APPEDIT);

			$body = $mail_tpl->fetchHtml('mail/sinsei.html');
			$subject = "【情報資産管理システム】ライセンス台帳　"._ACTION_APPEDIT;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$sosiki_pkey = $detail['sosiki_pkey'];
			
			$list = $this->db->dbSelect("SELECT * FROM user_detail where (auth = 'd003' or auth = 'd004') and sosiki_pkey = ".$sosiki_pkey, "list");
			for($i=0; $i<count(@$list); $i++){
				$email_ad = explode("\n",$list[$i]['email_ad']);
				for($j=0; $j<count($email_ad); $j++){
//					$email->email($email_ad[$j], _ADMIN_EMAIL, $subject, $body);
				}
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['licence_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * コピー
	 * 入力
	 */
	function app_copy(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$this->use_only_check($item['kanri_sosiki_pkey'],$item['sosiki_pkey']);
			if(@$item['install_su_type'] == "mugen"){
				$item['hold_qty'] = 99999999;
				$item['install_su_name'] = "無制限";
			}else{
				$item['install_su_name'] = $item['hold_qty'];
			}
			if(@$item['use_sosiki_qty'] > 0){
				for($i=0; $i<@$item['use_sosiki_qty']; $i++){
					$licence_pkey =	"licence_pkey_".$i;
					$sosiki_pkey =	"sosiki_pkey_".$i;
					$install_su =	"install_su_".$i;
					$version =	"version_".$i;
					if((@$item[$install_su] != "" and @$item[$sosiki_pkey] != "" and @$item[$sosiki_pkey] != 0) or @$item[$licence_pkey] != ""){
						if(@$item[$install_su] == ""){
							$item[$install_su] = 0;
						}
						if(@$item[$version] == ""){
							$item[$version] = 0;
						}
						$item['use_sosiki'][$i] = array(
										"licence_pkey"	=> @$item[$licence_pkey],
										"sosiki_pkey"	=> @$item[$sosiki_pkey],
										"install_su"	=> @$item[$install_su],
										"version"	=> @$item[$version]
										);
					}
				}
				$item['use_sosiki'] = $this->kanri_check($item['kanri_sosiki_pkey'],$item['use_sosiki']);
			}
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$licence_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey='".$licence_pkey."'", "detail");
			$this->use_only_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey']);
			
			//組織認証
			$this->sosiki_auth(array($detail['sosiki_pkey'],$detail['kanri_sosiki_pkey']));
			
			if(count($detail) > 0){
				$item			= $detail;
				$item['licence_pkey']	= "";
				$item['version']	= "";
				//管理所属=使用所属
				$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and sosiki_pkey = ".$detail['kanri_sosiki_pkey']." and newkbn <> 1";
				$item['use_sosiki_self'] = $this->db->dbSelect("select sosiki_pkey, install_su, version from licence_detail".$where_list, "detail");
				if($item['use_sosiki_self']['install_su'] == 99999999){
					$item['use_sosiki_self']['install_su'] == "無制限";
				}
				if(!is_array($item['use_sosiki_self'])){
					$item['use_sosiki_self'] = array("licence_pkey"=>"","sosiki_pkey"=>$detail['kanri_sosiki_pkey'],"install_su"=>"0","version"=>"1");
				}
				$item['use_sosiki_self'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],array($item['use_sosiki_self']));
				$item['use_sosiki_self'] = @$item['use_sosiki_self'][0];
				//管理所属!=使用所属
				$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and sosiki_pkey != ".$detail['kanri_sosiki_pkey']." and install_su > 0 and newkbn <> 1 order by \"sosiki_sortkey\"";
				$item['use_sosiki'] = $this->db->dbSelect("select sosiki_pkey, install_su, version from licence_detail".$where_list, "list");
				if(count($item['use_sosiki']) > 0){
					for($i=0; $i < count($item['use_sosiki']); $i++){
						if($item['use_sosiki'][$i]['install_su'] == 99999999){
							$item['use_sosiki'][$i]['install_su'] = "無制限";
						}
					}
				}
				$item['use_sosiki'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$item['use_sosiki']);
				/** アップグレード元ライセンス管理番号 */
				if($item['up_licence_kanrino']){
					$item['up_licence_kanrino'] =explode(",",$item['up_licence_kanrino']);
				}else{
					$item['up_licence_kanrino'] = array();
				}
				/** アップグレード元ライセンスキー */
				if($item['licence_pkey2']){
					$item['licence_pkey2'] =explode(",",$item['licence_pkey2']);
				}else{
					$item['licence_pkey2'] = array();
				}
				//ライセンス管理番号自動採番
				if(_NUMBERING_SET){
					//ID取得
					$fields_values = array("create_date" => date("Y/m/d H:i:s"));
					$id = $this->db->dbInsert("licence_kanrino_numbering", $fields_values);
					//最大値設定
					if(strlen($id) > _ZORO_PADDING and _ZORO_PADDING){
						$maxno = 1;
						for($i=1; $i<=_ZORO_PADDING; $i++){
							$maxno = $maxno * 10;
						}
						$id = $maxno - 1;
					}
					//ゼロパディング設定
					$kanrino = (string)$id;
					if(_ZORO_PADDING){
						$format = "%0"._ZORO_PADDING."d";
						$kanrino = sprintf($format, $kanrino);
					}
					//管理番号
					$item['licence_kanrino'] = _LICENCE_PREFIX.$kanrino;
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i");
//			$item['sosiki_pkey'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('use_only', $this->use_only);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}
	
	/**
	 * 修正申請
	 * 入力
	 */
	function app_modify(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$this->use_only_check($item['kanri_sosiki_pkey'],$item['sosiki_pkey']);
			if($item['licence_pkey'] != ""){
				$action_param = 'app_edit';
			}else{
				$action_param = 'app_reg';
			}
			if(@$item['install_su_type'] == "mugen"){
				$item['hold_qty'] = 99999999;
				$item['install_su_name'] = "無制限";
			}else{
				$item['install_su_name'] = $item['hold_qty'];
			}
			if(@$item['use_sosiki_qty'] > 0){
				for($i=0; $i<@$item['use_sosiki_qty']; $i++){
					$licence_pkey =	"licence_pkey_".$i;
					$sosiki_pkey =	"sosiki_pkey_".$i;
					$install_su =	"install_su_".$i;
					$version =	"version_".$i;
					if((@$item[$install_su] != "" and @$item[$sosiki_pkey] != "" and @$item[$sosiki_pkey] != 0) or @$item[$licence_pkey] != ""){
						if(@$item[$install_su] == ""){
							$item[$install_su] = 0;
						}
						if(@$item[$version] == ""){
							$item[$version] = 1;
						}
						$item['use_sosiki'][$i] = array(
										"licence_pkey"	=> @$item[$licence_pkey],
										"sosiki_pkey"	=> @$item[$sosiki_pkey],
										"install_su"	=> @$item[$install_su],
										"version"	=> @$item[$version]
										);
					}
				}
				$item['use_sosiki'] = $this->kanri_check($item['kanri_sosiki_pkey'],$item['use_sosiki']);
			}
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_REQUEST['code']), "detail");
			/** 詳細ﾃﾞｰﾀ */
			$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_history['shinsei_no'], "list");
			if(count($licence_list) > 0){
				for($i=0; $i<count($licence_list); $i++){
					if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
						$detail = $licence_list[$i];
					}
				}
				if(!is_array(@$detail)){
					$detail = $licence_list[0];
				}
			}else{
				$detail = $licence_list[0];
			}
			$this->use_only_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey']);
			
			//組織認証
			$this->sosiki_auth(array($detail['sinseisyozoku']));
			
			if(count($detail) > 0){
				$base_detail = $this->db->dbSelect("select * from licence_detail where licence_pkey=".$detail['licence_pkey'], "detail");
				$item			= $detail;
				//管理所属=使用所属
				$where_list =" where shinsei_no = '".$detail['shinsei_no']."' and sosiki_pkey = ".$detail['kanri_sosiki_pkey'];
				$item['use_sosiki_self'] = $this->db->dbSelect("select licence_pkey, sosiki_pkey, install_su, version from licence_rireki_detail".$where_list, "detail");
				if(!is_array($item['use_sosiki_self'])){
					$item['use_sosiki_self'] = array("licence_pkey"=>"","sosiki_pkey"=>$detail['kanri_sosiki_pkey'],"install_su"=>"0","version"=>"1");
					$app_reg = true;
				}
				if($item['use_sosiki_self']['install_su'] == 99999999){
					$item['use_sosiki_self']['install_su'] = "無制限";
				}
				$item['use_sosiki_self'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],array($item['use_sosiki_self']));
				$item['use_sosiki_self'] = @$item['use_sosiki_self'][0];

				//管理所属!=使用所属
				$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' and sosiki_pkey != ".$detail['kanri_sosiki_pkey']." order by \"sosiki_sortkey\"", "list");
				if(count($list_use) > 0 ){
					$pkey = array();
					foreach($list_use as $val){
						$licence_list = $this->db->dbSelect("SELECT * FROM licence where licence_pkey = ".$val['licence_pkey']." and newkbn <> 1", "list");
						if(count($licence_list) != 0){
							$pkey[] = $val['licence_pkey'];
						}else{
							$val['licence_pkey'] = "";
						}
						if($val['install_su'] == 99999999){
							$val['install_su'] = "無制限";
						}
						$item['use_sosiki'][] = array("licence_pkey"=>$val['licence_pkey'],"sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"version"=>$val['version']);
					}
					$item['use_sosiki'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$item['use_sosiki']);
					if(count($pkey) > 0){
						$pkey_in = implode(",",$pkey);
						$licence_list = $this->db->dbSelect("SELECT * FROM licence where licence_pkey in (".$pkey_in.") and newkbn <> 1", "list");
						if(count($licence_list) == 0){
							$app_reg = true;
						}
					}elseif(@$app_reg){
						$app_reg = true;
					}
				}
				if(!@$app_reg){
					$item['licence_pkey']	= $base_detail['licence_pkey'];
					$item['version']	= $base_detail['version'];
					$action_param = 'app_edit';
				}else{
					$item['licence_pkey']	= "";
					$item['version']	= "";
					$action_param = 'app_reg';
				}
				/** アップグレード元ライセンス管理番号 */
				if($item['up_licence_kanrino']){
					$item['up_licence_kanrino'] =explode(",",$item['up_licence_kanrino']);
				}else{
					$item['up_licence_kanrino'] = array();
				}
				/** アップグレード元ライセンスキー */
				if($item['licence_pkey2']){
					$item['licence_pkey2'] =explode(",",$item['licence_pkey2']);
				}else{
					$item['licence_pkey2'] = array();
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i");
//			$item['sosiki_pkey'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('use_only', $this->use_only);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param',$action_param);
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}
	
	/**
	 * 編集
	 * 入力
	 */
	function edit(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		#自所属＋配下組織
		$child_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
		if(count(child_sosiki_key($user_detail['sosiki_pkey'])) > 0){
			$sosiki_array = array_merge(array($user_detail['sosiki_pkey']),child_sosiki_key($user_detail['sosiki_pkey']));
		}else{
			$sosiki_array = array($user_detail['sosiki_pkey']);
		}
		$list = $this->db->dbSelect("SELECT * FROM sosiki where yukou = 'd001' and sosiki_pkey in (".implode(",",$sosiki_array).") ORDER BY sosiki_sortkey", "list");
		$sosiki["0"] = "";
		for($i=0; $i<count($list); $i++){
			if($list[$i]['sosiki_pkey'] != ""){
				$sosiki[$list[$i]['sosiki_pkey']] = implode("/",full_sosiki_name($list[$i]['sosiki_pkey']));
			}
		}

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$this->use_only_check($item['kanri_sosiki_pkey'],$item['sosiki_pkey']);
			
			$item['use_sosiki_self'] = array("licence_pkey"=>@$item['licence_pkey_self'],"sosiki_pkey"=>@$item['sosiki_pkey_self'],"install_su"=>@$item['install_su_self'],"version"=>@$item['version_self']);

			if(@$item['use_sosiki_qty'] > 0){
				for($i=0; $i<@$item['use_sosiki_qty']; $i++){
					$licence_pkey =	"licence_pkey_".$i;
					$sosiki_pkey =	"sosiki_pkey_".$i;
					$install_su =	"install_su_".$i;
					$version =	"version_".$i;
					if((@$item[$install_su] != "" and @$item[$sosiki_pkey] != "" and @$item[$sosiki_pkey] != 0) or @$item[$licence_pkey] != ""){
						if(@$item[$install_su] == ""){
							$item[$install_su] = 0;
						}elseif(@$item[$install_su] == 99999999){
							$item[$install_su] = "無制限";
						}
						if(@$item[$version] == ""){
							$item[$version] = 0;
						}
						$item['use_sosiki'][$i] = array(
										"licence_pkey"	=> @$item[$licence_pkey],
										"sosiki_pkey"	=> @$item[$sosiki_pkey],
										"install_su"	=> @$item[$install_su],
										"version"	=> @$item[$version]
										);
					}
				}
				$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey='".$item['licence_pkey']."'", "detail");
				$this->use_only_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey']);
				$item['use_sosiki'] = @array_values(@$item['use_sosiki']);
				$item['use_sosiki'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$item['use_sosiki']);
			}
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$licence_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey='".$licence_pkey."'", "detail");
			$this->use_only_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey']);
			/** アップグレード元ライセンス管理番号 */
			if($detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] =explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}
			/** アップグレード元ライセンスキー */
			if($detail['licence_pkey2']){
				$detail['licence_pkey2'] =explode(",",$detail['licence_pkey2']);
			}else{
				$detail['licence_pkey2'] = array();
			}
				
			if(count($detail) > 0){
				$item    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			//管理所属=使用所属
			$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and sosiki_pkey = ".$detail['kanri_sosiki_pkey']." and newkbn <> 1";
			$item['use_sosiki_self'] = $this->db->dbSelect("select licence_pkey, sosiki_pkey, install_su, version from licence_detail".$where_list, "detail");
			if(!is_array($item['use_sosiki_self'])){
				$item['use_sosiki_self'] = array("licence_pkey"=>"","sosiki_pkey"=>$detail['kanri_sosiki_pkey'],"install_su"=>"0","version"=>"1");
			}
			if($item['use_sosiki_self']['install_su'] == 99999999){
				$item['use_sosiki_self']['install_su'] = "無制限";
			}
			$item['use_sosiki_self'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],array($item['use_sosiki_self']));
			$item['use_sosiki_self'] = @$item['use_sosiki_self'][0];
			//管理所属!=使用所属
			$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and sosiki_pkey != ".$detail['kanri_sosiki_pkey']." and newkbn <> 1 order by \"sosiki_sortkey\"";
			$item['use_sosiki'] = $this->db->dbSelect("select licence_pkey, sosiki_pkey, install_su, version from licence_detail".$where_list, "list");
			if(count($item['use_sosiki']) > 0){
				for($i=0; $i < count($item['use_sosiki']); $i++){
					if($item['use_sosiki'][$i]['install_su'] == 99999999){
						$item['use_sosiki'][$i]['install_su'] = "無制限";
					}
				}
			}
			$item['use_sosiki'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$item['use_sosiki']);
			$item['use_sosiki'] = @array_values(@$item['use_sosiki']);

			$user_referer = _USER_REFERER;

		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('use_only', $this->use_only);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認app_print
	 */
	function edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		if(@$_SESSION['input']['install_su_type'] == "mugen"){
			$_SESSION['input']['hold_qty'] = 99999999;
			$_SESSION['input']['install_su_name'] = "無制限";
		}else{
			$_SESSION['input']['install_su_name'] = $_SESSION['input']['hold_qty'];
		}
		$detail_licenselist = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".@$_SESSION['input']['licencelist_pkey']."'", "detail");
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
			$detail_licenselist['hard_kanrino'] = $detail_hard['hard_kanrino'];
		}
		if(@$_SESSION['input']['licence_pkey2']){
			$detail_license = $this->db->dbSelect("select * from licence_detail where licence_pkey='".@$_SESSION['input']['licence_pkey2']."'", "detail");
			$detail_licenselist['up_licence_kanrino'] = $detail_license['licence_kanrino'];
		}
		$program_add_del_array = explode("\n",$detail_licenselist['program_add_del']);
		$detail_licenselist['program_add_del'] = $program_add_del_array;
		$program_add_del_down_array = explode("\n",$detail_licenselist['program_add_del_down']);
		$detail_licenselist['program_add_del_down'] = $program_add_del_down_array;

		unset($detail_licenselist['licencelist_pkey']);
		unset($detail_licenselist['bikou']);
		unset($detail_licenselist['version']);
		unset($detail_licenselist['sosiki_sortkey']);
		unset($detail_licenselist['sosiki_name']);
		unset($detail_licenselist['sosiki_fullname']);
		$_SESSION['input'] = array_merge($detail_licenselist, $_SESSION['input']);
		#使用所属
		if(@$_SESSION['input']['use_sosiki_qty'] > 0){
			for($i=0; $i<@$_SESSION['input']['use_sosiki_qty']; $i++){
				$licence_pkey =	"licence_pkey_".$i;
				$sosiki_pkey =	"sosiki_pkey_".$i;
				$install_su =	"install_su_".$i;
				$version =	"version_".$i;
				if((@$_SESSION['input'][$install_su] != "" and @$_SESSION['input'][$sosiki_pkey] != "" and @$_SESSION['input'][$sosiki_pkey] != 0) or @$_SESSION['input'][$licence_pkey] != ""){
					if(@$_SESSION['input'][$install_su] == ""){
						$_SESSION['input'][$install_su] = 0;
					}elseif(@$_SESSION['input'][$install_su] == 99999999){
						$_SESSION['input'][$install_su] = "無制限";
					}
					if(@$_SESSION['input'][$version] == ""){
						$_SESSION['input'][$version] = 0;
					}
					$_SESSION['input']['use_sosiki'][$i] = array(
										"licence_pkey"	=> @$_SESSION['input'][$licence_pkey],
										"sosiki_pkey"	=> @$_SESSION['input'][$sosiki_pkey],
										"install_su"	=> @$_SESSION['input'][$install_su],
										"version"	=> @$_SESSION['input'][$version]
										);
				}
			}
		}
		$session_input = $_SESSION['input'];
		$session_input['use_sosiki'] = @array_values(@$_SESSION['input']['use_sosiki']);

		/** 出力 */
		$this->tpl->assignHtml('list',   $detail_licenselist);
		$this->tpl->assignHtml('item',   $session_input);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function edit_done(){
		$page_name = "system";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */
		$licencelist_detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey=".$_SESSION['input']['licencelist_pkey'], "detail");
		if($licencelist_detail['hard_kotei'] == 'd002'){
			$_SESSION['input']['hard_pkey'] = "";
		}
		if($licencelist_detail['upgrade'] == 'd002'){
			$_SESSION['input']['licence_pkey2'] = "";
		}
		if(count(@$_SESSION['input']['licence_pkey2']) > 0 and is_array(@$_SESSION['input']['licence_pkey2'])){
			$_SESSION['input']['licence_pkey2'] = implode(",",$_SESSION['input']['licence_pkey2']);
		}

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			$_SESSION['input']['use_sosiki'][] = array("sosiki_pkey"=>@$_SESSION['input']['sosiki_pkey_self'],"licence_pkey"=>@$_SESSION['input']['licence_pkey_self'],"install_su"=>@$_SESSION['input']['install_su_self'],"version"=>@$_SESSION['input']['version_self']);
			$_SESSION['input']['use_sosiki'] = @array_values(@$_SESSION['input']['use_sosiki']);
			//使用所属追加・更新
			if(count(@$_SESSION['input']['use_sosiki']) > 0){
				for($i=0; $i<count($_SESSION['input']['use_sosiki']); $i++){
					if(@$_SESSION['input']['use_sosiki'][$i]['install_su'] == "無制限"){
						$_SESSION['input']['use_sosiki'][$i]['install_su'] = 99999999;
					}
					if($_SESSION['input']['use_sosiki'][$i]['licence_pkey'] == ""){
						/** 新規使用所属 */
						$fields_values = array(
								"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
								"sosiki_pkey"          => $_SESSION['input']['use_sosiki'][$i]['sosiki_pkey'],
								"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
								"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],     
								"install_su"           => $_SESSION['input']['use_sosiki'][$i]['install_su'],
								"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
								"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'], 
								"licence_no"           => $_SESSION['input']['licence_no'], 
								"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
								"hokan_baitai"         => $_SESSION['input']['hokan_baitai'], 
								"hokan_basyo"          => $_SESSION['input']['hokan_basyo'], 
								"bikou"                => $_SESSION['input']['bikou'], 
								"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
								"haiki_date"           => $_SESSION['input']['haiki_date'],
								"price"                => $_SESSION['input']['price'],
								"use_limit_date"       => $_SESSION['input']['use_limit_date'],
								"memo"                 => $_SESSION['input']['memo'],
								"version"              => $_SESSION['input']['use_sosiki'][$i]['version'] + 1,
								"newkbn"               => 0 
								      );
						$pkey = $this->db->dbInsert("\"licence\"", $fields_values);
					}else{
						if($_SESSION['input']['licence_pkey'] == $_SESSION['input']['use_sosiki'][$i]['licence_pkey']){
							$hokan_baitai	= $_SESSION['input']['hokan_baitai'];
							$hokan_basyo	= $_SESSION['input']['hokan_basyo'];
							$bikou		= $_SESSION['input']['bikou'];
							$memo		= $_SESSION['input']['memo'];
						}else{
							$old_licence_detail = $this->db->dbSelect("select * from licence where licence_pkey=".$_SESSION['input']['use_sosiki'][$i]['licence_pkey'], "detail");
							$hokan_baitai	= @$old_licence_detail['hokan_baitai'];
							$hokan_basyo	= @$old_licence_detail['hokan_basyo'];
							$bikou		= @$old_licence_detail['bikou'];
							$memo		= @$old_licence_detail['memo'];
						}
						$licence_pkey = addslashes($_SESSION['input']['use_sosiki'][$i]['licence_pkey']);
						$where = "licence_pkey = ".$licence_pkey;
						/** 登録 */
						$fields_values = array(
								"kanri_sosiki_pkey"    => $_SESSION['input']['kanri_sosiki_pkey'], 
								"sosiki_pkey"          => $_SESSION['input']['use_sosiki'][$i]['sosiki_pkey'],
								"licencelist_pkey"     => $_SESSION['input']['licencelist_pkey'],     
								"licence_kanrino"      => $_SESSION['input']['licence_kanrino'],     
								"install_su"           => $_SESSION['input']['use_sosiki'][$i]['install_su'],
								"hard_pkey"            => @$_SESSION['input']['hard_pkey'],
								"licence_pkey2"        => @$_SESSION['input']['licence_pkey2'], 
								"licence_no"           => $_SESSION['input']['licence_no'], 
								"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
								"hokan_baitai"         => $hokan_baitai, 
								"hokan_basyo"          => $hokan_basyo, 
								"bikou"                => $bikou, 
								"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'],
								"haiki_date"           => $_SESSION['input']['haiki_date'],
								"price"                => $_SESSION['input']['price'],
								"use_limit_date"       => $_SESSION['input']['use_limit_date'],
								"memo"                 => $memo,
								"version"              => $_SESSION['input']['use_sosiki'][$i]['version'] + 1
								      );
						$this->db->dbUpdate("\"licence\"", $fields_values, $where);
					}
					$where_qty = "licence_kanrino = '".$_SESSION['input']['licence_kanrino']."'";
					$fields_values = array(
							"hold_qty"             => $_SESSION['input']['hold_qty']
							      );
					$this->db->dbUpdate("\"hold_licence_qty\"", $fields_values, $where_qty);
				}
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['licence_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}
	
	/**
	 * 申請
	 * 取下
	 */
	function app_del(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SAGE);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_REQUEST['code']), "detail");
		/** 詳細ﾃﾞｰﾀ */
		$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_history['shinsei_no'], "list");
		if(count($licence_list) > 0){
			for($i=0; $i<count($licence_list); $i++){
				if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
					$detail = $licence_list[$i];
				}
			}
			if(!is_array(@$detail)){
				$detail = $licence_list[0];
			}
		}else{
			$detail = $licence_list[0];
		}
		$_SESSION['input']['licencehistory_pkey']    = $detail['licencehistory_pkey'];
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		
		//組織認証
		$this->sosiki_auth(array($detail['sinseisyozoku']));
		
		if(count($detail) > 0){
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}
			if($detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = $detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
			}
			$item    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;

		/** 出力 */
		$this->tpl->assignHtml('item',   $item);
		$this->tpl->assignHtml('list',   $item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPDEL);
		$this->tpl->assignHtml('action_param','app_del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 申請
	 * 取下
	 */
	function app_del_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_SESSION['input']['licencehistory_pkey']), "detail");
		$licencehistory_pkey = $detail_history['shinsei_no'];
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',@$detail['licence_kanrino']);
			$where = "shinsei_no = ".$detail['shinsei_no']." and history_type = 'd003'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => 'd003'
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

			$detail_shinsei = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."'", "list");
			for($i=0; $i<count($detail_shinsei); $i++){
				$where_list = "licence_pkey = ".$detail_shinsei[$i]['licence_pkey']." and newkbn = 1";
				$this->db->dbDelete("\"licence\"", $where_list);
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_APPDEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認
	 * 
	 */
	function app(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SHOUNIN);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";

			$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_SESSION['input']['licencehistory_pkey']), "detail");
			/** 詳細ﾃﾞｰﾀ */
			$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_history['shinsei_no'], "list");
			if(count($licence_list) > 0){
				for($i=0; $i<count($licence_list); $i++){
					if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
						$detail = $licence_list[$i];
					}
				}
				if(!is_array(@$detail)){
					$detail = $licence_list[0];
				}
			}else{
				$detail = $licence_list[0];
			}
			if(count($detail) > 0){
				if($detail['program_add_del']){
					$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
					$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
				}else{
					$detail['program_add_del'] = array();
				}
				if($detail['program_add_del_down']){
					$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
					$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
				}else{
					$detail['program_add_del_down'] = array();
				}
				#アップグレード元ライセンス管理番号
				if(@$detail['up_licence_kanrino']){
					$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
				}else{
					$detail['up_licence_kanrino'] = array();
				}		

				#使用所属
				$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
				if(@$detail['hold_qty'] == 99999999){
					$detail['install_su_name'] = "無制限";
				}else{
					$detail['install_su_name'] = $detail['hold_qty'];
				}

				if(count($list_use) > 0 ){
					foreach($list_use as $val){
						if(@$val['install_su'] == ""){
							$val['install_su'] = 0;
						}elseif(@$val['install_su'] == 99999999){
							$val['install_su'] = "無制限";
						}
						if(@$val['sosiki_pkey'] == ""){
							$val['sosiki_pkey'] = "0";
						}
						$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
					}
					$detail['use_sosiki_cmp'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$detail['use_sosiki_cmp']);
				}
				$history    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = @$_SESSION['input']['user_referer'];
		}else{
			$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_REQUEST['code']), "detail");
			/** 詳細ﾃﾞｰﾀ */
			$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_history['shinsei_no'], "list");
			if(count($licence_list) > 0){
				for($i=0; $i<count($licence_list); $i++){
					if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
						$detail = $licence_list[$i];
					}
				}
				if(!is_array(@$detail)){
					$detail = $licence_list[0];
				}
			}else{
				$detail = $licence_list[0];
			}
			
			//組織認証
			$this->sosiki_auth(array($detail['sinseisyozoku']));
			
			if(count($detail) > 0){
				if($detail['program_add_del']){
					$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
					$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
				}else{
					$detail['program_add_del'] = array();
				}
				if($detail['program_add_del_down']){
					$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
					$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
				}else{
					$detail['program_add_del_down'] = array();
				}
				#アップグレード元ライセンス管理番号
				if(@$detail['up_licence_kanrino']){
					$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
				}else{
					$detail['up_licence_kanrino'] = array();
				}		

				#使用所属
				$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
				if(@$detail['hold_qty'] == 99999999){
					$detail['install_su_name'] = "無制限";
				}else{
					$detail['install_su_name'] = $detail['hold_qty'];
				}

				if(count($list_use) > 0 ){
					foreach($list_use as $val){
						if(@$val['install_su'] == ""){
							$val['install_su'] = 0;
						}elseif(@$val['install_su'] == 99999999){
							$val['install_su'] = "無制限";
						}
						if(@$val['sosiki_pkey'] == ""){
							$val['sosiki_pkey'] = "0";
						}
						$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
					}
					$detail['use_sosiki_cmp'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$detail['use_sosiki_cmp']);
				}
				$history    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$item['syoninsya'] = _DEFAULT_SYONINSYA;
			$item['licencehistory_pkey'] = $detail['licencehistory_pkey'];
			$user_referer = _USER_REFERER;
			
			$item['syonin_date'] = date("Y/m/d H:i");
			$item['sinsei_date'] = $detail['sinsei_date'];
			$item['sinseisya'] = $detail['sinseisya'];
			$item['email_ad'] = $detail['email_ad'];
			$item['version'] = $detail['version'];
		}

		if($history['licence_pkey'] != ""){
			$version = $history['version']-1;
			$detail_his = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where licence_pkey = ".$history['licence_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_his['shinsei_no'], "list");
			if(count($licence_list) > 0){
				for($i=0; $i<count($licence_list); $i++){
					if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
						$detail = $licence_list[$i];
					}
				}
				if(!is_array(@$detail)){
					$detail = $licence_list[0];
				}
			}else{
				$detail = $licence_list[0];
			}

			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}		
			#ダウングレード使用時のプログラムの追加と削除の比較用データ
			if(@$detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}		
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".@$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = @$detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
				$detail['use_sosiki_cmp'] = $this->kanri_check($detail_his['kanri_sosiki_pkey'],$detail_his['sosiki_pkey'],$detail['use_sosiki_cmp']);
			}

			/** 比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$history['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $history['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$history['program_add_del'];
				if(count(@$history['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $history['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除の比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$history['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $history['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$history['program_add_del_down'];
				if(count(@$history['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $history['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}

			/** 比較 */
			$check_array = 	array(
						"kanri_sosiki_pkey",
						"licence_kanrino",
						"soft_name",
						"licence_keitai",
						"brand",
						"use_sosiki_cmp",
						"hard_kotei",
						"hard_kanrino",
						"upgrade",
						"up_licence_kanrino",
						"licence_no",
						"tyoutatu",
						"tokusitu_useproposal",
						"useproposal_youken",
						"hokan_baitai",
						"hokan_basyo",
						"program_add_del",
						"program_add_del_down",
						"bikou",
						"tyoutatu_date",
						"haiki_date",
						"edition",
						"price",
						"use_limit_date",
						"memo"
					);
			foreach($check_array as $val){
				@$history['$val'] = ereg_replace("\r","",@$history['$val']);
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}
		
		
		
		#install_su_name
		$new['install_su_name'] = "";
		if(@$detail['install_su_name'] != @$history['install_su_name'] and !is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = $_SESSION['input']['install_su_name'];
		}elseif(@$detail['install_su_name'] != @$history['install_su_name'] and is_array(@$new['use_sosiki_cmp']) and !is_array(@$old['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$history['install_su_name'] and is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$history['install_su_name'] and @$new['use_sosiki_cmp'] == " "){
			$new['install_su_name'] = $history['install_su_name'];
		}
		if(@$old['use_sosiki_cmp'] == ""){
			$old['install_su_name'] = @$detail['install_su_name'];
		}

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APP);
		$this->tpl->assignHtml('action_param','app');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/input_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}
	
	/**
	 * 内容確認
	 * 
	 */
	function app_conf(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SHOUNIN);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 承認時デフォルト値書換 */
		change_default_syonin(@$_SESSION['input']['syoninsya']);
		$item = $_SESSION['input'];
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app";
		$this->check_app();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}

		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_SESSION['input']['licencehistory_pkey']), "detail");
		/** 詳細ﾃﾞｰﾀ */
		$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_history['shinsei_no'], "list");
		if(count($licence_list) > 0){
			for($i=0; $i<count($licence_list); $i++){
				if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
					$detail = $licence_list[$i];
				}
			}
			if(!is_array(@$detail)){
				$detail = $licence_list[0];
			}
		}else{
			$detail = $licence_list[0];
		}
		if(count($detail) > 0){
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}
			if($detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = $detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
				$detail['use_sosiki_cmp'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$detail['use_sosiki_cmp']);
			}
			$history    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;


		if($history['licence_pkey'] != ""){
			$version = $history['version']-1;
			$detail_his = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where licence_pkey = ".$history['licence_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_his['shinsei_no'], "list");
			if(count($licence_list) > 0){
				for($i=0; $i<count($licence_list); $i++){
					if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
						$detail = $licence_list[$i];
					}
				}
				if(!is_array(@$detail)){
					$detail = $licence_list[0];
				}
			}else{
				$detail = $licence_list[0];
			}
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}		
			#ダウングレード使用時のプログラムの追加と削除の比較用データ
			if(@$detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}		
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".@$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = @$detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
				$detail['use_sosiki_cmp'] = $this->kanri_check($detail_his['kanri_sosiki_pkey'],$detail_his['sosiki_pkey'],$detail['use_sosiki_cmp']);
			}

			/** 比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$history['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $history['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$history['program_add_del'];
				if(count(@$history['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $history['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除の比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$history['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $history['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$history['program_add_del_down'];
				if(count(@$history['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $history['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}
			
			/** 比較 */
			$check_array = 	array(
						"kanri_sosiki_pkey",
						"licence_kanrino",
						"soft_name",
						"licence_keitai",
						"brand",
						"use_sosiki_cmp",
						"hard_kotei",
						"hard_kanrino",
						"upgrade",
						"up_licence_kanrino",
						"licence_no",
						"tyoutatu",
						"tokusitu_useproposal",
						"useproposal_youken",
						"hokan_baitai",
						"hokan_basyo",
						"program_add_del",
						"program_add_del_down",
						"bikou",
						"tyoutatu_date",
						"haiki_date",
						"edition",
						"price",
						"use_limit_date",
						"memo"
					);
			foreach($check_array as $val){
				@$history['$val'] = ereg_replace("\r","",@$history['$val']);
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}
		
		
		
		#install_su_name
		$new['install_su_name'] = "";
		if(@$detail['install_su_name'] != @$history['install_su_name'] and !is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = $_SESSION['input']['install_su_name'];
		}elseif(@$detail['install_su_name'] != @$history['install_su_name'] and is_array(@$new['use_sosiki_cmp']) and !is_array(@$old['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$history['install_su_name'] and is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$history['install_su_name'] and @$new['use_sosiki_cmp'] == " "){
			$new['install_su_name'] = $history['install_su_name'];
		}
		if(@$old['use_sosiki_cmp'] == ""){
			$old['install_su_name'] = @$detail['install_su_name'];
		}

		$app_col = select_code("00008");
		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',$app_col[@$_SESSION['input']['syonin_kbn']]);
		$this->tpl->assignHtml('action_param','app');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 内容確認
	 * 承認・却下
	 */
	function app_done(){
		$page_name = "system,syonin";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_SESSION['input']['licencehistory_pkey']), "detail");
		$licencehistory_pkey = $detail_history['shinsei_no'];
		$syonin_kbn       = addslashes(@$_SESSION['input']['syonin_kbn']);
		$syoninsya        = addslashes(@$_SESSION['input']['syoninsya']);
		$syonin_date      = addslashes(@$_SESSION['input']['syonin_date']);

		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',@$detail_history['licence_kanrino']);
			if($syonin_kbn == "d001"){
				$hold_qty = $this->db->dbSelect("select * from hold_licence_qty where licence_kanrino='".$detail['licence_kanrino']."'", "detail");
				if(count($hold_qty) > 0){
					$where_hold_qty = "licence_kanrino ='".$detail['licence_kanrino']."'";
					$fields_values = array(
							"hold_qty" => $detail['hold_qty']
							      );
					$this->db->dbUpdate("\"hold_licence_qty\"", $fields_values, $where_hold_qty);
				}else{
					$fields_values = array(
							"licence_kanrino" => $detail['licence_kanrino'],
							"hold_qty" => $detail['hold_qty']
							      );
					$this->db->dbInsert("\"hold_licence_qty\"", $fields_values);
				}
			}
			
			$detail_shinsei = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."'", "list");
			for($i=0; $i<count($detail_shinsei); $i++){
				$where_rireki = "history_pkey = ".$detail_shinsei[$i]['licencehistory_pkey']." and history_type = 'd003'";
				$fields_values = array(
						"syonin_kbn"          => $syonin_kbn,
						"syoninsya"           => $syoninsya,
						"syonin_date"         => $syonin_date
						      );
				$this->db->dbUpdate("\"rireki\"", $fields_values, $where_rireki);

				if($syonin_kbn == "d001"){
					$where_list = "licence_pkey = ".$detail_shinsei[$i]['licence_pkey'];
					$fields_values = array(
							"kanri_sosiki_pkey" => $detail_shinsei[$i]['kanri_sosiki_pkey'],
							"sosiki_pkey"       => $detail_shinsei[$i]['sosiki_pkey'],
							"licencelist_pkey"  => $detail_shinsei[$i]['licencelist_pkey'],
							"licence_kanrino"   => $detail_shinsei[$i]['licence_kanrino'],
							"install_su"        => $detail_shinsei[$i]['install_su'],
							"hard_pkey"         => $detail_shinsei[$i]['hard_pkey'],
							"licence_pkey2"     => $detail_shinsei[$i]['licence_pkey2'],
							"licence_no"        => $detail_shinsei[$i]['licence_no'],
							"tyoutatu"          => $detail_shinsei[$i]['tyoutatu'],
							"hokan_baitai"      => $detail_shinsei[$i]['hokan_baitai'],
							"hokan_basyo"       => $detail_shinsei[$i]['hokan_basyo'],
							"bikou"             => $detail_shinsei[$i]['bikou'],
							"tyoutatu_date"     => $detail_shinsei[$i]['tyoutatu_date'],
							"haiki_date"        => $detail_shinsei[$i]['haiki_date'],
							"price"             => $detail_shinsei[$i]['price'],
							"use_limit_date"    => $detail_shinsei[$i]['use_limit_date'],
							"memo"              => $detail_shinsei[$i]['memo'],
							"version"           => $detail_shinsei[$i]['version'] + 1, 
							"newkbn"            => 0
							      );
					$this->db->dbUpdate("\"licence\"", $fields_values, $where_list);
				}else{
					$where_list = "licence_pkey = ".$detail_shinsei[$i]['licence_pkey']." and newkbn = 1";
					$this->db->dbDelete("\"licence\"", $where_list);
				}
			}

			if($syonin_kbn == "d001"){
				$action = "承認";
			}else{
				$action = "却下";
			}
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$syoninsya);
			$mail_tpl->assignHtml('syonin_date',$syonin_date);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ライセンス台帳　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		$app_col = select_code("00008");
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', $app_col[@$_SESSION['input']['syonin_kbn']]);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認
	 * 表示
	 */
	function app_view(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_REQUEST['code']), "detail");
		/** 詳細ﾃﾞｰﾀ */
		$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_history['shinsei_no'], "list");
		if(count($licence_list) > 0){
			for($i=0; $i<count($licence_list); $i++){
				if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
					$detail = $licence_list[$i];
				}
			}
			if(!is_array(@$detail)){
				$detail = $licence_list[0];
			}
		}else{
			$detail = $licence_list[0];
		}
		//組織認証
		$this->sosiki_auth(array($detail['sinseisyozoku']));
		
		if(count($detail) > 0){
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}
			if($detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = $detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
				$detail['use_sosiki_cmp'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$detail['use_sosiki_cmp']);
			}
			$history    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		$item['syoninsya'] = _DEFAULT_SYONINSYA;
		
		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date']       = $detail['sinsei_date'];
		$item['sinseisya']         = $detail['sinseisya'];
		$item['email_ad']          = $detail['email_ad'];
		$item['licencehistory_pkey']  = $detail['licencehistory_pkey'];
		$item['version']           = $detail['version'];
		$user_referer              = _USER_REFERER;

		if($history['licence_pkey'] != ""){
			$version = $history['version']-1;
			$detail_his = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where licence_pkey = ".$history['licence_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_his['shinsei_no'], "list");
			if(count($licence_list) > 0){
				for($i=0; $i<count($licence_list); $i++){
					if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
						$detail = $licence_list[$i];
					}
				}
				if(!is_array(@$detail)){
					$detail = $licence_list[0];
				}
			}else{
				$detail = $licence_list[0];
			}
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}		
			#ダウングレード使用時のプログラムの追加と削除の比較用データ
			if(@$detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}		
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".@$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = @$detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
				$detail['use_sosiki_cmp'] = $this->kanri_check($detail_his['kanri_sosiki_pkey'],$detail_his['sosiki_pkey'],$detail['use_sosiki_cmp']);
			}

			/** 比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$history['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $history['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$history['program_add_del'];
				if(count(@$history['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $history['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除の比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$history['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $history['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$history['program_add_del_down'];
				if(count(@$history['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $history['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}

			/** 比較 */
			$check_array = 	array(
						"kanri_sosiki_pkey",
						"licence_kanrino",
						"soft_name",
						"licence_keitai",
						"brand",
						"use_sosiki_cmp",
						"hard_kotei",
						"hard_kanrino",
						"upgrade",
						"up_licence_kanrino",
						"licence_no",
						"tyoutatu",
						"tokusitu_useproposal",
						"useproposal_youken",
						"hokan_baitai",
						"hokan_basyo",
						"program_add_del",
						"program_add_del_down",
						"bikou",
						"tyoutatu_date",
						"haiki_date",
						"edition",
						"price",
						"use_limit_date",
						"memo"
					);
			foreach($check_array as $val){
				@$history['$val'] = ereg_replace("\r","",@$history['$val']);
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}
		
		
		
		#install_su_name
		$new['install_su_name'] = "";
		if(@$detail['install_su_name'] != @$history['install_su_name'] and !is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = $_SESSION['input']['install_su_name'];
		}elseif(@$detail['install_su_name'] != @$history['install_su_name'] and is_array(@$new['use_sosiki_cmp']) and !is_array(@$old['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$history['install_su_name'] and is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$history['install_su_name'] and @$new['use_sosiki_cmp'] == " "){
			$new['install_su_name'] = $history['install_su_name'];
		}
		if(@$old['use_sosiki_cmp'] == ""){
			$old['install_su_name'] = @$detail['install_su_name'];
		}

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPVIEW);
		$this->tpl->assignHtml('action_param','app_view');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 内容確認
	 * 表示
	 */
	function rireki_del(){
		$this->tpl->assignHtml('title', _TITLE_APP_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_REQUEST['code']), "detail");
		/** 詳細ﾃﾞｰﾀ */
		$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_history['shinsei_no'], "list");
		if(count($licence_list) > 0){
			for($i=0; $i<count($licence_list); $i++){
				if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
					$detail = $licence_list[$i];
				}
			}
			if(!is_array(@$detail)){
				$detail = $licence_list[0];
			}
		}else{
			$detail = $licence_list[0];
		}

		$_SESSION['input']['licencehistory_pkey']    = $detail['licencehistory_pkey'];
		$_SESSION['input']['user_referer'] = _USER_REFERER;

		if(count($detail) > 0){
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}
			if($detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = $detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
			}
			$old    = $detail;
			
			#install_su_name
			if(is_array(@$old['use_sosiki_cmp'])){
				$old['install_su_name'] = "";
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date']       = $detail['sinsei_date'];
		$item['sinseisya']         = $detail['sinseisya'];
		$item['email_ad']          = $detail['email_ad'];
		$item['licencehistory_pkey']  = $detail['licencehistory_pkey'];
		$item['version']           = $detail['version'];
		$user_referer              = _USER_REFERER;

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','rireki_del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function rireki_del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_SESSION['input']['licencehistory_pkey']), "detail");
		$licencehistory_pkey = $detail_history['shinsei_no'];
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',@$detail['licence_kanrino']);

			$detail_shinsei = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			for($i=0; $i<count($detail_shinsei); $i++){
				$where_licence_rireki = "licencehistory_pkey = ".$detail_shinsei[$i]['licencehistory_pkey'];
				$this->db->dbDelete("\"licencerireki\"", $where_licence_rireki);
				$this->db->dbDelete("\"hold_licence_qry_rireki\"", $where_licence_rireki);
				$where_rireki = "history_pkey = ".$detail_shinsei[$i]['licencehistory_pkey']." and history_type = 'd003'";
				$this->db->dbDelete("\"rireki\"", $where_rireki);
				$where_list = "licence_pkey = ".$detail_shinsei[$i]['licence_pkey']." and newkbn = 1";
				$this->db->dbDelete("\"licence\"", $where_list);
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 削除
	 * 確認
	 */
	function del(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$licence_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['licence_pkey']    = $licence_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;

		/** エラーﾁｪｯｸ */
		$_SESSION['input']['method'] = "del";
		$this->check_del();
		if(@$_SESSION['input']['error_flag'] == true || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
		}

		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey=".$licence_pkey." order by \"sosiki_sortkey\"", "detail");

		/** プログラムの追加と削除の表示用データ */
		if($detail['program_add_del']){
			$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
			$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
		}else{
			$detail['program_add_del'] = array();
		}
		/** ダウングレード使用時のプログラムの追加と削除の表示用データ */
		if($detail['program_add_del_down']){
			$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
			$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
		}else{
			$detail['program_add_del_down'] = array();
		}
		/** アップグレード元ライセンス管理番号 */
		if($detail['up_licence_kanrino']){
			$detail['up_licence_kanrino'] =explode(",",$detail['up_licence_kanrino']);
		}else{
			$detail['up_licence_kanrino'] = array();
		}
		/** アップグレード元ライセンスキー */
		if($detail['licence_pkey2']){
			$detail['licence_pkey2'] =explode(",",$detail['licence_pkey2']);
		}else{
			$detail['licence_pkey2'] = array();
		}
		
		if(count($detail) > 0){
			$item    = $detail;
			if($item['hold_qty'] == 99999999){
				$item['install_su_name'] = "無制限";
			}elseif(!$item['hold_qty']){
				$item['install_su_name'] = 0;
			}else{
				$item['install_su_name'] = $item['hold_qty'];
			}
			if($item['install_su'] == 99999999){
				$item['install_su'] = "無制限";
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('license/confirm_del.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$licence_pkey = addslashes(@$_SESSION['input']['licence_pkey']);
		$where = "licence_pkey = ".$licence_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from \"licence\" where ".$where, "detail");
		if(count($detail) > 0){
			$where_pkey = "licence_pkey = ".$detail['licence_pkey'];
			/** ソフトウェア台帳削除 */
			$this->db->dbDelete("\"soft\"", $where_pkey);
			/** 削除 */
			$this->db->dbDelete("\"licence\"", $where_pkey);
			
			if($detail['kanri_sosiki_pkey'] == $detail['sosiki_pkey']){
				$where_licence = "licence_kanrino = '".$detail['licence_kanrino']."'";
				$this->db->dbDelete("\"hold_licence_qty\"", $where_licence);
			}
			
			$this->tpl->assignHtml('name',$detail['licence_kanrino']);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check(){
		
		#入力チェック(警告)
		$cci_att = new CheckItem;
		$child_where = " where user_pkey = ".$this->authuser_code;
		$sosiki_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
		$child_array = child_sosiki_key($sosiki_detail['sosiki_pkey']);
		array_push($child_array,$sosiki_detail['sosiki_pkey']);
		if(!in_array(@$_SESSION['input']['kanri_sosiki_pkey'],$child_array) and @$_SESSION['input']['kanri_sosiki_pkey'] != "0" and _ERROR_0271){
			$cci_att->checkErrorCode("0271");
		}
		if(@$_SESSION['input']['tyoutatu_date'] == "" or @$_SESSION['input']['tyoutatu'] == "" and _ERROR_0209){
			$cci_att->checkErrorCode("0209");
		}
		if(@$_SESSION['input']['licencelist_pkey'] != ""){
			if(@$_SESSION['input']['install_su_type'] == "mugen"){
				$install_su = 99999999;
			}else{
				$install_su = @$_SESSION['input']['hold_qty'];
			}
			$where_ll = " where licencelist_pkey = ".$_SESSION['input']['licencelist_pkey'];
			$licencelist_detail = $this->db->dbSelect("select * from licencelist_detail".$where_ll, "detail");
			if(@$_SESSION['input']['hold_qty'] != 1 and @$licencelist_detail['licence_keitai'] == "d004" and _ERROR_0228){
				$cci_att->checkErrorCode("0228");
			}
			if(@$install_su == 99999999 and (@$licencelist_detail['licence_keitai'] == "d002" or @$licencelist_detail['licence_keitai'] == "d003" or @$licencelist_detail['licence_keitai'] == "d004" or @$licencelist_detail['licence_keitai'] == "d005" or @$licencelist_detail['licence_keitai'] == "d006") and _ERROR_0229){
				$cci_att->checkErrorCode("0229");
			}
			if(@$licencelist_detail['upgrade'] == "d001" and @$_SESSION['input']['licence_pkey2'] == "" and _ERROR_0222){
				$cci_att->checkErrorCode("0222");
			}
			if(@$licencelist_detail['hard_kotei'] == "d001" and @$_SESSION['input']['hard_pkey'] != ""){
				$where_hard = " where hard_pkey = ".$_SESSION['input']['hard_pkey'];
				$hard_detail = $this->db->dbSelect("select * from hard_detail".$where_hard, "detail");
				if(@$hard_detail["haiki_date"] != "" and _ERROR_0227){
					$cci_att->checkErrorCode("0227");
				}
			}
		}
		if(count(@$_SESSION['input']['licence_pkey2']) > 0){
			if(is_array(@$_SESSION['input']['licence_pkey2'])){
				$licence_pkey2_array = $_SESSION['input']['licence_pkey2'];
			}else{
				$licence_pkey2_array = array();
			}
			$error_225 = false;
			$error_226 = false;
			for($i=0; $i<count($licence_pkey2_array); $i++){
				$where_licence = " where licence_pkey = ".$licence_pkey2_array[$i];
				$licence_detail = $this->db->dbSelect("select * from licence_detail".$where_licence, "detail");
				if(@$licencelist_detail['upgrade'] == "d001" and @$licence_detail['haiki_date'] != ""){
					$error_225 = true;
				}
				if(@$licencelist_detail['upgrade'] == "d001" and @$licence_detail['upgrade'] == "d001"){
					$error_226 = true;
				}
			}
			if(@$_SESSION['input']['install_su_type'] == "mugen"){
				$install_su = 99999999;
			}else{
				$install_su = @$_SESSION['input']['hold_qty'];
			}
			if(@$_SESSION['input']['licence_pkey2'] != "" and @$licence_detail['install_su'] != $install_su and _ERROR_0224){
				$cci_att->checkErrorCode("0224");
			}
			if($error_225 and _ERROR_0225){
				$cci_att->checkErrorCode("0225");
			}

			if($error_226 and _ERROR_0226){
				$cci_att->checkErrorCode("0226");
			}
		}

		$where = " where sosiki_pkey in (".implode(",",$child_array).")";
		$list = $this->db->dbSelect("select DISTINCT ON (hokan_basyo) hokan_basyo from licence_detail".$where." order by hokan_basyo", "list");
		$items = array();
		if(count($list) > 0){
			for($i=0; $i<count($list); $i++){
				$items[] = $list[$i]['hokan_basyo'];
			}
		}
		if(@$_SESSION['input']['hokan_basyo'] != "" and !in_array(@$_SESSION['input']['hokan_basyo'],$items) and _ERROR_0278){
			$cci_att->checkErrorCode("0278");
		}

		#使用所属関係エラー
		$sosiki_array = array();
		if(@$_SESSION['input']['sosiki_pkey_self'] != "" and @$_SESSION['input']['sosiki_pkey_self'] != 0){
			$sosiki_array[] = $_SESSION['input']['sosiki_pkey_self'];
		}
		if(@$_SESSION['input']['use_sosiki_qty'] > 0){
			for($i=0; $i<$_SESSION['input']['use_sosiki_qty']; $i++){
				$licence_pkey =	"licence_pkey_".$i;
				$sosiki_pkey =	"sosiki_pkey_".$i;
				$install_qty =	"install_su_".$i;
				if(@$_SESSION['input'][$install_qty] != "" and @$_SESSION['input'][$sosiki_pkey] != "" and @$_SESSION['input'][$sosiki_pkey] != 0){
					$sosiki_array[] = $_SESSION['input'][$sosiki_pkey];
				}
			}
		}
		if(count($sosiki_array) <= 0 and _ERROR_0274){
			$cci_att->checkErrorCode("0274");
		}
		
		if($cci_att->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['att_flag']  = true;
			$_SESSION['input']['att_msg']   = $cci_att->error_msg;
		}
		
		
		#入力チェック
		$cci = new CheckItem;

		#バージョンチェック
		if($_SESSION['input']['use_sosiki_qty'] > 0){
			$error_0051 = false;
			for($i=0; $i<$_SESSION['input']['use_sosiki_qty']; $i++){
				$version_name = "version_".$i;
				$version = @$_SESSION['input'][$version_name];
				$licence_pkey_name = "licence_pkey_".$i;
				$licence_pkey = @$_SESSION['input'][$licence_pkey_name];
				if($licence_pkey != ""){
					$where = " where licence_pkey = ".$licence_pkey." and newkbn <> 1";
					$detail = $this->db->dbSelect("select * from licence_detail".$where, "detail");
					if($version != $detail['version'] and _ERROR_0051){
						$error_0051 = true;
					}
				}
			}
			if(@$_SESSION['input']['licence_pkey_self'] != ""){
				$where = " where licence_pkey = ".$_SESSION['input']['licence_pkey_self']." and newkbn <> 1";
				$detail = $this->db->dbSelect("select * from licence_detail".$where, "detail");
				if(@$_SESSION['input']['version_self'] != $detail['version'] and _ERROR_0051){
					$error_0051 = true;
				}
			}
			if($error_0051){
				$cci->checkErrorCode("0051");
			}
		}

		if($_SESSION['input']['method'] != "edit"){
			$cci->checkItemNon(array("email_ad"=>"申請者メールアドレス"));
			$cci->checkItemEmailArray(array("email_ad"=>"申請者メールアドレス"));
		
			$email_ad = explode("@",@$_SESSION['input']['email_ad']);
			if(count($email_ad)>=2){
				if(!in_array($email_ad[1],select_code("00027")) and _ERROR_0254){
					$cci->checkErrorCode("0254");
				}
			}
		}

		$error_name_array = select_code("00012");
		if(@$_SESSION['input']['install_su_type'] == "mugen"){
			$install_su = 99999999;
		}else{
			$install_su = @$_SESSION['input']['hold_qty'];
		}

		if(@$_SESSION['input']['kanri_sosiki_pkey'] == "0" and _ERROR_0270){
			$cci->checkErrorCode("0270");
		}
		if(@$_SESSION['input']['licencelist_pkey'] == "" and _ERROR_0214){
			$cci->checkErrorCode("0214");
		}else{
			$where_ll = " where licencelist_pkey = ".$_SESSION['input']['licencelist_pkey'];
			$licencelist_detail = $this->db->dbSelect("select * from licencelist_detail".$where_ll, "detail");
			if(@$licencelist_detail['hard_kotei'] == "d001" and @$_SESSION['input']['hard_pkey'] == "" and _ERROR_0220){
				$cci->checkErrorCode("0220");
			}
			if(@$licencelist_detail['hard_kotei'] == "d002" and @$_SESSION['input']['hard_pkey'] != "" and _ERROR_0221){
				$cci->checkErrorCode("0221");
			}
			if(@$licencelist_detail['upgrade'] == "d002" and @$_SESSION['input']['licence_pkey2'] != "" and _ERROR_0223){
				$cci->checkErrorCode("0223");
			}
			if(@$licencelist_detail['disabled'] == "d001" and _ERROR_0275){
				$cci->checkErrorCode("0275");
			}
		}
		if(@$_SESSION['input']['licence_kanrino'] == "" and _ERROR_0214){
			$cci->checkErrorCode("0214");
		}
		if(@$_SESSION['input']['install_su_type'] == "limit" and @$_SESSION['input']['hold_qty'] == "" and _ERROR_0215){
			$cci->checkErrorCode("0215");
		}
		if(@$_SESSION['input']['hokan_baitai'] == "" and _ERROR_0217){
			$cci->checkErrorCode("0217");
		}
		if(@$_SESSION['input']['hokan_basyo'] == "" and _ERROR_0218){
			$cci->checkErrorCode("0218");
		}
		
		if(@$_SESSION['input']['haiki_date'] != "" and strtotime(@$_SESSION['input']['haiki_date']) <= strtotime(date("Y/m/d"))){
			$where = " where licence_kanrino = '".addslashes($_SESSION['input']['licence_kanrino'])."' and (haiki_date > current_date or haiki_date is null)";
			$soft_list = $this->db->dbSelect("select * from soft_detail".$where, "list");
			if(count($soft_list) > 0 and _ERROR_0258){
				$cci->checkErrorCode("0258");
			}
		}
		#使用所属関係エラー
		if(@$_SESSION['input']['use_sosiki_qty'] > 0){
			$total_qty = 0;
			$sosiki_array = array();
			if(@$_SESSION['input']['install_su_self'] != "" and @$_SESSION['input']['sosiki_pkey_self'] != "" and @$_SESSION['input']['sosiki_pkey_self'] != 0){
				if($_SESSION['input']['install_su_self'] != "無制限"){
					$cci->checkNumeric(array("install_su_self" => "使用所属の導入可能数"));
				}
				if(in_array($_SESSION['input']['sosiki_pkey_self'],$sosiki_array) and _ERROR_0273){
					$cci->checkErrorCode("0273");
				}else{
					array_push($sosiki_array, $_SESSION['input']['sosiki_pkey_self']);
				}
			}
			for($i=0; $i<$_SESSION['input']['use_sosiki_qty']; $i++){
				$licence_pkey =	"licence_pkey_".$i;
				$sosiki_pkey =	"sosiki_pkey_".$i;
				$install_qty =	"install_su_".$i;
				if(@$_SESSION['input'][$install_qty] != "" and @$_SESSION['input'][$sosiki_pkey] != "" and @$_SESSION['input'][$sosiki_pkey] != 0){
					if($_SESSION['input'][$install_qty] != "無制限"){
						$cci->checkNumeric(array($install_qty => "使用所属の導入可能数"));
					}
					if(in_array($_SESSION['input'][$sosiki_pkey],$sosiki_array) and _ERROR_0273){
						$cci->checkErrorCode("0273");
					}else{
						array_push($sosiki_array, $_SESSION['input'][$sosiki_pkey]);
					}
				}
			}
			if(@$_SESSION['input']['install_su_self'] < 0 and $install_su < 99999999 and _ERROR_0272){
				$cci->checkErrorCode("0272");
			}
		}
		

		if(@$_SESSION['input']['price'] != ""){
			$cci->checkNumeric(array("price"=>$error_name_array['027']));
		}
		if($_SESSION['input']['method'] == "app_reg"){
			$where = " where newkbn <> 1 and licence_kanrino = '".addslashes($_SESSION['input']['licence_kanrino'])."' and (haiki_date > current_date or haiki_date is null)";
		}else{
			$old_licence = $this->db->dbSelect("select * from licence_detail where licence_pkey = ".$_SESSION['input']['licence_pkey'], "detail");
			$where = " where licence_kanrino='".$old_licence['licence_kanrino']."' and newkbn <> 1";
			$old_licence_list = $this->db->dbSelect("select * from licence_detail".$where, "list");
			$same_licence_in_array = array();
			if(count($old_licence_list) > 0){
				for($i=0; $i<count($old_licence_list); $i++){
					$same_licence_in_array[] = $old_licence_list[$i]['licence_pkey'];
				}
			}
			$same_licence_in = implode(",",$same_licence_in_array);
			$where = " where newkbn <> 1 and licence_pkey NOT IN (".$same_licence_in.") and licence_kanrino = '".addslashes($_SESSION['input']['licence_kanrino'])."' and (haiki_date > current_date or haiki_date is null)";
		}
		/** 詳細ﾃﾞｰﾀ */
		$list = $this->db->dbSelect("select * from licence_detail".$where, "list");
		if(count($list) > 0 and _ERROR_0230){
			$cci->checkErrorCode("0230");
		}
		if($_SESSION['input']['method'] != "del" and $_SESSION['input']['method'] != "edit"){
			if(@$_SESSION['input']['sinseisya'] == "" and _ERROR_0201){
				$cci->checkErrorCode("0201");
			}
			if(@$_SESSION['input']['sinsei_date'] == "" and _ERROR_0202){
				$cci->checkErrorCode("0202");
			}
		}
		if(@$_SESSION['input']['haiki_date'] != ""){
			$where = " where licence_pkey = ".$_SESSION['input']['licence_pkey']." and haiki_date > '".$_SESSION['input']['haiki_date']."' and newkbn <> 1";
			$soft_list = $this->db->dbSelect("select * from soft_detail".$where, "list" and _ERROR_0282);
			if(count($soft_list) > 0){
				$cci->checkErrorCode("0282");
			}
		}
		$cci->checkItemDate01(array("tyoutatu_date"=>$error_name_array['021'],"haiki_date"=>$error_name_array['022'],"use_limit_date"=>$error_name_array['028']));
		$cci->checkItemDateTime(array("sinsei_date"=>"申請日"));
		if(@$_SESSION['input']['install_su_type'] == "limit" and @$_SESSION['input']['hold_qty'] != ""){
			$cci->checkNumeric(array("hold_qty"=>$error_name_array['006']));
		}

		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check_app(){
		#入力チェック
		$cci = new CheckItem;

		$detail = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$_SESSION['input']['licencehistory_pkey'], "detail");
		if($_SESSION['input']['syonin_kbn'] == 'd001'){
			#バージョンチェック
			$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail['shinsei_no'], "list");
			if(count($licence_list) > 0){
				$error_0103 = false;
				for($i=0; $i<count($licence_list); $i++){
					$detail_old = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey = ".$licence_list[$i]['licence_pkey']." and newkbn <> 1", "detail");
					if($licence_list[$i]['version'] != $detail_old['version'] and @$detail_old[licence_pkey] != ""){
						$error_0103 = true;
					}
				}
				if($error_0103 and _ERROR_0103){
					$cci->checkErrorCode("0103");
				}
			}
		}
		
		if (strtotime(@$_SESSION['input']['syonin_date']) < strtotime($detail['sinsei_date']) and _ERROR_0104) {
			$cci->checkErrorCode("0104");
		}
		if(@$_SESSION['input']['syoninsya'] == "" and _ERROR_0101){
			$cci->checkErrorCode("0101");
		}
		if(@$_SESSION['input']['syonin_date'] == "" and _ERROR_0102){
			$cci->checkErrorCode("0102");
		}


		$error_name_array = select_code("00015");
		$cci->checkItemDateTime(array("syonin_date"=>$error_name_array['007']));
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check_del(){
		#入力チェック(警告)
		$cci_att = new CheckItem;

		/** CODE ｴｽｹｰﾌﾟ */
		$licence_pkey = addslashes(@$_SESSION['input']['licence_pkey']);
		$where = "licence_pkey = ".$licence_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from \"licence\" where ".$where, "detail");
		if(count($detail) > 0){
			$del_licence_list = $this->db->dbSelect("select * from \"licence\" where licence_kanrino = '".$detail['licence_kanrino']."'", "list");
			if(count($del_licence_list) > 0){
				$del_in_array = array();
				for($i=0; $i<count($del_licence_list); $i++){
					$del_in_array[] = $del_licence_list[$i]['licence_pkey'];
				}
				$del_in = implode(",",$del_in_array);
				$where = " where licence_pkey IN (".$del_in.")";
				$list = $this->db->dbSelect("select * from soft".$where, "list");
				if(count($list) > 0 and _ERROR_0024){
					$cci_att->checkErrorCode("0024",array("ソフトウェア台帳"));
				}
			}
		}
		if($cci_att->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['att_flag']  = true;
			$_SESSION['input']['att_msg']   = $cci_att->error_msg;
		}


		#入力チェック
		$cci = new CheckItem;

		$where = " where licence_pkey2 = '".addslashes($_SESSION['input']['licence_pkey'])."'";
		$list = $this->db->dbSelect("select * from licence".$where, "list");
		if(count($list) > 0 and _ERROR_0023){
			$cci->checkErrorCode("0023",array("アップグレード元ライセンス","ライセンス"));
		}
		
		/** 詳細ﾃﾞｰﾀ */
		$licence_list = $this->db->dbSelect("select * from \"licence\" where licence_kanrino = '".$detail['licence_kanrino']."' and kanri_sosiki_pkey <> sosiki_pkey and newkbn <> 1", "list");
		if(count($licence_list) > 0 and $detail['kanri_sosiki_pkey'] == $detail['sosiki_pkey'] and _ERROR_0283){
			$cci->checkErrorCode("0283");
		}
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "";
		$this->login($page_name);
		
		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where (sosiki_pkey in (".implode(",",$sosiki_array).") or kanri_sosiki_pkey in (".implode(",",$sosiki_array).")) and (haiki_date > '".date("Y/m/d")."' or haiki_date is null ) and newkbn <> 1";
		}

		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=license.csv");

		$list = $this->db->dbSelect("SELECT * FROM licence_detail".$_SESSION['csv'], "list");
		#自所属＋配下所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);

		$this->tpl->assignHtml('kanri_child_sosiki',  $child_array);
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		print mb_convert_encoding($this->tpl->fetchHtml('license/csv.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * プリント出力
	 */
	function prt(){
		$page_name = "";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_LICENSE);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where (sosiki_pkey in (".implode(",",$sosiki_array).") or kanri_sosiki_pkey in (".implode(",",$sosiki_array).")) and (haiki_date > '".date("Y/m/d")."' or haiki_date is null ) and newkbn <> 1";
		}
		
		$list = $this->db->dbSelect("SELECT * FROM licence_detail".$_SESSION['csv'], "list");
		if(count($list) > 0){
			for($i=0; $i<count($list); $i++){
				/** プログラムの追加と削除での表示 */
				$program_add_del_array = explode("\n",$list[$i]['program_add_del']);
				$list[$i]['program_add_del'] = $program_add_del_array;
				/** ダウングレード使用時のプログラムの追加と削除での表示 */
				$program_add_del_down_array = explode("\n",$list[$i]['program_add_del_down']);
				$list[$i]['program_add_del_down'] = $program_add_del_down_array;
				/** アップグレード元ライセンス管理番号 */
				$up_licence_kanrino_array = explode(",",$list[$i]['up_licence_kanrino']);
				$list[$i]['up_licence_kanrino'] = $up_licence_kanrino_array;
			}
		}

		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('list_view',$list);
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('license/print.html'));
		$this->tpl->outputHtml('print_list.html');

	}
	
	/**
	 * 申請書印刷
	 */
	function app_print(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_APP);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		$sosiki_array = select_sosiki();
		
		if(@$_SESSION['input']['install_su_type'] == "mugen"){
			$_SESSION['input']['hold_qty'] = 99999999;
			$_SESSION['input']['install_su_name'] = "無制限";
		}else{
			$_SESSION['input']['install_su_name'] = $_SESSION['input']['hold_qty'];
		}
		
		#使用所属
		$_SESSION['input']['use_sosiki_cmp'] = array();
		if(@$_SESSION['input']['sosiki_pkey_self'] != "" and @$_SESSION['input']['sosiki_pkey_self'] != 0){
			$_SESSION['input']['use_sosiki_cmp'][] = array(
									"sosiki_pkey"	=> @$_SESSION['input']['sosiki_pkey_self'],
									"install_su"	=> @$_SESSION['input']['install_su_self'],
									"hold_qty"	=> @$_SESSION['input']['install_su_name']
									);
		}
		if(count(@$_SESSION['input']['use_sosiki']) > 0){
			foreach($_SESSION['input']['use_sosiki'] as $key=>$value){
				$licence_pkey =	"licence_pkey_".$key;
				$sosiki_pkey =	"sosiki_pkey_".$key;
				$install_su =	"install_su_".$key;
				if((@$_SESSION['input'][$install_su] != "" and @$_SESSION['input'][$sosiki_pkey] != "" and @$_SESSION['input'][$sosiki_pkey] != 0) or @$_SESSION['input'][$licence_pkey] != ""){
					if(@$_SESSION['input'][$install_su] == ""){
						$_SESSION['input'][$install_su] = 0;
					}
					$_SESSION['input']['use_sosiki_cmp'][] = array(
											"sosiki_pkey"	=> @$_SESSION['input'][$sosiki_pkey],
											"install_su"	=> @$_SESSION['input'][$install_su],
											"hold_qty"	=> @$_SESSION['input']['install_su_name']
											);
				}
			}
		}
		
		$detail_licenselist = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".@$_SESSION['input']['licencelist_pkey']."'", "detail");
		$_SESSION['input']['soft_name'] = $detail_licenselist['soft_name'];
		$_SESSION['input']['licence_keitai'] = $detail_licenselist['licence_keitai'];
		$_SESSION['input']['brand'] = $detail_licenselist['brand'];
		$_SESSION['input']['edition'] = $detail_licenselist['edition'];
		$_SESSION['input']['hard_kotei'] = $detail_licenselist['hard_kotei'];
		$_SESSION['input']['upgrade'] = $detail_licenselist['upgrade'];
		if($_SESSION['input']['hard_pkey']){
			$detail_hard = $this->db->dbSelect("select * from hard_detail where hard_pkey='".@$_SESSION['input']['hard_pkey']."'", "detail");
			$_SESSION['input']['hard_kanrino'] = $detail_hard['hard_kanrino'];
		}
		$_SESSION['input']['tokusitu_useproposal'] = $detail_licenselist['tokusitu_useproposal'];
		$_SESSION['input']['useproposal_youken'] = $detail_licenselist['useproposal_youken'];

		/** プログラムの追加と削除での比較用データ */
		if($detail_licenselist['program_add_del']){
			$detail_licenselist['program_add_del'] = ereg_replace("\r","",$detail_licenselist['program_add_del']);
			$_SESSION['input']['program_add_del'] = explode("\n",$detail_licenselist['program_add_del']);
		}else{
			$_SESSION['input']['program_add_del'] = array();
		}
		/** ダウングレード使用時のプログラムの追加と削除での比較用データ */
		if($detail_licenselist['program_add_del_down']){
			$detail_licenselist['program_add_del_down'] = ereg_replace("\r","",$detail_licenselist['program_add_del_down']);
			$_SESSION['input']['program_add_del_down'] = explode("\n",$detail_licenselist['program_add_del_down']);
		}else{
			$_SESSION['input']['program_add_del_down'] = array();
		}

		if($detail_licenselist['upd_date'] != ""){
			$day = explode("-",$detail_licenselist['upd_date']);
		}else{
			$day = explode("/",$_SESSION['input']['sinsei_date']);
		}
		$check_date = date("Ymd",mktime(0,0,0,$day[1],$day[2] + _USE_COND_CHECK_DAY,$day[0]));

		$sinseidatetime = explode(" ",$_SESSION['input']['sinsei_date']);
		$sinsei = explode("/",$sinseidatetime[0]);
		$sinsei_date = date("Ymd",mktime(0,0,0,$sinsei[1],$sinsei[2],$sinsei[0]));

		if($detail_licenselist['useproposal_kakunin'] == "d001" and $check_date <= $sinsei_date){
			$this->tpl->assignHtml('kakunin',true);
		}


		if(@$_SESSION['input']['licence_pkey'] != ""){
			$detail = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey = ".$_SESSION['input']['licence_pkey'], "detail");
			$detail['tyoutatu_date'] = ereg_replace("-","/",$detail['tyoutatu_date']);
			$detail['use_limit_date'] = ereg_replace("-","/",$detail['use_limit_date']);
			$detail['haiki_date'] = ereg_replace("-","/",$detail['haiki_date']);
		
			/** プログラムの追加と削除での比較用データ */
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}
			/** ダウングレード使用時のプログラムの追加と削除での比較用データ */
			if($detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		
		
			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_detail where licence_kanrino = '".$detail['licence_kanrino']."' and newkbn <> 1 order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = $detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
				$detail['use_sosiki_cmp'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$detail['use_sosiki_cmp']);
			}
			/** 比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$_SESSION['input']['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $_SESSION['input']['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$_SESSION['input']['program_add_del'];
				if(count(@$_SESSION['input']['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $_SESSION['input']['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除での比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$_SESSION['input']['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $_SESSION['input']['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$_SESSION['input']['program_add_del_down'];
				if(count(@$_SESSION['input']['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $_SESSION['input']['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}

			$check_array = 	array(
						"kanri_sosiki_pkey",
						"licence_kanrino",
						"soft_name",
						"licence_keitai",
						"brand",
						"use_sosiki_cmp",
						"hard_kotei",
						"hard_kanrino",
						"upgrade",
						"up_licence_kanrino",
						"licence_no",
						"tyoutatu",
						"tokusitu_useproposal",
						"useproposal_youken",
						"hokan_baitai",
						"hokan_basyo",
						"program_add_del",
						"program_add_del_down",
						"bikou",
						"tyoutatu_date",
						"haiki_date",
						"edition",
						"price",
						"use_limit_date",
						"memo"
					);
			foreach($check_array as $val){
				@$_SESSION['input']['$val'] = ereg_replace("\r","",@$_SESSION['input']['$val']);
				if(@$detail[$val] != @$_SESSION['input'][$val]){
					$old[$val] = @$detail[$val];
					if(@$_SESSION['input'][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $_SESSION['input'][$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
			
		}else{
			$new = $_SESSION['input'];
		}
		
		
		
		#install_su_name
		$new['install_su_name'] = "";
		if(@$detail['install_su_name'] != @$_SESSION['input']['install_su_name'] and !is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = $_SESSION['input']['install_su_name'];
		}elseif(@$detail['install_su_name'] != @$_SESSION['input']['install_su_name'] and is_array(@$new['use_sosiki_cmp']) and !is_array(@$old['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$_SESSION['input']['install_su_name'] and is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$_SESSION['input']['install_su_name'] and @$new['use_sosiki_cmp'] == " "){
			$new['install_su_name'] = $_SESSION['input']['install_su_name'];
		}
		if(@$old['use_sosiki_cmp'] == ""){
			$old['install_su_name'] = @$detail['install_su_name'];
		}

		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',$_SESSION['input']);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		/** set template */
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('license/print_sinsei.html'));
		$this->tpl->outputHtml('print_sinsei.html');
	}
	
	/**
	 * 申請書印刷
	 */
	function app_print_r(){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_APP);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".addslashes(@$_REQUEST['code']), "detail");
		/** 詳細ﾃﾞｰﾀ */
		$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_history['shinsei_no'], "list");
		if(count($licence_list) > 0){
			for($i=0; $i<count($licence_list); $i++){
				if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
					$detail = $licence_list[$i];
				}
			}
			if(!is_array(@$detail)){
				$detail = $licence_list[0];
			}
		}else{
			$detail = $licence_list[0];
		}
		
		//組織認証
		$this->sosiki_auth(array($detail['sinseisyozoku']));
		
		if(count($detail) > 0){
			$history    = $detail;
			/** プログラムの追加と削除の比較用データ */
			if($history['program_add_del']){
				$history['program_add_del'] = ereg_replace("\r","",$history['program_add_del']);
				$history['program_add_del'] = explode("\n",$history['program_add_del']);
			}else{
				$history['program_add_del'] = array();
			}
			/** ダウングレード使用時のプログラムの追加と削除の比較用データ */
			if($history['program_add_del_down']){
				$history['program_add_del_down'] = ereg_replace("\r","",$history['program_add_del_down']);
				$history['program_add_del_down'] = explode("\n",$history['program_add_del_down']);
			}else{
				$history['program_add_del_down'] = array();
			}
			#アップグレード元ライセンス管理番号
			if(@$history['up_licence_kanrino']){
				$history['up_licence_kanrino'] = explode(",",$history['up_licence_kanrino']);
			}else{
				$history['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$history['hold_qty'] == 99999999){
				$history['install_su_name'] = "無制限";
			}else{
				$history['install_su_name'] = $history['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$history['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$history['install_su_name']);
				}
				$history['use_sosiki_cmp'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['sosiki_pkey'],$history['use_sosiki_cmp']);
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		$item['syoninsya'] = _DEFAULT_SYONINSYA;
		
		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date']       = $detail['sinsei_date'];
		$item['sinseisya']         = $detail['sinseisya'];
		$item['email_ad']          = $detail['email_ad'];
		$item['licencehistory_pkey']  = $detail['licencehistory_pkey'];
		$item['version']           = $detail['version'];
		$user_referer              = _USER_REFERER;

		if($history['licence_pkey'] != ""){
			$version = $history['version']-1;
			$detail_his = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where licence_pkey = ".$history['licence_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail_his['shinsei_no'], "list");
			if(count($licence_list) > 0){
				for($i=0; $i<count($licence_list); $i++){
					if($licence_list[$i]['kanri_sosiki_pkey'] == $licence_list[$i]['sosiki_pkey']){
						$detail = $licence_list[$i];
					}
				}
				if(!is_array(@$detail)){
					$detail = $licence_list[0];
				}
			}else{
				$detail = $licence_list[0];
			}
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}		
			/** ダウングレード使用時のプログラムの追加と削除の比較用データ */
			if(@$detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}		
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		

			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".@$detail['shinsei_no']."' order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = @$detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
				$detail['use_sosiki_cmp'] = $this->kanri_check($detail_his['kanri_sosiki_pkey'],$detail_his['sosiki_pkey'],$detail['use_sosiki_cmp']);
			}

			/** 比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$history['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $history['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$history['program_add_del'];
				if(count(@$history['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $history['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除の比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$history['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $history['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$history['program_add_del_down'];
				if(count(@$history['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $history['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}

			/** 比較 */
			$check_array = 	array(
						"kanri_sosiki_pkey",
						"licence_kanrino",
						"soft_name",
						"licence_keitai",
						"brand",
						"use_sosiki_cmp",
						"hard_kotei",
						"hard_kanrino",
						"upgrade",
						"up_licence_kanrino",
						"licence_no",
						"tyoutatu",
						"tokusitu_useproposal",
						"useproposal_youken",
						"hokan_baitai",
						"hokan_basyo",
						"program_add_del",
						"program_add_del_down",
						"bikou",
						"tyoutatu_date",
						"haiki_date",
						"edition",
						"price",
						"use_limit_date",
						"memo"
					);
			foreach($check_array as $val){
				@$history['$val'] = ereg_replace("\r","",@$history['$val']);
				if(@$detail[$val] != $history[$val]){
					$old[$val] = @$detail[$val];
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}
		
		
		
		#install_su_name
		$new['install_su_name'] = "";
		if(@$detail['install_su_name'] != @$history['install_su_name'] and !is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = $_SESSION['input']['install_su_name'];
		}elseif(@$detail['install_su_name'] != @$history['install_su_name'] and is_array(@$new['use_sosiki_cmp']) and !is_array(@$old['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$history['install_su_name'] and is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$history['install_su_name'] and @$new['use_sosiki_cmp'] == " "){
			$new['install_su_name'] = $history['install_su_name'];
		}
		if(@$old['use_sosiki_cmp'] == ""){
			$old['install_su_name'] = @$detail['install_su_name'];
		}


		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',@$item);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		/** set template */
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('license/print_sinsei.html'));
		$this->tpl->outputHtml('print_sinsei.html');
	}
	
	/**
	 * ライセンス台帳一覧
	 */
	function license_search(){
		parse_str($_POST['params'],$request);
		$_REQUEST['licence_array'] = @$request['licence_pkey2'];
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SELECT);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

//		if(@$_REQUEST['search_cd1'] == ""){
//			$_REQUEST['search_sosiki'] = "on";
//		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "licence_pkey";
		}
		if(@$_REQUEST['sort_asc'] == "DESC"){
			$_REQUEST['sort_asc'] = "DESC";
		}else{
			$_REQUEST['sort_asc'] = "ASC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "001";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$request[$col]){
				    case "001":
					$s_col = "licence_kanrino";
				        break;
				    case "002":
					$s_col = "soft_name";
				        break;
				    case "003":
					$s_col = "licence_keitai_name";
				        break;
				    case "004":
					$s_col = "hard_kanrino";
				        break;
				    case "005":
					$s_col = "up_licence_kanrino";
				        break;
				    case "006":
					$s_col = "install_su";
				        break;
				    case "007":
					$s_col = "install_qty";
				        break;
				    case "008":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "009":
					$s_col = "licencelist_pkey";
				        break;
				    case "010":
					$s_col = "edition";
				        break;
				    case "011":
					$s_col = "hard_kotei_name";
				        break;
				    case "012":
					$s_col = "upgrade_name";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}

			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$request[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}
		
		$where .= ") and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";


		if(count(@$_REQUEST['licence_array']) > 0){
			$licence_array = @$_REQUEST['licence_array'];
		}else{
			$licence_array = array();
		}
		$this->tpl->assignHtml('licence_array',$licence_array);

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licence_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licence_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00025"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->outputHtml('license/license_search.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * ハードウェア台帳一覧
	 */
	function license_search_reload(){
		parse_str($_POST['params'],$request);
		$_REQUEST['page'] = @$request['page'];
		
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SELECT);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		if(@$request['search_cd1'] == ""){
			$request['search_sosiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$request['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($request,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($request,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$request['sort_name'] == ""){
			$request['sort_name'] = "licence_pkey";
		}
		if(@$request['sort_asc'] == "DESC"){
			$request['sort_asc'] = "DESC";
		}else{
			$request['sort_asc'] = "ASC";
		}
		$this->sort = $request['sort_name'];
		$this->asc = $request['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** デフォルト値設定 */
		if(@$request['search_col1'] == ""){
			$request['search_col1'] = "001";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$request[$val] = trim(@$request[$val]);
			if(@$request[$val] != "" and @$request[$col] != ""){
				$search_val_base = @$request[$val];
				switch (@$request[$col]){
				    case "001":
					$s_col = "licence_kanrino";
				        break;
				    case "002":
					$s_col = "soft_name";
				        break;
				    case "003":
					$s_col = "licence_keitai_name";
				        break;
				    case "004":
					$s_col = "hard_kanrino";
				        break;
				    case "005":
					$s_col = "up_licence_kanrino";
				        break;
				    case "006":
					$s_col = "install_su";
				        break;
				    case "007":
					$s_col = "install_qty";
				        break;
				    case "008":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$request[$val]);
				        break;
				    case "009":
					$s_col = "licencelist_pkey";
				        break;
				    case "010":
					$s_col = "edition";
				        break;
				    case "011":
					$s_col = "hard_kotei_name";
				        break;
				    case "012":
					$s_col = "upgrade_name";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$request[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$request[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$request[$col]);
			$this->tpl->assignHtml($val,@$request[$val]);
			$this->tpl->assignHtml($comp,@$request[$comp]);
			$this->tpl->assignHtml($cd,@$request[$cd]);
		}
		
		$where .= ") and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$request['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";


		if(count(@$request['licence_pkey']) > 0){
			$licence_array = @$request['licence_pkey'];
		}else{
			$licence_array = array();
		}
		$this->tpl->assignHtml('licence_array',$licence_array);

		if(count(@$request['fix_name']) > 0){
			$fix_name = @$request['fix_name'];
		}else{
			$fix_name = array();
		}
		$this->tpl->assignHtml('fix_name',$fix_name);

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licence_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licence_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00025"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$html = $this->tpl->fetchHtml('license/license_search_reroad.html');
		print $html;
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * ハードウェア台帳一覧
	 */
	function license_search_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		parse_str(@$_POST['params'],$request);
		parse_str(@$_POST['input_params'],$input_request);
		
		$fix = @$request['fix_name'];
		if(count(@$fix) > 0 and count(@$request['licence_pkey']) > 0){
			$licence_pkey = array_merge($fix,$request['licence_pkey']);
		}elseif(count(@$fix) <= 0 and count(@$request['licence_pkey']) > 0){
			$licence_pkey = $request['licence_pkey'];
		}elseif(count(@$fix) > 0 and count(@$request['licence_pkey']) <= 0){
			$licence_pkey = $fix;
		}else{
			$licence_pkey = array();
		}
		$json = new Services_JSON();
		$pkey = $json->encode($licence_pkey);
		
		if(count($licence_pkey) > 0){
			$in_key = implode(",",$licence_pkey);
			$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_pkey", "list");
		}else{
			$licence = array();
		}

		$this->tpl->assignHtml('licence',$licence);
		$html = $this->tpl->fetchHtml('license/license_search_list.html');
		$license_list = '{"list":"'.ereg_replace("\n","bbbbrrrr",addslashes($html)).'","pkey":'.$pkey.'}';
		print $license_list;
	}

	/**
	 * ライセンス一覧
	 */
	function license_select(){
		parse_str($_POST['params'],$request);
		$_REQUEST['licence_array'] = @$request['licence_no'];
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SELECT);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

//		if(@$_REQUEST['search_cd1'] == ""){
//			$_REQUEST['search_sosiki'] = "on";
//		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "licence_pkey";
		}
		if(@$_REQUEST['sort_asc'] == "DESC"){
			$_REQUEST['sort_asc'] = "DESC";
		}else{
			$_REQUEST['sort_asc'] = "ASC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "001";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$request[$col]){
				    case "001":
					$s_col = "licence_kanrino";
				        break;
				    case "002":
					$s_col = "soft_name";
				        break;
				    case "003":
					$s_col = "licence_keitai_name";
				        break;
				    case "004":
					$s_col = "hard_kanrino";
				        break;
				    case "005":
					$s_col = "up_licence_kanrino";
				        break;
				    case "006":
					$s_col = "install_su";
				        break;
				    case "007":
					$s_col = "install_qty";
				        break;
				    case "008":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "009":
					$s_col = "licencelist_pkey";
				        break;
				    case "010":
					$s_col = "edition";
				        break;
				    case "011":
					$s_col = "hard_kotei_name";
				        break;
				    case "012":
					$s_col = "upgrade_name";
				        break;
				    case "013":
					$s_col = "sosiki_fullname";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}

			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$request[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}
		
		$where .= ") and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";


		$licence_array = array();
		if(count(@$_REQUEST['licence_array']) > 0){
			foreach($_REQUEST['licence_array'] as $value){
				$licence_pkey_name = "licence_pkey".$value;
				$licence_array[] = @$request[$licence_pkey_name];
			}
		}
		$this->tpl->assignHtml('licence_array',$licence_array);

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licence_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licence_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00025"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->outputHtml('license/licence_select.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * ライセンス一覧
	 */
	function license_select_reload(){
		parse_str($_POST['params'],$request);
		$_REQUEST['page'] = @$request['page'];
		
		$this->tpl->assignHtml('title', _TITLE_LICENSE_SELECT);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		if(@$request['search_cd1'] == ""){
			$request['search_sosiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$request['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($request,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($request,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$request['sort_name'] == ""){
			$request['sort_name'] = "licence_pkey";
		}
		if(@$request['sort_asc'] == "DESC"){
			$request['sort_asc'] = "DESC";
		}else{
			$request['sort_asc'] = "ASC";
		}
		$this->sort = $request['sort_name'];
		$this->asc = $request['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** デフォルト値設定 */
		if(@$request['search_col1'] == ""){
			$request['search_col1'] = "001";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$request[$val] = trim(@$request[$val]);
			if(@$request[$val] != "" and @$request[$col] != ""){
				$search_val_base = @$request[$val];
				switch (@$request[$col]){
				    case "001":
					$s_col = "licence_kanrino";
				        break;
				    case "002":
					$s_col = "soft_name";
				        break;
				    case "003":
					$s_col = "licence_keitai_name";
				        break;
				    case "004":
					$s_col = "hard_kanrino";
				        break;
				    case "005":
					$s_col = "up_licence_kanrino";
				        break;
				    case "006":
					$s_col = "install_su";
				        break;
				    case "007":
					$s_col = "install_qty";
				        break;
				    case "008":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$request[$val]);
				        break;
				    case "009":
					$s_col = "licencelist_pkey";
				        break;
				    case "010":
					$s_col = "edition";
				        break;
				    case "011":
					$s_col = "hard_kotei_name";
				        break;
				    case "012":
					$s_col = "upgrade_name";
				        break;
				    case "013":
					$s_col = "sosiki_fullname";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$request[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$request[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$request[$col]);
			$this->tpl->assignHtml($val,@$request[$val]);
			$this->tpl->assignHtml($comp,@$request[$comp]);
			$this->tpl->assignHtml($cd,@$request[$cd]);
		}
		
		$where .= ") and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$request['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";


		if(count(@$request['licence_pkey']) > 0){
			$licence_array = @$request['licence_pkey'];
		}else{
			$licence_array = array();
		}
		$this->tpl->assignHtml('licence_array',$licence_array);

		if(count(@$request['fix_name']) > 0){
			$fix_name = @$request['fix_name'];
		}else{
			$fix_name = array();
		}
		$this->tpl->assignHtml('fix_name',$fix_name);

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM licence_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM licence_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;

		/** set template */
		$this->tpl->assignHtml('license_col', select_code("00025"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$html = $this->tpl->fetchHtml('license/license_select_reroad.html');
		print $html;
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * ライセンス一覧
	 */
	function license_select_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		parse_str(@$_POST['params'],$request);
		parse_str(@$_POST['input_params'],$input_request);
		
		$fix = @$request['fix_name'];
		if(count(@$fix) > 0 and count(@$request['licence_pkey']) > 0){
			$licence_pkey = array_merge($fix,$request['licence_pkey']);
		}elseif(count(@$fix) <= 0 and count(@$request['licence_pkey']) > 0){
			$licence_pkey = $request['licence_pkey'];
		}elseif(count(@$fix) > 0 and count(@$request['licence_pkey']) <= 0){
			$licence_pkey = $fix;
		}else{
			$licence_pkey = array();
		}
		
		for($i=0; $i<count(@$input_request['licence_no']); $i++){
			$licence_pkey_name    = "licence_pkey".$input_request['licence_no'][$i];
			$soft_pkey_name       = "soft_pkey".$input_request['licence_no'][$i];
			$version_name         = "version".$input_request['licence_no'][$i];
			$bikou_name           = "bikou".$input_request['licence_no'][$i];
			$downgrade_name       = "downgrade".$input_request['licence_no'][$i];
			$tyoutatu_date_name   = "tyoutatu_date".$input_request['licence_no'][$i];
			$haiki_date_name      = "haiki_date".$input_request['licence_no'][$i];
			$memo_name            = "memo".$input_request['licence_no'][$i];
			
			$licence_input[$input_request[$licence_pkey_name]]["soft_pkey"]       = @$input_request[$soft_pkey_name];
			$licence_input[$input_request[$licence_pkey_name]]["version"]         = @$input_request[$version_name];
			$licence_input[$input_request[$licence_pkey_name]]['bikou']           = @$input_request[$bikou_name];
			$licence_input[$input_request[$licence_pkey_name]]['tyoutatu_date']   = @$input_request[$tyoutatu_date_name];
			$licence_input[$input_request[$licence_pkey_name]]['haiki_date']      = @$input_request[$haiki_date_name];
			$licence_input[$input_request[$licence_pkey_name]]['memo']            = @$input_request[$memo_name];
			$licence_input[$input_request[$licence_pkey_name]]['downgrade']       = @$input_request[$downgrade_name];
		}

		if(count(@$licence_pkey) > 0){
			$in_key = implode(",",$licence_pkey);
			$licence = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey in (".$in_key.") order by licence_kanrino", "list");
		}else{
			$licence = array();
		}
		if(count($licence) > 0){
			for($i=0; $i<count($licence); $i++){
				$licence[$i]['in_licence_pkey']		= @$licence[$i]['licence_pkey'];
				$licence[$i]['in_soft_pkey']		= @$licence_input[$licence[$i]['licence_pkey']]['soft_pkey'];
				$licence[$i]['in_version']		= @$licence_input[$licence[$i]['licence_pkey']]['version'];
				$licence[$i]['in_bikou']		= @$licence_input[$licence[$i]['licence_pkey']]['bikou'];
				$licence[$i]['in_tyoutatu_date']	= @$licence_input[$licence[$i]['licence_pkey']]['tyoutatu_date'];
				$licence[$i]['in_haiki_date']		= @$licence_input[$licence[$i]['licence_pkey']]['haiki_date'];
				$licence[$i]['in_memo']			= @$licence_input[$licence[$i]['licence_pkey']]['memo'];
				$licence[$i]['in_downgrade']		= @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				if(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'] != '' and !is_null(@$licence_input[$licence[$i]['licence_pkey']]['downgrade'])){
					$licence[$i]['in_downgrade']       = @$licence_input[$licence[$i]['licence_pkey']]['downgrade'];
				}else{
					$licence[$i]['in_downgrade']       = "d002";
				}
			}
		}

		$this->tpl->assignHtml('licence',$licence);
		$this->tpl->assignHtml('license_col', select_code("00025"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$html = $this->tpl->fetchHtml('license/license_list.html');
		$license_list = '{"list":"'.ereg_replace("\n","bbbbrrrr",addslashes($html)).'"}';
		print $license_list;
	}
	
	
	/**
	 * 管理権限チェック
	 */
	function kanri_check($kanri_sosiki_pkey,$sosiki_pkey,$use_sosiki=array()){
		if($kanri_sosiki_pkey == $sosiki_pkey){
			return $use_sosiki;
		}else{
			for($i=0; $i<count($use_sosiki); $i++){
				if($use_sosiki[$i]['sosiki_pkey'] == $sosiki_pkey){
					return array($use_sosiki[$i]);
				}
			}
			return array();
		}
	}
	
	/**
	 * 使用権限のみチェック
	 */
	function use_only_check($kanri_sosiki_pkey,$sosiki_pkey){
		if($kanri_sosiki_pkey != $sosiki_pkey){
			$this->use_only = true;
		}
	}
	
	/**
	 * 設置場所絞込み
	 */
	function location_search(){
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		$q = strtolower($_REQUEST["q"]);
		if (!$q) return;
		
		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		$where = " where sosiki_pkey in (".implode(",",$child_array).")";
		
		$list = $this->db->dbSelect("select DISTINCT ON (hokan_basyo) hokan_basyo from licence_detail".$where." order by hokan_basyo", "list");
		$items = array();
		if(count($list) > 0){
			for($i=0; $i<count($list); $i++){
				$items[] = $list[$i]['hokan_basyo'];
			}
		}

		foreach ($items as $value) {
			if (strpos(strtolower($value), $q) !== false) {
				echo "$value\n";
			}
		}

		
	}
	
	/**
	 * 使用所属追加
	 */
	function use_sosiki_add(){
		$this->tpl->assignHtml('title', "使用所属");
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		/** set template */
		$this->tpl->assignHtml('sosiki_pkey', $_POST['sosiki_pkey']);
		$this->tpl->assignHtml('install_su', $_POST['install_su']);
		$this->tpl->assignHtml('hold_qty_tmp', $_POST['hold_qty_tmp']);
		$this->tpl->assignHtml('use_sosiki_qty', $_POST['use_sosiki_qty']);
		$this->tpl->assignHtml('kanri_sosiki_pkey', $_POST['kanri_sosiki_pkey']);
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->outputHtml('license/input_use_sosiki.html');
	}
	
	/**
	 * 使用所属追加完了
	 */
	function use_sosiki_add_done(){
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		parse_str($_POST['params'],$request);
		$sosiki_detail = $this->db->dbSelect("SELECT * FROM sosiki where sosiki_pkey = ".$request['new_sosiki_pkey'], "detail");
		if(@$sosiki_detail['syozoku_fullname'] == ""){
			$sosiki_detail['syozoku_fullname'] = "所属なし";
			$request['new_install_su'] = "0";
		}
		if(@$request['new_install_su_type'] == "mugen"){
			$request['new_install_su'] = "無制限";
		}else{
			$request['new_install_su'] = ereg_replace("[^0-9]","",mb_convert_kana(@$request['new_install_su'], 'rnsKHV'));
		}
		if(@$request['new_install_su'] == ""){
			$request['new_install_su'] = "0";
		}

		$detail['use_sosiki_qty']	= $request['new_use_sosiki_qty'];
		$detail['sosiki_fullname']	= $sosiki_detail['syozoku_fullname'];
		$detail['install_su']		= $request['new_install_su'];
		$detail['sosiki_pkey']		= $request['new_sosiki_pkey'];

		$json = new Services_JSON();
		$use_sosiki = $json->encode($detail);
		
		print $use_sosiki;
	}

	/**
	 * 使用所属変更
	 */
	function use_sosiki_change(){
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		$kanri_sosiki_detail = $this->db->dbSelect("SELECT * FROM sosiki where sosiki_pkey = ".$_POST['kanri_sosiki_pkey'], "detail");

		if($_POST['licence_pkey'] != ""){
			$base_licence = $this->db->dbSelect("SELECT * FROM licence where licence_pkey = ".$_POST['licence_pkey'], "detail");

			$where_list =" where licence_kanrino='".$base_licence['licence_kanrino']."' and sosiki_pkey != ".$base_licence['kanri_sosiki_pkey']." and sosiki_pkey = ".$kanri_sosiki_detail['sosiki_pkey']." and newkbn <> 1";
			$licence_count = $this->db->dbSelect("select * from licence_detail".$where_list, "list");
			
			if(count($licence_count) > 0){
				$old_sosiki = $this->db->dbSelect("SELECT * FROM sosiki where sosiki_pkey = ".$base_licence['kanri_sosiki_pkey'], "detail");
				$detail['sosiki_pkey_self']	= $old_sosiki['sosiki_pkey'];
				$detail['sosiki_name_self']	= $old_sosiki['syozoku_fullname'];
			}else{
				$detail['sosiki_pkey_self']	= $kanri_sosiki_detail['sosiki_pkey'];
				$detail['sosiki_name_self']	= $kanri_sosiki_detail['syozoku_fullname'];
			}
			
		}else{
			$detail['sosiki_pkey_self']	= $kanri_sosiki_detail['sosiki_pkey'];
			$detail['sosiki_name_self']	= $kanri_sosiki_detail['syozoku_fullname'];
		}

		$json = new Services_JSON();
		$use_sosiki = $json->encode($detail);
		
		print $use_sosiki;
	}

}

?>