<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2008/12/12
 */

/** ﾁｪｯｸｸﾗｽ */
class ValidateItem {

	/**
	 * ｴﾗｰ
	 * @var boolean
	 */
	var $error_flag = false;

	/**
	 * ｴﾗｰﾒｯｾｰｼﾞ
	 * @var array
	 */
	var $error_msg = array();

	/**
	 * エラー表示
	 */
	 function checkErrorCode($error_code,$str=array()){
		$this->error_msg[] =  vsprintf(Error::ErrorView($error_code),$str);
		$this->error_flag = true;
	 }

	/**
	 * テキストエラー表示
	 */
	 function checkErrorText($text){
		$this->error_msg[] =  "$text";
		$this->error_flag = true;
	 }

	/**
	 * 必須項目
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemNon($require){
		foreach($require as $key => $val){
			if(!@$key || @$key == ""){
				$this->error_msg[] = $val."は".Error::ErrorView("0007");
				$this->error_flag = true;
			}
		}
	}

	/**
	 * 必須選択
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemSelect($require){
		foreach($require as $key => $val){
			if(!@$key || @$key == ""){
				$this->error_msg[] = $val."は".Error::ErrorView("0013");
				$this->error_flag = true;
			}
		}
	}

	/**
	 * Eﾒｰﾙ
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemEmail($require){
		foreach($require as $key => $val){
			if(@$key <> ""){
				if(!ereg("([0-9,a-z,A-Z,\-])+@([0-9,a-z,A-Z,\-])+\.([0-9,a-z,A-Z,\-])", $key)){
					$this->error_msg[] = $val."の".Error::ErrorView("0006");
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * 英数のみ
	 */
	function checkAlphaNumeric($require){
		foreach($require as $key => $val){
			if(@$key  <> ""){
				if(!ereg("^[a-zA-Z0-9]*$", $key)){
					$this->error_msg[] = $val."は".Error::ErrorView("0005");
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * 英数のみ
	 */
	function checkNumeric($require){
		foreach($require as $key => $val){
			if(@$key  <> ""){
				if(!ereg("^[0-9]*$", $key)){
					$this->error_msg[] = $val."は".Error::ErrorView("0017");
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * 日付01 (形式:2009/01/12)
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemDate01($require){
		foreach($require as $key => $val){
			if(@$key <> ""){
				if (!ereg ("^([12][0-9]{3})/([0-9]{2})/([0-9]{2})$", @$key)) {
					$this->error_msg[] = $val."は".Error::ErrorView("0010");
					$this->error_flag = true;
				}else{
					$date = explode("/", @$key);
					$this->checkItemDateValid($date[0], $date[1], $date[2], $val);
				}
			}
		}
	}
	
	/**
	 * 日付02 (形式:2009/01/12 23:59)
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemDateTime($require){
		foreach($require as $key => $val){
			if(@$key <> ""){
				if (!ereg ("^([12][0-9]{3})/([0-9]{2})/([0-9]{2}) ([0-9]{2}):([0-9]{2})$", @$key)) {
					$this->error_msg[] = $val."は".Error::ErrorView("0022");
					$this->error_flag = true;
				}else{
					$datetime = explode(" ", @$key);
					$date = explode("/", @$datetime[0]);
					$this->checkItemDateValid($date[0], $date[1], $date[2], $val);
				}
			}
		}
	}

	/**
	 * 日付 有効／無効
	 * @param  int      $y 年
	 *         int      $m 月
	 *         int      $d 日
	 *         string   $item_name
	 * @return boolean  $error
	 *         string   $msg
	 */
	 function checkItemDateValid($y, $m, $d, $item_name){
	 	if (checkdate($m, $d, $y) == false) {
			$this->error_msg[] = $item_name."は".Error::ErrorView("0010");
			$this->error_flag = true;
		}
	 }


	/**
	 * int 型
	 * @param  array    $require
	 *         boolean  $zero  true:0OK,false:0NG 
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemInt($require, $zero){
		foreach($require as $key => $val){
			if(@$val <> ""){
				if(!ereg ("^([0-9]+)$", $val)){
					$this->error_msg[] .= sprintf(_ERR_ITEM_INT_01, $key);
					$this->error_flag = true;
				}else{
					if(@$val > 2147483647){
						$this->error_msg[] .= sprintf(_ERR_ITEM_INT_02, $key);
						$this->error_flag = true;
					}else{
						if($zero == false){
							if(ereg ("^([0]+)", $val)){
								$this->error_msg[] .= sprintf(_ERR_ITEM_INT_03, $key);
								$this->error_flag = true;
							}
						}
					}
				}
			}
		}
	}

	/**
	 * 文字列の長さ
	 * @param  array    $require = array("item_name:len"=>"param")
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemStrlen($require){
		foreach($require as $key => $val){
			if(@$val <> ""){
				$item = explode(":", $key);
				if(strlen($val) > $item['1']){
					$this->error_msg[] .= sprintf(_ERR_ITEM_STRLEN, $item['0'], $item['1']);
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * 時間01 (形式:09:30)
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemTime01($require){
		foreach($require as $key => $val){
			if(@$val <> ""){
				if (!ereg ("^([0-9]{2}):([0-9]{2})$", @$val)) {
					$this->error_msg[] .= sprintf(_ERR_ITEM_TIME_01, $key);
					$this->error_flag = true;
				}else{
					$time = explode(":", $val);
					$hour = $time[0];
					$min  = $time[1];
					if($hour > '23' || $min > '59'){
						$this->error_msg[] .= sprintf(_ERR_ITEM_TIME_02, $key);
						$this->error_flag = true;	
					}
				}
			}
		}
	}
}
?>