<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2008/12/12
 */

class Sendmail {
	
	function Sendmail(){
		require_once('Mail.php');
		require_once("Mail/mime.php");

		// SMTPサーバ
		$this->mail_options = array(
			'host'      => _SMTP_HOST, // ホスト名
			'port'      => _SMTP_PORT, // ポート番号
			'auth'      => _SMTP_AUTH, // 認証必要？
			'username'  => _SMTP_USER, // ユーザー名
			'password'  => _SMTP_PASS, // パスワード
		);

		$this->mail_object =& Mail::factory(_SMTP_PROTOCOL,$this->mail_options);  // SMTP送信準備
	}
	
	function email($email, $myname, $subject, $body){
		$email = trim($email);
		mb_language('ja');
		mb_internal_encoding('UTF-8');

		$headers['Subject'] = mb_encode_mimeheader($subject);
		$headers['From']    = $myname;
		$headers['To']      = $email;

		$body = mb_convert_encoding($body, "JIS", _CHARACTER_SET);

		//メールの送信
		$ret = $this->mail_object->send($email, $headers, $body);

		//エラー
		$filename = _LOG_PATH."/mail".date("Ymd").".log";
		if(!file_exists($filename)){
			touch($filename);
			chmod($filename,0666);
			chown($filename,"apache");
			chgrp($filename,"apache");
		}
		$fp = fopen($filename, "a");
		if(PEAR::isError($ret)){
			fwrite($fp, date("Y-m-d H:i:s")." ".$ret->getMessage()." ".$email." ".$subject."\n");
		}else{
			fwrite($fp, date("Y-m-d H:i:s")." OK ".$email." ".$subject."\n");
		}
		fclose($fp);
	}
}
?>
