<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2008/12/12
 */

/** ﾅﾋﾞｹﾞｰｼｮﾝｸﾗｽ */
class Navigation {

	/**
	 * ﾅﾋﾞｹﾞｰｼｮﾝ
	 * @var string
	 */
	var $navi;

	/**
	 * 件数 ( start - end)
	 * @var int
	 */
	var $count_start;
	var $count_end;

	/**
	 * 一覧ﾃﾞｰﾀ
	 * @var int
	 */
	var $list_start;
	#var $list_end;



	/**
	 * 携帯用 ﾍﾟｰｼﾞﾅﾋﾞｹﾞｰｼｮﾝ
	 * @param  int    $records ﾃﾞｰﾀﾚｺｰﾄﾞ数
	 *         int    $count   表示する行数
	 *         string $url
	 * @return string $navi    < 前へ |  次へ >
	 */

	function mobileListNavi($records, $count, $url){

		$page_num = ceil($records / $count)  ; //合計ページ数
		
		if(@$_REQUEST['page'] == "" ){
			$now_page = 1;
		}else{
			$now_page = @$_REQUEST['page'];
		}
		
		$this->list_start = ($now_page - 1) * $count;
		
		//次へ
		if($now_page < $page_num){
			$next_page = $now_page + 1;
			$next = "<a href=\"".$url."page=".$next_page."\" accesskey=\"#\">(#)"._NAVI_NEXT."</a>";
		}
		
		//前へ
		if($now_page > 1){
			$back_page = $now_page - 1;
			$back = "<a href=\"".$url."page=".$back_page."\" accesskey=\"*\">"._NAVI_BACK."(*)</a>";
		}
		
		if( @$next || @$back) {
			$this->navi = @$back." | ".@$next;
		}
	}


	/**
	 * ﾍﾟｰｼﾞﾅﾋﾞｹﾞｰｼｮﾝ
	 * @param  int    $records ﾃﾞｰﾀﾚｺｰﾄﾞ数
	 *         int    $count   表示する行数
	 *         string $url
	 * @return string $navi    << 先頭 < 前へ 12345678910 次へ > 最後 >>
	 */

	function pageNavi($records, $count, $url, $param){

		$view = "";
		$start = "";
		$back = "";
		$next = "";
		$end = "";
	
		/** リクエスト */
		$where = "&amp;".$param;
		/** 数字ﾁｪｯｸ */
		if(is_numeric(@$_REQUEST['page']) == false){
			@$_REQUEST['page'] = "";
		}
		/** 合計ﾍﾟｰｼﾞ数 */
		$total_page = ceil($records / $count);

		if(@$_REQUEST['page'] == "" ){
			$now_page = 1;
		}else{
			$now_page = @$_REQUEST['page'];
			
			if( @$_REQUEST['page'] > $total_page){
				$now_page = 1;
			}else{
				$now_page = @$_REQUEST['page'];
			}
		}
	
		if($now_page < $total_page){
		/** 次へ */
			$next_page = $now_page + 1;
			#$next = "<span class=\"prev_next\"><a href=\"".$url."page=".$next_page.$where."\">"._NAVI_NEXT."</a></span>";
			$next = "<a href=\"".$url."page=".$next_page.$where."\">"._NAVI_NEXT."</a>";
		/** 最後へ */
			if(($total_page - $now_page) > '4'){
				if($total_page > '10'){
					#$end  = "<span class=\"prev_next\"><a href=\"".$url."page=".$total_page.$where."\">"._NAVI_LAST."</a></span>";
					$end  = "<span>|</span><a href=\"".$url."page=".$total_page.$where."\">"._NAVI_LAST."</a>";
				}
			}
		}
	
		if($now_page > 1){
		/** 前へ */
			$back_page = $now_page - 1;
			#$back = "<span class=\"prev_next\"><a href=\"".$url."page=".$back_page.$where."\">"._NAVI_BACK."</a></span>";
			$back = "<a href=\"".$url."page=".$back_page.$where."\">"._NAVI_BACK."</a>";
		/** 先頭へ */
			if($now_page > '6'){
				if($total_page > '10'){
					#$start = "<span class=\"prev_next\"><a href=\"".$url."page=1".$where."\">"._NAVI_FIRST."</a></span>";
					$start = "<a href=\"".$url."page=1".$where."\">"._NAVI_FIRST."</a><span>|</span>";
				}
			}
		}
		/** << 先頭 < 前へ 12345678910 次へ > 最後 >>  */
		if(@$_REQUEST['page'] == "" ){
			$i_start = 1;
			if($total_page < 10){
				$max = $total_page;
			}else{
				$max = 10;
			}
		}else{
			if($now_page > '6'){
				if(($total_page - $now_page)  > '3'){
					$i_start = $now_page - 5;
					$max = $i_start + 9;
				}else{
					if($total_page  > '9'){
						$i_start = $total_page - 9;
					}else{
						$i_start = 1;
					}
					
					$max = $total_page;
				}
			}else{
				$i_start = 1;
				if($total_page < 10){
					$max = $total_page;
				}else{
					$max = 10;
				}
			}
		}

		for ($i=$i_start; $i<=$max; $i++){
			if($i == $now_page){
				#$view .=  "<span class=\"now_page\">".$i."</span>";
				$view .=  $i."<span>|</span>";
			}else{
				#$view .=  "<span class=\"page\"><a href=\"".$url."page=".$i.$where."\">".$i."</a></span>";
				$view .=  "<a href=\"".$url."page=".$i.$where."\">".$i."</a><span>|</span>";
			}
		}
		
		/** 件数処理 */
		/** pageパラメータ処理 */
		if(@$_REQUEST['page'] == "" || is_numeric(@$_REQUEST['page']) == false){
			@$_REQUEST['page'] = 1;
		}else{
			$total_page = ceil($records / $count);
			if(@$_REQUEST['page'] > $total_page){
				@$_REQUEST['page'] = 1;
			}
		}
		$i_start = @$_REQUEST['page'] * $count - $count;
		$max     = @$_REQUEST['page'] * $count - 1;
		if($max >= $records){
			$max = $records - 1;
		}
		
		if($records == 0){
			$start_num = 0;
		}else{
			$start_num = $i_start + 1;
		}
		
		$end_num   = $max + 1;
		
		/** 件数 ( start - end) */
		$this->count_start = $start_num; /** 件数 始め */
		$this->count_end   = $end_num;   /** 件数 終り */

		/** 一覧ﾃﾞｰﾀ */
		$this->list_start  = $i_start;   /** 一覧 始め */
		#$this->list_end    = $max;      /** 一覧 終り */
		
		/** ﾅﾋﾞｹﾞｰｼｮﾝ */
		if($total_page > 1){
			#$this->navi = $start.$back.$view.$next.$end;
			$this->navi = $start.$back."<span>|</span>".$view.$next.$end;
		}
	}
	/**
	 * ﾍﾟｰｼﾞﾅﾋﾞｹﾞｰｼｮﾝ
	 * @param  int    $records ﾃﾞｰﾀﾚｺｰﾄﾞ数
	 *         int    $count   表示する行数
	 *         string $url
	 * @return string $navi    << 先頭 < 前へ 12345678910 次へ > 最後 >>
	 */

	function pageNaviPost($records, $count){

		$view = "";
		$start = "";
		$back = "";
		$next = "";
		$end = "";
	
		/** 数字ﾁｪｯｸ */
		if(is_numeric(@$_REQUEST['page']) == false){
			@$_REQUEST['page'] = "";
		}
		/** 合計ﾍﾟｰｼﾞ数 */
		$total_page = ceil($records / $count);

		if(@$_REQUEST['page'] == "" ){
			$now_page = 1;
		}else{
			$now_page = @$_REQUEST['page'];
			
			if( @$_REQUEST['page'] > $total_page){
				$now_page = 1;
			}else{
				$now_page = @$_REQUEST['page'];
			}
		}
	
		if($now_page < $total_page){
		/** 次へ */
			$next_page = $now_page + 1;
			$next = "<a href=\"javascript:void(0);\" onclick=\"navi_page(".$next_page.")\">"._NAVI_NEXT."</a>";
		/** 最後へ */
			if(($total_page - $now_page) > '4'){
				if($total_page > '10'){
					$end  = "<span>|</span><a href=\"javascript:void(0);\" onclick=\"navi_page(".$total_page.")\">"._NAVI_LAST."</a>";
				}
			}
		}
	
		if($now_page > 1){
		/** 前へ */
			$back_page = $now_page - 1;
			$back = "<a href=\"javascript:void(0);\" onclick=\"navi_page(".$back_page.")\">"._NAVI_BACK."</a>";
		/** 先頭へ */
			if($now_page > '6'){
				if($total_page > '10'){
					$start = "<a href=\"javascript:void(0);\" onclick=\"navi_page(1)\">"._NAVI_FIRST."</a><span>|</span>";
				}
			}
		}
		/** << 先頭 < 前へ 12345678910 次へ > 最後 >>  */
		if(@$_REQUEST['page'] == "" ){
			$i_start = 1;
			if($total_page < 10){
				$max = $total_page;
			}else{
				$max = 10;
			}
		}else{
			if($now_page > '6'){
				if(($total_page - $now_page)  > '3'){
					$i_start = $now_page - 5;
					$max = $i_start + 9;
				}else{
					if($total_page  > '9'){
						$i_start = $total_page - 9;
					}else{
						$i_start = 1;
					}
					
					$max = $total_page;
				}
			}else{
				$i_start = 1;
				if($total_page < 10){
					$max = $total_page;
				}else{
					$max = 10;
				}
			}
		}

		for ($i=$i_start; $i<=$max; $i++){
			if($i == $now_page){
				$view .=  $i."<span>|</span>";
			}else{
				$view .=  "<a href=\"javascript:void(0);\" onclick=\"navi_page(".$i.")\">".$i."</a><span>|</span>";
			}
		}
		
		/** 件数処理 */
		/** pageパラメータ処理 */
		if(@$_REQUEST['page'] == "" || is_numeric(@$_REQUEST['page']) == false){
			@$_REQUEST['page'] = 1;
		}else{
			$total_page = ceil($records / $count);
			if(@$_REQUEST['page'] > $total_page){
				@$_REQUEST['page'] = 1;
			}
		}
		$i_start = @$_REQUEST['page'] * $count - $count;
		$max     = @$_REQUEST['page'] * $count - 1;
		if($max >= $records){
			$max = $records - 1;
		}
		
		if($records == 0){
			$start_num = 0;
		}else{
			$start_num = $i_start + 1;
		}
		
		$end_num   = $max + 1;
		
		/** 件数 ( start - end) */
		$this->count_start = $start_num; /** 件数 始め */
		$this->count_end   = $end_num;   /** 件数 終り */

		/** 一覧ﾃﾞｰﾀ */
		$this->list_start  = $i_start;   /** 一覧 始め */
		#$this->list_end    = $max;      /** 一覧 終り */
		
		/** ﾅﾋﾞｹﾞｰｼｮﾝ */
		if($total_page > 1){
			#$this->navi = $start.$back.$view.$next.$end;
			$this->navi = $start.$back."<span>|</span>".$view.$next.$end;
		}
	}
}
?>