<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** 共通ﾓﾃﾞﾙｸﾗｽ */
class Model {

	/**
	 * ﾕｰｻﾞｰcode(登録者)
	 * @var int
	 */
	var $authuser_code;
	/**
	 * ﾕｰｻﾞｰname(登録者名)
	 * @var string
	 */
	var $authuser_name;
	/**
	 * ﾕｰｻﾞｰｱｶｳﾝﾄ(アカウント)
	 * @var string
	 */
	var $authuser_acount;
	/**
	 * ﾕｰｻﾞｰ権限
	 * @var array
	 */
	var $authuser_authority;
	/**
	 * ホスト名
	 * @var 
	 */
	var $host;

	/**
	 * ﾛｸﾞｲﾝ認証
	 */
	function login($page_name=""){
		/** ﾕｰｻﾞｰ認証 */
		$authuser = new AuthUser;
		$authuser->userLogin($this->db,$page_name);
		if($authuser->auth == false){
			$self_url = php_self_get();

			$this->tpl->assignHtml('login_user', @$_REQUEST['login_user']);
			$this->tpl->assignHtml('login_psw', @$_REQUEST['login_psw']);
			$this->tpl->assignHtml('self_url', $self_url);
			$this->tpl->assignHtml('error_msg', $authuser->error);
			$this->tpl->outputHtml('login.html');
			exit;
		}else{
			/** ﾕｰｻﾞｰcode(登録者) */
			$this->authuser_code = $authuser->code;
			$this->authuser_name = $authuser->name;
			$this->authuser_authority = $authuser->authority;
			$this->authuser_sosiki = $authuser->sosiki;
			
			$_SESSION['auth']['code']  = $this->authuser_code;
			$_SESSION['auth']['authority']  = $this->authuser_authority;
			/** ﾍﾟｰｼﾞｾｯﾄ */
			$this->tpl->assignHtml('login_name', $authuser->name);
			$this->tpl->assignHtml('authority', $authuser->authority);
		}
		$this->massage_list($this->db);
	}

	/**
	 * 組織認証
	 */
	function sosiki_auth($page_sosiki=array(),$range=true){
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if($range){
			$sosiki_array = array_merge($child_array,$full);
		}else{
			$sosiki_array = $child_array;
		}
		$sosiki_auth_flug = false;
		if(count($page_sosiki) > 0){
			for($i=0; $i<count($page_sosiki); $i++){
				if(in_array($page_sosiki[$i], $sosiki_array)){
					$sosiki_auth_flug = true;
				}
			}
		}

		if(!$sosiki_auth_flug){
			$this->tpl->assignHtml('login_user', @$_REQUEST['login_user']);
			$this->tpl->assignHtml('login_psw', @$_REQUEST['login_psw']);
			$this->tpl->assignHtml('self_url', "/sogo.php");
			$this->tpl->assignHtml('error_msg', Error::ErrorView("0009"));
			$this->tpl->outputHtml('login.html');
			exit;
		}
	}

	/**
	 * model メッセージ表示
	 */
	function massage_list($dbobj){
		$msg = array();
		$msg = $dbobj->dbSelect("select value from message where (start_date <= current_timestamp or start_date is null) and (end_date >= current_timestamp or end_date is null) and (end_time >= current_time or end_time is null) and (start_time <= current_time or start_time is null) order by sort", "list");
		$this->tpl->assignHtml('message', $msg);
	}

	/**
	 * model ｸﾗｽﾒｿｯﾄﾞ実行
	 * @param  string $action model名
	 */
	function runMethod($action,$param=array()){
		/** host_name */
		$host_array = explode(".",@$_SERVER["SERVER_NAME"]);
		$this->host = @$host_array[0];
		
		if(method_exists($this,$action)){
			if(count($param) >= 1 ){
				$this->$action($param);
			}else{
				$this->$action();
			}
		}else{
			header("Location: "._HTTP_URL);
		}
	}

	/**
	 * template
	 * @var  object
	 */
	var $tpl;

	/**
	 * ﾃﾝﾌﾟﾚｰﾄ ｵﾌﾞﾞｼﾞｪｸﾄ
	 * @return object $tpl
	 */
	function makeTplObject(){
		$this->tpl = new Template();
	}

	/**
	 * db
	 * @var object
	 */
	var $db;

	/**
	 * db ｵﾌﾞﾞｼﾞｪｸﾄ
	 */
	function makeDbObject(){
		$this->db = new DbControll();
		
	}

	/**
	 * Navigation
	 * @var object
	 */
	var $nv;

	/**
	 * navi ｵﾌﾞﾞｼﾞｪｸﾄ
	 */
	function makeNvObject(){
		$this->nv = new Navigation();
		
	}

	/**
	 * db ｼｽﾃﾑｾｯﾃｨﾝｸﾞ 取得
	 * @return 定数
	 */
	function getDbSystemSetting(){
		$site_info = $this->db->dbSelect("select * from control", "list");
		if($this->db->error){
			$this->tpl->assignHtml('error_msg', $this->db->error);
		}else{
			foreach($site_info as $val){
				define("_".strtoupper($val['control_id']), $val['settei']);
			}
		}
	}
	
	/**
	 * バリテーション
	 */
	function validators($modile=false){
		if(count($_REQUEST) >0 ){
			CharConvert::charConvertForm(array_keys($_REQUEST));
		}
	}

}
?>