<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2008/12/12
 */

class Mobile{

	/**
	 * UserAgentからキャリアを返す
	 * @param  string @$_SERVER['HTTP_USER_AGENT'] 
	 * @return string  docomo, softbank, au, other, pc
	 */
	function checkUa($agent){
		if(strpos($agent,"DoCoMo") !== FALSE){
			return('docomo');
		}elseif(strpos($agent,"SoftBank") !== FALSE || strpos($agent,"Vodafone") !== FALSE || strpos($agent,"J-PHONE") !== FALSE || strpos($agent,"MOT-") !== FALSE){
			return('softbank');
		}elseif(strpos($agent,"KDDI-") !== FALSE || strpos($agent,"UP.Browser/") !== FALSE){
			return('au');
		}elseif(strpos($agent,"L-MODE") !== FALSE || strpos($agent,"Nintendo Wii;") !== FALSE || strpos($agent,"PlayStation Portable") !== FALSE || strpos($agent,"EGBROWSER") !== FALSE || strpos($agent,"AveFront") !== FALSE || strpos($agent,"PLAYSTATION 3;") !== FALSE || strpos($agent,"ASTEL") !== FALSE || strpos($agent,"PDXGW") !== FALSE || strpos($agent,"WILLCOM") !== FALSE || strpos($agent,"DDIPOCKET") !== FALSE){
			return('other');
		}else{
			return('pc');
		}
	}

	function getSub($env){
		$ua = $_SERVER['HTTP_USER_AGENT'];
		if($env === 'docomo'){
			if(preg_match("/ser([a-zA-Z0-9]+)/",$ua, $dprg)){
				if(strlen($dprg[1]) === 11){
					$ser = $dprg[1];
				}elseif(strlen($dprg[1]) === 15){
					$ser = $dprg[1];
					if(preg_match("/icc([a-zA-Z0-9]+)/",$ua, $dpeg)){
						if(strlen($dpeg[1]) === 20){
							$icc = $dpeg[1];
						}
					}
				}
			}
		}elseif($env === 'softbank'){
			if(preg_match("/SN([a-zA-Z0-9]+)/",$ua,$vprg)){
				$srn = $vprg[1];
			}
		}elseif($env === 'au'){
			$ezn = $_SERVER['HTTP_X_UP_SUBNO'];
		}
		return array($ser,$icc,$srn,$ezn);
	}
}
?>
