<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2008/12/12
 */

/** ﾌｫｰﾑｸﾗｽ */
class MakeFrom {

	/**
	 * ﾗｼﾞｵﾎﾞﾀﾝ
	 * @param  array  $array 
	 *         int    $code   checked
	 *         string $name   変数名
	 *         string $view   表示 br,space
	 * @return string  $form 
	 */
	function makeRadioButton($array, $code, $name, $view="space"){
		$form = "";
		/** 表示 */
		if($view == "br"){
			$button_view = "<br />";
		}else{
			$button_view = "&nbsp;&nbsp;&nbsp;";
		}
		while( list($key, $value) = each($array)){
			if ($code == ""){
				$form .= "<input type=\"radio\" name=\"".$name."\" value=\"".$key."\" />".htmlspecialchars($value).$button_view;
			}else{
				if ($code == $key){
					$form .= "<input type=\"radio\" name=\"".$name."\" value=\"".$key."\" checked=\"checked\" />".htmlspecialchars($value).$button_view;
				}else{
					$form .= "<input type=\"radio\" name=\"".$name."\" value=\"".$key."\" />".htmlspecialchars($value).$button_view;
				}
			}
		}
		return $form;
	}

	/**
	 * ﾁｪｯｸﾎﾞｯｸｽ
	 * @param  array  $array 
	 *         array  $code   checked
	 *         string $name   変数名
	 *         string $view   表示 br,space
	 * @return string  $form 
	 */
	function makeCheckBox($array, $code_array, $name, $view="space"){
		$form = "";
		/** 表示 */
		if($view == "br"){
			$box_view = "<br />";
		}else{
			$box_view = "&nbsp;&nbsp;&nbsp;";
		}
		while( list($key, $value) = each($array)){
			if (@$code_array[0] == ""){
				$form .= "<input type=\"checkbox\" name=\"".$name."[]\" value=\"".$key."\" />".htmlspecialchars($value).$box_view;
			}else{
				if (in_array($key, $code_array) == true){
					$form .= "<input type=\"checkbox\" name=\"".$name."[]\" value=\"".$key."\" checked=\"checked\" />".htmlspecialchars($value).$box_view;
				}else{
					$form .= "<input type=\"checkbox\" name=\"".$name."[]\" value=\"".$key."\" />".htmlspecialchars($value).$box_view;
				}
			}
		}
		return $form;
	}

	/**
	 * ｾﾚｸﾄﾎﾞｯｸｽ
	 * @param  array  $array 
	 *         array  $code   checked
	 * @return string  $form 
	 */
	function makeSelectBox($array, $code){
		$form = "";
		while( list($key, $value) = each($array)){
			if ($code == ""){
				$form .= "<option value=\"".$key."\">".htmlspecialchars(mb_substr($value,0,30))."</option>";
			}else{
				if ($code == $key){
					$form .= "<option value=\"".$key."\" selected=\"selected\">".htmlspecialchars(mb_substr($value,0,30))."</option>";
				}else{
					$form .= "<option value=\"".$key."\">".htmlspecialchars(mb_substr($value,0,30))."</option>";
				}
			}
		}
		return $form;
	}

	/**
	 * 配列ﾃﾞｰﾀ変更
	 * @param  array   $db ﾃﾞｰﾀ
	 *         string  $key code field_name
	 *         string  $val name field_name
	 * @return array   $array  array([56]=>'スケート',[55]=>'アイスホッケー')
	 */
	function editDbArray($db, $key, $val){
		$array = array();
		foreach($db as $value){
			$array[$value[$key]] = $value[$val];
		}
		return $array;
	}

	/**
	 * 配列ﾃﾞｰﾀ変更
	 * @param  array   $db ﾃﾞｰﾀ  Array([0] => Array([sitem_code] => 56)[1] => Array([sitem_code] => 55))
	 *         string  $key code field_name
	 * @return array   $array  array([0]=>'56',[1]=>'55')
	 */
	function editDbArrayToForm($db, $key){
		$array = array();
		foreach($db as $value){
			$array[] = $value[$key];
		}
		return $array;
	}

	/**
	 * 配列ﾃﾞｰﾀ変更  
	 * @param  array   $db_array    array([56]=>'スケート',[55]=>'アイスホッケー')
	 *         array   $form_array  array([0]=>'56',[1]=>'55') 
	 * @return string  $item        スケート、アイスホッケー
	 */
	function editItemCodeToValue($db_array, $form_array){
		$item = "";
		#2009/02/24 for
		$count =count($form_array);
		for ($i=0; $i < $count;$i++){
			$item .= $db_array[$form_array[$i]];
		#foreach($form_array as $value){
		#	$item .= $db_array[$value];
			if(next($form_array) == true){
				$item .= _CHARACTER_COMMA;
			}
		}
		return $item;
	}
}
?>