<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2008/12/12
 */

/** ﾌｧｲﾙｼｽﾃﾑｸﾗｽ */
class FileSystem{
	
	/**
	 * ﾃﾞｨﾚｸﾄﾘ読込み
	 * @param  string $path    ﾃﾞｨﾚｸﾄﾘｰﾊﾟｽ
	 * @return array  $dirfile ﾌｧｲﾙ・ﾃﾞｨﾚｸﾄﾘｰ一覧
	 */
	function openDirectory($path){
		$dirfiles = array();
		$handle = @opendir($path);
		while ($file = @readdir($handle)){
			$dirfile[] = $file;
		}
		@closedir($handle);
		return $dirfile;
	}

	/**
	 * ﾌｧｲﾙのみ取得
	 * @param  string  $path    ﾃﾞｨﾚｸﾄﾘｰﾊﾟｽ
	 *         array   $dirfile ﾌｧｲﾙ・ﾃﾞｨﾚｸﾄﾘｰ一覧
	 * @return array   $files   ﾌｧｲﾙ一覧
	 */
	function isFiles($path, $dirfile){
		$files = array();
		foreach($dirfile as $val){
			if(is_file($path."/".$val)){
				$files[] = $val;	
			}
		}
		return $files;
	}

	/**
	 * @$_FILE
	 * $_FILE[ ﾊﾟﾗﾒｰﾀ名 ][ name ]        : ｱｯﾌﾟﾛｰﾄﾞﾌｧｲﾙ名   
	 * $_FILE[ ﾊﾟﾗﾒｰﾀ名 ][ type ]        : MIMEﾀｲﾌﾟ
	 * $_FILE[ ﾊﾟﾗﾒｰﾀ名 ][ size ]        : ｱｯﾌﾟﾛｰﾄﾞされたﾌｧｲﾙｻｲｽﾞ
	 * $_FILE[ ﾊﾟﾗﾒｰﾀ名 ][ tmp_name ]    : 一時的に保存されたﾌｧｲﾙﾊﾟｽ
	 * $_FILE[ ﾊﾟﾗﾒｰﾀ名 ][ error ]       : ｴﾗｰｺｰﾄﾞ｡正常にｱｯﾌﾟﾛｰﾄﾞされたらｾﾞﾛになります｡
	 * $_FILE[ ﾊﾟﾗﾒｰﾀ名 ][ upload_name ] : ｱｯﾌﾟﾛｰﾄﾞされたﾌｧｲﾙ名
	 * $_FILE[ ﾊﾟﾗﾒｰﾀ名 ][ delete ]      : 削除 true,false
	 * $_FILE[ ﾊﾟﾗﾒｰﾀ名 ][ dir ]         : ｱｯﾌﾟﾛｰﾄﾞされたﾃﾞｨﾚｸﾄﾘ名
	 */

	/**
	 * ﾌｧｲﾙｺﾝﾄﾛｰﾙ (upload)
	 * @param  array   $file        
	 *         string  $temp_path    tmp ﾊﾟｽ
	 */
	function fileControlUpload($file, $temp_path){
		foreach($file as $val){
			if(@$_FILES[$val]['name'] <> ""){
				if(@$_SESSION['input'][$val]['upload_name'] <> ""){
					/** tmp ﾌｧｲﾙ 削除 */
					FileSystem::deleteFile(@$_SESSION['input'][$val]['upload_name'], $temp_path);
				}
				/** ｾｯｼｮﾝ登録 */
				$_SESSION['input'][$val] = @$_FILES[$val];
				/** ｱｯﾌﾟﾛｰﾄﾞ */
				FileSystem::uploadFile(@$_SESSION['input'][$val], $val, $temp_path);
			}else{
				if(@$_SESSION['input'][$val]['upload_name'] <> ""){
					if(@$_REQUEST[$val."_del"] == "1"){
						$_SESSION['input'][$val]['delete'] = true;
					}else{
						$_SESSION['input'][$val]['delete'] = false;
					}
				}
			}
		}
	}

	/**
	 * ﾌｧｲﾙｺﾝﾄﾛｰﾙ (done)
	 * @param  array   $file         
	 *         string  $temp_path    tmp ﾊﾟｽ
	 *         string  $upload_path  upload ﾊﾟｽ
	 *         int     $code         CODE
	 *         object  $dbobj
	 *         string  $table_name
	 *         string  $where
	 */
	function fileControlDone($file, $temp_path, $upload_path, $code, $dbobj, $table_name, $where){
		foreach($file as $val){
			if(@$_SESSION['input'][$val]['upload_name'] <> ""){
				if(@$_SESSION['input'][$val]['delete'] == true){
					/** tmp    ﾌｧｲﾙ 削除 */
					FileSystem::deleteFile(@$_SESSION['input'][$val]['upload_name'], $temp_path);
					/** upload ﾌｧｲﾙ 削除 */
					FileSystem::deleteFile(@$_SESSION['input'][$val]['upload_name'], $upload_path);
					/** db     ﾌｧｲﾙ 削除 */
					if($table_name <> ""){
						$sql    = "select ".$val." from ".$table_name." where ".$where;
						$detail = $dbobj->dbSelect($sql, "detail");
						if (count($detail) > 0 ){
							if($detail[$val] <> ""){
								FileSystem::deleteFile($detail[$val], $upload_path);
								/** ｻﾑﾈｲﾙ 削除 */
								FileSystem::deleteFile("thumb_".$detail[$val], $upload_path);
								FileSystem::deleteFile("list_".$detail[$val], $upload_path);
							}
						}
					}
					/** reset */
					@$_SESSION['input'][$val] = array();
				}else{
					if(@$_SESSION['input'][$val]['tmp_name'] <> ""){
						/** ｱｯﾌﾟﾛｰﾄﾞﾌｧｲﾙ名 code付ける */
						$name        = $code."_".@$_SESSION['input'][$val]['upload_name'];
						/** temp ﾌｧｲﾙ ｺﾋﾟｰ */
						$temp_file   = $temp_path."/".@$_SESSION['input'][$val]['upload_name'];
						$upload_file = $upload_path."/".$name;
						FileSystem::copyFile($temp_file, $upload_file);
						/** tmp ﾌｧｲﾙ 削除 */
						FileSystem::deleteFile(@$_SESSION['input'][$val]['upload_name'], $temp_path);
						/** ｾｯｼｮﾝ ｱｯﾌﾟﾛｰﾄﾞﾌｧｲﾙ名 変更 */
						@$_SESSION['input'][$val]['upload_name'] = $name;
					}
					/** db ﾌｧｲﾙ 削除 */
					if($table_name <> ""){
						$sql    = "select ".$val." from ".$table_name." where ".$where;
						$detail = $dbobj->dbSelect($sql, "detail");
						if (count($detail) > 0  and $detail[$val] <> @$_SESSION['input'][$val]['upload_name']){
							if($detail[$val] <> ""){
								FileSystem::deleteFile($detail[$val], $upload_path);
								/** ｻﾑﾈｲﾙ 削除 */
								FileSystem::deleteFile("thumb_".$detail[$val], $upload_path);
								FileSystem::deleteFile("list_".$detail[$val], $upload_path);
							}
						}
					}
				}
			}
		}
	}

	/** 
	 *  ﾘｻｲｽﾞ ImageMagick xy指定
	 *  @param
	 *  $x_size : 画像の幅
	 *  $y_size : 画像の高さ
	 *  $image  : オリジナル画像
	 *  $rename : リネーム
	 */
	function resizeImage($image, $x_size, $y_size, $rename){
		if (file_exists($image) && is_file($image)){
			$size  = getimagesize($image);
			$width = $size[0];
			$hight = $size[1];
			if($width > $x_size || $hight > $y_size){
				$w = _IMAGEMAGICK_PATH." -geometry ".$x_size."x".$y_size." ".$image." ".$rename;
			}else{
				$w = _IMAGEMAGICK_PATH." -geometry ".$width."x".$hight." ".$image." ".$rename;
			}
			exec($w);
			chmod($rename,0644);
		}
	}

	/**  
	 * ﾌｧｲﾙ ｺﾋﾟｰ
	 * @param  string  $temp_file    temp   ﾌｧｲﾙ 名
	 *         string  $upload_file  upload ﾌｧｲﾙ 名
	 */
	function copyFile($temp_file, $upload_file){
		if (file_exists($temp_file) && is_file($temp_file)){
			copy($temp_file, $upload_file);
		}
	}

	/**  
	 * ﾌｧｲﾙ 削除
	 * @param  string  $file_name   ﾌｧｲﾙ 名
	 *         string  $path        ﾊﾟｽ
	 */
	function deleteFile($file_name, $path){
		$file = $path."/".$file_name;
		if (file_exists($file) && is_file($file)){
			unlink($file);
		}
	}

	/**
	 * ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ
	 * @param  array   $file        
	 *         string  $path        tmp ﾊﾟｽ
	 *         string  $name        code
	 */
	function uploadFile($file, $name, $path){
		/** type */
//		$type = array_search($file['type'], Select::fileMime());
//		if($type != false){
		$type = "csv";
			/** upload file name */
			@$_SESSION['input'][$name]['upload_name'] = $name."_".date('ymdHis').".".$type;
			@$_SESSION['input'][$name]['dir']         = "tmp";
			/** tmpｺﾋﾟ- */
			move_uploaded_file($file['tmp_name'], $path."/".@$_SESSION['input'][$name]['upload_name']);
			/** ﾊﾟｰﾐｯｼｮﾝ変更 */
			chmod($path."/".@$_SESSION['input'][$name]['upload_name'], 0644);
			/** ﾘｻｲｽﾞ */
			#FileSystem::resizeImage($path."/".@$_SESSION['input'][$name]['upload_name']);
//		}
	}

	/**  
	 * ﾌｧｲﾙ ｻｲｽﾞ
	 * @param  string  $file_name   ﾌｧｲﾙ 名
	 *         string  $path        ﾊﾟｽ
	 * @return string
	 */
	function getFilesize($file_name, $path){
		$file = $path."/".$file_name;
		if (file_exists($file) && is_file($file)){
			return filesize($file);
		}
	}

	/**
	 * ﾊﾞｲﾄ ｺﾝﾊﾞｰﾄ
	 *
	 * @param  int     $bytes
	 * @return string
	*/
	function byteConvert($bytes){
		$s = Select::fileUnit();
		$e = floor(log($bytes)/log(1024));
		return sprintf('%.1f '.$s[$e], ($bytes/pow(1024, floor($e))));
	}

	/**  
	 * 拡張子
	 * @param  string  $file_name   ﾌｧｲﾙ 名
	 *         string  $path        ﾊﾟｽ
	 * @return string
	 */
	function getExtension($file_name, $path){
		$file = $path."/".$file_name;
		if (file_exists($file) && is_file($file)){
			$info = pathinfo($file);
			return $info['extension'];
		}
	}

	/**  
	 * ﾌｧｲﾙ書込
	 * @param  string  $file   ﾌｧｲﾙ 名
	 *         array   $data   ﾊﾟｽ
	 */
	function fileSave($file, $data){
		if (file_exists($file) && is_file($file)){
			$fp = @fopen($file, "w");
			flock($fp, LOCK_EX);
			foreach ($data as $value){
				fputs($fp, $value, strlen($value));
			}
			flock($fp, LOCK_UN);
			fclose($fp);
		}
	}

}
?>
