<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2009/9/30
 */

/** 拡張入力ﾌｫｰﾑ */
class ExInput {

	/**
	 * ｴﾗｰ
	 * @var boolean
	 */
	var $error_flag = false;

	/**
	 * ｴﾗｰﾒｯｾｰｼﾞ
	 * @var array
	 */
	var $error_msg = array();

	/**
	 * 検索フォーム
	 * @var array
	 */
	var $search_form = array();

	/**
	 * 検索確認
	 * @var array
	 */
	var $search_conf = array();

	/**
	 * 検索条件
	 * @var array
	 */
	var $search_where = array();

	/**
	 * 初期値
	 * @var array
	 */
	var $default = array();

	/**
	 * 入力フォーム
	 * @form array
	 */
	var $form = array();

	/**
	 * 確認
	 * @form array
	 */
	var $conf = array();

	/**
	 * 入力値表示
	 * @result array
	 */
	var $result = array();

	/**
	 * 登録値
	 * @reg array
	 */
	var $reg = array();

	/**
	 * 参照テーブル
	 * @table string
	 */
	var $table;

	/**
	 * データテーブル
	 * @data_table string
	 */
	var $data_table;

	/**
	 * タイトルテーブル
	 * @title_table string
	 */
	var $title_table;

	/**
	 * エラーテーブル
	 * @error_table string
	 */
	var $error_table;

	/**
	 * 検索テーブル
	 * @search_table string
	 */
	var $search_table;

	/**
	 * キーコード
	 * @key_col string
	 */
	var $key_col;

	/**
	 * @param  string $table      テーブル名
	 *         string $key_col    キーカラム名
	 *         string $sort_asc   ソート順
	 */

	function ExInput($table,$key_col){

		$this->key_col = $key_col;
		$this->table = $table;
		$this->data_table = $table."_data";
		$this->title_table = $table."_datatitle";
		$this->error_table = $table."_error";
		$this->search_table = $table."_search";
	}

	/**
	 * タイトルセット
	 * @param  string $sort_col   ソートするカラム名
	 *         string $sort_asc   ソート順
	 */

	function title_set(){

		$db = new DbControll();
		$order = " ORDER BY sort";
		$this->list = $db->dbSelect("select * from ".$this->title_table.$order, "list");
		for($i=0; $i<count($this->list); $i++){
			if($this->list[$i]['input_type'] != ""){
				$this->result[] = array("title_id"=>$this->list[$i]['title_id'],"name"=>$this->list[$i]['title_name'],"type"=>$this->list[$i]['input_type'],"exist"=>$this->list[$i]['exist'],"param"=>$this->list[$i]['input_param'],);
			}
		}
		$this->default_value();
	}

	/**
	 * 初期値
	 */

	function default_value(){
		for($i=0; $i<count($this->list); $i++){
			$json = new Services_JSON();
			$default_array = $json->decode($this->list[$i]['input_default']);
			if(count($default_array) <= 1){
				$this->default[$this->list[$i]['title_id']] = $default_array[0];
			}else{
				for($j=1; $j<=count($default_array); $j++){
					$title = $this->list[$i]['title_id'].$j;
					$this->default[$title] = $default_array[$j-1];
				}
			}
		}
	}

	/**
	 * 登録値
	 */

	function reg_value($value){
		$db = new DbControll();
		for($i=0; $i<count($this->list); $i++){
			if($this->list[$i]['input_type'] != ""){
				$class_name = ucfirst($this->list[$i]['input_type'])."_Ex";
				eval('$ex = new '.$class_name.'();');
				$reg_data = $ex->reg_data($value,$this->list[$i]['title_id']);
				if(count($reg_data) > 0){
					foreach($reg_data as $key=>$val){
						$this->reg[$key] = $val;
					}
				}
			}
		}
	}

	/**
	 * 入力フォーム
	 */

	function input_form($data){
		for($i=0; $i<count($this->list); $i++){
			if($this->list[$i]['input_type'] != ""){
				$json = new Services_JSON();
				$param = $json->decode($this->list[$i]['input_param']);
				$class_name = ucfirst($this->list[$i]['input_type'])."_Ex";
				eval('$ex = new '.$class_name.'();');
				$form_data = $ex->form_data($data,$param,$this->list[$i]['title_id'],$this->list[$i]['input_type']);
				$this->form[] = array("title_id"=>$this->list[$i]['title_id'],"name"=>$this->list[$i]['title_name'],"form"=>$form_data,"exist"=>$this->list[$i]['exist']);
			}
		}
	}

	/**
	 * 確認表示
	 */

	function input_conf($data){
		for($i=0; $i<count($this->list); $i++){
			if($this->list[$i]['input_type'] != ""){
				$json = new Services_JSON();
				$param = $json->decode($this->list[$i]['input_param']);
				$class_name = ucfirst($this->list[$i]['input_type'])."_Ex";
				eval('$ex = new '.$class_name.'();');
				$conf_data = $ex->conf_data($data,$param,$this->list[$i]['title_id'],$this->list[$i]['input_type']);
				$this->conf[] = array("title_id"=>$this->list[$i]['title_id'],"name"=>$this->list[$i]['title_name'],"conf"=>$conf_data,"exist"=>$this->list[$i]['exist']);
			}
		}
	}

	/**
	 * DB入力
	 */

	function insert($req,$code){
		$db = new DbControll();
		for($i=0; $i<count($this->result); $i++){
			if($this->result[$i]['type'] != ""){
				$json = new Services_JSON();
				$param = $json->decode($this->result[$i]['param']);

				$class_name = ucfirst($this->result[$i]['type'])."_Ex";
				eval('$ex = new '.$class_name.'();');
				$insert_data = $ex->insert_data($req,$this->result[$i]['title_id'],$param);
				for($j=0; $j<count($insert_data); $j++){
					if($insert_data[$j]['data_value'] != ""){
						$insert_data[$j][$this->key_col] = $code;
						$db->dbInsert($this->data_table, $insert_data[$j]);
					}
				}
			}
		}
	}
	
	/**
	 * DB更新
	 */

	function update($req,$code){
		$db = new DbControll();
		$list = $db->dbSelect("SELECT * FROM ".$this->data_table." where ".$this->key_col."=".$code, "list");
		for($i=0; $i<count($list); $i++){
			$reg_data[$list[$i]['title_id']] = $list[$i]['data_value'];
		}
		for($i=0; $i<count($this->result); $i++){
			if($this->result[$i]['type'] != ""){
				$json = new Services_JSON();
				$param = $json->decode($this->result[$i]['param']);
				$class_name = ucfirst($this->result[$i]['type'])."_Ex";
				eval('$ex = new '.$class_name.'();');
				$updata_data = $ex->insert_data($req,$this->result[$i]['title_id'],$param);
				for($j=0; $j<count($updata_data); $j++){
					if(@$reg_data[$updata_data[$j]['title_id']] == "" and $updata_data[$j]['data_value'] != ""){
						$updata_data[$j][$this->key_col] = $code;
						$db->dbInsert($this->data_table, $updata_data[$j]);
					}elseif(@$reg_data[$updata_data[$j]['title_id']] != "" and $updata_data[$j]['data_value'] != ""){
						$where       = $this->key_col." = '".$code."' and title_id = '".$updata_data[$j]['title_id']."'";
						$db->dbUpdate($this->data_table, $updata_data[$j], $where);
					}else{
						$where       = $this->key_col." = '".$code."' and title_id = '".$updata_data[$j]['title_id']."'";
						$db->dbDelete($this->data_table, $where);
					}
				}
			}
		}
	}
	
	/**
	 * DB削除
	 */

	function delete($code){
		$db = new DbControll();
		$list = $db->dbSelect("SELECT * FROM ".$this->data_table." where ".$this->key_col."=".$code, "list");
		for($i=0; $i<count($list); $i++){
			$reg_data[$list[$i]['title_id']] = $list[$i]['data_value'];
		}
		for($i=0; $i<count($this->result); $i++){
			if($this->result[$i]['type'] != ""){
				$json = new Services_JSON();
				$param = $json->decode($this->result[$i]['param']);
				$class_name = ucfirst($this->result[$i]['type'])."_Ex";
				eval('$ex = new '.$class_name.'();');
				$delete_data = $ex->delete_data($this->result[$i]['title_id'],$reg_data,$param);
			}
		}
		$db = new DbControll();
		$where       = $this->key_col." = '".$code."'";
		$db->dbDelete($this->data_table, $where);
	}

	/**
	 * エラーチェック
	 */

	function ExErrorCheck($values,$col_name=array()){
		$etc_value = $values;
		for($i=0; $i<count($this->result); $i++){
			if($this->result[$i]['type'] != ""){
				$class_name = ucfirst($this->result[$i]['type'])."_Ex";
				eval('$ex = new '.$class_name.'();');
				$ex->error($values,$this->result[$i]);
				if(@$ex->error_msg){
					$this->error_msg = array_merge($this->error_msg,$ex->error_msg);
				}
				if(@$ex->error_flag){
					$this->error_flag = true;
				}
				if($this->result[$i]['exist'] == "1"){
					$class_name = "EXIST_Er";
					eval('$er_exist = new '.$class_name.'();');
					$er_exist->check(@$ex->check_data,$this->result[$i]['name']);
					if(@$er_exist->error_msg){
						$this->error_msg = array_merge($this->error_msg,$er_exist->error_msg);
					}
					if(@$er_exist->error_flag){
						$this->error_flag = true;
					}
				}
				if(@$ex->check_data != ""){
					$db = new DbControll();
					$error_col_list = $db->dbSelect("select * from ".$this->error_table." where title_id = '".$this->result[$i]['title_id']."'", "list");
					for($j=0; $j<count($error_col_list); $j++){

						$json = new Services_JSON();
						$param_array = $json->decode($error_col_list[$j]['check_param']);

						$class_name = $error_col_list[$j]['check_type']."_Er";
						eval('$er_ex = new '.$class_name.'();');
						$er_ex->check(@$ex->check_data,$this->result[$i]['name'],@$param_array);
						if(@$er_ex->error_msg){
							$this->error_msg = array_merge($this->error_msg,$er_ex->error_msg);
						}
						if(@$er_ex->error_flag){
							$this->error_flag = true;
						}
					}
				}
				unset($etc_value[$this->result[$i]['title_id']]);
			}
		}
		if(count($etc_value) > 0){
			foreach($etc_value as $key=>$val){
				$db = new DbControll();
				$error_col_list = $db->dbSelect("select * from ".$this->error_table." where title_id = '".$key."'", "list");
				for($j=0; $j<count($error_col_list); $j++){

					$json = new Services_JSON();
					$param_array = $json->decode($error_col_list[$j]['check_param']);

					$class_name = $error_col_list[$j]['check_type']."_Er";
					eval('$er_ex = new '.$class_name.'();');
					$er_ex->check(@$val,$col_name[$key],@$param_array);
					if(@$er_ex->error_msg){
						$this->error_msg = array_merge($this->error_msg,$er_ex->error_msg);
					}
					if(@$er_ex->error_flag){
						$this->error_flag = true;
					}
				}
			}
		}
		
	}

	/**
	 * 検索
	 */

	function ExSearch($values){
//		$_SESSION['input'] = @$values;
		$db = new DbControll();
		$search_list = $db->dbSelect("select * from ".$this->search_table." order by sort", "list");
		for($i=0; $i<count($search_list); $i++){
			if($search_list[$i]['search_type'] != ""){

				$json = new Services_JSON();
				$param = $json->decode($search_list[$i]['search_param']);
				$class_name = ucfirst($search_list[$i]['search_type'])."_Sh";
				eval('$ex = new '.$class_name.'();');
				$ex->search(@$values,$search_list[$i]['title_id'],$param);
				
				$this->search_form[] = array("title_id"=>$search_list[$i]['title_id'],"name"=>$search_list[$i]['title_name'],"type"=>$search_list[$i]['search_type'],"value"=>$ex->value,"param"=>$param);
				$this->search_conf[] = array("title_id"=>$search_list[$i]['title_id'],"name"=>$search_list[$i]['title_name'],"type"=>$search_list[$i]['search_type'],"value"=>$ex->conf,"param"=>$param);
				for($j=0; $j<count($ex->where); $j++){
					$this->search_where[] = $ex->where[$j];
				}
			}
		}
	}
	
}
?>