<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** DB ｺﾝﾄﾛｰﾙ */
class DbControll {

	/**
	 * dbcon
	 * @var object
	 */
	var $dbcon;

	/**
	 * res
	 * @var mixed
	 */
	var $res;

	/**
	 * records
	 * @var int
	 */
	var $records;

	/**
	 * error
	 * @var string
	 */
	var $error;

	/**
	 * db 接続
	 */
	function dbConnect(){
		require_once 'MDB2.php';
		$this->dbcon = MDB2::connect(_DB_TYPE.'://'._DB_USER.':'._DB_PASS.'@'._DB_HOST.'/'._DB_NAME);
		$this->error = "";
	}

	/**
	 * db 切断
	 */
	function dbClose(){
		$this->dbcon->disconnect();
		$this->dbcon->free();
	}

	/**
	 * db ﾚｺｰﾄﾞ数
	 */
	function dbRecords(){
		$this->records = $this->res->numRows();
	}

	/**
	 * db 結果ｾｯﾄから行を取得
	 * @return array
	 */
	function dbArray(){
		return $this->res->fetchRow();
	}

	/**
	 * db ｸｴﾘ実行
	 * @param  string $sql sqlｸｴﾘ
	 * @return string $error ｴﾗｰﾒｯｾｰｼﾞ
	 *         mixed  $res
	 */
	function dbQuery($sql){
		$this->dbConnect();
		if (PEAR::isError($this->dbcon)) {
			$this->error = $this->dbcon->getMessage();
		}else{
			/** ｶﾗﾑ名をｷｰとする連想配列 */
			$this->dbcon->setFetchMode(MDB2_FETCHMODE_ASSOC);
//			$this->dbcon->query('SET NAMES '._CHARACTER_SET_db);
			$this->res = $this->dbcon->query($sql);
			if (PEAR::isError($this->res)) {
    				$this->error = $this->res->getMessage();
			}
		}
	}

	/**
	 * db select
	 * @param  string $sql sqlｸｴﾘ
	 *         string $type ﾘｽﾄ／詳細
	 * @return array  db 結果
	 */
	function dbSelect($sql, $type){
		$this->dbQuery($sql);
		if ($this->error == "") {
			$this->dbRecords();
			$dbvalue = array();
			if($type == "list"){
				while ($row =& $this->dbArray()) {
					array_push($dbvalue, $row);
				}
			}elseif($type == "detail"){
				$dbvalue = $this->dbArray();
			}
			return $dbvalue;
			$this->DbClose();
		}
	}

	/**
	 * db limit ｸｴﾘ実行 MySQL LIMITｵﾌﾟｼｮﾝの挙動をｴﾐｭﾚｰﾄ
	 * @param  string $sql   sqlｸｴﾘ
	 *         int    $form  取得を開始する行
	 *         int    $count 取得する行数
	 * @return string $error ｴﾗｰﾒｯｾｰｼﾞ
	 *         mixed  $res
	 */
	function dbLimitQuery($sql, $form, $count){
		$this->dbConnect();
		if (PEAR::isError($this->dbcon)) {
			$this->error = $this->dbcon->getMessage();
		}else{
			$this->res = $this->dbcon->limitQuery($sql, $form, $count);
			if (PEAR::isError($this->res)) {
    				$this->error = $this->res->getMessage();
			}
		}
	}

	/**
	 * db 連番取得
	 * @return int    カレントコード
	 */
	function dbCurrCode(){
		$sql = "SELECT last_insert_id();";
		$code = $this->dbcon->getOne($sql);
		return $code;
	}

	/**
	 * db insert
	 * @param  string $table_name    ﾃｰﾌﾞﾙ名
	 *         array  $fields_values array('ﾌｨｰﾙﾄﾞ名'=>'値')
	 * @return string $error         ｴﾗｰﾒｯｾｰｼﾞ
	 */
	function dbInsert($table_name, $fields_values){
		$this->dbConnect();
		if (PEAR::isError($this->dbcon)) {
			$this->error = $this->dbcon->getMessage();
			
		}else{
//			$this->dbcon->query('SET NAMES '._CHARACTER_SET_db);
			$this->dbcon->loadModule('Extended', null, false);
			$this->res = $this->dbcon->extended->autoExecute($table_name, $fields_values, MDB2_AUTOQUERY_INSERT);
			if (PEAR::isError($this->res)) {
				$this->error = $this->res->getMessage();
			}
			$sql = "SELECT LASTVAL();";
			$code = $this->dbcon->getOne($sql);
			unset($sql);
			unset($table_name);
			unset($fields_values);
			$this->DbClose();
			return $code;
		}
	}

	/**
	 * db update
	 * @param  string $table_name    ﾃｰﾌﾞﾙ名
	 *         array  $fields_values array('ﾌｨｰﾙﾄﾞ名'=>'値')
	 *         string $where 条件式('id = 1')     
	 * @return string $error ｴﾗｰﾒｯｾｰｼﾞ
	 */
	function dbUpdate($table_name, $fields_values, $where){
		$this->dbConnect();
		if (PEAR::isError($this->dbcon)) {
			$this->error = $this->dbcon->getMessage();
			
		}else{
//			$this->dbcon->query('SET NAMES '._CHARACTER_SET_db);
			$this->dbcon->loadModule('Extended', null, false);
			$this->res = $this->dbcon->extended->autoExecute($table_name, $fields_values, MDB2_AUTOQUERY_UPDATE, $where);
			if (PEAR::isError($this->res)) {
				$this->error = $this->res->getMessage();
			}
			$this->DbClose();
			unset($table_name);
			unset($fields_values);
			unset($where);
		}
	}

	/**
	 * db delete
	 * @param  string $table_name    ﾃｰﾌﾞﾙ名
	 *         string $where         条件式('id = 1')     
	 */
	function dbDelete($table_name, $where){
		$sql = "delete from ".$table_name." where ".$where;
		$this->dbQuery($sql);
		$this->DbClose();
	}

	/**
	 * db prepare
	 * @param  string $sql    sql
	 *         array  $fields_array array(array('値','値','値'))
	 * @return string $error         ｴﾗｰﾒｯｾｰｼﾞ
	 */
	function dbPrepare($sql, $fields_array){
		$this->dbConnect();
		if (PEAR::isError($this->dbcon)) {
			$this->error = $this->dbcon->getMessage();
			
		}else{
//			$this->dbcon->query('SET NAMES '._CHARACTER_SET_db);
			$this->dbcon->loadModule('Extended', null, false);

			$sth = $this->dbcon->prepare($sql);
			$this->res = $this->dbcon->extended->executeMultiple($sth, $fields_array);

			if (PEAR::isError($this->res)) {
				$this->error = $this->res->getMessage();
			}
			unset($sql);
			unset($fields_array);
			$this->DbClose();
		}
	}

	/**
	 * db order update 表示順変更
	 * @param  string $table_name   ﾃｰﾌﾞﾙ名
	 *         string $order_name   ﾌｨｰﾙﾄﾞ名 order
	 *         int    $code_name    ﾌｨｰﾙﾄﾞ名 code
	 *         string $where        where文
	 */
	function dbOrderUpdate($table_name, $order_name, $code_name, $where){
		$sql = "select ".$code_name." from ".$table_name." ".$where." order by ".$order_name;
		$this->dbQuery($sql);
		if ($this->error == "") {
			$dbvalue = array();
			while ($row =& $this->dbArray()) {
				array_push($dbvalue, $row);
			}
			$i=10;
			foreach($dbvalue as $val){
				$sql = "UPDATE ".$table_name." set ".$order_name."=".$i." WHERE ".$code_name."='".$val[$code_name]."'";
				$this->DbQuery($sql);
				$i+=10;
			}
			$this->DbClose();
		}
	}

	/**
	 * db ｴｽｹｰﾌﾟ
	 * @param  string $value
	 * @return string ｴｽｹｰﾌﾟされた文字列
	 */
	function dbEscape($value){
		$this->dbConnect();
		if (PEAR::isError($this->dbcon)) {
			$this->error = $this->dbcon->getMessage();
		}else{
			return $this->dbcon->escapeSimple($value);
		}
	}

	/**
	 * db like検索ｴｽｹｰﾌﾟ (ﾘﾃﾗﾙ,ﾏｯﾁﾝｸﾞの2回行う)
	 * @param  string $value
	 * @return string like検索ｴｽｹｰﾌﾟされた文字列
	 */
	function likeEscape($value){
		$value = ereg_replace('\\\\', '\\\\', $value);
		$value = ereg_replace('_', '\\\\_', $value);
		$value = ereg_replace('%', '\\\\%', $value);
		return $value;
	}
}
?>