<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2008/12/12
 */

/** ﾁｪｯｸｸﾗｽ */
class CheckItem {

	/**
	 * ｴﾗｰ
	 * @var boolean
	 */
	var $error_flag = false;

	/**
	 * ｴﾗｰﾒｯｾｰｼﾞ
	 * @var array
	 */
	var $error_msg = array();

	/**
	 * エラー表示
	 */
	 function checkErrorCode($error_code,$str=array()){
		$this->error_msg[] =  vsprintf(Error::ErrorView($error_code),$str);
		$this->error_flag = true;
	 }

	/**
	 * テキストエラー表示
	 */
	 function checkErrorText($text){
		$this->error_msg[] =  "$text";
		$this->error_flag = true;
	 }

	/**
	 * 必須項目
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemNon($require){
		foreach($require as $key => $val){
			if(!@$_SESSION['input'][$key] || @$_SESSION['input'][$key] == "" and _ERROR_0007){
				$this->error_msg[] = $val."は".Error::ErrorView("0007");
				$this->error_flag = true;
			}
		}
	}

	/**
	 * 必須選択
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemSelect($require){
		foreach($require as $key => $val){
			if(!@$_SESSION['input'][$key] || @$_SESSION['input'][$key] == "" and _ERROR_0013){
				$this->error_msg[] = $val."は".Error::ErrorView("0013");
				$this->error_flag = true;
			}
		}
	}

	/**
	 * 必須項目 配列データ
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemNonArray($require){
		foreach($require as $key => $val){
			if(is_array(@$_SESSION['input'][$val]) == false && count(@$_SESSION['input'][$val]) == 0 and _ERROR_0007){
				$this->error_msg[] .= sprintf(_ERR_ITEM_NON, $key);
				$this->error_flag = true;
			}
		}
	}

	/**
	 * 所属先チェック
	 */
	function CheckMoveCate($require, $pkey, $parent){
		foreach($require as $key => $val){
			if(in_array($pkey,$parent) and _ERROR_0014){
				$this->error_msg[] = $val."を".Error::ErrorView("0014");
				$this->error_flag = true;
			}
		}
	}
	
	/**
	 * 所属先チェック
	 */
	function CheckCateDel($require){
		foreach($require as $key => $val){
			$db = new DbControll();
			$list = $db->dbSelect("SELECT * FROM \"user\" where sosiki_pkey = ".$_SESSION['input'][$key], "list");
			if(count($list) > 0 and _ERROR_0015){
				$this->error_msg[] = "その".$val."内に".Error::ErrorView("0015");
				$this->error_flag = true;
			}
		}
	}
	
	/**
	 * Eﾒｰﾙ
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemEmail($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$key]  <> ""){
				if(!ereg("([0-9,a-z,A-Z,_,-])+@([0-9,a-z,A-Z,_,-])+\.([0-9,a-z,A-Z,_,-])", $_SESSION['input'][$key]) and _ERROR_0006){
					$this->error_msg[] = $val."の".Error::ErrorView("0006");
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * Eﾒｰﾙ
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemEmailArray($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$key]  <> ""){
				$email_array = explode("\n",$_SESSION['input'][$key]);
				for($i=0; $i<count($email_array); $i++){
					if(!ereg("([0-9,a-z,A-Z,_,-])+@([0-9,a-z,A-Z,_,-])+\.([0-9,a-z,A-Z,_,-])", $email_array[$i])){
						$error_flag = true;
					}
				}
				if(@$error_flag and _ERROR_0006){
					$this->error_msg[] = $val."の".Error::ErrorView("0006");
					$this->error_flag = true;
				}

			}
		}
	}

	/**
	 * 英数のみ
	 */
	function checkAlphaNumeric($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$key]  <> ""){
				if(!ereg("^[a-zA-Z0-9]*$", $_SESSION['input'][$key]) and _ERROR_0005){
					$this->error_msg[] = $val."は".Error::ErrorView("0005");
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * 英数＋ハイフン＋アンダーバーのみ
	 */
	function checkAlphaNumericPlus($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$key]  <> ""){
				if(!ereg("^[a-zA-Z0-9,_,-]*$", $_SESSION['input'][$key]) and _ERROR_0005){
					$this->error_msg[] = $val."は".Error::ErrorView("0005");
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * 英数のみ
	 */
	function checkNumeric($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$key]  <> ""){
				if(!ereg("^-?[0-9]*$", $_SESSION['input'][$key]) and _ERROR_0017){
					$this->error_msg[] = $val."は".Error::ErrorView("0017");
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * ﾕｰｻﾞｰID重複 新規追加用
	 * @param  object   $dbobj
         *         string   $sql 
         *         string   $item_name
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemRepeatedAdd($sql, $item_name){
		$db = new DbControll();
		$detail = $db->dbSelect($sql, "detail");
		if (count($detail) > 0 and _ERROR_0016){
			$this->error_msg[] = $item_name."は".Error::ErrorView("0016");
			$this->error_flag = true;
		}
	}

	/**
	 * ﾕｰｻﾞｰID重複 編集用
	 * @param  object   $dbobj
         *         string   $sql 
         *         string   $item_name
	 *         string   $field_code 
         *         int      $code
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemRepeatedEdit($sql, $item_name, $old_code, $field_code){
		$db = new DbControll();
		$list = $db->dbSelect($sql, "list");
		if (count($list) > 0){
			foreach($list as $val){
				if($old_code <> $val[$field_code] and _ERROR_0016){
					$this->error_msg[] = $item_name."は".Error::ErrorView("0016");
					$this->error_flag = true;
					break;
				}
			}
		}
	}

	/**
	 * 日付01 (形式:2009/01/12)
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemDate01($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$key] <> ""){
				if (!ereg ("^([12][0-9]{3})/([0-9]{2})/([0-9]{2})$", @$_SESSION['input'][$key]) and _ERROR_0010) {
					$this->error_msg[] = $val."は".Error::ErrorView("0010");
					$this->error_flag = true;
				}else{
					$date = explode("/", @$_SESSION['input'][$key]);
					$this->checkItemDateValid($date[0], $date[1], $date[2], $val);
				}
			}
		}
	}
	
	/**
	 * 日付02 (形式:2009/01/12 23:59)
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemDateTime($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$key] <> ""){
				if (!ereg ("^([12][0-9]{3})/([0-9]{2})/([0-9]{2}) ([0-9]{2}):([0-9]{2})$", @$_SESSION['input'][$key]) and _ERROR_0022) {
					$this->error_msg[] = $val."は".Error::ErrorView("0022");
					$this->error_flag = true;
				}else{
					$datetime = explode(" ", @$_SESSION['input'][$key]);
					$date = explode("/", @$datetime[0]);
					$this->checkItemDateValid($date[0], $date[1], $date[2], $val);
				}
			}
		}
	}

	/**
	 * 日付 有効／無効
	 * @param  int      $y 年
	 *         int      $m 月
	 *         int      $d 日
	 *         string   $item_name
	 * @return boolean  $error
	 *         string   $msg
	 */
	 function checkItemDateValid($y, $m, $d, $item_name){
	 	if (checkdate($m, $d, $y) == false and _ERROR_0010) {
			$this->error_msg[] = $item_name."は".Error::ErrorView("0010");
			$this->error_flag = true;
		}
	 }


	/**
	 * int 型
	 * @param  array    $require
	 *         boolean  $zero  true:0OK,false:0NG 
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemInt($require, $zero){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val] <> ""){
				if(!ereg ("^([0-9]+)$", $_SESSION['input'][$val])){
					$this->error_msg[] .= sprintf(_ERR_ITEM_INT_01, $key);
					$this->error_flag = true;
				}else{
					if(@$_SESSION['input'][$val] > 2147483647){
						$this->error_msg[] .= sprintf(_ERR_ITEM_INT_02, $key);
						$this->error_flag = true;
					}else{
						if($zero == false){
							if(ereg ("^([0]+)", $_SESSION['input'][$val])){
								$this->error_msg[] .= sprintf(_ERR_ITEM_INT_03, $key);
								$this->error_flag = true;
							}
						}
					}
				}
			}
		}
	}

	/**
	 * 文字列の長さ
	 * @param  array    $require = array("item_name:len"=>"param")
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemStrlen($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val] <> ""){
				$item = explode(":", $key);
				if(mb_strlen($_SESSION['input'][$val]) > $item['1']){
					$this->error_msg[] .= sprintf(_ERR_ITEM_STRLEN, $item['0'], $item['1']);
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * ID・ﾊﾟｽﾜｰﾄﾞ
         * (半角英数字・$limit_min文字～$limit_max文字)
	 * @param  array    $require = array("item_name"=>"param")
         *         int      $limit_min 
         *         int      $limit_max
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemPsw($require, $limit_min, $limit_max){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val] <> ""){
				if (ereg("[^0-9a-zA-Z]", $_SESSION['input'][$val])){
					/** 半角英数字 */
					$this->error_msg[] .= sprintf(_ERR_ITEM_PASSWD_01, $key);
					$this->error_flag = true;
				}else{
					/** $limit_min文字～$limit_max文字 */
					if ( strlen($_SESSION['input'][$val]) < $limit_min || strlen($_SESSION['input'][$val]) > $limit_max){
						$this->error_msg[] .= sprintf(_ERR_ITEM_PASSWD_02, $key, $limit_min, $limit_max);
						$this->error_flag = true;
					}
				}
			}
		}
	}

	/**
	 * 日付02
	 * @param  int      $y 年
	 *         int      $m 月
	 *         int      $d 日
	 *         string   $item_name
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemDate02($y, $m, $d, $item_name){
		$val = @$_SESSION['input'][$y]."/".@$_SESSION['input'][$m]."/".@$_SESSION['input'][$d];
		if (!ereg ("^([12][0-9]{3})/([0-9]{2})/([0-9]{2})$", $val)) {
			$this->error_msg[] .= sprintf(_ERR_ITEM_DATE_01, $item_name);
			$this->error_flag = true;
		}else{
			$date = explode("/", $val);
			$this->checkItemDateValid($date[0], $date[1], $date[2], $item_name);
		}
	}
	/**
	 * 日付 期間比較
	 * @param  array    $require  array( _ITEM_OPEN_TIME=>array("event_s_date","event_e_date"))
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemDateCompare($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val[0]] <> "" && @$_SESSION['input'][$val[1]] <> ""){
				$date_start = ereg_replace("/", "", $_SESSION['input'][$val[0]]);
				$date_end   = ereg_replace("/", "", $_SESSION['input'][$val[1]]);
				if ($date_start > $date_end) {
					$this->error_msg[] .= sprintf(_ERR_ITEM_DATE_TIME, $key);
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * 日付 期間比較02
	 * @param  int      $start_y 年
	 *         int      $start_m 月
	 *         int      $start_d 日
	 *         int      $end_y   年
	 *         int      $end_m   月
	 *         int      $end_d   日
	 *         string   $item_name
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemDateCompare02($start_y, $start_m, $start_d, $end_y, $end_m, $end_d, $item_name){
		$date_start = $_SESSION['input'][$start_y].$_SESSION['input'][$start_m].$_SESSION['input'][$start_d];
		$date_end   = $_SESSION['input'][$end_y].$_SESSION['input'][$end_m].$_SESSION['input'][$end_d];
		if ($date_start > $date_end) {
			$this->error_msg[] .= sprintf(_ERR_ITEM_DATE_TIME, $item_name);
			$this->error_flag = true;
		}
	}

	/**
	 * 日付 期間入力
	 * @param  array    $require  array( _ITEM_OPEN_TIME=>array("event_s_date","event_e_date"))
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemDateInput($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val[0]] <> "" && @$_SESSION['input'][$val[1]] == ""){
				$this->error_msg[] .= sprintf(_ERR_ITEM_DATE_INPUT, $key);
				$this->error_flag = true;
			}else{
				if(@$_SESSION['input'][$val[1]] <> "" && @$_SESSION['input'][$val[0]] == ""){
					$this->error_msg[] .= sprintf(_ERR_ITEM_DATE_INPUT, $key);
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * 時間01 (形式:09:30)
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemTime01($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val] <> ""){
				if (!ereg ("^([0-9]{2}):([0-9]{2})$", @$_SESSION['input'][$val])) {
					$this->error_msg[] .= sprintf(_ERR_ITEM_TIME_01, $key);
					$this->error_flag = true;
				}else{
					$time = explode(":", $_SESSION['input'][$val]);
					$hour = $time[0];
					$min  = $time[1];
					if($hour > '23' || $min > '59'){
						$this->error_msg[] .= sprintf(_ERR_ITEM_TIME_02, $key);
						$this->error_flag = true;	
					}
				}
			}
		}
	}

	/**
	 * ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ
	 * error_code
	 * 0:成功,4:null
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemFileUpload($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val]['error'] != 0 and @$_SESSION['input'][$val]['error'] != 4){
				$this->error_msg[] .= sprintf(_ERR_ITEM_FILE_UPLOAD, $key);
				$this->error_flag = true;
				/** reset */
				$_SESSION['input'][$val] = array();
			}
		}
	}

	/**
	 * ﾌｧｲﾙﾀｲﾌﾟ PDF
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemFileType($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val]['tmp_name'] <> ""){
				$type = $_SESSION['input'][$val]['type'];
				if(array_search($type, Select::pdfMime()) == false){
					$this->error_msg[] .= sprintf(_ERR_ITEM_FILE_TYPE, $key);
					$this->error_flag = true;
					/** reset */
					$_SESSION['input'][$val] = array();
				}
			}
		}
	}

	/**
	 * 写真ﾀｲﾌﾟ JPG GIF PNG
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function CheckItemImageType($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val]['tmp_name'] <> ""){
				$type = $_SESSION['input'][$val]['type'];
				if(array_search($type, Select::imageMime()) == false){
					$this->error_msg[] .= sprintf(_ERR_ITEM_IMAGE_TYPE, $key);
					$this->error_flag = true;
					/** reset */
					$_SESSION['input'][$val] = array();
				}
			}
		}
	}

	/**
	 * 必須項目 画像
	 * @param  string   $action
	 *         string   $image_name
	 *         string   $item_name
	 * @return boolean  $error
	 *         string   $msg
	 */
	function CheckItemNonImage($action, $image_name, $item_name){
		if($action == "add"){
			if(@$_SESSION['input'][$image_name]['tmp_name'] == ""){
				$this->error_msg[] .= sprintf(_ERR_ITEM_NON, $item_name);
				$this->error_flag = true;
				/** reset */
				@$_SESSION['input'][$val] = array();
			}else{
				if(@$_SESSION['input'][$image_name]['delete'] == true){
					$this->error_msg[] .= sprintf(_ERR_ITEM_NON_IMAGE, $item_name);
					$this->error_flag = true;
				}
			}
		}elseif($action == "edit"){
			if(@$_SESSION['input'][$image_name]['upload_name'] == "" && @$_SESSION['input'][$image_name]['tmp_name'] == ""){
				$this->error_msg[] .= sprintf(_ERR_ITEM_NON, $item_name);
				$this->error_flag = true;
				/** reset */
				@$_SESSION['input'][$val] = array();
			}else{
				if(@$_SESSION['input'][$image_name]['delete'] == true){
					$this->error_msg[] .= sprintf(_ERR_ITEM_NON_IMAGE, $item_name);
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * URL
	 * @param  array    $require
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemUrl($require){
		foreach($require as $key => $val){
			if(@$_SESSION['input'][$val]  <> ""){
				if(!ereg("(^|[^=\"'])(https?|ftp|news)(://[[:alnum:]\+\$\;\?\.%,!#~*/:@&=_-]+)", $_SESSION['input'][$val])){
					$this->error_msg[] .= sprintf(_ERR_ITEM_URL, $key);
					$this->error_flag = true;
				}
			}
		}
	}

	/**
	 * zip
	 * @param  array    $zip=array(zip1, zip2)
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemZip($zip){
		if ( @$_SESSION['input'][$zip[0]] <> "" || @$_SESSION['input'][$zip[1]] <> ""){
			$val = $_SESSION['input'][$zip[0]]."-".$_SESSION['input'][$zip[1]];
			if (!ereg ("([0-9]{3})-([0-9]{4})", $val)) {
				$this->error_msg[] .= _ERR_ITEM_ZIP;
				$this->error_flag = true;
			}
		}
	}

	/**
	 * 電話/FAX番号(TEL,fax)
	 * @param  array    $require
	 *         string   $name
	 * @return boolean  $error
	 *         string   $msg
	 */
	function checkItemPhone($require, $name){
		if ( @$_SESSION['input'][$require[0]] <> "" || @$_SESSION['input'][$require[1]] <> "" || @$_SESSION['input'][$require[2]] <> ""){
			$val = $_SESSION['input'][$require[0]]."-".$_SESSION['input'][$require[1]]."-".$_SESSION['input'][$require[2]];
			if (!ereg ("^([0-9]+)-([0-9]+)-([0-9]+)$", $val)) {
				$this->error_msg[] .= sprintf(_ERR_ITEM_PHONE, $name);
				$this->error_flag = true;
			}else{
				if ( strlen(@$_SESSION['input'][$require[0]]) > '6' || strlen(@$_SESSION['input'][$require[1]]) > '6' || strlen(@$_SESSION['input'][$require[2]]) > '6'){
					$this->error_msg[] .= sprintf(_ERR_ITEM_PHONE, $name);
					$this->error_flag = true;
				}
			}
		}
	}
}
?>