<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** ﾕｰｻﾞｰ認証 */
class AuthUser{

	/**
	 * 許可
	 * @var boolean
	 */
	var $auth = true;

	/**
	 * ｴﾗｰ
	 * @var string
	 */
	var $error;

	/**
	 * ﾕｰｻﾞｰcode
	 * @var int
	 */
	var $code;

	/**
	 * ﾕｰｻﾞｰ名
	 * @var string
	 */
	var $name;

	/**
	 * ﾕｰｻﾞｰ権限
	 * @var array
	 */
	var $authority;


	/**
	 * ﾕｰｻﾞｰﾁｪｯｸ
	 * @param  object  dbｵﾌﾞｼﾞｪｸﾄ
	 * @return boolean
	 */
	function userCheck($dbobj,$page_name=""){
		if(@$_REQUEST['login_user'] && !@$_REQUEST['login_psw']){
			$this->auth = false;
			$this->error = Error::ErrorView("0002");
		}elseif(!@$_REQUEST['login_user'] && @$_REQUEST['login_psw']){
			$this->auth = false;
			$this->error = Error::ErrorView("0001");
		}elseif(!@$_REQUEST['login_user'] && !@$_REQUEST['login_psw']){
			$this->auth = false;
			$this->error = "";
		}else{
			$user_setting = $dbobj->dbSelect("select * from \"user\" where user_id='".@$_REQUEST['login_user']."' and pass='".@$_REQUEST['login_psw']."'", "detail");
			if(is_array($user_setting)){
				$_SESSION['auth_key'] = sha1(uniqid().mt_rand(1,999999999)); // keyを生成
				if(@$_REQUEST['cookie'] == "on"){
					$timeoutday=30;//有効期限30日
					$timeout=time()+$timeoutday*86400;
					setcookie('auth_key', $_SESSION['auth_key'], $timeout,'/');
				}else{
					setcookie("auth_key","",0,"/");
				}
				$fields_values = array(
						"user_id"     => $_REQUEST['login_user'],
						"key"         => $_SESSION['auth_key'],
						"expire"      => date('Y-m-d H:i:s',time()+3600*24*30)
						      );
				$dbobj->dbInsert("login_key", $fields_values);
				$this->keyCheck($dbobj,$page_name);
			}else{
				$this->auth = false;
				$this->error = Error::ErrorView("0003");
			}
		}
	}

	/**
	 * ﾕｰｻﾞｰﾁｪｯｸ
	 * @param  object  dbｵﾌﾞｼﾞｪｸﾄ
	 * @return boolean
	 */
	function keyCheck($dbobj,$page_name=""){
		$where = "expire < '".date('Y-m-d H:i:s')."'";
		$dbobj->dbDelete("login_key", $where);
		if(@$this->auth != false){
			$user_key = $dbobj->dbSelect("select * from login_key where key='".$_SESSION['auth_key']."' and expire >='".date('Y-m-d H:i:s')."'", "detail");
			if(is_array($user_key)){
				$user_setting = $dbobj->dbSelect("select * from \"user\" where user_id='".$user_key['user_id']."'", "detail");
				$authority = $this->authorityCheck($dbobj,$page_name,$user_setting['auth']);
				if($authority == 1){
					/** 認証成功 */
					$this->auth = true;
					/** ﾕｰｻﾞｰcode */
					$this->code = $user_setting['user_pkey'];
					/** ﾕｰｻﾞｰ名 */
					$this->name = $user_setting['user_name'];
					/** 組織コード */
					$this->sosiki = $user_setting['sosiki_pkey'];
				}else{
					/** 認証失敗 */
					$this->auth = false;
					$this->error = Error::ErrorView("0009");
				}
			}else{
				$this->auth = false;
				$this->error = "";
				$this->userLogout($dbobj);
			}
		}else{
			$this->userLogout($dbobj);
		}
	}

	/**
	 * ﾛｸﾞｲﾝﾁｪｯｸ
	 * @param  object  dbｵﾌﾞｼﾞｪｸﾄ
	 */	
	function userLogin($dbobj,$page_name=""){
		if(!@$_SESSION['auth_key'] && !@$_COOKIE["auth_key"]){
			$this->userCheck($dbobj,$page_name);
		}elseif(!@$_SESSION['auth_key'] && @$_COOKIE["auth_key"]){
			$_SESSION['auth_key'] = $_COOKIE["auth_key"];
			$this->keyCheck($dbobj,$page_name);
		}else{
			$this->keyCheck($dbobj,$page_name);
		}
	}

	function authorityCheck($dbobj,$page_name="",$group){
		$auth_tbl = $dbobj->dbSelect("select * from \"mt_auth\" where authority_name='".$group."'", "detail");
		$group = $auth_tbl['authority_id'];
		$this->authority = $group;
		$auth_col = explode(",",@$page_name);
		if($auth_col[0] != ""){
			for($i=0; $i<count($auth_col); $i++){
				if($auth_col[$i] == $group){
					return 1;
				}
			}
			return 0;
		}else{
			return 1;
		}
	}

	/**
	 * ﾛｸﾞｱｳﾄ
	 */	
	function userLogout($dbobj){
		$where = "key = '".$_SESSION['auth_key']."'";
		$dbobj->dbDelete("login_key", $where);
		$_SESSION = array();
		setcookie("auth_key","",0,"/");
	}
}
?>