<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** 収集情報管理 */
class InventoryModel extends Model{

	/**
	 * ﾕｰｻﾞｰcode(登録者)
	 * @var int
	 */
	var $authuser_code;

	/**
	 * 一覧
	 */
	function index(){
		$this->tpl->assignHtml('title', _TITLE_INVENTORY);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
			$_REQUEST['search_haiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);
		$this->tpl->assignHtml('search_haiki',@$_REQUEST['search_haiki']);
		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
//			$_REQUEST['sort_name'] = "group1";
			$_REQUEST['sort_name'] = "hardwareno";
			$sort_default = true;
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);
		if($this->sort == 'hardwareno' and $this->asc == "ASC"){
			$this->sort = "LENGTH(hardwareno),hardwareno";
		}elseif($this->sort == 'hardwareno' and $this->asc == "DESC"){
			$this->sort = "LENGTH(hardwareno) DESC,hardwareno";
		}
		if(@$sort_default){
//			$order = " order by group1,LENGTH(hardwareno),hardwareno";
			$order = " order by LENGTH(hardwareno),hardwareno";
		}else{
			$order = " order by ".$this->sort." ".$this->asc;
		}

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "007";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "group1";
				        break;
				    case "002":
					$s_col = "jyotai_name";
				        break;
				    case "003":
					$s_col = "hsyubetu_name";
				        break;
				    case "004":
					$s_col = "hikaku_name";
				        break;
				    case "005":
					$s_col = "collectsource";
				        break;
				    case "006":
					$s_col = "invtraprecvdate";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "007":
					$s_col = "hardwareno";
				        break;
				    case "008":
					$s_col = "computername";
				        break;
				    case "009":
					$s_col = "ipaddress";
				        break;
				    case "010":
					$s_col = "userid";
				        break;
				    case "011":
					$s_col = "hyoujimei";
				        break;
				    case "012":
					$s_col = "machinevendor";
				        break;
				    case "013":
					$s_col = "machinename";
				        break;
				    case "014":
					$s_col = "macaddress";
				        break;
				    case "015":
					$s_col = "osversion";
				        break;
				    case "016":
					$s_col = "program_add_del";
				        break;
				    case "017":
					$s_col = "toolversion";
				        break;
				    case "018":
					$s_col = "bikou";
				        break;
				    case "019":
					$s_col = "memo";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= ")";

		//所属
		$sosiki_name = select_sosiki();
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		if(@$_REQUEST['search_sosiki'] == "on" or $this->authuser_authority != "system"){
			$where .= " and (group1 like '".$sosiki_name[$detail['sosiki_pkey']]."/%' or group1 = '".$sosiki_name[$detail['sosiki_pkey']]."'";
			if(@$_REQUEST['search_sosiki'] != "on"){
				$parent_sosiki_pkey_array = full_sosiki_key($detail['sosiki_pkey']);
				array_pop($parent_sosiki_pkey_array);
				for($i=0; $i<count($parent_sosiki_pkey_array); $i++){
					$where .= " or group1 = '".$sosiki_name[$parent_sosiki_pkey_array[$i]]."'";
				}
				$where .= " or group1 is null";
			}
			$where .= " )";
		}
		
		if(@$_REQUEST['search_haiki'] == "on"){
			$where .= " and jyotai != 'd004'";
		}

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM inventory_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi($list['count'], $count, $url, $param);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM inventory_detail".$where.$order.$limit, "list");
			if(count($list_limit) > 0){
				for($i=0; $i<count($list_limit); $i++){
					/** プログラムの追加と削除での表示 */
					$program_add_del_array = explode("\n",$list_limit[$i]['program_add_del']);
					$list_limit[$i]['program_add_del'] = $program_add_del_array;
					$hardware = $this->db->dbSelect("select * from hard where hard_kanrino = '".$list_limit[$i]['hardwareno']."' and newkbn <> 1", "list");
					if(count($hardware) > 0 ){
						$list_limit[$i]['hard_link'] = true;
					}else{
						$list_limit[$i]['hard_link'] = false;
					}
				}
			}
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		$_SESSION['csv'] = $where.$order;
		$_SESSION['csv_where'] = $where;
		/** set template */
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('inventory/list.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認
	 * 表示
	 */
	function detail(){
		$this->tpl->assignHtml('title', _TITLE_INVENTORY_DETAIL);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$inventory_pkey = addslashes(@$_REQUEST['code']);
		$inventory_detail = $this->db->dbSelect("select * from inventory_detail where inventory_pkey='".$inventory_pkey."'", "detail");
		
		//組織認証
		$inv_sosiki_fullname = $this->db->dbSelect("select * from sosiki where syozoku_fullname='".$inventory_detail['group1']."'", "detail");
		if($this->authuser_authority != 'system'){
			$this->sosiki_auth(array($inv_sosiki_fullname['sosiki_pkey']));
		}
		
		if(count($inventory_detail) > 0){
			$sosiki_detail = $this->db->dbSelect("select sosiki_pkey from hard where hard_kanrino = '".$inventory_detail['hardwareno']."'", "detail");
			$sosiki = $sosiki_detail['sosiki_pkey'];
			$sosiki_list = array();
			if(@$sosiki !== FALSE){
				$sosiki_in = " in(".implode(",",full_sosiki_key($sosiki)).")";
				$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 where licencelist.newkbn <> 1 and licence.sosiki_pkey".$sosiki_in." group by licencelistprogram.program_add_del UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 where licencelist.newkbn <> 1 and licence.sosiki_pkey".$sosiki_in." group by licencelistprogram_down.program_add_del", "list");
				for($k=0; $k<count($program_array); $k++){
					array_push($sosiki_list,$program_array[$k]['program_add_del']);
				}
			}
			$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (((licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade != 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram.program_add_del UNION 
select licencelistprogram_down.program_add_del from (((licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade = 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram_down.program_add_del", "list");
			$pg_list = array();
			for($k=0; $k<count($program_array); $k++){
				$pg_list[] = $program_array[$k]['program_add_del'];
			}
			#齟齬チェック対象外ライセンス種類
			$type_array = $this->db->dbSelect("select * from code where code_bunrui = '00029' order by code_sort", "list");
			$type_in =array();
			$target_type = "";
			if(count($type_array) > 0){
				for($k=0; $k<count($type_array); $k++){
					$type_in[] = "'".$type_array[$k]['code_name']."'";
				}
				$target_type = "(".implode(",",$type_in).")";
			}
			$target_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." and licencelist.newkbn <> 1 and licencelist.yukou = 'd001' UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." and licencelist.newkbn <> 1 and licencelist.yukou = 'd001'","list");
			$target_soft = array();
			for($k=0; $k<count($target_array); $k++){
				$target_soft[] = $target_array[$k]['program_add_del'];
			}

			$program_add_del = array();
			if($inventory_detail['hardwareno'] != ""){
				$program_add_del_array = $this->db->dbSelect("select * from inventorysoft where hardwareno='".$inventory_detail['hardwareno']."' order by lower(insapname)", "list");
				for($i=0;$i<count($program_add_del_array);$i++){
					$name = $program_add_del_array[$i]['insapname'];
					if(in_array($program_add_del_array[$i]['insapname'],$target_soft)){
						$type = "driver";
					}elseif(in_array($program_add_del_array[$i]['insapname'],$pg_list) and in_array($program_add_del_array[$i]['insapname'],$sosiki_list)){
						$type = "true";
					}else{
						$type = "false";
					}
					$program_add_del[] = array("name"=>$name,"type"=>$type);
				}
				$hardware = $this->db->dbSelect("select * from hard where hard_kanrino = '".$inventory_detail['hardwareno']."' and newkbn <> 1", "list");
				if(count($hardware) > 0 ){
					$inventory_detail['hard_link'] = true;
				}else{
					$inventory_detail['hard_link'] = false;
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;
		/** 出力 */
		$this->tpl->assignHtml('item',   @$inventory_detail);
		$this->tpl->assignHtml('detail', @$inventory_detail);
		$this->tpl->assignHtml('program_add_del', @$program_add_del);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPVIEW);
		$this->tpl->assignHtml('action_param','view');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('inventory/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 入力
	 */
	function edit(){
		$this->tpl->assignHtml('title', _TITLE_INVENTORY_INPUT);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$inventory_pkey = @$_SESSION['input']['inventory_pkey'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$inventory_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from inventory_detail where inventory_pkey='".$inventory_pkey."'", "detail");
		
			//組織認証
			$inv_sosiki_fullname = $this->db->dbSelect("select * from sosiki where syozoku_fullname='".$detail['group1']."'", "detail");
			if($this->authuser_authority != 'system'){
				$this->sosiki_auth(array($inv_sosiki_fullname['sosiki_pkey']));
			}
		
			$item = @$detail;
			$user_referer = _USER_REFERER;
		}
		$inventory_detail = $this->db->dbSelect("select * from inventory_detail where inventory_pkey='".$inventory_pkey."'", "detail");
		$program_add_del = array();

		if(count($inventory_detail) > 0){
			$sosiki_detail = $this->db->dbSelect("select sosiki_pkey from hard where hard_kanrino = '".$inventory_detail['hardwareno']."'", "detail");
			$sosiki = $sosiki_detail['sosiki_pkey'];
			$sosiki_list = array();
			if(@$sosiki !== FALSE){
				$sosiki_in = " in(".implode(",",full_sosiki_key($sosiki)).")";
				$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 where licencelist.newkbn <> 1 and licence.sosiki_pkey".$sosiki_in." group by licencelistprogram.program_add_del UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 where licencelist.newkbn <> 1 and licence.sosiki_pkey".$sosiki_in." group by licencelistprogram_down.program_add_del", "list");
				for($k=0; $k<count($program_array); $k++){
					array_push($sosiki_list,$program_array[$k]['program_add_del']);
				}
			}
			$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (((licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade != 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram.program_add_del UNION 
select licencelistprogram_down.program_add_del from (((licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade = 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram_down.program_add_del", "list");
			$pg_list = array();
			for($k=0; $k<count($program_array); $k++){
				$pg_list[] = $program_array[$k]['program_add_del'];
			}
			#齟齬チェック対象外ライセンス種類
			$type_array = $this->db->dbSelect("select * from code where code_bunrui = '00029' order by code_sort", "list");
			$type_in =array();
			$target_type = "";
			if(count($type_array) > 0){
				for($k=0; $k<count($type_array); $k++){
					$type_in[] = "'".$type_array[$k]['code_name']."'";
				}
				$target_type = "(".implode(",",$type_in).")";
			}
			$target_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." and licencelist.newkbn <> 1 and licencelist.yukou = 'd001' UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." and licencelist.newkbn <> 1 and licencelist.yukou = 'd001'","list");
			$target_soft = array();
			for($k=0; $k<count($target_array); $k++){
				$target_soft[] = $target_array[$k]['program_add_del'];
			}

			$program_add_del = array();
			if($inventory_detail['hardwareno'] != ""){
				$program_add_del_array = $this->db->dbSelect("select * from inventorysoft where hardwareno='".$inventory_detail['hardwareno']."' order by lower(insapname)", "list");
				for($i=0;$i<count($program_add_del_array);$i++){
					$name = $program_add_del_array[$i]['insapname'];
					if(in_array($program_add_del_array[$i]['insapname'],$target_soft)){
						$type = "driver";
					}elseif(in_array($program_add_del_array[$i]['insapname'],$pg_list) and in_array($program_add_del_array[$i]['insapname'],$sosiki_list)){
						$type = "true";
					}else{
						$type = "false";
					}
					$program_add_del[] = array("name"=>$name,"type"=>$type);
				}
				$hardware = $this->db->dbSelect("select * from hard where hard_kanrino = '".$inventory_detail['hardwareno']."' and newkbn <> 1", "list");
				if(count($hardware) > 0 ){
					$inventory_detail['hard_link'] = true;
				}else{
					$inventory_detail['hard_link'] = false;
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('detail', @$inventory_detail);
		$this->tpl->assignHtml('program_add_del', @$program_add_del);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('inventory/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認
	 */
	function edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_INVENTORY_INPUT);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		$inventory_pkey = @$_SESSION['input']['inventory_pkey'];
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		$inventory_detail = $this->db->dbSelect("select * from inventory_detail where inventory_pkey='".$inventory_pkey."'", "detail");
		$program_add_del = array();
		if(count($inventory_detail) > 0){
			$sosiki_detail = $this->db->dbSelect("select sosiki_pkey from hard where hard_kanrino = '".$inventory_detail['hardwareno']."'", "detail");
			$sosiki = $sosiki_detail['sosiki_pkey'];
			$sosiki_list = array();
			if(@$sosiki !== FALSE){
				$sosiki_in = " in(".implode(",",full_sosiki_key($sosiki)).")";
				$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 where licencelist.newkbn <> 1 and licence.sosiki_pkey".$sosiki_in." group by licencelistprogram.program_add_del UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 where licencelist.newkbn <> 1 and licence.sosiki_pkey".$sosiki_in." group by licencelistprogram_down.program_add_del", "list");
				for($k=0; $k<count($program_array); $k++){
					array_push($sosiki_list,$program_array[$k]['program_add_del']);
				}
			}
			$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (((licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade != 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram.program_add_del UNION 
select licencelistprogram_down.program_add_del from (((licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade = 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram_down.program_add_del", "list");
			$pg_list = array();
			for($k=0; $k<count($program_array); $k++){
				$pg_list[] = $program_array[$k]['program_add_del'];
			}
			#齟齬チェック対象外ライセンス種類
			$type_array = $this->db->dbSelect("select * from code where code_bunrui = '00029' order by code_sort", "list");
			$type_in =array();
			$target_type = "";
			if(count($type_array) > 0){
				for($k=0; $k<count($type_array); $k++){
					$type_in[] = "'".$type_array[$k]['code_name']."'";
				}
				$target_type = "(".implode(",",$type_in).")";
			}
			$target_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." and licencelist.newkbn <> 1 and licencelist.yukou = 'd001' UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." and licencelist.newkbn <> 1 and licencelist.yukou = 'd001'","list");
			$target_soft = array();
			for($k=0; $k<count($target_array); $k++){
				$target_soft[] = $target_array[$k]['program_add_del'];
			}

			$program_add_del = array();
			if($inventory_detail['hardwareno'] != ""){
				$program_add_del_array = $this->db->dbSelect("select * from inventorysoft where hardwareno='".$inventory_detail['hardwareno']."' order by lower(insapname)", "list");
				for($i=0;$i<count($program_add_del_array);$i++){
					$name = $program_add_del_array[$i]['insapname'];
					if(in_array($program_add_del_array[$i]['insapname'],$target_soft)){
						$type = "driver";
					}elseif(in_array($program_add_del_array[$i]['insapname'],$pg_list) and in_array($program_add_del_array[$i]['insapname'],$sosiki_list)){
						$type = "true";
					}else{
						$type = "false";
					}
					$program_add_del[] = array("name"=>$name,"type"=>$type);
				}
				$hardware = $this->db->dbSelect("select * from hard where hard_kanrino = '".$inventory_detail['hardwareno']."' and newkbn <> 1", "list");
				if(count($hardware) > 0 ){
					$inventory_detail['hard_link'] = true;
				}else{
					$inventory_detail['hard_link'] = false;
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('detail', @$inventory_detail);
		$this->tpl->assignHtml('program_add_del', @$program_add_del);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('inventory/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function edit_done(){
		$page_name = "system,syonin";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */
		$inventory_pkey = addslashes($_SESSION['input']['inventory_pkey']);
		$inventory_detail = $this->db->dbSelect("select * from inventory_detail where inventory_pkey='".$inventory_pkey."'", "detail");
		$where = "inventory_pkey = ".$inventory_pkey;

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			if($this->authuser_authority != 'system'){
				$_SESSION['input']['memo'] = $inventory_detail['memo'];
			}
			/** 登録 */
			$fields_values = array(
					"group1"            => $_SESSION['input']['group1'],     
					"jyotai"            => $_SESSION['input']['jyotai'],     
					"hsyubetu"          => $_SESSION['input']['hsyubetu'],     
					"hikaku"            => $_SESSION['input']['hikaku'],
					"bikou"             => $_SESSION['input']['bikou'],
					"memo"              => $_SESSION['input']['memo'],
					"mukou_date"        => date("Y/m/d")
					      );
			$this->db->dbUpdate("\"inventory\"", $fields_values, $where);

		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$inventory_detail['hardwareno']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action',"edit");
		$this->tpl->assignHtml('code',$inventory_pkey);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 削除
	 * 確認
	 */
	function del(){
		$this->tpl->assignHtml('title', _TITLE_INVENTORY_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$inventory_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['inventory_pkey']    = $inventory_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		/** 詳細ﾃﾞｰﾀ */
		$inventory_detail = $this->db->dbSelect("select * from inventory_detail where inventory_pkey='".$inventory_pkey."'", "detail");
		if(count($inventory_detail) > 0){
			$sosiki_detail = $this->db->dbSelect("select sosiki_pkey from hard where hard_kanrino = '".$inventory_detail['hardwareno']."'", "detail");
			$sosiki = $sosiki_detail['sosiki_pkey'];
			$sosiki_list = array();
			if(@$sosiki !== FALSE){
				$sosiki_in = " in(".implode(",",full_sosiki_key($sosiki)).")";
				$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 where licencelist.newkbn <> 1 and licence.sosiki_pkey".$sosiki_in." group by licencelistprogram.program_add_del UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 where licencelist.newkbn <> 1 and licence.sosiki_pkey".$sosiki_in." group by licencelistprogram_down.program_add_del", "list");
				for($k=0; $k<count($program_array); $k++){
					array_push($sosiki_list,$program_array[$k]['program_add_del']);
				}
			}
			$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (((licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade != 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram.program_add_del UNION 
select licencelistprogram_down.program_add_del from (((licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey and licencelist.yukou = 'd001') LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade = 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram_down.program_add_del", "list");
			$pg_list = array();
			for($k=0; $k<count($program_array); $k++){
				$pg_list[] = $program_array[$k]['program_add_del'];
			}
			#齟齬チェック対象外ライセンス種類
			$type_array = $this->db->dbSelect("select * from code where code_bunrui = '00029' order by code_sort", "list");
			$type_in =array();
			$target_type = "";
			if(count($type_array) > 0){
				for($k=0; $k<count($type_array); $k++){
					$type_in[] = "'".$type_array[$k]['code_name']."'";
				}
				$target_type = "(".implode(",",$type_in).")";
			}
			$target_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." and licencelist.newkbn <> 1 and licencelist.yukou = 'd001' UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." and licencelist.newkbn <> 1 and licencelist.yukou = 'd001'","list");
			$target_soft = array();
			for($k=0; $k<count($target_array); $k++){
				$target_soft[] = $target_array[$k]['program_add_del'];
			}

			$program_add_del = array();
			if($inventory_detail['hardwareno'] != ""){
				$program_add_del_array = $this->db->dbSelect("select * from inventorysoft where hardwareno='".$inventory_detail['hardwareno']."' order by lower(insapname)", "list");
				for($i=0;$i<count($program_add_del_array);$i++){
					$name = $program_add_del_array[$i]['insapname'];
					if(in_array($program_add_del_array[$i]['insapname'],$target_soft)){
						$type = "driver";
					}elseif(in_array($program_add_del_array[$i]['insapname'],$pg_list) and in_array($program_add_del_array[$i]['insapname'],$sosiki_list)){
						$type = "true";
					}else{
						$type = "false";
					}
					$program_add_del[] = array("name"=>$name,"type"=>$type);
				}
				$hardware = $this->db->dbSelect("select * from hard where hard_kanrino = '".$inventory_detail['hardwareno']."' and newkbn <> 1", "list");
				if(count($hardware) > 0 ){
					$inventory_detail['hard_link'] = true;
				}else{
					$inventory_detail['hard_link'] = false;
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   @$inventory_detail);
		$this->tpl->assignHtml('detail', @$inventory_detail);
		$this->tpl->assignHtml('program_add_del', @$program_add_del);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('inventory/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$inventory_pkey = addslashes(@$_SESSION['input']['inventory_pkey']);
		$where = "inventory_pkey = ".$inventory_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select hardwareno from \"inventory\" where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['hardwareno']);
			/** 削除 */
			$this->db->dbDelete("\"inventory\"", $where);
			$this->db->dbDelete("\"inventorysoft\"", "hardwareno = '".$detail['hardwareno']."'");
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check(){
		
		#入力チェック(警告)
		$cci_att = new CheckItem;
		
		if($_SESSION['input']['hikaku'] == 'd002' and _ERROR_0281){
			$cci_att->checkErrorCode("0281");
		}
		
		if($cci_att->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['att_flag']  = true;
			$_SESSION['input']['att_msg']   = $cci_att->error_msg;
		}
		
		
		#入力チェック
		$cci = new CheckItem;

		$error_name_array = select_code("00014");

		$cci->checkItemNon(array("group1"=>$error_name_array['001']));
		
		if($_SESSION['input']['jyotai'] != 'd004' and $_SESSION['input']['hsyubetu'] == 'd003' and _ERROR_0280){
			$cci->checkErrorCode("0280");
		}
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "";
		$this->login($page_name);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_name = select_sosiki();
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			if(@$_REQUEST['search_sosiki'] == "on" or $this->authuser_authority != "system"){
				$_SESSION['csv'] = " where group1 like '".$sosiki_name[$detail['sosiki_pkey']]."%' and jyotai != 'd004'";
			}else{
				$_SESSION['csv'] = " where jyotai != 'd004'";
			}
		}

		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=inventory.csv");

		$list = $this->db->dbSelect("SELECT * FROM inventory_detail".$_SESSION['csv'], "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		print mb_convert_encoding($this->tpl->fetchHtml('inventory/csv.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * csv出力
	 */
	function p_csv(){
		$page_name = "";
		$this->login($page_name);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_name = select_sosiki();
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			if(@$_REQUEST['search_sosiki'] == "on" or $this->authuser_authority != "system"){
				$_SESSION['csv_where'] = " where group1 like '".$sosiki_name[$detail['sosiki_pkey']]."%' and jyotai != 'd004'";
			}else{
				$_SESSION['csv_where'] = " where jyotai != 'd004'";
			}
		}

		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=inventorysoft.csv");

		$list = $this->db->dbSelect("SELECT * FROM inventorysoft_csv".$_SESSION['csv_where']." order by hardwareno", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		print mb_convert_encoding($this->tpl->fetchHtml('inventory/p_csv.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * プリント出力
	 */
	function prt(){
		$page_name = "";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_INVENTORY);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_name = select_sosiki();
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			if(@$_REQUEST['search_sosiki'] == "on" or $this->authuser_authority != "system"){
				$_SESSION['csv'] = " where group1 like '".$sosiki_name[$detail['sosiki_pkey']]."%' and jyotai != 'd004'";
			}else{
				$_SESSION['csv'] = " where jyotai != 'd004'";
			}
		}

		$list = $this->db->dbSelect("SELECT * FROM inventory_detail".$_SESSION['csv'], "list");
		if(count($list) > 0){
			for($i=0; $i<count($list); $i++){
				/** プログラムの追加と削除での表示 */
				$program_add_del_array = explode("\n",$list[$i]['program_add_del']);
				$list[$i]['program_add_del'] = $program_add_del_array;
			}
		}
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('list_view',$list);
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('inventory/print.html'));
		$this->tpl->outputHtml('print_list.html');

	}

	/**
	 * 詳細印刷
	 */
	function d_print(){
		$this->tpl->assignHtml('title', _TITLE_INVENTORY_DETAIL);
		$page_name = "";
		$this->login($page_name);

		$inventory_pkey = addslashes(@$_REQUEST['code']);
		$inventory_detail = $this->db->dbSelect("select * from inventory_detail where inventory_pkey='".$inventory_pkey."'", "detail");
		
		//組織認証
		$inv_sosiki_fullname = $this->db->dbSelect("select * from sosiki where syozoku_fullname='".$inventory_detail['group1']."'", "detail");
		if($this->authuser_authority != 'system'){
			$this->sosiki_auth(array($inv_sosiki_fullname['sosiki_pkey']));
		}
		
		if(count($inventory_detail) > 0){
			$program_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (((licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey) LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade != 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram.program_add_del UNION 
select licencelistprogram_down.program_add_del from (((licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey) LEFT JOIN licence ON licencelist.licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1 )  LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1 and soft.downgrade = 'd001' ) LEFT JOIN hard ON soft.hard_pkey =  hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1 where licencelist.newkbn <> 1 and hard.hard_kanrino = '".$inventory_detail['hardwareno']."' group by licencelistprogram_down.program_add_del", "list");
			$pg_list = array();
			for($k=0; $k<count($program_array); $k++){
				$pg_list[] = $program_array[$k]['program_add_del'];
			}

			#齟齬チェック対象外ライセンス種類
			$type_array = $this->db->dbSelect("select * from code where code_bunrui = '00029' order by code_sort", "list");
			$type_in =array();
			$target_type = "";
			if(count($type_array) > 0){
				for($k=0; $k<count($type_array); $k++){
					$type_in[] = "'".$type_array[$k]['code_name']."'";
				}
				$target_type = "(".implode(",",$type_in).")";
			}
			$target_array = $this->db->dbSelect("select licencelistprogram.program_add_del from (licencelistprogram LEFT JOIN licencelist ON licencelistprogram.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type." UNION select licencelistprogram_down.program_add_del from (licencelistprogram_down LEFT JOIN licencelist ON licencelistprogram_down.licencelist_pkey = licencelist.licencelist_pkey) where licencelist.licence_keitai in ".$target_type,"list");
			$target_soft = array();
			for($k=0; $k<count($target_array); $k++){
				$target_soft[] = $target_array[$k]['program_add_del'];
			}

			$program_add_del = array();
			if($inventory_detail['hardwareno'] != ""){
				$program_add_del_array = $this->db->dbSelect("select * from inventorysoft where hardwareno='".$inventory_detail['hardwareno']."' order by lower(insapname)", "list");
				for($i=0;$i<count($program_add_del_array);$i++){
					$name = $program_add_del_array[$i]['insapname'];
					if(in_array($program_add_del_array[$i]['insapname'],$pg_list)){
						$type = "true";
					}elseif(in_array($program_add_del_array[$i]['insapname'],$target_soft)){
						$type = "driver";
					}else{
						$type = "false";
					}
					$program_add_del[] = array("name"=>$name,"type"=>$type);
				}
			}
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   @$inventory_detail);
		$this->tpl->assignHtml('detail', @$inventory_detail);
		$this->tpl->assignHtml('program_add_del', @$program_add_del);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('action_name',_ACTION_APPVIEW);
		$this->tpl->assignHtml('action_param','view');

		/** set template */
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('inventory/print_detail.html'));
		$this->tpl->outputHtml('print_sinsei.html');
	}
}

?>