<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

class InvModel extends Model{

	/**
	 * エラーメッセージ
	 */
	var $error_message = array();

	function inv_start(){
		//取り込み開始処理
		$where_date = "invbunrui = 1";
		$fields_values = array(
				"invstart"   => date("Y/m/d H:i:s"),
				"invend"     => null
		);
		$this->db->dbUpdate("inventorydate", $fields_values, $where_date);
		//バッチログリセット
		$where_date = "1 = 1";
		$fields_values = array(
				"end_date"   => null
		);
		$this->db->dbUpdate("bat_log", $fields_values, $where_date);
		//バッチログセット
		$this->set_bat_log(1);
	}
	
	function inv_end(){
		//取り込み終了処理
		$this->error_mail_send();
		$this->inv_end_time_set();
		//バッチログセット
		$this->set_bat_log(6);
	}
	
	function inv(){
		/** ﾃﾞｨﾚｸﾄﾘ読込 */
		$ap_name = "allinsap.csv";
		$inv_name = "allinventory.csv";

		if(!file_exists(_CSV_ALL_PATH)){
			array_push($this->error_message ,_CSV_ALL_PATH."が見つかりません");
			$this->error_mail_send();
			//バッチログセット
			$this->set_bat_log(2);
			exit();
		}
		if(!file_exists(_CSV_ALL_PATH."/".$ap_name)){
			array_push($this->error_message ,$ap_name."が見つかりません");
			$this->error_mail_send();
			//バッチログセット
			$this->set_bat_log(2);
			exit();
		}
		if(!file_exists(_CSV_ALL_PATH."/".$inv_name)){
			array_push($this->error_message ,$inv_name."が見つかりません");
			$this->error_mail_send();
			//バッチログセット
			$this->set_bat_log(2);
			exit();
		}
		$buf_ap = mb_convert_encoding(@file_get_contents(_CSV_ALL_PATH."/".$ap_name),"utf-8", "SJIS-win");
		$fp_ap = tmpfile();
		fwrite($fp_ap, $buf_ap);
		rewind($fp_ap);
		$ap_array = array();
		$search_col = select_code("00028");
		while(!feof($fp_ap)){
			$str_ap = fgetExcelCSV($fp_ap);
			if(is_array($str_ap)){
				$ap_id = $str_ap['0']."_".$str_ap['1'];
				if($this->ap_check($str_ap[5],$search_col)){
					if($str_ap[2] != ""){
						$hardno = $str_ap[2];
					}else{
						$hardno = $str_ap[3];
					}
					$ap_array[$ap_id][] = array($hardno,$str_ap[5]);
				}
			}
			unset($ap_id);
			unset($str_ap);
		}
		fclose($fp_ap);
		$buf_inv = mb_convert_encoding(@file_get_contents(_CSV_ALL_PATH."/".$inv_name),"utf-8", "SJIS-win");
		$fp_inv = tmpfile();
		fwrite($fp_inv, $buf_inv);
		rewind($fp_inv);
		$inv_array = array();
		while(!feof($fp_inv)){
			$str_inv = fgetExcelCSV($fp_inv);
			if(is_array($str_inv)){
				$ins_flag = $this->inv_ins($str_inv,"all");
				if($ins_flag){
					if($str_inv[4] != ""){
						$where = "hardwareno = '".$str_inv[4]."'";
						$hardno = $str_inv[4];
					}else{
						$where = "hardwareno = '".$str_inv[9]."'";
						$hardno = $str_inv[9];
					}
					$this->db->dbDelete("\"inventorysoft\"", $where);

					$alm_id = $str_inv['0']."_".$str_inv['1'];
					unset($where);
					if(@$str_inv[31] != ''){
						$os_array = explode("  ",$str_inv[31]);
						$ap_array[$alm_id][] = array($hardno,$os_array[0]);
					}
					if(count($ap_array[$alm_id])>0){
						$fields_values = array();
						$validate_error = true;
						for($i=0; $i<count($ap_array[$alm_id]); $i++){
							$fields_values = array(
									"hardwareno"           => $ap_array[$alm_id][$i][0],
									"insapname"            => $ap_array[$alm_id][$i][1]
									      );
							if(!$this->ap_validate($fields_values)){
								$validate_error = false;
							}
						}
					}

					if($validate_error){
						$this->db->dbPrepare("INSERT INTO inventorysoft (hardwareno, insapname) VALUES (?,?)", $ap_array[$alm_id]);
						if($this->db->error != ""){
							array_push($this->error_message ,$this->db->error." ".$name." INSERT INTO inventorysoft ".$hardno);
						}
					}
					unset($ap_array[$alm_id]);
					unset($list);
				}
				unset($ins_flag);
			}
			unset($str_inv);
		}
		fclose($fp_inv);
		
		$inv_name = "adlist.csv";
		if(!file_exists(_CSV_ALL_PATH."/".$inv_name)){
			array_push($this->error_message ,_CSV_ALL_PATH."/".$inv_name."が見つかりません");
		}
		$buf_inv = mb_convert_encoding(@file_get_contents(_CSV_ALL_PATH."/".$inv_name),"utf-8", "SJIS-win");
		$fp_inv = tmpfile();
		fwrite($fp_inv, $buf_inv);
		rewind($fp_inv);
		$inv_array = array();
		while(!feof($fp_inv)){
			$str_inv = fgetExcelCSV($fp_inv);
			if(is_array($str_inv)){
				$this->ad_ins($str_inv);
print $str_inv[0]."\n";
			}
		}
		fclose($fp_inv);
		$this->db->dbDelete("program", "1=1");
		$softname_list = $this->db->dbSelect("select insapname from inventorysoft group by insapname", "list");
		$softname = array();
		for($i=0; $i<count($softname_list); $i++){
			if($softname_list[$i]['insapname'] != ""){
				$softname[] = array($softname_list[$i]['insapname']);
			}
		}
		$this->db->dbPrepare("INSERT INTO program (program_add_del) VALUES (?)", $softname);
		unset($softname_list);
		unset($softname);
		
		unset($buf_inv);
		unset($buf_ap);
		@unlink(_CSV_ALL_PATH."/allinventory.csv");
		@unlink(_CSV_ALL_PATH."/allinsap.csv");
		@unlink(_CSV_ALL_PATH."/adlist.csv");

		$this->error_mail_send();
		//バッチログセット
		$this->set_bat_log(2);
	}

	function new_type(){
		/** ﾃﾞｨﾚｸﾄﾘ読込 */
		$ap_name = "allinsap.csv";
		$inv_name = "allinventory.csv";

		if(!file_exists(_CSV_ALL_PATH)){
			array_push($this->error_message ,_CSV_ALL_PATH."が見つかりません");
			$this->error_mail_send();
			$this->inv_end_time_set();
			exit();
		}
		if(!file_exists(_CSV_ALL_PATH."/".$ap_name)){
			array_push($this->error_message ,$ap_name."が見つかりません");
			$this->error_mail_send();
			$this->inv_end_time_set();
			exit();
		}
		if(!file_exists(_CSV_ALL_PATH."/".$inv_name)){
			array_push($this->error_message ,$inv_name."が見つかりません");
			$this->error_mail_send();
			$this->inv_end_time_set();
			exit();
		}
		$buf_ap = mb_convert_encoding(@file_get_contents(_CSV_ALL_PATH."/".$ap_name),"utf-8", "SJIS-win");
		$fp_ap = tmpfile();
		fwrite($fp_ap, $buf_ap);
		rewind($fp_ap);
		$ap_array = array();
		$search_col = select_code("00028");
		while(!feof($fp_ap)){
			$str_ap = fgetExcelCSV($fp_ap);
			if(is_array($str_ap)){
				$ap_id = $str_ap['0']."_".$str_ap['1'];
				if($this->ap_check($str_ap[5],$search_col)){
					if($str_ap[2] != ""){
						$hardno = $str_ap[2];
					}else{
						$hardno = $str_ap[3];
					}
					$ap_array[$ap_id][] = array($hardno,$str_ap[5]);
				}
			}
			unset($ap_id);
			unset($str_ap);
		}
		fclose($fp_ap);
		$buf_inv = mb_convert_encoding(@file_get_contents(_CSV_ALL_PATH."/".$inv_name),"utf-8", "SJIS-win");
		$fp_inv = tmpfile();
		fwrite($fp_inv, $buf_inv);
		rewind($fp_inv);
		$inv_array = array();
		while(!feof($fp_inv)){
			$str_inv = fgetExcelCSV($fp_inv);
			if(is_array($str_inv)){
				$ins_flag = $this->inv_ins($str_inv,"all");
				if($ins_flag){
					if($str_inv[4] != ""){
						$where = "hardwareno = '".$str_inv[4]."'";
						$hardno = $str_inv[4];
					}else{
						$where = "hardwareno = '".$str_inv[9]."'";
						$hardno = $str_inv[9];
					}
					$this->db->dbDelete("\"inventorysoft\"", $where);

					$alm_id = $str_inv['0']."_".$str_inv['1'];
					unset($where);
					if(@$str_inv[31] != ''){
						$os_array = explode("  ",$str_inv[31]);
						$ap_array[$alm_id][] = array($hardno,$os_array[0]);
					}
					if(count($ap_array[$alm_id])>0){
						$fields_values = array();
						$validate_error = true;
						for($i=0; $i<count($ap_array[$alm_id]); $i++){
							$fields_values = array(
									"hardwareno"           => $ap_array[$alm_id][$i][0],
									"insapname"            => $ap_array[$alm_id][$i][1]
									      );
							if(!$this->ap_validate($fields_values)){
								$validate_error = false;
							}
						}
					}

					if($validate_error){
						$this->db->dbPrepare("INSERT INTO inventorysoft (hardwareno, insapname) VALUES (?,?)", $ap_array[$alm_id]);
						if($this->db->error != ""){
							array_push($this->error_message ,$this->db->error." ".$name." INSERT INTO inventorysoft ".$hardno);
						}
					}
					unset($ap_array[$alm_id]);
					unset($list);
				}
				unset($ins_flag);
			}
			unset($str_inv);
		}
		fclose($fp_inv);
		
		$inv_name = "adlist.csv";
		if(!file_exists(_CSV_ALL_PATH."/".$inv_name)){
			array_push($this->error_message ,_CSV_ALL_PATH."/".$inv_name."が見つかりません");
		}
		$buf_inv = mb_convert_encoding(@file_get_contents(_CSV_ALL_PATH."/".$inv_name),"utf-8", "SJIS-win");
		$fp_inv = tmpfile();
		fwrite($fp_inv, $buf_inv);
		rewind($fp_inv);
		$inv_array = array();
		while(!feof($fp_inv)){
			$str_inv = fgetExcelCSV($fp_inv);
			if(is_array($str_inv)){
				$this->ad_ins($str_inv);
print $str_inv[0]."\n";
			}
		}
		fclose($fp_inv);
		$this->db->dbDelete("program", "1=1");
		$softname_list = $this->db->dbSelect("select insapname from inventorysoft group by insapname", "list");
		$softname = array();
		for($i=0; $i<count($softname_list); $i++){
			if($softname_list[$i]['insapname'] != ""){
				$softname[] = array($softname_list[$i]['insapname']);
			}
		}
		$this->db->dbPrepare("INSERT INTO program (program_add_del) VALUES (?)", $softname);
		unset($softname_list);
		unset($softname);
		
		unset($buf_inv);
		unset($buf_ap);
		@unlink(_CSV_ALL_PATH."/allinventory.csv");
		@unlink(_CSV_ALL_PATH."/allinsap.csv");
		@unlink(_CSV_ALL_PATH."/adlist.csv");

		$this->error_mail_send();
	}

	function invsoft(){
		$inv_date_list = $this->db->dbSelect("select * from inventorydate where invend is null and invbunrui in(1,2)", "list");
		$search_col = select_code("00028");
		if(count($inv_date_list) <= 0){
			//チェック開始処理
			$where_date = "invbunrui = 2";
			$fields_values = array(
					"invstart"   => date("Y/m/d H:i:s"),
					"invend"     => null
			);
			$this->db->dbUpdate("inventorydate", $fields_values, $where_date);
			/** ﾃﾞｨﾚｸﾄﾘ読込 */
			for($j=1; $j<=7; $j++){
				$inv_name = "inventory".$j.".csv";
				$buf_inv = mb_convert_encoding(@file_get_contents(_CSV_SUB_PATH."/".$inv_name),"utf-8", "SJIS-win");
				$fp_inv = tmpfile();
				fwrite($fp_inv, $buf_inv);
				rewind($fp_inv);
				$inv_array = array();
				while(!feof($fp_inv)){
					$str_inv = fgetExcelCSV($fp_inv);
					if(is_array($str_inv)){
						$inv_id = $str_inv['0']."_".$str_inv['1'];
						$inv_array[$inv_id] = $str_inv;
					}
				}
				fclose($fp_inv);
				$ap_name = "insap".$j.".csv";
				$buf_ap = mb_convert_encoding(@file_get_contents(_CSV_SUB_PATH."/".$ap_name),"utf-8", "SJIS-win");
				$fp_ap = tmpfile();
				fwrite($fp_ap, $buf_ap);
				rewind($fp_ap);
				$ap_array = array();
				while(!feof($fp_ap)){
					$str_ap = fgetExcelCSV($fp_ap);
					if(is_array($str_ap)){
						$ap_id = $str_ap['0']."_".$str_ap['1'];
						$ap_array[$ap_id][] = $str_ap;
					}
				}
				fclose($fp_ap);
				$apalm_name = "apalm".$j.".csv";
				$buf = mb_convert_encoding(@file_get_contents(_CSV_SUB_PATH."/".$apalm_name),"utf-8", "SJIS-win");
				$fp = tmpfile();
				fwrite($fp, $buf);
				rewind($fp);
				$csv_data = array();
				while(!feof($fp)){
					$str = fgetExcelCSV($fp);
					if(is_array($str)){
						$allinv_date = $this->db->dbSelect("select * from inventorydate where invend < '".$str[1]."' and invbunrui = 1", "list");
						if(count($allinv_date) > 0){
							$alm_id = $str['0']."_".$str['2'];
							unset($str);
							$ins_flag = $this->inv_ins($inv_array[$alm_id],"soft");
							if($ins_flag){
								if($inv_array[$alm_id][4] != ""){
									$where = "hardwareno = '".$inv_array[$alm_id][4]."'";
									$hardno = $inv_array[$alm_id][4];
								}else{
									$where = "hardwareno = '".$inv_array[$alm_id][9]."'";
									$hardno = $inv_array[$alm_id][9];
								}
								if(@$inv_array[$alm_id][31] != ''){
									$os_array = explode("  ",$inv_array[$alm_id][31]);
									$ap_array[$alm_id][] = array("","",$inv_array[$alm_id][4],$inv_array[$alm_id][9],"",$os_array[0]);
								}
								
								$this->db->dbDelete("\"inventorysoft\"", $where);
								for($l=0; $l<count($ap_array[$alm_id]); $l++){
									if($ap_array[$alm_id][$l][2] != ""){
										$hardno = $ap_array[$alm_id][$l][2];
									}else{
										$hardno = $ap_array[$alm_id][$l][3];
									}
									if(is_array($ap_array[$alm_id][$l]) AND $hardno != ""){
									    	$this->soft_check($hardno,$ap_array[$alm_id][$l][5],$search_col);
										unset($hardno);
									}
								}
								unset($ap_array[$alm_id]);
							}
						}
					}
				}
				fclose($fp);
				@unlink(_CSV_SUB_PATH."/".$inv_name);
				@unlink(_CSV_SUB_PATH."/".$ap_name);
				@unlink(_CSV_SUB_PATH."/".$apalm_name);
			}

			require_once(_HCMS_PATH."/inv.model.php");
			$sogo = new SogoCheckModel();
			/** db */
			$sogo->makeDbObject();
			$sogo->getDbSystemSetting();
			/** バリテーション */
			$sogo->validators();
			/** ｱｸｼｮﾝ ｸﾗｽﾒｿｯﾄﾞ実行 */
			$sogo->runMethod("inv_check_ready");


			$fields_values = array(
					"invend"     => date("Y/m/d H:i:s")
			);
			$this->db->dbUpdate("inventorydate", $fields_values, $where_date);
		}
	}
	
	function usb(){
		$inv_date_list = $this->db->dbSelect("select * from inventorydate where invend is null and invbunrui = 3", "list");
		$search_col = select_code("00028");
		if(count($inv_date_list) <= 0){
			//チェック開始処理
			$where = "invbunrui = 3";
			$fields_values = array(
					"invstart"   => date("Y/m/d H:i:s"),
					"invend"     => null
			);
			$this->db->dbUpdate("inventorydate", $fields_values, $where);
			if(!file_exists(_CSV_USB_PATH)){
				array_push($this->error_message ,_CSV_USB_PATH."が見つかりません");
			}else{
				/** ﾃﾞｨﾚｸﾄﾘ読込 */
				foreach(FileSystem::isFiles(_CSV_USB_PATH, FileSystem::openDirectory(_CSV_USB_PATH)) as $val){
					$todaytime = date("Y/m/d H:i:s");
					list($file_name,$ext) = explode(".",$val);
					list($file_type,$kanrino) = explode("_",$file_name);
					if(strtolower($file_type) == "inv"){
						$buf = mb_convert_encoding(file_get_contents(_CSV_USB_PATH."/".$val),"utf-8", "SJIS-win");
						$fp = tmpfile();
						fwrite($fp, $buf);
						rewind($fp);
						$csv_data = array();
						while(!feof($fp)){
						    $str = fgetExcelCSV($fp);
						    if(is_array($str)){
					    
							$sosiki_array = array();
							for($k=1; $k<=5; $k++){
								if(@$str[$k] != ""){
									$sosiki_array[] = $str[$k];
								}
							}
							$sosiki = implode("/",$sosiki_array);
						
							$ins_flag = true;
							$detail = $this->db->dbSelect("select * from inventory where hardwareno = '".@$str[0]."'", "detail");
							if($detail){
								$where = "hardwareno = '".@$str[0]."'";
								$fields_values = array(
										"collectsource"        => "USBツール",
										"invtraprecvdate"      => $todaytime,
										"hardwareno"           => @$str[0],
										"group1"               => $sosiki,
										"macaddress"           => @$str[7],
										"ipaddress"            => @$str[6],
										"subnetmask"           => "",
										"defaultgateway"       => "",
										"dnsserver"            => "",
										"secondarydns"         => "",
										"computername"         => @$str[9],
										"domainname"           => "",
										"userid"               => @$str[8],
										"machinevendor"        => @$str[11],
										"machinename"          => @$str[10],
										"cpuname"              => "",
										"memorysize"           => "",
										"osversion"            => @$str[12],
										"windowsservicepack"   => "",
										"ieversion"            => "",
										"virussoftname"        => "",
										"enginever"            => "",
										"patternver"           => "",
										"toolversion"          => @$str[17],
										"misiyou1"             => @$str[13],
										"misiyou2"             => @$str[14],
										"misiyou3"             => @$str[15]
										      );


								if($this->inv_validate($fields_values)){
									$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
									if($this->db->error != ""){
										array_push($this->error_message ,$this->db->error." USB INSERT INTO inventory ".@$str[0]);
									}
								}else{
									$ins_flag = false;
								}
							}else{
								$mac_data = $this->db->dbSelect("select * from inventory where upper(macaddress) = upper('".@$str[7]."') and macaddress is not null and macaddress != ''", "detail");
								if($mac_data){
									$where = "upper(macaddress) = upper('".@$str[7]."') and macaddress is not null and macaddress != ''";
									$fields_values = array(
											"collectsource"        => "USBツール",
											"idkey"                => @$str[7],
											"invtraprecvdate"      => $todaytime,
											"hardwareno"           => @$str[0],
											"group1"               => $sosiki,
											"macaddress"           => @$str[7],
											"ipaddress"            => @$str[6],
											"subnetmask"           => "",
											"defaultgateway"       => "",
											"dnsserver"            => "",
											"secondarydns"         => "",
											"computername"         => @$str[9],
											"domainname"           => "",
											"userid"               => @$str[8],
											"machinevendor"        => @$str[11],
											"machinename"          => @$str[10],
											"cpuname"              => "",
											"memorysize"           => "",
											"osversion"            => @$str[12],
											"windowsservicepack"   => "",
											"ieversion"            => "",
											"virussoftname"        => "",
											"enginever"            => "",
											"patternver"           => "",
											"toolversion"          => @$str[17],
											"misiyou1"             => @$str[13],
											"misiyou2"             => @$str[14],
											"misiyou3"             => @$str[15]
											      );
									if($this->inv_validate($fields_values)){
										$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
										if($this->db->error != ""){
											array_push($this->error_message ,$this->db->error." USB Update inventory ".@$str[0]);
										}
									}else{
										$ins_flag = false;
									}
								}else{
									$fields_values = array(
											"collectsource"        => "USBツール",
											"idkey"                => @$str[7],
											"invtraprecvdate"      => $todaytime,
											"hardwareno"           => @$str[0],
											"group1"               => $sosiki,
											"jyotai"               => "d001",
											"hikaku"               => "d001",
											"hsyubetu"             => "d001",
											"userid"               => @$str[8],
											"computername"         => @$str[9],
											"machinevendor"        => @$str[11],
											"machinename"          => @$str[10],
											"osversion"            => @$str[12],
											"misiyou1"             => @$str[13],
											"misiyou2"             => @$str[14],
											"misiyou3"             => @$str[15],
											"macaddress"           => @$str[7],
											"toolversion"          => @$str[17],
											"ipaddress"            => @$str[6]
											      );
									if($this->inv_validate($fields_values)){
										$this->db->dbInsert("\"inventory\"", $fields_values);
										if($this->db->error != ""){
											array_push($this->error_message ,$this->db->error." USB INSERT INTO inventory ".@$str[0]);
										}
									}else{
										$ins_flag = false;
									}
								}
							}
							if($ins_flag){
								$where = "hardwareno = '".@$kanrino."'";
								$this->db->dbDelete("\"inventorysoft\"", $where);
								$buf_soft = mb_convert_encoding(file_get_contents(_CSV_USB_PATH."/Ap_".@$kanrino.".csv"),"utf-8", "SJIS-win");
								$fp_soft = tmpfile();
								fwrite($fp_soft, $buf_soft);
								rewind($fp_soft);
								if(@$str[12] != ''){
									$os_array = explode("  ",$str[12]);
								    	$this->soft_check($kanrino,$os_array[0],$search_col);
								}
								$csv_data = array();
								while(!feof($fp_soft)){
								    $str_soft = fgetExcelCSV($fp_soft);
								    if(is_array($str_soft) and count($str_soft) >= 2){
								    	$this->soft_check($str_soft[0],$str_soft[1],$search_col);
								    }
								}
								fclose($fp_soft);
							}
						    }
						}
						fclose($fp);
						@rename(_CSV_USB_PATH."/".$val,_CSV_USB_BACK_PATH."/".$val);
						@rename(_CSV_USB_PATH."/Ap_".@$kanrino.".csv",_CSV_USB_BACK_PATH."/Ap_".@$kanrino.".csv");
						@rename(_CSV_USB_PATH."/File_".@$kanrino.".csv",_CSV_USB_BACK_PATH."/File_".@$kanrino.".csv");
						@rename(_CSV_USB_PATH."/Reg_".@$kanrino.".csv",_CSV_USB_BACK_PATH."/Reg_".@$kanrino.".csv");
					}
				}
			}
			$this->inv_end_time_set(3);
		}
	}
	
	function koban(){
		$inv_date_list = $this->db->dbSelect("select * from inventorydate where invend is null and invbunrui = 4", "list");
		if(count($inv_date_list) <= 0){
			//チェック開始処理
			$where = "invbunrui = 4";
			$fields_values = array(
					"invstart"   => date("Y/m/d H:i:s"),
					"invend"     => null
			);
			$this->db->dbUpdate("inventorydate", $fields_values, $where);
			/** ﾃﾞｨﾚｸﾄﾘ読込 */
			foreach(FileSystem::isFiles(_CSV_KBN_PATH, FileSystem::openDirectory(_CSV_KBN_PATH)) as $val){
			
				$file_name = explode("-",$val);
				$file_date = mktime(substr($file_name[2], 0,2),
						    substr($file_name[2], 2,2),
						    0,
						    substr($file_name[1], 4,2),
						    substr($file_name[1], 6,2),
						    substr($file_name[1], 0,4)
						    );
				if(mktime() > $file_date){
					$buf = mb_convert_encoding(file_get_contents(_CSV_KBN_PATH."/".$val),"utf-8", "SJIS-win");
					$fp = tmpfile();
					fwrite($fp, $buf);
					rewind($fp);
					$csv_data = array();
					while(!feof($fp)){
					    $str = fgetExcelCSV($fp);
					    if(is_array($str)){
						$macaddress = strtoupper(ereg_replace(":","",$str[1]));
						$detail = $this->db->dbSelect("select * from inventory where upper(macaddress) = upper('".$macaddress."')", "detail");
						if($detail){
							$ok_data = $this->db->dbSelect("select * from inventory where upper(macaddress) = upper('".$macaddress."') and invtraprecvdate < '".$str[0]."'", "detail");
							if($ok_data){
								$where = "upper(macaddress) = upper('".$macaddress."')";
								switch ($ok_data['collectsource']) {
									case "LanScope検知":
									case "Koban検知":
										$fields_values = array(
												"collectsource"        => "Koban検知",
												"invtraprecvdate"      => $str[0],
												"ipaddress"            => $str[2]
												      );
										if($this->inv_validate($fields_values)){
											$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
											if($this->db->error != ""){
												array_push($this->error_message ,$this->db->error." koban Update inventory ".@$str[2]);
											}
										}
										break;
									default:
										$fields_values = array(
												"ipaddress"            => $str[2]
												      );
										if($this->inv_validate($fields_values)){
											$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
											if($this->db->error != ""){
												array_push($this->error_message ,$this->db->error." koban Update inventory ".@$str[2]);
											}
										}
										break;
								}
							}
						}else{
							$fields_values = array(
									"collectsource"        => "Koban検知",
									"idkey"                => $macaddress,
									"invtraprecvdate"      => $str[0],
									"jyotai"               => "d001",
									"hikaku"               => "d001",
									"hsyubetu"             => "d003",
									"macaddress"           => $macaddress,
									"ipaddress"            => $str[2]
									      );
							if($this->inv_validate($fields_values)){
								$this->db->dbInsert("\"inventory\"", $fields_values);
								if($this->db->error != ""){
									array_push($this->error_message ,$this->db->error." USB INSERT INTO inventory ".@$str[2]);
								}
							}
						}
					    }
					}
					fclose($fp);
					@unlink(_CSV_KBN_PATH."/".$val);
				}
			}
			$where = "invbunrui = 4";
			$fields_values = array(
					"invend"     => date("Y/m/d H:i:s")
			);
			$this->db->dbUpdate("inventorydate", $fields_values, $where);
		}
	}
	
	function lanscope(){
		$inv_date_list = $this->db->dbSelect("select * from inventorydate where invend is null and invbunrui = 5", "list");
		if(count($inv_date_list) <= 0){
			//チェック開始処理
			$where = "invbunrui = 5";
			$fields_values = array(
					"invstart"   => date("Y/m/d H:i:s"),
					"invend"     => null
			);
			$this->db->dbUpdate("inventorydate", $fields_values, $where);
			/** ﾃﾞｨﾚｸﾄﾘ読込 */
			foreach(FileSystem::isFiles(_CSV_DCT_PATH, FileSystem::openDirectory(_CSV_DCT_PATH)) as $val){
				$buf = mb_convert_encoding(file_get_contents(_CSV_DCT_PATH."/".$val),"utf-8", "SJIS-win");
				$fp = tmpfile();
				fwrite($fp, $buf);
				rewind($fp);
				$csv_data = array();
				while(!feof($fp)){
				    $str = fgetExcelCSV($fp);
				    if(is_array($str)){
						$detail = $this->db->dbSelect("select * from inventory where upper(macaddress) = upper('".$str[1]."')", "detail");
						if($detail){
							$ok_data = $this->db->dbSelect("select * from inventory where  upper(macaddress) =  upper('".$str[1]."') and invtraprecvdate < '".$str[5]."'", "detail");
							if($ok_data){
								$where = "upper(macaddress) = upper('".$str[1]."')";
								switch ($ok_data['collectsource']) {
									case "LanScope検知":
									case "Koban検知":
										$fields_values = array(
												"collectsource"        => "LanScope検知",
												"invtraprecvdate"      => $str[5],
												"ipaddress"            => $str[2],
												"computername"         => $str[6]
												      );
										if($this->inv_validate($fields_values)){
											$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
											if($this->db->error != ""){
												array_push($this->error_message ,$this->db->error." lan Update inventory ".@$str[2]);
											}
										}
										break;
									default:
										$fields_values = array(
												"ipaddress"            => $str[2],
												"computername"         => $str[6]
												      );
										if($this->inv_validate($fields_values)){
											$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
											if($this->db->error != ""){
												array_push($this->error_message ,$this->db->error." lan Update inventory ".@$str[2]);
											}
										}
										break;
								}
							}
						}else{
							$fields_values = array(
									"collectsource"        => "LanScope検知",
									"idkey"                => $str[1],
									"invtraprecvdate"      => $str[5],
									"jyotai"               => "d001",
									"hikaku"               => "d001",
									"hsyubetu"             => "d003",
									"macaddress"           => $str[1],
									"ipaddress"            => $str[2],
									"computername"         => $str[6]
									      );
							if($this->inv_validate($fields_values)){
								$this->db->dbInsert("\"inventory\"", $fields_values);
								if($this->db->error != ""){
									array_push($this->error_message ,$this->db->error." lan INSERT INTO inventory ".@$str[2]);
								}
							}
						}


				    }
				}
				
				fclose($fp);
				@unlink(_CSV_DCT_PATH."/".$val);
			}
			$where = "invbunrui = 5";
			$fields_values = array(
					"invend"     => date("Y/m/d H:i:s")
			);
			$this->db->dbUpdate("inventorydate", $fields_values, $where);
		}
	}

	function hard_haiki(){
		$hard_list = $this->db->dbSelect("select hard_kanrino from hard where haiki_date <= '".date('Y/m/d')."'", "list");
		if(count($hard_list) > 0){
			for($i=0; $i<count($hard_list); $i++){
				$where = "hardwareno = '".$hard_list[$i]['hard_kanrino']."'";
				$fields_values = array(
						"jyotai"        => "d004"
						      );
				$this->db->dbUpdate("inventory", $fields_values, $where);
			}
		}
		//バッチログセット
		$this->set_bat_log(3);
	}

	function using(){
		$where = "invtraprecvdate >= current_date - 1";
		$fields_values = array(
				"jyotai"        => "d001"
				      );
		$this->db->dbUpdate("inventory", $fields_values, $where);
		//バッチログセット
		$this->set_bat_log(4);
	}

	function sosiki(){
		$hard_list = $this->db->dbSelect("select hard_kanrino,sosiki_fullname from hard_detail", "list");
		if(count($hard_list) > 0){
			for($i=0; $i<count($hard_list); $i++){
				if($hard_list[$i]['sosiki_fullname']){
print $i."_sosiki\n";
					$where = "hardwareno = '".$hard_list[$i]['hard_kanrino']."'";
					$fields_values = array(
							"group1"               => $hard_list[$i]['sosiki_fullname']
							      );
					$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
				}
			}
		}
		//バッチログセット
		$this->set_bat_log(5);
	}
	
	function ap_check($soft_name,$search_col){
		$match = true;
		if(count($search_col) > 0){
			foreach($search_col as $value){
				if(ereg ($value, $soft_name)){
					$match = false;
				}
				unset($value);
			}
		}
		if($soft_name == "" or $soft_name == null){
			$match = false;
		}
		return $match;
		unset($match);
	}
	
	function soft_check($hardwareno,$soft_name,$search_col){
		$match = false;
		if(count($search_col) > 0){
			foreach($search_col as $value){
				if(ereg ($value, $soft_name)){
					$match = true;
				}
				unset($value);
			}
		}
		if(!$match and ($soft_name != "" and $soft_name != null)){
			$fields_values = array(
					"hardwareno"           => $hardwareno,
					"insapname"            => $soft_name
					      );
			if($this->ap_validate($fields_values)){
				$this->db->dbInsert("\"inventorysoft\"", $fields_values);
				if($this->db->error != ""){
					array_push($this->error_message ,$this->db->error." USB INSERT INTO inventorysoft ".$hardwareno." ".$soft_name);
				}
			}
		}
		unset($fields_values);
		unset($hardwareno);
		unset($soft_name);
		unset($search_col);
		unset($match);
	}
	
	function inv_ins($str,$type){
		$sosiki_array = array();
		for($k=14; $k<=18; $k++){
			if(@$str[$k] != ""){
				$sosiki_array[] = $str[$k];
			}
		}
		$sosiki = implode("/",$sosiki_array);
		
		if($str[4] != ""){
			$hardwareno = $str[4];
			$misiyou1   = $str[5];
			$misiyou2   = $str[6];
			$misiyou3   = $str[7];
			$userid     = $str[8];
		}else{
			$hardwareno = $str[9];
			$misiyou1   = $str[10];
			$misiyou2   = $str[11];
			$misiyou3   = $str[12];
			$userid     = $str[13];
		}
		if($hardwareno != ""){
			$detail = $this->db->dbSelect("select * from inventory where hardwareno = '".$hardwareno."'", "detail");
			if($detail){
	print $str[2]."\n";
				$ok_data = $this->db->dbSelect("select * from inventory where hardwareno = '".$hardwareno."' and invtraprecvdate < '".$str[3]."'", "detail");
				if($ok_data){
					$where = "hardwareno = '".$hardwareno."' and invtraprecvdate < '".$str[3]."'";
					$fields_values = array(
							"collectsource"        => "LanScopeツール",
							"idkey"                => @$str[2],
							"invtraprecvdate"      => @$str[3],
							"hsyubetu"             => "d001",
							"hardwareno"           => $hardwareno,
							"group1"               => $sosiki,
							"macaddress"           => @$str[19],
							"ipaddress"            => @$str[20],
							"subnetmask"           => @$str[21],
							"defaultgateway"       => @$str[22],
							"dnsserver"            => @$str[23],
							"secondarydns"         => @$str[24],
							"computername"         => @$str[25],
							"domainname"           => @$str[26],
							"userid"               => $userid,
							"machinevendor"        => @$str[27],
							"machinename"          => @$str[28],
							"cpuname"              => @$str[29],
							"memorysize"           => @$str[30],
							"osversion"            => @$str[31],
							"windowsservicepack"   => @$str[32],
							"ieversion"            => @$str[33],
							"virussoftname"        => @$str[34],
							"enginever"            => @$str[35],
							"patternver"           => @$str[36],
							"toolversion"          => @$str[37],
							"misiyou1"             => $misiyou1,
							"misiyou2"             => $misiyou2,
							"misiyou3"             => $misiyou3
							      );
					if($this->inv_validate($fields_values)){
						$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
						if($this->db->error != ""){
							array_push($this->error_message ,$this->db->error." Update inventory ".$str['hardwareno']);
							return false;
						}
					}
				}else{
					return false;
				}
			}else{
	print $str[2]."-in\n";
				$mac_data = $this->db->dbSelect("select * from inventory where upper(macaddress) = upper('".@$str[19]."') and macaddress is not null and macaddress != ''", "detail");
				if($mac_data){
					$ok_data = $this->db->dbSelect("select * from inventory where upper(macaddress) = upper('".@$str[19]."') and macaddress is not null and macaddress != '' and invtraprecvdate < '".$str[3]."'", "detail");
					if($ok_data){
						$where = "upper(macaddress) = upper('".@$str[19]."') and macaddress is not null and macaddress != '' and invtraprecvdate < '".$str[3]."'";
						$fields_values = array(
								"collectsource"        => "LanScopeツール",
								"idkey"                => @$str[2],
								"invtraprecvdate"      => @$str[3],
								"hsyubetu"             => "d001",
								"hardwareno"           => $hardwareno,
								"group1"               => $sosiki,
								"macaddress"           => @$str[19],
								"ipaddress"            => @$str[20],
								"subnetmask"           => @$str[21],
								"defaultgateway"       => @$str[22],
								"dnsserver"            => @$str[23],
								"secondarydns"         => @$str[24],
								"computername"         => @$str[25],
								"domainname"           => @$str[26],
								"userid"               => $userid,
								"machinevendor"        => @$str[27],
								"machinename"          => @$str[28],
								"cpuname"              => @$str[29],
								"memorysize"           => @$str[30],
								"osversion"            => @$str[31],
								"windowsservicepack"   => @$str[32],
								"ieversion"            => @$str[33],
								"virussoftname"        => @$str[34],
								"enginever"            => @$str[35],
								"patternver"           => @$str[36],
								"toolversion"          => @$str[37],
								"misiyou1"             => $misiyou1,
								"misiyou2"             => $misiyou2,
								"misiyou3"             => $misiyou3
								      );
						if($this->inv_validate($fields_values)){
							$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
							if($this->db->error != ""){
								array_push($this->error_message ,$this->db->error." Update inventory ".@$str[19]);
								return false;
							}
						}
					}else{
						return false;
					}
				}else{
					$fields_values = array(
								"collectsource"        => "LanScopeツール",
								"idkey"                => @$str[2],
								"invtraprecvdate"      => @$str[3],
								"jyotai"               => "d001",
								"hikaku"               => "d001",
								"hsyubetu"             => "d001",
								"hardwareno"           => $hardwareno,
								"group1"               => $sosiki,
								"macaddress"           => @$str[19],
								"ipaddress"            => @$str[20],
								"subnetmask"           => @$str[21],
								"defaultgateway"       => @$str[22],
								"dnsserver"            => @$str[23],
								"secondarydns"         => @$str[24],
								"computername"         => @$str[25],
								"domainname"           => @$str[26],
								"userid"               => $userid,
								"machinevendor"        => @$str[27],
								"machinename"          => @$str[28],
								"cpuname"              => @$str[29],
								"memorysize"           => @$str[30],
								"osversion"            => @$str[31],
								"windowsservicepack"   => @$str[32],
								"ieversion"            => @$str[33],
								"virussoftname"        => @$str[34],
								"enginever"            => @$str[35],
								"patternver"           => @$str[36],
								"toolversion"          => @$str[37],
								"misiyou1"             => $misiyou1,
								"misiyou2"             => $misiyou2,
								"misiyou3"             => $misiyou3
							      );
					if($this->inv_validate($fields_values)){
						$this->db->dbInsert("\"inventory\"", $fields_values);
						if($this->db->error != ""){
							array_push($this->error_message ,$this->db->error." Insert into inventory ".$hardwareno);
							return false;
						}
					}
				}
			}
			return true;
		}else{
			return false;
		}
	}
	
	function ad_ins($str){
		$detail = $this->db->dbSelect("select * from inventory where domainname = 'ISG01.pref.ishikawa.jp' and userid = '".$str[0]."'", "detail");
		if($detail){
			$where = "userid = '".$str[0]."' and domainname = 'ISG01.pref.ishikawa.jp'";
			$fields_values = array(
					"hyoujimei"            => @$str[1],
					"yakusyoku"            => @$str[2],
					"syozoku"              => @$str[4]
					      );
			$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
		}
	}
	
	function inv_validate($fields_values){
		$vi = new ValidateItem;

		#入力チェック
		if(count($fields_values) > 0){
			foreach($fields_values as $key=>$value){
				switch ($key) {
					case "collectsource":
						$vi->checkItemStrlen(array("collectsource:100"=>$value));
						break;
					case "idkey":
						$vi->checkItemStrlen(array("idkey:255"=>$value));
						break;
					case "hardwareno":
						$vi->checkItemStrlen(array("hardwareno:255"=>$value));
						break;
					case "group1":
						$vi->checkItemStrlen(array("group1:255"=>$value));
						break;
					case "jyotai":
						$vi->checkItemStrlen(array("jyotai:6"=>$value));
						break;
					case "hikaku":
						$vi->checkItemStrlen(array("hikaku:6"=>$value));
						break;
					case "hsyubetu":
						$vi->checkItemStrlen(array("hsyubetu:6"=>$value));
						break;
					case "macaddress":
						$vi->checkItemStrlen(array("macaddress:12"=>$value));
						break;
					case "ipaddress":
						$vi->checkItemStrlen(array("ipaddress:15"=>$value));
						break;
					case "subnetmask":
						$vi->checkItemStrlen(array("subnetmask:15"=>$value));
						break;
					case "defaultgateway":
						$vi->checkItemStrlen(array("defaultgateway:15"=>$value));
						break;
					case "dnsserver":
						$vi->checkItemStrlen(array("dnsserver:255"=>$value));
						break;
					case "secondarydns":
						$vi->checkItemStrlen(array("secondarydns:255"=>$value));
						break;
					case "computername":
						$vi->checkItemStrlen(array("computername:255"=>$value));
						break;
					case "domainname":
						$vi->checkItemStrlen(array("domainname:255"=>$value));
						break;
					case "workgroup":
						$vi->checkItemStrlen(array("workgroup:255"=>$value));
						break;
					case "userid":
						$vi->checkItemStrlen(array("userid:255"=>$value));
						break;
					case "hyoujimei":
						$vi->checkItemStrlen(array("hyoujimei:255"=>$value));
						break;
					case "yakusyoku":
						$vi->checkItemStrlen(array("yakusyoku:255"=>$value));
						break;
					case "syozoku":
						$vi->checkItemStrlen(array("syozoku:255"=>$value));
						break;
					case "machinevendor":
						$vi->checkItemStrlen(array("machinevendor:255"=>$value));
						break;
					case "machinename":
						$vi->checkItemStrlen(array("machinename:255"=>$value));
						break;
					case "cpuname":
						$vi->checkItemStrlen(array("cpuname:255"=>$value));
						break;
					case "memorysize":
						$vi->checkItemStrlen(array("memorysize:255"=>$value));
						break;
					case "osversion":
						$vi->checkItemStrlen(array("osversion:255"=>$value));
						break;
					case "windowsservicepack":
						$vi->checkItemStrlen(array("windowsservicepack:255"=>$value));
						break;
					case "ieversion":
						$vi->checkItemStrlen(array("ieversion:255"=>$value));
						break;
					case "virussoftname":
						$vi->checkItemStrlen(array("virussoftname:100"=>$value));
						break;
					case "enginever":
						$vi->checkItemStrlen(array("enginever:20"=>$value));
						break;
					case "patternver":
						$vi->checkItemStrlen(array("patternver:255"=>$value));
						break;
					case "misiyou1":
						$vi->checkItemStrlen(array("misiyou1:255"=>$value));
						break;
					case "misiyou2":
						$vi->checkItemStrlen(array("misiyou2:255"=>$value));
						break;
					case "misiyou3":
						$vi->checkItemStrlen(array("misiyou3:255"=>$value));
						break;
					case "mukou_date":
						$vi->checkItemDate01(array($value=>"mukou_date"));
						break;
					case "toolversion":
						$vi->checkItemStrlen(array("toolversion:255"=>$value));
						break;
				}
			}
			if($vi->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
				$message = implode("\n",$vi->error_msg);
				array_push($this->error_message ,$this->db->error." validate inventory ".$fields_values['hardwareno']." ".$message);
				unset($message);
				unset($fields_values);
				return false;
			}
		}
		return true;
	}
	
	function ap_validate($fields_values){
		$vi = new ValidateItem;

		#入力チェック
		if(count($fields_values) > 0){
			foreach($fields_values as $key=>$value){
				switch ($key) {
					case "hardwareno":
						$vi->checkItemNon(array($value=>"hardwareno"));
						$vi->checkItemStrlen(array("hardwareno:255"=>$value));
						break;
					case "insapname":
						$vi->checkItemStrlen(array("insapname:255"=>$value));
						break;
				}
			}
			if($vi->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
				$message = implode("\n",$vi->error_msg);
				array_push($this->error_message ,$this->db->error." validate inventorysoft ".$fields_values['hardwareno']." ".$fields_values['insapname']." ".$message);
				unset($message);
				unset($fields_values);
				return false;
			}
		}
		return true;
	}
	
	function error_mail_send(){
		$mail_tpl = new Template;
		$email = new Sendmail;
		if(count($this->error_message) > 0){
			$message = implode("\n\n",$this->error_message);
			$mail_tpl->assignHtml('error_message',$message);
			$body = $mail_tpl->fetchHtml('mail/import_error.html');
			$subject = "【情報資産管理システム】収集情報インポートエラー";
			$email->email(_ERROR_EMAIL, _ADMIN_EMAIL, $subject, $body);
			//エラーログ書き出し
			$filename = _LOG_PATH."/inventory_import".date("Ymd").".log";
			if(!file_exists($filename)){
				touch($filename);
				chmod($filename,0666);
				chown($filename,"apache");
				chgrp($filename,"apache");
			}
			$fp = fopen($filename, "a");
			fwrite($fp, date("Y-m-d H:i:s")."\n".$message."\n\n\n");
			fclose($fp);
		}
	}

	function inv_end_time_set($type=1){
		$where_date = "invbunrui = ".$type;
		$fields_values = array(
				"invend"     => date("Y/m/d H:i:s")
		);
		$this->db->dbUpdate("inventorydate", $fields_values, $where_date);
	}

	//バッチログセット
	function set_bat_log($pkey){
		$where_date = "bat_pkey = ".$pkey;
		$fields_values = array(
				"end_date"     => date("Y/m/d H:i:s")
		);
		$this->db->dbUpdate("bat_log", $fields_values, $where_date);
	}
}

?>