<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** インポート */
class ImportModel extends Model{

	/**
	 * ﾕｰｻﾞｰcode(登録者)
	 * @var int
	 */
	var $authuser_code;

	/**
	 * 一覧
	 */
	function index(){
		$this->import();
	}

	/**
	 * 一覧
	 */
	function import(){
		$this->tpl->assignHtml('title', _TITLE_IMPORT);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			
			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i:s");
			$item['sinseisyozoku'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('table_col', select_code("00009"));
		$this->tpl->assignHtml('action_name',_ACTION_IMPORT);
		$this->tpl->assignHtml('action_param','import');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('import/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * インポート
	 * 確認
	 */
	function import_conf(){
		$this->tpl->assignHtml('title', _TITLE_IMPORT);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** FILE ｺﾝﾄﾛｰﾙ upload ｾｯｼｮﾝ登録 */
		$file        = array("csv");
		$csv_path   = _UPLOAD_PATH."/csv";
		FileSystem::fileControlUpload($file, $csv_path);
		$ex_array = explode(".",@$_FILES['csv']['name']);
		$ex = strtolower(array_pop($ex_array));
		
		$cci = new CheckItem;
		if(@$_FILES['csv']['name'] == "" or $ex != "csv" or @$_FILES['csv']['tmp_name'] == "" and _ERROR_0018){
			$cci->checkErrorCode("0018");
		}
		$limit_time = 30*60;

		$check_time = date("Y-m-d H:i:s",mktime(date("H"),date("i"),date("s")-$limit_time,date("m"),date("d"),date("Y")));
		$where = "start_date <= '".$check_time."'";
		$this->db->dbDelete("import_moniter", $where);
		$where = " where user_id = '".$this->authuser_code."'";
		$detail = $this->db->dbSelect("select count(*) from import_moniter".$where, "detail");
		if($detail['count'] > 0 and _ERROR_0020){
			$cci->checkErrorCode("0020");
		}
		
		$limit_size = 100000;
		$where = " where user_id = '".$this->authuser_code."'";
		$detail_qty = $this->db->dbSelect("select SUM(import_qty) as qty from import_moniter", "detail");
		$self_qty = sizeof(file($csv_path."/".@$_SESSION['input']['csv']['upload_name']));
		$total_qty = $detail_qty['qty']+$self_qty;

		if($limit_size < $self_qty and _ERROR_0019){
			$cci->checkErrorCode("0019");
		}elseif($limit_size < $total_qty and _ERROR_0021){
			$cci->checkErrorCode("0021");
		}
		if($cci->error_flag == true){
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
			
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=import");
			exit;
		}else{
			$fields_values = array(
					"user_id"       => $this->authuser_code,     
					"import_qty"    => $self_qty,     
					"start_date"    => date("Y-m-d H:i:s")
					      );
			$import_pkey = $this->db->dbInsert("import_moniter", $fields_values);
		}

		$buf = mb_convert_encoding(file_get_contents($csv_path."/".@$_SESSION['input']['csv']['upload_name']),"utf-8", "SJIS-win");
		$fp = tmpfile();
		fwrite($fp, $buf);
		rewind($fp);
		$csv_data = array();
		while(!feof($fp)){
		    $str = fgetExcelCSV($fp);
		    if(is_array($str)){
			    $csv_data[] = $str;
		    }
		}
		$_SESSION['input']['csv_data'] = $csv_data;
		fclose($fp);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "import";
		$this->check($_SESSION['input']['import_table'],$csv_data);
		$csv_qty = count(@$csv_data)-1;
		unset($csv_data);
		unset($buf);

		$where = "import_pkey = ".$import_pkey;
		$this->db->dbDelete("import_moniter", $where);
		
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		
		/** 出力 */
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		$this->tpl->assignHtml('item', @$_SESSION['input']);
		$this->tpl->assignHtml('qty', @$csv_qty);
		$this->tpl->assignHtml('table_col', select_code("00009"));
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('action_name',_ACTION_IMPORT);
		$this->tpl->assignHtml('action_param','import');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('import/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * インポート
	 * 確認
	 */
	function import_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		$import_data = $_SESSION['input']['csv_data'];
		$import_table = $_SESSION['input']['import_table'];

		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);

		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_pop($full);
		$full_array = array_merge($child_array,$full);

		//組織名取得(array)
		$sosiki_col = array();
		$sosiki_col_array = $this->db->dbSelect("SELECT sosiki_pkey,syozoku_fullname FROM sosiki", "list");
		if(count($sosiki_col_array) > 0){
			for($i=0; $i<count($sosiki_col_array); $i++){
				$sosiki_col[$sosiki_col_array[$i]['sosiki_pkey']] = $sosiki_col_array[$i]['syozoku_fullname'];
			}
		}
		//使用者によるソフトウェア追加導入・削除取得(array)
		$soft_installdel = select_code('00022');
		//該当取得(array)
		$gaitou_col = select_code('00004');
		//有効取得(array)
		$yukou_col = select_code('00007');
		//認証取得(array)
		$auth_col = select_code('00023');
		//種別取得(array)
		$syubetu_col = select_code('00001');
		//状態取得(array)
		$jyoutai_col = select_code('00002');
		//種類取得(array)
		$type_col = select_code('00005');
		//要否取得(array)
		$anpi_col = select_code('00006');

		switch ($import_table) {
		    case "d001":
			for($i=1; $i<count($import_data); $i++){
				//ハードウェア管理番号の空白文字除去と全角英数を半角に変換
				$import_data[$i][2] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][2], 'rnsKHV'));

				$data['hard_pkey']        = @$import_data[$i][0];
				$data['sosiki_full']      = @$import_data[$i][1];
				$data['hard_kanrino']     = @$import_data[$i][2];
				$data['use_name']         = @$import_data[$i][5];
				$data['price']            = @$import_data[$i][9];
				$data['tyoutatu']         = @$import_data[$i][10];
				$data['location']         = @$import_data[$i][11];
				$data['bikou']            = @$import_data[$i][12];
				$data['tyoutatu_date']    = @$import_data[$i][13];
				$data['haiki_date']       = @$import_data[$i][14];
				$data['soft_installdel']  = @$import_data[$i][15];
				$data['memo']             = @$import_data[$i][16];
				$data['version']          = @$import_data[$i][17];
				//コードに変換
				if(!$data['sosiki_pkey'] = array_search($data['sosiki_full'],$sosiki_col)){
					$data['sosiki_pkey'] = "";
				}
				if(!$data['soft_installdel'] = array_search($data['soft_installdel'],$soft_installdel)){
					$data['soft_installdel'] = "";
				}
				if($data['version'] == ""){
					$data['version'] = 0;
				}
				if($this->authuser_authority != 'system'){
					$detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".$data['hard_pkey'], "detail");
					$data['memo'] = $detail['memo'];
				}
				
				$where = "hard_pkey = ".$data['hard_pkey'];
				if(@$_SESSION['input']['direct'] == "on"){
					if($data['hard_pkey'] == ""){
						$insert_values[] = array(
								$data['sosiki_pkey'],
								$data['hard_kanrino'],
								$data['soft_installdel'],
								$data['use_name'],
								$data['tyoutatu'],
								$data['bikou'],
								$data['tyoutatu_date'],
								$data['haiki_date'],
								$data['price'],
								$data['location'],
								$data['memo'],
								1, 
								0 
								      );
					}else{
						$fields_values = array(
								"sosiki_pkey"          => $data['sosiki_pkey'],
								"hard_kanrino"         => $data['hard_kanrino'],
								"soft_installdel"      => $data['soft_installdel'],
								"use_name"             => $data['use_name'],
								"tyoutatu"             => $data['tyoutatu'],
								"bikou"                => $data['bikou'],
								"tyoutatu_date"        => $data['tyoutatu_date'],
								"haiki_date"           => $data['haiki_date'],
								"price"                => $data['price'],
								"location"             => $data['location'],
								"memo"                 => $data['memo'],
								"version"              => $data['version'] + 1
								      );
						$this->db->dbUpdate("\"hard\"", $fields_values, $where);
					}
				}else{
					if($data['hard_pkey'] == ""){
						if($this->authuser_authority != 'system'){
							$data['soft_installdel'] = 'd001';
						}
						$fields_values = array(
								"sosiki_pkey"          => $data['sosiki_pkey'],     
								"hard_kanrino"         => $data['hard_kanrino'],     
								"soft_installdel"      => $data['soft_installdel'],
								"use_name"             => $data['use_name'],
								"tyoutatu"             => $data['tyoutatu'], 
								"bikou"                => $data['bikou'], 
								"tyoutatu_date"        => $data['tyoutatu_date'], 
								"haiki_date"           => $data['haiki_date'], 
								"price"                => $data['price'],
								"location"             => $data['location'],
								"memo"                 => $data['memo'],
								"version"              => 1, 
								"newkbn"               => 1 
								      );
						$pkey = $this->db->dbInsert("\"hard\"", $fields_values);
						$fields_values = array(
								"hard_pkey"            => $pkey,     
								"sosiki_pkey"          => $data['sosiki_pkey'],     
								"hard_kanrino"         => $data['hard_kanrino'],     
								"soft_installdel"      => $data['soft_installdel'],
								"use_name"             => $data['use_name'],
								"tyoutatu"             => $data['tyoutatu'], 
								"bikou"                => $data['bikou'], 
								"tyoutatu_date"        => $data['tyoutatu_date'], 
								"haiki_date"           => $data['haiki_date'], 
								"price"                => $data['price'],
								"location"             => $data['location'],
								"memo"                 => $data['memo'],
								"version"              => 1 
								      );
						$code = $this->db->dbInsert("\"hardrireki\"", $fields_values);
					}else{
						if($this->authuser_authority != 'system'){
							$detail = $this->db->dbSelect("select * from hard where hard_pkey = '".$data['hard_pkey']."'", "detail");
							if(@$detail['soft_installdel'] == ""){
								$data['soft_installdel'] = 'd001';
							}else{
								$data['soft_installdel'] = $detail['soft_installdel'];
							}
						}
						$fields_values = array(
								"hard_pkey"            => $data['hard_pkey'],     
								"sosiki_pkey"          => $data['sosiki_pkey'],     
								"hard_kanrino"         => $data['hard_kanrino'],     
								"soft_installdel"      => $data['soft_installdel'],
								"use_name"             => $data['use_name'],
								"tyoutatu"             => $data['tyoutatu'], 
								"bikou"                => $data['bikou'], 
								"tyoutatu_date"        => $data['tyoutatu_date'], 
								"haiki_date"           => $data['haiki_date'], 
								"price"                => $data['price'],
								"location"             => $data['location'],
								"memo"                 => $data['memo'],
								"version"              => $data['version']
								      );
						$code = $this->db->dbInsert("\"hardrireki\"", $fields_values);
					}
				
					$fields_values = array(
							"history_pkey"         => $code,
							"history_type"         => "d001",
							"email_ad"             => $_SESSION['input']['email_ad'], 
							"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
							"sinseisya"            => $_SESSION['input']['sinseisya'], 
							"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'],
							"shinsei_no"           => $code,
							      );
					$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);
				}
			}
			if(count(@$insert_values) >= 1){
				$this->db->dbPrepare("INSERT INTO \"hard\" (sosiki_pkey,hard_kanrino,soft_installdel,use_name,tyoutatu,bikou,tyoutatu_date,haiki_date,price,location,memo,version,newkbn) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)", $insert_values);
				unset($insert_values);
			}
		        break;
		    case "d002":
			for($i=1; $i<count($import_data); $i++){
				//ハードウェア管理番号＋ライセンス管理番号の空白文字除去と全角英数を半角に変換
				$import_data[$i][2] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][2], 'rnsKHV'));
				$import_data[$i][4] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][4], 'rnsKHV'));

				$data['soft_pkey']        = @$import_data[$i][0];
				$data['hard_kanrino']     = @$import_data[$i][2];
				$data['licence_kanrino']  = @$import_data[$i][4];
				$data['downgrade']        = @$import_data[$i][9];
				$data['bikou']            = @$import_data[$i][11];
				$data['tyoutatu_date']    = @$import_data[$i][12];
				$data['haiki_date']       = @$import_data[$i][13];
				$data['memo']             = @$import_data[$i][14];
				$data['version']          = @$import_data[$i][15];
				if($data['version'] == ""){
					$data['version'] = 0;
				}
				
				//コードに変換
				if(!$data['downgrade'] = array_search($data['downgrade'],$gaitou_col)){
					$data['downgrade'] = "";
				}
				if($this->authuser_authority != 'system'){
					$detail = $this->db->dbSelect("select * from soft_detail where soft_pkey=".$data['soft_pkey'], "detail");
					$data['memo'] = $detail['memo'];
				}
				$detail = $this->db->dbSelect("select * from hard where hard_kanrino = '".$data['hard_kanrino']."' and newkbn <> 1", "detail");
				$data['hard_pkey'] = $detail['hard_pkey'];
				$list = $this->db->dbSelect("select * from licence where licence_kanrino = '".$data['licence_kanrino']."' and newkbn <> 1", "list");
				if(count($list) > 0){
					for($j=0; $j<count($list); $j++){
						if(in_array($list[$j]['sosiki_pkey'],$full_array)){
							$data['licence_pkey'] = $list[$j]['licence_pkey'];
							break;
						}
					}
				}
				#既存ソフトウェア抽出
				$where_list =" where hard_pkey='".$data['hard_pkey']."' and newkbn <> 1";
				$soft_list = $this->db->dbSelect("select soft_pkey, hard_pkey, licence_pkey, version, memo, bikou, downgrade, tyoutatu_date, haiki_date from soft_detail".$where_list." order by \"licence_kanrino\"", "list");
				if(count($soft_list) > 0){
					for($j=0; $j<count($soft_list); $j++){
						$base_detailt[$soft_list[$j]['hard_pkey']][$soft_list[$j]['soft_pkey']] = $soft_list[$j];
					}
				}
				if(!is_array(@$date_array[$data['hard_pkey']])){
					$date_array[$data['hard_pkey']] = $base_detailt[$data['hard_pkey']];
				}
				if($data['soft_pkey'] != ""){
					$date_array[$data['hard_pkey']][$data['soft_pkey']] = $data;
				}else{
					$date_array[$data['hard_pkey']][] = $data;
				}
			}
			if(count($date_array) > 0){
				if(@$_SESSION['input']['direct'] == "on"){
					foreach($date_array as $data_val){
						/** 登録 */
						$shinsei_no = "";
						foreach($data_val as $val){
							if($val['version'] == ""){
								$val['version'] = 1;
							}
							if($val['soft_pkey'] == ""){
								$fields_values = array(
										"hard_pkey"            => $val['hard_pkey'], 
										"licence_pkey"         => $val['licence_pkey'],
										"bikou"                => $val['bikou'], 
										"downgrade"            => $val['downgrade'], 
										"install_date"         => $val['tyoutatu_date'],
										"uninstall_date"       => $val['haiki_date'],
										"memo"                 => @$val['memo'],
										"version"              => 1, 
										"newkbn"               => 0 
										      );
								$pkey = $this->db->dbInsert("\"soft\"", $fields_values);
							}else{
								$pkey = addslashes($val['soft_pkey']);
								if($this->authuser_authority != 'system'){
									$detail = $this->db->dbSelect("select * from soft_detail where soft_pkey=".$val[$soft_pkey], "detail");
									$val[$memo] = $detail['memo'];
								}
								$where = "soft_pkey = ".$pkey;

								$fields_values = array(
										"hard_pkey"            => $val['hard_pkey'], 
										"licence_pkey"         => $val['licence_pkey'],
										"bikou"                => $val['bikou'], 
										"downgrade"            => $val['downgrade'], 
										"install_date"         => $val['tyoutatu_date'],
										"uninstall_date"       => $val['haiki_date'],
										"memo"                 => @$val['memo'],
										"version"              => $val['version']
										      );
								$this->db->dbUpdate("\"soft\"", $fields_values, $where);
							}
						}
					}
				}else{
					foreach($date_array as $data_val){
						/** 登録 */
						$shinsei_no = "";
						foreach($data_val as $val){
							if($val['version'] == ""){
								$val['version'] = 1;
							}
							if($val['soft_pkey'] == ""){
								$fields_values = array(
										"hard_pkey"            => $val['hard_pkey'], 
										"licence_pkey"         => $val['licence_pkey'],
										"bikou"                => $val['bikou'], 
										"downgrade"            => $val['downgrade'], 
										"install_date"         => $val['tyoutatu_date'],
										"uninstall_date"       => $val['haiki_date'],
										"memo"                 => @$val['memo'],
										"version"              => 1, 
										"newkbn"               => 1 
										      );
								$pkey = $this->db->dbInsert("\"soft\"", $fields_values);
							}else{
								$pkey = $val['soft_pkey'];
								if($this->authuser_authority != 'system'){
									$detail = $this->db->dbSelect("select * from soft_detail where soft_pkey=".$val[$soft_pkey], "detail");
									$val[$memo] = $detail['memo'];
								}
							}

							$fields_values = array(
									"soft_pkey"            => $pkey, 
									"hard_pkey"            => $val['hard_pkey'], 
									"licence_pkey"         => $val['licence_pkey'],     
									"bikou"                => $val['bikou'], 
									"downgrade"            => $val['downgrade'], 
									"install_date"         => $val['tyoutatu_date'],
									"uninstall_date"       => $val['haiki_date'],
									"memo"                 => @$val['memo'],
									"version"              => $val['version']
									      );

							$code = $this->db->dbInsert("\"softrireki\"", $fields_values);

							if($shinsei_no == ""){
								$shinsei_no = $code;
							}
							$fields_values = array(
									"history_pkey"         => $code,     
									"history_type"         => "d002",     
									"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
									"sinseisya"            => $_SESSION['input']['sinseisya'], 
									"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'], 
									"email_ad"             => $_SESSION['input']['email_ad'],
									"shinsei_no"           => $shinsei_no
									      );
							$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);
						}
					}
				}
			}

		        break;
		    case "d003":
			$date_array = array();
			for($i=1; $i<count($import_data); $i++){
				//ハードウェア管理番号＋ライセンス管理番号の空白文字除去と全角英数を半角に変換
				$import_data[$i][3] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][3], 'rnsKHV'));
				$import_data[$i][9] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][9], 'rnsKHV'));
				$import_data[$i][11] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][11], 'rnsKHV'));
				
				$data['licence_pkey']     = @$import_data[$i][0];
				$data['kanri_sosiki_full']= @$import_data[$i][1];
				$data['sosiki_full']      = @$import_data[$i][2];
				$data['licence_kanrino']  = @$import_data[$i][3];
				$data['licencelist_pkey'] = @$import_data[$i][4];
				$data['hard_kanrino']     = @$import_data[$i][9];
				$data['licence_kanrino2'] = @$import_data[$i][11];
				$data['hold_qty']         = @$import_data[$i][13];
				$data['install_su']       = @$import_data[$i][14];
				$data['licence_no']       = @$import_data[$i][16];
				$data['price']            = @$import_data[$i][17];
				$data['tyoutatu']         = @$import_data[$i][18];
				$data['hokan_baitai']     = @$import_data[$i][21];
				$data['hokan_basyo']      = @$import_data[$i][22];
				$data['bikou']            = @$import_data[$i][25];
				$data['tyoutatu_date']    = @$import_data[$i][26];
				$data['use_limit_date']   = @$import_data[$i][27];
				$data['haiki_date']       = @$import_data[$i][28];
				$data['memo']             = @$import_data[$i][29];
				$data['version']          = @$import_data[$i][30];
				if($data['version'] == ""){
					$data['version'] = 0;
				}
				//コードに変換
				if(!$data['sosiki_pkey'] = array_search($data['sosiki_full'],$sosiki_col)){
					$data['sosiki_pkey'] = 0;
				}
				if(!$data['kanri_sosiki_pkey'] = array_search($data['kanri_sosiki_full'],$sosiki_col)){
					$data['kanri_sosiki_pkey'] = 0;
				}
				if($data['install_su'] == ""){
					$data['install_su'] = 0;
				}
				$detail = $this->db->dbSelect("select * from hard where hard_kanrino = '".$data['hard_kanrino']."' and newkbn <> 1", "detail");
				$data['hard_pkey'] = $detail['hard_pkey'];
				$licence_kanrino2_array = explode("\n",$data['licence_kanrino2']);
				if(count($licence_kanrino2_array) > 0){
					$licence_pkey2_array = array();
					for($k=0; $k<count($licence_kanrino2_array); $k++){
						$list = $this->db->dbSelect("select * from licence where licence_kanrino = '".$licence_kanrino2_array[$k]."' and newkbn <> 1", "list");
						if(count($list) > 0){
							for($j=0; $j<count($list); $j++){
								if(in_array($list[$j]['sosiki_pkey'],$full_array)){
									$licence_pkey2_array[] = $list[$j]['licence_pkey'];
									break;
								}
							}
						}
					}
					$data['licence_pkey2'] = implode(",",$licence_pkey2_array);
				}
				if($this->authuser_authority != 'system'){
					$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey=".$data['licence_pkey'], "detail");
					$data['memo'] = $detail['memo'];
				}
				
				$use_only = false;
				if($data['licence_pkey'] != ""){
					$list = $this->db->dbSelect("select * from licence where licence_pkey = ".$data['licence_pkey'], "list");
					if(in_array($list[0]['sosiki_pkey'],$child_array) and !in_array($list[0]['kanri_sosiki_pkey'],$child_array)){
						$use_only = true;
					}
				}

				$shinsei_no = "";
				if(@$_SESSION['input']['direct'] == "on"){
					if($data['licence_pkey'] != ""){
						$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey = ".$data['licence_pkey']." and newkbn <> 1", "detail");
						if($detail['kanri_sosiki_pkey'] == $detail['sosiki_pkey']){
							//使用所属抽出
							$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and newkbn <> 1";
							$use_sosiki = $this->db->dbSelect("select * from licence_detail".$where_list, "list");
							for($j=0; $j<count($use_sosiki); $j++){
								if($use_sosiki[$j]['kanri_sosiki_pkey'] == $use_sosiki[$j]['sosiki_pkey']){
									$use_sosiki[$j]['sosiki_pkey'] 	= $data['sosiki_pkey'];
									$use_sosiki[$j]['install_su'] 	= $data['install_su'];
									$use_sosiki[$j]['hokan_baitai']	= $data['hokan_baitai'];
									$use_sosiki[$j]['hokan_basyo']	= $data['hokan_basyo'];
									$use_sosiki[$j]['bikou']	= $data['bikou'];
									$use_sosiki[$j]['memo']		= $data['memo'];
								}
								$use_sosiki[$j]['kanri_sosiki_pkey']	= $data['kanri_sosiki_pkey'];
								$use_sosiki[$j]['licencelist_pkey']	= $data['licencelist_pkey'];
								$use_sosiki[$j]['licence_kanrino']	= $data['licence_kanrino'];
								$use_sosiki[$j]['hard_pkey']		= $data['hard_pkey'];
								$use_sosiki[$j]['licence_pkey2']	= $data['licence_pkey2'];
								$use_sosiki[$j]['licence_no']		= $data['licence_no'];
								$use_sosiki[$j]['tyoutatu']		= $data['tyoutatu'];
								$use_sosiki[$j]['tyoutatu_date']	= $data['tyoutatu_date'];
								$use_sosiki[$j]['haiki_date']		= $data['haiki_date'];
								$use_sosiki[$j]['price']		= $data['price'];
								$use_sosiki[$j]['use_limit_date']	= $data['use_limit_date'];
								$use_sosiki[$j]['hold_qty']		= $data['hold_qty'];
							}
						}else{
							$use_sosiki[0] = $detail;
							if(!$use_only){
								$use_sosiki[0]['sosiki_pkey'] 	= $data['sosiki_pkey'];
								$use_sosiki[0]['install_su'] 	= $data['install_su'];
							}
							$use_sosiki[0]['hokan_baitai']	= $data['hokan_baitai'];
							$use_sosiki[0]['hokan_basyo']	= $data['hokan_basyo'];
							$use_sosiki[0]['bikou']		= $data['bikou'];
							$use_sosiki[0]['memo']		= $data['memo'];
						}
						for($j=0; $j<count($use_sosiki); $j++){
							$fields_values = array(
									"kanri_sosiki_pkey"    => $use_sosiki[$j]['kanri_sosiki_pkey'], 
									"sosiki_pkey"          => $use_sosiki[$j]['sosiki_pkey'],
									"licencelist_pkey"     => $use_sosiki[$j]['licencelist_pkey'],
									"licence_kanrino"      => $use_sosiki[$j]['licence_kanrino'],
									"install_su"           => $use_sosiki[$j]['install_su'],
									"hard_pkey"            => $use_sosiki[$j]['hard_pkey'],
									"licence_pkey2"        => $use_sosiki[$j]['licence_pkey2'],
									"licence_no"           => $use_sosiki[$j]['licence_no'],
									"tyoutatu"             => $use_sosiki[$j]['tyoutatu'],
									"hokan_baitai"         => $use_sosiki[$j]['hokan_baitai'],
									"hokan_basyo"          => $use_sosiki[$j]['hokan_basyo'],
									"bikou"                => $use_sosiki[$j]['bikou'],
									"tyoutatu_date"        => $use_sosiki[$j]['tyoutatu_date'],
									"haiki_date"           => $use_sosiki[$j]['haiki_date'],
									"price"                => $use_sosiki[$j]['price'],
									"use_limit_date"       => $use_sosiki[$j]['use_limit_date'],
									"memo"                 => $use_sosiki[$j]['memo'],
									"version"              => $use_sosiki[$j]['version']
									      );
							/** 登録 */
							$licence_pkey = addslashes($use_sosiki[$j]['licence_pkey']);
							$where = "licence_pkey = ".$licence_pkey;
							$this->db->dbUpdate("\"licence\"", $fields_values, $where);
							$hold_qty = $this->db->dbSelect("select * from hold_licence_qty where licence_kanrino='".$use_sosiki[$j]['licence_kanrino']."'", "detail");
							if(count($hold_qty) > 0){
								$where_hold_qty = "licence_kanrino ='".$use_sosiki[$j]['licence_kanrino']."'";
								$fields_values = array(
										"hold_qty" => $use_sosiki[$j]['hold_qty']
										      );
								$this->db->dbUpdate("\"hold_licence_qty\"", $fields_values, $where_hold_qty);
							}else{
								$fields_values = array(
										"licence_kanrino"	=> $use_sosiki[$j]['licence_kanrino'],
										"hold_qty"		=> $use_sosiki[$j]['hold_qty']
										      );
								$this->db->dbInsert("\"hold_licence_qty\"", $fields_values);
							}
						}
					}else{
						$detail = $this->db->dbSelect("select * from licence_detail where licence_kanrino = '".$data['licence_kanrino']."' and newkbn <> 1", "detail");
						if(count($detail) <= 0){
							/** 新規使用所属 */
							$fields_values = array(
									"kanri_sosiki_pkey"    => $data['kanri_sosiki_pkey'],
									"sosiki_pkey"          => $data['sosiki_pkey'],
									"licencelist_pkey"     => $data['licencelist_pkey'],
									"licence_kanrino"      => $data['licence_kanrino'],
									"install_su"           => $data['install_su'],
									"hard_pkey"            => $data['hard_pkey'],
									"licence_pkey2"        => $data['licence_pkey2'], 
									"licence_no"           => $data['licence_no'],
									"tyoutatu"             => $data['tyoutatu'],
									"hokan_baitai"         => $data['hokan_baitai'],
									"hokan_basyo"          => $data['hokan_basyo'],
									"bikou"                => $data['bikou'],
									"tyoutatu_date"        => $data['tyoutatu_date'],
									"haiki_date"           => $data['haiki_date'],
									"price"                => $data['price'],
									"use_limit_date"       => $data['use_limit_date'],
									"memo"                 => $data['memo'],
									"version"              => 1,
									"newkbn"               => 0 
									      );
							$pkey = $this->db->dbInsert("\"licence\"", $fields_values);
						}else{
							$data['hold_qty'] = $detail['hold_qty'];
							/** 新規使用所属 */
							$fields_values = array(
									"kanri_sosiki_pkey"    => $detail['kanri_sosiki_pkey'],
									"sosiki_pkey"          => $data['sosiki_pkey'],
									"licencelist_pkey"     => $detail['licencelist_pkey'],
									"licence_kanrino"      => $detail['licence_kanrino'],
									"install_su"           => $data['install_su'],
									"hard_pkey"            => $detail['hard_pkey'],
									"licence_pkey2"        => $detail['licence_pkey2'], 
									"licence_no"           => $detail['licence_no'],
									"tyoutatu"             => $detail['tyoutatu'],
									"hokan_baitai"         => $data['hokan_baitai'],
									"hokan_basyo"          => $data['hokan_basyo'],
									"bikou"                => $data['bikou'],
									"tyoutatu_date"        => $detail['tyoutatu_date'],
									"haiki_date"           => $detail['haiki_date'],
									"price"                => $detail['price'],
									"use_limit_date"       => $detail['use_limit_date'],
									"memo"                 => $data['memo'],
									"version"              => 1,
									"newkbn"               => 1 
									      );
							$pkey = $this->db->dbInsert("\"licence\"", $fields_values);
						}
						$hold_qty = $this->db->dbSelect("select * from hold_licence_qty where licence_kanrino='".$data['licence_kanrino']."'", "detail");
						if(count($hold_qty) > 0){
							$where_hold_qty = "licence_kanrino ='".$data['licence_kanrino']."'";
							$fields_values = array(
									"hold_qty" => $data['hold_qty']
									      );
							$this->db->dbUpdate("\"hold_licence_qty\"", $fields_values, $where_hold_qty);
						}else{
							$fields_values = array(
									"licence_kanrino" => $data['licence_kanrino'],
									"hold_qty" => $data['hold_qty']
									      );
							$this->db->dbInsert("\"hold_licence_qty\"", $fields_values);
						}
					}
				}else{
					if($data['licence_pkey'] != ""){
						$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey = ".$data['licence_pkey']." and newkbn <> 1", "detail");
						if($detail['kanri_sosiki_pkey'] == $detail['sosiki_pkey']){
							//使用所属抽出
							$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and newkbn <> 1";
							$use_sosiki = $this->db->dbSelect("select * from licence_detail".$where_list, "list");
							for($j=0; $j<count($use_sosiki); $j++){
								if($use_sosiki[$j]['kanri_sosiki_pkey'] == $use_sosiki[$j]['sosiki_pkey']){
									$use_sosiki[$j]['sosiki_pkey'] 	= $data['sosiki_pkey'];
									$use_sosiki[$j]['install_su'] 	= $data['install_su'];
									$use_sosiki[$j]['hokan_baitai']	= $data['hokan_baitai'];
									$use_sosiki[$j]['hokan_basyo']	= $data['hokan_basyo'];
									$use_sosiki[$j]['bikou']	= $data['bikou'];
									$use_sosiki[$j]['memo']		= $data['memo'];
								}
								$use_sosiki[$j]['kanri_sosiki_pkey']	= $data['kanri_sosiki_pkey'];
								$use_sosiki[$j]['licencelist_pkey']	= $data['licencelist_pkey'];
								$use_sosiki[$j]['licence_kanrino']	= $data['licence_kanrino'];
								$use_sosiki[$j]['hard_pkey']		= $data['hard_pkey'];
								$use_sosiki[$j]['licence_pkey2']	= $data['licence_pkey2'];
								$use_sosiki[$j]['licence_no']		= $data['licence_no'];
								$use_sosiki[$j]['tyoutatu']		= $data['tyoutatu'];
								$use_sosiki[$j]['tyoutatu_date']	= $data['tyoutatu_date'];
								$use_sosiki[$j]['haiki_date']		= $data['haiki_date'];
								$use_sosiki[$j]['price']		= $data['price'];
								$use_sosiki[$j]['use_limit_date']	= $data['use_limit_date'];
								$use_sosiki[$j]['hold_qty']		= $data['hold_qty'];
							}
						}else{
							$use_sosiki[0] = $detail;
							if(!$use_only){
								$use_sosiki[0]['sosiki_pkey'] 	= $data['sosiki_pkey'];
								$use_sosiki[0]['install_su'] 	= $data['install_su'];
							}
							$use_sosiki[0]['hokan_baitai']	= $data['hokan_baitai'];
							$use_sosiki[0]['hokan_basyo']	= $data['hokan_basyo'];
							$use_sosiki[0]['bikou']		= $data['bikou'];
							$use_sosiki[0]['memo']		= $data['memo'];
						}
						for($j=0; $j<count($use_sosiki); $j++){
							$fields_values = array(
									"kanri_sosiki_pkey"    => $use_sosiki[$j]['kanri_sosiki_pkey'], 
									"sosiki_pkey"          => $use_sosiki[$j]['sosiki_pkey'],
									"licence_pkey"         => $use_sosiki[$j]['licence_pkey'], 
									"licencelist_pkey"     => $use_sosiki[$j]['licencelist_pkey'],
									"licence_kanrino"      => $use_sosiki[$j]['licence_kanrino'],
									"install_su"           => $use_sosiki[$j]['install_su'],
									"hard_pkey"            => $use_sosiki[$j]['hard_pkey'],
									"licence_pkey2"        => $use_sosiki[$j]['licence_pkey2'],
									"licence_no"           => $use_sosiki[$j]['licence_no'],
									"tyoutatu"             => $use_sosiki[$j]['tyoutatu'],
									"hokan_baitai"         => $use_sosiki[$j]['hokan_baitai'],
									"hokan_basyo"          => $use_sosiki[$j]['hokan_basyo'],
									"bikou"                => $use_sosiki[$j]['bikou'],
									"tyoutatu_date"        => $use_sosiki[$j]['tyoutatu_date'],
									"haiki_date"           => $use_sosiki[$j]['haiki_date'],
									"price"                => $use_sosiki[$j]['price'],
									"use_limit_date"       => $use_sosiki[$j]['use_limit_date'],
									"memo"                 => $use_sosiki[$j]['memo'],
									"version"              => $use_sosiki[$j]['version']
									      );
							/** 登録 */
							$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);
							if(@$shinsei_no == ""){
								$shinsei_no = $code;
							}
							$fields_values = array(
									"history_pkey"         => $code,     
									"history_type"         => "d003",     
									"email_ad"             => $_SESSION['input']['email_ad'], 
									"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
									"sinseisya"            => $_SESSION['input']['sinseisya'], 
									"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'],
									"shinsei_no"           => $shinsei_no
									      );
							$this->db->dbInsert("\"rireki\"", $fields_values);
							$fields_values = array(
									"licencehistory_pkey"  => $code,     
									"hold_qty"             => $use_sosiki[$j]['hold_qty']
									      );
							$this->db->dbInsert("\"hold_licence_qry_rireki\"", $fields_values);
						}
					}else{
						$detail = $this->db->dbSelect("select * from licence_detail where licence_kanrino = '".$data['licence_kanrino']."' and newkbn <> 1", "detail");
						if(count($detail) <= 0){
							/** 新規使用所属 */
							$fields_values = array(
									"kanri_sosiki_pkey"    => $data['kanri_sosiki_pkey'],
									"sosiki_pkey"          => $data['sosiki_pkey'],
									"licencelist_pkey"     => $data['licencelist_pkey'],
									"licence_kanrino"      => $data['licence_kanrino'],
									"install_su"           => $data['install_su'],
									"hard_pkey"            => $data['hard_pkey'],
									"licence_pkey2"        => $data['licence_pkey2'], 
									"licence_no"           => $data['licence_no'],
									"tyoutatu"             => $data['tyoutatu'],
									"hokan_baitai"         => $data['hokan_baitai'],
									"hokan_basyo"          => $data['hokan_basyo'],
									"bikou"                => $data['bikou'],
									"tyoutatu_date"        => $data['tyoutatu_date'],
									"haiki_date"           => $data['haiki_date'],
									"price"                => $data['price'],
									"use_limit_date"       => $data['use_limit_date'],
									"memo"                 => $data['memo'],
									"version"              => 1,
									"newkbn"               => 1 
									      );
							$pkey = $this->db->dbInsert("\"licence\"", $fields_values);
							/** 登録 */
							$fields_values = array(
									"kanri_sosiki_pkey"    => $data['kanri_sosiki_pkey'], 
									"sosiki_pkey"          => $data['sosiki_pkey'],
									"licence_pkey"         => $pkey, 
									"licencelist_pkey"     => $data['licencelist_pkey'],
									"licence_kanrino"      => $data['licence_kanrino'],
									"install_su"           => $data['install_su'],
									"hard_pkey"            => $data['hard_pkey'],
									"licence_pkey2"        => $data['licence_pkey2'],
									"licence_no"           => $data['licence_no'],
									"tyoutatu"             => $data['tyoutatu'],
									"hokan_baitai"         => $data['hokan_baitai'],
									"hokan_basyo"          => $data['hokan_basyo'],
									"bikou"                => $data['bikou'],
									"tyoutatu_date"        => $data['tyoutatu_date'],
									"haiki_date"           => $data['haiki_date'],
									"price"                => $data['price'],
									"use_limit_date"       => $data['use_limit_date'],
									"memo"                 => $data['memo'],
									"version"              => 1
									      );
							$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);
						}else{
							$data['hold_qty'] = $detail['hold_qty'];
							/** 新規使用所属 */
							$fields_values = array(
									"kanri_sosiki_pkey"    => $detail['kanri_sosiki_pkey'],
									"sosiki_pkey"          => $data['sosiki_pkey'],
									"licencelist_pkey"     => $detail['licencelist_pkey'],
									"licence_kanrino"      => $detail['licence_kanrino'],
									"install_su"           => $data['install_su'],
									"hard_pkey"            => $detail['hard_pkey'],
									"licence_pkey2"        => $detail['licence_pkey2'], 
									"licence_no"           => $detail['licence_no'],
									"tyoutatu"             => $detail['tyoutatu'],
									"hokan_baitai"         => $data['hokan_baitai'],
									"hokan_basyo"          => $data['hokan_basyo'],
									"bikou"                => $data['bikou'],
									"tyoutatu_date"        => $detail['tyoutatu_date'],
									"haiki_date"           => $detail['haiki_date'],
									"price"                => $detail['price'],
									"use_limit_date"       => $detail['use_limit_date'],
									"memo"                 => $data['memo'],
									"version"              => 1,
									"newkbn"               => 1 
									      );
							$pkey = $this->db->dbInsert("\"licence\"", $fields_values);
							/** 登録 */
							$fields_values = array(
									"kanri_sosiki_pkey"    => $detail['kanri_sosiki_pkey'], 
									"sosiki_pkey"          => $data['sosiki_pkey'],
									"licence_pkey"         => $pkey, 
									"licencelist_pkey"     => $detail['licencelist_pkey'],
									"licence_kanrino"      => $detail['licence_kanrino'],
									"install_su"           => $data['install_su'],
									"hard_pkey"            => $detail['hard_pkey'],
									"licence_pkey2"        => $detail['licence_pkey2'],
									"licence_no"           => $detail['licence_no'],
									"tyoutatu"             => $detail['tyoutatu'],
									"hokan_baitai"         => $data['hokan_baitai'],
									"hokan_basyo"          => $data['hokan_basyo'],
									"bikou"                => $data['bikou'],
									"tyoutatu_date"        => $detail['tyoutatu_date'],
									"haiki_date"           => $detail['haiki_date'],
									"price"                => $detail['price'],
									"use_limit_date"       => $detail['use_limit_date'],
									"memo"                 => $data['memo'],
									"version"              => 1
									      );
							$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);
						}
						if(@$shinsei_no == ""){
							$shinsei_no = $code;
						}
						$fields_values = array(
								"history_pkey"         => $code,     
								"history_type"         => "d003",     
								"email_ad"             => $_SESSION['input']['email_ad'], 
								"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
								"sinseisya"            => $_SESSION['input']['sinseisya'], 
								"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'],
								"shinsei_no"           => $shinsei_no
								      );
						$this->db->dbInsert("\"rireki\"", $fields_values);

						$fields_values = array(
								"licencehistory_pkey"  => $code,     
								"hold_qty"             => $data['hold_qty']
								      );
						$this->db->dbInsert("\"hold_licence_qry_rireki\"", $fields_values);
					}
				}
			}
		        break;
		    case "d004":
			for($i=1; $i<count($import_data); $i++){
				$data['licencelist_pkey']     = @$import_data[$i][0];
				$data['soft_name']            = @$import_data[$i][1];
				$data['edition']              = @$import_data[$i][2];
				$data['licence_keitai']       = @$import_data[$i][3];
				$data['hard_kotei']           = @$import_data[$i][4];
				$data['upgrade']              = @$import_data[$i][5];
				$data['brand']                = @$import_data[$i][6];
				$data['disabled']             = @$import_data[$i][7];
				$data['tokusitu_useproposal'] = @$import_data[$i][10];
				$data['useproposal_youken']   = @$import_data[$i][11];
				$data['bikou']                = @$import_data[$i][12];
				$data['upd_syozoku']          = @$import_data[$i][13];
				$data['upd_name']             = @$import_data[$i][14];
				$data['upd_date']             = @$import_data[$i][15];
				$data['useproposal_kakunin']  = @$import_data[$i][16];
				$data['yukou']                = @$import_data[$i][17];
				$data['memo']                 = @$import_data[$i][18];
				$data['version']              = @$import_data[$i][19];
				$data['del']                  = @$import_data[$i][20];
				if($data['version'] == ""){
					$data['version'] = 0;
				}
				
				//コードに変換
				if(!$data['upd_syozoku'] = array_search($data['upd_syozoku'],$sosiki_col)){
					$data['upd_syozoku'] = 0;
				}
				if(!$data['licence_keitai'] = array_search($data['licence_keitai'],$type_col)){
					$data['licence_keitai'] = "";
				}
				if(!$data['hard_kotei'] = array_search($data['hard_kotei'],$gaitou_col)){
					$data['hard_kotei'] = "";
				}
				if(!$data['upgrade'] = array_search($data['upgrade'],$gaitou_col)){
					$data['upgrade'] = "";
				}
				if(!$data['disabled'] = array_search($data['disabled'],$gaitou_col)){
					$data['disabled'] = "";
				}
				if(!$data['useproposal_kakunin'] = array_search($data['useproposal_kakunin'],$anpi_col)){
					$data['useproposal_kakunin'] = "";
				}
				if(!$data['yukou'] = array_search($data['yukou'],$yukou_col)){
					$data['yukou'] = "";
				}
				
				if($this->authuser_authority != 'system'){
					$detail = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey=".$data['licencelist_pkey'], "detail");
					$data['memo'] = $detail['memo'];
				}
				$where = "licencelist_pkey = ".$data['licencelist_pkey'];
				if($data['del'] == 1 and $data['licencelist_pkey'] != ""){
					$this->db->dbDelete("\"licencelist\"", $where);
					$this->db->dbDelete("\"licencelistprogram\"", $where);
				}else{
					if(@$_SESSION['input']['direct'] == "on"){
						if($data['licencelist_pkey'] == ""){
							$insert_values[] = array(
									$data['soft_name'],     
									$data['licence_keitai'],     
									$data['brand'],     
									$data['hard_kotei'],
									$data['upgrade'],
									$data['useproposal_kakunin'], 
									$data['tokusitu_useproposal'], 
									$data['useproposal_youken'], 
									$data['bikou'], 
									$data['yukou'], 
									$data['upd_date'], 
									$data['upd_name'], 
									$data['upd_syozoku'],
									$data['edition'],
									$data['disabled'],
									$data['memo'],
									1, 
									0 
									      );
						}else{
							$fields_values = array(
									"soft_name"            => $data['soft_name'],     
									"licence_keitai"       => $data['licence_keitai'],     
									"brand"                => $data['brand'],     
									"hard_kotei"           => $data['hard_kotei'],
									"upgrade"              => $data['upgrade'],
									"useproposal_kakunin"  => $data['useproposal_kakunin'], 
									"tokusitu_useproposal" => $data['tokusitu_useproposal'], 
									"useproposal_youken"   => $data['useproposal_youken'], 
									"bikou"                => $data['bikou'], 
									"yukou"                => $data['yukou'], 
									"upd_date"             => $data['upd_date'], 
									"upd_name"             => $data['upd_name'], 
									"upd_syozoku"          => $data['upd_syozoku'],
									"edition"              => $data['edition'],
									"disabled"             => $data['disabled'],
									"memo"                 => $data['memo'],
									"version"              => $data['version'] + 1
									      );
							$this->db->dbUpdate("\"licencelist\"", $fields_values, $where);
						}
					}else{
						if($data['licencelist_pkey'] == ""){
							$fields_values = array(
									"soft_name"            => $data['soft_name'],     
									"licence_keitai"       => $data['licence_keitai'],     
									"brand"                => $data['brand'],     
									"hard_kotei"           => $data['hard_kotei'],
									"upgrade"              => $data['upgrade'],
									"useproposal_kakunin"  => $data['useproposal_kakunin'], 
									"tokusitu_useproposal" => $data['tokusitu_useproposal'], 
									"useproposal_youken"   => $data['useproposal_youken'], 
									"bikou"                => $data['bikou'], 
									"yukou"                => $data['yukou'], 
									"upd_date"             => $data['upd_date'], 
									"upd_name"             => $data['upd_name'], 
									"upd_syozoku"          => $data['upd_syozoku'],
									"edition"              => $data['edition'],
									"disabled"             => $data['disabled'],
									"memo"                 => $data['memo'],
									"version"              => 1, 
									"newkbn"               => 1 
									      );
							$pkey = $this->db->dbInsert("\"licencelist\"", $fields_values);
							$fields_values = array(
									"licencelist_pkey"     => $pkey,
									"soft_name"            => $data['soft_name'],     
									"licence_keitai"       => $data['licence_keitai'],     
									"brand"                => $data['brand'],     
									"hard_kotei"           => $data['hard_kotei'],
									"upgrade"              => $data['upgrade'],
									"useproposal_kakunin"  => $data['useproposal_kakunin'], 
									"tokusitu_useproposal" => $data['tokusitu_useproposal'], 
									"useproposal_youken"   => $data['useproposal_youken'], 
									"bikou"                => $data['bikou'], 
									"yukou"                => $data['yukou'], 
									"upd_date"             => $data['upd_date'], 
									"upd_name"             => $data['upd_name'], 
									"upd_syozoku"          => $data['upd_syozoku'],
									"edition"              => $data['edition'],
									"disabled"             => $data['disabled'],
									"memo"                 => $data['memo'],
									"version"              => 1
									      );
							$code = $this->db->dbInsert("\"licencelistrireki\"", $fields_values);
						}else{
							$fields_values = array(
									"licencelist_pkey"     => $data['licencelist_pkey'],
									"soft_name"            => $data['soft_name'],     
									"licence_keitai"       => $data['licence_keitai'],     
									"brand"                => $data['brand'],     
									"hard_kotei"           => $data['hard_kotei'],
									"upgrade"              => $data['upgrade'],
									"useproposal_kakunin"  => $data['useproposal_kakunin'], 
									"tokusitu_useproposal" => $data['tokusitu_useproposal'], 
									"useproposal_youken"   => $data['useproposal_youken'], 
									"bikou"                => $data['bikou'], 
									"yukou"                => $data['yukou'], 
									"upd_date"             => $data['upd_date'], 
									"upd_name"             => $data['upd_name'], 
									"upd_syozoku"          => $data['upd_syozoku'],
									"edition"              => $data['edition'],
									"disabled"             => $data['disabled'],
									"memo"                 => $data['memo'],
									"version"              => $data['version']
									      );
							$code = $this->db->dbInsert("\"licencelistrireki\"", $fields_values);
						}
					
						$fields_values = array(
								"history_pkey"         => $code,     
								"history_type"         => "d004",     
								"email_ad"             => $_SESSION['input']['email_ad'], 
								"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
								"sinseisya"            => $_SESSION['input']['sinseisya'], 
								"sinseisyozoku"        => $_SESSION['input']['sinseisyozoku'],
								"shinsei_no"           => $code
								      );
						$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);
						if(_AUTO_APPROVAL == 1){
							$this->auto_app($code);
						}
					}
				}
			}
			if(count(@$insert_values) >= 1){
				$this->db->dbPrepare("INSERT INTO \"licencelist\" (soft_name,licence_keitai,brand,hard_kotei,upgrade,useproposal_kakunin,tokusitu_useproposal,useproposal_youken,bikou,yukou,upd_date,upd_name,upd_syozoku,edition,disabled,memo,version,newkbn) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $insert_values);
				unset($insert_values);
			}
		        break;
		    case "d005":
			for($i=1; $i<count($import_data); $i++){
				$data['licencelist_pkey'] = @$import_data[$i][0];
				$data['program_add_del']  = @$import_data[$i][1];
				$data['del']              = @$import_data[$i][2];
				
				$where = "licencelist_pkey = ".$data['licencelist_pkey']." and program_add_del = '".$data['program_add_del']."'";
				if($data['del'] == 1){
					$this->db->dbDelete("\"licencelistprogram\"", $where);
				}else{
					$insert_values[] = array(
							$data['licencelist_pkey'],
							$data['program_add_del']
							      );
				}
			}
			$tmp = array();
			foreach($insert_values as $val) {
				if (!in_array($val, $tmp)) {
					$tmp[] = $val;
				}
			}
			$insert_values = $tmp;
			if(count(@$insert_values) >= 1){
				$this->db->dbPrepare("INSERT INTO licencelistprogram (licencelist_pkey,program_add_del) VALUES (?,?)", $insert_values);
				unset($insert_values);
			}
		        break;
		    case "d010":
			for($i=1; $i<count($import_data); $i++){
				$data['licencelist_pkey'] = @$import_data[$i][0];
				$data['program_add_del']  = @$import_data[$i][1];
				$data['del']              = @$import_data[$i][2];
				
				$where = "licencelist_pkey = ".$data['licencelist_pkey']." and program_add_del = '".$data['program_add_del']."'";
				if($data['del'] == 1){
					$this->db->dbDelete("\"licencelistprogram_down\"", $where);
				}else{
					$insert_values[] = array(
							$data['licencelist_pkey'],
							$data['program_add_del']
							      );
				}
			}
			$tmp = array();
			foreach($insert_values as $val) {
				if (!in_array($val, $tmp)) {
					$tmp[] = $val;
				}
			}
			$insert_values = $tmp;
			if(count(@$insert_values) >= 1){
				$this->db->dbPrepare("INSERT INTO licencelistprogram_down (licencelist_pkey,program_add_del) VALUES (?,?)", $insert_values);
				unset($insert_values);
			}
		        break;
		    case "d006":
			for($i=1; $i<count($import_data); $i++){
				$data['program_add_del']  = @$import_data[$i][0];
				$data['del']              = @$import_data[$i][1];
				
				$where = "program_add_del = '".$data['program_add_del']."'";
				if($data['del'] == 1){
					$this->db->dbDelete("\"program\"", $where);
				}else{
					$insert_values[] = array($data['program_add_del']);
				}
			}
			if(count(@$insert_values) >= 1){
				$this->db->dbPrepare("INSERT INTO \"program\" (program_add_del) VALUES (?)", $insert_values);
				unset($insert_values);
			}
		        break;
		    case "d007":
			for($i=1; $i<count($import_data); $i++){
				$data['inventory_pkey']   = @$import_data[$i][0];
				$data['group1']           = @$import_data[$i][1];
				$data['jyotai']           = @$import_data[$i][2];
				$data['hsyubetu']         = @$import_data[$i][3];
				$data['hikaku']           = @$import_data[$i][4];
				$data['bikou']            = @$import_data[$i][36];
				$data['memo']             = @$import_data[$i][37];
				
				//コードに変換
				if(!$data['jyotai'] = array_search($data['jyotai'],$jyoutai_col)){
					$data['jyotai'] = "";
				}
				if(!$data['hsyubetu'] = array_search($data['hsyubetu'],$syubetu_col)){
					$data['hsyubetu'] = "";
				}
				if(!$data['hikaku'] = array_search($data['hikaku'],$yukou_col)){
					$data['hikaku'] = "";
				}

				$where = "inventory_pkey = ".$data['inventory_pkey'];
				if($data['inventory_pkey'] != ""){
					$fields_values = array(
							"group1"         => $data['group1'],
							"jyotai"         => $data['jyotai'],
							"hsyubetu"       => $data['hsyubetu'],
							"hikaku"         => $data['hikaku'],
							"bikou"          => $data['bikou'],
							"memo"           => $data['memo'],
							"mukou_date"     => date("Y-m-d")
							      );
					$this->db->dbUpdate("\"inventory\"", $fields_values, $where);
				}
			}
		        break;
		    case "d008":
			for($i=1; $i<count($import_data); $i++){
				$data['user_pkey']        = @$import_data[$i][0];
				$data['sosiki_full']      = @$import_data[$i][1];
				$data['user_id']          = @$import_data[$i][2];
				$data['user_name']        = @$import_data[$i][3];
				$data['auth']             = @$import_data[$i][4];
				$data['email_ad']         = @$import_data[$i][5];
				$data['pass']             = @$import_data[$i][6];
				$data['kessai']           = @$import_data[$i][7];
				$data['del']              = @$import_data[$i][8];

				//コードに変換
				if(!$data['sosiki_pkey'] = array_search($data['sosiki_full'],$sosiki_col)){
					$data['sosiki_pkey'] = "";
				}
				if(!$data['auth'] = array_search($data['auth'],$auth_col)){
					$data['auth'] = "";
				}
				
				if(!ereg("　$",$data['kessai'])){
					$data['kessai'] .= "　";
				}
				
				$where = "user_pkey = ".$data['user_pkey'];
				if($data['del'] == 1 and $data['user_pkey'] != ""){
					$this->db->dbDelete("\"user\"", $where);
				}else{
					if($data['user_pkey'] == ""){
						$insert_values[] = array(
								$data['sosiki_pkey'],
								$data['user_id'],
								$data['user_name'],
								$data['auth'],
								$data['email_ad'],
								$data['pass'],
								$data['kessai']
								      );
					}else{
						$fields_values = array(
								"sosiki_pkey"         => $data['sosiki_pkey'],
								"user_id"             => $data['user_id'],
								"user_name"           => $data['user_name'],
								"auth"                => $data['auth'],
								"email_ad"            => $data['email_ad'],
								"pass"                => $data['pass'],
								"kessai"              => $data['kessai']
								      );
						$this->db->dbUpdate("\"user\"", $fields_values, $where);
					}
				}
			}
			if(count(@$insert_values) >= 1){
				$this->db->dbPrepare("INSERT INTO \"user\" (sosiki_pkey,user_id,user_name,auth,email_ad,pass,kessai) VALUES (?,?,?,?,?,?,?)", $insert_values);
				unset($insert_values);
			}
		        break;
		    case "d009":
			for($i=1; $i<count($import_data); $i++){
				$data['sosiki_pkey']     = @$import_data[$i][3];
				$data['sosiki_onpkey']   = @$import_data[$i][0];
				$data['sosiki_sortkey']  = @$import_data[$i][5];
				$data['yukou']           = @$import_data[$i][6];
				$data['syozoku_name']    = @$import_data[$i][4];
				$data['del']             = @$import_data[$i][7];
				
				//コードに変換
				if(!$data['yukou'] = array_search($data['yukou'],$yukou_col)){
					$data['yukou'] = "";
				}

				if($data['sosiki_sortkey'] == ""){
					$data['sosiki_sortkey'] = 0;
				}

				$where = "sosiki_pkey = ".$data['sosiki_pkey'];
				if($data['del'] == 1 and $data['sosiki_pkey'] != ""){
					$this->db->dbDelete("\"sosiki\"", $where);
				}else{
					if($data['sosiki_pkey'] == ""){
						$insert_values[] = array(
								      $data['sosiki_onpkey'],
								      $data['sosiki_sortkey'],
								      $data['syozoku_name'],
								      $data['yukou']
								      );
					}else{
						$fields_values = array(
								"sosiki_onpkey"       => $data['sosiki_onpkey'],
								"sosiki_sortkey"      => $data['sosiki_sortkey'],
								"yukou"               => $data['yukou'],
								"syozoku_name"        => $data['syozoku_name'],
								      );
						$this->db->dbUpdate("\"sosiki\"", $fields_values, $where);
					}
				}
			}
			if(count(@$insert_values) >= 1){
				$this->db->dbPrepare("INSERT INTO sosiki (sosiki_onpkey,sosiki_sortkey,syozoku_name,yukou) VALUES (?,?,?,?)", $insert_values);
				unset($insert_values);
			}
			$list = $this->db->dbSelect("SELECT * FROM \"sosiki\" order by sosiki_sortkey", "list");

			for($i=0; $i<count($list); $i++){
				$fullname = implode("/",full_sosiki_name($list[$i]['sosiki_pkey']));
				$where = "sosiki_pkey = ".$list[$i]['sosiki_pkey'];
				$fields_values = array(
						"syozoku_fullname"   => $fullname
						      );
				$this->db->dbUpdate("sosiki", $fields_values, $where);
				
				#「sosiki_path」更新
				$parent_sosiki_array = parent_sosiki_array($list[$i]['sosiki_pkey']);
				$parent_sosiki = implode(",",$parent_sosiki_array);
				$child_sosiki_array = child_sosiki_array($list[$i]['sosiki_pkey']);
				$child_sosiki = implode(",",$child_sosiki_array);
				$sosiki_path_detail = $this->db->dbSelect("SELECT * FROM sosiki_path where sosiki_pkey = ".$list[$i]['sosiki_pkey'], "detail");
				if(count($sosiki_path_detail) > 0){
					$where_sosiki = "sosiki_pkey = ".$list[$i]['sosiki_pkey'];
					$fields_values = array(
							"parent_sosiki"  => $parent_sosiki,
							"child_sosiki"   => $child_sosiki
							      );
					$this->db->dbUpdate("sosiki_path", $fields_values, $where_sosiki);
				}else{
					$insert_values = array(
							"sosiki_pkey"  => $list[$i]['sosiki_pkey'],
							"parent_sosiki"  => $parent_sosiki,
							"child_sosiki"   => $child_sosiki
							      );
					$this->db->dbInsert("sosiki_path", $insert_values);
				}
			}
		        break;
		}
		/** 出力 */
		$table = select_code("00009");

		$this->tpl->assignHtml('name',$table[$import_table]);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_IMPORT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}
	
	/**
	 * チェック
	 */
	function check($import_table,$import_data){
		#入力チェック
		$cci = new CheckItem;
		$cci_tmp = new CheckItem;
		
		$cci->checkItemNon(array("email_ad"=>"申請者メールアドレス"));
		$cci->checkItemEmailArray(array("email_ad"=>"申請者メールアドレス"));
		
		$email_ad = explode("@",@$_SESSION['input']['email_ad']);
		if(count($email_ad)>=2){
			if(!in_array($email_ad[1],select_code("00027")) and _ERROR_0254){
				$cci->checkErrorCode("0254");
			}
		}
		if(@$_SESSION['input']['sinseisya'] == "" and _ERROR_0201){
			$cci->checkErrorCode("0201");
		}
		if(@$_SESSION['input']['sinsei_date'] == "" and _ERROR_0202){
			$cci->checkErrorCode("0202");
		}
		$cci->checkItemDateTime(array("sinsei_date"=>"申請日"));

		if(count($import_data) <= 1){
			$cci->checkErrorText("インポート件数が0件です。");
		}

		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);

		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_pop($full);
		$full_array = array_merge($child_array,$full);

		//組織名取得(array)
		$sosiki_col = array();
		$sosiki_col_array = $this->db->dbSelect("SELECT sosiki_pkey,syozoku_fullname FROM sosiki", "list");
		if(count($sosiki_col_array) > 0){
			for($i=0; $i<count($sosiki_col_array); $i++){
				$sosiki_col[$sosiki_col_array[$i]['sosiki_pkey']] = $sosiki_col_array[$i]['syozoku_fullname'];
			}
		}
		//使用者によるソフトウェア追加導入・削除取得(array)
		$soft_installdel = select_code('00022');
		//該当取得(array)
		$gaitou_col = select_code('00004');
		//有効取得(array)
		$yukou_col = select_code('00007');
		//認証取得(array)
		$auth_col = select_code('00023');
		//種別取得(array)
		$syubetu_col = select_code('00001');
		//状態取得(array)
		$jyoutai_col = select_code('00002');
		//種類取得(array)
		$type_col = select_code('00005');
		//要否取得(array)
		$anpi_col = select_code('00006');


		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}else{
			switch ($import_table) {
			    case "d001":
				for($i=1; $i<count($import_data); $i++){
					//ハードウェア管理番号の空白文字除去と全角英数を半角に変換
					$import_data[$i][2] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][2], 'rnsKHV'));
					
					$data['hard_pkey']        = @$import_data[$i][0];
					$data['sosiki_full']      = @$import_data[$i][1];
					$data['hard_kanrino']     = @$import_data[$i][2];
					$data['use_name']         = @$import_data[$i][5];
					$data['price']            = @$import_data[$i][9];
					$data['tyoutatu']         = @$import_data[$i][10];
					$data['location']         = @$import_data[$i][11];
					$data['bikou']            = @$import_data[$i][12];
					$data['tyoutatu_date']    = @$import_data[$i][13];
					$data['haiki_date']       = @$import_data[$i][14];
					$data['soft_installdel']  = @$import_data[$i][15];
					$data['memo']             = @$import_data[$i][16];

					if($data['hard_pkey'] != ""){
						$list = $this->db->dbSelect("select * from hard where hard_pkey = ".$data['hard_pkey'], "list");
						if(count($list) <> 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"該当するハードウェアが見つかりません。"));
							break;
						}
						#自所属と下部組織のみ編集可能
						$hardware = $this->db->dbSelect("select * from hard where hard_pkey = '".$data['hard_pkey']."'", "detail");
						if(!in_array($hardware['sosiki_pkey'],$child_array) and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"他所属のハードウェアは修正できません。"));
							break;
						}
					}
					if($data['hard_kanrino'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ハードウェア管理番号を記載してください。"));
						break;
					}
					if($data['use_name'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"使用者名を記載してください。"));
						break;
					}
					if($data['sosiki_full'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"所属を記載してください。"));
						break;
					}
					if(!in_array($data['sosiki_full'],$sosiki_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"記載された所属は存在しません。"));
						break;
					}
					if($this->authuser_authority == 'system' or $data['soft_installdel'] != ""){
						if(!in_array($data['soft_installdel'],$soft_installdel) and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"使用者によるソフトウェア追加導入・削除に記載された項目は選択項目に存在しません。"));
							break;
						}
					}
					if(!ereg ("^([12][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})$", $data['tyoutatu_date']) and $data['tyoutatu_date'] != "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"調達日の入力形式が間違っています。yyyy/mm/ddの形式で入力してください"));
						break;
					}
					if(!ereg ("^([12][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})$", $data['haiki_date']) and $data['haiki_date'] != "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"廃棄日の入力形式が間違っています。yyyy/mm/ddの形式で入力してください"));
						break;
					}
				
					if(!ereg ("^[0-9]*$", $data['price']) and $data['price'] != "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"調達金額は半角数字で入力してください"));
						break;
					}
				}
			        break;
			    case "d002":
				for($i=1; $i<count($import_data); $i++){
					//ハードウェア管理番号＋ライセンス管理番号の空白文字除去と全角英数を半角に変換
					$import_data[$i][2] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][2], 'rnsKHV'));
					$import_data[$i][4] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][4], 'rnsKHV'));

					$data['soft_pkey']        = @$import_data[$i][0];
					$data['hard_kanrino']     = @$import_data[$i][2];
					$data['licence_kanrino']  = @$import_data[$i][4];
					$data['downgrade']        = @$import_data[$i][9];
					$data['bikou']            = @$import_data[$i][11];
					$data['install_date']     = @$import_data[$i][12];
					$data['uninstall_date']   = @$import_data[$i][13];
					$data['memo']             = @$import_data[$i][14];
				
					if($data['soft_pkey'] != ""){
						$list = $this->db->dbSelect("select * from soft where soft_pkey = ".$data['soft_pkey'], "list");
						if(count($list) <> 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"該当するソフトウェアが見つかりません。"));
							break;
						}
					}
					if($data['hard_kanrino'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ハードウェア管理番号を記載してください。"));
						break;
					}
					if($data['hard_kanrino'] != ""){
						$list = $this->db->dbSelect("select * from hard where hard_kanrino = '".$data['hard_kanrino']."' and newkbn <> 1", "list");
						if(count($list) < 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"記載されたハードウェア管理番号は存在しません。"));
							break;
						}
					}
					if($data['licence_kanrino'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ライセンス管理番号を記載してください。"));
						break;
					}
					if($data['licence_kanrino'] != ""){
						$list = $this->db->dbSelect("select * from licence where licence_kanrino = '".$data['licence_kanrino']."' and newkbn <> 1", "list");
						if(count($list) < 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"記載されたライセンス管理番号は存在しません。"));
							break;
						}
					}
					if($data['soft_pkey'] == ""){
						if($data['licence_kanrino'] != "" and $data['hard_kanrino'] != ""){
							$list = $this->db->dbSelect("select * from soft_detail where hard_kanrino = '".$data['hard_kanrino']."' and licence_kanrino = '".$data['licence_kanrino']."' and (haiki_date > '".date("Y/m/d")."' or haiki_date is null) and newkbn <> 1", "list");
							if(count($list) > 0 or $this->db->error != "" and _ERROR_0012){
								$cci->checkErrorCode("0012",array($i,"選択された「ライセンス」は既に登録されています。ライセンスを重複登録することはできません。"));
								break;
							}
						}
					}
					if(!in_array($data['downgrade'], $gaitou_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ダウングレード使用に記載された項目は選択項目に存在しません。"));
						break;
					}
					if(!ereg ("^([12][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})$", $data['install_date']) and $data['install_date'] != "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"導入日の入力形式が間違っています。yyyy/mm/ddの形式で入力してください"));
						break;
					}
					if(!ereg ("^([12][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})$", $data['uninstall_date']) and $data['uninstall_date'] != "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"削除日の入力形式が間違っています。yyyy/mm/ddの形式で入力してください"));
						break;
					}
				
					#自所属と下部組織のハードウェアと上下部組織のライセンスのみ選択可能
					$hardware = $this->db->dbSelect("select * from hard where hard_kanrino = '".$data['hard_kanrino']."' and newkbn <> 1", "detail");
					if(!in_array(@$hardware['sosiki_pkey'],$child_array) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"他所属のハードウェアは選択できません。"));
						break;
					}
					$licence_array = $this->db->dbSelect("select * from licence where licence_kanrino = '".$data['licence_kanrino']."' and newkbn <> 1", "list");
					$licence_sosiki_f = false;
					if(count($licence_array) > 0){
						for($j=0; $j<count($licence_array); $j++){
							if(in_array($licence_array[$j]['sosiki_pkey'],$full_array)){
								$licence_sosiki_f = true;
							}
						}
					}
					if(!$licence_sosiki_f and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"他所属のライセンスは選択できません。"));
						break;
					}
				}
			        break;
			    case "d003":
				for($i=1; $i<count($import_data); $i++){
					//ハードウェア管理番号＋ライセンス管理番号の空白文字除去と全角英数を半角に変換
					$import_data[$i][3] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][3], 'rnsKHV'));
					$import_data[$i][9] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][9], 'rnsKHV'));
					$import_data[$i][11] = preg_replace("/[\s]/","",mb_convert_kana(@$import_data[$i][11], 'rnsKHV'));

					$data['licence_pkey']     = @$import_data[$i][0];
					$data['kanri_sosiki_full']= @$import_data[$i][1];
					$data['sosiki_full']      = @$import_data[$i][2];
					$data['licence_kanrino']  = @$import_data[$i][3];
					$data['licencelist_pkey'] = @$import_data[$i][4];
					$data['hard_kanrino']     = @$import_data[$i][9];
					$data['licence_kanrino2'] = @$import_data[$i][11];
					$data['hold_qty']         = @$import_data[$i][13];
					$data['install_su']       = @$import_data[$i][14];
					$data['licence_no']       = @$import_data[$i][16];
					$data['price']            = @$import_data[$i][17];
					$data['tyoutatu']         = @$import_data[$i][18];
					$data['hokan_baitai']     = @$import_data[$i][21];
					$data['hokan_basyo']      = @$import_data[$i][22];
					$data['bikou']            = @$import_data[$i][25];
					$data['tyoutatu_date']    = @$import_data[$i][26];
					$data['use_limit_date']   = @$import_data[$i][27];
					$data['haiki_date']       = @$import_data[$i][28];
					$data['memo']             = @$import_data[$i][29];
				
					if(!$data['sosiki_pkey'] = array_search($data['sosiki_full'],$sosiki_col)){
						$data['sosiki_pkey'] = 0;
					}
					if(!$data['kanri_sosiki_pkey'] = array_search($data['kanri_sosiki_full'],$sosiki_col)){
						$data['kanri_sosiki_pkey'] = 0;
					}
					#自所属と下部組織のみ編集可能
					if($data['licence_pkey'] != ""){
						$detail = $this->db->dbSelect("select * from licence where licence_pkey = ".$data['licence_pkey'], "detail");
						if(!in_array(@$detail['sosiki_pkey'],$child_array) and !in_array(@$detail['kanri_sosiki_pkey'],$child_array) and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"他所属のライセンスは修正できません。"));
							break;
						}
						$use_sosiki_list = $this->db->dbSelect("select * from licence where licence_kanrino = '".$data['licence_kanrino']."' and licence_pkey <> ".$data['licence_pkey']." and sosiki_pkey = ".$data['sosiki_pkey']." and newkbn <> 1", "list");
					}else{
						$detail = $this->db->dbSelect("select * from licence where licence_kanrino = '".$data['licence_kanrino']."' and newkbn <> 1", "detail");
						if(@$detail['kanri_sosiki_pkey']){
							if(!in_array(@$detail['kanri_sosiki_pkey'],$child_array) and _ERROR_0012){
								$cci->checkErrorCode("0012",array($i,"他所属のライセンスは修正できません。"));
								break;
							}
						}
						$use_sosiki_list = $this->db->dbSelect("select * from licence where licence_kanrino = '".$data['licence_kanrino']."' and sosiki_pkey = ".$data['sosiki_pkey']." and newkbn <> 1", "list");
					}
					if(count(@$use_sosiki_list)){
						$cci->checkErrorCode("0012",array($i,"記載されたライセンス管理番号において使用所属が既に存在しています。"));
						break;
					}

					$use_only = false;
					if($data['licence_pkey'] != ""){
						$list = $this->db->dbSelect("select * from licence where licence_pkey = ".$data['licence_pkey'], "list");
						if(count($list) <> 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"該当するライセンスが見つかりません。"));
							break;
						}
						if(in_array($list[0]['sosiki_pkey'],$child_array) and !in_array($list[0]['kanri_sosiki_pkey'],$child_array)){
							$use_only = true;
						}
					}
					
					if(!$use_only){
						if(!$data['kanri_sosiki_pkey'] = array_search($data['kanri_sosiki_full'],$sosiki_col) and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"記載された管理所属は存在しません。"));
							break;
						}
						if(!$data['sosiki_pkey'] = array_search($data['sosiki_full'],$sosiki_col) and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"記載された使用所属は存在しません。"));
							break;
						}
						if($data['licence_kanrino'] == "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"ライセンス管理番号を記載してください。"));
							break;
						}
						if($data['licencelist_pkey'] == "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"ライセンス一覧表一覧コードを記載してください。"));
							break;
						}
						if(!ereg("^[0-9]+$",$data['hold_qty']) and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"保有数は半角数字で入力してください"));
							break;
						}
						if($data['install_su'] != "" and _ERROR_0012){
							if(!ereg("^[0-9]+$",$data['install_su'])){
								$cci->checkErrorCode("0012",array($i,"導入可能数は半角数字で入力してください"));
								break;
							}
						}
						if($data['price'] != "" and _ERROR_0012){
							if(!ereg("^[0-9]+$",$data['price'])){
								$cci->checkErrorCode("0012",array($i,"調達金額は半角数字で入力してください"));
								break;
							}
						}
						if(!ereg ("^([12][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})$", $data['tyoutatu_date']) and $data['tyoutatu_date'] != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"調達日の入力形式が間違っています。yyyy/mm/ddの形式で入力してください"));
							break;
						}
						if(!ereg ("^([12][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})$", $data['use_limit_date']) and $data['use_limit_date'] != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"使用期限の入力形式が間違っています。yyyy/mm/ddの形式で入力してください"));
							break;
						}
						if(!ereg ("^([12][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})$", $data['haiki_date']) and $data['haiki_date'] != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"廃棄日の入力形式が間違っています。yyyy/mm/ddの形式で入力してください"));
							break;
						}
					}
					if($data['hokan_baitai'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ライセンス媒体を記載してください。"));
						break;
					}
					if($data['hokan_basyo'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"保管場所を記載してください。"));
						break;
					}
				
					#自所属と上下部組織のハードウェアとライセンスのみ選択可能
					if($data['hard_kanrino'] != ""){
						$hardware = $this->db->dbSelect("select * from hard where hard_kanrino = '".$data['hard_kanrino']."' and newkbn <> 1", "detail");
						if(!in_array(@$hardware['sosiki_pkey'],$full_array) and @$hardware['sosiki_pkey'] != $data['sosiki_pkey'] and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"他所属の固定先ハードウェアは選択できません。"));
							break;
						}
					}
					if($data['licence_kanrino2'] != ""){
						$licence_kanrino2_array = explode("\n",$data['licence_kanrino2']);
						$licence_sosiki_f_one = true;
						if(count($licence_kanrino2_array) > 0){
							for($k=0; $k<count($licence_kanrino2_array); $k++){
								$licence_array = $this->db->dbSelect("select * from licence where licence_kanrino = '".$licence_kanrino2_array[$k]."' and newkbn <> 1", "list");
								$licence_sosiki_f = false;
								if(count($licence_array) > 0){
									for($j=0; $j<count($licence_array); $j++){
										if(in_array($licence_array[$j]['sosiki_pkey'],$full_array)){
											$licence_sosiki_f = true;
										}
									}
								}
								if(!$licence_sosiki_f){
									$licence_sosiki_f_one = false;
								}
							}
						}
						if(!$licence_sosiki_f_one and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"他所属のアップグレード元ライセンスは選択できません。"));
							break;
						}
					}
					
				}
			        break;
			    case "d004":

//暫定処置　2012/03/26　根本解決し削除すること
if(@$_SESSION['input']['direct'] != "on" and _ERROR_0009){
	$cci->checkErrorCode("0009");
	break;
}
//暫定処置　2012/03/26　根本解決し削除すること
				for($i=1; $i<count($import_data); $i++){
					$data['licencelist_pkey']     = @$import_data[$i][0];
					$data['soft_name']            = @$import_data[$i][1];
					$data['edition']              = @$import_data[$i][2];
					$data['licence_keitai']       = @$import_data[$i][3];
					$data['hard_kotei']           = @$import_data[$i][4];
					$data['upgrade']              = @$import_data[$i][5];
					$data['brand']                = @$import_data[$i][6];
					$data['disabled']             = @$import_data[$i][7];
					$data['tokusitu_useproposal'] = @$import_data[$i][10];
					$data['useproposal_youken']   = @$import_data[$i][11];
					$data['bikou']                = @$import_data[$i][12];
					$data['upd_syozoku']          = @$import_data[$i][13];
					$data['upd_name']             = @$import_data[$i][14];
					$data['upd_date']             = @$import_data[$i][15];
					$data['useproposal_kakunin']  = @$import_data[$i][16];
					$data['yukou']                = @$import_data[$i][17];
					$data['memo']                 = @$import_data[$i][18];
				
					if($data['licencelist_pkey'] != ""){
						$list = $this->db->dbSelect("select * from licencelist where licencelist_pkey = ".$data['licencelist_pkey'], "list");
						if(count($list) <> 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"該当するライセンス一覧表が見つかりません。"));
							break;
						}
					}
					if($data['soft_name'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ソフトウェア名を記載してください。"));
						break;
					}
					if($data['tokusitu_useproposal'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"特筆すべき使用許諾条件を記載してください。特筆すべき使用許諾条件が全くないライセンスの場合は「なし」と記載してください。"));
						break;
					}
					if($data['useproposal_youken'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ライセンス保有証明部材を記載してください。使用許諾条件を読み、導入及び使用について何の条件も付されていない（台数制限ももちろんない）ことが確認できた場合は「なし」と記載してください。"));
						break;
					}
					if(!in_array($data['licence_keitai'], $type_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"種類に記載された項目は選択項目に存在しません。"));
						break;
					}
					if(!in_array($data['hard_kotei'], $gaitou_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ハードウェア固定に記載された項目は選択項目に存在しません。"));
						break;
					}
					if(!in_array($data['upgrade'], $gaitou_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"アップグレード版に記載された項目は選択項目に存在しません。"));
						break;
					}
					if(!in_array($data['disabled'], $gaitou_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"使用禁止に記載された項目は選択項目に存在しません。"));
						break;
					}
					if(!in_array($data['useproposal_kakunin'], $anpi_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"使用許諾条件の定期確認に記載された項目は選択項目に存在しません。"));
						break;
					}

					if(!in_array($data['yukou'], $yukou_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"有効に記載された項目は選択項目に存在しません。"));
						break;
					}

					if(!ereg ("^([12][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})$", $data['upd_date']) and $data['upd_date'] != "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"承認日の入力形式が間違っています。yyyy/mm/ddの形式で入力してください"));
						break;
					}
					if(!$data['upd_syozoku'] = array_search($data['upd_syozoku'],$sosiki_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"記載された申請者所属は存在しません。"));
						break;
					}
					if($data['upd_name'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"申請者を記載してください。"));
						break;
					}
				}
			        break;
			    case "d005":
				for($i=1; $i<count($import_data); $i++){
					$data['licencelist_pkey'] = @$import_data[$i][0];
					$data['program_add_del']  = @$import_data[$i][1];
					$data['del']              = @$import_data[$i][2];
				
					if($data['program_add_del'] != "" and $data['licencelist_pkey'] != ""){
						$list = $this->db->dbSelect("select * from licencelistprogram where program_add_del = '".$data['program_add_del']."' and licencelist_pkey = '".$data['licencelist_pkey']."'", "list");
						if(count($list) > 0 and $data['del'] != 1 and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"記載されたプログラムの追加と削除での表示は既に登録されています。プログラムの追加と削除での表示を重複登録することはできません。"));
							break;
						}
					}
					if($data['licencelist_pkey'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"一覧コードを記載してください。"));
						break;
					}
					if($data['program_add_del'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"プログラムの追加と削除での表示を記載してください。"));
						break;
					}
				}
			        break;
			    case "d010":
				for($i=1; $i<count($import_data); $i++){
					$data['licencelist_pkey'] = @$import_data[$i][0];
					$data['program_add_del']  = @$import_data[$i][1];
					$data['del']              = @$import_data[$i][2];
				
					if($data['program_add_del'] != "" and $data['licencelist_pkey'] != ""){
						$list = $this->db->dbSelect("select * from licencelistprogram_down where program_add_del = '".$data['program_add_del']."' and licencelist_pkey = '".$data['licencelist_pkey']."'", "list");
						if(count($list) > 0 and $data['del'] != 1 and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"記載されたダウングレード使用時のプログラムの追加と削除での表示は既に登録されています。ダウングレード使用時のプログラムの追加と削除での表示を重複登録することはできません。"));
							break;
						}
					}
					if($data['licencelist_pkey'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"一覧コードを記載してください。"));
						break;
					}
					if($data['program_add_del'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"プログラムの追加と削除での表示を記載してください。"));
						break;
					}
				}
			        break;
			    case "d006":
				for($i=1; $i<count($import_data); $i++){
					$data['program_add_del']  = @$import_data[$i][0];
					$data['del']              = @$import_data[$i][1];
				
					if($data['program_add_del'] != ""){
						$list = $this->db->dbSelect("select * from program where program_add_del = '".$data['program_add_del']."'", "list");
						if(count($list) > 0 and $data['del'] != 1 and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"記載されたプログラムの追加と削除での表示は既に登録されています。プログラムの追加と削除での表示を重複登録することはできません。"));
							break;
						}
					}
					if($data['program_add_del'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"プログラムの追加と削除での表示を記載してください。"));
						break;
					}
				}
			        break;
			    case "d007":
				for($i=1; $i<count($import_data); $i++){
					$data['inventory_pkey']   = @$import_data[$i][0];
					$data['group1']           = @$import_data[$i][1];
					$data['jyotai']           = @$import_data[$i][2];
					$data['hsyubetu']         = @$import_data[$i][3];
					$data['hikaku']           = @$import_data[$i][4];

					if($data['inventory_pkey'] != ""){
						$list = $this->db->dbSelect("select * from inventory where inventory_pkey = ".$data['inventory_pkey'], "list");
						if(count($list) <> 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"該当する収集情報が見つかりません。"));
							break;
						}
					}
					if($data['group1'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"所属を記載してください。"));
						break;
					}
					if(!in_array($data['jyotai'], $jyoutai_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"状態に記載された項目は選択項目に存在しません。"));
						break;
					}
					if(!in_array($data['hsyubetu'], $syubetu_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ハードウェア種別に記載された項目は選択項目に存在しません。"));
						break;
					}
					if(!in_array($data['hikaku'], $yukou_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"台帳比較に記載された項目は選択項目に存在しません。"));
						break;
					}
				}
			        break;
			    case "d008":
				for($i=1; $i<count($import_data); $i++){
					$data['user_pkey']        = @$import_data[$i][0];
					$data['sosiki_full']      = @$import_data[$i][1];
					$data['user_id']          = @$import_data[$i][2];
					$data['user_name']        = @$import_data[$i][3];
					$data['auth']             = @$import_data[$i][4];
					$data['email_ad']         = @$import_data[$i][5];
					$data['pass']             = @$import_data[$i][6];
					$data['kessai']           = @$import_data[$i][7];
				
					if($data['user_pkey'] != ""){
						$list = $this->db->dbSelect("select * from \"user\" where user_pkey = ".$data['user_pkey'], "list");
						if(count($list) <> 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"該当するユーザーが見つかりません。"));
							break;
						}
					}
					if(!$data['sosiki_pkey'] = array_search($data['sosiki_full'],$sosiki_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"記載された所属は存在しません。"));
						break;
					}
					if($data['user_id'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ユーザーIDを記載してください。"));
						break;
					}
					if(!ereg("^[0-9a-zA-Z,_,-]+$",$data['user_id']) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ユーザーIDは半角英数字で入力してください。"));
						break;
					}
					if($data['user_name'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"ユーザー名を記載してください。"));
						break;
					}
					if(!in_array($data['auth'], $auth_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"権限に記載された項目は選択項目に存在しません。"));
						break;
					}
					if($data['email_ad'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"メールアドレスを記載してください。"));
						break;
					}
					if($data['pass'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"パスワードを記載してください。"));
						break;
					}
					if($data['kessai'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"決裁欄を記載してください。"));
						break;
					}
				}
			        break;
			    case "d009":
				for($i=1; $i<count($import_data); $i++){
					$data['sosiki_pkey']     = @$import_data[$i][3];
					$data['sosiki_onpkey']   = @$import_data[$i][0];
					$data['sosiki_sortkey']  = @$import_data[$i][5];
					$data['yukou']           = @$import_data[$i][6];
					$data['syozoku_name']    = @$import_data[$i][4];
				
					if($data['sosiki_pkey'] != ""){
						$list = $this->db->dbSelect("select * from sosiki where sosiki_pkey = '".$data['sosiki_pkey']."'", "list");
						if(count($list) <> 1 or $this->db->error != "" and _ERROR_0012){
							$cci->checkErrorCode("0012",array($i,"該当する所属が見つかりません。"));
							break;
						}
					}
					if(!ereg("^[0-9]+$",$data['sosiki_onpkey']) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"親所属内部キーは半角数字で入力してください。"));
						break;
					}
					if(!ereg("^[0-9]+$",$data['sosiki_sortkey']) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"所属コードは半角数字で入力してください。"));
						break;
					}
					if($data['syozoku_name'] == "" and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"所属を記載してください。"));
						break;
					}
					if(!in_array($data['yukou'], $yukou_col) and _ERROR_0012){
						$cci->checkErrorCode("0012",array($i,"有効に記載された項目は選択項目に存在しません。"));
						break;
					}
				}
			        break;
			}
		
			if($cci->error_flag == true){
				/** ｾｯｼｮﾝ登録 */
				$_SESSION['input']['error_flag']  = true;
				$_SESSION['input']['error_msg']   = $cci->error_msg;
			}
		}
	}

	function auto_app($pkey){

		$where = "licencehistory_pkey = ".$pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where ".$where, "detail");
		if($detail['program_add_del']){
			$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
			$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
		}else{
			$detail['program_add_del'] = array();
		}
		if($detail['program_add_del_down']){
			$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
			$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
		}else{
			$detail['program_add_del_down'] = array();
		}
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_name']);
			$where = "history_pkey = ".$pkey." and history_type = 'd004'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => "d001",
					"syoninsya"           => "システム管理者",
					"syonin_date"         => date("Y/m/d")
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);
			
			$where = "licencelist_pkey = ".$detail['licencelist_pkey'];
			$fields_values = array(
					"soft_name"            => $detail['soft_name'],     
					"licence_keitai"       => $detail['licence_keitai'],     
					"brand"                => $detail['brand'],     
					"hard_kotei"           => $detail['hard_kotei'],
					"upgrade"              => $detail['upgrade'],
					"useproposal_kakunin"  => $detail['useproposal_kakunin'], 
					"tokusitu_useproposal" => $detail['tokusitu_useproposal'], 
					"useproposal_youken"   => $detail['useproposal_youken'], 
					"bikou"                => $detail['bikou'], 
					"yukou"                => $detail['yukou'], 
					"version"              => $detail['version'] + 1, 
					"upd_date"             => $detail['sinsei_date'], 
					"upd_name"             => $detail['sinseisya'], 
					"upd_syozoku"          => $detail['sinseisyozoku'], 
					"edition"              => $detail['edition'],
					"disabled"             => $detail['disabled'],
					"memo"                 => $detail['memo'],
					"newkbn"               => 0
					      );
			$this->db->dbUpdate("\"licencelist\"", $fields_values, $where);
			$code = $detail['licencelist_pkey'];
			
			$where = "licencelist_pkey = ".$code;
			$this->db->dbDelete("\"licencelistprogram\"", $where);

			for($i=0; $i<count($detail['program_add_del']); $i++){
				$fields_values = array(
						"licencelist_pkey"     => $code,
						"program_add_del"      => $detail['program_add_del'][$i]
						      );
				$this->db->dbInsert("\"licencelistprogram\"", $fields_values);
			}
			for($i=0; $i<count($detail['program_add_del_down']); $i++){
				$fields_values = array(
						"licencelist_pkey"     => $code,
						"program_add_del"      => $detail['program_add_del_down'][$i]
						      );
				$this->db->dbInsert("\"licencelistprogram_down\"", $fields_values);
			}
		}
	}

	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "";
		$this->login($page_name);
		
		$name = $_REQUEST['code'];
		
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=".$name.".csv");

		print $this->tpl->fetchHtml('sample/'.$name.'.csv');
	}
	
}

?>