<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** ハードウェア一覧管理 */
class HardwareModel extends Model{

	/**
	 * ﾕｰｻﾞｰcode(登録者)
	 * @var int
	 */
	var $authuser_code;

	/**
	 * 一覧
	 */
	function index(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
			$_REQUEST['search_haiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);
		$this->tpl->assignHtml('search_haiki',@$_REQUEST['search_haiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "sosiki_sortkey";
			$sort_default = true;
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);
		if($this->sort == 'hard_kanrino' and $this->asc == "ASC"){
			$this->sort = "LENGTH(hard_kanrino),hard_kanrino";
		}elseif($this->sort == 'hard_kanrino' and $this->asc == "DESC"){
			$this->sort = "LENGTH(hard_kanrino) DESC,hard_kanrino";
		}
		if(@$sort_default){
			$order = " order by sosiki_sortkey,LENGTH(hard_kanrino),hard_kanrino";
		}else{
			$order = " order by ".$this->sort." ".$this->asc;
		}

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "002";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "sosiki_fullname";
				        break;
				    case "002":
					$s_col = "hard_kanrino";
				        break;
				    case "003":
					$s_col = "computername";
				        break;
				    case "004":
					$s_col = "ipaddress";
				        break;
				    case "005":
					$s_col = "use_name";
				        break;
				    case "006":
					$s_col = "soft_qty";
				        break;
				    case "007":
					$s_col = "soft_installdel_name";
				        break;
				    case "008":
					$s_col = "machinevendor";
				        break;
				    case "009":
					$s_col = "machinename";
				        break;
				    case "010":
					$s_col = "tyoutatu";
				        break;
				    case "011":
					$s_col = "bikou";
				        break;
				    case "012":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "013":
					$s_col = "haiki_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "014":
					$s_col = "price";
				        break;
				    case "015":
					$s_col = "bikou";
				        break;
				    case "016":
					$s_col = "location";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= ") and newkbn <> 1";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";

		if(@$_REQUEST['search_haiki'] == "on"){
			$where .= " and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";
		}

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM hard_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi($list['count'], $count, $url, $param);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM hard_detail".$where.$order.$limit, "list");
			if(count($list_limit) > 0){
				for($i=0; $i<count($list_limit); $i++){
					if(in_array($list_limit[$i]['sosiki_pkey'],$child_array)){
						$list_limit[$i]['app_edit_ok'] = true;
					}else{
						$list_limit[$i]['app_edit_ok'] = false;
					}
					#インベントリが複数ある場合収集情報アイコンを非表示
					$inv_where = "where hardwareno = '".$list_limit[$i]['hard_kanrino']."'";
					$inv_list = $this->db->dbSelect("SELECT count(*) FROM inventory ".$inv_where, "detail");
					$list_limit[$i]['inventory_count'] = $inv_list['count'];
				
				}
			}
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;
		/** set template */
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/list.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * 新規追加
	 * 入力
	 */
	function app_reg(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i:s");
			$item['sosiki_pkey'] = $user_detail['sosiki_pkey'];
			$user_referer = _USER_REFERER;

			//ハードウェア管理番号自動採番
			if(_NUMBERING_SET){
				//ID取得
				$fields_values = array("create_date" => date("Y/m/d H:i:s"));
				$id = $this->db->dbInsert("hard_kanrino_numbering", $fields_values);
				//最大値設定
				if(strlen($id) > _ZORO_PADDING and _ZORO_PADDING){
					$maxno = 1;
					for($i=1; $i<=_ZORO_PADDING; $i++){
						$maxno = $maxno * 10;
					}
					$id = $maxno - 1;
				}
				//ゼロパディング設定
				$kanrino = (string)$id;
				if(_ZORO_PADDING){
					$format = "%0"._ZORO_PADDING."d";
					$kanrino = sprintf($format, $kanrino);
				}
				//管理番号
				$item['hard_kanrino'] = _HARD_PREFIX.$kanrino;
			}

		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 確認
	 */
	function app_reg_conf(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_reg";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 新規追加
	 * 登録
	 */
	function app_reg_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_reg";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			/** 登録 */
			$fields_values = array(
					"sosiki_pkey"          => $_SESSION['input']['sosiki_pkey'],     
					"hard_kanrino"         => $_SESSION['input']['hard_kanrino'],     
					"soft_installdel"      => $_SESSION['input']['soft_installdel'],
					"use_name"             => $_SESSION['input']['use_name'],
					"price"                => $_SESSION['input']['price'], 
					"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
					"location"             => $_SESSION['input']['location'], 
					"bikou"                => $_SESSION['input']['bikou'], 
					"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'], 
					"haiki_date"           => $_SESSION['input']['haiki_date'], 
					"memo"                 => @$_SESSION['input']['memo'], 
					"version"              => 1, 
					"newkbn"               => 1 
					      );
			$pkey = $this->db->dbInsert("\"hard\"", $fields_values);
			$fields_values = array(
					"hard_pkey"            => $pkey,     
					"sosiki_pkey"          => $_SESSION['input']['sosiki_pkey'],     
					"hard_kanrino"         => $_SESSION['input']['hard_kanrino'],     
					"soft_installdel"      => $_SESSION['input']['soft_installdel'],
					"use_name"             => $_SESSION['input']['use_name'],
					"price"                => $_SESSION['input']['price'], 
					"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
					"location"             => $_SESSION['input']['location'], 
					"bikou"                => $_SESSION['input']['bikou'], 
					"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'], 
					"haiki_date"           => $_SESSION['input']['haiki_date'], 
					"memo"                 => @$_SESSION['input']['memo'], 
					"version"              => 1 
					      );
			$code = $this->db->dbInsert("\"hardrireki\"", $fields_values);

			$fields_values = array(
					"history_pkey"         => $code,     
					"history_type"         => "d001",     
					"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
					"sinseisya"            => $_SESSION['input']['sinseisya'], 
					"sinseisyozoku"        => $this->authuser_sosiki,
					"email_ad"             => $_SESSION['input']['email_ad'],
					"shinsei_no"           => $code,     
					      );
			$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);

			$mail_tpl = new Template;
			$email = new Sendmail;
		
			$mail_tpl->assignHtml('sinseisya',$_SESSION['input']['sinseisya']);
			$mail_tpl->assignHtml('sinsei_date',$_SESSION['input']['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ハードウェア台帳");
			$mail_tpl->assignHtml('action',_ACTION_APPADD);

			$body = $mail_tpl->fetchHtml('mail/sinsei.html');
			$subject = "【情報資産管理システム】ハードウェア台帳　"._ACTION_APPADD;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$sosiki_pkey = $detail['sosiki_pkey'];
			
			$list = $this->db->dbSelect("SELECT * FROM user_detail where (auth = 'd003' or auth = 'd004') and sosiki_pkey = ".$sosiki_pkey, "list");
			for($i=0; $i<count(@$list); $i++){
				$email_ad = explode("\n",$list[$i]['email_ad']);
				for($j=0; $j<count($email_ad); $j++){
//					$email->email($email_ad[$j], _ADMIN_EMAIL, $subject, $body);
				}
			}

		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['hard_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 編集
	 * 入力
	 */
	function app_edit(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$hard_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".$hard_pkey, "detail");

			//組織認証
			$this->sosiki_auth(array($detail['sosiki_pkey']));
			
			if(count($detail) > 0){
				$item    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i:s");
//			$item['sosiki_pkey'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認app_print
	 */
	function app_edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		if(@$_SESSION['input']['haiki_date'] != ""){
			$this->tpl->assignHtml('kakunin',   true);
		}
		$detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".@$_SESSION['input']['hard_pkey'], "detail");
		if(@$_SESSION['input']['sosiki_pkey'] != @$detail['sosiki_pkey']){
			$this->tpl->assignHtml('sosiki_change',   true);
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		$this->tpl->assignHtml('action_param','app_edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function app_edit_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app_edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			if($this->authuser_authority != 'system'){
				$detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".$_SESSION['input']['hard_pkey'], "detail");
				$_SESSION['input']['memo'] = $detail['memo'];
			}
			/** 登録 */
			$fields_values = array(
					"hard_pkey"            => $_SESSION['input']['hard_pkey'],     
					"sosiki_pkey"          => $_SESSION['input']['sosiki_pkey'],     
					"hard_kanrino"         => $_SESSION['input']['hard_kanrino'],     
					"soft_installdel"      => $_SESSION['input']['soft_installdel'],
					"use_name"             => $_SESSION['input']['use_name'],
					"price"                => $_SESSION['input']['price'], 
					"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
					"location"             => $_SESSION['input']['location'], 
					"memo"                 => $_SESSION['input']['memo'], 
					"bikou"                => $_SESSION['input']['bikou'], 
					"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'], 
					"haiki_date"           => $_SESSION['input']['haiki_date'], 
					"version"              => $_SESSION['input']['version'] 
					      );
			$code = $this->db->dbInsert("\"hardrireki\"", $fields_values);

			$fields_values = array(
					"history_pkey"         => $code,     
					"history_type"         => "d001",     
					"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
					"sinseisya"            => $_SESSION['input']['sinseisya'], 
					"sinseisyozoku"        => $this->authuser_sosiki,
					"email_ad"             => $_SESSION['input']['email_ad'],
					"shinsei_no"           => $code,     
					      );
			$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);

			//ソフトウエア台帳
			if(@$_REQUEST['kakunin'] == "on"){
				$this->soft_app_edit_done();
			}
			
			//ライセンス台帳
			if(@$_REQUEST['kakunin'] == "on" or @$_REQUEST['sosiki_change'] == "on"){
				$licence_list = $this->db->dbSelect("select * from licence_detail where hard_pkey='".$_SESSION['input']['hard_pkey']."' and newkbn <> 1", "list");
				if(count($licence_list) > 0){
					for($i=0; $i<count($licence_list); $i++){
						$this->licence_app_edit_done($licence_list[$i]['licence_pkey']);
					}
				}
			}

			$mail_tpl = new Template;
			$email = new Sendmail;
		
			$mail_tpl->assignHtml('sinseisya',$_SESSION['input']['sinseisya']);
			$mail_tpl->assignHtml('sinsei_date',$_SESSION['input']['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ハードウェア台帳");
			$mail_tpl->assignHtml('action',_ACTION_APPEDIT);

			$body = $mail_tpl->fetchHtml('mail/sinsei.html');
			$subject = "【情報資産管理システム】ハードウェア台帳　"._ACTION_APPEDIT;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$sosiki_pkey = $detail['sosiki_pkey'];
			
			$list = $this->db->dbSelect("SELECT * FROM user_detail where (auth = 'd003' or auth = 'd004') and sosiki_pkey = ".$sosiki_pkey, "list");
			for($i=0; $i<count(@$list); $i++){
				$email_ad = explode("\n",$list[$i]['email_ad']);
				for($j=0; $j<count($email_ad); $j++){
//					$email->email($email_ad[$j], _ADMIN_EMAIL, $subject, $body);
				}
			}
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['hard_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_APPEDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * ソフトウェア台帳更新申請
	 */
	function soft_app_edit_done(){

		$soft_list = $this->db->dbSelect("select * from soft_detail where hard_pkey=".$_SESSION['input']['hard_pkey']." and newkbn <> 1", "list");
		$shinsei_no = "";
		if(count($soft_list) > 0){
			for($i=0; $i<count($soft_list); $i++){
				if(strtotime($soft_list[$i]['haiki_date']) > strtotime($_SESSION['input']['haiki_date']) or $soft_list[$i]['haiki_date'] == null){
					$haiki_date = $_SESSION['input']['haiki_date'];
				}else{
					$haiki_date = $soft_list[$i]['haiki_date'];
				}
				$fields_values = array(
						"soft_pkey"            => $soft_list[$i]['soft_pkey'], 
						"hard_pkey"            => $soft_list[$i]['hard_pkey'], 
						"licence_pkey"         => $soft_list[$i]['licence_pkey'],     
						"bikou"                => $soft_list[$i]['bikou'], 
						"downgrade"            => $soft_list[$i]['downgrade'], 
						"install_date"         => $soft_list[$i]['tyoutatu_date'],
						"uninstall_date"       => $haiki_date,
						"memo"                 => $soft_list[$i]['memo'],
						"version"              => $soft_list[$i]['version']
						      );

				$code = $this->db->dbInsert("\"softrireki\"", $fields_values);
				if($shinsei_no == ""){
					$shinsei_no = $code;
				}
				$fields_values = array(
						"history_pkey"         => $code,     
						"history_type"         => "d002",     
						"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
						"sinseisya"            => $_SESSION['input']['sinseisya'], 
						"sinseisyozoku"        => $this->authuser_sosiki,
						"email_ad"             => $_SESSION['input']['email_ad'],
						"shinsei_no"           => $shinsei_no
						      );
				$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);
			}
		}
	}

	/**
	 * 編集
	 * 登録
	 */
	function licence_app_edit_done($licence_pkey){
	
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey='".$licence_pkey."'", "detail");

		$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and newkbn <> 1 order by \"sosiki_sortkey\"";
		$use_sosiki = $this->db->dbSelect("select * from licence_detail".$where_list, "list");
		$shinsei_no = "";
		if(count(@$use_sosiki) > 0){
			for($i=0; $i<count($use_sosiki); $i++){
				if(@$_REQUEST['kakunin'] == "on" and (strtotime($use_sosiki[$i]['haiki_date']) > strtotime($_SESSION['input']['haiki_date']) or $use_sosiki[$i]['haiki_date'] == null)){
					$use_sosiki[$i]['haiki_date'] = $_SESSION['input']['haiki_date'];
				}
				if(@$_REQUEST['sosiki_change'] == "on"){
					$use_sosiki[$i]['kanri_sosiki_pkey']	= $_SESSION['input']['sosiki_pkey'];
					$use_sosiki[$i]['sosiki_pkey']		= $_SESSION['input']['sosiki_pkey'];
				}
				/** 登録 */
				$fields_values = array(
						"kanri_sosiki_pkey"    => $use_sosiki[$i]['kanri_sosiki_pkey'], 
						"sosiki_pkey"          => $use_sosiki[$i]['sosiki_pkey'],
						"licence_pkey"         => $use_sosiki[$i]['licence_pkey'], 
						"licencelist_pkey"     => $use_sosiki[$i]['licencelist_pkey'],
						"licence_kanrino"      => $use_sosiki[$i]['licence_kanrino'],
						"install_su"           => $use_sosiki[$i]['install_su'],
						"hard_pkey"            => $use_sosiki[$i]['hard_pkey'],
						"licence_pkey2"        => $use_sosiki[$i]['licence_pkey2'],
						"licence_no"           => $use_sosiki[$i]['licence_no'],
						"tyoutatu"             => $use_sosiki[$i]['tyoutatu'],
						"hokan_baitai"         => $use_sosiki[$i]['hokan_baitai'],
						"hokan_basyo"          => $use_sosiki[$i]['hokan_basyo'],
						"bikou"                => $use_sosiki[$i]['bikou'],
						"tyoutatu_date"        => $use_sosiki[$i]['tyoutatu_date'],
						"haiki_date"           => $use_sosiki[$i]['haiki_date'],
						"price"                => $use_sosiki[$i]['price'],
						"use_limit_date"       => $use_sosiki[$i]['use_limit_date'],
						"memo"                 => $use_sosiki[$i]['memo'],
						"version"              => $use_sosiki[$i]['version']
						      );
				$code = $this->db->dbInsert("\"licencerireki\"", $fields_values);

				if($shinsei_no == ""){
					$shinsei_no = $code;
				}
				$fields_values = array(
						"history_pkey"         => $code,     
						"history_type"         => "d003",     
						"sinsei_date"          => $_SESSION['input']['sinsei_date'], 
						"sinseisya"            => $_SESSION['input']['sinseisya'], 
						"sinseisyozoku"        => $this->authuser_sosiki, 
						"email_ad"             => $_SESSION['input']['email_ad'],
						"shinsei_no"           => $shinsei_no
						      );
				$rireki_code = $this->db->dbInsert("\"rireki\"", $fields_values);
				
				$fields_values = array(
						"licencehistory_pkey"  => $code,     
						"hold_qty"             => $use_sosiki[$i]['hold_qty']
						      );
				$this->db->dbInsert("\"hold_licence_qry_rireki\"", $fields_values);
			}
		}
	}

	/**
	 * コピー
	 * 入力
	 */
	function app_copy(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$hard_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".$hard_pkey, "detail");

			//組織認証
			$this->sosiki_auth(array($detail['sosiki_pkey']));
			
			if(count($detail) > 0){
				$item			= $detail;
				$item['hard_pkey']	= "";
				$item['version']	= "";
				$child_where = " where user_pkey = ".$this->authuser_code;
				$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
				$item['sosiki_pkey']	= $user_detail['sosiki_pkey'];
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i:s");
//			$item['sosiki_pkey'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param','app_reg');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 修正申請
	 * 入力
	 */
	function app_modify(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SHINSEI);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			if($item['hard_pkey'] != ""){
				$action_param = 'app_edit';
			}else{
				$action_param = 'app_reg';
			}
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$history_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$history_pkey, "detail");

			//組織認証
			$this->sosiki_auth(array($detail['sinseisyozoku']));
			
			if(count($detail) > 0){
				$base_detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".$detail['hard_pkey'], "detail");
				if($base_detail['newkbn'] == 0){
					$item			= $detail;
					$item['version']	= $base_detail['version'];
					$action_param = 'app_edit';
				}else{
					$item			= $detail;
					$item['hard_pkey']	= "";
					$item['version']	= "";
					$action_param = 'app_reg';
				}
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
			$item['sinseisya'] = _DEFAULT_SINSEISYA;
			$item['email_ad'] = _DEFAULT_EMAIL;
			
			$item['sinsei_date'] = date("Y/m/d H:i:s");
//			$item['sosiki_pkey'] = $user_detail['sosiki_pkey'];
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		$this->tpl->assignHtml('action_param',$action_param);
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/input_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 入力
	 */
	function edit(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}else{
			$hard_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".$hard_pkey, "detail");
			if(count($detail) > 0){
				$item    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;

			$child_where = " where user_pkey = ".$this->authuser_code;
			$user_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認
	 */
	function edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 申請時デフォルト値書換 */
		change_default_shinsei(@$_SESSION['input']['sinseisya'],@$_SESSION['input']['email_ad']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 */
	function edit_done(){
		$page_name = "system";
		$this->login($page_name);

		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */
		$hard_pkey = addslashes($_SESSION['input']['hard_pkey']);
		$where = "hard_pkey = ".$hard_pkey;

		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			$error = $_SESSION['input']['error_msg'];
		}else{
			if($this->authuser_authority != 'system'){
				$detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".$_SESSION['input']['hard_pkey'], "detail");
				$_SESSION['input']['memo'] = $detail['memo'];
			}
			/** 登録 */
			$fields_values = array(
					"sosiki_pkey"          => $_SESSION['input']['sosiki_pkey'],     
					"hard_kanrino"         => $_SESSION['input']['hard_kanrino'],     
					"soft_installdel"      => $_SESSION['input']['soft_installdel'],
					"use_name"             => $_SESSION['input']['use_name'],
					"price"                => $_SESSION['input']['price'], 
					"tyoutatu"             => $_SESSION['input']['tyoutatu'], 
					"location"             => $_SESSION['input']['location'], 
					"memo"                 => $_SESSION['input']['memo'], 
					"bikou"                => $_SESSION['input']['bikou'], 
					"tyoutatu_date"        => $_SESSION['input']['tyoutatu_date'], 
					"haiki_date"           => $_SESSION['input']['haiki_date'], 
					"version"              => $_SESSION['input']['version'] + 1 
					      );
			$this->db->dbUpdate("\"hard\"", $fields_values, $where);
		}
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('name',$_SESSION['input']['hard_kanrino']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_EDIT);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 申請
	 * 取下
	 */
	function app_del(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SAGE);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$hardhistory_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['hardhistory_pkey']    = $hardhistory_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$hardhistory_pkey, "detail");
		
		//組織認証
		$this->sosiki_auth(array($detail['sinseisyozoku']));
		
		if(count($detail) > 0){
			$item    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;

		/** 出力 */
		$this->tpl->assignHtml('item',   $item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPDEL);
		$this->tpl->assignHtml('action_param','app_del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/confirm_sinsei.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function app_del_done(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$hardhistory_pkey = addslashes(@$_SESSION['input']['hardhistory_pkey']);
		$where = "hardhistory_pkey = ".$hardhistory_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['hard_kanrino']);
			$where = "history_pkey = ".$hardhistory_pkey." and history_type = 'd001'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => 'd003'
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

			$where_list = "hard_pkey = ".$detail['hard_pkey']." and newkbn = 1";
			$this->db->dbDelete("\"hard\"", $where_list);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_APPDEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認
	 * 
	 */
	function app(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SHOUNIN);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$hardhistory_pkey = addslashes(@$_SESSION['input']['hardhistory_pkey']);
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";

			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$hardhistory_pkey, "detail");
			if(count($detail) > 0){
				$history    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
		}else{
			$hardhistory_pkey = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$hardhistory_pkey, "detail");
			
			//組織認証
			$this->sosiki_auth(array($detail['sinseisyozoku']));
			
			if(count($detail) > 0){
				$history    = $detail;
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$item['syoninsya'] = _DEFAULT_SYONINSYA;
			
			$item['syonin_date'] = date("Y/m/d H:i:s");
			$item['sinsei_date'] = $detail['sinsei_date'];
			$item['sinseisya'] = $detail['sinseisya'];
			$item['email_ad'] = $detail['email_ad'];
			$item['hardhistory_pkey'] = $detail['hardhistory_pkey'];
			$item['hard_pkey'] = $detail['hard_pkey'];
			$item['hard_kanrino'] = $detail['hard_kanrino'];
			$item['version'] = $detail['version'];
			$user_referer = _USER_REFERER;
		}


		if($history['hard_pkey'] != ""){
			$version = $history['version']-1;
			$detail = $this->db->dbSelect("SELECT * FROM hard_rireki_detail where hard_pkey = ".$history['hard_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			/** 比較 */
			$check_array = 	array(
						"sosiki_pkey",
						"hard_kanrino",
						"soft_installdel",
						"use_name",
						"price",
						"tyoutatu",
						"location",
						"memo",
						"bikou",
						"tyoutatu_date",
						"haiki_date"
					);

			foreach($check_array as $val){
				if($detail[$val] != $history[$val]){
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}
				if(!isset($detail)){
					$old[$val] = "";
				}elseif($detail[$val] == ""){
					$old[$val] = " ";
				}else{
					$old[$val] = $detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APP);
		$this->tpl->assignHtml('action_param','app');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/input_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}
	
	/**
	 * 内容確認
	 * 
	 */
	function app_conf(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_SHOUNIN);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 承認時デフォルト値書換 */
		change_default_syonin(@$_SESSION['input']['syoninsya']);
		$item = $_SESSION['input'];
		$hardhistory_pkey = addslashes(@$_SESSION['input']['hardhistory_pkey']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "app";
		$this->check_app();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}

		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$hardhistory_pkey, "detail");
		if(count($detail) > 0){
			$history    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$user_referer = _USER_REFERER;


		if($history['hard_pkey'] != ""){
			$version = $history['version']-1;
			$detail = $this->db->dbSelect("SELECT * FROM hard_rireki_detail where hard_pkey = ".$history['hard_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
		
			/** 比較 */
			$check_array = 	array(
						"sosiki_pkey",
						"hard_kanrino",
						"soft_installdel",
						"use_name",
						"price",
						"tyoutatu",
						"location",
						"memo",
						"bikou",
						"tyoutatu_date",
						"haiki_date"
					);
			foreach($check_array as $val){
				if($detail[$val] != $history[$val]){
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}
				if(!isset($detail)){
					$old[$val] = "";
				}elseif($detail[$val] == ""){
					$old[$val] = " ";
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $history;
		}
		$app_col = select_code("00008");
		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$_SESSION['input']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',$app_col[@$_SESSION['input']['syonin_kbn']]);
		$this->tpl->assignHtml('action_param','app');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 内容確認
	 * 承認・却下
	 */
	function app_done(){
		$page_name = "system,syonin";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$hardhistory_pkey = addslashes(@$_SESSION['input']['hardhistory_pkey']);
		$syonin_kbn       = addslashes(@$_SESSION['input']['syonin_kbn']);
		$syoninsya        = addslashes(@$_SESSION['input']['syoninsya']);
		$syonin_date      = addslashes(@$_SESSION['input']['syonin_date']);

		$where = "hardhistory_pkey = ".$hardhistory_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['hard_kanrino']);
			$where = "history_pkey = ".$hardhistory_pkey." and history_type = 'd001'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => $syonin_kbn,
					"syoninsya"           => $syoninsya,
					"syonin_date"         => $syonin_date
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);
			
			if($syonin_kbn == "d001"){
				$where = "hard_pkey = ".$detail['hard_pkey'];
				$fields_values = array(
						"sosiki_pkey"       => $detail['sosiki_pkey'],
						"hard_kanrino"      => $detail['hard_kanrino'],
						"soft_installdel"   => $detail['soft_installdel'],
						"use_name"          => $detail['use_name'],
						"price"             => $detail['price'],
						"tyoutatu"          => $detail['tyoutatu'],
						"location"          => $detail['location'],
						"memo"              => $detail['memo'],
						"bikou"             => $detail['bikou'],
						"tyoutatu_date"     => $detail['tyoutatu_date'],
						"haiki_date"        => $detail['haiki_date'],
						"version"           => $detail['version'] + 1, 
						"newkbn"            => 0
						      );
				$this->db->dbUpdate("\"hard\"", $fields_values, $where);
				
			}else{
				$where_list = "hard_pkey = ".$detail['hard_pkey']." and newkbn = 1";
				$this->db->dbDelete("\"hard\"", $where_list);
			}

			if($syonin_kbn == "d001"){
				$action = "承認";
			}else{
				$action = "却下";
			}
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$syoninsya);
			$mail_tpl->assignHtml('syonin_date',$syonin_date);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ハードウェア台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ハードウェア台帳　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		$app_col = select_code("00008");
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', $app_col[@$_SESSION['input']['syonin_kbn']]);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	/**
	 * 内容確認
	 * 表示
	 */
	function app_view(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$hardhistory_pkey = addslashes(@$_REQUEST['code']);
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$hardhistory_pkey, "detail");
		
		//組織認証
		$this->sosiki_auth(array($detail['sinseisyozoku']));
		
		if(count($detail) > 0){
			$history    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date'] = $detail['sinsei_date'];
		$item['sinseisya'] = $detail['sinseisya'];
		$item['email_ad'] = $detail['email_ad'];
		$item['hardhistory_pkey'] = $detail['hardhistory_pkey'];
		$item['hard_pkey'] = $detail['hard_pkey'];
		$item['hard_kanrino'] = $detail['hard_kanrino'];
		$item['version'] = $detail['version'];
		$user_referer = _USER_REFERER;

		if($history['hard_pkey'] != ""){
			$version = $history['version']-1;
			$detail = $this->db->dbSelect("SELECT * FROM hard_rireki_detail where hard_pkey = ".$history['hard_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			/** 比較 */
			$check_array = 	array(
						"sosiki_pkey",
						"hard_kanrino",
						"soft_installdel",
						"use_name",
						"price",
						"tyoutatu",
						"location",
						"memo",
						"bikou",
						"tyoutatu_date",
						"haiki_date"
					);
			foreach($check_array as $val){
				if($detail[$val] != $history[$val]){
					if($history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}
				if(!isset($detail)){
					$old[$val] = "";
				}elseif($detail[$val] == ""){
					$old[$val] = " ";
				}else{
					$old[$val] = $detail[$val];
				}
			}
		
		}else{
			$new = $history;
		}
		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_APPVIEW);
		$this->tpl->assignHtml('action_param','app_view');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 内容確認
	 * 表示
	 */
	function rireki_del(){
		$this->tpl->assignHtml('title', _TITLE_APP_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$hardhistory_pkey = addslashes(@$_REQUEST['code']);
		$_SESSION['input']['hardhistory_pkey']    = $hardhistory_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$hardhistory_pkey, "detail");
		if(count($detail) > 0){
			$old    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date']       = $detail['sinsei_date'];
		$item['sinseisya']         = $detail['sinseisya'];
		$item['email_ad']          = $detail['email_ad'];
		$item['hardhistory_pkey']  = $detail['hardhistory_pkey'];
		$item['version']           = $detail['version'];
		$user_referer              = _USER_REFERER;

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('app_col', select_code("00008"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','rireki_del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/confirm_syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function rireki_del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$hardhistory_pkey = addslashes(@$_SESSION['input']['hardhistory_pkey']);
		$where = "hardhistory_pkey = ".$hardhistory_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select hard_kanrino from \"hard_rireki_detail\" where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['hard_kanrino']);
			/** 削除 */
			$this->db->dbDelete("\"hardrireki\"", $where);
			$where_rireki = "history_pkey = ".$hardhistory_pkey." and history_type = 'd001'";
			$this->db->dbDelete("\"rireki\"", $where_rireki);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}


	/**
	 * 削除
	 * 確認
	 */
	function del(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_INPUT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		$hard_pkey = addslashes(@$_REQUEST['code']);
		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['hard_pkey']    = $hard_pkey;
		$_SESSION['input']['user_referer'] = _USER_REFERER;

		/** エラーﾁｪｯｸ */
		$_SESSION['input']['method'] = "del";
		$this->check_del();
		if(@$_SESSION['input']['error_flag'] == true || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
		}

		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_detail where hard_pkey=".$hard_pkey, "detail");
		if(count($detail) > 0){
			$item    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name',_ACTION_DEL);
		$this->tpl->assignHtml('action_param','del');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('hardware/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 削除
	 * 登録
	 */
	function del_done(){
		$page_name = "system";
		$this->login($page_name);

		/** CODE ｴｽｹｰﾌﾟ */
		$hard_pkey = addslashes(@$_SESSION['input']['hard_pkey']);
		$where = "hard_pkey = ".$hard_pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select hard_kanrino from \"hard\" where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['hard_kanrino']);
			/** 削除 */
			$this->db->dbDelete("\"hard\"", $where);
			/** ソフトウェア台帳削除 */
			$this->db->dbDelete("\"soft\"", $where);
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_name', _ACTION_DEL);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}

	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check(){
		#入力チェック(警告)
		$cci_att = new CheckItem;
		$child_where = " where user_pkey = ".$this->authuser_code;
		$sosiki_detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
		$child_array = child_sosiki_key($sosiki_detail['sosiki_pkey']);
		array_push($child_array,$sosiki_detail['sosiki_pkey']);
		if(!in_array(@$_SESSION['input']['sosiki_pkey'],$child_array) and @$_SESSION['input']['sosiki_pkey'] != "0" and _ERROR_0204){
			$cci_att->checkErrorCode("0204");
		}
		$sosikiname = implode("/",full_sosiki_name(@$_SESSION['input']['sosiki_pkey']));
		$where = " where hardwareno = '".addslashes(@$_SESSION['input']['hard_kanrino'])."'";
		$inv_detail = $this->db->dbSelect("select * from inventory".$where, "detail");
		if(@$inv_detail['hardwareno'] == '' and _ERROR_0277){
			$cci_att->checkErrorCode("0277");
		}
		if(@$_SESSION['input']['tyoutatu_date'] == "" or @$_SESSION['input']['tyoutatu'] == "" and _ERROR_0209){
			$cci_att->checkErrorCode("0209");
		}

		$where = " where sosiki_pkey in (".implode(",",$child_array).")";
		$list = $this->db->dbSelect("select DISTINCT ON (location) location from hard_detail".$where." order by location", "list");
		$items = array();
		if(count($list) > 0){
			for($i=0; $i<count($list); $i++){
				$items[] = $list[$i]['location'];
			}
		}
		if(@$_SESSION['input']['location'] != "" and !in_array(@$_SESSION['input']['location'],$items) and _ERROR_0278){
			$cci_att->checkErrorCode("0278");
		}
		
		if(@$_SESSION['input']['haiki_date'] != ""){
			$where = " where hard_kanrino = '".addslashes($_SESSION['input']['hard_kanrino'])."' and haiki_date is null and newkbn <> 1";
			$licence_list = $this->db->dbSelect("select * from licence_detail".$where, "list");
			if(count($licence_list) > 0 and _ERROR_0256){
				$cci_att->checkErrorCode("0256");
			}
			$soft_list = $this->db->dbSelect("select * from soft_detail".$where, "list");
			if(count($soft_list) > 0 and _ERROR_0257){
				$cci_att->checkErrorCode("0257");
			}
		}

		if($cci_att->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['att_flag']  = true;
			$_SESSION['input']['att_msg']   = $cci_att->error_msg;
		}
		
		
		#入力チェック
		$cci = new CheckItem;

		#バージョンチェック
		if($_SESSION['input']['method'] != "app_reg"){
			$where = " where hard_pkey = ".$_SESSION['input']['hard_pkey'];
			$detail = $this->db->dbSelect("select * from hard_detail".$where, "detail");
			if(@$_SESSION['input']['version'] != $detail['version'] and _ERROR_0051){
				$cci->checkErrorCode("0051");
			}
		}

		if($_SESSION['input']['method'] != "edit"){
			$cci->checkItemNon(array("email_ad"=>"申請者メールアドレス"));
			$cci->checkItemEmailArray(array("email_ad"=>"申請者メールアドレス"));
		
			$email_ad = explode("@",@$_SESSION['input']['email_ad']);
			if(count($email_ad)>=2){
				if(!in_array($email_ad[1],select_code("00027")) and _ERROR_0254){
					$cci->checkErrorCode("0254");
				}
			}
		}

		$error_name_array = select_code("00010");

		if(@$_SESSION['input']['sosiki_pkey'] == "0" and _ERROR_0203){
			$cci->checkErrorCode("0203");
		}
		if(@$_SESSION['input']['hard_kanrino'] == "" and _ERROR_0206){
			$cci->checkErrorCode("0206");
		}
		if(@$_SESSION['input']['use_name'] == "" and _ERROR_0207){
			$cci->checkErrorCode("0207");
		}
		if(@$_SESSION['input']['soft_installdel'] == "" and _ERROR_0208){
			$cci->checkErrorCode("0208");
		}
		if(@$_SESSION['input']['price'] != ""){
			$cci->checkNumeric(array("price"=>$error_name_array['014']));
		}
		if($_SESSION['input']['method'] == "app_reg"){
			$where = " where newkbn <> 1 and hard_kanrino = '".addslashes($_SESSION['input']['hard_kanrino'])."' and (haiki_date > current_date or haiki_date is null)";
		}else{
			$where = " where newkbn <> 1 and hard_pkey != ".$_SESSION['input']['hard_pkey']." and hard_kanrino = '".addslashes($_SESSION['input']['hard_kanrino'])."' and (haiki_date > current_date or haiki_date is null)";
		}
		$list = $this->db->dbSelect("select * from hard_detail".$where, "list");
		if(count($list) > 0 and _ERROR_0210){
			$cci->checkErrorCode("0210");
		}
		if($_SESSION['input']['method'] != "del" and $_SESSION['input']['method'] != "edit"){
			if(@$_SESSION['input']['sinseisya'] == "" and _ERROR_0201){
				$cci->checkErrorCode("0201");
			}
			if(@$_SESSION['input']['sinsei_date'] == "" and _ERROR_0202){
				$cci->checkErrorCode("0202");
			}
		}
		if(@$_SESSION['input']['haiki_date'] != ""){
			$where = " where hard_pkey = ".$_SESSION['input']['hard_pkey']." and haiki_date > '".$_SESSION['input']['haiki_date']."' and newkbn <> 1";
			$soft_list = $this->db->dbSelect("select * from soft_detail".$where, "list");
			if(count($soft_list) > 0 and _ERROR_0282){
				$cci->checkErrorCode("0282");
			}
		}
		$cci->checkItemDate01(array("tyoutatu_date"=>$error_name_array['012'],"haiki_date"=>$error_name_array['013']));
		$cci->checkItemDateTime(array("sinsei_date"=>"申請日"));
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check_app(){
		#入力チェック
		$cci = new CheckItem;

		$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$_SESSION['input']['hardhistory_pkey'], "detail");
		if($_SESSION['input']['syonin_kbn'] == 'd001'){
			#バージョンチェック
			$detail_old = $this->db->dbSelect("SELECT * FROM hard_detail where hard_pkey = ".$detail['hard_pkey'], "detail");
			if($detail['version'] != $detail_old['version'] and _ERROR_0103){
				$cci->checkErrorCode("0103");
			}
			$where = " where newkbn <> 1 and hard_pkey != ".$detail['hard_pkey']." and hard_kanrino = '".addslashes($detail['hard_kanrino'])."' and (haiki_date > current_date or haiki_date is null)";
			/** 詳細ﾃﾞｰﾀ */
			$list = $this->db->dbSelect("select * from hard_detail".$where, "list");
			if(count($list) > 0 and _ERROR_0210){
				$cci->checkErrorCode("0210");
			}
		}

		if (strtotime(@$_SESSION['input']['syonin_date']) < strtotime($detail['sinsei_date']) and _ERROR_0104) {
			$cci->checkErrorCode("0104");
		}
		if(@$_SESSION['input']['syoninsya'] == "" and _ERROR_0101){
			$cci->checkErrorCode("0101");
		}
		if(@$_SESSION['input']['syonin_date'] == "" and _ERROR_0102){
			$cci->checkErrorCode("0102");
		}

		$error_name_array = select_code("00015");
		$cci->checkItemDateTime(array("syonin_date"=>$error_name_array['007']));
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check_del(){
		#入力チェック(警告)
		$cci_att = new CheckItem;

		$where = " where hard_pkey = '".addslashes($_SESSION['input']['hard_pkey'])."'";
		$list = $this->db->dbSelect("select * from soft".$where, "list");
		if(count($list) > 0 and _ERROR_0024){
			$cci_att->checkErrorCode("0024",array("ソフトウェア台帳"));
		}
		
		if($cci_att->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['att_flag']  = true;
			$_SESSION['input']['att_msg']   = $cci_att->error_msg;
		}

		#入力チェック
		$cci = new CheckItem;

		#バージョンチェック
		$where = " where hard_pkey = '".addslashes($_SESSION['input']['hard_pkey'])."'";
		$list = $this->db->dbSelect("select * from licence".$where, "list");
		if(count($list) > 0 and _ERROR_0203){
			$cci->checkErrorCode("0023",array("固定先ハードウェア","ライセンス"));
		}
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "";
		$this->login($page_name);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sosiki_pkey in (".implode(",",$sosiki_array).") and newkbn <> 1 and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";
		}
		
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=hardware.csv");

		$list = $this->db->dbSelect("SELECT * FROM hard_detail".$_SESSION['csv'], "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		print mb_convert_encoding($this->tpl->fetchHtml('hardware/csv.html'),"SJIS-win","UTF-8");
	}
	
	/**
	 * プリント出力
	 */
	function prt(){
		$page_name = "";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sosiki_pkey in (".implode(",",$sosiki_array).") and newkbn <> 1 and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";
		}

		$list = $this->db->dbSelect("SELECT * FROM hard_detail".$_SESSION['csv'], "list");

		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('list_view',$list);
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('hardware/print.html'));
		$this->tpl->outputHtml('print_list.html');
	}
	
	/**
	 * 申請書印刷
	 */
	function app_print(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_APP);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		if(@$_SESSION['input']['hard_pkey'] != ""){
			$detail = $this->db->dbSelect("SELECT * FROM hard_detail where hard_pkey = ".$_SESSION['input']['hard_pkey'], "detail");
			if($detail['tyoutatu_date'] != ""){
				$tyoutatu_date = explode("-",$detail['tyoutatu_date']);
				$detail['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
			}
			if($detail['haiki_date'] != ""){
				$haiki_date = explode("-",$detail['haiki_date']);
				$detail['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
			}
			/** 比較 */
			
			$check_array = 	array(
						"sosiki_pkey",
						"hard_kanrino",
						"soft_installdel",
						"use_name",
						"price",
						"tyoutatu",
						"location",
						"bikou",
						"memo",
						"tyoutatu_date",
						"haiki_date"
					);

			foreach($check_array as $val){
				if(@$detail[$val] != @$_SESSION['input'][$val]){
					$old[$val] = @$detail[$val];
					if(@$_SESSION['input'][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $_SESSION['input'][$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
			
		}else{
			$new = $_SESSION['input'];
		}
		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");


		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',$_SESSION['input']);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		/** set template */
		$print_base = $this->tpl->fetchHtml('hardware/print_sinsei.html');
		//ソフトウェア台帳申請
		if(@$_REQUEST['kakunin'] == "on"){
			$print_base .= $this->soft_app_print();
		}
			
		//ライセンス台帳申請
		if(@$_REQUEST['kakunin'] == "on" or @$_REQUEST['sosiki_change'] == "on"){
			$licence_list = $this->db->dbSelect("select * from licence_detail where hard_pkey='".$_SESSION['input']['hard_pkey']."' and newkbn <> 1", "list");
			if(count($licence_list) > 0){
				for($i=0; $i<count($licence_list); $i++){
					$print_base .= $this->licence_app_print($licence_list[$i]['licence_pkey']);
				}
			}
		}
		
		$this->tpl->assignHtml('print_table', $print_base);
		$this->tpl->outputHtml('print_sinsei.html');
	}
	
	/**
	 * ソフトウェア申請
	 */
	function soft_app_print(){
		$this->tpl->assignHtml('title', _TITLE_SOFTWARE_APP);
		#ダウングレード名取得
		$downgrade_array = select_code("00004");
		
		//ライセンス情報
		$soft_list = $this->db->dbSelect("select * from soft_detail where hard_pkey=".$_SESSION['input']['hard_pkey']." and newkbn <> 1", "list");
		if(count($soft_list) > 0){
			for($i=0; $i<count($soft_list); $i++){
				if($soft_list[$i]['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft_list[$i]['tyoutatu_date']);
					$soft_list[$i]['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft_list[$i]['haiki_date'] != ""){
					$haiki_date = explode("-",$soft_list[$i]['haiki_date']);
					$soft_list[$i]['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				if(strtotime(@$soft_list[$i]['haiki_date']) > strtotime($_SESSION['input']['haiki_date']) or @$soft_list[$i]['haiki_date'] == null){
					$haiki_date = $_SESSION['input']['haiki_date'];
				}else{
					$haiki_date = $soft_list[$i]['haiki_date'];
				}
				if(strtotime(@$soft_list[$i]['haiki_date']) > strtotime(date('Y/m/d')) or @$soft_list[$i]['haiki_date'] == null){
					$soft_list[$i]['haiki_date'] = $haiki_date;
					$list[] = $soft_list[$i];
				}else{
					$soft_list[$i]['haiki_date'] = $haiki_date;
					$del_list[] = $soft_list[$i];
				}
			}
		}
		#ハードウェア管理番号取得
		$hard_detail = $this->db->dbSelect("select * from hard_detail where hard_pkey='".$_SESSION['input']['hard_pkey']."'", "detail");

		$hard_detail['hard_kanrino'] = $_SESSION['input']['hard_kanrino'];
		$hard_detail['use_name'] = $_SESSION['input']['use_name'];
		
		$history = $hard_detail;
		#導入ライセンス比較
		for($i=0; $i<count(@$list); $i++){
			$soft = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".@$list[$i]['soft_pkey']." and newkbn <> 1", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $list[$i][$val];
					}
				}
				$old = array();
			}
			$licence_cmp[$i]['new'] = @$new;
			$licence_cmp[$i]['old'] = @$old;
		}
		#削除済みライセンス比較
		for($i=0; $i<count(@$del_list); $i++){
			$soft = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".@$del_list[$i]['soft_pkey']." and newkbn <> 1", "detail");
			if(is_array($soft)){
				if($soft['tyoutatu_date'] != ""){
					$tyoutatu_date = explode("-",$soft['tyoutatu_date']);
					$soft['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
				}
				if($soft['haiki_date'] != ""){
					$haiki_date = explode("-",$soft['haiki_date']);
					$soft['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
				}
				/** 比較 */
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				$new = array();
				$old = array();
				foreach($check_array as $val){
					if(@$soft[$val] != $del_list[$i][$val]){
						$old[$val] = @$soft[$val];
						if(@$del_list[$i][$val] == ""){
							$new[$val] = " ";
						}else{
							$new[$val] = $del_list[$i][$val];
						}
					}else{
						$old[$val] = $soft[$val];
					}
				}
			}else{
				$check_array = 	array(
							"licence_kanrino",
							"licencelist_pkey",
							"soft_name",
							"edition",
							"licence_keitai_name",
							"downgrade_name",
							"bikou",
							"tyoutatu_date",
							"haiki_date",
							"memo"
						);
				foreach($check_array as $val){
					if($del_list[$i][$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $del_list[$i][$val];
					}
				}
				$old = array();
			}
			$d_licence_cmp[$i]['new'] = @$new;
			$d_licence_cmp[$i]['old'] = @$old;
		}
		$detail = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$history['hard_pkey']."' and newkbn <> 1", "detail");
		if($detail['hard_pkey'] != ""){
			#ハードウェア比較
			$check_array = 	array(
						"hard_kanrino",
						"use_name"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != $_SESSION['input'][$val]){
					$old[$val] = @$detail[$val];
					if(@$_SESSION['input'][$val] == ""){
						$new[$val] = "　";
					}else{
						$new[$val] = $_SESSION['input'][$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $_SESSION['input'];
		}
		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',$_SESSION['input']);
		$this->tpl->assignHtml('licence_cmp',@$licence_cmp);
		$this->tpl->assignHtml('d_licence_cmp',@$d_licence_cmp);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		/** set template */
		return "<div class=\"page\">".$this->tpl->fetchHtml('software/print_sinsei.html')."</div>";
	}

	/**
	 * ライセンス申請
	 */
	function licence_app_print($licence_pkey){
		$this->tpl->assignHtml('title', _TITLE_LICENSE_APP);

		$sosiki_array = select_sosiki();
		
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licence_detail where licence_pkey='".$licence_pkey."'", "detail");
		if($detail['hold_qty'] == 99999999){
			$detail['install_su_name'] = "無制限";
		}else{
			$detail['install_su_name'] = $detail['hold_qty'];
		}
		$item			= $detail;
		if(@$_REQUEST['kakunin'] == "on" and (strtotime($detail['haiki_date']) > strtotime($_SESSION['input']['haiki_date']) or $detail['haiki_date'] == null)){
			$item['haiki_date']	= $_SESSION['input']['haiki_date'];
		}
		$item['tyoutatu_date'] = ereg_replace("-","/",$item['tyoutatu_date']);
		/** プログラムの追加と削除での比較用データ */
		if($item['program_add_del']){
			$item['program_add_del'] = ereg_replace("\r","",$item['program_add_del']);
			$item['program_add_del'] = explode("\n",$item['program_add_del']);
		}else{
			$item['program_add_del'] = array();
		}
		/** ダウングレード使用時のプログラムの追加と削除での比較用データ */
		if($item['program_add_del_down']){
			$item['program_add_del_down'] = ereg_replace("\r","",$item['program_add_del_down']);
			$item['program_add_del_down'] = explode("\n",$item['program_add_del_down']);
		}else{
			$item['program_add_del_down'] = array();
		}
		#アップグレード元ライセンス管理番号
		if(@$item['up_licence_kanrino']){
			$item['up_licence_kanrino'] = explode(",",$item['up_licence_kanrino']);
		}else{
			$item['up_licence_kanrino'] = array();
		}		
		if(@$_REQUEST['sosiki_change'] == "on"){
			$item['kanri_sosiki_pkey'] = $_SESSION['input']['sosiki_pkey'];
		}
	
		#使用所属
		$where_list =" where licence_kanrino='".$detail['licence_kanrino']."' and newkbn <> 1 order by \"sosiki_sortkey\"";
		$item['use_sosiki'] = $this->db->dbSelect("select licence_pkey, sosiki_pkey, install_su from licence_detail".$where_list, "list");
		if(count($item['use_sosiki']) > 0){
			$item['use_sosiki_cmp'] = array();
			for($i=0; $i<count($item['use_sosiki']); $i++){
				if((@$item['use_sosiki'][$i]['install_su'] != "" and @$item['use_sosiki'][$i]['sosiki_pkey'] != "" and @$item['use_sosiki'][$i]['sosiki_pkey'] != 0) or @$item['use_sosiki'][$i]['licence_pkey'] != ""){
					if($item['use_sosiki'][$i]['install_su'] == ""){
						$item['use_sosiki'][$i]['install_su'] = 0;
					}elseif($item['use_sosiki'][$i]['install_su'] == 99999999){
						$item['use_sosiki'][$i]['install_su'] = "無制限";
					}
					if(@$_REQUEST['sosiki_change'] == "on"){
						$item['use_sosiki_cmp'][$i] = array(
										"sosiki_pkey"		=> $_SESSION['input']['sosiki_pkey'],
										"install_su"		=> $item['use_sosiki'][$i]['install_su'],
										"hold_qty"		=> $item['install_su_name']
										);
					}else{
						$item['use_sosiki_cmp'][$i] = array(
										"sosiki_pkey"		=> $item['use_sosiki'][$i]['sosiki_pkey'],
										"install_su"		=> $item['use_sosiki'][$i]['install_su'],
										"hold_qty"		=> $item['install_su_name']
										);
					}
				}
			}
			$item['use_sosiki_cmp'] = $this->kanri_check($item['kanri_sosiki_pkey'],$item['use_sosiki_cmp']);
		}

		$detail_licenselist = $this->db->dbSelect("select * from licencelist_detail where licencelist_pkey='".@$item['licencelist_pkey']."'", "detail");
		$day = explode("-",$detail_licenselist['upd_date']);
		$check_date = date("Ymd",mktime(0,0,0,$day[1],$day[2] + _USE_COND_CHECK_DAY,$day[0]));

		$sinseidatetime = explode(" ",$_SESSION['input']['sinsei_date']);
		$sinsei = explode("/",$sinseidatetime[0]);
		$sinsei_date = date("Ymd",mktime(0,0,0,$sinsei[1],$sinsei[2],$sinsei[0]));

		if($detail_licenselist['useproposal_kakunin'] == "d001" and $check_date <= $sinsei_date){
			$this->tpl->assignHtml('kakunin',true);
		}


		if(@$item['licence_pkey'] != ""){
			$detail = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey = ".$item['licence_pkey'], "detail");
			$detail['tyoutatu_date'] = ereg_replace("-","/",$detail['tyoutatu_date']);
	
			/** プログラムの追加と削除での比較用データ */
			if($detail['program_add_del']){
				$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
				$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
			}else{
				$detail['program_add_del'] = array();
			}
			/** ダウングレード使用時のプログラムの追加と削除での比較用データ */
			if($detail['program_add_del_down']){
				$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
				$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
			}else{
				$detail['program_add_del_down'] = array();
			}
			#アップグレード元ライセンス管理番号
			if(@$detail['up_licence_kanrino']){
				$detail['up_licence_kanrino'] = explode(",",$detail['up_licence_kanrino']);
			}else{
				$detail['up_licence_kanrino'] = array();
			}		
	
			#使用所属
			$list_use = $this->db->dbSelect("SELECT * FROM licence_detail where licence_kanrino = '".$detail['licence_kanrino']."' and newkbn <> 1 order by \"sosiki_sortkey\"", "list");
			if(@$detail['hold_qty'] == 99999999){
				$detail['install_su_name'] = "無制限";
			}else{
				$detail['install_su_name'] = $detail['hold_qty'];
			}

			if(count($list_use) > 0 ){
				foreach($list_use as $val){
					if(@$val['install_su'] == ""){
						$val['install_su'] = 0;
					}elseif(@$val['install_su'] == 99999999){
						$val['install_su'] = "無制限";
					}
					if(@$val['sosiki_pkey'] == ""){
						$val['sosiki_pkey'] = "0";
					}
					$detail['use_sosiki_cmp'][] = array("sosiki_pkey"=>$val['sosiki_pkey'],"install_su"=>$val['install_su'],"hold_qty"=>$detail['install_su_name']);
				}
				$detail['use_sosiki_cmp'] = $this->kanri_check($detail['kanri_sosiki_pkey'],$detail['use_sosiki_cmp']);
			}
			/** 比較 */
			$program_add_del_check = "";
			if(count(@$detail['program_add_del']) == count(@$item['program_add_del'])){
				for($i=0; $i<count($detail['program_add_del']); $i++){
					if($detail['program_add_del'][$i] != $item['program_add_del'][$i]){
						$program_add_del_check = "error";
					}
				}
			}else{
				$program_add_del_check = "error";
			}
			if($program_add_del_check == "error"){
				$old['program_add_del'] = $detail['program_add_del'];
				$new['program_add_del'] = @$item['program_add_del'];
				if(count(@$item['program_add_del']) <= 0){
					$new['program_add_del'] = array(" ");
				}else{
					$new['program_add_del'] = $item['program_add_del'];
				}
			}else{
				$old['program_add_del'] = $detail['program_add_del'];
			}
			/** ダウングレード使用時のプログラムの追加と削除での比較 */
			$program_add_del_down_check = "";
			if(count(@$detail['program_add_del_down']) == count(@$item['program_add_del_down'])){
				for($i=0; $i<count($detail['program_add_del_down']); $i++){
					if($detail['program_add_del_down'][$i] != $item['program_add_del_down'][$i]){
						$program_add_del_down_check = "error";
					}
				}
			}else{
				$program_add_del_down_check = "error";
			}
			if($program_add_del_down_check == "error"){
				$old['program_add_del_down'] = $detail['program_add_del_down'];
				$new['program_add_del_down'] = @$item['program_add_del_down'];
				if(count(@$_SESSION['input']['program_add_del_down']) <= 0){
					$new['program_add_del_down'] = array(" ");
				}else{
					$new['program_add_del_down'] = $item['program_add_del_down'];
				}
			}else{
				$old['program_add_del_down'] = $detail['program_add_del_down'];
			}

			$check_array = 	array(
						"kanri_sosiki_pkey",
						"licence_kanrino",
						"soft_name",
						"licence_keitai",
						"brand",
						"use_sosiki_cmp",
						"hard_kotei",
						"hard_kanrino",
						"upgrade",
						"up_licence_kanrino",
						"licence_no",
						"tyoutatu",
						"tokusitu_useproposal",
						"useproposal_youken",
						"hokan_baitai",
						"hokan_basyo",
						"program_add_del",
						"program_add_del_down",
						"bikou",
						"tyoutatu_date",
						"haiki_date",
						"edition",
						"price",
						"use_limit_date",
						"memo"
					);
			foreach($check_array as $val){
				@$_SESSION['input']['$val'] = ereg_replace("\r","",@$item['$val']);
				if(@$detail[$val] != @$item[$val]){
					$old[$val] = @$detail[$val];
					if(@$item[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $item[$val];
					}
				}else{
					$old[$val] = @$detail[$val];
				}
			}
		
		}else{
			$new = $item;
		}
		
		#install_su_name
		$new['install_su_name'] = "";
		if(@$detail['install_su_name'] != @$item['install_su_name'] and !is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = $item['install_su_name'];
		}elseif(@$detail['install_su_name'] != @$item['install_su_name'] and is_array(@$new['use_sosiki_cmp']) and !is_array(@$old['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$item['install_su_name'] and is_array(@$new['use_sosiki_cmp'])){
			$new['install_su_name'] = " ";
		}elseif(@$detail['install_su_name'] == @$item['install_su_name'] and @$new['use_sosiki_cmp'] == " "){
			$new['install_su_name'] = $item['install_su_name'];
		}
		if(@$old['use_sosiki_cmp'] == ""){
			$old['install_su_name'] = @$detail['install_su_name'];
		}

		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item',$_SESSION['input']);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		/** set template */
		return "<div class=\"page\">".$this->tpl->fetchHtml('license/print_sinsei.html')."</div>";
	}
	
	/**
	 * 管理権限チェック
	 */
	function kanri_check($kanri_sosiki_pkey,$use_sosiki=array()){
		#自所属＋配下所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		
		if(!in_array($kanri_sosiki_pkey,$child_array)){
			$this->use_only = true;
			$view_use_sosiki = array();
			for($i=0; $i<count($use_sosiki); $i++){
				if(in_array($use_sosiki[$i]['sosiki_pkey'],$child_array)){
					$view_use_sosiki[] = $use_sosiki[$i];
				}
			}
			return $view_use_sosiki;
		}else{
			return $use_sosiki;
		}
	}

	/**
	 * 申請書印刷
	 */
	function app_print_r(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST_APP);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		$hardhistory_pkey = addslashes(@$_REQUEST['code']);
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$hardhistory_pkey, "detail");
		
		//組織認証
		$this->sosiki_auth(array($detail['sinseisyozoku']));
		
		if(count($detail) > 0){
			$history    = $detail;
		}else{
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$item['syonin_kbn']        = $detail['syonin_kbn'];
		$item['syoninsya']         = $detail['syoninsya'];
		$item['syonin_date']       = $detail['syonin_date'];
		$item['sinsei_date'] = $detail['sinsei_date'];
		$item['sinseisya'] = $detail['sinseisya'];
		$item['email_ad'] = $detail['email_ad'];
		$item['hardhistory_pkey'] = $detail['hardhistory_pkey'];
		$item['hard_pkey'] = $detail['hard_pkey'];
		$item['hard_kanrino'] = $detail['hard_kanrino'];
		$item['version'] = $detail['version'];
		$user_referer = _USER_REFERER;

		if($history['hard_pkey'] != ""){
			$version = $history['version']-1;
			$detail = $this->db->dbSelect("SELECT * FROM hard_rireki_detail where hard_pkey = ".$history['hard_pkey']." and version=".$version." and syonin_kbn = 'd001'", "detail");
			if($detail['tyoutatu_date'] != ""){
				$tyoutatu_date = explode("-",$detail['tyoutatu_date']);
				$detail['tyoutatu_date'] = date("Y/m/d",mktime(0,0,0,$tyoutatu_date[1],$tyoutatu_date[2],$tyoutatu_date[0]));
			}
			if($detail['haiki_date'] != ""){
				$haiki_date = explode("-",$detail['haiki_date']);
				$detail['haiki_date'] = date("Y/m/d",mktime(0,0,0,$haiki_date[1],$haiki_date[2],$haiki_date[0]));
			}
			/** 比較 */
			$check_array = 	array(
						"sosiki_pkey",
						"hard_kanrino",
						"soft_installdel",
						"use_name",
						"price",
						"tyoutatu",
						"location",
						"bikou",
						"memo",
						"tyoutatu_date",
						"haiki_date"
					);
			foreach($check_array as $val){
				if(@$detail[$val] != @$history[$val]){
					$old[$val] = @$detail[$val];
					if(@$history[$val] == ""){
						$new[$val] = " ";
					}else{
						$new[$val] = $history[$val];
					}
				}else{
					$old[$val] = $detail[$val];
				}
			}
		}else{
			$new = $history;
		}
		$user_where = " where user_pkey = ".$this->authuser_code;
		$user_detail = $this->db->dbSelect("SELECT * FROM \"user\"".$user_where, "detail");

		/** 出力 */
		$this->tpl->assignHtml('old',@$old);
		$this->tpl->assignHtml('new',@$new);
		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('kessai',$user_detail['kessai']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		/** set template */
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('hardware/print_sinsei.html'));
		$this->tpl->outputHtml('print_sinsei.html');
	}

	/**
	 * ハードウェア台帳一覧
	 */
	function hard_search(){
		$this->tpl->assignHtml('title', _TITLE_HARD_LIST);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "hard_kanrino";
		}
		if(@$_REQUEST['sort_asc'] == "DESC"){
			$_REQUEST['sort_asc'] = "DESC";
		}else{
			$_REQUEST['sort_asc'] = "ASC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);
		if($this->sort == 'hard_kanrino' and $this->asc == "ASC"){
			$this->sort = "LENGTH(hard_kanrino),hard_kanrino";
		}elseif($this->sort == 'hard_kanrino' and $this->asc == "DESC"){
			$this->sort = "LENGTH(hard_kanrino) DESC,hard_kanrino";
		}
		$order = " order by ".$this->sort." ".$this->asc;

		/** デフォルト値設定 */
		if(@$_REQUEST['search_col1'] == ""){
			$_REQUEST['search_col1'] = "001";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "hard_kanrino";
				        break;
				    case "002":
					$s_col = "use_name";
				        break;
				    case "003":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "004":
					$s_col = "computername";
				        break;
				    case "005":
					$s_col = "ipaddress";
				        break;
				    case "006":
					$s_col = "location";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= ") and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM hard_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM hard_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** set template */
		$this->tpl->assignHtml('hardware_col', select_code("00024"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->outputHtml('hardware/sub_list.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * ハードウェア台帳一覧
	 */
	function hard_search_reload(){
		parse_str($_POST['params'],$request);
		$_REQUEST['page'] = @$request['page'];

		$this->tpl->assignHtml('title', _TITLE_HARD_LIST);
		$page_name = "";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$request['search_cd1'] == ""){
			$request['search_sosiki'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$request['search_sosiki']);

		/** パラメータ */
		$param_key = ereg_key($request,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($request,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($request[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(@$request['sort_name'] == ""){
			$request['sort_name'] = "hard_kanrino";
		}
		if(@$request['sort_asc'] == "DESC"){
			$request['sort_asc'] = "DESC";
		}else{
			$request['sort_asc'] = "ASC";
		}
		$this->sort = $request['sort_name'];
		$this->asc = $request['sort_asc'];
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);
		if($this->sort == 'hard_kanrino' and $this->asc == "ASC"){
			$this->sort = "LENGTH(hard_kanrino),hard_kanrino";
		}elseif($this->sort == 'hard_kanrino' and $this->asc == "DESC"){
			$this->sort = "LENGTH(hard_kanrino) DESC,hard_kanrino";
		}
		$order = " order by ".$this->sort." ".$this->asc;

		/** デフォルト値設定 */
		if(@$request['search_col1'] == ""){
			$request['search_col1'] = "001";
		}

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$request[$val] = trim(@$request[$val]);
			if(@$request[$val] != "" and @$request[$col] != ""){
				$search_val_base = @$request[$val];
				switch (@$request[$col]){
				    case "001":
					$s_col = "hard_kanrino";
				        break;
				    case "002":
					$s_col = "use_name";
				        break;
				    case "003":
					$s_col = "tyoutatu_date";
					$search_val_base = ereg_replace("\/","-",@$request[$val]);
				        break;
				    case "004":
					$s_col = "computername";
				        break;
				    case "005":
					$s_col = "ipaddress";
				        break;
				    case "006":
					$s_col = "location";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$request[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$request[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$request[$col]);
			$this->tpl->assignHtml($val,@$request[$val]);
			$this->tpl->assignHtml($comp,@$request[$comp]);
			$this->tpl->assignHtml($cd,@$request[$cd]);
		}

		$where .= ") and (haiki_date > '".date("Y/m/d")."' or haiki_date is null )";

		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$request['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sosiki_pkey in (".implode(",",$sosiki_array).")";

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM hard_detail".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM hard_detail".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** set template */
		$this->tpl->assignHtml('hardware_col', select_code("00024"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$html = $this->tpl->fetchHtml('hardware/sub_list_reload.html');
		print $html;
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * ハードウェア台帳一覧
	 */
	function hard_search_done(){
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		
		if(@$_REQUEST['no'] != "undefined" and @$_REQUEST['no'] != ""){
			$where = " where hard_pkey = ".$_REQUEST['no'];
			$detail = $this->db->dbSelect("SELECT * FROM hard_detail".$where, "detail");
		}else{
			$detail['hard_pkey']     = "";
			$detail['hard_kanrino']  = "";
			$detail['use_name']      = "&nbsp;";
		}
		
		$json = new Services_JSON();
		$hard_detail = $json->encode($detail);
		
		print $hard_detail;
	}

	/**
	 * ハードウェア台帳一覧
	 */
	function hard_select_done(){
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		
		if(@$_REQUEST['no'] != "undefined" and @$_REQUEST['no'] != ""){
			$where = " where hard_pkey = ".$_REQUEST['no'];
			$detail = $this->db->dbSelect("SELECT * FROM hard_detail".$where, "detail");
		}else{
			$detail['hard_pkey']     = "";
			$detail['hard_kanrino']  = "";
			$detail['use_name']      = "&nbsp;";
		}

		$detail['pkey'] = array();
		if($detail['hard_pkey'] != ""){
			$list = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$detail['hard_pkey']."' and (haiki_date > '".date("Y/m/d")."' or haiki_date is null) and newkbn <> 1 order by licence_kanrino", "list");
			if(count($list) > 0){
				for($i=0; $i<count($list); $i++){
					if($list[$i]['downgrade'] == "" or is_null($list[$i]['downgrade'])){
						$list[$i]['downgrade'] = "d002";
					}
					$licence_pkey[$i] = $list[$i]['licence_pkey'];
				}
			}
			$del_list = $this->db->dbSelect("select * from soft_detail where hard_pkey='".$detail['hard_pkey']."' and haiki_date <= '".date("Y/m/d")."' and newkbn <> 1 order by licence_kanrino", "list");
			if(count($del_list) > 0){
				for($i=0; $i<count($del_list); $i++){
					if($del_list[$i]['downgrade'] == "" or is_null($del_list[$i]['downgrade'])){
						$del_list[$i]['downgrade'] = "d002";
					}
					$del_licence_pkey[$i] = $del_list[$i]['licence_pkey'];
				}
			}
			
		}

		$this->tpl->assignHtml('list_view',$list);
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$licence_list = $this->tpl->fetchHtml('hardware/licence_list.html');
		$detail['list_view'] = $licence_list;

		$this->tpl->assignHtml('del_list_view',$del_list);
		$d_licence_list = $this->tpl->fetchHtml('hardware/licence_list_d.html');
		$detail['del_list_view'] = $d_licence_list;

		$json = new Services_JSON();
		$hard_detail = $json->encode($detail);
		
		print $hard_detail;
	}

	/**
	 * 設置場所絞込み
	 */
	function location_search(){
		$page_name = "system,sinsei,syonin";
		$this->login($page_name);

		$q = strtolower($_REQUEST["q"]);
		if (!$q) return;
		
		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		$where = " where sosiki_pkey in (".implode(",",$child_array).")";
		
		$list = $this->db->dbSelect("select DISTINCT ON (location) location from hard_detail".$where." order by location", "list");
		$items = array();
		if(count($list) > 0){
			for($i=0; $i<count($list); $i++){
				$items[] = $list[$i]['location'];
			}
		}

		foreach ($items as $value) {
			if (strpos(strtolower($value), $q) !== false) {
				echo "$value\n";
			}
		}

		
	}
}
?>