<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/**
* csv出力
 */
function csv($table_name,$option){
	header("Content-Type: application/octet-stream");
	header("Content-Disposition: attachment; filename=".$table_name.".csv");

	$db = new DbControll();
	$list = $db->dbSelect("SELECT * FROM \"".$table_name."\"".$option, "list");

	$header_array = array_keys($list[0]);
	for($i=0; $i<count($header_array); $i++){
		print(mb_convert_encoding($header_array[$i],"SJIS","UTF-8").",");
	}
	print("\n");
	
	for($j=0 ;$j<count($list); $j++) {
		for($k=0; $k<count($header_array); $k++) {
			$str = $list[$j][$header_array[$k]];
			print(mb_convert_encoding($str,"SJIS","UTF-8").",");
		}
		print("\n");
	}
}

/**
 * keyを正規表現で抽出
 */
function ereg_key($array,$str){
	$key_array = array();
	if(count($array) > 0){
		foreach($array as $key => $value){
			if(ereg($str,$key)){
				$key_array[] = $key;
			}
		}
	}
	return $key_array;
}

/**
 * コード分類一覧
 */
function select_bunrui() {
	$db = new DbControll();
	$list = $db->dbSelect("SELECT * FROM codebunrui ORDER BY code_bunrui", "list");
	$array = array();
	for($i=0;$i<count($list); $i++){
		$array[$list[$i]['code_bunrui']] = $list[$i]['code_bunruimei'];
	}
	return $array;
}

/**
 * コード一覧
 */
function select_code($bunrui) {
	$db = new DbControll();
	$list = $db->dbSelect("SELECT * FROM code where code_bunrui = '".$bunrui."' ORDER BY code_sort", "list");
	$array = array();
	for($i=0;$i<count($list); $i++){
		$array[$list[$i]['code']] = $list[$i]['code_name'];
	}
	return $array;
}

/**
 * 権限名一覧
 */
function select_auth() {
	$db = new DbControll();
	$list = $db->dbSelect("SELECT * FROM mt_auth", "list");
	for($i=0; $i<count($list); $i++){
		if($list[$i]['authority_id'] != ""){
			$auth[$list[$i]['authority_id']] = $list[$i]['authority_name'];
		}
	}
	return $auth;
}

/**
 * 所属名一覧
 */
function select_sosiki() {
	$db = new DbControll();
	$list = $db->dbSelect("SELECT * FROM sosiki where yukou = 'd001'ORDER BY sosiki_sortkey", "list");
	$sosiki["0"] = "";
	for($i=0; $i<count($list); $i++){
		if($list[$i]['sosiki_pkey'] != ""){
			$sosiki[$list[$i]['sosiki_pkey']] = implode("/",full_sosiki_name($list[$i]['sosiki_pkey']));
		}
	}
	return $sosiki;
}

/**
 * フル所属名
 */
function full_sosiki_name($pkey,$name=array()) {
	$db = new DbControll();
	$detail = $db->dbSelect("SELECT * FROM sosiki where sosiki_pkey = ".$pkey, "detail");
	array_unshift($name,$detail['syozoku_name']);
	if($detail['sosiki_onpkey']){
		return full_sosiki_name($detail['sosiki_onpkey'],$name);
	}else{
		return $name;
	}
}

/**
 * フル所属キー
 */
function full_sosiki_key($pkey,$key=array()) {
	$db = new DbControll();
	$detail = $db->dbSelect("SELECT * FROM sosiki_path where sosiki_pkey = ".$pkey, "detail");
	if($detail['parent_sosiki'] != "" and $detail['parent_sosiki'] != null){
		return explode(",",$detail['parent_sosiki']);
	}
	return array();
}

/**
 * 直の下位組織キー取得
 */
function direct_child_sosiki_key($pkey) {
	$key = array();
	$db = new DbControll();
	$list = $db->dbSelect("SELECT * FROM sosiki where sosiki_onpkey = ".$pkey." order by sosiki_sortkey", "list");
	if(count($list) > 0){
		for($i=0; $i<count($list); $i++){
			$direct_child_array[$i] = $list[$i]['sosiki_pkey'];
		}
		return $direct_child_array;
	}else{
		return array();
	}
}

/**
 * 自所属配下所属キー
 */
function child_sosiki_key($pkey) {
	$key = array();
	$db = new DbControll();
	$detail = $db->dbSelect("SELECT * FROM sosiki_path where sosiki_pkey = ".$pkey, "detail");
	if($detail['child_sosiki'] != "" and $detail['child_sosiki'] != null){
		return explode(",",$detail['child_sosiki']);
	}
	return array();
}

/**
 * フル所属キー(組織テーブル更新時のみ使用)
 */
function parent_sosiki_array($pkey,$key=array()) {
	$db = new DbControll();
	$detail = $db->dbSelect("SELECT * FROM sosiki where sosiki_pkey = ".$pkey, "detail");
	array_unshift($key,$pkey);
	if($detail['sosiki_onpkey']){
		return parent_sosiki_array($detail['sosiki_onpkey'],$key);
	}else{
		return $key;
	}
}

/**
 * 自所属配下所属キー(組織テーブル更新時のみ使用)
 */
function child_sosiki_array($pkey) {
	$key = array();
	$db = new DbControll();
	$list = $db->dbSelect("SELECT * FROM sosiki where sosiki_onpkey = ".$pkey, "list");
	for($i=0; $i<count($list); $i++){
		$key[] = $list[$i]['sosiki_pkey'];
		$key = array_merge($key,child_sosiki_array($list[$i]['sosiki_pkey']));
	}
	return $key;
}
function fgetExcelCSV(&$fp , $length = null, $delimiter = ',' , $enclosure = '"') {
    $line = fgets($fp);
    if($line === false) {
        return false;
    }
    $bytes = preg_split('//' , trim($line));
    array_shift($bytes);array_pop($bytes);
    $cols = array();
    $col = '';
    $isInQuote = false;
    while($bytes) {
        $byte = array_shift($bytes);
        if($isInQuote) {
            if($byte == $enclosure) {
                if(@$bytes[0] == $enclosure) {
                    $col .= $byte;
                    array_shift($bytes);
                } else {
                    $isInQuote = false;
                }
            } else {
                $col .= $byte;
            }
        } else {
            if($byte == $delimiter) {
                $cols[] = $col;
                $col = '';
            } elseif($byte == $enclosure && $col == '') {
                $isInQuote = true;
            } else {
                $col .= $byte;
            }
        }
        while(!$bytes && $isInQuote) {
            $col .= "\n";
            $line = fgets($fp);
            if($line === false) {
                $isInQuote = false;
            } else {
                $bytes = preg_split('//' , trim($line));
                array_shift($bytes);array_pop($bytes);
            }
        }
    }
    $cols[] = $col;
    return $cols;
}

function fgetcsv_reg (&$handle, $length = null, $d = ',', $e = '"') {
$d = preg_quote($d);
$e = preg_quote($e);
$_line = "";
$eof = false; // Added for PHP Warning.
while ( $eof != true ) {
$_line .= (empty($length) ? fgets($handle) : fgets($handle, $length));
$itemcnt = preg_match_all('/'.$e.'/', $_line, $dummy);
if ($itemcnt % 2 == 0) $eof = true;
}
$_csv_line = preg_replace('/(?:\\r\\n|[\\r\\n])?$/', $d, trim($_line));
$_csv_pattern = '/('.$e.'[^'.$e.']*(?:'.$e.$e.'[^'.$e.']*)*'.$e.'|[^'.$d.']*)'.$d.'/';

preg_match_all($_csv_pattern, $_csv_line, $_csv_matches);

$_csv_data = $_csv_matches[1];

for ( $_csv_i=0; $_csv_i<count($_csv_data); $_csv_i++ ) {
$_csv_data[$_csv_i] = preg_replace('/^'.$e.'(.*)'.$e.'$/s', '$1', $_csv_data[$_csv_i]);
$_csv_data[$_csv_i] = str_replace($e.$e, $e, $_csv_data[$_csv_i]);
}
return empty($_line) ? false : $_csv_data;
}

/**
 * 申請・承認デフォルト値設定
 */
function set_default_shinsei() {
		#デフォルト値読み込み
		if(@$_COOKIE["shinsei"]){
			list($shinseisya,$email)=explode(",",@$_COOKIE["shinsei"]);
		}else{
			$shinseisya = "";
			$email = "";
		}
		define('_DEFAULT_SINSEISYA', $shinseisya);
		define('_DEFAULT_EMAIL', $email);
		define('_DEFAULT_SYONINSYA', _DEFAULT_SINSEISYA);
}

/**
 * 申請時デフォルト値書換
 */
function change_default_shinsei($shinseisya,$email) {
		#デフォルト値
		$timeoutday=180;
		$timeout=time()+$timeoutday*86400;
		$value=join(",",array(@$shinseisya,@$email));
		setcookie("shinsei",$value,$timeout,'/');
}

/**
 * 承認時デフォルト値書換
 */
function change_default_syonin($syoninsya) {
		#デフォルト値読み込み
		if(@$_COOKIE["shinsei"]){
			$cookies = explode(",",@$_COOKIE["shinsei"]);
			$email = @$cookies[1];
		}else{
			$email = "";
		}
		#デフォルト値
		$timeoutday=180;
		$timeout=time()+$timeoutday*86400;
		$value=join(",",array(@$syoninsya,@$email));
		setcookie("shinsei",$value,$timeout,'/');
}

/**
 * DBログ書き出し（マニュアル）
 */
function db_log($user_name, $table, $action, $pkey){

	$filename = _LOG_PATH."/db".date("Ymd").".log";
	if(!file_exists($filename)){
		touch($filename);
		chmod($filename,0666);
		chown($filename,"apache");
		chgrp($filename,"apache");
	}
	$fp = fopen($filename, "a");
	fwrite($fp, date("Y-m-d H:i:s")." ".$user_name." ".$table." ".$action." ".$pkey."\n");
	fclose($fp);
}

function php_self_get(){
	$get = "";
	foreach($_GET as $key => $value){
		if(!$get){
			$get .= "?";
		}else{
			$get .= "&";
		}
		$get .= htmlspecialchars($key, ENT_QUOTES, 'UTF-8')."=".htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
	}
	return $_SERVER['SCRIPT_NAME'].$get;
}
?>
