<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

class ExtModel extends Model{

	function index(){
		$this->tpl->assignHtml('title', _TITLE_EXT);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));
		
		/** 一覧 */
		$list = $this->db->dbSelect("SELECT * FROM inventorydate order by invbunrui", "list");

		$this->tpl->assignHtml('runtime',$list);
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('ext/index.html'));
		$this->tpl->outputHtml('base.html');
		
	}
	
	function count(){
		$this->count_run();
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('massage',"ソフトウェア集計の出力が完了しました");
		$this->tpl->assignHtml('user_referer',"ext.php");
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		/** set template */
		$this->tpl->outputHtml('done.html');
	}
	
	function csv(){
		$this->csv_run();
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('error',  @$error);
		$this->tpl->assignHtml('massage',"台帳等の出力が完了しました");
		$this->tpl->assignHtml('user_referer',"ext.php");
		$this->tpl->assignHtml('action_name',_ACTION_APPADD);
		/** set template */
		$this->tpl->outputHtml('done.html');
	}
	
	function count_run(){
		/** programcount */
		$list = $this->db->dbSelect("select aaa.soft_name, aaa.licence_keitai_name, aaa.brand, aaa.hard_kotei_name, aaa.upgrade_name, (CASE WHEN aaa.install_su is Null then 0 else aaa.install_su END) AS install_su, (CASE WHEN aaa.install_qty is Null then 0 else aaa.install_qty END) AS install_qty, (CASE WHEN ccc.count is Null then 0 else ccc.count END) AS count from (select licencelist_detail.licencelist_pkey, licencelist_detail.soft_name, licencelist_detail.licence_keitai_name, licencelist_detail.brand, licencelist_detail.hard_kotei_name, licencelist_detail.upgrade_name, (CASE WHEN SUM(licence_detail.install_su) > 99999999 then 99999999 else SUM(licence_detail.install_su) END) AS install_su, SUM(licence_detail.install_qty) as install_qty from licencelist_detail LEFT JOIN licence_detail ON licencelist_detail.licencelist_pkey = licence_detail.licencelist_pkey and (licence_detail.haiki_date > '".date("Y/m/d")."' or licence_detail.haiki_date is null) and licence_detail.newkbn <> 1 where licencelist_detail.newkbn <> 1 group by licencelist_detail.licencelist_pkey,licencelist_detail.soft_name,licencelist_detail.licence_keitai_name,licencelist_detail.brand,licencelist_detail.hard_kotei_name,licencelist_detail.upgrade_name) aaa LEFT JOIN (select licencelistprogram. licencelist_pkey, count(*) as count from (((licencelistprogram LEFT JOIN licence ON licencelistprogram .licencelist_pkey = licence.licencelist_pkey and (licence.haiki_date > '".date("Y/m/d")."' or licence.haiki_date is null) and licence.newkbn <> 1) LEFT JOIN soft ON licence.licence_pkey = soft.licence_pkey and (soft.uninstall_date > '".date("Y/m/d")."' or soft.uninstall_date is null) and soft.newkbn <> 1) LEFT JOIN hard ON soft.hard_pkey = hard.hard_pkey and (hard.haiki_date > '".date("Y/m/d")."' or hard.haiki_date is null) and hard.newkbn <> 1) JOIN inventorysoft ON hard.hard_kanrino = inventorysoft.hardwareno and licencelistprogram. program_add_del = inventorysoft.insapname group by licencelistprogram. licencelist_pkey order by licencelistprogram.licencelist_pkey ) ccc ON ccc.licencelist_pkey = aaa.licencelist_pkey
", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$data = mb_convert_encoding($this->tpl->fetchHtml('ext/softcount.html'),"SJIS-win","UTF-8");
		$filename = _CSV_PATH."/".date("YmdHi")."softcount.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);


		/** programcount */
		$list = $this->db->dbSelect("select insapname , count(*) from inventorysoft LEFT JOIN inventory ON inventorysoft.hardwareno = inventory.hardwareno where inventory.jyotai != 'd004' group by insapname", "list");
		$filename = _CSV_PATH."/".date("YmdHi")."programcount.csv";
		$fp = fopen($filename, "w");
		fwrite($fp,"\"".mb_convert_encoding("プログラムの追加と削除での表示","SJIS-win","UTF-8")."\",\"".mb_convert_encoding("収集情報での検知数","SJIS-win","UTF-8")."\"\n");
		for($i=0;$i<count($list); $i++){
			fwrite($fp,"\"".mb_convert_encoding($list[$i]['insapname'],"SJIS-win","UTF-8")."\",");
			fwrite($fp,$list[$i]['count']."\n");
		}
		fclose($fp);
	}
	
	function csv_run(){
		$dir_path = _CSV_PATH."/".date("Ymd_His");
		
		if(!is_dir($dir_path)) {
			mkdir($dir_path, 0777);
			chmod($dir_path, 0777);
		}
		
		$this->tpl->assignHtml('authority',  "system");
		/** hard */
		$list = $this->db->dbSelect("SELECT * FROM hard_detail where newkbn <> 1", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('hardware_col', select_code("00010"));
		$this->tpl->assignHtml('install_col', select_code("00022"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$data = mb_convert_encoding($this->tpl->fetchHtml('hardware/csv.html'),"SJIS-win","UTF-8");
		$filename = $dir_path."/hard.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);

		/** soft */
		$list = $this->db->dbSelect("SELECT * FROM soft_detail where newkbn <> 1", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('soft_col', select_code("00011"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$data = mb_convert_encoding($this->tpl->fetchHtml('software/csv.html'),"SJIS-win","UTF-8");
		$filename = $dir_path."/soft.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);

		/** license */
		$list = $this->db->dbSelect("SELECT * FROM licence_detail where newkbn <> 1", "list");
		$sosiki_list = $this->db->dbSelect("SELECT * FROM sosiki", "list");
		$child_array = array();
		if(count($sosiki_list) > 0){
			for($i=0; $i<count($sosiki_list); $i++){
				$child_array[$i] = $sosiki_list[$i]['sosiki_pkey'];
			}
		}
		$this->tpl->assignHtml('kanri_child_sosiki',  $child_array);

		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('license_col', select_code("00012"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$data = mb_convert_encoding($this->tpl->fetchHtml('license/csv.html'),"SJIS-win","UTF-8");
		$filename = $dir_path."/license.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);
		
		/** license_list */
		$list = $this->db->dbSelect("SELECT * FROM licencelist_detail where newkbn <> 1", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('license_col', select_code("00013"));
		$this->tpl->assignHtml('gaitou_col', select_code("00004"));
		$this->tpl->assignHtml('type_col', select_code("00005"));
		$this->tpl->assignHtml('anpi_col', select_code("00006"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$data = mb_convert_encoding($this->tpl->fetchHtml('licenselist/csv.html'),"SJIS-win","UTF-8");
		$filename = $dir_path."/licenselist.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);
		
		/** license_list_program */
		$list = $this->db->dbSelect("SELECT licencelist_pkey,program_name FROM licencelist_program_detail where newkbn <> 1", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$data = mb_convert_encoding($this->tpl->fetchHtml('licenselist/csv_program.html'),"SJIS-win","UTF-8");
		$filename = $dir_path."/licenselistprogram.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);
		
		/** license_list_program_down */
		$list = $this->db->dbSelect("SELECT licencelist_pkey,program_name FROM licencelist_program_down_detail where newkbn <> 1", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$data = mb_convert_encoding($this->tpl->fetchHtml('licenselist/csv_program.html'),"SJIS-win","UTF-8");
		$filename = $dir_path."/licenselistprogram_down.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);
		
		
		/** program */
		$list = $this->db->dbSelect("SELECT * FROM program", "list");
		$data = "program_add_del\n";
		$filename = $dir_path."/program.csv";
		$fp = fopen($filename, "w");
		fwrite($fp,"\"".mb_convert_encoding("プログラムの追加と削除での表示","SJIS-win","UTF-8")."\"\n");
		for($i=0;$i<count($list); $i++){
			fwrite($fp,"\"".mb_convert_encoding($list[$i]['program_add_del'],"SJIS-win","UTF-8")."\"\n");
		}
		fclose($fp);
		
		/** inventory */
		$list = $this->db->dbSelect("SELECT * FROM inventory_detail", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$this->tpl->assignHtml('hardtype_col', select_code("00001"));
		$this->tpl->assignHtml('condition_col', select_code("00002"));
		$this->tpl->assignHtml('umu_col', select_code("00007"));
		$data = mb_convert_encoding($this->tpl->fetchHtml('inventory/csv.html'),"SJIS-win","UTF-8");
		$filename = $dir_path."/inventory.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);
		
		/** inventorysoft */
		$list = $this->db->dbSelect("SELECT * FROM inventorysoft_csv order by hardwareno", "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('inventory_col', select_code("00014"));
		$data = mb_convert_encoding($this->tpl->fetchHtml('inventory/p_csv.html'),"SJIS-win","UTF-8");
		$filename = $dir_path."/inventorysoft.csv";
		$fp = fopen($filename, "w");
		fwrite($fp, $data);
		fclose($fp);
	}
	
}

?>