<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** コントロール管理 */
class ControlModel extends Model{

	/**
	 * 一覧
	 */
	function index(){
		$this->tpl->assignHtml('title', _TITLE_CONT_LIST);
		$page_name = "system,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);

		/** ソート条件 */
		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "control_name";
		}
		if(@$_REQUEST['sort_asc'] == ""){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);


		/** 一覧 */
		if($this->authuser_authority == 'system'){
			/** 検索条件 */
			$where = "";
			$list = $this->db->dbSelect("SELECT * FROM \"control\"".$where.$order, "list");
		}else{
			$where = " where control_id = 'ALERT_DISCREPANT_DAY'";
			$list = $this->db->dbSelect("SELECT * FROM \"control\"".$where.$order, "list");
		}
		
		if( count($list) > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNavi(count($list), $count, $url, $param);
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, count($list), $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  array_slice($list, $this->nv->list_start, $count));
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('control/list.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	/**
	 * 編集
	 * 入力
	 */
	function edit(){
		$this->tpl->assignHtml('title', _TITLE_CONTROL);
		$page_name = "system,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** 入力ﾌｫｰﾑ */
		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re"){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			/** 入力値 */
			$control_id    = @$_SESSION['input']['control_id'];
			$control_name    = @$_SESSION['input']['control_name'];
			$settei       = @$_SESSION['input']['settei'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
		}else{
			$control_id = addslashes(@$_REQUEST['code']);
			/** 詳細ﾃﾞｰﾀ */
			$detail = $this->db->dbSelect("select * from \"control\" where control_id='".$control_id."'", "detail");
			if(count($detail) > 0){
				$control_name    = $detail['control_name'];
				$settei          = $detail['settei'];
			}else{
				$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
			}
			$user_referer = _USER_REFERER;
		}
		/** 出力 */
		$this->tpl->assignHtml('control_id', @$control_id);
		$this->tpl->assignHtml('control_name', @$control_name);
		$this->tpl->assignHtml('settei', @$settei);
		$this->tpl->assignHtml('user_referer',@$user_referer);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('control/input.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 確認
	 */
	function edit_conf(){
		$this->tpl->assignHtml('title', _TITLE_CONTROL);
		$page_name = "system,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']['control_id']    = @$_REQUEST['control_id'];
		$_SESSION['input']['control_name']    = @$_REQUEST['control_name'];
		$_SESSION['input']['settei']       = @$_REQUEST['settei'];
		$_SESSION['input']['user_referer'] = @$_REQUEST['user_referer'];
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** 出力 */
		$this->tpl->assignHtml('control_name',$_SESSION['input']['control_name']);
		$this->tpl->assignHtml('settei',$_SESSION['input']['settei']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action_param','edit');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('control/confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * 編集
	 * 登録
	 */
	function edit_done(){
		$page_name = "system,alert";
		$this->login($page_name);

print_r($_SESSION['input']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "edit";
		$this->check();
		/** CODE ｴｽｹｰﾌﾟ */
		$control_id = addslashes($_SESSION['input']['control_id']);
		$where = "control_id = '".$control_id."'";

		/** 登録 */
		$fields_values = array(
				"settei"   => $_SESSION['input']['settei']
				      );
		$this->db->dbUpdate("control", $fields_values, $where);
		/** 出力 */
		$this->tpl->assignHtml('db_error',  $this->db->error);
		$this->tpl->assignHtml('name',$_SESSION['input']['control_name']);
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		$this->tpl->assignHtml('action',"edit");
		$this->tpl->assignHtml('code',$control_id);
		$this->tpl->assignHtml('action_name',_ACTION_EDITER);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check(){
		#入力チェック
		$cci = new CheckItem;
		#必須項目
		$cci->checkItemNon(array("settei"=>_CONT_VALUE));

		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
		}
	}

}

?>