<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** コード管理 */
class CodeModel extends Model{

	/**
	 * 一覧
	 */
	function index(){
		$this->tpl->assignHtml('title', _TITLE_CODE);
		$page_name = "system";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** コード分類 */
		$code_bunrui = select_bunrui();
		$this->tpl->assignHtml('search_bunrui', @$_REQUEST['search_bunrui']);
		$this->tpl->assignHtml('bunrui',  $code_bunrui);
		$this->tpl->assignHtml('bunrui_code',  @$_REQUEST['search_bunrui']);

		if(@$_REQUEST['search_bunrui']){
			$where = " where code_bunrui = '".$_REQUEST['search_bunrui']."'";
			$list = $this->db->dbSelect("SELECT * FROM \"code\"".$where." order by code_sort", "list");
		}else{
			$list = array();
		}
		
		if( count($list) > 0){
			$this->tpl->assignHtml('list_view',  $list);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}

		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('code/code.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}

	function code_edit(){
		$page_name = "system";
		$this->login($page_name);
		
		if(@$_REQUEST['name'] == ""){
			$this->del($_REQUEST['bunrui_code'],$_REQUEST['code']);
			$this->sort($_REQUEST['bunrui_code']);
		}elseif(@$_REQUEST['name'] != ""){
			$sort = ereg_replace("[^0-9]","",@$_REQUEST['sort']);
			if($sort == ""){
				$sort = 32767;
			}
			$this->edit($_REQUEST['bunrui_code'],$_REQUEST['code'],$_REQUEST['name'],$sort);
			$this->sort($_REQUEST['bunrui_code']);
		}
		$this->table_view($_REQUEST['bunrui_code']);
	}

	function code_reg(){
		$page_name = "system";
		$this->login($page_name);

		$_SESSION['input'] = $_REQUEST;
		#入力チェック
		$cci = new CheckItem;
		#必須項目
		$cci->checkItemSelect(array('bunrui_code'=>'分類名'));
		$cci->checkItemNon(array('code'=>'コード',
					  'name'=>'コード名'
		));
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
		if($cci->error_flag == true){
			$this->tpl->assignHtml('error_msg',  $cci->error_msg);
			$error = '{"error":"'.addslashes(ereg_replace("\n","",$this->tpl->fetchHtml('code/code_error.html'))).'"}';
			print "$error";
		}else{
			$sort = ereg_replace("[^0-9]","",@$_REQUEST['sort']);
			if($sort == ""){
				$sort = 32767;
			}
			$this->reg($_REQUEST['bunrui_code'],$_REQUEST['code'],$_REQUEST['name'],$sort);
			$this->sort($_REQUEST['bunrui_code']);
			$this->table_view($_REQUEST['bunrui_code']);
		}
	}

	/**
	 * 新規追加
	 * 入力
	 */
	function reg($bunrui_code,$code,$name,$sort){
		$fields_values = array(
				"code_bunrui" => $bunrui_code,
				"code"        => $code,
				"code_name"   => $name,
				"code_sort"   => $sort
				      );
		$this->db->dbInsert("code", $fields_values);
	}

	/**
	 * 編集
	 */
	function edit($bunrui_code,$code,$name,$sort){
		$where = "code_bunrui = '".$bunrui_code."' and code = '".$code."'";
		$fields_values = array(
				"code_name"   => $name,
				"code_sort"   => $sort
				      );
		$this->db->dbUpdate("code", $fields_values, $where);
	}

	/**
	 * 削除
	 */
	function del($bunrui_code,$code){
		$where = "code_bunrui = '".$bunrui_code."' and code = '".$code."'";
		$this->db->dbDelete("code", $where);
	}
	
	/**
	 * 表示
	 */
	function table_view($bunrui_code){
		$where = " where code_bunrui = '".$bunrui_code."'";
		$list = $this->db->dbSelect("SELECT * FROM \"code\"".$where." order by code_sort", "list");

		if( count($list) > 0){
			$this->tpl->assignHtml('list_view',  $list);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$this->tpl->assignHtml('bunrui_code',  $bunrui_code);
		$table = '{"data":"'.addslashes(ereg_replace("\n","",$this->tpl->fetchHtml('code/code_table.html'))).'","error":"non"}';
		print "$table";

	}
	
	/**
	 * ソート
	 */
	function sort($bunrui_code){
		$where = " where code_bunrui = '".$bunrui_code."'";
		$list = $this->db->dbSelect("SELECT * FROM \"code\"".$where." order by code_sort", "list");

		for($i=0; $i<count($list); $i++){
			$sort_key = ($i+1)*10;
			$where = "code_bunrui = '".$bunrui_code."' and code = '".$list[$i]['code']."'";
			$fields_values = array(
					"code_sort"   => $sort_key
					      );
			$this->db->dbUpdate("code", $fields_values, $where);
		}
	}
}

?>