<?php
/**
 * SARMS
 * Copyright (C) 2011  NEC Corporation
 * 
 * This file is part of SARMS.
 * 
 * SARMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * SARMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with SARMS.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Editer URL   : http://www.2ndgate.jp
 * Editer email : info@2ndgate.jp
 * Ver 1.0 date : 2010/09/15
 * character    : UTF-8
 */

/** 未承認・承認済 */
class ApprovalModel extends Model{

	function index(){
		$this->tpl->assignHtml('title', _TITLE_APP_LIST);
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_REQUEST['search_cd1'] == ""){
			$_REQUEST['search_sosiki'] = "on";
			$_REQUEST['search_shounin'] = "on";
		}
		$this->tpl->assignHtml('search_sosiki',@$_REQUEST['search_sosiki']);
		$this->tpl->assignHtml('search_shounin',@$_REQUEST['search_shounin']);

		/** パラメータ */
		$param_key = ereg_key($_REQUEST,"sort");
		$param_sort = "";
		for($i=0; $i<count($param_key); $i++){
			$param_sort .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param_key = ereg_key($_REQUEST,"search");
		$param_search = "";
		for($i=0; $i<count($param_key); $i++){
			$param_search .= $param_key[$i]."=".rawurlencode(stripslashes($_REQUEST[$param_key[$i]]))."&amp;";
		}
		$param = $param_search.$param_sort;
		$this->tpl->assignHtml('param_search', $param_search);
		$this->tpl->assignHtml('param', $param);

		/** ソート条件 */
		if(count(@$_REQUEST['app_array']) <= 0){
			$app_array = array();
		}else{
			$app_array = $_REQUEST['app_array'];
		}

		if(@$_REQUEST['sort_name'] == ""){
			$_REQUEST['sort_name'] = "sinsei_date";
		}
		if(@$_REQUEST['sort_asc'] == "ASC"){
			$_REQUEST['sort_asc'] = "ASC";
		}else{
			$_REQUEST['sort_asc'] = "DESC";
		}
		$this->sort = $_REQUEST['sort_name'];
		$this->asc = $_REQUEST['sort_asc'];
		$order = " order by ".$this->sort." ".$this->asc;
		$this->tpl->assignHtml('sort',  $this->sort);
		$this->tpl->assignHtml('asc',   $this->asc);

		/** 検索条件 */
		$search_max = 3;
		$where = " where (";
		for($i=1; $i<=$search_max; $i++){
			$col = "search_col".$i;
			$val = "search_value".$i;
			$comp = "search_comp".$i;
			$cd = "search_cd".$i;
			@$_REQUEST[$val] = trim(@$_REQUEST[$val]);
			if(@$_REQUEST[$val] != "" and @$_REQUEST[$col] != ""){
				$search_val_base = @$_REQUEST[$val];
				switch (@$_REQUEST[$col]){
				    case "001":
					$s_col = "history_type_name";
				        break;
				    case "002":
					$s_col = "sosiki_fullname";
				        break;
				    case "003":
					$s_col = "sinseisya";
				        break;
				    case "004":
					$s_col = "sinsei_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "005":
					$s_col = "syonin_kbn_name";
				        break;
				    case "006":
					$s_col = "syoninsya";
				        break;
				    case "007":
					$s_col = "syonin_date";
					$search_val_base = ereg_replace("\/","-",@$_REQUEST[$val]);
				        break;
				    case "008":
					$s_col = "shinsei_no";
				        break;
				    case "009":
					$s_col = "kanri_no";
				        break;
				    default:
					$s_col = "";
				        break;
				}
				switch (@$_REQUEST[$comp]){
				    case "002":
					$s_val = " = LOWER('".addslashes($search_val_base)."')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "003":
					$s_val = " >= '".addslashes($search_val_base)."'";
				        break;
				    case "004":
					$s_val = " <= '".addslashes($search_val_base)."'";
				        break;
				    case "005":
					$s_val = " not like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				    case "001":
				    default:
					$s_val = " like LOWER('%".addslashes($search_val_base)."%')";
					$s_col = "LOWER(".$s_col."::TEXT)";
				        break;
				}
			}else{
				$s_val = "";
			}
			
			if(@$s_col != "" and $s_val != ""){
				$search = " ".$s_col.$s_val;
			}else{
				$search = " 1=1";
			}
			
			if($search_max > $i){
				if(@$_REQUEST[$cd] == "002"){
					$where .= $search." or";
				}else{
					$where .= $search." and";
				}
			}else{
				$where .= $search;
			}
			
			$this->tpl->assignHtml($col,@$_REQUEST[$col]);
			$this->tpl->assignHtml($val,@$_REQUEST[$val]);
			$this->tpl->assignHtml($comp,@$_REQUEST[$comp]);
			$this->tpl->assignHtml($cd,@$_REQUEST[$cd]);
		}

		$where .= ")";

		$child_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$child_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		//所属
		$sosiki_where = " where user_pkey = ".$this->authuser_code;
		$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
		$child_array = child_sosiki_key($detail['sosiki_pkey']);
		$full = full_sosiki_key($detail['sosiki_pkey']);
		array_unshift($child_array,$detail['sosiki_pkey']);
		array_pop($full);
		if(@$_REQUEST['search_sosiki'] == "on"){
			$sosiki_array = $child_array;
		}else{
			$sosiki_array = array_merge($child_array,$full);
		}
		$where .= " and sinseisyozoku in ('".implode("','",$sosiki_array)."')";

		if(@$_REQUEST['search_shounin'] == "on"){
			$where .= " and (syonin_kbn = '' or syonin_kbn is null )";
		}

		/** 一覧 */
		$list = $this->db->dbSelect("SELECT count(*) FROM rireki_detail_list".$where, "detail");
		if( $list['count'] > 0){
			/** ﾅﾋﾞｹﾞｰｼｮﾝ */
			$count = _LIST_QTY;
			$url   = $_SERVER["SCRIPT_NAME"]."?";
			$this->nv->pageNaviPost($list['count'], $count, $url, $param);
			$limit = " limit ".$count." offset ".$this->nv->list_start;
			$list_limit = $this->db->dbSelect("SELECT * FROM rireki_detail_list".$where.$order.$limit, "list");
			/** 出力 */
			$this->tpl->assignHtml('navi',       $this->nv->navi);
			$this->tpl->assignHtml('navi_count', sprintf(_NAVI_COUNT, $list['count'], $this->nv->count_start, $this->nv->count_end));
			$this->tpl->assignHtml('list_view',  $list_limit);
		}else{
			/** 出力 */
			$this->tpl->assignHtml('db_error', Error::ErrorView("0004"));
		}
		$_SESSION['csv'] = $where.$order;
		/** set template */
		$this->tpl->assignHtml('app_array', $app_array);
		$this->tpl->assignHtml('sosiki_array', $child_array);
		$this->tpl->assignHtml('authority', $this->authuser_authority);
		$this->tpl->assignHtml('rireki_col', select_code("00015"));
		$this->tpl->assignHtml('comp_col', select_code("00018"));
		$this->tpl->assignHtml('cd_col', select_code("00019"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('approval/list.html'));
		$this->tpl->outputHtml('base.html');
		/** ｾｯｼｮﾝ削除 検索条件 */
		unset($_SESSION['input']);
	}
	
	/**
	 * csv出力
	 */
	function csv(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sinseisyozoku in ('".implode("','",$sosiki_array)."') and (syonin_kbn = '' or syonin_kbn is null )";
		}

		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=approval.csv");

		$list = $this->db->dbSelect("SELECT * FROM rireki_detail_list".$_SESSION['csv'], "list");
		$this->tpl->assignHtml('list_view',  $list);
		$this->tpl->assignHtml('rireki_col', select_code("00015"));
		$this->tpl->assignHtml('parent', select_sosiki());
		print mb_convert_encoding($this->tpl->fetchHtml('approval/csv.html'),"SJIS-win","UTF-8");
	}
	
	/**syonin
	 * プリント出力
	 */
	function prt(){
		$page_name = "system,sinsei,syonin,alert";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_APP_LIST);

		//デフォルト検索条件設定
		if(@$_SESSION['csv'] == ""){
			//所属
			$sosiki_where = " where user_pkey = ".$this->authuser_code;
			$detail = $this->db->dbSelect("SELECT * FROM user_detail".$sosiki_where, "detail");
			$child_array = child_sosiki_key($detail['sosiki_pkey']);
			array_unshift($child_array,$detail['sosiki_pkey']);
			$sosiki_array = $child_array;
			$_SESSION['csv'] = " where sinseisyozoku in ('".implode("','",$sosiki_array)."') and (syonin_kbn = '' or syonin_kbn is null )";
		}

		$list = $this->db->dbSelect("SELECT * FROM rireki_detail_list".$_SESSION['csv'], "list");

		$this->tpl->assignHtml('list_view',$list);
		$this->tpl->assignHtml('rireki_col', select_code("00015"));
		$this->tpl->assignHtml('parent', select_sosiki());
		$this->tpl->assignHtml('print_table', $this->tpl->fetchHtml('approval/print.html'));
		$this->tpl->outputHtml('print_list.html');

	}
	
	/**
	 * まとめて承認
	 */
	function syonin(){
		$page_name = "system,syonin";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_APP_LIST);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
			$app_array = @$_SESSION['input']['app_array'];
		}else{
			$app_array = @$_REQUEST['app_array'];
			$item['syoninsya'] = _DEFAULT_SYONINSYA;
			$item['syonin_date'] = date("Y/m/d H:i:s");
			$user_referer = _USER_REFERER;
		}
		$app = array();
		for($i=0; $i<count($app_array); $i++){
			list($pkey,$type) = explode("_",$app_array[$i]);
			$app[$type][] = $pkey;
		}
		$_SESSION['app'] = $app;

		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('qty', count(@$app_array));
		$this->tpl->assignHtml('app', @$app_array);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_param','syonin');
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('approval/syonin.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * まとめて承認
	 * 確認
	 */
	function syonin_conf(){
		$this->tpl->assignHtml('title', _TITLE_APP_LIST);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 承認時デフォルト値書換 */
		change_default_syonin(@$_SESSION['input']['syoninsya']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "syonin";
		$this->check_app();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('qty', count(@$_REQUEST['app_array']));
		$this->tpl->assignHtml('app', @$_REQUEST['app_array']);
		$this->tpl->assignHtml('syonin', @$_SESSION['input']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);

		$this->tpl->assignHtml('action_param','syonin');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('approval/syonin_confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * まとめて承認
	 */
	function syonin_done(){
		$page_name = "system,syonin";
		$this->login($page_name);

		$app = $_SESSION['app'];
		$this->error_count = 0;		
		for($i=0; $i<count(@$app['d001']); $i++){
			if($this->check001($app['d001'][$i])){
				$this->reg001($app['d001'][$i]);
			}else{
				$this->error_count++;
			}
		}
		for($i=0; $i<count(@$app['d002']); $i++){
			if($this->check002($app['d002'][$i])){
				$this->reg002($app['d002'][$i]);
			}else{
				$this->error_count++;
			}
		}
		for($i=0; $i<count(@$app['d003']); $i++){
			if($this->check003($app['d003'][$i])){
				$this->reg003($app['d003'][$i]);
			}else{
				$this->error_count++;
			}
		}
		for($i=0; $i<count(@$app['d004']); $i++){
			if($this->check004($app['d004'][$i])){
				$this->reg004($app['d004'][$i]);
			}else{
				$this->error_count++;
			}
		}
		if($this->error_count > 0){
			$this->tpl->assignHtml('db_error', $this->error_count."件がエラーで承認できませんでした。");
		}else{
			$this->tpl->assignHtml('db_error', "一括承認が完了しました。");
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}
	
	/**
	 * まとめて却下
	 */
	function kyakka(){
		$page_name = "system,syonin";
		$this->login($page_name);
		$this->tpl->assignHtml('title', _TITLE_APP_LIST);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		if(@$_SESSION['input']['error_flag'] == true || @$_REQUEST['input'] == "re" || @$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('error_flag',@$_SESSION['input']['error_flag']);
			$this->tpl->assignHtml('error_msg', @$_SESSION['input']['error_msg']);
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			/** 入力値 */
			$item = @$_SESSION['input'];
			$user_referer = @$_SESSION['input']['user_referer'];
			/** ｴﾗｰｾｯｼｮﾝ削除 */
			$_SESSION['input']['error_flag'] = false;
			$_SESSION['input']['error_msg']  = "";
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
			$app_array = @$_SESSION['input']['app_array'];
		}else{
			$app_array = @$_REQUEST['app_array'];
			$item['syoninsya'] = _DEFAULT_SYONINSYA;
			$item['syonin_date'] = date("Y/m/d H:i:s");
			$user_referer = _USER_REFERER;
		}
		$app = array();
		for($i=0; $i<count($app_array); $i++){
			list($pkey,$type) = explode("_",$app_array[$i]);
			$app[$type][] = $pkey;
		}
		$_SESSION['app'] = $app;

		$this->tpl->assignHtml('item', @$item);
		$this->tpl->assignHtml('qty', count(@$app_array));
		$this->tpl->assignHtml('app', @$app_array);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('user_referer',$user_referer);
		$this->tpl->assignHtml('action_param','kyakka');
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('approval/kyakka.html'));
		$this->tpl->outputHtml('base.html');
	}
	
	/**
	 * まとめて却下
	 * 確認
	 */
	function kyakka_conf(){
		$this->tpl->assignHtml('title', _TITLE_APP_LIST);
		$page_name = "system,syonin";
		$this->login($page_name);
		//メニューリスト
		$Menu = new Menu;
		$this->tpl->assignHtml('menu', $Menu->menu_list($this->authuser_authority,$page_name));

		/** ｾｯｼｮﾝ登録 */
		$_SESSION['input']    = @$_REQUEST;
		/** 承認時デフォルト値書換 */
		change_default_syonin(@$_SESSION['input']['syoninsya']);
		/** 入力ﾁｪｯｸ */
		$_SESSION['input']['method'] = "kyakka";
		$this->check_app();
		if(@$_SESSION['input']['error_flag'] == true){
			/** 入力ﾌｫｰﾑへ */
			header("Location: ".$_SERVER["REQUEST_URI"]."?action=".$_SESSION['input']['method']);
			exit;
		}
		if(@$_SESSION['input']['att_flag'] == true){
			/** ｴﾗｰ */
			$this->tpl->assignHtml('att_flag',@$_SESSION['input']['att_flag']);
			$this->tpl->assignHtml('att_msg', @$_SESSION['input']['att_msg']);
			$_SESSION['input']['att_flag'] = false;
			$_SESSION['input']['att_msg']  = "";
		}
		/** 出力 */
		$this->tpl->assignHtml('item',   $_SESSION['input']);
		$this->tpl->assignHtml('qty', count(@$_REQUEST['app_array']));
		$this->tpl->assignHtml('app', @$_REQUEST['app_array']);
		$this->tpl->assignHtml('syonin', @$_SESSION['input']);
		$this->tpl->assignHtml('syonin_col', select_code("00015"));
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);

		$this->tpl->assignHtml('action_param','kyakka');
		/** set template */
		$this->tpl->assignHtml('admin_contents', $this->tpl->fetchHtml('approval/kyakka_confirm.html'));
		$this->tpl->outputHtml('base.html');
	}

	/**
	 * まとめて却下
	 */
	function kyakka_done(){
		$page_name = "system,syonin";
		$this->login($page_name);

		$app = $_SESSION['app'];
		$this->error_count = 0;		
		for($i=0; $i<count(@$app['d001']); $i++){
			$this->del001($app['d001'][$i]);
		}
		for($i=0; $i<count(@$app['d002']); $i++){
			$this->del002($app['d002'][$i]);
		}
		for($i=0; $i<count(@$app['d003']); $i++){
			$this->del003($app['d003'][$i]);
		}
		for($i=0; $i<count(@$app['d004']); $i++){
			$this->del004($app['d004'][$i]);
		}
		if($this->error_count > 0){
			$this->tpl->assignHtml('db_error', $this->error_count."件がエラーで却下できませんでした。");
		}else{
			$this->tpl->assignHtml('db_error', "一括却下が完了しました。");
		}
		/** 出力 */
		$this->tpl->assignHtml('user_referer',$_SESSION['input']['user_referer']);
		/** set template */
		$this->tpl->outputHtml('done.html');
		/** ｾｯｼｮﾝ削除 */
		unset($_SESSION['input']);
	}
	
	function reg001($pkey){

		$where = "hardhistory_pkey = ".$pkey;
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['hard_kanrino']);
			$where = "history_pkey = ".$pkey." and history_type = 'd001'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => "d001",
					"syoninsya"           => $_SESSION['input']['syoninsya'],
					"syonin_date"         => $_SESSION['input']['syonin_date']
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);
			
			$where = "hard_pkey = ".$detail['hard_pkey'];
			$fields_values = array(
					"sosiki_pkey"       => $detail['sosiki_pkey'],
					"hard_kanrino"      => $detail['hard_kanrino'],
					"soft_installdel"   => $detail['soft_installdel'],
					"use_name"          => $detail['use_name'],
					"price"             => $detail['price'],
					"tyoutatu"          => $detail['tyoutatu'],
					"location"          => $detail['location'],
					"memo"              => $detail['memo'],
					"bikou"             => $detail['bikou'],
					"tyoutatu_date"     => $detail['tyoutatu_date'],
					"haiki_date"        => $detail['haiki_date'],
					"version"           => $detail['version'] + 1, 
					"newkbn"            => 0
					      );
			$this->db->dbUpdate("\"hard\"", $fields_values, $where);

			$action = "承認";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$_SESSION['input']['syoninsya']);
			$mail_tpl->assignHtml('syonin_date',$_SESSION['input']['syonin_date']);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ハードウェア台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ハードウェア台帳　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->error_count++;
		}
	}
	
	function reg002($pkey){

		$softhistory_pkey = $pkey;
		/** 詳細ﾃﾞｰﾀ */
		$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");
		/** 詳細ﾃﾞｰﾀ */
		$where = "shinsei_no = ".$soft_detail['shinsei_no'];
		$detail = $this->db->dbSelect("select * from soft_rireki_detail where ".$where, "list");
		$this->tpl->assignHtml('name',$detail[0]['hard_kanrino']);
		if(count($detail) > 0){
			for($i=0; $i<count($detail); $i++){
				$where_soft = "soft_pkey = ".$detail[$i]['soft_pkey'];
				$fields_values = array(
						"hard_pkey"         => $detail[$i]['hard_pkey'],
						"licence_pkey"      => $detail[$i]['licence_pkey'],
						"downgrade"         => $detail[$i]['downgrade'],
						"bikou"             => $detail[$i]['bikou'],
						"install_date"      => $detail[$i]['tyoutatu_date'],
						"uninstall_date"    => $detail[$i]['haiki_date'],
						"memo"              => $detail[$i]['memo'],
						"version"           => $detail[$i]['version'] + 1, 
						"newkbn"            => 0
						      );
				$this->db->dbUpdate("\"soft\"", $fields_values, $where_soft);
			}

			$where = "shinsei_no = ".$soft_detail['shinsei_no']." and history_type = 'd002'";
			$fields_values = array(
					"syonin_kbn"          => "d001",
					"syoninsya"           => $_SESSION['input']['syoninsya'],
					"syonin_date"         => $_SESSION['input']['syonin_date']
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

			$action = "承認";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$_SESSION['input']['syoninsya']);
			$mail_tpl->assignHtml('syonin_date',$_SESSION['input']['syonin_date']);
			$mail_tpl->assignHtml('sinsei_date',$detail[0]['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ソフトウェア台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ソフトウェア台帳　".$action;

			$email->email($detail[0]['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->error_count++;
		}
	}
	
	function reg003($pkey){

		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$pkey, "detail");
		$licencehistory_pkey = $detail_history['shinsei_no'];
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',@$detail_history['licence_kanrino']);
			$hold_qty = $this->db->dbSelect("select * from hold_licence_qty where licence_kanrino='".$detail['licence_kanrino']."'", "detail");
			if(count($hold_qty) > 0){
				$where_hold_qty = "licence_kanrino ='".$detail['licence_kanrino']."'";
				$fields_values = array(
						"hold_qty" => $detail['hold_qty']
						      );
				$this->db->dbUpdate("\"hold_licence_qty\"", $fields_values, $where_hold_qty);
			}else{
				$fields_values = array(
						"licence_kanrino" => $detail['licence_kanrino'],
						"hold_qty" => $detail['hold_qty']
						      );
				$this->db->dbInsert("\"hold_licence_qty\"", $fields_values);
			}
			
			$detail_shinsei = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."'", "list");
			for($i=0; $i<count($detail_shinsei); $i++){
				$where_rireki = "history_pkey = ".$detail_shinsei[$i]['licencehistory_pkey']." and history_type = 'd003'";
				$fields_values = array(
						"syonin_kbn"          => "d001",
						"syoninsya"           => $_SESSION['input']['syoninsya'],
						"syonin_date"         => $_SESSION['input']['syonin_date']
						      );
				$this->db->dbUpdate("\"rireki\"", $fields_values, $where_rireki);

				$where_list = "licence_pkey = ".$detail_shinsei[$i]['licence_pkey'];
				$fields_values = array(
						"kanri_sosiki_pkey" => $detail_shinsei[$i]['kanri_sosiki_pkey'],
						"sosiki_pkey"       => $detail_shinsei[$i]['sosiki_pkey'],
						"licencelist_pkey"  => $detail_shinsei[$i]['licencelist_pkey'],
						"licence_kanrino"   => $detail_shinsei[$i]['licence_kanrino'],
						"install_su"        => $detail_shinsei[$i]['install_su'],
						"hard_pkey"         => $detail_shinsei[$i]['hard_pkey'],
						"licence_pkey2"     => $detail_shinsei[$i]['licence_pkey2'],
						"licence_no"        => $detail_shinsei[$i]['licence_no'],
						"tyoutatu"          => $detail_shinsei[$i]['tyoutatu'],
						"hokan_baitai"      => $detail_shinsei[$i]['hokan_baitai'],
						"hokan_basyo"       => $detail_shinsei[$i]['hokan_basyo'],
						"bikou"             => $detail_shinsei[$i]['bikou'],
						"tyoutatu_date"     => $detail_shinsei[$i]['tyoutatu_date'],
						"haiki_date"        => $detail_shinsei[$i]['haiki_date'],
						"price"             => $detail_shinsei[$i]['price'],
						"use_limit_date"    => $detail_shinsei[$i]['use_limit_date'],
						"memo"              => $detail_shinsei[$i]['memo'],
						"version"           => $detail_shinsei[$i]['version'] + 1, 
						"newkbn"            => 0
						      );
				$this->db->dbUpdate("\"licence\"", $fields_values, $where_list);
			}

			$action = "承認";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$_SESSION['input']['syoninsya']);
			$mail_tpl->assignHtml('syonin_date',$_SESSION['input']['syonin_date']);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ライセンス台帳　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->error_count++;
		}
	}
	
	function reg004($pkey){

		$where = "licencehistory_pkey = ".$pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where ".$where, "detail");
		#プログラムの追加と削除登録用データ
		if($detail['program_add_del']){
			$detail['program_add_del'] = ereg_replace("\r","",$detail['program_add_del']);
			$detail['program_add_del'] = ereg_replace("\(RETURN\)","\r",$detail['program_add_del']);
			$detail['program_add_del'] = explode("\n",$detail['program_add_del']);
		}else{
			$detail['program_add_del'] = array();
		}
		#ダウングレード使用時のプログラムの追加と削除登録用データ
		if($detail['program_add_del_down']){
			$detail['program_add_del_down'] = ereg_replace("\r","",$detail['program_add_del_down']);
			$detail['program_add_del_down'] = ereg_replace("\(RETURN\)","\r",$detail['program_add_del_down']);
			$detail['program_add_del_down'] = explode("\n",$detail['program_add_del_down']);
		}else{
			$detail['program_add_del_down'] = array();
		}
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_name']);
			$where = "history_pkey = ".$pkey." and history_type = 'd004'";
			/** 自動承認 */
			$fields_values = array(
					"syonin_kbn"          => "d001",
					"syoninsya"           => "自動承認",
					"syonin_date"         => date("Y/m/d H:i")
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);
			
			$where = "licencelist_pkey = ".$detail['licencelist_pkey'];
			$fields_values = array(
					"soft_name"            => $detail['soft_name'],     
					"licence_keitai"       => $detail['licence_keitai'],     
					"brand"                => $detail['brand'],     
					"hard_kotei"           => $detail['hard_kotei'],
					"upgrade"              => $detail['upgrade'],
					"useproposal_kakunin"  => $detail['useproposal_kakunin'], 
					"tokusitu_useproposal" => $detail['tokusitu_useproposal'], 
					"useproposal_youken"   => $detail['useproposal_youken'], 
					"bikou"                => $detail['bikou'], 
					"yukou"                => $detail['yukou'], 
					"edition"              => $detail['edition'], 
					"disabled"             => $detail['disabled'], 
					"memo"                 => $detail['memo'], 
					"version"              => $detail['version'] + 1, 
					"upd_date"             => $detail['sinsei_date'], 
					"upd_name"             => $detail['sinseisya'], 
					"upd_syozoku"          => $detail['sinseisyozoku'], 
					"newkbn"               => 0
					      );
			$this->db->dbUpdate("\"licencelist\"", $fields_values, $where);
			$code = $detail['licencelist_pkey'];
			
			$where = "licencelist_pkey = ".$code;
			#プログラムの追加と削除登録
			$this->db->dbDelete("\"licencelistprogram\"", $where);
			for($i=0; $i<count($detail['program_add_del']); $i++){
				$fields_values = array(
						"licencelist_pkey"     => $code,
						"program_add_del"      => $detail['program_add_del'][$i]
						      );
				$this->db->dbInsert("\"licencelistprogram\"", $fields_values);
			}
			#ダウングレード使用時のプログラムの追加と削除登録
			$this->db->dbDelete("\"licencelistprogram_down\"", $where);
			for($i=0; $i<count($detail['program_add_del_down']); $i++){
				$fields_values = array(
						"licencelist_pkey"     => $code,
						"program_add_del"      => $detail['program_add_del_down'][$i]
						      );
				$this->db->dbInsert("\"licencelistprogram_down\"", $fields_values);
			}

			$action = "承認";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$_SESSION['input']['syoninsya']);
			$mail_tpl->assignHtml('syonin_date',$_SESSION['input']['syonin_date']);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス一覧表");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ライセンス一覧表　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->error_count++;
		}
	}
	
	function del001($pkey){

		$where = "hardhistory_pkey = ".$pkey;
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where ".$where, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['hard_kanrino']);
			$where = "history_pkey = ".$pkey." and history_type = 'd001'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => "d002",
					"syoninsya"           => $_SESSION['input']['syoninsya'],
					"syonin_date"         => $_SESSION['input']['syonin_date']
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

			$where_list = "hard_pkey = ".$detail['hard_pkey']." and newkbn = 1";
			$this->db->dbDelete("\"hard\"", $where_list);

			$action = "却下";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$_SESSION['input']['syoninsya']);
			$mail_tpl->assignHtml('syonin_date',$_SESSION['input']['syonin_date']);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ハードウェア台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ハードウェア台帳　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->error_count++;
		}
	}
	
	function del002($pkey){

		$softhistory_pkey = $pkey;
		/** 詳細ﾃﾞｰﾀ */
		$soft_detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$softhistory_pkey, "detail");
		/** 詳細ﾃﾞｰﾀ */
		$where = "shinsei_no = ".$soft_detail['shinsei_no'];
		$detail = $this->db->dbSelect("select * from soft_rireki_detail where ".$where, "list");
		$this->tpl->assignHtml('name',$detail[0]['hard_kanrino']);
		if(count($detail) > 0){
			for($i=0; $i<count($detail); $i++){
				$where_list = "soft_pkey = ".$detail[$i]['soft_pkey']." and newkbn = 1";
				$this->db->dbDelete("\"soft\"", $where_list);
			}

			$where = "shinsei_no = ".$soft_detail['shinsei_no']." and history_type = 'd002'";
			$fields_values = array(
					"syonin_kbn"          => "d002",
					"syoninsya"           => $_SESSION['input']['syoninsya'],
					"syonin_date"         => $_SESSION['input']['syonin_date']
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

			$action = "却下";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$_SESSION['input']['syoninsya']);
			$mail_tpl->assignHtml('syonin_date',$_SESSION['input']['syonin_date']);
			$mail_tpl->assignHtml('sinsei_date',$detail[0]['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ソフトウェア台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ソフトウェア台帳　".$action;

			$email->email($detail[0]['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->error_count++;
		}
	}
	
	function del003($pkey){

		$detail_history = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$pkey, "detail");
		$licencehistory_pkey = $detail_history['shinsei_no'];
		/** 詳細ﾃﾞｰﾀ */
		$detail = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$licencehistory_pkey, "detail");
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',@$detail_history['licence_kanrino']);
			
			$detail_shinsei = $this->db->dbSelect("SELECT * FROM licence_rireki_detail where shinsei_no = '".$detail['shinsei_no']."'", "list");
			for($i=0; $i<count($detail_shinsei); $i++){
				$where_rireki = "history_pkey = ".$detail_shinsei[$i]['licencehistory_pkey']." and history_type = 'd003'";
				$fields_values = array(
						"syonin_kbn"          => "d002",
						"syoninsya"           => $_SESSION['input']['syoninsya'],
						"syonin_date"         => $_SESSION['input']['syonin_date']
						      );
				$this->db->dbUpdate("\"rireki\"", $fields_values, $where_rireki);

				$where_list = "licence_pkey = ".$detail_shinsei[$i]['licence_pkey']." and newkbn = 1";
				$this->db->dbDelete("\"licence\"", $where_list);
			}

			$action = "却下";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$_SESSION['input']['syoninsya']);
			$mail_tpl->assignHtml('syonin_date',$_SESSION['input']['syonin_date']);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス台帳");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ライセンス台帳　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->error_count++;
		}
	}
	
	function del004($pkey){

		$where = "licencehistory_pkey = ".$pkey;
		if(count($detail) > 0){
			$this->tpl->assignHtml('name',$detail['soft_name']);
			$where = "history_pkey = ".$pkey." and history_type = 'd004'";
			/** 取下 */
			$fields_values = array(
					"syonin_kbn"          => "d002",
					"syoninsya"           => $_SESSION['input']['syoninsya'],
					"syonin_date"         => $_SESSION['input']['syonin_date']
					      );
			$this->db->dbUpdate("\"rireki\"", $fields_values, $where);

			$where_list = "licencelist_pkey = ".$detail['licencelist_pkey']." and newkbn = 1";
			$list = $this->db->dbSelect("select * from licencelist_detail where ".$where_list, "list");
			if(count($list) > 0){
				$this->db->dbDelete("\"licencelist\"", $where_list);
				$this->db->dbDelete("\"licencelistprogram\"", "licencelist_pkey = ".$detail['licencelist_pkey']);
			}

			$action = "却下";
			$mail_tpl = new Template;
			$email = new Sendmail;
	
			$mail_tpl->assignHtml('syoninsya',$_SESSION['input']['syoninsya']);
			$mail_tpl->assignHtml('syonin_date',$_SESSION['input']['syonin_date']);
			$mail_tpl->assignHtml('sinsei_date',$detail['sinsei_date']);
			$mail_tpl->assignHtml('daicho',"ライセンス一覧表");
			$mail_tpl->assignHtml('action',$action);

			$body = $mail_tpl->fetchHtml('mail/syonin.html');
			$subject = "【情報資産管理システム】ライセンス一覧表　".$action;

			$email->email($detail['email_ad'], _ADMIN_EMAIL, $subject, $body);
		}else{
			$this->error_count++;
		}
	}
	
	function check001($pkey){
		$detail = $this->db->dbSelect("select * from hard_rireki_detail where hardhistory_pkey=".$pkey, "detail");
		#バージョンチェック
		$detail_old = $this->db->dbSelect("SELECT * FROM hard_detail where hard_pkey = ".$detail['hard_pkey'], "detail");
		if($detail['version'] != $detail_old['version'] and _ERROR_0103){
			return false;
		}
		$where = " where newkbn <> 1 and hard_pkey != ".$detail['hard_pkey']." and hard_kanrino = '".addslashes($detail['hard_kanrino'])."' and (haiki_date > current_date or haiki_date is null)";
		/** 詳細ﾃﾞｰﾀ */
		$list = $this->db->dbSelect("select * from hard_detail".$where, "list");
		if(count($list) > 0 and _ERROR_0210){
			return false;
		}
		if (strtotime(@$_SESSION['input']['syonin_date']) < strtotime($detail['sinsei_date']) and _ERROR_0104) {
			return false;
		}
		return true;
	}
	
	function check002($pkey){
		$detail = $this->db->dbSelect("select * from soft_rireki_detail where softhistory_pkey=".$pkey, "detail");
		#バージョンチェック
		$soft_list = $this->db->dbSelect("select * from soft_rireki_detail where shinsei_no=".$detail['shinsei_no'], "list");
		if(count($soft_list) > 0){
			$error_0103 = false;
			for($i=0; $i<count($soft_list); $i++){
				$detail_old = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".$soft_list[$i]['soft_pkey'], "detail");
				if($soft_list[$i]['version'] != $detail_old['version']){
					$error_0103 = true;
				}
			}
			if($error_0103 and _ERROR_0103){
				return false;
			}
			for($i=0; $i<count($soft_list); $i++){
				$error_check = true;
				if (ereg ("^([12][0-9]{3})-([0-9]{2})-([0-9]{2})$", @$soft_list[$i]['haiki_date'])) {
					$haiki = explode("-",@$soft_list[$i]['haiki_date']);
					if(strtotime(date('Y/m/d',mktime(0,0,0,$haiki[1],$haiki[2],$haiki[0]))) <= strtotime(date('Y/m/d'))){
						$error_check = false;
					}
				}
				if($error_check){
					$pkey = @$soft_list[$i]['licence_pkey'];
					$where = " where licence_pkey = ".$pkey;
					$licence_detail = $this->db->dbSelect("select * from licence_detail".$where, "detail");

					if(strtotime($licence_detail['haiki_date']) <= strtotime(date("Y/m/d")) and $licence_detail['haiki_date'] != null and _ERROR_0233){
						return false;
					}
					$detail_old = $this->db->dbSelect("SELECT * FROM soft_detail where soft_pkey = ".$soft_list[$i]['soft_pkey'], "detail");
					if(@$detail_old['newkbn'] == 1){
						$where_install_licence = " where licence_pkey = ".$pkey." and soft_pkey != ".$soft_list[$i]['soft_pkey']." and newkbn <> 1 and (haiki_date > '".date("Y/m/d")."' or haiki_date is null)";
						$install_licence =  $this->db->dbSelect("select * from soft_detail".$where_install_licence, "list");
						$install_qty = count($install_licence);
						$qty = $licence_detail['install_su'] - $install_qty;
						if($qty <= 0 and _ERROR_0238){
							return false;
						}
					}
				}
			}
		}
		
		if (strtotime(@$_SESSION['input']['syonin_date']) < strtotime($detail['sinsei_date']) and _ERROR_0104) {
			return false;
		}
		return true;
	}
	
	function check003($pkey){
		$detail = $this->db->dbSelect("select * from licence_rireki_detail where licencehistory_pkey=".$pkey, "detail");
		#バージョンチェック
		$licence_list = $this->db->dbSelect("select * from licence_rireki_detail where shinsei_no=".$detail['shinsei_no'], "list");
		if(count($licence_list) > 0){
			$error_0103 = false;
			for($i=0; $i<count($licence_list); $i++){
				$detail_old = $this->db->dbSelect("SELECT * FROM licence_detail where licence_pkey = ".$licence_list[$i]['licence_pkey']." and newkbn <> 1", "detail");
				if($licence_list[$i]['version'] != $detail_old['version'] and @$detail_old[licence_pkey] != ""){
					$error_0103 = true;
				}
			}
			if($error_0103 and _ERROR_0103){
				return false;
			}
		}
		
		if (strtotime(@$_SESSION['input']['syonin_date']) < strtotime($detail['sinsei_date']) and _ERROR_0104) {
			return false;
		}
		return true;
	}
	
	function check004($pkey){
		#バージョンチェック
		$detail = $this->db->dbSelect("select * from licencelist_rireki_detail where licencehistory_pkey=".$pkey, "detail");
		if($detail['licencelist_pkey'] != ""){
			$detail_old = $this->db->dbSelect("SELECT * FROM licencelist_detail where licencelist_pkey = ".$detail['licencelist_pkey'], "detail");
			if($detail['version'] != $detail_old['version'] and _ERROR_0103){
				return false;
			}
		}
		if (strtotime(@$_SESSION['input']['syonin_date']) < strtotime($detail['sinsei_date']) and _ERROR_0104) {
			return false;
		}
		return true;
	}
	
	/**
	 * 入力ﾁｪｯｸ
	 * @param string ﾒｿｯﾄﾞ名
	 */
	function check_app(){
		#入力チェック
		$cci = new CheckItem;

		if(@$_SESSION['input']['syoninsya'] == "" and _ERROR_0101){
			$cci->checkErrorCode("0101");
		}
		if(@$_SESSION['input']['syonin_date'] == "" and _ERROR_0102){
			$cci->checkErrorCode("0102");
		}

		$error_name_array = select_code("00015");
		$cci->checkItemDateTime(array("syonin_date"=>$error_name_array['007']));
		
		if($cci->error_flag == true){
			/** ｾｯｼｮﾝ登録 */
			$_SESSION['input']['error_flag']  = true;
			$_SESSION['input']['error_msg']   = $cci->error_msg;
		}
	}
	
}

?>