--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

--
-- Name: pgstattuple_type; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE pgstattuple_type AS (
	table_len bigint,
	tuple_count bigint,
	tuple_len bigint,
	tuple_percent double precision,
	dead_tuple_count bigint,
	dead_tuple_len bigint,
	dead_tuple_percent double precision,
	free_space bigint,
	free_percent double precision
);


ALTER TYPE public.pgstattuple_type OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: bat_log; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE bat_log (
    bat_pkey serial NOT NULL,
    title character varying(255) NOT NULL,
    end_date timestamp with time zone
);


ALTER TABLE public.bat_log OWNER TO shisanadmin;

--
-- Name: TABLE bat_log; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE bat_log IS '夜間バッチ終了ログ';


--
-- Name: code; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE code (
    code_bunrui character varying(5) NOT NULL,
    code character varying(6) NOT NULL,
    code_name character varying(100) NOT NULL,
    code_sort smallint NOT NULL
);


ALTER TABLE public.code OWNER TO shisanadmin;

--
-- Name: TABLE code; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE code IS 'コード';


--
-- Name: codebunrui; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE codebunrui (
    code_bunrui character varying(5) NOT NULL,
    code_bunruimei character varying(100) NOT NULL
);


ALTER TABLE public.codebunrui OWNER TO shisanadmin;

--
-- Name: TABLE codebunrui; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE codebunrui IS 'コード分類';


--
-- Name: control; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE control (
    control_id character varying(20) NOT NULL,
    control_name character varying(50),
    settei character varying(20) NOT NULL
);


ALTER TABLE public.control OWNER TO shisanadmin;

--
-- Name: TABLE control; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE control IS 'コントロール';


--
-- Name: errmsg; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE errmsg (
    err_pkey character varying(4) NOT NULL,
    err_msg text
);


ALTER TABLE public.errmsg OWNER TO shisanadmin;

--
-- Name: TABLE errmsg; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE errmsg IS 'エラーメッセージ';


--
-- Name: hard; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE hard (
    hard_pkey serial NOT NULL,
    sosiki_pkey integer,
    hard_kanrino character varying(255),
    soft_installdel character varying(6),
    use_name character varying(80),
    tyoutatu text,
    bikou text,
    tyoutatu_date date,
    haiki_date date,
    version smallint NOT NULL,
    newkbn smallint,
    price integer,
    "location" character varying(255),
    memo text
);


ALTER TABLE public.hard OWNER TO shisanadmin;

--
-- Name: TABLE hard; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE hard IS 'ハードウェア台帳';


--
-- Name: inventory; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE inventory (
    inventory_pkey serial NOT NULL,
    collectsource character varying(100),
    idkey character varying(255),
    invtraprecvdate timestamp with time zone,
    hardwareno character varying(255),
    group1 character varying(255),
    jyotai character varying(6),
    hikaku character varying(6),
    hsyubetu character varying(6),
    macaddress character varying(12),
    ipaddress character varying(15),
    subnetmask character varying(15),
    defaultgateway character varying(15),
    dnsserver character varying(255),
    secondarydns character varying(255),
    computername character varying(255),
    domainname character varying(255),
    workgroup character varying(255),
    userid character varying(255),
    hyoujimei character varying(255),
    yakusyoku character varying(255),
    syozoku character varying(255),
    machinevendor character varying(255),
    machinename character varying(255),
    cpuname character varying(255),
    memorysize character varying(255),
    osversion character varying(255),
    windowsservicepack character varying(255),
    ieversion character varying(255),
    virussoftname character varying(100),
    enginever character varying(20),
    patternver character varying(255),
    misiyou1 character varying(255),
    misiyou2 character varying(255),
    misiyou3 character varying(255),
    mukou_date date,
    toolversion character varying(255),
    bikou text,
    memo text
);


ALTER TABLE public.inventory OWNER TO shisanadmin;

--
-- Name: TABLE inventory; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE inventory IS '収集情報';


--
-- Name: soft; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE soft (
    soft_pkey serial NOT NULL,
    hard_pkey integer,
    licence_pkey integer,
    bikou text,
    install_date date,
    uninstall_date date,
    version smallint NOT NULL,
    newkbn smallint,
    memo text,
    downgrade character varying(6)
);


ALTER TABLE public.soft OWNER TO shisanadmin;

--
-- Name: TABLE soft; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE soft IS 'ソフトウェア台帳';


--
-- Name: sosiki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE sosiki (
    sosiki_pkey serial NOT NULL,
    sosiki_onpkey integer,
    sosiki_sortkey integer NOT NULL,
    syozoku_name character varying(80) NOT NULL,
    yukou character varying(6),
    syozoku_fullname character varying(255)
);


ALTER TABLE public.sosiki OWNER TO shisanadmin;

--
-- Name: TABLE sosiki; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE sosiki IS '組織';


--
-- Name: hard_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW hard_detail AS
    SELECT DISTINCT ON (hard.hard_pkey) hard.hard_pkey, inventory.inventory_pkey, hard.sosiki_pkey, sosiki.syozoku_name AS sosiki_name, sosiki.syozoku_fullname AS sosiki_fullname, hard.hard_kanrino, inventory.computername, inventory.ipaddress, hard.use_name, (SELECT count(*) AS count FROM soft WHERE (((hard.hard_pkey = soft.hard_pkey) AND (soft.newkbn = 0)) AND ((soft.uninstall_date > ('now'::text)::date) OR (soft.uninstall_date IS NULL)))) AS soft_qty, hard.soft_installdel, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00022'::text) AND ((code.code)::text = (hard.soft_installdel)::text))) AS soft_installdel_name, inventory.machinevendor, inventory.machinename, hard.price, hard.tyoutatu, hard."location", hard.bikou, hard.tyoutatu_date, hard.haiki_date, hard.memo, hard.version, hard.newkbn, COALESCE(sosiki.sosiki_sortkey, 0) AS sosiki_sortkey FROM ((hard LEFT JOIN inventory ON (((hard.hard_kanrino)::text = (inventory.hardwareno)::text))) LEFT JOIN sosiki ON ((hard.sosiki_pkey = sosiki.sosiki_pkey))) ORDER BY hard.hard_pkey;


ALTER TABLE public.hard_detail OWNER TO shisanadmin;

--
-- Name: hard_kanrino_numbering; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE hard_kanrino_numbering (
    id bigserial NOT NULL,
    create_date timestamp with time zone
);


ALTER TABLE public.hard_kanrino_numbering OWNER TO shisanadmin;

--
-- Name: TABLE hard_kanrino_numbering; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE hard_kanrino_numbering IS 'ハードウェア管理番号採番';


--
-- Name: hardrireki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE hardrireki (
    hardhistory_pkey serial NOT NULL,
    hard_pkey integer,
    sosiki_pkey integer,
    hard_kanrino character varying(255),
    soft_installdel character varying(6),
    use_name character varying(80),
    tyoutatu text,
    bikou text,
    tyoutatu_date date,
    haiki_date date,
    version smallint NOT NULL,
    price integer,
    "location" character varying(255),
    memo text
);


ALTER TABLE public.hardrireki OWNER TO shisanadmin;

--
-- Name: TABLE hardrireki; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE hardrireki IS 'ハードウェア台帳履歴';


--
-- Name: rireki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE rireki (
    history_pkey integer NOT NULL,
    history_type character varying(16) NOT NULL,
    sinsei_date timestamp with time zone,
    sinseisya character varying(80),
    sinseisyozoku integer,
    syonin_kbn character varying(6),
    syonin_date timestamp with time zone,
    syoninsya character varying(80),
    email_ad text,
    shinsei_no integer
);


ALTER TABLE public.rireki OWNER TO shisanadmin;

--
-- Name: TABLE rireki; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE rireki IS '履歴マスタ';


--
-- Name: hard_rireki_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW hard_rireki_detail AS
    SELECT hardrireki.hardhistory_pkey, hardrireki.hard_pkey, hardrireki.sosiki_pkey, sosiki.syozoku_name AS sosiki_name, hardrireki.hard_kanrino, hardrireki.use_name, hardrireki.soft_installdel, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00022'::text) AND ((code.code)::text = (hardrireki.soft_installdel)::text))) AS soft_installdel_name, hardrireki.price, hardrireki.tyoutatu, hardrireki."location", hardrireki.bikou, hardrireki.tyoutatu_date, hardrireki.haiki_date, hardrireki.memo, hardrireki.version, rireki.sinseisyozoku, rireki.sinsei_date, rireki.sinseisya, rireki.syonin_kbn, rireki.syoninsya, rireki.syonin_date, rireki.email_ad FROM ((hardrireki LEFT JOIN rireki ON (((hardrireki.hardhistory_pkey = rireki.history_pkey) AND ((rireki.history_type)::text = 'd001'::text)))) LEFT JOIN sosiki ON ((hardrireki.sosiki_pkey = sosiki.sosiki_pkey)));


ALTER TABLE public.hard_rireki_detail OWNER TO shisanadmin;

--
-- Name: hold_licence_qry_rireki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE hold_licence_qry_rireki (
    licencehistory_pkey integer NOT NULL,
    hold_qty integer NOT NULL
);


ALTER TABLE public.hold_licence_qry_rireki OWNER TO shisanadmin;

--
-- Name: TABLE hold_licence_qry_rireki; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE hold_licence_qry_rireki IS 'ライセンス保有数履歴';


--
-- Name: hold_licence_qty; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE hold_licence_qty (
    licence_kanrino character varying(255) NOT NULL,
    hold_qty integer NOT NULL
);


ALTER TABLE public.hold_licence_qty OWNER TO shisanadmin;

--
-- Name: TABLE hold_licence_qty; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE hold_licence_qty IS 'ライセンス保有数';


--
-- Name: import_moniter; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE import_moniter (
    import_pkey serial NOT NULL,
    user_id character varying(20),
    import_qty bigint,
    start_date timestamp with time zone
);


ALTER TABLE public.import_moniter OWNER TO shisanadmin;

--
-- Name: inventorysoft; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE inventorysoft (
    hardwareno character varying(255) NOT NULL,
    insapname character varying(255),
    insapno bigserial NOT NULL
);


ALTER TABLE public.inventorysoft OWNER TO shisanadmin;

--
-- Name: TABLE inventorysoft; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE inventorysoft IS '収集情報ソフトウェア';


--
-- Name: inventory_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW inventory_detail AS
    SELECT inventory.inventory_pkey, inventory.collectsource, inventory.idkey, inventory.invtraprecvdate, inventory.hardwareno, inventory.group1, inventory.jyotai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00002'::text) AND ((code.code)::text = (inventory.jyotai)::text))) AS jyotai_name, inventory.hikaku, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00007'::text) AND ((code.code)::text = (inventory.hikaku)::text))) AS hikaku_name, inventory.hsyubetu, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00001'::text) AND ((code.code)::text = (inventory.hsyubetu)::text))) AS hsyubetu_name, inventory.macaddress, inventory.ipaddress, inventory.subnetmask, inventory.defaultgateway, inventory.dnsserver, inventory.secondarydns, inventory.computername, inventory.domainname, inventory.workgroup, inventory.userid, inventory.hyoujimei, inventory.yakusyoku, inventory.syozoku, inventory.machinevendor, inventory.machinename, inventory.cpuname, inventory.memorysize, inventory.osversion, inventory.windowsservicepack, inventory.ieversion, inventory.virussoftname, inventory.enginever, inventory.patternver, inventory.misiyou1, inventory.misiyou2, inventory.misiyou3, inventory.mukou_date, array_to_string(ARRAY(SELECT s.insapname FROM inventorysoft s WHERE (((s.hardwareno)::text = (inventory.hardwareno)::text) AND (s.insapname IS NOT NULL)) ORDER BY lower((s.insapname)::text)), E'\015\012'::text) AS program_add_del, inventory.bikou, inventory.memo, inventory.toolversion FROM inventory;


ALTER TABLE public.inventory_detail OWNER TO shisanadmin;

--
-- Name: inventorydate; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE inventorydate (
    invbunrui integer NOT NULL,
    invbunruimei character varying(100),
    invstart timestamp with time zone,
    invend timestamp with time zone
);


ALTER TABLE public.inventorydate OWNER TO shisanadmin;

--
-- Name: TABLE inventorydate; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE inventorydate IS '収集情報更新日時';


--
-- Name: inventorysoft_ext; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE inventorysoft_ext (
    insapno bigint NOT NULL,
    inv_soft_reg boolean,
    inv_soft_exempt boolean
);


ALTER TABLE public.inventorysoft_ext OWNER TO shisanadmin;

--
-- Name: inventorysoft_csv; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW inventorysoft_csv AS
    SELECT inventory.inventory_pkey, inventory.group1, inventory.jyotai, inventory.hikaku, inventory.invtraprecvdate, inventory.hardwareno, inventorysoft.insapname, inventorysoft_ext.inv_soft_reg, inventorysoft_ext.inv_soft_exempt, inventory.collectsource, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00002'::text) AND ((code.code)::text = (inventory.jyotai)::text))) AS jyotai_name, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00007'::text) AND ((code.code)::text = (inventory.hikaku)::text))) AS hikaku_name, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00001'::text) AND ((code.code)::text = (inventory.hsyubetu)::text))) AS hsyubetu_name, inventory.ipaddress, inventory.computername, inventory.userid, inventory.hyoujimei, inventory.machinevendor, inventory.machinename, inventory.macaddress, inventory.osversion, array_to_string(ARRAY(SELECT s.insapname FROM inventorysoft s WHERE ((s.hardwareno)::text = (inventory.hardwareno)::text) ORDER BY lower((s.insapname)::text)), E'\015\012'::text) AS program_add_del, inventory.bikou, inventory.memo FROM ((inventorysoft LEFT JOIN inventory ON (((inventorysoft.hardwareno)::text = (inventory.hardwareno)::text))) LEFT JOIN inventorysoft_ext ON ((inventorysoft.insapno = inventorysoft_ext.insapno)));


ALTER TABLE public.inventorysoft_csv OWNER TO shisanadmin;

--
-- Name: inventorysoft_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW inventorysoft_detail AS
    SELECT inventory.inventory_pkey, inventory.collectsource, inventory.invtraprecvdate, inventory.hardwareno, inventory.group1, inventory.jyotai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00002'::text) AND ((code.code)::text = (inventory.jyotai)::text))) AS jyotai_name, inventory.hikaku, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00007'::text) AND ((code.code)::text = (inventory.hikaku)::text))) AS hikaku_name, inventory.hsyubetu, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00001'::text) AND ((code.code)::text = (inventory.hsyubetu)::text))) AS hsyubetu_name, inventory.ipaddress, inventory.computername, inventory.userid, inventory.hyoujimei, inventory.machinevendor, inventory.machinename, inventory.macaddress, inventory.osversion, array_to_string(ARRAY(SELECT s.insapname FROM inventorysoft s WHERE ((s.hardwareno)::text = (inventory.hardwareno)::text) ORDER BY lower((s.insapname)::text)), E'\015\012'::text) AS program_add_del, inventory.bikou, inventory.memo, inventorysoft.hardwareno AS s_hardwareno, inventorysoft.insapname FROM (inventory LEFT JOIN inventorysoft ON (((inventory.hardwareno)::text = (inventorysoft.hardwareno)::text)));


ALTER TABLE public.inventorysoft_detail OWNER TO shisanadmin;

--
-- Name: licence; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licence (
    licence_pkey serial NOT NULL,
    sosiki_pkey integer,
    licencelist_pkey integer,
    licence_kanrino character varying(255),
    install_su integer,
    hard_pkey integer,
    licence_pkey2 text,
    licence_no text,
    tyoutatu text,
    hokan_baitai text,
    hokan_basyo text,
    bikou text,
    tyoutatu_date date,
    haiki_date date,
    version smallint NOT NULL,
    newkbn smallint,
    kanri_sosiki_pkey integer,
    price character varying(100),
    use_limit_date date,
    memo text
);


ALTER TABLE public.licence OWNER TO shisanadmin;

--
-- Name: TABLE licence; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE licence IS 'ライセンス台帳

';


--
-- Name: licencelist; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licencelist (
    licencelist_pkey serial NOT NULL,
    soft_name character varying(255),
    licence_keitai character varying(6),
    brand character varying(50),
    hard_kotei character varying(6),
    upgrade character varying(6),
    useproposal_kakunin character varying(6),
    tokusitu_useproposal text,
    useproposal_youken text,
    bikou text,
    upd_date date,
    upd_name character varying(80),
    yukou character varying(6),
    version smallint NOT NULL,
    upd_syozoku integer,
    newkbn smallint,
    edition character varying(100),
    disabled character varying(6),
    memo text
);


ALTER TABLE public.licencelist OWNER TO shisanadmin;

--
-- Name: TABLE licencelist; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE licencelist IS 'ライセンス一覧表';


--
-- Name: licencelistprogram; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licencelistprogram (
    licencelist_pkey integer NOT NULL,
    program_add_del character varying(255) NOT NULL
);


ALTER TABLE public.licencelistprogram OWNER TO shisanadmin;

--
-- Name: TABLE licencelistprogram; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE licencelistprogram IS 'ライセンス一覧プログラム表示';


--
-- Name: licencelistprogram_down; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licencelistprogram_down (
    licencelist_pkey integer NOT NULL,
    program_add_del character varying(255) NOT NULL
);


ALTER TABLE public.licencelistprogram_down OWNER TO shisanadmin;

--
-- Name: licence_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW licence_detail AS
    SELECT licence.licence_pkey, licence.kanri_sosiki_pkey, kanri.syozoku_name AS kanri_sosiki_name, kanri.syozoku_fullname AS kanri_sosiki_fullname, COALESCE(kanri.sosiki_sortkey, 0) AS kanri_sosiki_sortkey, licence.sosiki_pkey, sosiki.syozoku_name AS sosiki_name, sosiki.syozoku_fullname AS sosiki_fullname, COALESCE(sosiki.sosiki_sortkey, 0) AS sosiki_sortkey, licence.licence_kanrino, licence.licencelist_pkey, licencelist.soft_name, licencelist.edition, licencelist.disabled, licencelist.licence_keitai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00005'::text) AND ((code.code)::text = (licencelist.licence_keitai)::text))) AS licence_keitai_name, licencelist.hard_kotei, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelist.hard_kotei)::text))) AS hard_kotei_name, licence.hard_pkey, hard.hard_kanrino, licencelist.upgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelist.upgrade)::text))) AS upgrade_name, licence.licence_pkey2, array_to_string(ARRAY(SELECT l2.licence_kanrino FROM licence l2 WHERE ((l2.licence_pkey)::text = ANY (string_to_array(licence.licence_pkey2, ','::text))) ORDER BY l2.licence_pkey), ','::text) AS up_licence_kanrino, licencelist.brand, "hold".hold_qty, licence.install_su, (SELECT count(*) AS count FROM soft WHERE (((licence.licence_pkey = soft.licence_pkey) AND (soft.uninstall_date IS NULL)) AND (soft.newkbn = 0))) AS install_qty, licence.licence_no, licence.price, licence.tyoutatu, licencelist.tokusitu_useproposal, licencelist.useproposal_youken, licence.hokan_baitai, licence.hokan_basyo, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram p WHERE (p.licencelist_pkey = licence.licencelist_pkey) ORDER BY p.program_add_del), E'\015\012'::text) AS program_add_del, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram_down p WHERE (p.licencelist_pkey = licence.licencelist_pkey) ORDER BY p.program_add_del), E'\015\012'::text) AS program_add_del_down, licence.bikou, licence.tyoutatu_date, licence.use_limit_date, licence.haiki_date, licence.memo, licence.version, licence.newkbn FROM (((((licence LEFT JOIN licencelist ON ((licence.licencelist_pkey = licencelist.licencelist_pkey))) LEFT JOIN sosiki ON ((licence.sosiki_pkey = sosiki.sosiki_pkey))) LEFT JOIN sosiki kanri ON ((licence.kanri_sosiki_pkey = kanri.sosiki_pkey))) LEFT JOIN hard ON ((licence.hard_pkey = hard.hard_pkey))) LEFT JOIN hold_licence_qty "hold" ON (((licence.licence_kanrino)::text = ("hold".licence_kanrino)::text)));


ALTER TABLE public.licence_detail OWNER TO shisanadmin;

--
-- Name: licence_kanrino_numbering; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licence_kanrino_numbering (
    id bigserial NOT NULL,
    create_date timestamp with time zone
);


ALTER TABLE public.licence_kanrino_numbering OWNER TO shisanadmin;

--
-- Name: TABLE licence_kanrino_numbering; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE licence_kanrino_numbering IS 'ライセンス管理番号採番';


--
-- Name: licencerireki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licencerireki (
    licencehistory_pkey serial NOT NULL,
    licence_pkey integer,
    sosiki_pkey integer,
    licencelist_pkey integer,
    licence_kanrino character varying(255),
    install_su integer,
    hard_pkey integer,
    licence_pkey2 text,
    licence_no text,
    tyoutatu text,
    hokan_baitai text,
    hokan_basyo text,
    bikou text,
    tyoutatu_date date,
    haiki_date date,
    version smallint NOT NULL,
    kanri_sosiki_pkey integer,
    price character varying(100),
    use_limit_date date,
    memo text
);


ALTER TABLE public.licencerireki OWNER TO shisanadmin;

--
-- Name: TABLE licencerireki; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE licencerireki IS 'ライセンス台帳履歴';


--
-- Name: licence_rireki_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW licence_rireki_detail AS
    SELECT licencerireki.licencehistory_pkey, licencerireki.licence_pkey, licencerireki.kanri_sosiki_pkey, kanri.syozoku_name AS kanri_sosiki_name, licencerireki.sosiki_pkey, sosiki.syozoku_name AS sosiki_name, sosiki.sosiki_sortkey, licencerireki.licence_kanrino, licencerireki.licencelist_pkey, licencelist.soft_name, licencelist.edition, licencelist.licence_keitai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00005'::text) AND ((code.code)::text = (licencelist.licence_keitai)::text))) AS licence_keitai_name, licencelist.hard_kotei, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelist.hard_kotei)::text))) AS hard_kotei_name, licencerireki.hard_pkey, hard.hard_kanrino, licencelist.upgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelist.upgrade)::text))) AS upgrade_name, licencerireki.licence_pkey2, array_to_string(ARRAY(SELECT l2.licence_kanrino FROM licence l2 WHERE ((l2.licence_pkey)::text = ANY (string_to_array(licencerireki.licence_pkey2, ','::text))) ORDER BY l2.licence_pkey), ','::text) AS up_licence_kanrino, licencelist.brand, "hold".hold_qty, licencerireki.install_su, licencerireki.licence_no, licencerireki.price, licencerireki.tyoutatu, licencelist.tokusitu_useproposal, licencelist.useproposal_youken, licencerireki.hokan_baitai, licencerireki.hokan_basyo, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram p WHERE (p.licencelist_pkey = licencerireki.licencelist_pkey) ORDER BY p.program_add_del), E'\015\012'::text) AS program_add_del, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram_down p WHERE (p.licencelist_pkey = licencerireki.licencelist_pkey) ORDER BY p.program_add_del), E'\015\012'::text) AS program_add_del_down, licencerireki.bikou, licencerireki.tyoutatu_date, licencerireki.use_limit_date, licencerireki.haiki_date, licencerireki.memo, licencerireki.version, rireki.sinseisyozoku, rireki.sinsei_date, rireki.sinseisya, rireki.syonin_kbn, rireki.syonin_date, rireki.syoninsya, rireki.email_ad, rireki.shinsei_no FROM ((((((licencerireki LEFT JOIN rireki ON (((licencerireki.licencehistory_pkey = rireki.history_pkey) AND ((rireki.history_type)::text = 'd003'::text)))) LEFT JOIN licencelist ON ((licencerireki.licencelist_pkey = licencelist.licencelist_pkey))) LEFT JOIN sosiki ON ((licencerireki.sosiki_pkey = sosiki.sosiki_pkey))) LEFT JOIN sosiki kanri ON ((licencerireki.kanri_sosiki_pkey = kanri.sosiki_pkey))) LEFT JOIN hard ON ((licencerireki.hard_pkey = hard.hard_pkey))) LEFT JOIN hold_licence_qry_rireki "hold" ON ((licencerireki.licencehistory_pkey = "hold".licencehistory_pkey)));


ALTER TABLE public.licence_rireki_detail OWNER TO shisanadmin;

--
-- Name: licencelist_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW licencelist_detail AS
    SELECT l.licencelist_pkey, l.soft_name, l.edition, l.licence_keitai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00005'::text) AND ((code.code)::text = (l.licence_keitai)::text))) AS licence_keitai_name, l.hard_kotei, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (l.hard_kotei)::text))) AS hard_kotei_name, l.upgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (l.upgrade)::text))) AS upgrade_name, l.brand, l.disabled, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (l.disabled)::text))) AS disabled_name, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram p WHERE (p.licencelist_pkey = l.licencelist_pkey) ORDER BY p.program_add_del), E'\015\012'::text) AS program_add_del, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram_down p WHERE (p.licencelist_pkey = l.licencelist_pkey) ORDER BY p.program_add_del), E'\015\012'::text) AS program_add_del_down, (SELECT count(*) AS count FROM licence li WHERE (((li.licencelist_pkey = l.licencelist_pkey) AND ((li.haiki_date > ('now'::text)::date) OR (li.haiki_date IS NULL))) AND (li.newkbn = 0))) AS licence_qty, (SELECT count(*) AS count FROM (soft s LEFT JOIN licence li ON ((((s.licence_pkey = li.licence_pkey) AND ((s.uninstall_date > ('now'::text)::date) OR (s.uninstall_date IS NULL))) AND (s.newkbn = 0)))) WHERE ((((li.haiki_date > ('now'::text)::date) OR (li.haiki_date IS NULL)) AND (li.newkbn = 0)) AND (li.licencelist_pkey = l.licencelist_pkey))) AS soft_qty, l.tokusitu_useproposal, l.useproposal_youken, l.bikou, l.upd_syozoku, l.upd_name, l.upd_date, l.useproposal_kakunin, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00006'::text) AND ((code.code)::text = (l.useproposal_kakunin)::text))) AS useproposal_kakunin_name, l.yukou, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00007'::text) AND ((code.code)::text = (l.yukou)::text))) AS yukou_name, l.memo, l.version, l.newkbn, COALESCE(sosiki.sosiki_sortkey, 0) AS sosiki_sortkey, sosiki.syozoku_name AS sosiki_name, sosiki.syozoku_fullname AS sosiki_fullname FROM (licencelist l LEFT JOIN sosiki ON ((l.upd_syozoku = sosiki.sosiki_pkey)));


ALTER TABLE public.licencelist_detail OWNER TO shisanadmin;

--
-- Name: licencelist_program_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW licencelist_program_detail AS
    SELECT llp.licencelist_pkey, llp.program_add_del AS program_name, l.soft_name, l.licence_keitai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00005'::text) AND ((code.code)::text = (l.licence_keitai)::text))) AS licence_keitai_name, l.brand, l.hard_kotei, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (l.hard_kotei)::text))) AS hard_kotei_name, l.upgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (l.upgrade)::text))) AS upgrade_name, l.useproposal_kakunin, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00006'::text) AND ((code.code)::text = (l.useproposal_kakunin)::text))) AS useproposal_kakunin_name, l.tokusitu_useproposal, l.useproposal_youken, l.bikou, l.upd_date, l.upd_syozoku, l.upd_name, l.yukou, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00007'::text) AND ((code.code)::text = (l.yukou)::text))) AS yukou_name, l.version, l.newkbn, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram p WHERE (p.licencelist_pkey = l.licencelist_pkey)), E'\015\012'::text) AS program_add_del, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram_down p WHERE (p.licencelist_pkey = l.licencelist_pkey)), E'\015\012'::text) AS program_add_del_down, COALESCE(sosiki.sosiki_sortkey, 0) AS sosiki_sortkey, sosiki.syozoku_name AS sosiki_name FROM ((licencelistprogram llp LEFT JOIN licencelist l ON ((llp.licencelist_pkey = l.licencelist_pkey))) LEFT JOIN sosiki ON ((l.upd_syozoku = sosiki.sosiki_pkey)));


ALTER TABLE public.licencelist_program_detail OWNER TO shisanadmin;

--
-- Name: licencelist_program_down_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW licencelist_program_down_detail AS
    SELECT llp.licencelist_pkey, llp.program_add_del AS program_name, l.soft_name, l.licence_keitai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00005'::text) AND ((code.code)::text = (l.licence_keitai)::text))) AS licence_keitai_name, l.brand, l.hard_kotei, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (l.hard_kotei)::text))) AS hard_kotei_name, l.upgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (l.upgrade)::text))) AS upgrade_name, l.useproposal_kakunin, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00006'::text) AND ((code.code)::text = (l.useproposal_kakunin)::text))) AS useproposal_kakunin_name, l.tokusitu_useproposal, l.useproposal_youken, l.bikou, l.upd_date, l.upd_syozoku, l.upd_name, l.yukou, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00007'::text) AND ((code.code)::text = (l.yukou)::text))) AS yukou_name, l.version, l.newkbn, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram p WHERE (p.licencelist_pkey = l.licencelist_pkey)), E'\015\012'::text) AS program_add_del, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram_down p WHERE (p.licencelist_pkey = l.licencelist_pkey)), E'\015\012'::text) AS program_add_del_down, COALESCE(sosiki.sosiki_sortkey, 0) AS sosiki_sortkey, sosiki.syozoku_name AS sosiki_name FROM ((licencelistprogram_down llp LEFT JOIN licencelist l ON ((llp.licencelist_pkey = l.licencelist_pkey))) LEFT JOIN sosiki ON ((l.upd_syozoku = sosiki.sosiki_pkey)));


ALTER TABLE public.licencelist_program_down_detail OWNER TO shisanadmin;

--
-- Name: licencelistprogram_down_rireki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licencelistprogram_down_rireki (
    licencehistory_pkey integer NOT NULL,
    program_add_del character varying(255) NOT NULL
);


ALTER TABLE public.licencelistprogram_down_rireki OWNER TO shisanadmin;

--
-- Name: licencelistprogramrireki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licencelistprogramrireki (
    licencehistory_pkey integer NOT NULL,
    program_add_del character varying(255) NOT NULL
);


ALTER TABLE public.licencelistprogramrireki OWNER TO shisanadmin;

--
-- Name: TABLE licencelistprogramrireki; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE licencelistprogramrireki IS 'ライセンス一覧プログラム表示履歴';


--
-- Name: licencelistrireki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE licencelistrireki (
    licencehistory_pkey serial NOT NULL,
    licencelist_pkey integer,
    soft_name character varying(255),
    licence_keitai character varying(6),
    brand character varying(50),
    hard_kotei character varying(6),
    upgrade character varying(6),
    useproposal_kakunin character varying(6),
    tokusitu_useproposal text,
    useproposal_youken text,
    bikou text,
    upd_date date,
    upd_syozoku character varying(6),
    upd_name character varying(80),
    yukou character varying(6),
    version smallint,
    edition character varying(100),
    disabled character varying(6),
    memo text
);


ALTER TABLE public.licencelistrireki OWNER TO shisanadmin;

--
-- Name: TABLE licencelistrireki; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE licencelistrireki IS 'ライセンス一覧表履歴';


--
-- Name: licencelist_rireki_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW licencelist_rireki_detail AS
    SELECT licencelistrireki.licencehistory_pkey, licencelistrireki.licencelist_pkey, licencelistrireki.soft_name, licencelistrireki.edition, licencelistrireki.licence_keitai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00005'::text) AND ((code.code)::text = (licencelistrireki.licence_keitai)::text))) AS licence_keitai_name, licencelistrireki.hard_kotei, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelistrireki.hard_kotei)::text))) AS hard_kotei_name, licencelistrireki.upgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelistrireki.upgrade)::text))) AS upgrade_name, licencelistrireki.brand, licencelistrireki.disabled, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelistrireki.disabled)::text))) AS disabled_name, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogramrireki p WHERE (p.licencehistory_pkey = licencelistrireki.licencehistory_pkey) ORDER BY p.program_add_del), E'\015\012'::text) AS program_add_del, array_to_string(ARRAY(SELECT regexp_replace((p.program_add_del)::text, E'\015'::text, '(RETURN)'::text) AS regexp_replace FROM licencelistprogram_down_rireki p WHERE (p.licencehistory_pkey = licencelistrireki.licencehistory_pkey) ORDER BY p.program_add_del), E'\015\012'::text) AS program_add_del_down, licencelistrireki.tokusitu_useproposal, licencelistrireki.useproposal_youken, licencelistrireki.bikou, licencelistrireki.upd_syozoku, licencelistrireki.upd_name, licencelistrireki.upd_date, licencelistrireki.useproposal_kakunin, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00006'::text) AND ((code.code)::text = (licencelistrireki.useproposal_kakunin)::text))) AS useproposal_kakunin_name, licencelistrireki.yukou, licencelistrireki.memo, licencelistrireki.version, rireki.sinseisyozoku, rireki.sinsei_date, rireki.sinseisya, rireki.syonin_kbn, rireki.syonin_date, rireki.syoninsya, COALESCE(sosiki.sosiki_sortkey, 0) AS sosiki_sortkey, sosiki.syozoku_name AS sosiki_name, rireki.email_ad FROM ((licencelistrireki LEFT JOIN rireki ON (((licencelistrireki.licencehistory_pkey = rireki.history_pkey) AND ((rireki.history_type)::text = 'd004'::text)))) LEFT JOIN sosiki ON (((licencelistrireki.upd_syozoku)::text = (sosiki.sosiki_pkey)::text)));


ALTER TABLE public.licencelist_rireki_detail OWNER TO shisanadmin;

--
-- Name: login_key; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE login_key (
    user_id character varying(20) NOT NULL,
    "key" character varying(50) NOT NULL,
    expire timestamp with time zone NOT NULL
);


ALTER TABLE public.login_key OWNER TO shisanadmin;

--
-- Name: TABLE login_key; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE login_key IS '認証キー';


--
-- Name: message; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE message (
    msg_pkey bigserial NOT NULL,
    value text NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    start_time time with time zone,
    end_time time with time zone,
    sort integer
);


ALTER TABLE public.message OWNER TO shisanadmin;

--
-- Name: TABLE message; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE message IS 'メッセージ';


--
-- Name: mt_auth; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE mt_auth (
    authority_id character varying(20) NOT NULL,
    authority_name character varying(50) NOT NULL
);


ALTER TABLE public.mt_auth OWNER TO shisanadmin;

--
-- Name: TABLE mt_auth; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE mt_auth IS '権限テーブル';


--
-- Name: mt_menu; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE mt_menu (
    menu_code serial NOT NULL,
    menu_name character varying(20) NOT NULL,
    menu_url character varying(50) NOT NULL,
    menu_action text,
    menu_hierarchy smallint NOT NULL,
    menu_sort integer NOT NULL
);


ALTER TABLE public.mt_menu OWNER TO shisanadmin;

--
-- Name: TABLE mt_menu; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE mt_menu IS 'メニュー';


--
-- Name: program; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE program (
    program_add_del character varying(255) NOT NULL
);


ALTER TABLE public.program OWNER TO shisanadmin;

--
-- Name: TABLE program; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE program IS 'プログラムの追加と削除での表示

';


--
-- Name: rireki_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW rireki_detail AS
    SELECT rireki.history_pkey, rireki.history_type, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00026'::text) AND ((code.code)::text = (rireki.history_type)::text))) AS history_type_name, rireki.sinseisyozoku, sosiki.syozoku_name, sosiki.syozoku_fullname AS sosiki_fullname, rireki.sinseisya, rireki.sinsei_date, rireki.syonin_kbn, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00008'::text) AND ((code.code)::text = (rireki.syonin_kbn)::text))) AS syonin_kbn_name, rireki.syoninsya, rireki.syonin_date, sosiki.sosiki_sortkey, rireki.email_ad, rireki.shinsei_no FROM (rireki LEFT JOIN sosiki ON (((rireki.sinseisyozoku)::text = (sosiki.sosiki_pkey)::text)));


ALTER TABLE public.rireki_detail OWNER TO shisanadmin;

--
-- Name: softrireki; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE softrireki (
    softhistory_pkey serial NOT NULL,
    soft_pkey integer,
    hard_pkey integer,
    licence_pkey integer,
    bikou text,
    install_date date,
    uninstall_date date,
    version smallint NOT NULL,
    memo text,
    downgrade character varying(6)
);


ALTER TABLE public.softrireki OWNER TO shisanadmin;

--
-- Name: TABLE softrireki; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE softrireki IS 'ソフトウェア台帳履歴';


--
-- Name: rireki_detail_list; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW rireki_detail_list AS
    (((SELECT DISTINCT ON (rireki.shinsei_no) rireki.history_pkey, rireki.history_type, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00026'::text) AND ((code.code)::text = (rireki.history_type)::text))) AS history_type_name, rireki.sinseisyozoku, sosiki.syozoku_name, sosiki.syozoku_fullname AS sosiki_fullname, rireki.sinseisya, rireki.sinsei_date, rireki.syonin_kbn, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00008'::text) AND ((code.code)::text = (rireki.syonin_kbn)::text))) AS syonin_kbn_name, rireki.syoninsya, rireki.syonin_date, sosiki.sosiki_sortkey, rireki.email_ad, ('hw-'::text || (rireki.shinsei_no)::text) AS shinsei_no, hardrireki.hard_kanrino AS kanri_no FROM ((rireki LEFT JOIN sosiki ON (((rireki.sinseisyozoku)::text = (sosiki.sosiki_pkey)::text))) LEFT JOIN hardrireki ON ((rireki.history_pkey = hardrireki.hardhistory_pkey))) WHERE ((rireki.history_type)::text = 'd001'::text) ORDER BY rireki.shinsei_no) UNION (SELECT DISTINCT ON (rireki.shinsei_no) rireki.history_pkey, rireki.history_type, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00026'::text) AND ((code.code)::text = (rireki.history_type)::text))) AS history_type_name, rireki.sinseisyozoku, sosiki.syozoku_name, sosiki.syozoku_fullname AS sosiki_fullname, rireki.sinseisya, rireki.sinsei_date, rireki.syonin_kbn, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00008'::text) AND ((code.code)::text = (rireki.syonin_kbn)::text))) AS syonin_kbn_name, rireki.syoninsya, rireki.syonin_date, sosiki.sosiki_sortkey, rireki.email_ad, ('sw-'::text || (rireki.shinsei_no)::text) AS shinsei_no, (softrireki.soft_pkey)::character varying(255) AS kanri_no FROM ((rireki LEFT JOIN sosiki ON (((rireki.sinseisyozoku)::text = (sosiki.sosiki_pkey)::text))) LEFT JOIN softrireki ON ((rireki.history_pkey = softrireki.softhistory_pkey))) WHERE ((rireki.history_type)::text = 'd002'::text) ORDER BY rireki.shinsei_no)) UNION (SELECT DISTINCT ON (rireki.shinsei_no) rireki.history_pkey, rireki.history_type, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00026'::text) AND ((code.code)::text = (rireki.history_type)::text))) AS history_type_name, rireki.sinseisyozoku, sosiki.syozoku_name, sosiki.syozoku_fullname AS sosiki_fullname, rireki.sinseisya, rireki.sinsei_date, rireki.syonin_kbn, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00008'::text) AND ((code.code)::text = (rireki.syonin_kbn)::text))) AS syonin_kbn_name, rireki.syoninsya, rireki.syonin_date, sosiki.sosiki_sortkey, rireki.email_ad, ('li-'::text || (rireki.shinsei_no)::text) AS shinsei_no, licencerireki.licence_kanrino AS kanri_no FROM ((rireki LEFT JOIN sosiki ON (((rireki.sinseisyozoku)::text = (sosiki.sosiki_pkey)::text))) LEFT JOIN licencerireki ON ((rireki.history_pkey = licencerireki.licencehistory_pkey))) WHERE ((rireki.history_type)::text = 'd003'::text) ORDER BY rireki.shinsei_no)) UNION (SELECT DISTINCT ON (rireki.shinsei_no) rireki.history_pkey, rireki.history_type, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00026'::text) AND ((code.code)::text = (rireki.history_type)::text))) AS history_type_name, rireki.sinseisyozoku, sosiki.syozoku_name, sosiki.syozoku_fullname AS sosiki_fullname, rireki.sinseisya, rireki.sinsei_date, rireki.syonin_kbn, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00008'::text) AND ((code.code)::text = (rireki.syonin_kbn)::text))) AS syonin_kbn_name, rireki.syoninsya, rireki.syonin_date, sosiki.sosiki_sortkey, rireki.email_ad, ('ll-'::text || (rireki.shinsei_no)::text) AS shinsei_no, (licencelistrireki.licencelist_pkey)::character varying(255) AS kanri_no FROM ((rireki LEFT JOIN sosiki ON (((rireki.sinseisyozoku)::text = (sosiki.sosiki_pkey)::text))) LEFT JOIN licencelistrireki ON ((rireki.history_pkey = licencelistrireki.licencehistory_pkey))) WHERE ((rireki.history_type)::text = 'd004'::text) ORDER BY rireki.shinsei_no);


ALTER TABLE public.rireki_detail_list OWNER TO shisanadmin;

--
-- Name: soft_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW soft_detail AS
    SELECT soft.soft_pkey, hard.sosiki_pkey, sosiki.syozoku_name AS sosiki_name, sosiki.syozoku_fullname AS sosiki_fullname, soft.hard_pkey, hard.hard_kanrino, hard.use_name, soft.licence_pkey, licence.licence_kanrino, licence.licencelist_pkey, licencelist.soft_name, licencelist.edition, licencelist.licence_keitai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00005'::text) AND ((code.code)::text = (licencelist.licence_keitai)::text))) AS licence_keitai_name, licencelist.hard_kotei, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelist.hard_kotei)::text))) AS hard_kotei_name, licencelist.upgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (licencelist.upgrade)::text))) AS upgrade_name, soft.downgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (soft.downgrade)::text))) AS downgrade_name, soft.bikou, soft.install_date AS tyoutatu_date, soft.uninstall_date AS haiki_date, soft.memo, soft.version, soft.newkbn, hard.haiki_date AS hard_haiki_date, COALESCE(sosiki.sosiki_sortkey, 0) AS sosiki_sortkey, licence.sosiki_pkey AS licence_sosiki_pkey FROM ((((soft LEFT JOIN hard ON ((soft.hard_pkey = hard.hard_pkey))) LEFT JOIN licence ON ((soft.licence_pkey = licence.licence_pkey))) LEFT JOIN licencelist ON ((licence.licencelist_pkey = licencelist.licencelist_pkey))) LEFT JOIN sosiki ON ((hard.sosiki_pkey = sosiki.sosiki_pkey)));


ALTER TABLE public.soft_detail OWNER TO shisanadmin;

--
-- Name: soft_rireki_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW soft_rireki_detail AS
    SELECT softrireki.softhistory_pkey, softrireki.soft_pkey, softrireki.hard_pkey, hard.hard_kanrino, hard.use_name, softrireki.licence_pkey, licence.licence_kanrino, licence.licencelist_pkey, licencelist.soft_name, licencelist.edition, licencelist.licence_keitai, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00005'::text) AND ((code.code)::text = (licencelist.licence_keitai)::text))) AS licence_keitai_name, softrireki.downgrade, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00004'::text) AND ((code.code)::text = (softrireki.downgrade)::text))) AS downgrade_name, softrireki.bikou, softrireki.install_date AS tyoutatu_date, softrireki.uninstall_date AS haiki_date, softrireki.memo, softrireki.version, rireki.sinseisyozoku, rireki.sinsei_date, rireki.sinseisya, rireki.syonin_kbn, rireki.syonin_date, rireki.syoninsya, rireki.email_ad, rireki.shinsei_no FROM ((((softrireki LEFT JOIN rireki ON (((softrireki.softhistory_pkey = rireki.history_pkey) AND ((rireki.history_type)::text = 'd002'::text)))) LEFT JOIN hard ON ((softrireki.hard_pkey = hard.hard_pkey))) LEFT JOIN licence ON ((softrireki.licence_pkey = licence.licence_pkey))) LEFT JOIN licencelist ON ((licence.licencelist_pkey = licencelist.licencelist_pkey)));


ALTER TABLE public.soft_rireki_detail OWNER TO shisanadmin;

--
-- Name: sogo_msg; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE sogo_msg (
    sogo_pkey character varying(4) NOT NULL,
    sogo_msg text,
    sogo_spt text,
    sogo_mail text
);


ALTER TABLE public.sogo_msg OWNER TO shisanadmin;

--
-- Name: TABLE sogo_msg; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE sogo_msg IS '齟齬メッセージ';


--
-- Name: sogo_type; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE sogo_type (
    sogo_pkey character varying(4) NOT NULL,
    sogo_type smallint NOT NULL
);


ALTER TABLE public.sogo_type OWNER TO shisanadmin;

--
-- Name: TABLE sogo_type; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE sogo_type IS '齟齬種別（1:台帳齟齬　2:インベントリ齟齬）';


--
-- Name: sogo_view; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE sogo_view (
    sogochk_pkey integer NOT NULL,
    sosiki_sortkey smallint,
    sosiki_fullname character varying(550),
    check_date date,
    err_pkey character varying(4),
    inventory text,
    hardware text,
    software text,
    licence text,
    licence_list text,
    message text,
    support text,
    sosiki_pkey1 integer,
    sosiki_pkey2 integer
);


ALTER TABLE public.sogo_view OWNER TO shisanadmin;

--
-- Name: TABLE sogo_view; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE sogo_view IS '齟齬表示用';


--
-- Name: sogocheck; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE sogocheck (
    sogochk_pkey serial NOT NULL,
    sogochk_type smallint NOT NULL,
    err_pkey character varying(4),
    inv_list character varying(255),
    inv_detail character varying(255),
    hard_hardno character varying(255),
    soft_hardno character varying(255),
    soft_licenceno character varying(255),
    soft_program character varying(255),
    licence_licenceno character varying(255),
    licence_program character varying(255),
    licencelist_program character varying(255),
    sosiki1 integer,
    sosiki2 integer,
    sysyem_user boolean,
    start_date timestamp with time zone,
    check_date timestamp with time zone,
    msg_val1 character varying(255),
    msg_val2 character varying(255),
    msg_val3 character varying(255),
    msg_val4 character varying(255),
    msg_val5 character varying(255),
    msg_val6 character varying(255),
    msg_val7 character varying(255),
    spt_val1 character varying(255),
    spt_val2 character varying(255),
    spt_val3 character varying(255),
    spt_val4 character varying(255),
    spt_val5 character varying(255),
    mail_val1 character varying(255),
    mail_val2 character varying(255),
    mail_val3 character varying(255),
    mail_val4 character varying(255),
    mail_val5 character varying(255),
    mail_val6 character varying(255),
    mail_val7 character varying(255)
);


ALTER TABLE public.sogocheck OWNER TO shisanadmin;

--
-- Name: TABLE sogocheck; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE sogocheck IS '齟齬チェック';


--
-- Name: sogocheck_tmp; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE sogocheck_tmp (
    sogochk_pkey serial NOT NULL,
    sogochk_type smallint NOT NULL,
    err_pkey character varying(4),
    inv_list character varying(255),
    inv_detail character varying(255),
    hard_hardno character varying(255),
    soft_hardno character varying(255),
    soft_licenceno character varying(255),
    soft_program character varying(255),
    licence_licenceno character varying(255),
    licence_program character varying(255),
    licencelist_program character varying(255),
    sosiki1 integer,
    sosiki2 integer,
    sysyem_user boolean,
    start_date timestamp with time zone,
    check_date timestamp with time zone,
    msg_val1 character varying(255),
    msg_val2 character varying(255),
    msg_val3 character varying(255),
    msg_val4 character varying(255),
    msg_val5 character varying(255),
    msg_val6 character varying(255),
    msg_val7 character varying(255),
    spt_val1 character varying(255),
    spt_val2 character varying(255),
    spt_val3 character varying(255),
    spt_val4 character varying(255),
    spt_val5 character varying(255),
    mail_val1 character varying(255),
    mail_val2 character varying(255),
    mail_val3 character varying(255),
    mail_val4 character varying(255),
    mail_val5 character varying(255),
    mail_val6 character varying(255),
    mail_val7 character varying(255)
);


ALTER TABLE public.sogocheck_tmp OWNER TO shisanadmin;

--
-- Name: sosiki_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW sosiki_detail AS
    SELECT mtr.sosiki_pkey, mtr.sosiki_sortkey, mtr.syozoku_name, mtr.yukou, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00007'::text) AND ((code.code)::text = (mtr.yukou)::text))) AS yukou_name, mtr.sosiki_onpkey, slv.syozoku_name AS s_syozoku_name, slv.syozoku_fullname AS s_syozoku_fullname, COALESCE(slv.sosiki_sortkey, 0) AS s_sosiki_sortkey FROM (sosiki mtr LEFT JOIN sosiki slv ON ((mtr.sosiki_onpkey = slv.sosiki_pkey)));


ALTER TABLE public.sosiki_detail OWNER TO shisanadmin;

--
-- Name: sosiki_path; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE sosiki_path (
    sosiki_pkey integer NOT NULL,
    parent_sosiki text,
    child_sosiki text
);


ALTER TABLE public.sosiki_path OWNER TO shisanadmin;

--
-- Name: TABLE sosiki_path; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE sosiki_path IS '組織パス';


--
-- Name: tmp_hard; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_hard (
    hard_pkey integer,
    sosiki_pkey integer,
    hard_kanrino character varying(255),
    soft_installdel character varying(6),
    use_name character varying(80),
    tyoutatu text,
    bikou text,
    tyoutatu_date date,
    haiki_date date,
    version smallint,
    newkbn smallint,
    price integer,
    "location" character varying(255),
    memo text
);


ALTER TABLE public.tmp_hard OWNER TO shisanadmin;

--
-- Name: tmp_hard_detail; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_hard_detail (
    hard_pkey integer,
    inventory_pkey integer,
    sosiki_pkey integer,
    sosiki_name character varying(80),
    sosiki_fullname character varying(255),
    hard_kanrino character varying(255),
    computername character varying(255),
    ipaddress character varying(15),
    use_name character varying(80),
    soft_qty bigint,
    soft_installdel character varying(6),
    soft_installdel_name character varying,
    machinevendor character varying(255),
    machinename character varying(255),
    price integer,
    tyoutatu text,
    "location" character varying(255),
    bikou text,
    tyoutatu_date date,
    haiki_date date,
    memo text,
    version smallint,
    newkbn smallint,
    sosiki_sortkey integer
);


ALTER TABLE public.tmp_hard_detail OWNER TO shisanadmin;

--
-- Name: tmp_inventory; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_inventory (
    inventory_pkey integer,
    collectsource character varying(100),
    idkey character varying(255),
    invtraprecvdate timestamp with time zone,
    hardwareno character varying(255),
    group1 character varying(255),
    jyotai character varying(6),
    hikaku character varying(6),
    hsyubetu character varying(6),
    macaddress character varying(12),
    ipaddress character varying(15),
    subnetmask character varying(15),
    defaultgateway character varying(15),
    dnsserver character varying(255),
    secondarydns character varying(255),
    computername character varying(255),
    domainname character varying(255),
    workgroup character varying(255),
    userid character varying(255),
    hyoujimei character varying(255),
    yakusyoku character varying(255),
    syozoku character varying(255),
    machinevendor character varying(255),
    machinename character varying(255),
    cpuname character varying(255),
    memorysize character varying(255),
    osversion character varying(255),
    windowsservicepack character varying(255),
    ieversion character varying(255),
    virussoftname character varying(100),
    enginever character varying(20),
    patternver character varying(255),
    misiyou1 character varying(255),
    misiyou2 character varying(255),
    misiyou3 character varying(255),
    mukou_date date,
    toolversion character varying(255),
    bikou text,
    memo text
);


ALTER TABLE public.tmp_inventory OWNER TO shisanadmin;

--
-- Name: tmp_inventory_detail; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_inventory_detail (
    inventory_pkey integer,
    collectsource character varying(100),
    idkey character varying(255),
    invtraprecvdate timestamp with time zone,
    hardwareno character varying(255),
    group1 character varying(255),
    jyotai character varying(6),
    jyotai_name character varying,
    hikaku character varying(6),
    hikaku_name character varying,
    hsyubetu character varying(6),
    hsyubetu_name character varying,
    macaddress character varying(12),
    ipaddress character varying(15),
    subnetmask character varying(15),
    defaultgateway character varying(15),
    dnsserver character varying(255),
    secondarydns character varying(255),
    computername character varying(255),
    domainname character varying(255),
    workgroup character varying(255),
    userid character varying(255),
    hyoujimei character varying(255),
    yakusyoku character varying(255),
    syozoku character varying(255),
    machinevendor character varying(255),
    machinename character varying(255),
    cpuname character varying(255),
    memorysize character varying(255),
    osversion character varying(255),
    windowsservicepack character varying(255),
    ieversion character varying(255),
    virussoftname character varying(100),
    enginever character varying(20),
    patternver character varying(255),
    misiyou1 character varying(255),
    misiyou2 character varying(255),
    misiyou3 character varying(255),
    mukou_date date,
    program_add_del text,
    bikou text,
    memo text,
    toolversion character varying(255)
);


ALTER TABLE public.tmp_inventory_detail OWNER TO shisanadmin;

--
-- Name: tmp_inventorysoft; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_inventorysoft (
    hardwareno character varying(255),
    insapname character varying(255),
    insapno bigint
);


ALTER TABLE public.tmp_inventorysoft OWNER TO shisanadmin;

--
-- Name: tmp_licence; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_licence (
    licence_pkey integer,
    sosiki_pkey integer,
    licencelist_pkey integer,
    licence_kanrino character varying(255),
    install_su integer,
    hard_pkey integer,
    licence_pkey2 text,
    licence_no text,
    tyoutatu text,
    hokan_baitai text,
    hokan_basyo text,
    bikou text,
    tyoutatu_date date,
    haiki_date date,
    version smallint,
    newkbn smallint,
    kanri_sosiki_pkey integer,
    price character varying(100),
    use_limit_date date,
    memo text
);


ALTER TABLE public.tmp_licence OWNER TO shisanadmin;

--
-- Name: tmp_licence_detail; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_licence_detail (
    licence_pkey integer,
    kanri_sosiki_pkey integer,
    kanri_sosiki_name character varying(80),
    kanri_sosiki_fullname character varying(255),
    kanri_sosiki_sortkey integer,
    sosiki_pkey integer,
    sosiki_name character varying(80),
    sosiki_fullname character varying(255),
    sosiki_sortkey integer,
    licence_kanrino character varying(255),
    licencelist_pkey integer,
    soft_name character varying(255),
    edition character varying(100),
    disabled character varying(6),
    licence_keitai character varying(6),
    licence_keitai_name character varying,
    hard_kotei character varying(6),
    hard_kotei_name character varying,
    hard_pkey integer,
    hard_kanrino character varying(255),
    upgrade character varying(6),
    upgrade_name character varying,
    licence_pkey2 text,
    up_licence_kanrino text,
    brand character varying(50),
    hold_qty integer,
    install_su integer,
    install_qty bigint,
    licence_no text,
    price character varying(100),
    tyoutatu text,
    tokusitu_useproposal text,
    useproposal_youken text,
    hokan_baitai text,
    hokan_basyo text,
    program_add_del text,
    program_add_del_down text,
    bikou text,
    tyoutatu_date date,
    use_limit_date date,
    haiki_date date,
    memo text,
    version smallint,
    newkbn smallint
);


ALTER TABLE public.tmp_licence_detail OWNER TO shisanadmin;

--
-- Name: tmp_licencelist; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_licencelist (
    licencelist_pkey integer,
    soft_name character varying(255),
    licence_keitai character varying(6),
    brand character varying(50),
    hard_kotei character varying(6),
    upgrade character varying(6),
    useproposal_kakunin character varying(6),
    tokusitu_useproposal text,
    useproposal_youken text,
    bikou text,
    upd_date date,
    upd_name character varying(80),
    yukou character varying(6),
    version smallint,
    upd_syozoku integer,
    newkbn smallint,
    edition character varying(100),
    disabled character varying(6),
    memo text
);


ALTER TABLE public.tmp_licencelist OWNER TO shisanadmin;

--
-- Name: tmp_licencelist_detail; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_licencelist_detail (
    licencelist_pkey integer,
    soft_name character varying(255),
    edition character varying(100),
    licence_keitai character varying(6),
    licence_keitai_name character varying,
    hard_kotei character varying(6),
    hard_kotei_name character varying,
    upgrade character varying(6),
    upgrade_name character varying,
    brand character varying(50),
    disabled character varying(6),
    disabled_name character varying,
    program_add_del text,
    program_add_del_down text,
    licence_qty bigint,
    soft_qty bigint,
    tokusitu_useproposal text,
    useproposal_youken text,
    bikou text,
    upd_syozoku integer,
    upd_name character varying(80),
    upd_date date,
    useproposal_kakunin character varying(6),
    useproposal_kakunin_name character varying,
    yukou character varying(6),
    yukou_name character varying,
    memo text,
    version smallint,
    newkbn smallint,
    sosiki_sortkey integer,
    sosiki_name character varying(80),
    sosiki_fullname character varying(255)
);


ALTER TABLE public.tmp_licencelist_detail OWNER TO shisanadmin;

--
-- Name: tmp_licencelistprogram; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_licencelistprogram (
    licencelist_pkey integer,
    program_add_del character varying(255)
);


ALTER TABLE public.tmp_licencelistprogram OWNER TO shisanadmin;

--
-- Name: tmp_licencelistprogram_down; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_licencelistprogram_down (
    licencelist_pkey integer,
    program_add_del character varying(255)
);


ALTER TABLE public.tmp_licencelistprogram_down OWNER TO shisanadmin;

--
-- Name: tmp_soft; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_soft (
    soft_pkey integer,
    hard_pkey integer,
    licence_pkey integer,
    bikou text,
    install_date date,
    uninstall_date date,
    version smallint,
    newkbn smallint,
    downgrade character varying(6),
    memo text
);


ALTER TABLE public.tmp_soft OWNER TO shisanadmin;

--
-- Name: tmp_soft_detail; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_soft_detail (
    soft_pkey integer,
    sosiki_pkey integer,
    sosiki_name character varying(80),
    sosiki_fullname character varying(255),
    hard_pkey integer,
    hard_kanrino character varying(255),
    use_name character varying(80),
    licence_pkey integer,
    licence_kanrino character varying(255),
    licencelist_pkey integer,
    soft_name character varying(255),
    edition character varying(100),
    licence_keitai character varying(6),
    licence_keitai_name character varying,
    hard_kotei character varying(6),
    hard_kotei_name character varying,
    upgrade character varying(6),
    upgrade_name character varying,
    downgrade character varying(6),
    downgrade_name character varying,
    bikou text,
    tyoutatu_date date,
    haiki_date date,
    memo text,
    version smallint,
    newkbn smallint,
    hard_haiki_date date,
    sosiki_sortkey integer,
    licence_sosiki_pkey integer
);


ALTER TABLE public.tmp_soft_detail OWNER TO shisanadmin;

--
-- Name: tmp_sosiki_detail; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE tmp_sosiki_detail (
    sosiki_pkey integer,
    sosiki_sortkey smallint,
    syozoku_name character varying(80),
    yukou character varying(6),
    yukou_name character varying,
    sosiki_onpkey integer,
    s_syozoku_name character varying(80),
    s_syozoku_fullname character varying(255),
    s_sosiki_sortkey integer
);


ALTER TABLE public.tmp_sosiki_detail OWNER TO shisanadmin;

--
-- Name: user; Type: TABLE; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE TABLE "user" (
    user_pkey serial NOT NULL,
    sosiki_pkey integer,
    user_id character varying(20) NOT NULL,
    user_name character varying(80),
    auth character varying(20) NOT NULL,
    email_ad text,
    pass character varying(20) NOT NULL,
    kessai text
);


ALTER TABLE public."user" OWNER TO shisanadmin;

--
-- Name: TABLE "user"; Type: COMMENT; Schema: public; Owner: shisanadmin
--

COMMENT ON TABLE "user" IS 'ユーザー';


--
-- Name: user_detail; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW user_detail AS
    SELECT "user".sosiki_pkey, "user".auth, "user".pass, "user".kessai, "user".user_id, "user".email_ad, "user".user_name, "user".user_pkey, COALESCE(sosiki.sosiki_sortkey, 0) AS sosiki_sortkey, sosiki.syozoku_name AS sosiki_name, sosiki.syozoku_fullname AS sosiki_fullname, (SELECT code.code_name FROM code WHERE (((code.code_bunrui)::text = '00023'::text) AND ((code.code)::text = ("user".auth)::text))) AS auth_name FROM (("user" LEFT JOIN sosiki ON (("user".sosiki_pkey = sosiki.sosiki_pkey))) LEFT JOIN mt_auth ON ((("user".auth)::text = (mt_auth.authority_id)::text)));


ALTER TABLE public.user_detail OWNER TO shisanadmin;

--
-- Name: ztest_sogo_count; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW ztest_sogo_count AS
    SELECT sosiki.sosiki_pkey, sosiki.syozoku_name, count(sosiki.sosiki_pkey) AS count FROM (sogocheck LEFT JOIN sosiki ON ((((sogocheck.sosiki2)::text = (sosiki.sosiki_pkey)::text) OR ((sogocheck.sosiki1)::text = (sosiki.sosiki_pkey)::text)))) GROUP BY sosiki.sosiki_pkey, sosiki.sosiki_sortkey, sosiki.syozoku_name ORDER BY sosiki.sosiki_sortkey;


ALTER TABLE public.ztest_sogo_count OWNER TO shisanadmin;

--
-- Name: ztest_sogo_count2; Type: VIEW; Schema: public; Owner: shisanadmin
--

CREATE VIEW ztest_sogo_count2 AS
    SELECT sogocheck_tmp.err_pkey, count(sogocheck_tmp.err_pkey) AS count FROM (sogo_type LEFT JOIN sogocheck_tmp ON (((sogo_type.sogo_pkey)::text = (sogocheck_tmp.err_pkey)::text))) GROUP BY sogocheck_tmp.err_pkey ORDER BY sogocheck_tmp.err_pkey;


ALTER TABLE public.ztest_sogo_count2 OWNER TO shisanadmin;

--
-- Name: bat_log_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY bat_log
    ADD CONSTRAINT bat_log_pkey PRIMARY KEY (bat_pkey);


--
-- Name: code_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY code
    ADD CONSTRAINT code_pkey PRIMARY KEY (code_bunrui, code);


--
-- Name: codebunrui_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY codebunrui
    ADD CONSTRAINT codebunrui_pkey PRIMARY KEY (code_bunrui);


--
-- Name: control_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY control
    ADD CONSTRAINT control_pkey PRIMARY KEY (control_id);


--
-- Name: errmsg_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY errmsg
    ADD CONSTRAINT errmsg_pkey PRIMARY KEY (err_pkey);


--
-- Name: hard_kanrino_numbering_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY hard_kanrino_numbering
    ADD CONSTRAINT hard_kanrino_numbering_pkey PRIMARY KEY (id);


--
-- Name: hard_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY hard
    ADD CONSTRAINT hard_pkey PRIMARY KEY (hard_pkey);


--
-- Name: hardrireki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY hardrireki
    ADD CONSTRAINT hardrireki_pkey PRIMARY KEY (hardhistory_pkey);


--
-- Name: hold_licence_qry_rireki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY hold_licence_qry_rireki
    ADD CONSTRAINT hold_licence_qry_rireki_pkey PRIMARY KEY (licencehistory_pkey);


--
-- Name: import_moniter_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY import_moniter
    ADD CONSTRAINT import_moniter_pkey PRIMARY KEY (import_pkey);


--
-- Name: inventory_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY inventory
    ADD CONSTRAINT inventory_pkey PRIMARY KEY (inventory_pkey);


--
-- Name: inventorydate_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY inventorydate
    ADD CONSTRAINT inventorydate_pkey PRIMARY KEY (invbunrui);


--
-- Name: inventorysoft_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY inventorysoft
    ADD CONSTRAINT inventorysoft_pkey PRIMARY KEY (insapno);


--
-- Name: licence_kanrino; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY hold_licence_qty
    ADD CONSTRAINT licence_kanrino PRIMARY KEY (licence_kanrino);


--
-- Name: licence_kanrino_numbering_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licence_kanrino_numbering
    ADD CONSTRAINT licence_kanrino_numbering_pkey PRIMARY KEY (id);


--
-- Name: licence_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licence
    ADD CONSTRAINT licence_pkey PRIMARY KEY (licence_pkey);


--
-- Name: licencelist_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licencelist
    ADD CONSTRAINT licencelist_pkey PRIMARY KEY (licencelist_pkey);


--
-- Name: licencelistprogram_d_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licencelistprogram_down
    ADD CONSTRAINT licencelistprogram_d_pkey PRIMARY KEY (licencelist_pkey, program_add_del);


--
-- Name: licencelistprogram_d_rireki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licencelistprogram_down_rireki
    ADD CONSTRAINT licencelistprogram_d_rireki_pkey PRIMARY KEY (licencehistory_pkey, program_add_del);


--
-- Name: licencelistprogram_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licencelistprogram
    ADD CONSTRAINT licencelistprogram_pkey PRIMARY KEY (licencelist_pkey, program_add_del);


--
-- Name: licencelistprogramrireki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licencelistprogramrireki
    ADD CONSTRAINT licencelistprogramrireki_pkey PRIMARY KEY (licencehistory_pkey, program_add_del);


--
-- Name: licencelistrireki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licencelistrireki
    ADD CONSTRAINT licencelistrireki_pkey PRIMARY KEY (licencehistory_pkey);


--
-- Name: licencerireki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY licencerireki
    ADD CONSTRAINT licencerireki_pkey PRIMARY KEY (licencehistory_pkey);


--
-- Name: login_key_user_id_key; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY login_key
    ADD CONSTRAINT login_key_user_id_key UNIQUE (user_id, "key");


--
-- Name: message_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY message
    ADD CONSTRAINT message_pkey PRIMARY KEY (msg_pkey);


--
-- Name: mt_auth_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY mt_auth
    ADD CONSTRAINT mt_auth_pkey PRIMARY KEY (authority_id);


--
-- Name: mt_menu_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY mt_menu
    ADD CONSTRAINT mt_menu_pkey PRIMARY KEY (menu_code);


--
-- Name: rireki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY rireki
    ADD CONSTRAINT rireki_pkey PRIMARY KEY (history_pkey, history_type);


--
-- Name: soft_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY soft
    ADD CONSTRAINT soft_pkey PRIMARY KEY (soft_pkey);


--
-- Name: softrireki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY softrireki
    ADD CONSTRAINT softrireki_pkey PRIMARY KEY (softhistory_pkey);


--
-- Name: sogo_msg_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY sogo_msg
    ADD CONSTRAINT sogo_msg_pkey PRIMARY KEY (sogo_pkey);


--
-- Name: sogo_type_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY sogo_type
    ADD CONSTRAINT sogo_type_pkey PRIMARY KEY (sogo_pkey);


--
-- Name: sogo_view_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY sogo_view
    ADD CONSTRAINT sogo_view_pkey PRIMARY KEY (sogochk_pkey);


--
-- Name: sogocheck_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY sogocheck
    ADD CONSTRAINT sogocheck_pkey PRIMARY KEY (sogochk_pkey);


--
-- Name: sogochktest_pket; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY sogocheck_tmp
    ADD CONSTRAINT sogochktest_pket PRIMARY KEY (sogochk_pkey);


--
-- Name: sosiki_path_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY sosiki_path
    ADD CONSTRAINT sosiki_path_pkey PRIMARY KEY (sosiki_pkey);


--
-- Name: sosiki_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY sosiki
    ADD CONSTRAINT sosiki_pkey PRIMARY KEY (sosiki_pkey);


--
-- Name: user_pkey; Type: CONSTRAINT; Schema: public; Owner: shisanadmin; Tablespace: 
--

ALTER TABLE ONLY "user"
    ADD CONSTRAINT user_pkey PRIMARY KEY (user_pkey);


--
-- Name: auth; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX auth ON "user" USING btree (auth);


--
-- Name: code_bunrui; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX code_bunrui ON code USING btree (code_bunrui);


--
-- Name: code_bunruimei; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX code_bunruimei ON codebunrui USING btree (code_bunruimei);


--
-- Name: code_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX code_name ON code USING btree (code_name);


--
-- Name: code_sort; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX code_sort ON code USING btree (code_sort);


--
-- Name: collectsorce; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX collectsorce ON inventory USING btree (collectsource);


--
-- Name: email_ad; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX email_ad ON rireki USING btree (email_ad);


--
-- Name: expire; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX expire ON login_key USING btree (expire);


--
-- Name: group1; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX group1 ON inventory USING btree (group1);


--
-- Name: h_hard_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX h_hard_kanrino ON hard USING btree (hard_kanrino);


--
-- Name: h_location; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX h_location ON hard USING btree ("location");


--
-- Name: h_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX h_memo ON hard USING btree (memo);


--
-- Name: h_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX h_newkbn ON hard USING btree (newkbn);


--
-- Name: h_price; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX h_price ON hard USING btree (price);


--
-- Name: h_soft_installdel; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX h_soft_installdel ON hard USING btree (soft_installdel);


--
-- Name: h_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX h_sosiki_pkey ON hard USING btree (sosiki_pkey);


--
-- Name: hard_haiki_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hard_haiki_date ON hard USING btree (haiki_date);


--
-- Name: hardwareno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hardwareno ON inventory USING btree (hardwareno);


--
-- Name: history_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX history_pkey ON rireki USING btree (history_pkey);


--
-- Name: history_type; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX history_type ON rireki USING btree (history_type);


--
-- Name: hr_hard_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hr_hard_kanrino ON hardrireki USING btree (hard_kanrino);


--
-- Name: hr_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hr_hard_pkey ON hardrireki USING btree (hard_pkey);


--
-- Name: hr_location; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hr_location ON hardrireki USING btree ("location");


--
-- Name: hr_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hr_memo ON hardrireki USING btree (memo);


--
-- Name: hr_price; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hr_price ON hardrireki USING btree (price);


--
-- Name: hr_soft_installdel; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hr_soft_installdel ON hardrireki USING btree (soft_installdel);


--
-- Name: hr_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX hr_sosiki_pkey ON hardrireki USING btree (sosiki_pkey);


--
-- Name: idkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX idkey ON inventory USING btree (idkey);


--
-- Name: idx_hash; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX idx_hash ON licence USING btree (hashtext((licence_pkey)::text));


--
-- Name: insapname; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX insapname ON inventorysoft USING btree (insapname);


--
-- Name: install_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX install_date ON soft USING btree (install_date);


--
-- Name: inv_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX inv_bikou ON inventory USING btree (bikou);


--
-- Name: inv_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX inv_memo ON inventory USING btree (memo);


--
-- Name: inv_soft_exempt; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX inv_soft_exempt ON inventorysoft_ext USING btree (inv_soft_exempt);


--
-- Name: inv_soft_reg; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX inv_soft_reg ON inventorysoft_ext USING btree (inv_soft_reg);


--
-- Name: inventory_invtraprecvdate; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX inventory_invtraprecvdate ON inventory USING btree (invtraprecvdate);


--
-- Name: inventory_sogochk_type; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX inventory_sogochk_type ON sogocheck_tmp USING btree (sogochk_type);


--
-- Name: inventorydate_invend; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX inventorydate_invend ON inventorydate USING btree (invend);


--
-- Name: inventorysoft_insapname; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX inventorysoft_insapname ON inventorysoft USING btree (insapname);


--
-- Name: key; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX "key" ON login_key USING btree ("key");


--
-- Name: l_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_bikou ON licence USING btree (bikou);


--
-- Name: l_haiki_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_haiki_date ON licence USING btree (haiki_date);


--
-- Name: l_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_hard_pkey ON licence USING btree (hard_pkey);


--
-- Name: l_hokan_baitai; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_hokan_baitai ON licence USING btree (hokan_baitai);


--
-- Name: l_hokan_basyo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_hokan_basyo ON licence USING btree (hokan_basyo);


--
-- Name: l_install_su; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_install_su ON licence USING btree (install_su);


--
-- Name: l_kanri_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_kanri_sosiki_pkey ON licence USING btree (kanri_sosiki_pkey);


--
-- Name: l_licence_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_licence_kanrino ON licence USING btree (licence_kanrino);


--
-- Name: l_licence_no; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_licence_no ON licence USING btree (licence_no);


--
-- Name: l_licence_pkey2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_licence_pkey2 ON licence USING btree (licence_pkey2);


--
-- Name: l_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_licencelist_pkey ON licence USING btree (licencelist_pkey);


--
-- Name: l_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_memo ON licence USING btree (memo);


--
-- Name: l_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_newkbn ON licence USING btree (newkbn);


--
-- Name: l_price; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_price ON licence USING btree (price);


--
-- Name: l_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_sosiki_pkey ON licence USING btree (sosiki_pkey);


--
-- Name: l_tyoutatu; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_tyoutatu ON licence USING btree (tyoutatu);


--
-- Name: l_tyoutatu_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_tyoutatu_date ON licence USING btree (tyoutatu_date);


--
-- Name: l_use_limit_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX l_use_limit_date ON licence USING btree (use_limit_date);


--
-- Name: ll_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_bikou ON licencelist USING btree (bikou);


--
-- Name: ll_brand; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_brand ON licencelist USING btree (brand);


--
-- Name: ll_disabled; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_disabled ON licencelist USING btree (disabled);


--
-- Name: ll_edition; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_edition ON licencelist USING btree (edition);


--
-- Name: ll_hard_kotei; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_hard_kotei ON licencelist USING btree (hard_kotei);


--
-- Name: ll_licence_keitai; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_licence_keitai ON licencelist USING btree (licence_keitai);


--
-- Name: ll_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_licencelist_pkey ON licencelistrireki USING btree (licencelist_pkey);


--
-- Name: ll_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_memo ON licencelist USING btree (memo);


--
-- Name: ll_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_newkbn ON licencelist USING btree (newkbn);


--
-- Name: ll_soft_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_soft_name ON licencelist USING btree (soft_name);


--
-- Name: ll_upd_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_upd_date ON licencelist USING btree (upd_date);


--
-- Name: ll_upd_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_upd_name ON licencelist USING btree (upd_name);


--
-- Name: ll_upgrade; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_upgrade ON licencelist USING btree (upgrade);


--
-- Name: ll_useproposal_kakunin; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_useproposal_kakunin ON licencelist USING btree (useproposal_kakunin);


--
-- Name: ll_useproposal_youken; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_useproposal_youken ON licencelist USING btree (useproposal_youken);


--
-- Name: ll_yukou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX ll_yukou ON licencelist USING btree (yukou);


--
-- Name: llr_disabled; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX llr_disabled ON licencelistrireki USING btree (disabled);


--
-- Name: llr_edition; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX llr_edition ON licencelistrireki USING btree (edition);


--
-- Name: llr_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX llr_memo ON licencelistrireki USING btree (memo);


--
-- Name: lr_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_hard_pkey ON licencerireki USING btree (hard_pkey);


--
-- Name: lr_kanri_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_kanri_sosiki_pkey ON licencerireki USING btree (kanri_sosiki_pkey);


--
-- Name: lr_licence_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_licence_pkey ON licencerireki USING btree (licence_pkey);


--
-- Name: lr_licence_pkey2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_licence_pkey2 ON licencerireki USING btree (licence_pkey2);


--
-- Name: lr_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_licencelist_pkey ON licencerireki USING btree (licencelist_pkey);


--
-- Name: lr_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_memo ON licencerireki USING btree (memo);


--
-- Name: lr_price; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_price ON licencerireki USING btree (price);


--
-- Name: lr_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_sosiki_pkey ON licencerireki USING btree (sosiki_pkey);


--
-- Name: lr_use_limit_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX lr_use_limit_date ON licencerireki USING btree (use_limit_date);


--
-- Name: macaddress; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX macaddress ON inventory USING btree (macaddress);


--
-- Name: mail_val1; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX mail_val1 ON sogocheck USING btree (mail_val1);


--
-- Name: mail_val2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX mail_val2 ON sogocheck USING btree (mail_val2);


--
-- Name: mail_val3; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX mail_val3 ON sogocheck USING btree (mail_val3);


--
-- Name: mail_val4; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX mail_val4 ON sogocheck USING btree (mail_val4);


--
-- Name: mail_val5; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX mail_val5 ON sogocheck USING btree (mail_val5);


--
-- Name: mail_val6; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX mail_val6 ON sogocheck USING btree (mail_val6);


--
-- Name: mail_val7; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX mail_val7 ON sogocheck USING btree (mail_val7);


--
-- Name: msg_val1; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX msg_val1 ON sogocheck USING btree (msg_val1);


--
-- Name: msg_val2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX msg_val2 ON sogocheck USING btree (msg_val2);


--
-- Name: msg_val3; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX msg_val3 ON sogocheck USING btree (msg_val3);


--
-- Name: msg_val4; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX msg_val4 ON sogocheck USING btree (msg_val4);


--
-- Name: msg_val5; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX msg_val5 ON sogocheck USING btree (msg_val5);


--
-- Name: msg_val6; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX msg_val6 ON sogocheck USING btree (msg_val6);


--
-- Name: msg_val7; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX msg_val7 ON sogocheck USING btree (msg_val7);


--
-- Name: program_add_del; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX program_add_del ON licencelistprogram USING btree (program_add_del);


--
-- Name: program_add_del_d; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX program_add_del_d ON licencelistprogram_down USING btree (program_add_del);


--
-- Name: r_program_add_del; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX r_program_add_del ON licencelistprogramrireki USING btree (program_add_del);


--
-- Name: r_program_add_del_d; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX r_program_add_del_d ON licencelistprogram_down_rireki USING btree (program_add_del);


--
-- Name: s_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX s_bikou ON soft USING btree (bikou);


--
-- Name: s_downgrade; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX s_downgrade ON soft USING btree (downgrade);


--
-- Name: s_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX s_hard_pkey ON soft USING btree (hard_pkey);


--
-- Name: s_hardwareno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX s_hardwareno ON inventorysoft USING btree (hardwareno);


--
-- Name: s_licence_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX s_licence_pkey ON soft USING btree (licence_pkey);


--
-- Name: s_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX s_memo ON soft USING btree (memo);


--
-- Name: s_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX s_newkbn ON soft USING btree (newkbn);


--
-- Name: shisan_no; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX shisan_no ON rireki USING btree (shinsei_no);


--
-- Name: sinsei_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sinsei_date ON rireki USING btree (sinsei_date);


--
-- Name: sinseisya; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sinseisya ON rireki USING btree (sinseisya);


--
-- Name: sinseisyozoku; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sinseisyozoku ON rireki USING btree (sinseisyozoku);


--
-- Name: sogo_check_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_check_date ON sogo_view USING btree (check_date);


--
-- Name: sogo_err_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_err_pkey ON sogo_view USING btree (err_pkey);


--
-- Name: sogo_hard_hardno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_hard_hardno ON sogocheck USING btree (hard_hardno);


--
-- Name: sogo_hardware; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_hardware ON sogo_view USING btree (hardware);


--
-- Name: sogo_inv_detail; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_inv_detail ON sogocheck USING btree (inv_detail);


--
-- Name: sogo_inv_list; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_inv_list ON sogocheck USING btree (inv_list);


--
-- Name: sogo_inventory; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_inventory ON sogo_view USING btree (inventory);


--
-- Name: sogo_licence; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_licence ON sogo_view USING btree (licence);


--
-- Name: sogo_licence_licenceno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_licence_licenceno ON sogocheck USING btree (licence_licenceno);


--
-- Name: sogo_licence_list; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_licence_list ON sogo_view USING btree (licence_list);


--
-- Name: sogo_licence_program; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_licence_program ON sogocheck USING btree (licence_program);


--
-- Name: sogo_licencelist_program; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_licencelist_program ON sogocheck USING btree (licencelist_program);


--
-- Name: sogo_message; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_message ON sogo_view USING btree (message);


--
-- Name: sogo_soft_hardno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_soft_hardno ON sogocheck USING btree (soft_hardno);


--
-- Name: sogo_soft_licenceno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_soft_licenceno ON sogocheck USING btree (soft_licenceno);


--
-- Name: sogo_soft_program; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_soft_program ON sogocheck USING btree (soft_program);


--
-- Name: sogo_software; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_software ON sogo_view USING btree (software);


--
-- Name: sogo_sosiki_fullname; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_sosiki_fullname ON sogo_view USING btree (sosiki_fullname);


--
-- Name: sogo_sosiki_pkey1; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_sosiki_pkey1 ON sogo_view USING btree (sosiki_pkey1);


--
-- Name: sogo_sosiki_pkey2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_sosiki_pkey2 ON sogo_view USING btree (sosiki_pkey2);


--
-- Name: sogo_sosiki_sortkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_sosiki_sortkey ON sogo_view USING btree (sosiki_sortkey);


--
-- Name: sogo_support; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_support ON sogo_view USING btree (support);


--
-- Name: sogo_type_type; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogo_type_type ON sogo_type USING btree (sogo_type);


--
-- Name: sogocheck_sogochk_type; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogocheck_sogochk_type ON sogocheck USING btree (sogochk_type);


--
-- Name: sogocheck_sosiki1; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogocheck_sosiki1 ON sogocheck USING btree (sosiki1);


--
-- Name: sogocheck_sosiki2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogocheck_sosiki2 ON sogocheck USING btree (sosiki2);


--
-- Name: sogocheck_sysyem_user; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sogocheck_sysyem_user ON sogocheck USING btree (sysyem_user);


--
-- Name: sosiki_onkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sosiki_onkey ON sosiki USING btree (sosiki_onpkey);


--
-- Name: sosiki_sortkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sosiki_sortkey ON sosiki USING btree (sosiki_sortkey);


--
-- Name: spt_val1; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX spt_val1 ON sogocheck USING btree (spt_val1);


--
-- Name: spt_val2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX spt_val2 ON sogocheck USING btree (spt_val2);


--
-- Name: spt_val3; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX spt_val3 ON sogocheck USING btree (spt_val3);


--
-- Name: spt_val4; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX spt_val4 ON sogocheck USING btree (spt_val4);


--
-- Name: spt_val5; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX spt_val5 ON sogocheck USING btree (spt_val5);


--
-- Name: sr_downgrade; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sr_downgrade ON softrireki USING btree (downgrade);


--
-- Name: sr_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sr_hard_pkey ON softrireki USING btree (hard_pkey);


--
-- Name: sr_licence_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sr_licence_pkey ON softrireki USING btree (licence_pkey);


--
-- Name: sr_memo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sr_memo ON softrireki USING btree (memo);


--
-- Name: sr_soft_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX sr_soft_pkey ON softrireki USING btree (soft_pkey);


--
-- Name: syonin_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX syonin_date ON rireki USING btree (syonin_date);


--
-- Name: syonin_kbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX syonin_kbn ON rireki USING btree (syonin_kbn);


--
-- Name: syoninsya; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX syoninsya ON rireki USING btree (syoninsya);


--
-- Name: syozoku_fullname; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX syozoku_fullname ON sosiki USING btree (syozoku_fullname);


--
-- Name: syozoku_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX syozoku_name ON sosiki USING btree (syozoku_name);


--
-- Name: tmp_hard_detail_haiki_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_detail_haiki_date ON tmp_hard_detail USING btree (haiki_date);


--
-- Name: tmp_hard_detail_hard_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_detail_hard_kanrino ON tmp_hard_detail USING btree (hard_kanrino);


--
-- Name: tmp_hard_detail_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_detail_hard_pkey ON tmp_hard_detail USING btree (hard_pkey);


--
-- Name: tmp_hard_detail_inventory_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_detail_inventory_pkey ON tmp_hard_detail USING btree (inventory_pkey);


--
-- Name: tmp_hard_detail_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_detail_newkbn ON tmp_hard_detail USING btree (newkbn);


--
-- Name: tmp_hard_detail_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_detail_sosiki_pkey ON tmp_hard_detail USING btree (sosiki_pkey);


--
-- Name: tmp_hard_detail_sosiki_sortkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_detail_sosiki_sortkey ON tmp_hard_detail USING btree (sosiki_sortkey);


--
-- Name: tmp_hard_haiki_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_haiki_date ON tmp_hard USING btree (haiki_date);


--
-- Name: tmp_hard_hard_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_hard_kanrino ON tmp_hard USING btree (hard_kanrino);


--
-- Name: tmp_hard_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_hard_pkey ON tmp_hard USING btree (hard_pkey);


--
-- Name: tmp_hard_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_newkbn ON tmp_hard USING btree (newkbn);


--
-- Name: tmp_hard_soft_installdel; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_soft_installdel ON tmp_hard USING btree (soft_installdel);


--
-- Name: tmp_hard_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_hard_sosiki_pkey ON tmp_hard USING btree (sosiki_pkey);


--
-- Name: tmp_inventory_collectsource; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_collectsource ON tmp_inventory USING btree (collectsource);


--
-- Name: tmp_inventory_detail_collectsource; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_detail_collectsource ON tmp_inventory_detail USING btree (collectsource);


--
-- Name: tmp_inventory_detail_group1; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_detail_group1 ON tmp_inventory_detail USING btree (group1);


--
-- Name: tmp_inventory_detail_hardwareno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_detail_hardwareno ON tmp_inventory_detail USING btree (hardwareno);


--
-- Name: tmp_inventory_detail_idkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_detail_idkey ON tmp_inventory_detail USING btree (idkey);


--
-- Name: tmp_inventory_detail_inventory_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_detail_inventory_pkey ON tmp_inventory_detail USING btree (inventory_pkey);


--
-- Name: tmp_inventory_detail_macaddress; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_detail_macaddress ON tmp_inventory_detail USING btree (macaddress);


--
-- Name: tmp_inventory_detail_userid; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_detail_userid ON tmp_inventory_detail USING btree (userid);


--
-- Name: tmp_inventory_group1; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_group1 ON tmp_inventory USING btree (group1);


--
-- Name: tmp_inventory_hardwareno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_hardwareno ON tmp_inventory USING btree (hardwareno);


--
-- Name: tmp_inventory_idkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_idkey ON tmp_inventory USING btree (idkey);


--
-- Name: tmp_inventory_inventory_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_inventory_pkey ON tmp_inventory USING btree (inventory_pkey);


--
-- Name: tmp_inventory_macaddress; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_macaddress ON tmp_inventory USING btree (macaddress);


--
-- Name: tmp_inventory_userid; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventory_userid ON tmp_inventory USING btree (userid);


--
-- Name: tmp_inventorysoft_hardwareno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventorysoft_hardwareno ON tmp_inventorysoft USING btree (hardwareno);


--
-- Name: tmp_inventorysoft_insapno; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_inventorysoft_insapno ON tmp_inventorysoft USING btree (insapno);


--
-- Name: tmp_licence_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_bikou ON tmp_licence USING btree (bikou);


--
-- Name: tmp_licence_detail_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_bikou ON tmp_licence_detail USING btree (bikou);


--
-- Name: tmp_licence_detail_haiki_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_haiki_date ON tmp_licence_detail USING btree (haiki_date);


--
-- Name: tmp_licence_detail_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_hard_pkey ON tmp_licence_detail USING btree (hard_pkey);


--
-- Name: tmp_licence_detail_hokan_baitai; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_hokan_baitai ON tmp_licence_detail USING btree (hokan_baitai);


--
-- Name: tmp_licence_detail_hokan_basyo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_hokan_basyo ON tmp_licence_detail USING btree (hokan_basyo);


--
-- Name: tmp_licence_detail_install_su; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_install_su ON tmp_licence_detail USING btree (install_su);


--
-- Name: tmp_licence_detail_licence_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_licence_kanrino ON tmp_licence_detail USING btree (licence_kanrino);


--
-- Name: tmp_licence_detail_licence_no; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_licence_no ON tmp_licence_detail USING btree (licence_no);


--
-- Name: tmp_licence_detail_licence_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_licence_pkey ON tmp_licence_detail USING btree (licence_pkey);


--
-- Name: tmp_licence_detail_licence_pkey2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_licence_pkey2 ON tmp_licence_detail USING btree (licence_pkey2);


--
-- Name: tmp_licence_detail_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_licencelist_pkey ON tmp_licence_detail USING btree (licencelist_pkey);


--
-- Name: tmp_licence_detail_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_newkbn ON tmp_licence_detail USING btree (newkbn);


--
-- Name: tmp_licence_detail_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_sosiki_pkey ON tmp_licence_detail USING btree (sosiki_pkey);


--
-- Name: tmp_licence_detail_sosiki_sortkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_sosiki_sortkey ON tmp_licence_detail USING btree (sosiki_sortkey);


--
-- Name: tmp_licence_detail_tyoutatu; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_tyoutatu ON tmp_licence_detail USING btree (tyoutatu);


--
-- Name: tmp_licence_detail_tyoutatu_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_detail_tyoutatu_date ON tmp_licence_detail USING btree (tyoutatu_date);


--
-- Name: tmp_licence_haiki_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_haiki_date ON tmp_licence USING btree (haiki_date);


--
-- Name: tmp_licence_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_hard_pkey ON tmp_licence USING btree (hard_pkey);


--
-- Name: tmp_licence_hokan_baitai; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_hokan_baitai ON tmp_licence USING btree (hokan_baitai);


--
-- Name: tmp_licence_hokan_basyo; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_hokan_basyo ON tmp_licence USING btree (hokan_basyo);


--
-- Name: tmp_licence_install_su; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_install_su ON tmp_licence USING btree (install_su);


--
-- Name: tmp_licence_licence_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_licence_kanrino ON tmp_licence USING btree (licence_kanrino);


--
-- Name: tmp_licence_licence_no; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_licence_no ON tmp_licence USING btree (licence_no);


--
-- Name: tmp_licence_licence_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_licence_pkey ON tmp_licence USING btree (licence_pkey);


--
-- Name: tmp_licence_licence_pkey2; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_licence_pkey2 ON tmp_licence USING btree (licence_pkey2);


--
-- Name: tmp_licence_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_licencelist_pkey ON tmp_licence USING btree (licencelist_pkey);


--
-- Name: tmp_licence_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_newkbn ON tmp_licence USING btree (newkbn);


--
-- Name: tmp_licence_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_sosiki_pkey ON tmp_licence USING btree (sosiki_pkey);


--
-- Name: tmp_licence_tyoutatu; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_tyoutatu ON tmp_licence USING btree (tyoutatu);


--
-- Name: tmp_licence_tyoutatu_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licence_tyoutatu_date ON tmp_licence USING btree (tyoutatu_date);


--
-- Name: tmp_licencelist_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_bikou ON tmp_licencelist USING btree (bikou);


--
-- Name: tmp_licencelist_brand; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_brand ON tmp_licencelist USING btree (brand);


--
-- Name: tmp_licencelist_detail_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_bikou ON tmp_licencelist_detail USING btree (bikou);


--
-- Name: tmp_licencelist_detail_brand; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_brand ON tmp_licencelist_detail USING btree (brand);


--
-- Name: tmp_licencelist_detail_hard_kotei; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_hard_kotei ON tmp_licencelist_detail USING btree (hard_kotei);


--
-- Name: tmp_licencelist_detail_licence_keitai; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_licence_keitai ON tmp_licencelist_detail USING btree (licence_keitai);


--
-- Name: tmp_licencelist_detail_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_licencelist_pkey ON tmp_licencelist_detail USING btree (licencelist_pkey);


--
-- Name: tmp_licencelist_detail_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_newkbn ON tmp_licencelist_detail USING btree (newkbn);


--
-- Name: tmp_licencelist_detail_soft_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_soft_name ON tmp_licencelist_detail USING btree (soft_name);


--
-- Name: tmp_licencelist_detail_sosiki_fullname; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_sosiki_fullname ON tmp_licencelist_detail USING btree (sosiki_fullname);


--
-- Name: tmp_licencelist_detail_upd_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_upd_date ON tmp_licencelist_detail USING btree (upd_date);


--
-- Name: tmp_licencelist_detail_upd_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_upd_name ON tmp_licencelist_detail USING btree (upd_name);


--
-- Name: tmp_licencelist_detail_upd_syozoku; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_upd_syozoku ON tmp_licencelist_detail USING btree (upd_syozoku);


--
-- Name: tmp_licencelist_detail_upgrade; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_upgrade ON tmp_licencelist_detail USING btree (upgrade);


--
-- Name: tmp_licencelist_detail_useproposal_kakunin; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_useproposal_kakunin ON tmp_licencelist_detail USING btree (useproposal_kakunin);


--
-- Name: tmp_licencelist_detail_useproposal_youken; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_useproposal_youken ON tmp_licencelist_detail USING btree (useproposal_youken);


--
-- Name: tmp_licencelist_detail_yukou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_detail_yukou ON tmp_licencelist_detail USING btree (yukou);


--
-- Name: tmp_licencelist_hard_kotei; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_hard_kotei ON tmp_licencelist USING btree (hard_kotei);


--
-- Name: tmp_licencelist_licence_keitai; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_licence_keitai ON tmp_licencelist USING btree (licence_keitai);


--
-- Name: tmp_licencelist_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_licencelist_pkey ON tmp_licencelist USING btree (licencelist_pkey);


--
-- Name: tmp_licencelist_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_newkbn ON tmp_licencelist USING btree (newkbn);


--
-- Name: tmp_licencelist_soft_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_soft_name ON tmp_licencelist USING btree (soft_name);


--
-- Name: tmp_licencelist_upd_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_upd_date ON tmp_licencelist USING btree (upd_date);


--
-- Name: tmp_licencelist_upd_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_upd_name ON tmp_licencelist USING btree (upd_name);


--
-- Name: tmp_licencelist_upd_syozoku; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_upd_syozoku ON tmp_licencelist USING btree (upd_syozoku);


--
-- Name: tmp_licencelist_upgrade; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_upgrade ON tmp_licencelist USING btree (upgrade);


--
-- Name: tmp_licencelist_useproposal_kakunin; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_useproposal_kakunin ON tmp_licencelist USING btree (useproposal_kakunin);


--
-- Name: tmp_licencelist_useproposal_youken; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_useproposal_youken ON tmp_licencelist USING btree (useproposal_youken);


--
-- Name: tmp_licencelist_yukou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelist_yukou ON tmp_licencelist USING btree (yukou);


--
-- Name: tmp_licencelistprogram_down_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelistprogram_down_licencelist_pkey ON tmp_licencelistprogram_down USING btree (licencelist_pkey);


--
-- Name: tmp_licencelistprogram_down_program_add_del; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelistprogram_down_program_add_del ON tmp_licencelistprogram_down USING btree (program_add_del);


--
-- Name: tmp_licencelistprogram_licencelist_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelistprogram_licencelist_pkey ON tmp_licencelistprogram USING btree (licencelist_pkey);


--
-- Name: tmp_licencelistprogram_program_add_del; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_licencelistprogram_program_add_del ON tmp_licencelistprogram USING btree (program_add_del);


--
-- Name: tmp_soft_bikou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_bikou ON tmp_soft USING btree (bikou);


--
-- Name: tmp_soft_detail_hard_haiki_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_hard_haiki_date ON tmp_soft_detail USING btree (hard_haiki_date);


--
-- Name: tmp_soft_detail_hard_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_hard_kanrino ON tmp_soft_detail USING btree (hard_kanrino);


--
-- Name: tmp_soft_detail_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_hard_pkey ON tmp_soft_detail USING btree (hard_pkey);


--
-- Name: tmp_soft_detail_licence_kanrino; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_licence_kanrino ON tmp_soft_detail USING btree (licence_kanrino);


--
-- Name: tmp_soft_detail_licence_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_licence_pkey ON tmp_soft_detail USING btree (licence_pkey);


--
-- Name: tmp_soft_detail_licence_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_licence_sosiki_pkey ON tmp_soft_detail USING btree (licence_sosiki_pkey);


--
-- Name: tmp_soft_detail_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_newkbn ON tmp_soft_detail USING btree (newkbn);


--
-- Name: tmp_soft_detail_soft_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_soft_name ON tmp_soft_detail USING btree (soft_name);


--
-- Name: tmp_soft_detail_soft_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_soft_pkey ON tmp_soft_detail USING btree (soft_pkey);


--
-- Name: tmp_soft_detail_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_sosiki_pkey ON tmp_soft_detail USING btree (sosiki_pkey);


--
-- Name: tmp_soft_detail_sosiki_sortkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_detail_sosiki_sortkey ON tmp_soft_detail USING btree (sosiki_sortkey);


--
-- Name: tmp_soft_downgrade; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_downgrade ON tmp_soft USING btree (downgrade);


--
-- Name: tmp_soft_hard_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_hard_pkey ON tmp_soft USING btree (hard_pkey);


--
-- Name: tmp_soft_install_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_install_date ON tmp_soft USING btree (install_date);


--
-- Name: tmp_soft_licence_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_licence_pkey ON tmp_soft USING btree (licence_pkey);


--
-- Name: tmp_soft_newkbn; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_newkbn ON tmp_soft USING btree (newkbn);


--
-- Name: tmp_soft_soft_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_soft_pkey ON tmp_soft USING btree (install_date);


--
-- Name: tmp_soft_uninstall_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_soft_uninstall_date ON tmp_soft USING btree (uninstall_date);


--
-- Name: tmp_sosiki_detail_s_sosiki_sortkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_sosiki_detail_s_sosiki_sortkey ON tmp_sosiki_detail USING btree (s_sosiki_sortkey);


--
-- Name: tmp_sosiki_detail_sosiki_onpkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_sosiki_detail_sosiki_onpkey ON tmp_sosiki_detail USING btree (sosiki_onpkey);


--
-- Name: tmp_sosiki_detail_sosiki_pkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_sosiki_detail_sosiki_pkey ON tmp_sosiki_detail USING btree (sosiki_pkey);


--
-- Name: tmp_sosiki_detail_sosiki_sortkey; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_sosiki_detail_sosiki_sortkey ON tmp_sosiki_detail USING btree (sosiki_sortkey);


--
-- Name: tmp_sosiki_detail_syozoku_name; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_sosiki_detail_syozoku_name ON tmp_sosiki_detail USING btree (syozoku_name);


--
-- Name: tmp_sosiki_detail_yukou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX tmp_sosiki_detail_yukou ON tmp_sosiki_detail USING btree (yukou);


--
-- Name: uninstall_date; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX uninstall_date ON soft USING btree (uninstall_date);


--
-- Name: upd_syosoku; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX upd_syosoku ON licencelist USING btree (upd_syozoku);


--
-- Name: user_id; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX user_id ON login_key USING btree (user_id);


--
-- Name: userid; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX userid ON inventory USING btree (userid);


--
-- Name: yukou; Type: INDEX; Schema: public; Owner: shisanadmin; Tablespace: 
--

CREATE INDEX yukou ON sosiki USING btree (yukou);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

